/*
 * 
 * Copyright (C) 2002 the xine project
 * Copyright (C) 2002 the ffmpeg project
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Ported to mplayer by Arpi <arpi@thot.banki.hu>
 * Ported to libavcodec by Nick Kurshev <nickols_k@mail.ru>
 *
 */
//#define DEBUG_SVQ1
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "common.h"
#include "avcodec.h"
#include "dsputil.h"
#include "mpegvideo.h"
#include "bswap.h"
#define bit_buffer_t GetBitContext

static inline unsigned int get_bit_cache(GetBitContext *s){
    OPEN_READER(re, s)
    UPDATE_CACHE(re, s)
    return GET_CACHE(re, s);
//    CLOSE_READER(re, s)
}

/* variable length (bit) code */
typedef struct vlc_code_s {
  int16_t	 value	:10,
		 length	:6;
} vlc_code_t;

#define MEDIAN(a,b,c)	(((a < b) != (b >= c)) ? b : (((a < c) != (c > b)) ? c : a))

#define SVQ1_BLOCK_SKIP		0
#define SVQ1_BLOCK_INTER	1
#define SVQ1_BLOCK_INTER_4V	2
#define SVQ1_BLOCK_INTRA	3

/* motion vector (prediction) */
typedef struct svq1_pmv_s {
  int		 x;
  int		 y;
} svq1_pmv_t;

#include "svq1_cb.h"

/* block type, codes 000 .. 1xx */
static vlc_code_t svq1_block_type_table[8] = {
  { SVQ1_BLOCK_INTRA, 3 }, { SVQ1_BLOCK_INTER_4V, 3 },
  { SVQ1_BLOCK_INTER, 2 }, { SVQ1_BLOCK_INTER,    2 },
  { SVQ1_BLOCK_SKIP,  1 }, { SVQ1_BLOCK_SKIP,     1 },
  { SVQ1_BLOCK_SKIP,  1 }, { SVQ1_BLOCK_SKIP,     1 }
};

/* motion vector, codes 0000011 .. 011xxxx */
static vlc_code_t svq1_motion_table_0[61] = {
  { 7, 8 }, { 6, 8 }, { 5, 8 }, { 4, 7 }, { 4, 7 },
  { 3, 5 }, { 3, 5 }, { 3, 5 }, { 3, 5 }, { 3, 5 }, { 3, 5 }, { 3, 5 }, { 3, 5 },
  { 2, 4 }, { 2, 4 }, { 2, 4 }, { 2, 4 }, { 2, 4 }, { 2, 4 }, { 2, 4 }, { 2, 4 },
  { 2, 4 }, { 2, 4 }, { 2, 4 }, { 2, 4 }, { 2, 4 }, { 2, 4 }, { 2, 4 }, { 2, 4 },
  { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 },
  { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 },
  { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 },
  { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }
};

/* motion vector, codes 000000000010 ... 0000010111xx */
static vlc_code_t svq1_motion_table_1[94] = {
  {32, 13}, {31, 13}, {30, 12}, {30, 12}, {29, 12}, {29, 12},
  {28, 12}, {28, 12}, {27, 12}, {27, 12}, {26, 12}, {26, 12}, {25, 12}, {25, 12},
  {24, 11}, {24, 11}, {24, 11}, {24, 11}, {23, 11}, {23, 11}, {23, 11}, {23, 11},
  {22, 11}, {22, 11}, {22, 11}, {22, 11}, {21, 11}, {21, 11}, {21, 11}, {21, 11},
  {20, 11}, {20, 11}, {20, 11}, {20, 11}, {19, 11}, {19, 11}, {19, 11}, {19, 11},
  {18, 11}, {18, 11}, {18, 11}, {18, 11}, {17, 11}, {17, 11}, {17, 11}, {17, 11},
  {16, 11}, {16, 11}, {16, 11}, {16, 11}, {15, 11}, {15, 11}, {15, 11}, {15, 11},
  {14, 11}, {14, 11}, {14, 11}, {14, 11}, {13, 11}, {13, 11}, {13, 11}, {13, 11},
  {12, 11}, {12, 11}, {12, 11}, {12, 11}, {11, 11}, {11, 11}, {11, 11}, {11, 11},
  {10, 10}, {10, 10}, {10, 10}, {10, 10}, {10, 10}, {10, 10}, {10, 10}, {10, 10},
  { 9, 10}, { 9, 10}, { 9, 10}, { 9, 10}, { 9, 10}, { 9, 10}, { 9, 10}, { 9, 10},
  { 8, 10}, { 8, 10}, { 8, 10}, { 8, 10}, { 8, 10}, { 8, 10}, { 8, 10}, { 8, 10},
};

/* inter-coded vector codebook count tables, codes 000000 ... 111111 */
static vlc_code_t svq1_inter_vector_tables[6][64] = {
  /* 4x2 vector, codes 0000xxx ... 11xxxxx */
  { { 6, 4 }, { 6, 4 }, { 6, 4 }, { 6, 4 }, { 5, 4 }, { 5, 4 }, { 5, 4 }, { 5, 4 },
    { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 },
    { 3, 3 }, { 3, 3 }, { 3, 3 }, { 3, 3 }, { 3, 3 }, { 3, 3 }, { 3, 3 }, { 3, 3 },
    { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 },
    { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 },
    { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 },
    {-1, 2 }, {-1, 2 }, {-1, 2 }, {-1, 2 }, {-1, 2 }, {-1, 2 }, {-1, 2 }, {-1, 2 },
    {-1, 2 }, {-1, 2 }, {-1, 2 }, {-1, 2 }, {-1, 2 }, {-1, 2 }, {-1, 2 }, {-1, 2 } },

  /* 4x4 vector, codes 0000xxx ... 11xxxxx */
  { { 6, 4 }, { 6, 4 }, { 6, 4 }, { 6, 4 }, { 5, 4 }, { 5, 4 }, { 5, 4 }, { 5, 4 },
    { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 },
    { 3, 3 }, { 3, 3 }, { 3, 3 }, { 3, 3 }, { 3, 3 }, { 3, 3 }, { 3, 3 }, { 3, 3 },
    { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 },
    { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 },
    { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 },
    {-1, 2 }, {-1, 2 }, {-1, 2 }, {-1, 2 }, {-1, 2 }, {-1, 2 }, {-1, 2 }, {-1, 2 },
    {-1, 2 }, {-1, 2 }, {-1, 2 }, {-1, 2 }, {-1, 2 }, {-1, 2 }, {-1, 2 }, {-1, 2 } },

  /* 8x4 vector, codes 00000xx ... 1xxxxxx */
  { { 6, 5 }, { 6, 5 }, { 5, 5 }, { 5, 5 }, { 4, 4 }, { 4, 4 }, { 4, 4 }, { 4, 4 },
    { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 }, { 2, 4 }, { 2, 4 }, { 2, 4 }, { 2, 4 },
    { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 },
    { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 },
    {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 },
    {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 },
    {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 },
    {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 } },

  /* 8x8 vector, codes 00000xx ... 1xxxxxx */
  { { 6, 5 }, { 6, 5 }, { 5, 5 }, { 5, 5 }, { 4, 4 }, { 4, 4 }, { 4, 4 }, { 4, 4 },
    { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 }, { 2, 4 }, { 2, 4 }, { 2, 4 }, { 2, 4 },
    { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 },
    { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 },
    {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 },
    {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 },
    {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 },
    {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 } },

  /* 16x8 vector, codes 00000xx ... 1xxxxxx */
  { { 6, 5 }, { 6, 5 }, { 5, 5 }, { 5, 5 }, { 4, 4 }, { 4, 4 }, { 4, 4 }, { 4, 4 },
    { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 }, { 2, 4 }, { 2, 4 }, { 2, 4 }, { 2, 4 },
    { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 },
    { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 }, { 0, 3 },
    {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 },
    {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 },
    {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 },
    {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 } },

  /* 16x16 vector, codes 000000x ... 1xxxxxx */
  { { 6, 6 }, { 5, 6 }, { 4, 5 }, { 4, 5 }, { 3, 5 }, { 3, 5 }, { 2, 5 }, { 2, 5 },
    { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 },
    { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 },
    { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 },
    {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 },
    {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 },
    {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 },
    {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 }, {-1, 1 } }
};

/* vector codebook count tables, codes 0000000 ... 1111111 */
static vlc_code_t svq1_intra_vector_tables[6][128] = {
  /* 4x2 vector, codes 00000xx ... 1xxxxxx */
  { { 5, 5 }, { 5, 5 }, { 5, 5 }, { 5, 5 }, {-1, 5 }, {-1, 5 }, {-1, 5 }, {-1, 5 },
    { 6, 4 }, { 6, 4 }, { 6, 4 }, { 6, 4 }, { 6, 4 }, { 6, 4 }, { 6, 4 }, { 6, 4 },
    { 4, 4 }, { 4, 4 }, { 4, 4 }, { 4, 4 }, { 4, 4 }, { 4, 4 }, { 4, 4 }, { 4, 4 },
    { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 },
    { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 },
    { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 },
    { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 },
    { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 } },

  /* 4x4 vector, codes 0000xxx ... 11xxxxx */
  { { 5, 4 }, { 5, 4 }, { 5, 4 }, { 5, 4 }, { 5, 4 }, { 5, 4 }, { 5, 4 }, { 5, 4 },
    {-1, 4 }, {-1, 4 }, {-1, 4 }, {-1, 4 }, {-1, 4 }, {-1, 4 }, {-1, 4 }, {-1, 4 },
    { 6, 3 }, { 6, 3 }, { 6, 3 }, { 6, 3 }, { 6, 3 }, { 6, 3 }, { 6, 3 }, { 6, 3 },
    { 6, 3 }, { 6, 3 }, { 6, 3 }, { 6, 3 }, { 6, 3 }, { 6, 3 }, { 6, 3 }, { 6, 3 },
    { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 },
    { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 },
    { 3, 3 }, { 3, 3 }, { 3, 3 }, { 3, 3 }, { 3, 3 }, { 3, 3 }, { 3, 3 }, { 3, 3 },
    { 3, 3 }, { 3, 3 }, { 3, 3 }, { 3, 3 }, { 3, 3 }, { 3, 3 }, { 3, 3 }, { 3, 3 },
    { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 },
    { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 },
    { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 },
    { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 },
    { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 },
    { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 },
    { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 },
    { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 }, { 0, 2 } },

  /* 8x4 vector, codes 00000xx ... 1xxxxxx */
  { { 2, 5 }, { 2, 5 }, { 2, 5 }, { 2, 5 }, {-1, 5 }, {-1, 5 }, {-1, 5 }, {-1, 5 },
    { 6, 4 }, { 6, 4 }, { 6, 4 }, { 6, 4 }, { 6, 4 }, { 6, 4 }, { 6, 4 }, { 6, 4 },
    { 5, 4 }, { 5, 4 }, { 5, 4 }, { 5, 4 }, { 5, 4 }, { 5, 4 }, { 5, 4 }, { 5, 4 },
    { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 },
    { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 },
    { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 }, { 4, 3 },
    { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 },
    { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 }, { 1, 3 },  
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 } },

  /* 8x8 vector, codes 000000x ... 1xxxxxx */
  { { 2, 6 }, { 2, 6 }, {-1, 6 }, {-1, 6 }, { 5, 5 }, { 5, 5 }, { 5, 5 }, { 5, 5 },
    { 6, 4 }, { 6, 4 }, { 6, 4 }, { 6, 4 }, { 6, 4 }, { 6, 4 }, { 6, 4 }, { 6, 4 },
    { 4, 4 }, { 4, 4 }, { 4, 4 }, { 4, 4 }, { 4, 4 }, { 4, 4 }, { 4, 4 }, { 4, 4 },
    { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 },
    { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 },
    { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 },
    { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 },
    { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 } },

  /* 16x8 vector, codes 000000x ... 1xxxxxx */
  { { 4, 6 }, { 4, 6 }, {-1, 6 }, {-1, 6 }, { 5, 5 }, { 5, 5 }, { 5, 5 }, { 5, 5 },
    { 3, 5 }, { 3, 5 }, { 3, 5 }, { 3, 5 }, { 2, 5 }, { 2, 5 }, { 2, 5 }, { 2, 5 },
    { 6, 3 }, { 6, 3 }, { 6, 3 }, { 6, 3 }, { 6, 3 }, { 6, 3 }, { 6, 3 }, { 6, 3 },
    { 6, 3 }, { 6, 3 }, { 6, 3 }, { 6, 3 }, { 6, 3 }, { 6, 3 }, { 6, 3 }, { 6, 3 },
    { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 },
    { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 },
    { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 },
    { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 } },

  /* 16x16 vector, codes 0000000 ... 1xxxxxx */
  { { 5, 7 }, {-1, 7 }, { 4, 6 }, { 4, 6 }, { 6, 5 }, { 6, 5 }, { 6, 5 }, { 6, 5 },
    { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 }, { 3, 4 },
    { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 },
    { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 }, { 2, 3 },
    { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 },
    { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 },
    { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 },
    { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 }, { 1, 2 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 },
    { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 }, { 0, 1 } }
};

/* intra mean value, codes 00100101 ... 1111xxxx */
static vlc_code_t svq1_intra_mean_table_0[219] = {
  {135, 8 }, {136, 8 }, {165, 8 },
  {134, 8 }, {129, 8 }, {164, 8 }, {163, 8 }, {133, 8 }, {162, 8 }, {174, 8 }, {175, 8 },
  {161, 8 }, {160, 8 }, {159, 8 }, {158, 8 }, {157, 8 }, {156, 8 }, {155, 8 }, {154, 8 },
  {153, 8 }, {151, 8 }, {152, 8 }, {132, 8 }, {110, 8 }, {131, 8 }, {108, 8 }, {130, 8 },
  {166, 8 }, {105, 8 }, {104, 8 }, {103, 8 }, {127, 8 }, {101, 8 }, {167, 8 }, {168, 8 },
  { 98, 8 }, {128, 8 }, { 48, 8 }, { 95, 8 }, { 62, 8 }, { 93, 8 }, { 92, 8 }, { 91, 8 },
  { 90, 8 }, { 89, 8 }, { 60, 8 }, { 87, 8 }, { 86, 8 }, { 57, 8 }, { 84, 8 }, { 83, 8 },
  { 82, 8 }, { 81, 8 }, { 80, 8 }, { 79, 8 }, { 78, 8 }, { 77, 8 }, { 76, 8 }, { 75, 8 },
  { 74, 8 }, { 73, 8 }, { 72, 8 }, { 71, 8 }, { 70, 8 }, { 69, 8 }, { 68, 8 }, { 67, 8 },
  { 66, 8 }, { 65, 8 }, { 56, 8 }, { 63, 8 }, { 23, 8 }, { 61, 8 }, { 30, 8 }, { 59, 8 },
  { 58, 8 }, { 52, 8 }, { 29, 8 }, { 55, 8 }, { 54, 8 }, { 53, 8 }, { 50, 8 }, { 51, 8 },
  { 22, 8 }, { 49, 8 }, { 85, 7 }, { 85, 7 }, { 97, 7 }, { 97, 7 }, { 88, 7 }, { 88, 7 },
  { 64, 7 }, { 64, 7 }, { 94, 7 }, { 94, 7 }, {106, 7 }, {106, 7 }, {107, 7 }, {107, 7 },
  {109, 7 }, {109, 7 }, {111, 7 }, {111, 7 }, {112, 7 }, {112, 7 }, {113, 7 }, {113, 7 },
  {114, 7 }, {114, 7 }, {115, 7 }, {115, 7 }, {116, 7 }, {116, 7 }, {117, 7 }, {117, 7 },
  {118, 7 }, {118, 7 }, {119, 7 }, {119, 7 }, {120, 7 }, {120, 7 }, { 99, 7 }, { 99, 7 },
  {102, 7 }, {102, 7 }, { 28, 7 }, { 28, 7 }, {100, 7 }, {100, 7 }, { 96, 7 }, { 96, 7 },
  {139, 7 }, {139, 7 }, { 24, 7 }, { 24, 7 }, {  1, 7 }, {  1, 7 }, {138, 7 }, {138, 7 },
  {121, 7 }, {121, 7 }, {122, 7 }, {122, 7 }, {123, 7 }, {123, 7 }, {124, 7 }, {124, 7 },
  {125, 7 }, {125, 7 }, {126, 7 }, {126, 7 }, {137, 7 }, {137, 7 }, {140, 7 }, {140, 7 },
  {150, 7 }, {150, 7 }, {144, 7 }, {144, 7 }, {141, 7 }, {141, 7 }, {142, 7 }, {142, 7 },
  {143, 7 }, {143, 7 }, {145, 7 }, {145, 7 }, {147, 7 }, {147, 7 }, {146, 7 }, {146, 7 },
  { 27, 6 }, { 27, 6 }, { 27, 6 }, { 27, 6 }, {148, 6 }, {148, 6 }, {148, 6 }, {148, 6 },
  {149, 6 }, {149, 6 }, {149, 6 }, {149, 6 }, {  0, 6 }, {  0, 6 }, {  0, 6 }, {  0, 6 },
  { 26, 4 }, { 26, 4 }, { 26, 4 }, { 26, 4 }, { 26, 4 }, { 26, 4 }, { 26, 4 }, { 26, 4 },
  { 26, 4 }, { 26, 4 }, { 26, 4 }, { 26, 4 }, { 26, 4 }, { 26, 4 }, { 26, 4 }, { 26, 4 },
  { 25, 4 }, { 25, 4 }, { 25, 4 }, { 25, 4 }, { 25, 4 }, { 25, 4 }, { 25, 4 }, { 25, 4 },
  { 25, 4 }, { 25, 4 }, { 25, 4 }, { 25, 4 }, { 25, 4 }, { 25, 4 }, { 25, 4 }, { 25, 4 }
};

/* intra mean value, codes 0000001101 ... 001001001x */
static vlc_code_t svq1_intra_mean_table_1[135] = {
  {218, 10}, {219, 10}, {220, 10},
  {221, 10}, {222, 10}, {217, 10}, {230, 10}, {215, 10}, {208, 10}, {207, 10}, {206, 10},
  {214, 10}, {204, 10}, {223, 10}, {224, 10}, {225, 10}, {226, 10}, {227, 10}, {228, 10},
  {229, 10}, {213, 10}, {212, 10}, {231, 10}, {232, 10}, {211, 10}, {210, 10}, {236, 10},
  {209, 10}, {216, 10}, {205, 10}, { 18, 10}, {186, 9 }, {186, 9 }, {185, 9 }, {185, 9 },
  {184, 9 }, {184, 9 }, {182, 9 }, {182, 9 }, {183, 9 }, {183, 9 }, {180, 9 }, {180, 9 },
  {181, 9 }, {181, 9 }, {178, 9 }, {178, 9 }, {187, 9 }, {187, 9 }, {176, 9 }, {176, 9 },
  {188, 9 }, {188, 9 }, {179, 9 }, {179, 9 }, {173, 9 }, {173, 9 }, {172, 9 }, {172, 9 },
  {171, 9 }, {171, 9 }, {170, 9 }, {170, 9 }, {169, 9 }, {169, 9 }, {189, 9 }, {189, 9 },
  {190, 9 }, {190, 9 }, {191, 9 }, {191, 9 }, {192, 9 }, {192, 9 }, {193, 9 }, {193, 9 },
  {194, 9 }, {194, 9 }, {195, 9 }, {195, 9 }, {196, 9 }, {196, 9 }, {197, 9 }, {197, 9 },
  {198, 9 }, {198, 9 }, {200, 9 }, {200, 9 }, {201, 9 }, {201, 9 }, {202, 9 }, {202, 9 },
  {203, 9 }, {203, 9 }, {199, 9 }, {199, 9 }, {177, 9 }, {177, 9 }, { 40, 9 }, { 40, 9 },
  { 39, 9 }, { 39, 9 }, { 38, 9 }, { 38, 9 }, { 37, 9 }, { 37, 9 }, { 36, 9 }, { 36, 9 },
  { 35, 9 }, { 35, 9 }, { 34, 9 }, { 34, 9 }, { 33, 9 }, { 33, 9 }, { 32, 9 }, { 32, 9 },
  { 31, 9 }, { 31, 9 }, { 21, 9 }, { 21, 9 }, { 11, 9 }, { 11, 9 }, { 41, 9 }, { 41, 9 },
  { 45, 9 }, { 45, 9 }, { 44, 9 }, { 44, 9 }, { 42, 9 }, { 42, 9 }, { 43, 9 }, { 43, 9 },
  { 47, 9 }, { 47, 9 }, { 46, 9 }, { 46, 9 }
};

/* intra mean value, codes 00000000000001 ... 00000011001xxx */
static vlc_code_t svq1_intra_mean_table_2[207] = {
  {255, 14}, { 14, 14}, { 13, 14}, { 17, 12}, { 17, 12}, { 17, 12}, { 17, 12},
  {243, 11}, {243, 11}, {243, 11}, {243, 11}, {243, 11}, {243, 11}, {243, 11}, {243, 11},
  {242, 11}, {242, 11}, {242, 11}, {242, 11}, {242, 11}, {242, 11}, {242, 11}, {242, 11},
  {241, 11}, {241, 11}, {241, 11}, {241, 11}, {241, 11}, {241, 11}, {241, 11}, {241, 11},
  {240, 11}, {240, 11}, {240, 11}, {240, 11}, {240, 11}, {240, 11}, {240, 11}, {240, 11},
  {237, 11}, {237, 11}, {237, 11}, {237, 11}, {237, 11}, {237, 11}, {237, 11}, {237, 11},
  {239, 11}, {239, 11}, {239, 11}, {239, 11}, {239, 11}, {239, 11}, {239, 11}, {239, 11},
  {235, 11}, {235, 11}, {235, 11}, {235, 11}, {235, 11}, {235, 11}, {235, 11}, {235, 11},
  {234, 11}, {234, 11}, {234, 11}, {234, 11}, {234, 11}, {234, 11}, {234, 11}, {234, 11},
  {233, 11}, {233, 11}, {233, 11}, {233, 11}, {233, 11}, {233, 11}, {233, 11}, {233, 11},
  {244, 11}, {244, 11}, {244, 11}, {244, 11}, {244, 11}, {244, 11}, {244, 11}, {244, 11},
  {238, 11}, {238, 11}, {238, 11}, {238, 11}, {238, 11}, {238, 11}, {238, 11}, {238, 11},
  { 20, 11}, { 20, 11}, { 20, 11}, { 20, 11}, { 20, 11}, { 20, 11}, { 20, 11}, { 20, 11},
  {248, 11}, {248, 11}, {248, 11}, {248, 11}, {248, 11}, {248, 11}, {248, 11}, {248, 11},
  {249, 11}, {249, 11}, {249, 11}, {249, 11}, {249, 11}, {249, 11}, {249, 11}, {249, 11},
  {250, 11}, {250, 11}, {250, 11}, {250, 11}, {250, 11}, {250, 11}, {250, 11}, {250, 11},
  {251, 11}, {251, 11}, {251, 11}, {251, 11}, {251, 11}, {251, 11}, {251, 11}, {251, 11},
  {252, 11}, {252, 11}, {252, 11}, {252, 11}, {252, 11}, {252, 11}, {252, 11}, {252, 11},
  {253, 11}, {253, 11}, {253, 11}, {253, 11}, {253, 11}, {253, 11}, {253, 11}, {253, 11},
  {254, 11}, {254, 11}, {254, 11}, {254, 11}, {254, 11}, {254, 11}, {254, 11}, {254, 11},
  { 12, 11}, { 12, 11}, { 12, 11}, { 12, 11}, { 12, 11}, { 12, 11}, { 12, 11}, { 12, 11},
  { 10, 11}, { 10, 11}, { 10, 11}, { 10, 11}, { 10, 11}, { 10, 11}, { 10, 11}, { 10, 11},
  {245, 11}, {245, 11}, {245, 11}, {245, 11}, {245, 11}, {245, 11}, {245, 11}, {245, 11},
  {247, 11}, {247, 11}, {247, 11}, {247, 11}, {247, 11}, {247, 11}, {247, 11}, {247, 11},
  { 19, 11}, { 19, 11}, { 19, 11}, { 19, 11}, { 19, 11}, { 19, 11}, { 19, 11}, { 19, 11},
  {246, 11}, {246, 11}, {246, 11}, {246, 11}, {246, 11}, {246, 11}, {246, 11}, {246, 11}
};

/* intra mean value, codes 00000000000000000000 ... 000000000000001xxxxx */
static vlc_code_t svq1_intra_mean_table_3[64] = {
  {  6, 20}, {  3, 20}, {  4, 20}, {  5, 20}, {  7, 20}, {  8, 20}, {  9, 19}, {  9, 19},
  {  2, 17}, {  2, 17}, {  2, 17}, {  2, 17}, {  2, 17}, {  2, 17}, {  2, 17}, {  2, 17},
  { 16, 16}, { 16, 16}, { 16, 16}, { 16, 16}, { 16, 16}, { 16, 16}, { 16, 16}, { 16, 16},
  { 16, 16}, { 16, 16}, { 16, 16}, { 16, 16}, { 16, 16}, { 16, 16}, { 16, 16}, { 16, 16},
  { 15, 15}, { 15, 15}, { 15, 15}, { 15, 15}, { 15, 15}, { 15, 15}, { 15, 15}, { 15, 15},
  { 15, 15}, { 15, 15}, { 15, 15}, { 15, 15}, { 15, 15}, { 15, 15}, { 15, 15}, { 15, 15},
  { 15, 15}, { 15, 15}, { 15, 15}, { 15, 15}, { 15, 15}, { 15, 15}, { 15, 15}, { 15, 15},
  { 15, 15}, { 15, 15}, { 15, 15}, { 15, 15}, { 15, 15}, { 15, 15}, { 15, 15}, { 15, 15}
};

/* inter mean value, codes 00001011 ... 1xxxxxxx */
static vlc_code_t svq1_inter_mean_table_0[245] = {
  { 10, 8 }, { 12, 8 }, { 11, 8 }, {-11, 8 }, {-12, 8 },
  {-10, 8 }, { -9, 8 }, { -7, 7 }, { -7, 7 }, { -6, 7 }, { -6, 7 }, {  8, 7 }, {  8, 7 },
  { -8, 7 }, { -8, 7 }, {  9, 7 }, {  9, 7 }, {  6, 7 }, {  6, 7 }, {  7, 7 }, {  7, 7 },
  { -5, 6 }, { -5, 6 }, { -5, 6 }, { -5, 6 }, { -4, 6 }, { -4, 6 }, { -4, 6 }, { -4, 6 },
  {  5, 6 }, {  5, 6 }, {  5, 6 }, {  5, 6 }, {  4, 6 }, {  4, 6 }, {  4, 6 }, {  4, 6 },
  {  3, 5 }, {  3, 5 }, {  3, 5 }, {  3, 5 }, {  3, 5 }, {  3, 5 }, {  3, 5 }, {  3, 5 },
  {  2, 5 }, {  2, 5 }, {  2, 5 }, {  2, 5 }, {  2, 5 }, {  2, 5 }, {  2, 5 }, {  2, 5 },
  { -2, 5 }, { -2, 5 }, { -2, 5 }, { -2, 5 }, { -2, 5 }, { -2, 5 }, { -2, 5 }, { -2, 5 },
  { -3, 5 }, { -3, 5 }, { -3, 5 }, { -3, 5 }, { -3, 5 }, { -3, 5 }, { -3, 5 }, { -3, 5 },
  { -1, 4 }, { -1, 4 }, { -1, 4 }, { -1, 4 }, { -1, 4 }, { -1, 4 }, { -1, 4 }, { -1, 4 },
  { -1, 4 }, { -1, 4 }, { -1, 4 }, { -1, 4 }, { -1, 4 }, { -1, 4 }, { -1, 4 }, { -1, 4 },
  {  1, 3 }, {  1, 3 }, {  1, 3 }, {  1, 3 }, {  1, 3 }, {  1, 3 }, {  1, 3 }, {  1, 3 },
  {  1, 3 }, {  1, 3 }, {  1, 3 }, {  1, 3 }, {  1, 3 }, {  1, 3 }, {  1, 3 }, {  1, 3 },
  {  1, 3 }, {  1, 3 }, {  1, 3 }, {  1, 3 }, {  1, 3 }, {  1, 3 }, {  1, 3 }, {  1, 3 },
  {  1, 3 }, {  1, 3 }, {  1, 3 }, {  1, 3 }, {  1, 3 }, {  1, 3 }, {  1, 3 }, {  1, 3 },
  {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 },
  {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 },
  {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 },
  {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 },
  {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 },
  {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 },
  {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 },
  {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 },
  {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 },
  {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 },
  {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 },
  {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 },
  {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 },
  {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 },
  {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 },
  {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }, {  0, 1 }
};

/* inter mean value, codes 000000010010 ... 00001011xxxx */
static vlc_code_t svq1_inter_mean_table_1[158] = {
  {-30, 12}, {-31, 12}, {-32, 12}, {-33, 12}, { 31, 12}, {-34, 12},
  {-35, 12}, { 29, 12}, { 30, 12}, { 33, 12}, { 34, 12}, { 32, 12}, {-29, 11}, {-29, 11},
  {-28, 11}, {-28, 11}, { 28, 11}, { 28, 11}, {-27, 11}, {-27, 11}, {-26, 11}, {-26, 11},
  { 27, 11}, { 27, 11}, { 26, 11}, { 26, 11}, { 25, 11}, { 25, 11}, { 24, 11}, { 24, 11},
  { 23, 11}, { 23, 11}, { 22, 11}, { 22, 11}, {-24, 11}, {-24, 11}, {-25, 11}, {-25, 11},
  {-23, 10}, {-23, 10}, {-23, 10}, {-23, 10}, {-21, 10}, {-21, 10}, {-21, 10}, {-21, 10},
  {-20, 10}, {-20, 10}, {-20, 10}, {-20, 10}, {-19, 10}, {-19, 10}, {-19, 10}, {-19, 10},
  {-18, 10}, {-18, 10}, {-18, 10}, {-18, 10}, {-22, 10}, {-22, 10}, {-22, 10}, {-22, 10},
  { 19, 10}, { 19, 10}, { 19, 10}, { 19, 10}, { 21, 10}, { 21, 10}, { 21, 10}, { 21, 10},
  { 20, 10}, { 20, 10}, { 20, 10}, { 20, 10}, { 18, 10}, { 18, 10}, { 18, 10}, { 18, 10},
  {-14, 9 }, {-14, 9 }, {-14, 9 }, {-14, 9 }, {-14, 9 }, {-14, 9 }, {-14, 9 }, {-14, 9 },
  {-17, 9 }, {-17, 9 }, {-17, 9 }, {-17, 9 }, {-17, 9 }, {-17, 9 }, {-17, 9 }, {-17, 9 },
  { 16, 9 }, { 16, 9 }, { 16, 9 }, { 16, 9 }, { 16, 9 }, { 16, 9 }, { 16, 9 }, { 16, 9 },
  { 13, 9 }, { 13, 9 }, { 13, 9 }, { 13, 9 }, { 13, 9 }, { 13, 9 }, { 13, 9 }, { 13, 9 },
  { 14, 9 }, { 14, 9 }, { 14, 9 }, { 14, 9 }, { 14, 9 }, { 14, 9 }, { 14, 9 }, { 14, 9 },
  { 15, 9 }, { 15, 9 }, { 15, 9 }, { 15, 9 }, { 15, 9 }, { 15, 9 }, { 15, 9 }, { 15, 9 },
  { 17, 9 }, { 17, 9 }, { 17, 9 }, { 17, 9 }, { 17, 9 }, { 17, 9 }, { 17, 9 }, { 17, 9 },
  {-13, 9 }, {-13, 9 }, {-13, 9 }, {-13, 9 }, {-13, 9 }, {-13, 9 }, {-13, 9 }, {-13, 9 },
  {-16, 9 }, {-16, 9 }, {-16, 9 }, {-16, 9 }, {-16, 9 }, {-16, 9 }, {-16, 9 }, {-16, 9 },
  {-15, 9 }, {-15, 9 }, {-15, 9 }, {-15, 9 }, {-15, 9 }, {-15, 9 }, {-15, 9 }, {-15, 9 }
};

/* inter mean value, codes 000000000010111 ... 0000000100011xx */
static vlc_code_t svq1_inter_mean_table_2[121] = {
  { 61, 15},
  { 52, 15}, { 58, 15}, {-56, 15}, {-57, 15}, { 59, 15}, {-55, 15}, { 60, 15}, {-54, 15},
  { 53, 15}, {-62, 15}, {-60, 15}, {-59, 15}, {-58, 15}, { 57, 15}, { 56, 15}, {-53, 15},
  { 55, 15}, { 54, 15}, { 50, 14}, { 50, 14}, { 45, 14}, { 45, 14}, {-52, 14}, {-52, 14},
  {-51, 14}, {-51, 14}, {-50, 14}, {-50, 14}, { 46, 14}, { 46, 14}, {-49, 14}, {-49, 14},
  {-48, 14}, {-48, 14}, { 48, 14}, { 48, 14}, {-47, 14}, {-47, 14}, { 49, 14}, { 49, 14},
  {-45, 14}, {-45, 14}, {-44, 14}, {-44, 14}, { 47, 14}, { 47, 14}, { 51, 14}, { 51, 14},
  { 44, 14}, { 44, 14}, {-46, 14}, {-46, 14}, {-43, 13}, {-43, 13}, {-43, 13}, {-43, 13},
  {-42, 13}, {-42, 13}, {-42, 13}, {-42, 13}, {-41, 13}, {-41, 13}, {-41, 13}, {-41, 13},
  {-40, 13}, {-40, 13}, {-40, 13}, {-40, 13}, {-39, 13}, {-39, 13}, {-39, 13}, {-39, 13},
  {-38, 13}, {-38, 13}, {-38, 13}, {-38, 13}, {-37, 13}, {-37, 13}, {-37, 13}, {-37, 13},
  {-36, 13}, {-36, 13}, {-36, 13}, {-36, 13}, { 42, 13}, { 42, 13}, { 42, 13}, { 42, 13},
  { 36, 13}, { 36, 13}, { 36, 13}, { 36, 13}, { 43, 13}, { 43, 13}, { 43, 13}, { 43, 13},
  { 41, 13}, { 41, 13}, { 41, 13}, { 41, 13}, { 40, 13}, { 40, 13}, { 40, 13}, { 40, 13},
  { 35, 13}, { 35, 13}, { 35, 13}, { 35, 13}, { 39, 13}, { 39, 13}, { 39, 13}, { 39, 13},
  { 38, 13}, { 38, 13}, { 38, 13}, { 38, 13}, { 37, 13}, { 37, 13}, { 37, 13}, { 37, 13}
};

/* inter mean value, codes 000000000000100101 ... 0000000000101101xx */
static vlc_code_t svq1_inter_mean_table_3[147] = {
  {111, 18}, {102, 18}, { 99, 18},
  {-86, 18}, { 97, 18}, {-97, 18}, { 96, 18}, {-95, 18}, {-76, 18}, {-77, 18}, {-78, 18},
  {-85, 18}, {-80, 18}, {-81, 18}, { 89, 18}, { 90, 18}, {-84, 18}, {-89, 18}, { 80, 18},  
  {-90, 18}, {-88, 18}, { 92, 18}, { 93, 18}, { 95, 18}, {-109,18}, {-79, 17}, {-79, 17},
  {-83, 17}, {-83, 17}, {-75, 17}, {-75, 17}, {-74, 17}, {-74, 17}, {-73, 17}, {-73, 17},
  {-72, 17}, {-72, 17}, { 87, 17}, { 87, 17}, { 86, 17}, { 86, 17}, { 75, 17}, { 75, 17},
  { 85, 17}, { 85, 17}, { 84, 17}, { 84, 17}, { 81, 17}, { 81, 17}, { 79, 17}, { 79, 17},
  { 74, 17}, { 74, 17}, { 72, 17}, { 72, 17}, { 82, 17}, { 82, 17}, { 78, 17}, { 78, 17},
  { 83, 17}, { 83, 17}, { 76, 17}, { 76, 17}, { 73, 17}, { 73, 17}, { 77, 17}, { 77, 17},
  { 70, 16}, { 70, 16}, { 70, 16}, { 70, 16}, { 69, 16}, { 69, 16}, { 69, 16}, { 69, 16},
  { 64, 16}, { 64, 16}, { 64, 16}, { 64, 16}, {-68, 16}, {-68, 16}, {-68, 16}, {-68, 16},
  {-66, 16}, {-66, 16}, {-66, 16}, {-66, 16}, { 68, 16}, { 68, 16}, { 68, 16}, { 68, 16},
  {-69, 16}, {-69, 16}, {-69, 16}, {-69, 16}, { 65, 16}, { 65, 16}, { 65, 16}, { 65, 16},
  { 71, 16}, { 71, 16}, { 71, 16}, { 71, 16}, {-70, 16}, {-70, 16}, {-70, 16}, {-70, 16},
  {-65, 16}, {-65, 16}, {-65, 16}, {-65, 16}, {-67, 16}, {-67, 16}, {-67, 16}, {-67, 16},
  {-63, 16}, {-63, 16}, {-63, 16}, {-63, 16}, {-71, 16}, {-71, 16}, {-71, 16}, {-71, 16},
  { 67, 16}, { 67, 16}, { 67, 16}, { 67, 16}, {-61, 16}, {-61, 16}, {-61, 16}, {-61, 16},
  {-64, 16}, {-64, 16}, {-64, 16}, {-64, 16}, { 63, 16}, { 63, 16}, { 63, 16}, { 63, 16},
  { 62, 16}, { 62, 16}, { 62, 16}, { 62, 16}, { 66, 16}, { 66, 16}, { 66, 16}, { 66, 16}
};

/* inter mean value, codes 00000000000001001001 ... 0000000000001001001x */
static vlc_code_t svq1_inter_mean_table_4[75] = {
  {142, 20}, {135, 20}, {125, 20}, {123, 20}, {122, 20}, {119, 20}, {117, 20},
  {113, 20}, {104, 20}, {103, 20}, {-120,20}, {-114,20}, {-108,20}, {-104,20}, {-102,20},
  {-101,20}, {-93, 20}, {-91, 19}, {-91, 19}, {-96, 19}, {-96, 19}, { 88, 19}, { 88, 19},
  { 91, 19}, { 91, 19}, { 94, 19}, { 94, 19}, {121, 19}, {121, 19}, {120, 19}, {120, 19},
  {-110,19}, {-110,19}, {118, 19}, {118, 19}, {115, 19}, {115, 19}, {114, 19}, {114, 19},
  {112, 19}, {112, 19}, {107, 19}, {107, 19}, {110, 19}, {110, 19}, {109, 19}, {109, 19},
  {108, 19}, {108, 19}, {-103,19}, {-103,19}, {106, 19}, {106, 19}, {105, 19}, {105, 19},
  {-100,19}, {-100,19}, {101, 19}, {101, 19}, {100, 19}, {100, 19}, {-99, 19}, {-99, 19},
  {-82, 19}, {-82, 19}, {-87, 19}, {-87, 19}, {-94, 19}, {-94, 19}, {-98, 19}, {-98, 19},
  { 98, 19}, { 98, 19}, {-92, 19}, {-92, 19}
};

/* inter mean value, codes 0000000000000000000000 ... 000000000000010010001x */
static vlc_code_t svq1_inter_mean_table_5[292] = {
  {255, 22}, {254, 22}, {253, 22}, {252, 22}, {251, 22}, {250, 22}, {249, 22}, {248, 22},
  {247, 22}, {246, 22}, {245, 22}, {244, 22}, {243, 22}, {242, 22}, {241, 22}, {240, 22},
  {239, 22}, {238, 22}, {237, 22}, {236, 22}, {235, 22}, {234, 22}, {233, 22}, {232, 22},
  {231, 22}, {230, 22}, {229, 22}, {228, 22}, {227, 22}, {226, 22}, {225, 22}, {224, 22},
  {223, 22}, {222, 22}, {221, 22}, {220, 22}, {219, 22}, {218, 22}, {217, 22}, {216, 22},
  {215, 22}, {214, 22}, {213, 22}, {212, 22}, {211, 22}, {210, 22}, {209, 22}, {208, 22},
  {207, 22}, {206, 22}, {205, 22}, {204, 22}, {203, 22}, {202, 22}, {201, 22}, {200, 22},
  {199, 22}, {198, 22}, {197, 22}, {196, 22}, {195, 22}, {194, 22}, {193, 22}, {192, 22},
  {191, 22}, {190, 22}, {189, 22}, {188, 22}, {187, 22}, {186, 22}, {185, 22}, {184, 22},
  {183, 22}, {182, 22}, {181, 22}, {180, 22}, {179, 22}, {178, 22}, {177, 22}, {176, 22},
  {175, 22}, {174, 22}, {173, 22}, {172, 22}, {171, 22}, {170, 22}, {169, 22}, {168, 22},
  {167, 22}, {166, 22}, {-256,22}, {164, 22}, {-211,22}, {162, 22}, {161, 22}, {160, 22},
  {-210,22}, {-168,22}, {157, 22}, {156, 22}, {155, 22}, {154, 22}, {153, 22}, {152, 22},
  {151, 22}, {150, 22}, {149, 22}, {148, 22}, {147, 22}, {146, 22}, {145, 22}, {144, 22},
  {143, 22}, {-208,22}, {141, 22}, {140, 22}, {139, 22}, {-200,22}, {137, 22}, {136, 22},
  {-198,22}, {134, 22}, {133, 22}, {-196,22}, {-201,22}, {130, 22}, {129, 22}, {128, 22},
  {127, 22}, {126, 22}, {-195,22}, {124, 22}, {-167,22}, {-166,22}, {-165,22}, {-164,22},
  {-163,22}, {-162,22}, {-161,22}, {-180,22}, {-160,22}, {-159,22}, {-158,22}, {-157,22},
  {-156,22}, {-155,22}, {-154,22}, {-153,22}, {-152,22}, {-151,22}, {-150,22}, {-149,22},
  {-148,22}, {-147,22}, {-146,22}, {-145,22}, {-144,22}, {-143,22}, {-142,22}, {-141,22},
  {-140,22}, {-139,22}, {-138,22}, {-137,22}, {-136,22}, {-135,22}, {-134,22}, {-133,22},
  {-132,22}, {-131,22}, {-130,22}, {-129,22}, {-126,22}, {-125,22}, {-124,22}, {-123,22},
  {-122,22}, {-121,22}, {-118,22}, {-116,22}, {-115,22}, {-113,22}, {-112,22}, {-107,22},
  {-106,22}, {-169,22}, {-170,22}, {-171,22}, {-172,22}, {-173,22}, {-174,22}, {-175,22},
  {-176,22}, {-177,22}, {-178,22}, {-187,22}, {-179,22}, {-181,22}, {-182,22}, {-183,22},
  {-184,22}, {-185,22}, {-186,22}, {-235,22}, {-188,22}, {-189,22}, {-190,22}, {-191,22},
  {-192,22}, {-193,22}, {-194,22}, {-197,22}, {-255,22}, {-254,22}, {-253,22}, {-252,22},
  {-251,22}, {-250,22}, {-249,22}, {-248,22}, {-247,22}, {-246,22}, {-245,22}, {-244,22},
  {-243,22}, {-242,22}, {-241,22}, {-240,22}, {-239,22}, {-238,22}, {-237,22}, {-232,22},
  {-236,22}, {-234,22}, {-233,22}, {-217,22}, {-231,22}, {-230,22}, {-229,22}, {-228,22},
  {-227,22}, {-226,22}, {-225,22}, {-224,22}, {-223,22}, {-222,22}, {-221,22}, {-220,22},
  {-219,22}, {-216,22}, {-202,22}, {-205,22}, {-215,22}, {-214,22}, {-213,22}, {-204,22},
  {-212,22}, {-209,22}, {-218,22}, {-199,22}, {-207,22}, {-206,22}, {165, 21}, {165, 21},
  {131, 21}, {131, 21}, {163, 21}, {163, 21}, {-203,21}, {-203,21}, {116, 21}, {116, 21},
  {159, 21}, {159, 21}, {138, 21}, {138, 21}, {158, 21}, {158, 21}, {-105,21}, {-105,21},
  {-111,21}, {-111,21}, {132, 21}, {132, 21}, {128, 21}, {128, 21}, {-127,21}, {-127,21},
  {-119,21}, {-119,21}, {-117,21}, {-117,21}
};

#define SVQ1_PROCESS_VECTOR()\
    for (; level > 0; i++) {\
      /* process next depth */\
      if (i == m) {\
	m = n;\
	if (--level == 0)\
	  break;\
      }\
      /* divide block if next bit set */\
      if (get_bits (bitbuf, 1) == 0)\
	break;\
      /* add child nodes */\
      list[n++] = list[i];\
      list[n++] = list[i] + (((level & 1) ? pitch : 1) << ((level / 2) + 1));\
    }

#define SVQ1_ADD_CODEBOOK()\
	  /* add codebook entries to vector */\
	  for (j=0; j < stages; j++) {\
	    n3  = codebook[entries[j]] ^ 0x80808080;\
	    n1 += ((n3 & 0xFF00FF00) >> 8);\
	    n2 +=  (n3 & 0x00FF00FF);\
	  }\
\
	  /* clip to [0..255] */\
	  if (n1 & 0xFF00FF00) {\
	    n3  = ((( n1 >> 15) & 0x00010001) | 0x01000100) - 0x00010001;\
	    n1 += 0x7F007F00;\
	    n1 |= (((~n1 >> 15) & 0x00010001) | 0x01000100) - 0x00010001;\
	    n1 &= (n3 & 0x00FF00FF);\
	  }\
\
	  if (n2 & 0xFF00FF00) {\
	    n3  = ((( n2 >> 15) & 0x00010001) | 0x01000100) - 0x00010001;\
	    n2 += 0x7F007F00;\
	    n2 |= (((~n2 >> 15) & 0x00010001) | 0x01000100) - 0x00010001;\
	    n2 &= (n3 & 0x00FF00FF);\
	  }

#define SVQ1_DO_CODEBOOK_INTRA()\
      for (y=0; y < height; y++) {\
	for (x=0; x < (width / 4); x++, codebook++) {\
	n1 = n4;\
	n2 = n4;\
	SVQ1_ADD_CODEBOOK()\
	/* store result */\
	dst[x] = (n1 << 8) | n2;\
	}\
	dst += (pitch / 4);\
      }

#define SVQ1_DO_CODEBOOK_NONINTRA()\
      for (y=0; y < height; y++) {\
	for (x=0; x < (width / 4); x++, codebook++) {\
	n3 = dst[x];\
	/* add mean value to vector */\
	n1 = ((n3 & 0xFF00FF00) >> 8) + n4;\
	n2 =  (n3 & 0x00FF00FF)	  + n4;\
	SVQ1_ADD_CODEBOOK()\
	/* store result */\
	dst[x] = (n1 << 8) | n2;\
	}\
	dst += (pitch / 4);\
      }

#define SVQ1_CALC_CODEBOOK_ENTRIES(cbook)\
      codebook = (const uint32_t *) cbook[level];\
      bit_cache = get_bits (bitbuf, 4*stages);\
      /* calculate codebook entries for this vector */\
      for (j=0; j < stages; j++) {\
	entries[j] = (((bit_cache >> (4*(stages - j - 1))) & 0xF) + 16*j) << (level + 1);\
      }\
      mean -= (stages * 128);\
      n4    = ((mean + (mean >> 31)) << 16) | (mean & 0xFFFF);

static int svq1_decode_block_intra (bit_buffer_t *bitbuf, uint8_t *pixels, int pitch ) {
  uint32_t    bit_cache;
  vlc_code_t *vlc;
  uint8_t    *list[63];
  uint32_t   *dst;
  const uint32_t *codebook;
  int	      entries[6];
  int	      i, j, m, n;
  int	      mean, stages;
  unsigned    x, y, width, height, level;
  uint32_t    n1, n2, n3, n4;

  /* initialize list for breadth first processing of vectors */
  list[0] = pixels;

  /* recursively process vector */
  for (i=0, m=1, n=1, level=5; i < n; i++) {
    SVQ1_PROCESS_VECTOR();

    /* destination address and vector size */
    dst = (uint32_t *) list[i];
    width = 1 << ((4 + level) /2);
    height = 1 << ((3 + level) /2);

    /* get number of stages (-1 skips vector, 0 for mean only) */
    bit_cache = get_bit_cache (bitbuf);

    vlc = &svq1_intra_vector_tables[level][bit_cache >> (32 - 7)];

    /* flush bits */
    stages	    = vlc->value;
    skip_bits(bitbuf,vlc->length);

    if (stages == -1) {
	for (y=0; y < height; y++) {
	  memset (&dst[y*(pitch / 4)], 0, width);
	}
      continue;		/* skip vector */
    }

    if ((stages > 0) && (level >= 4)) {
#ifdef DEBUG_SVQ1
    printf("Error (svq1_decode_block_intra): invalid vector: stages=%i level=%i\n",stages,level);
#endif
      return -1;	/* invalid vector */
    }

    /* get mean value for vector */
    bit_cache = get_bit_cache (bitbuf);

    if (bit_cache >= 0x25000000)
	vlc = &svq1_intra_mean_table_0[(bit_cache >> (32 - 8)) - 37];
    else if (bit_cache >= 0x03400000)
	vlc = &svq1_intra_mean_table_1[(bit_cache >> (32 - 10)) - 13];
    else if (bit_cache >= 0x00040000) 
	vlc = &svq1_intra_mean_table_2[(bit_cache >> (32 - 14)) - 1];
    else
	vlc = &svq1_intra_mean_table_3[bit_cache >> (32 - 20)];

    /* flush bits */
    mean	    = vlc->value;
    skip_bits(bitbuf,vlc->length);

    if (stages == 0) {
      for (y=0; y < height; y++) {
	memset (&dst[y*(pitch / 4)], mean, width);
      }
    } else {
      SVQ1_CALC_CODEBOOK_ENTRIES(svq1_intra_codebooks);
      SVQ1_DO_CODEBOOK_INTRA()
    }
  }

  return 0;
}

static int svq1_decode_block_non_intra (bit_buffer_t *bitbuf, uint8_t *pixels, int pitch ) {
  uint32_t    bit_cache;
  vlc_code_t *vlc;
  uint8_t    *list[63];
  uint32_t   *dst;
  const uint32_t *codebook;
  int	      entries[6];
  int	      i, j, m, n;
  int	      mean, stages;
  int	      x, y, width, height, level;
  uint32_t    n1, n2, n3, n4;

  /* initialize list for breadth first processing of vectors */
  list[0] = pixels;

  /* recursively process vector */
  for (i=0, m=1, n=1, level=5; i < n; i++) {
    SVQ1_PROCESS_VECTOR();

    /* destination address and vector size */
    dst = (uint32_t *) list[i];
    width = 1 << ((4 + level) /2);
    height = 1 << ((3 + level) /2);

    /* get number of stages (-1 skips vector, 0 for mean only) */
    bit_cache = get_bit_cache (bitbuf);

    vlc = &svq1_inter_vector_tables[level][bit_cache >> (32 - 6)];

    /* flush bits */
    stages	    = vlc->value;
    skip_bits(bitbuf,vlc->length);

    if (stages == -1) continue;	/* skip vector */

    if ((stages > 0) && (level >= 4)) {
#ifdef DEBUG_SVQ1
    printf("Error (svq1_decode_block_non_intra): invalid vector: stages=%i level=%i\n",stages,level);
#endif
      return -1;	/* invalid vector */
    }

    /* get mean value for vector */
    bit_cache = get_bit_cache (bitbuf);

    if (bit_cache >= 0x0B000000)
	vlc = &svq1_inter_mean_table_0[(bit_cache >> (32 - 8)) - 11];
    else if (bit_cache >= 0x01200000)
	vlc = &svq1_inter_mean_table_1[(bit_cache >> (32 - 12)) - 18];
    else if (bit_cache >= 0x002E0000) 
	vlc = &svq1_inter_mean_table_2[(bit_cache >> (32 - 15)) - 23];
    else if (bit_cache >= 0x00094000)
	vlc = &svq1_inter_mean_table_3[(bit_cache >> (32 - 18)) - 37];
    else if (bit_cache >= 0x00049000)
	vlc = &svq1_inter_mean_table_4[(bit_cache >> (32 - 20)) - 73];
    else
	vlc = &svq1_inter_mean_table_5[bit_cache >> (32 - 22)];

    /* flush bits */
    mean	    = vlc->value;
    skip_bits(bitbuf,vlc->length);

    SVQ1_CALC_CODEBOOK_ENTRIES(svq1_inter_codebooks);
    SVQ1_DO_CODEBOOK_NONINTRA()
  }
  return 0;
}

static int svq1_decode_motion_vector (bit_buffer_t *bitbuf, svq1_pmv_t *mv, svq1_pmv_t **pmv) {
  uint32_t    bit_cache;
  vlc_code_t *vlc;
  int	      diff, sign;
  int	      i;

  for (i=0; i < 2; i++) {

    /* get motion code */
    bit_cache = get_bit_cache (bitbuf);

    if (!(bit_cache & 0xFFE00000))
      return -1;	/* invalid vlc code */

    if (bit_cache & 0x80000000) {
      diff = 0;

      /* flush bit */
      skip_bits(bitbuf,1);

    } else {
      if (bit_cache >= 0x06000000) {
        vlc = &svq1_motion_table_0[(bit_cache >> (32 - 7)) - 3];
      } else {
        vlc = &svq1_motion_table_1[(bit_cache >> (32 - 12)) - 2];
      }

      /* decode motion vector differential */
      sign = (int) (bit_cache << (vlc->length - 1)) >> 31;
      diff = (vlc->value ^ sign) - sign;

      /* flush bits */
      skip_bits(bitbuf,vlc->length);
    }

    /* add median of motion vector predictors and clip result */
    if (i == 1)
      mv->y = ((diff + MEDIAN(pmv[0]->y, pmv[1]->y, pmv[2]->y)) << 26) >> 26;
    else
      mv->x = ((diff + MEDIAN(pmv[0]->x, pmv[1]->x, pmv[2]->x)) << 26) >> 26;
  }

  return 0;
}

static void svq1_skip_block (uint8_t *current, uint8_t *previous, int pitch, int x, int y) {
  uint8_t *src;
  uint8_t *dst;
  int	   i;

  src = &previous[x + y*pitch];
  dst = current;

  for (i=0; i < 16; i++) {
    memcpy (dst, src, 16);
    src += pitch;
    dst += pitch;
  }
}

static int svq1_motion_inter_block (MpegEncContext *s, bit_buffer_t *bitbuf,
			       uint8_t *current, uint8_t *previous, int pitch,
			       svq1_pmv_t *motion, int x, int y) {
  uint8_t    *src;
  uint8_t    *dst;
  svq1_pmv_t  mv;
  svq1_pmv_t *pmv[3];
  int	      result;

  /* predict and decode motion vector */
  pmv[0] = &motion[0];
  if (y == 0) {
    pmv[1] =
    pmv[2] = pmv[0];
  }
  else {
    pmv[1] = &motion[(x / 8) + 2];
    pmv[2] = &motion[(x / 8) + 4];
  }

  result = svq1_decode_motion_vector (bitbuf, &mv, pmv);

  if (result != 0)
    return result;

  motion[0].x		=
  motion[(x / 8) + 2].x	=
  motion[(x / 8) + 3].x	= mv.x;
  motion[0].y		=
  motion[(x / 8) + 2].y	=
  motion[(x / 8) + 3].y	= mv.y;

  src = &previous[(x + (mv.x >> 1)) + (y + (mv.y >> 1))*pitch];
  dst = current;

  s->dsp.put_pixels_tab[0][((mv.y & 1) << 1) | (mv.x & 1)](dst,src,pitch,16);

  return 0;
}

static int svq1_motion_inter_4v_block (MpegEncContext *s, bit_buffer_t *bitbuf,
				  uint8_t *current, uint8_t *previous, int pitch,
				  svq1_pmv_t *motion,int x, int y) {
  uint8_t    *src;
  uint8_t    *dst;
  svq1_pmv_t  mv;
  svq1_pmv_t *pmv[4];
  int	      i, result;

  /* predict and decode motion vector (0) */
  pmv[0] = &motion[0];
  if (y == 0) {
    pmv[1] =
    pmv[2] = pmv[0];
  }
  else {
    pmv[1] = &motion[(x / 8) + 2];
    pmv[2] = &motion[(x / 8) + 4];
  }

  result = svq1_decode_motion_vector (bitbuf, &mv, pmv);

  if (result != 0)
    return result;

  /* predict and decode motion vector (1) */
  pmv[0] = &mv;
  if (y == 0) {
    pmv[1] =
    pmv[2] = pmv[0];
  }
  else {
    pmv[1] = &motion[(x / 8) + 3];
  }
  result = svq1_decode_motion_vector (bitbuf, &motion[0], pmv);

  if (result != 0)
    return result;

  /* predict and decode motion vector (2) */
  pmv[1] = &motion[0];
  pmv[2] = &motion[(x / 8) + 1];

  result = svq1_decode_motion_vector (bitbuf, &motion[(x / 8) + 2], pmv);

  if (result != 0)
    return result;

  /* predict and decode motion vector (3) */
  pmv[2] = &motion[(x / 8) + 2];
  pmv[3] = &motion[(x / 8) + 3];

  result = svq1_decode_motion_vector (bitbuf, pmv[3], pmv);

  if (result != 0)
    return result;

  /* form predictions */
  for (i=0; i < 4; i++) {
    src = &previous[(x + (pmv[i]->x >> 1)) + (y + (pmv[i]->y >> 1))*pitch];
    dst = current;

    s->dsp.put_pixels_tab[1][((pmv[i]->y & 1) << 1) | (pmv[i]->x & 1)](dst,src,pitch,8);

    /* select next block */
    if (i & 1) {
      current  += 8*(pitch - 1);
      previous += 8*(pitch - 1);
    } else {
      current  += 8;
      previous += 8;
    }
  }

  return 0;
}

static int svq1_decode_delta_block (MpegEncContext *s, bit_buffer_t *bitbuf,
			uint8_t *current, uint8_t *previous, int pitch,
			svq1_pmv_t *motion, int x, int y) {
  uint32_t bit_cache;
  uint32_t block_type;
  int	   result = 0;

  /* get block type */
  bit_cache = get_bit_cache (bitbuf);

  bit_cache	>>= (32 - 3);
  block_type	  = svq1_block_type_table[bit_cache].value;
  skip_bits(bitbuf,svq1_block_type_table[bit_cache].length);

  /* reset motion vectors */
  if (block_type == SVQ1_BLOCK_SKIP || block_type == SVQ1_BLOCK_INTRA) {
    motion[0].x		  =
    motion[0].y		  =
    motion[(x / 8) + 2].x =
    motion[(x / 8) + 2].y =
    motion[(x / 8) + 3].x =
    motion[(x / 8) + 3].y = 0;
  }

  switch (block_type) {
  case SVQ1_BLOCK_SKIP:
    svq1_skip_block (current, previous, pitch, x, y);
    break;

  case SVQ1_BLOCK_INTER:
    result = svq1_motion_inter_block (s, bitbuf, current, previous, pitch, motion, x, y);

    if (result != 0)
    {
#ifdef DEBUG_SVQ1
    printf("Error in svq1_motion_inter_block %i\n",result);
#endif
      break;
    }
    result = svq1_decode_block_non_intra (bitbuf, current, pitch);
    break;

  case SVQ1_BLOCK_INTER_4V:
    result = svq1_motion_inter_4v_block (s, bitbuf, current, previous, pitch, motion, x, y);

    if (result != 0)
    {
#ifdef DEBUG_SVQ1
    printf("Error in svq1_motion_inter_4v_block %i\n",result);
#endif
      break;
    }
    result = svq1_decode_block_non_intra (bitbuf, current, pitch);
    break;

  case SVQ1_BLOCK_INTRA:
    result = svq1_decode_block_intra (bitbuf, current, pitch);
    break;
  }

  return result;
}

/* standard video sizes */
static struct { int width; int height; } svq1_frame_size_table[8] = {
  { 160, 120 }, { 128,  96 }, { 176, 144 }, { 352, 288 },
  { 704, 576 }, { 240, 180 }, { 320, 240 }, {  -1,  -1 }
};

static int svq1_decode_frame_header (bit_buffer_t *bitbuf,MpegEncContext *s) {
  int frame_size_code;

  /* unknown field */
  get_bits (bitbuf, 8);

  /* frame type */
  s->pict_type= get_bits (bitbuf, 2)+1;
  if(s->pict_type==4) 
      return -1;

  if (s->pict_type == I_TYPE) {

    /* unknown fields */
    if (s->f_code == 0x50 || s->f_code == 0x60) {
      get_bits (bitbuf, 16);
    }

    if ((s->f_code ^ 0x10) >= 0x50) {
      skip_bits(bitbuf,8*get_bits (bitbuf, 8));
    }

    get_bits (bitbuf, 2);
    get_bits (bitbuf, 2);
    get_bits (bitbuf, 1);

    /* load frame size */
    frame_size_code = get_bits (bitbuf, 3);

    if (frame_size_code == 7) {
      /* load width, height (12 bits each) */
      s->width = get_bits (bitbuf, 12);
      s->height = get_bits (bitbuf, 12);

      if (!s->width || !s->height)
        return -1;
    } else {
      /* get width, height from table */
      s->width = svq1_frame_size_table[frame_size_code].width;
      s->height = svq1_frame_size_table[frame_size_code].height;
    }
  }

  /* unknown fields */
  if (get_bits (bitbuf, 1) == 1) {
    get_bits (bitbuf, 1);
    get_bits (bitbuf, 1);

    if (get_bits (bitbuf, 2) != 0)
      return -1;
  }

  if (get_bits (bitbuf, 1) == 1) {
    get_bits (bitbuf, 1);
    get_bits (bitbuf, 4);
    get_bits (bitbuf, 1);
    get_bits (bitbuf, 2);

    while (get_bits (bitbuf, 1) == 1) {
      get_bits (bitbuf, 8);
    }
  }
  
  return 0;
}

static int svq1_decode_frame(AVCodecContext *avctx, 
                             void *data, int *data_size,
                             UINT8 *buf, int buf_size)
{
  MpegEncContext *s=avctx->priv_data;
  uint8_t      *current, *previous;
  int		result, i, x, y, width, height;
  AVFrame *pict = data; 

  /* initialize bit buffer */
  init_get_bits(&s->gb,buf,buf_size);

  /* decode frame header */
  s->f_code = get_bits (&s->gb, 22);

  if ((s->f_code & ~0x70) || !(s->f_code & 0x60))
    return -1;

  /* swap some header bytes (why?) */
  if (s->f_code != 0x20) {
    uint32_t *src = (uint32_t *) (buf + 4);

    for (i=0; i < 4; i++) {
      src[i] = ((src[i] << 16) | (src[i] >> 16)) ^ src[7 - i];
    }
  }

  result = svq1_decode_frame_header (&s->gb, s);

  if (result != 0)
  {
#ifdef DEBUG_SVQ1
    printf("Error in svq1_decode_frame_header %i\n",result);
#endif
    return result;
  }
  
  if(avctx->hurry_up && s->pict_type==B_TYPE) return buf_size;

  if(MPV_frame_start(s, avctx) < 0)
      return -1;

  /* decode y, u and v components */
  for (i=0; i < 3; i++) {
    int linesize;
    if (i == 0) {
      width  = (s->width+15)&~15;
      height = (s->height+15)&~15;
      linesize= s->linesize;
    } else {
      if(s->flags&CODEC_FLAG_GRAY) break;
      width  = (s->width/4+15)&~15;
      height = (s->height/4+15)&~15;
      linesize= s->uvlinesize;
    }

    current  = s->current_picture.data[i];

    if(s->pict_type==B_TYPE){
        previous = s->next_picture.data[i];
    }else{
        previous = s->last_picture.data[i];
    }

    if (s->pict_type == I_TYPE) {
      /* keyframe */
      for (y=0; y < height; y+=16) {
	for (x=0; x < width; x+=16) {
	  result = svq1_decode_block_intra (&s->gb, &current[x], linesize);
	  if (result != 0)
	  {
#ifdef DEBUG_SVQ1
	    printf("Error in svq1_decode_block %i (keyframe)\n",result);
#endif
	    return result;
	  }
	}
	current += 16*linesize;
      }
    } else {
      svq1_pmv_t pmv[width/8+3];
      /* delta frame */
      memset (pmv, 0, ((width / 8) + 3) * sizeof(svq1_pmv_t));

      for (y=0; y < height; y+=16) {
	for (x=0; x < width; x+=16) {
	  result = svq1_decode_delta_block (s, &s->gb, &current[x], previous,
					    linesize, pmv, x, y);
	  if (result != 0)
	  {
#ifdef DEBUG_SVQ1
    printf("Error in svq1_decode_delta_block %i\n",result);
#endif
	    return result;
	  }
	}

	pmv[0].x =
	pmv[0].y = 0;

	current += 16*linesize;
      }
    }
  }
  
  *pict = *(AVFrame*)&s->current_picture;


  MPV_frame_end(s);
  
  *data_size=sizeof(AVFrame);
  return buf_size;
}

static int svq1_decode_init(AVCodecContext *avctx)
{
    MpegEncContext *s = avctx->priv_data;

    s->avctx = avctx;
    s->width = (avctx->width+3)&~3;
    s->height = (avctx->height+3)&~3;
    s->codec_id= avctx->codec->id;
    avctx->pix_fmt = PIX_FMT_YUV410P;
    avctx->has_b_frames= 1; // not true, but DP frames and these behave like unidirectional b frames
    s->flags= avctx->flags;
    if (MPV_common_init(s) < 0) return -1;
    return 0;
}

static int svq1_decode_end(AVCodecContext *avctx)
{
    MpegEncContext *s = avctx->priv_data;

    MPV_common_end(s);
    return 0;
}

AVCodec svq1_decoder = {
    "svq1",
    CODEC_TYPE_VIDEO,
    CODEC_ID_SVQ1,
    sizeof(MpegEncContext),
    svq1_decode_init,
    NULL,
    svq1_decode_end,
    svq1_decode_frame,
    CODEC_CAP_DR1,
};
