-- handle the conveyance school

BLINK = add_spell {
	["name"] = 	"Phase Door",
	["name2"] = 	"Phase",
	["school"] = 	{SCHOOL_CONVEYANCE},
	["level"] = 	2,
	["mana"] = 	3,
	["mana_max"] = 	3,
	["fail"] = 	10,
	["spell"] = 	function()
			local dist = 6 + get_level(Ind, BLINK, 6)

			teleport_player(Ind, dist, TRUE);
	end,
	["info"] = 	function()
			return "distance "..(6 + get_level(Ind, BLINK, 6))
	end,
	["desc"] = 	{ "Teleports you on a small scale range.", },
}

DISARM = add_spell {
	["name"] = 	"Disarm",
	["name2"] = 	"Disarm",
	["school"] = 	{SCHOOL_CONVEYANCE},
	["level"] = 	5,
	["mana"] = 	4,
	["mana_max"] = 	4,
	["fail"] = 	10,
	["spell"] = 	function()
			destroy_traps_touch(Ind, 1 + get_level(Ind, DISARM, 4, 0))
	end,
	["info"] = 	function()
			return "rad "..(1 + get_level(Ind, DISARM, 4, 0))
	end,
	["desc"] = 	{ "Destroys traps and reveals and unlocks doors.", }
}

TELEPORT = add_spell {
	["name"] = 	"Teleportation",
	["name2"] = 	"Tele",
	["school"] = 	{SCHOOL_CONVEYANCE},
	["level"] = 	10,
	["mana"] = 	12,
	["mana_max"] = 	12,
	["fail"] = 	50,
	["spell"] = 	function()
			local dist = 100 + get_level(Ind, TELEPORT, 100)

			teleport_player(Ind, dist, FALSE)
	end,
	["info"] = 	function()
			return ""
	end,
	["desc"] = 	{ "Teleports you around the level.", }
}

TELEAWAY_I = add_spell {
	["name"] = 	"Teleport Away I",
	["name2"] = 	"TAway I",
	["school"] = 	{SCHOOL_CONVEYANCE},
	["level"] = 	23,
	["mana"] = 	15,
	["mana_max"] = 	15,
	["fail"] = 	0,
	["direction"] = TRUE,
	["spell"] = 	function(args)
			teleport_monster(Ind, args.dir)
	end,
	["info"] = 	function()
			return ""
	end,
	["desc"] = 	{ "Teleports a line of monsters away.", }
}
TELEAWAY_II = add_spell {
	["name"] = 	"Teleport Away II",
	["name2"] = 	"TAway II",
	["school"] = 	{SCHOOL_CONVEYANCE},
	["level"] = 	43,
	["mana"] = 	40,
	["mana_max"] = 	40,
	["fail"] = 	-60,
	["direction"] = FALSE,
	["spell"] = 	function()
			project_los(Ind, GF_AWAY_ALL, 100, "points and shouts")
	end,
	["info"] = 	function()
			return ""
	end,
	["desc"] = 	{ "Teleports all monsters in sight away." }
}

RECALL = add_spell {
	["name"] = 	"Recall",
	["name2"] = 	"Rec",
	["school"] = 	{SCHOOL_CONVEYANCE},
	["level"] = 	30,
	["mana"] = 	25,
	["mana_max"] = 	25,
	["fail"] = 	20,
	["spell"] = 	function(args)
			local dur = randint(21 - get_level(Ind, RECALL, 15)) + 15 - get_level(Ind, RECALL, 10)

			if args.book < 0 then return end
			set_recall(Ind, dur, player.inventory[1 + args.book])
	end,
	["info"] = 	function()
			return "dur "..(15 - get_level(Ind, RECALL, 10)).."+d"..(21 - get_level(Ind, RECALL, 15))
	end,
	["desc"] = 	{
			"Cast on yourself it will recall you to the surface/dungeon.",
			--"***Automatically projecting***",
	}
}

PROBABILITY_TRAVEL = add_spell {
	["name"] = 	"Probability Travel",
	["name2"] = 	"Prob",
	["school"] = 	{SCHOOL_CONVEYANCE},
	["level"] = 	35,
	["mana"] = 	50,
	["mana_max"] = 	50,
	["fail"] = 	20,
	["spell"] = 	function()
			set_prob_travel(Ind, randint(10) + get_level(Ind, PROBABILITY_TRAVEL, 60))
	end,
	["info"] = 	function()
			return "dur "..get_level(Ind, PROBABILITY_TRAVEL, 60).."+d20"
	end,
	["desc"] = 	{
			"Renders you instable, when you hit a wall you travel throught it and instantly",
			"appear on the other side of it. You can also float up and down at will."
	}
}

if (def_hack("TEMP1", nil) == 0) then
TELEKINESIS = add_spell {
	["name"] = 	"Telekinesis I",
	["name2"] = 	"TK I",
	["school"] = 	{SCHOOL_CONVEYANCE},
	["level"] = 	40,
	["mana"] = 	25,
	["mana_max"] = 	25,
	["fail"] = 	10,
	["am"] = 	75,
	["get_item"] = {
		["prompt"] = 	"Teleport which object? ",
		["inven"] = 	TRUE,
		["get"] = 	function (obj)
			if obj.weight * obj.number <= 4 + get_level(Ind, TELEKINESIS, 390, 0) then
				return TRUE
			end
			return FALSE
		end,
	},
	["spell"] = 	function(args)
		if args.item == -1 then return end
		if player.inventory[1 + args.item].weight * player.inventory[1 + args.item].number <= 4 + get_level(Ind, TELEKINESIS, 390, 0) then
			player.current_telekinesis = player.inventory[1 + args.book]
			telekinesis_aux(Ind, args.item)
		else
			msg_print(Ind, "Pfft trying to hack your client ? pretty lame ...")
		end
	end,
	["info"] = 	function()
		return "max wgt "..((4 + get_level(Ind, TELEKINESIS, 390, 0)) / 10).."."..(imod(4 + get_level(Ind, TELEKINESIS, 390, 0), 10))
	end,
	["desc"] = 	{
		"Inscribe your book with @Pplayername, cast it, select an item and the item",
		"will be teleported to that player whereever he/she might be in the Universe.",
	}
}
else
TELEKINESIS = add_spell {
	["name"] = 	"Telekinesis I",
	["name2"] = 	"TK I",
	["school"] = 	{SCHOOL_CONVEYANCE},
	["level"] = 	40,
	["mana"] = 	25,
	["mana_max"] = 	25,
	["fail"] = 	10,
	["am"] = 	75,
	["spell"] = 	function(args)
		--telekinesis(Ind, player.inventory[1 + args.book], 4 + get_level(Ind, TELEKINESIS, 330, 0)) (conv/mind)
		telekinesis(Ind, player.inventory[1 + args.book], 4 + get_level(Ind, TELEKINESIS, 390, 0))
	end,
	["info"] = 	function()
		--return "max wgt "..((4 + get_level(Ind, TELEKINESIS, 330, 0)) / 10).."."..(imod(4 + get_level(Ind, TELEKINESIS, 330, 0), 10)) (conv/mind)
		return "max wgt "..((4 + get_level(Ind, TELEKINESIS, 390, 0)) / 10).."."..(imod(4 + get_level(Ind, TELEKINESIS, 390, 0), 10))
	end,
	["desc"] = 	{
		"Inscribe your book with @Pplayername, cast it, select an item and the item",
		"will be teleported to that player whereever he/she might be in the Universe.",
	}
}
end
