/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.filelock;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.gradle.cache.internal.filelock.FileLockOutcome;
import org.gradle.cache.internal.filelock.LockState;
import org.gradle.cache.internal.filelock.LockStateSerializer;

public class LockStateAccess {
    private final LockStateSerializer protocol;
    private static final int REGION_START = 0;
    private static final int STATE_CONTENT_START = 1;
    private final int stateRegionSize;

    public LockStateAccess(LockStateSerializer protocol) {
        this.protocol = protocol;
        this.stateRegionSize = 1 + protocol.getSize();
    }

    public LockState ensureLockState(RandomAccessFile lockFileAccess) throws IOException {
        if (lockFileAccess.length() == 0L) {
            LockState state = this.protocol.createInitialState();
            this.writeState(lockFileAccess, state);
            return state;
        }
        return this.readState(lockFileAccess);
    }

    public void writeState(RandomAccessFile lockFileAccess, LockState lockState) throws IOException {
        ByteArrayOutputStream outstr = new ByteArrayOutputStream();
        DataOutputStream dataOutput = new DataOutputStream(outstr);
        dataOutput.writeByte(this.protocol.getVersion());
        this.protocol.write(dataOutput, lockState);
        dataOutput.flush();
        lockFileAccess.seek(0L);
        lockFileAccess.write(outstr.toByteArray());
        assert (lockFileAccess.getFilePointer() == (long)this.stateRegionSize);
    }

    public LockState readState(RandomAccessFile lockFileAccess) throws IOException {
        try {
            int readPos;
            int nread;
            byte[] buffer = new byte[this.stateRegionSize];
            lockFileAccess.seek(0L);
            for (readPos = 0; readPos < buffer.length && (nread = lockFileAccess.read(buffer, readPos, buffer.length - readPos)) >= 0; readPos += nread) {
            }
            ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer, 0, readPos);
            DataInputStream dataInput = new DataInputStream(inputStream);
            byte protocolVersion = dataInput.readByte();
            if (protocolVersion != this.protocol.getVersion()) {
                throw new IllegalStateException(String.format("Unexpected lock protocol found in lock file. Expected %s, found %s.", this.protocol.getVersion(), protocolVersion));
            }
            return this.protocol.read(dataInput);
        }
        catch (EOFException e) {
            return this.protocol.createInitialState();
        }
    }

    public FileLockOutcome tryLock(RandomAccessFile lockFileAccess, boolean shared) throws IOException {
        try {
            FileLock fileLock = lockFileAccess.getChannel().tryLock(0L, this.stateRegionSize, shared);
            if (fileLock == null) {
                return FileLockOutcome.LOCKED_BY_ANOTHER_PROCESS;
            }
            return FileLockOutcome.acquired(fileLock);
        }
        catch (OverlappingFileLockException e) {
            return FileLockOutcome.LOCKED_BY_THIS_PROCESS;
        }
    }

    public int getRegionEnd() {
        return this.stateRegionSize;
    }
}

