/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.junit.diff;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.netbeans.junit.diff.Diff;
import org.netbeans.junit.diff.LineDiff;

public class SimpleDiff
implements Diff {
    private static final int BUFSIZE = 1024;
    private final LineDiff lineDiff = new LineDiff(false);

    @Override
    public boolean diff(File file, File file2, File file3) throws IOException {
        if (this.isBinaryFile(file) || this.isBinaryFile(file2)) {
            return this.binaryCompare(file, file2, file3);
        }
        return this.textualCompare(file, file2, file3);
    }

    @Override
    public boolean diff(String string, String string2, String string3) throws IOException {
        File file = new File(string);
        File file2 = new File(string2);
        File file3 = null != string3 ? new File(string3) : null;
        return this.diff(file, file2, file3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isBinaryFile(File file) throws IOException {
        byte[] byArray = new byte[1024];
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            boolean bl;
            boolean bl2 = fileInputStream.read(byArray, 0, 1024);
            if (bl2) {
                boolean bl3 = false;
                return bl3;
            }
            for (bl = false; bl != bl2; bl += 1) {
                if (byArray[bl] >= 0) continue;
                boolean bl4 = true;
                return bl4;
            }
            bl = false;
            return bl;
        }
    }

    protected boolean binaryCompare(File file, File file2, File file3) throws IOException {
        if (file.length() != file2.length()) {
            return true;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        BufferedInputStream bufferedInputStream2 = new BufferedInputStream(new FileInputStream(file2));
        byte[] byArray = new byte[1024];
        byte[] byArray2 = new byte[1024];
        try {
            while (true) {
                int n = ((InputStream)bufferedInputStream).read(byArray);
                int n2 = ((InputStream)bufferedInputStream2).read(byArray2);
                if (n == -1) {
                    boolean bl = n2 != -1;
                    return bl;
                }
                if (n != n2) {
                    boolean bl = true;
                    return bl;
                }
                if (Arrays.equals(byArray, byArray2)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            ((InputStream)bufferedInputStream).close();
            ((InputStream)bufferedInputStream2).close();
        }
    }

    protected boolean textualCompare(File file, File file2, File file3) throws IOException {
        return this.lineDiff.diff(file, file2, file3);
    }
}

