// Code generated by mockery; DO NOT EDIT.
// github.com/vektra/mockery
// template: testify

package router

import (
	"context"
	"io"
	"time"

	mock "github.com/stretchr/testify/mock"
	"gitlab.com/gitlab-org/gitlab-runner/common"
	"google.golang.org/grpc"
)

// NewMockDelegate creates a new instance of MockDelegate. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewMockDelegate(t interface {
	mock.TestingT
	Cleanup(func())
}) *MockDelegate {
	mock := &MockDelegate{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}

// MockDelegate is an autogenerated mock type for the Delegate type
type MockDelegate struct {
	mock.Mock
}

type MockDelegate_Expecter struct {
	mock *mock.Mock
}

func (_m *MockDelegate) EXPECT() *MockDelegate_Expecter {
	return &MockDelegate_Expecter{mock: &_m.Mock}
}

// DownloadArtifacts provides a mock function for the type MockDelegate
func (_mock *MockDelegate) DownloadArtifacts(config common.JobCredentials, artifactsFile io.WriteCloser, directDownload *bool) common.DownloadState {
	ret := _mock.Called(config, artifactsFile, directDownload)

	if len(ret) == 0 {
		panic("no return value specified for DownloadArtifacts")
	}

	var r0 common.DownloadState
	if returnFunc, ok := ret.Get(0).(func(common.JobCredentials, io.WriteCloser, *bool) common.DownloadState); ok {
		r0 = returnFunc(config, artifactsFile, directDownload)
	} else {
		r0 = ret.Get(0).(common.DownloadState)
	}
	return r0
}

// MockDelegate_DownloadArtifacts_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'DownloadArtifacts'
type MockDelegate_DownloadArtifacts_Call struct {
	*mock.Call
}

// DownloadArtifacts is a helper method to define mock.On call
//   - config common.JobCredentials
//   - artifactsFile io.WriteCloser
//   - directDownload *bool
func (_e *MockDelegate_Expecter) DownloadArtifacts(config interface{}, artifactsFile interface{}, directDownload interface{}) *MockDelegate_DownloadArtifacts_Call {
	return &MockDelegate_DownloadArtifacts_Call{Call: _e.mock.On("DownloadArtifacts", config, artifactsFile, directDownload)}
}

func (_c *MockDelegate_DownloadArtifacts_Call) Run(run func(config common.JobCredentials, artifactsFile io.WriteCloser, directDownload *bool)) *MockDelegate_DownloadArtifacts_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 common.JobCredentials
		if args[0] != nil {
			arg0 = args[0].(common.JobCredentials)
		}
		var arg1 io.WriteCloser
		if args[1] != nil {
			arg1 = args[1].(io.WriteCloser)
		}
		var arg2 *bool
		if args[2] != nil {
			arg2 = args[2].(*bool)
		}
		run(
			arg0,
			arg1,
			arg2,
		)
	})
	return _c
}

func (_c *MockDelegate_DownloadArtifacts_Call) Return(downloadState common.DownloadState) *MockDelegate_DownloadArtifacts_Call {
	_c.Call.Return(downloadState)
	return _c
}

func (_c *MockDelegate_DownloadArtifacts_Call) RunAndReturn(run func(config common.JobCredentials, artifactsFile io.WriteCloser, directDownload *bool) common.DownloadState) *MockDelegate_DownloadArtifacts_Call {
	_c.Call.Return(run)
	return _c
}

// GetRouterDiscovery provides a mock function for the type MockDelegate
func (_mock *MockDelegate) GetRouterDiscovery(ctx context.Context, config common.RunnerConfig) *common.RouterDiscovery {
	ret := _mock.Called(ctx, config)

	if len(ret) == 0 {
		panic("no return value specified for GetRouterDiscovery")
	}

	var r0 *common.RouterDiscovery
	if returnFunc, ok := ret.Get(0).(func(context.Context, common.RunnerConfig) *common.RouterDiscovery); ok {
		r0 = returnFunc(ctx, config)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*common.RouterDiscovery)
		}
	}
	return r0
}

// MockDelegate_GetRouterDiscovery_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetRouterDiscovery'
type MockDelegate_GetRouterDiscovery_Call struct {
	*mock.Call
}

// GetRouterDiscovery is a helper method to define mock.On call
//   - ctx context.Context
//   - config common.RunnerConfig
func (_e *MockDelegate_Expecter) GetRouterDiscovery(ctx interface{}, config interface{}) *MockDelegate_GetRouterDiscovery_Call {
	return &MockDelegate_GetRouterDiscovery_Call{Call: _e.mock.On("GetRouterDiscovery", ctx, config)}
}

func (_c *MockDelegate_GetRouterDiscovery_Call) Run(run func(ctx context.Context, config common.RunnerConfig)) *MockDelegate_GetRouterDiscovery_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 common.RunnerConfig
		if args[1] != nil {
			arg1 = args[1].(common.RunnerConfig)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockDelegate_GetRouterDiscovery_Call) Return(routerDiscovery *common.RouterDiscovery) *MockDelegate_GetRouterDiscovery_Call {
	_c.Call.Return(routerDiscovery)
	return _c
}

func (_c *MockDelegate_GetRouterDiscovery_Call) RunAndReturn(run func(ctx context.Context, config common.RunnerConfig) *common.RouterDiscovery) *MockDelegate_GetRouterDiscovery_Call {
	_c.Call.Return(run)
	return _c
}

// PatchTrace provides a mock function for the type MockDelegate
func (_mock *MockDelegate) PatchTrace(config common.RunnerConfig, jobCredentials *common.JobCredentials, content []byte, startOffset int, debugModeEnabled bool) common.PatchTraceResult {
	ret := _mock.Called(config, jobCredentials, content, startOffset, debugModeEnabled)

	if len(ret) == 0 {
		panic("no return value specified for PatchTrace")
	}

	var r0 common.PatchTraceResult
	if returnFunc, ok := ret.Get(0).(func(common.RunnerConfig, *common.JobCredentials, []byte, int, bool) common.PatchTraceResult); ok {
		r0 = returnFunc(config, jobCredentials, content, startOffset, debugModeEnabled)
	} else {
		r0 = ret.Get(0).(common.PatchTraceResult)
	}
	return r0
}

// MockDelegate_PatchTrace_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'PatchTrace'
type MockDelegate_PatchTrace_Call struct {
	*mock.Call
}

// PatchTrace is a helper method to define mock.On call
//   - config common.RunnerConfig
//   - jobCredentials *common.JobCredentials
//   - content []byte
//   - startOffset int
//   - debugModeEnabled bool
func (_e *MockDelegate_Expecter) PatchTrace(config interface{}, jobCredentials interface{}, content interface{}, startOffset interface{}, debugModeEnabled interface{}) *MockDelegate_PatchTrace_Call {
	return &MockDelegate_PatchTrace_Call{Call: _e.mock.On("PatchTrace", config, jobCredentials, content, startOffset, debugModeEnabled)}
}

func (_c *MockDelegate_PatchTrace_Call) Run(run func(config common.RunnerConfig, jobCredentials *common.JobCredentials, content []byte, startOffset int, debugModeEnabled bool)) *MockDelegate_PatchTrace_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 common.RunnerConfig
		if args[0] != nil {
			arg0 = args[0].(common.RunnerConfig)
		}
		var arg1 *common.JobCredentials
		if args[1] != nil {
			arg1 = args[1].(*common.JobCredentials)
		}
		var arg2 []byte
		if args[2] != nil {
			arg2 = args[2].([]byte)
		}
		var arg3 int
		if args[3] != nil {
			arg3 = args[3].(int)
		}
		var arg4 bool
		if args[4] != nil {
			arg4 = args[4].(bool)
		}
		run(
			arg0,
			arg1,
			arg2,
			arg3,
			arg4,
		)
	})
	return _c
}

func (_c *MockDelegate_PatchTrace_Call) Return(patchTraceResult common.PatchTraceResult) *MockDelegate_PatchTrace_Call {
	_c.Call.Return(patchTraceResult)
	return _c
}

func (_c *MockDelegate_PatchTrace_Call) RunAndReturn(run func(config common.RunnerConfig, jobCredentials *common.JobCredentials, content []byte, startOffset int, debugModeEnabled bool) common.PatchTraceResult) *MockDelegate_PatchTrace_Call {
	_c.Call.Return(run)
	return _c
}

// PrepareJobRequest provides a mock function for the type MockDelegate
func (_mock *MockDelegate) PrepareJobRequest(config common.RunnerConfig, sessionInfo *common.SessionInfo) common.JobRequest {
	ret := _mock.Called(config, sessionInfo)

	if len(ret) == 0 {
		panic("no return value specified for PrepareJobRequest")
	}

	var r0 common.JobRequest
	if returnFunc, ok := ret.Get(0).(func(common.RunnerConfig, *common.SessionInfo) common.JobRequest); ok {
		r0 = returnFunc(config, sessionInfo)
	} else {
		r0 = ret.Get(0).(common.JobRequest)
	}
	return r0
}

// MockDelegate_PrepareJobRequest_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'PrepareJobRequest'
type MockDelegate_PrepareJobRequest_Call struct {
	*mock.Call
}

// PrepareJobRequest is a helper method to define mock.On call
//   - config common.RunnerConfig
//   - sessionInfo *common.SessionInfo
func (_e *MockDelegate_Expecter) PrepareJobRequest(config interface{}, sessionInfo interface{}) *MockDelegate_PrepareJobRequest_Call {
	return &MockDelegate_PrepareJobRequest_Call{Call: _e.mock.On("PrepareJobRequest", config, sessionInfo)}
}

func (_c *MockDelegate_PrepareJobRequest_Call) Run(run func(config common.RunnerConfig, sessionInfo *common.SessionInfo)) *MockDelegate_PrepareJobRequest_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 common.RunnerConfig
		if args[0] != nil {
			arg0 = args[0].(common.RunnerConfig)
		}
		var arg1 *common.SessionInfo
		if args[1] != nil {
			arg1 = args[1].(*common.SessionInfo)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockDelegate_PrepareJobRequest_Call) Return(jobRequest common.JobRequest) *MockDelegate_PrepareJobRequest_Call {
	_c.Call.Return(jobRequest)
	return _c
}

func (_c *MockDelegate_PrepareJobRequest_Call) RunAndReturn(run func(config common.RunnerConfig, sessionInfo *common.SessionInfo) common.JobRequest) *MockDelegate_PrepareJobRequest_Call {
	_c.Call.Return(run)
	return _c
}

// ProcessJob provides a mock function for the type MockDelegate
func (_mock *MockDelegate) ProcessJob(config common.RunnerConfig, buildCredentials *common.JobCredentials) (common.JobTrace, error) {
	ret := _mock.Called(config, buildCredentials)

	if len(ret) == 0 {
		panic("no return value specified for ProcessJob")
	}

	var r0 common.JobTrace
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(common.RunnerConfig, *common.JobCredentials) (common.JobTrace, error)); ok {
		return returnFunc(config, buildCredentials)
	}
	if returnFunc, ok := ret.Get(0).(func(common.RunnerConfig, *common.JobCredentials) common.JobTrace); ok {
		r0 = returnFunc(config, buildCredentials)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(common.JobTrace)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(common.RunnerConfig, *common.JobCredentials) error); ok {
		r1 = returnFunc(config, buildCredentials)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockDelegate_ProcessJob_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ProcessJob'
type MockDelegate_ProcessJob_Call struct {
	*mock.Call
}

// ProcessJob is a helper method to define mock.On call
//   - config common.RunnerConfig
//   - buildCredentials *common.JobCredentials
func (_e *MockDelegate_Expecter) ProcessJob(config interface{}, buildCredentials interface{}) *MockDelegate_ProcessJob_Call {
	return &MockDelegate_ProcessJob_Call{Call: _e.mock.On("ProcessJob", config, buildCredentials)}
}

func (_c *MockDelegate_ProcessJob_Call) Run(run func(config common.RunnerConfig, buildCredentials *common.JobCredentials)) *MockDelegate_ProcessJob_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 common.RunnerConfig
		if args[0] != nil {
			arg0 = args[0].(common.RunnerConfig)
		}
		var arg1 *common.JobCredentials
		if args[1] != nil {
			arg1 = args[1].(*common.JobCredentials)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockDelegate_ProcessJob_Call) Return(jobTrace common.JobTrace, err error) *MockDelegate_ProcessJob_Call {
	_c.Call.Return(jobTrace, err)
	return _c
}

func (_c *MockDelegate_ProcessJob_Call) RunAndReturn(run func(config common.RunnerConfig, buildCredentials *common.JobCredentials) (common.JobTrace, error)) *MockDelegate_ProcessJob_Call {
	_c.Call.Return(run)
	return _c
}

// RegisterRunner provides a mock function for the type MockDelegate
func (_mock *MockDelegate) RegisterRunner(config common.RunnerCredentials, parameters common.RegisterRunnerParameters) *common.RegisterRunnerResponse {
	ret := _mock.Called(config, parameters)

	if len(ret) == 0 {
		panic("no return value specified for RegisterRunner")
	}

	var r0 *common.RegisterRunnerResponse
	if returnFunc, ok := ret.Get(0).(func(common.RunnerCredentials, common.RegisterRunnerParameters) *common.RegisterRunnerResponse); ok {
		r0 = returnFunc(config, parameters)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*common.RegisterRunnerResponse)
		}
	}
	return r0
}

// MockDelegate_RegisterRunner_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'RegisterRunner'
type MockDelegate_RegisterRunner_Call struct {
	*mock.Call
}

// RegisterRunner is a helper method to define mock.On call
//   - config common.RunnerCredentials
//   - parameters common.RegisterRunnerParameters
func (_e *MockDelegate_Expecter) RegisterRunner(config interface{}, parameters interface{}) *MockDelegate_RegisterRunner_Call {
	return &MockDelegate_RegisterRunner_Call{Call: _e.mock.On("RegisterRunner", config, parameters)}
}

func (_c *MockDelegate_RegisterRunner_Call) Run(run func(config common.RunnerCredentials, parameters common.RegisterRunnerParameters)) *MockDelegate_RegisterRunner_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 common.RunnerCredentials
		if args[0] != nil {
			arg0 = args[0].(common.RunnerCredentials)
		}
		var arg1 common.RegisterRunnerParameters
		if args[1] != nil {
			arg1 = args[1].(common.RegisterRunnerParameters)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockDelegate_RegisterRunner_Call) Return(registerRunnerResponse *common.RegisterRunnerResponse) *MockDelegate_RegisterRunner_Call {
	_c.Call.Return(registerRunnerResponse)
	return _c
}

func (_c *MockDelegate_RegisterRunner_Call) RunAndReturn(run func(config common.RunnerCredentials, parameters common.RegisterRunnerParameters) *common.RegisterRunnerResponse) *MockDelegate_RegisterRunner_Call {
	_c.Call.Return(run)
	return _c
}

// RequestJob provides a mock function for the type MockDelegate
func (_mock *MockDelegate) RequestJob(ctx context.Context, config common.RunnerConfig, sessionInfo *common.SessionInfo) (*common.JobResponse, bool) {
	ret := _mock.Called(ctx, config, sessionInfo)

	if len(ret) == 0 {
		panic("no return value specified for RequestJob")
	}

	var r0 *common.JobResponse
	var r1 bool
	if returnFunc, ok := ret.Get(0).(func(context.Context, common.RunnerConfig, *common.SessionInfo) (*common.JobResponse, bool)); ok {
		return returnFunc(ctx, config, sessionInfo)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, common.RunnerConfig, *common.SessionInfo) *common.JobResponse); ok {
		r0 = returnFunc(ctx, config, sessionInfo)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*common.JobResponse)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, common.RunnerConfig, *common.SessionInfo) bool); ok {
		r1 = returnFunc(ctx, config, sessionInfo)
	} else {
		r1 = ret.Get(1).(bool)
	}
	return r0, r1
}

// MockDelegate_RequestJob_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'RequestJob'
type MockDelegate_RequestJob_Call struct {
	*mock.Call
}

// RequestJob is a helper method to define mock.On call
//   - ctx context.Context
//   - config common.RunnerConfig
//   - sessionInfo *common.SessionInfo
func (_e *MockDelegate_Expecter) RequestJob(ctx interface{}, config interface{}, sessionInfo interface{}) *MockDelegate_RequestJob_Call {
	return &MockDelegate_RequestJob_Call{Call: _e.mock.On("RequestJob", ctx, config, sessionInfo)}
}

func (_c *MockDelegate_RequestJob_Call) Run(run func(ctx context.Context, config common.RunnerConfig, sessionInfo *common.SessionInfo)) *MockDelegate_RequestJob_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 common.RunnerConfig
		if args[1] != nil {
			arg1 = args[1].(common.RunnerConfig)
		}
		var arg2 *common.SessionInfo
		if args[2] != nil {
			arg2 = args[2].(*common.SessionInfo)
		}
		run(
			arg0,
			arg1,
			arg2,
		)
	})
	return _c
}

func (_c *MockDelegate_RequestJob_Call) Return(jobResponse *common.JobResponse, b bool) *MockDelegate_RequestJob_Call {
	_c.Call.Return(jobResponse, b)
	return _c
}

func (_c *MockDelegate_RequestJob_Call) RunAndReturn(run func(ctx context.Context, config common.RunnerConfig, sessionInfo *common.SessionInfo) (*common.JobResponse, bool)) *MockDelegate_RequestJob_Call {
	_c.Call.Return(run)
	return _c
}

// ResetToken provides a mock function for the type MockDelegate
func (_mock *MockDelegate) ResetToken(runner common.RunnerCredentials, systemID string) *common.ResetTokenResponse {
	ret := _mock.Called(runner, systemID)

	if len(ret) == 0 {
		panic("no return value specified for ResetToken")
	}

	var r0 *common.ResetTokenResponse
	if returnFunc, ok := ret.Get(0).(func(common.RunnerCredentials, string) *common.ResetTokenResponse); ok {
		r0 = returnFunc(runner, systemID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*common.ResetTokenResponse)
		}
	}
	return r0
}

// MockDelegate_ResetToken_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ResetToken'
type MockDelegate_ResetToken_Call struct {
	*mock.Call
}

// ResetToken is a helper method to define mock.On call
//   - runner common.RunnerCredentials
//   - systemID string
func (_e *MockDelegate_Expecter) ResetToken(runner interface{}, systemID interface{}) *MockDelegate_ResetToken_Call {
	return &MockDelegate_ResetToken_Call{Call: _e.mock.On("ResetToken", runner, systemID)}
}

func (_c *MockDelegate_ResetToken_Call) Run(run func(runner common.RunnerCredentials, systemID string)) *MockDelegate_ResetToken_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 common.RunnerCredentials
		if args[0] != nil {
			arg0 = args[0].(common.RunnerCredentials)
		}
		var arg1 string
		if args[1] != nil {
			arg1 = args[1].(string)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockDelegate_ResetToken_Call) Return(resetTokenResponse *common.ResetTokenResponse) *MockDelegate_ResetToken_Call {
	_c.Call.Return(resetTokenResponse)
	return _c
}

func (_c *MockDelegate_ResetToken_Call) RunAndReturn(run func(runner common.RunnerCredentials, systemID string) *common.ResetTokenResponse) *MockDelegate_ResetToken_Call {
	_c.Call.Return(run)
	return _c
}

// ResetTokenWithPAT provides a mock function for the type MockDelegate
func (_mock *MockDelegate) ResetTokenWithPAT(runner common.RunnerCredentials, systemID string, pat string) *common.ResetTokenResponse {
	ret := _mock.Called(runner, systemID, pat)

	if len(ret) == 0 {
		panic("no return value specified for ResetTokenWithPAT")
	}

	var r0 *common.ResetTokenResponse
	if returnFunc, ok := ret.Get(0).(func(common.RunnerCredentials, string, string) *common.ResetTokenResponse); ok {
		r0 = returnFunc(runner, systemID, pat)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*common.ResetTokenResponse)
		}
	}
	return r0
}

// MockDelegate_ResetTokenWithPAT_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'ResetTokenWithPAT'
type MockDelegate_ResetTokenWithPAT_Call struct {
	*mock.Call
}

// ResetTokenWithPAT is a helper method to define mock.On call
//   - runner common.RunnerCredentials
//   - systemID string
//   - pat string
func (_e *MockDelegate_Expecter) ResetTokenWithPAT(runner interface{}, systemID interface{}, pat interface{}) *MockDelegate_ResetTokenWithPAT_Call {
	return &MockDelegate_ResetTokenWithPAT_Call{Call: _e.mock.On("ResetTokenWithPAT", runner, systemID, pat)}
}

func (_c *MockDelegate_ResetTokenWithPAT_Call) Run(run func(runner common.RunnerCredentials, systemID string, pat string)) *MockDelegate_ResetTokenWithPAT_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 common.RunnerCredentials
		if args[0] != nil {
			arg0 = args[0].(common.RunnerCredentials)
		}
		var arg1 string
		if args[1] != nil {
			arg1 = args[1].(string)
		}
		var arg2 string
		if args[2] != nil {
			arg2 = args[2].(string)
		}
		run(
			arg0,
			arg1,
			arg2,
		)
	})
	return _c
}

func (_c *MockDelegate_ResetTokenWithPAT_Call) Return(resetTokenResponse *common.ResetTokenResponse) *MockDelegate_ResetTokenWithPAT_Call {
	_c.Call.Return(resetTokenResponse)
	return _c
}

func (_c *MockDelegate_ResetTokenWithPAT_Call) RunAndReturn(run func(runner common.RunnerCredentials, systemID string, pat string) *common.ResetTokenResponse) *MockDelegate_ResetTokenWithPAT_Call {
	_c.Call.Return(run)
	return _c
}

// SetConnectionMaxAge provides a mock function for the type MockDelegate
func (_mock *MockDelegate) SetConnectionMaxAge(duration time.Duration) {
	_mock.Called(duration)
	return
}

// MockDelegate_SetConnectionMaxAge_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'SetConnectionMaxAge'
type MockDelegate_SetConnectionMaxAge_Call struct {
	*mock.Call
}

// SetConnectionMaxAge is a helper method to define mock.On call
//   - duration time.Duration
func (_e *MockDelegate_Expecter) SetConnectionMaxAge(duration interface{}) *MockDelegate_SetConnectionMaxAge_Call {
	return &MockDelegate_SetConnectionMaxAge_Call{Call: _e.mock.On("SetConnectionMaxAge", duration)}
}

func (_c *MockDelegate_SetConnectionMaxAge_Call) Run(run func(duration time.Duration)) *MockDelegate_SetConnectionMaxAge_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 time.Duration
		if args[0] != nil {
			arg0 = args[0].(time.Duration)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockDelegate_SetConnectionMaxAge_Call) Return() *MockDelegate_SetConnectionMaxAge_Call {
	_c.Call.Return()
	return _c
}

func (_c *MockDelegate_SetConnectionMaxAge_Call) RunAndReturn(run func(duration time.Duration)) *MockDelegate_SetConnectionMaxAge_Call {
	_c.Run(run)
	return _c
}

// UnregisterRunner provides a mock function for the type MockDelegate
func (_mock *MockDelegate) UnregisterRunner(config common.RunnerCredentials) bool {
	ret := _mock.Called(config)

	if len(ret) == 0 {
		panic("no return value specified for UnregisterRunner")
	}

	var r0 bool
	if returnFunc, ok := ret.Get(0).(func(common.RunnerCredentials) bool); ok {
		r0 = returnFunc(config)
	} else {
		r0 = ret.Get(0).(bool)
	}
	return r0
}

// MockDelegate_UnregisterRunner_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'UnregisterRunner'
type MockDelegate_UnregisterRunner_Call struct {
	*mock.Call
}

// UnregisterRunner is a helper method to define mock.On call
//   - config common.RunnerCredentials
func (_e *MockDelegate_Expecter) UnregisterRunner(config interface{}) *MockDelegate_UnregisterRunner_Call {
	return &MockDelegate_UnregisterRunner_Call{Call: _e.mock.On("UnregisterRunner", config)}
}

func (_c *MockDelegate_UnregisterRunner_Call) Run(run func(config common.RunnerCredentials)) *MockDelegate_UnregisterRunner_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 common.RunnerCredentials
		if args[0] != nil {
			arg0 = args[0].(common.RunnerCredentials)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockDelegate_UnregisterRunner_Call) Return(b bool) *MockDelegate_UnregisterRunner_Call {
	_c.Call.Return(b)
	return _c
}

func (_c *MockDelegate_UnregisterRunner_Call) RunAndReturn(run func(config common.RunnerCredentials) bool) *MockDelegate_UnregisterRunner_Call {
	_c.Call.Return(run)
	return _c
}

// UnregisterRunnerManager provides a mock function for the type MockDelegate
func (_mock *MockDelegate) UnregisterRunnerManager(config common.RunnerCredentials, systemID string) bool {
	ret := _mock.Called(config, systemID)

	if len(ret) == 0 {
		panic("no return value specified for UnregisterRunnerManager")
	}

	var r0 bool
	if returnFunc, ok := ret.Get(0).(func(common.RunnerCredentials, string) bool); ok {
		r0 = returnFunc(config, systemID)
	} else {
		r0 = ret.Get(0).(bool)
	}
	return r0
}

// MockDelegate_UnregisterRunnerManager_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'UnregisterRunnerManager'
type MockDelegate_UnregisterRunnerManager_Call struct {
	*mock.Call
}

// UnregisterRunnerManager is a helper method to define mock.On call
//   - config common.RunnerCredentials
//   - systemID string
func (_e *MockDelegate_Expecter) UnregisterRunnerManager(config interface{}, systemID interface{}) *MockDelegate_UnregisterRunnerManager_Call {
	return &MockDelegate_UnregisterRunnerManager_Call{Call: _e.mock.On("UnregisterRunnerManager", config, systemID)}
}

func (_c *MockDelegate_UnregisterRunnerManager_Call) Run(run func(config common.RunnerCredentials, systemID string)) *MockDelegate_UnregisterRunnerManager_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 common.RunnerCredentials
		if args[0] != nil {
			arg0 = args[0].(common.RunnerCredentials)
		}
		var arg1 string
		if args[1] != nil {
			arg1 = args[1].(string)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockDelegate_UnregisterRunnerManager_Call) Return(b bool) *MockDelegate_UnregisterRunnerManager_Call {
	_c.Call.Return(b)
	return _c
}

func (_c *MockDelegate_UnregisterRunnerManager_Call) RunAndReturn(run func(config common.RunnerCredentials, systemID string) bool) *MockDelegate_UnregisterRunnerManager_Call {
	_c.Call.Return(run)
	return _c
}

// UpdateJob provides a mock function for the type MockDelegate
func (_mock *MockDelegate) UpdateJob(config common.RunnerConfig, jobCredentials *common.JobCredentials, jobInfo common.UpdateJobInfo) common.UpdateJobResult {
	ret := _mock.Called(config, jobCredentials, jobInfo)

	if len(ret) == 0 {
		panic("no return value specified for UpdateJob")
	}

	var r0 common.UpdateJobResult
	if returnFunc, ok := ret.Get(0).(func(common.RunnerConfig, *common.JobCredentials, common.UpdateJobInfo) common.UpdateJobResult); ok {
		r0 = returnFunc(config, jobCredentials, jobInfo)
	} else {
		r0 = ret.Get(0).(common.UpdateJobResult)
	}
	return r0
}

// MockDelegate_UpdateJob_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'UpdateJob'
type MockDelegate_UpdateJob_Call struct {
	*mock.Call
}

// UpdateJob is a helper method to define mock.On call
//   - config common.RunnerConfig
//   - jobCredentials *common.JobCredentials
//   - jobInfo common.UpdateJobInfo
func (_e *MockDelegate_Expecter) UpdateJob(config interface{}, jobCredentials interface{}, jobInfo interface{}) *MockDelegate_UpdateJob_Call {
	return &MockDelegate_UpdateJob_Call{Call: _e.mock.On("UpdateJob", config, jobCredentials, jobInfo)}
}

func (_c *MockDelegate_UpdateJob_Call) Run(run func(config common.RunnerConfig, jobCredentials *common.JobCredentials, jobInfo common.UpdateJobInfo)) *MockDelegate_UpdateJob_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 common.RunnerConfig
		if args[0] != nil {
			arg0 = args[0].(common.RunnerConfig)
		}
		var arg1 *common.JobCredentials
		if args[1] != nil {
			arg1 = args[1].(*common.JobCredentials)
		}
		var arg2 common.UpdateJobInfo
		if args[2] != nil {
			arg2 = args[2].(common.UpdateJobInfo)
		}
		run(
			arg0,
			arg1,
			arg2,
		)
	})
	return _c
}

func (_c *MockDelegate_UpdateJob_Call) Return(updateJobResult common.UpdateJobResult) *MockDelegate_UpdateJob_Call {
	_c.Call.Return(updateJobResult)
	return _c
}

func (_c *MockDelegate_UpdateJob_Call) RunAndReturn(run func(config common.RunnerConfig, jobCredentials *common.JobCredentials, jobInfo common.UpdateJobInfo) common.UpdateJobResult) *MockDelegate_UpdateJob_Call {
	_c.Call.Return(run)
	return _c
}

// UploadRawArtifacts provides a mock function for the type MockDelegate
func (_mock *MockDelegate) UploadRawArtifacts(config common.JobCredentials, bodyProvider common.ContentProvider, options common.ArtifactsOptions) (common.UploadState, string) {
	ret := _mock.Called(config, bodyProvider, options)

	if len(ret) == 0 {
		panic("no return value specified for UploadRawArtifacts")
	}

	var r0 common.UploadState
	var r1 string
	if returnFunc, ok := ret.Get(0).(func(common.JobCredentials, common.ContentProvider, common.ArtifactsOptions) (common.UploadState, string)); ok {
		return returnFunc(config, bodyProvider, options)
	}
	if returnFunc, ok := ret.Get(0).(func(common.JobCredentials, common.ContentProvider, common.ArtifactsOptions) common.UploadState); ok {
		r0 = returnFunc(config, bodyProvider, options)
	} else {
		r0 = ret.Get(0).(common.UploadState)
	}
	if returnFunc, ok := ret.Get(1).(func(common.JobCredentials, common.ContentProvider, common.ArtifactsOptions) string); ok {
		r1 = returnFunc(config, bodyProvider, options)
	} else {
		r1 = ret.Get(1).(string)
	}
	return r0, r1
}

// MockDelegate_UploadRawArtifacts_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'UploadRawArtifacts'
type MockDelegate_UploadRawArtifacts_Call struct {
	*mock.Call
}

// UploadRawArtifacts is a helper method to define mock.On call
//   - config common.JobCredentials
//   - bodyProvider common.ContentProvider
//   - options common.ArtifactsOptions
func (_e *MockDelegate_Expecter) UploadRawArtifacts(config interface{}, bodyProvider interface{}, options interface{}) *MockDelegate_UploadRawArtifacts_Call {
	return &MockDelegate_UploadRawArtifacts_Call{Call: _e.mock.On("UploadRawArtifacts", config, bodyProvider, options)}
}

func (_c *MockDelegate_UploadRawArtifacts_Call) Run(run func(config common.JobCredentials, bodyProvider common.ContentProvider, options common.ArtifactsOptions)) *MockDelegate_UploadRawArtifacts_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 common.JobCredentials
		if args[0] != nil {
			arg0 = args[0].(common.JobCredentials)
		}
		var arg1 common.ContentProvider
		if args[1] != nil {
			arg1 = args[1].(common.ContentProvider)
		}
		var arg2 common.ArtifactsOptions
		if args[2] != nil {
			arg2 = args[2].(common.ArtifactsOptions)
		}
		run(
			arg0,
			arg1,
			arg2,
		)
	})
	return _c
}

func (_c *MockDelegate_UploadRawArtifacts_Call) Return(uploadState common.UploadState, s string) *MockDelegate_UploadRawArtifacts_Call {
	_c.Call.Return(uploadState, s)
	return _c
}

func (_c *MockDelegate_UploadRawArtifacts_Call) RunAndReturn(run func(config common.JobCredentials, bodyProvider common.ContentProvider, options common.ArtifactsOptions) (common.UploadState, string)) *MockDelegate_UploadRawArtifacts_Call {
	_c.Call.Return(run)
	return _c
}

// VerifyRunner provides a mock function for the type MockDelegate
func (_mock *MockDelegate) VerifyRunner(config common.RunnerCredentials, systemID string) *common.VerifyRunnerResponse {
	ret := _mock.Called(config, systemID)

	if len(ret) == 0 {
		panic("no return value specified for VerifyRunner")
	}

	var r0 *common.VerifyRunnerResponse
	if returnFunc, ok := ret.Get(0).(func(common.RunnerCredentials, string) *common.VerifyRunnerResponse); ok {
		r0 = returnFunc(config, systemID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*common.VerifyRunnerResponse)
		}
	}
	return r0
}

// MockDelegate_VerifyRunner_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'VerifyRunner'
type MockDelegate_VerifyRunner_Call struct {
	*mock.Call
}

// VerifyRunner is a helper method to define mock.On call
//   - config common.RunnerCredentials
//   - systemID string
func (_e *MockDelegate_Expecter) VerifyRunner(config interface{}, systemID interface{}) *MockDelegate_VerifyRunner_Call {
	return &MockDelegate_VerifyRunner_Call{Call: _e.mock.On("VerifyRunner", config, systemID)}
}

func (_c *MockDelegate_VerifyRunner_Call) Run(run func(config common.RunnerCredentials, systemID string)) *MockDelegate_VerifyRunner_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 common.RunnerCredentials
		if args[0] != nil {
			arg0 = args[0].(common.RunnerCredentials)
		}
		var arg1 string
		if args[1] != nil {
			arg1 = args[1].(string)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockDelegate_VerifyRunner_Call) Return(verifyRunnerResponse *common.VerifyRunnerResponse) *MockDelegate_VerifyRunner_Call {
	_c.Call.Return(verifyRunnerResponse)
	return _c
}

func (_c *MockDelegate_VerifyRunner_Call) RunAndReturn(run func(config common.RunnerCredentials, systemID string) *common.VerifyRunnerResponse) *MockDelegate_VerifyRunner_Call {
	_c.Call.Return(run)
	return _c
}

// NewMockClientConn creates a new instance of MockClientConn. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewMockClientConn(t interface {
	mock.TestingT
	Cleanup(func())
}) *MockClientConn {
	mock := &MockClientConn{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}

// MockClientConn is an autogenerated mock type for the ClientConn type
type MockClientConn struct {
	mock.Mock
}

type MockClientConn_Expecter struct {
	mock *mock.Mock
}

func (_m *MockClientConn) EXPECT() *MockClientConn_Expecter {
	return &MockClientConn_Expecter{mock: &_m.Mock}
}

// Done provides a mock function for the type MockClientConn
func (_mock *MockClientConn) Done() {
	_mock.Called()
	return
}

// MockClientConn_Done_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'Done'
type MockClientConn_Done_Call struct {
	*mock.Call
}

// Done is a helper method to define mock.On call
func (_e *MockClientConn_Expecter) Done() *MockClientConn_Done_Call {
	return &MockClientConn_Done_Call{Call: _e.mock.On("Done")}
}

func (_c *MockClientConn_Done_Call) Run(run func()) *MockClientConn_Done_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockClientConn_Done_Call) Return() *MockClientConn_Done_Call {
	_c.Call.Return()
	return _c
}

func (_c *MockClientConn_Done_Call) RunAndReturn(run func()) *MockClientConn_Done_Call {
	_c.Run(run)
	return _c
}

// Invoke provides a mock function for the type MockClientConn
func (_mock *MockClientConn) Invoke(ctx context.Context, method string, args any, reply any, opts ...grpc.CallOption) error {
	// grpc.CallOption
	_va := make([]interface{}, len(opts))
	for _i := range opts {
		_va[_i] = opts[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, ctx, method, args, reply)
	_ca = append(_ca, _va...)
	ret := _mock.Called(_ca...)

	if len(ret) == 0 {
		panic("no return value specified for Invoke")
	}

	var r0 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, string, any, any, ...grpc.CallOption) error); ok {
		r0 = returnFunc(ctx, method, args, reply, opts...)
	} else {
		r0 = ret.Error(0)
	}
	return r0
}

// MockClientConn_Invoke_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'Invoke'
type MockClientConn_Invoke_Call struct {
	*mock.Call
}

// Invoke is a helper method to define mock.On call
//   - ctx context.Context
//   - method string
//   - args any
//   - reply any
//   - opts ...grpc.CallOption
func (_e *MockClientConn_Expecter) Invoke(ctx interface{}, method interface{}, args interface{}, reply interface{}, opts ...interface{}) *MockClientConn_Invoke_Call {
	return &MockClientConn_Invoke_Call{Call: _e.mock.On("Invoke",
		append([]interface{}{ctx, method, args, reply}, opts...)...)}
}

func (_c *MockClientConn_Invoke_Call) Run(run func(ctx context.Context, method string, args any, reply any, opts ...grpc.CallOption)) *MockClientConn_Invoke_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 string
		if args[1] != nil {
			arg1 = args[1].(string)
		}
		var arg2 any
		if args[2] != nil {
			arg2 = args[2].(any)
		}
		var arg3 any
		if args[3] != nil {
			arg3 = args[3].(any)
		}
		var arg4 []grpc.CallOption
		variadicArgs := make([]grpc.CallOption, len(args)-4)
		for i, a := range args[4:] {
			if a != nil {
				variadicArgs[i] = a.(grpc.CallOption)
			}
		}
		arg4 = variadicArgs
		run(
			arg0,
			arg1,
			arg2,
			arg3,
			arg4...,
		)
	})
	return _c
}

func (_c *MockClientConn_Invoke_Call) Return(err error) *MockClientConn_Invoke_Call {
	_c.Call.Return(err)
	return _c
}

func (_c *MockClientConn_Invoke_Call) RunAndReturn(run func(ctx context.Context, method string, args any, reply any, opts ...grpc.CallOption) error) *MockClientConn_Invoke_Call {
	_c.Call.Return(run)
	return _c
}

// NewStream provides a mock function for the type MockClientConn
func (_mock *MockClientConn) NewStream(ctx context.Context, desc *grpc.StreamDesc, method string, opts ...grpc.CallOption) (grpc.ClientStream, error) {
	// grpc.CallOption
	_va := make([]interface{}, len(opts))
	for _i := range opts {
		_va[_i] = opts[_i]
	}
	var _ca []interface{}
	_ca = append(_ca, ctx, desc, method)
	_ca = append(_ca, _va...)
	ret := _mock.Called(_ca...)

	if len(ret) == 0 {
		panic("no return value specified for NewStream")
	}

	var r0 grpc.ClientStream
	var r1 error
	if returnFunc, ok := ret.Get(0).(func(context.Context, *grpc.StreamDesc, string, ...grpc.CallOption) (grpc.ClientStream, error)); ok {
		return returnFunc(ctx, desc, method, opts...)
	}
	if returnFunc, ok := ret.Get(0).(func(context.Context, *grpc.StreamDesc, string, ...grpc.CallOption) grpc.ClientStream); ok {
		r0 = returnFunc(ctx, desc, method, opts...)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(grpc.ClientStream)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(context.Context, *grpc.StreamDesc, string, ...grpc.CallOption) error); ok {
		r1 = returnFunc(ctx, desc, method, opts...)
	} else {
		r1 = ret.Error(1)
	}
	return r0, r1
}

// MockClientConn_NewStream_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'NewStream'
type MockClientConn_NewStream_Call struct {
	*mock.Call
}

// NewStream is a helper method to define mock.On call
//   - ctx context.Context
//   - desc *grpc.StreamDesc
//   - method string
//   - opts ...grpc.CallOption
func (_e *MockClientConn_Expecter) NewStream(ctx interface{}, desc interface{}, method interface{}, opts ...interface{}) *MockClientConn_NewStream_Call {
	return &MockClientConn_NewStream_Call{Call: _e.mock.On("NewStream",
		append([]interface{}{ctx, desc, method}, opts...)...)}
}

func (_c *MockClientConn_NewStream_Call) Run(run func(ctx context.Context, desc *grpc.StreamDesc, method string, opts ...grpc.CallOption)) *MockClientConn_NewStream_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 context.Context
		if args[0] != nil {
			arg0 = args[0].(context.Context)
		}
		var arg1 *grpc.StreamDesc
		if args[1] != nil {
			arg1 = args[1].(*grpc.StreamDesc)
		}
		var arg2 string
		if args[2] != nil {
			arg2 = args[2].(string)
		}
		var arg3 []grpc.CallOption
		variadicArgs := make([]grpc.CallOption, len(args)-3)
		for i, a := range args[3:] {
			if a != nil {
				variadicArgs[i] = a.(grpc.CallOption)
			}
		}
		arg3 = variadicArgs
		run(
			arg0,
			arg1,
			arg2,
			arg3...,
		)
	})
	return _c
}

func (_c *MockClientConn_NewStream_Call) Return(clientStream grpc.ClientStream, err error) *MockClientConn_NewStream_Call {
	_c.Call.Return(clientStream, err)
	return _c
}

func (_c *MockClientConn_NewStream_Call) RunAndReturn(run func(ctx context.Context, desc *grpc.StreamDesc, method string, opts ...grpc.CallOption) (grpc.ClientStream, error)) *MockClientConn_NewStream_Call {
	_c.Call.Return(run)
	return _c
}
