/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.quality.AbstractCodeQualityTask;
import org.gradle.api.plugins.quality.PmdReports;
import org.gradle.api.plugins.quality.TargetJdk;
import org.gradle.api.plugins.quality.internal.PmdAction;
import org.gradle.api.plugins.quality.internal.PmdActionParameters;
import org.gradle.api.plugins.quality.internal.PmdReportsImpl;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.Reporting;
import org.gradle.api.resources.TextResource;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.LocalState;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.nativeintegration.console.ConsoleDetector;
import org.gradle.internal.nativeintegration.console.ConsoleMetaData;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.util.internal.ClosureBackedAction;
import org.gradle.workers.WorkQueue;

@CacheableTask
public abstract class Pmd
extends AbstractCodeQualityTask
implements Reporting<PmdReports> {
    private FileCollection pmdClasspath;
    private List<String> ruleSets;
    private TargetJdk targetJdk;
    private TextResource ruleSetConfig;
    private FileCollection ruleSetFiles;
    private final PmdReports reports;
    private boolean consoleOutput;
    private FileCollection classpath;
    private final Property<Integer> rulesMinimumPriority;
    private final Property<Integer> maxFailures;
    private final Property<Boolean> incrementalAnalysis;
    private final Property<Integer> threads;

    public Pmd() {
        ObjectFactory objects = this.getObjectFactory();
        this.reports = (PmdReports)objects.newInstance(PmdReportsImpl.class, new Object[]{this});
        this.rulesMinimumPriority = objects.property(Integer.class);
        this.incrementalAnalysis = objects.property(Boolean.class);
        this.maxFailures = objects.property(Integer.class);
        this.threads = objects.property(Integer.class);
    }

    @TaskAction
    public void run() {
        Pmd.validate((Integer)this.rulesMinimumPriority.get());
        Pmd.validateThreads((Integer)this.threads.get());
        WorkQueue workQueue = this.getWorkerExecutor().processIsolation(spec -> this.configureForkOptions(spec.getForkOptions()));
        workQueue.submit(PmdAction.class, this::setupParameters);
    }

    private void setupParameters(PmdActionParameters parameters) {
        parameters.getAntLibraryClasspath().setFrom((Iterable)this.getPmdClasspath());
        parameters.getPmdClasspath().setFrom((Iterable)this.getPmdClasspath());
        parameters.getTargetJdk().set((Object)this.getTargetJdk());
        parameters.getRuleSets().set(this.getRuleSets());
        parameters.getRuleSetConfigFiles().from(new Object[]{this.getRuleSetFiles()});
        if (this.getRuleSetConfig() != null) {
            parameters.getRuleSetConfigFiles().from(new Object[]{this.getRuleSetConfig().asFile()});
        }
        parameters.getIgnoreFailures().set((Object)this.getIgnoreFailures());
        parameters.getConsoleOutput().set((Object)this.isConsoleOutput());
        parameters.getStdOutIsAttachedToTerminal().set((Object)this.stdOutIsAttachedToTerminal());
        if (this.getClasspath() != null) {
            parameters.getAuxClasspath().setFrom((Iterable)this.getClasspath());
        }
        parameters.getRulesMinimumPriority().set(this.getRulesMinimumPriority());
        parameters.getMaxFailures().set(this.getMaxFailures());
        parameters.getIncrementalAnalysis().set(this.getIncrementalAnalysis());
        parameters.getIncrementalCacheFile().set(this.getIncrementalCacheFile());
        parameters.getThreads().set(this.getThreads());
        parameters.getSource().setFrom((Iterable)this.getSource());
        parameters.getEnabledReports().set((Iterable)this.getReports().getEnabled().stream().map(report -> {
            PmdActionParameters.EnabledReport newReport = (PmdActionParameters.EnabledReport)this.getObjectFactory().newInstance(PmdActionParameters.EnabledReport.class, new Object[0]);
            newReport.getName().set((Object)report.getName());
            newReport.getOutputLocation().set((Provider)report.getOutputLocation());
            return newReport;
        }).collect(Collectors.toList()));
    }

    public boolean stdOutIsAttachedToTerminal() {
        try {
            ConsoleDetector consoleDetector = (ConsoleDetector)NativeServices.getInstance().get(ConsoleDetector.class);
            ConsoleMetaData consoleMetaData = consoleDetector.getConsole();
            return consoleMetaData != null && consoleMetaData.isStdOut();
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public PmdReports reports(@DelegatesTo(value=PmdReports.class, strategy=1) Closure closure) {
        return this.reports((Action)new ClosureBackedAction(closure));
    }

    public PmdReports reports(Action<? super PmdReports> configureAction) {
        configureAction.execute((Object)this.reports);
        return this.reports;
    }

    public static void validate(int value) {
        if (value > 5 || value < 1) {
            throw new InvalidUserDataException(String.format("Invalid rulesMinimumPriority '%d'.  Valid range 1 (highest) to 5 (lowest).", value));
        }
    }

    private static void validateThreads(int value) {
        if (value < 0) {
            throw new InvalidUserDataException(String.format("Invalid number of threads '%d'.  Number should not be negative.", value));
        }
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileTree getSource() {
        return super.getSource();
    }

    @Classpath
    public FileCollection getPmdClasspath() {
        return this.pmdClasspath;
    }

    public void setPmdClasspath(FileCollection pmdClasspath) {
        this.pmdClasspath = pmdClasspath;
    }

    @Input
    public List<String> getRuleSets() {
        return this.ruleSets;
    }

    public void setRuleSets(List<String> ruleSets) {
        this.ruleSets = ruleSets;
    }

    @Input
    public TargetJdk getTargetJdk() {
        return this.targetJdk;
    }

    public void setTargetJdk(TargetJdk targetJdk) {
        this.targetJdk = targetJdk;
    }

    @Nullable
    @Optional
    @Nested
    public TextResource getRuleSetConfig() {
        return this.ruleSetConfig;
    }

    public void setRuleSetConfig(@Nullable TextResource ruleSetConfig) {
        this.ruleSetConfig = ruleSetConfig;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    public FileCollection getRuleSetFiles() {
        return this.ruleSetFiles;
    }

    public void setRuleSetFiles(FileCollection ruleSetFiles) {
        this.ruleSetFiles = ruleSetFiles;
    }

    @Nested
    public final PmdReports getReports() {
        return this.reports;
    }

    @Input
    public Property<Integer> getMaxFailures() {
        return this.maxFailures;
    }

    @Input
    public Property<Integer> getRulesMinimumPriority() {
        return this.rulesMinimumPriority;
    }

    @Input
    public boolean isConsoleOutput() {
        return this.consoleOutput;
    }

    public void setConsoleOutput(boolean consoleOutput) {
        this.consoleOutput = consoleOutput;
    }

    @Nullable
    @Optional
    @Classpath
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(@Nullable FileCollection classpath) {
        this.classpath = classpath;
    }

    @Internal
    public Property<Boolean> getIncrementalAnalysis() {
        return this.incrementalAnalysis;
    }

    @LocalState
    public File getIncrementalCacheFile() {
        return new File(this.getTemporaryDir(), "incremental.cache");
    }

    @Input
    public Property<Integer> getThreads() {
        return this.threads;
    }
}

