/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.systemstubs.stream.output;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.stream.Stream;
import uk.org.webcompere.systemstubs.stream.output.MultiplexOutput;
import uk.org.webcompere.systemstubs.stream.output.Output;
import uk.org.webcompere.systemstubs.stream.output.OutputFactory;
import uk.org.webcompere.systemstubs.stream.output.TapStream;

public class OutputFactories {
    public static Output<MultiplexOutput> ofMultiple(Output<?> first, Output<?> ... others) {
        return new MultiplexOutput(first, others);
    }

    public static OutputFactory<MultiplexOutput> ofMultiple(OutputFactory<?> first, OutputFactory<?> ... others) {
        return original -> {
            Output[] constructed = new Output[others.length];
            for (int i = 0; i < others.length; ++i) {
                constructed[i] = others[i].apply(original);
            }
            return new MultiplexOutput(first.apply(original), constructed);
        };
    }

    public static OutputFactory<MultiplexOutput> ofMultiplePlusOriginal(OutputFactory<?> first, OutputFactory<?> ... others) {
        return OutputFactories.ofMultiple(first, (OutputFactory[])Stream.concat(Arrays.stream(others), Stream.of(Output::fromStream)).toArray(OutputFactory[]::new));
    }

    public static OutputFactory<MultiplexOutput> ofMultiplePlusOriginal(Output<?> first, Output<?> ... others) {
        return original -> new MultiplexOutput(first, (Output[])Stream.concat(Arrays.stream(others), Stream.of(Output.fromStream(original))).toArray(Output[]::new));
    }

    public static OutputFactory<MultiplexOutput> tapAndOutput() {
        return OutputFactories.ofMultiplePlusOriginal(new TapStream(), new Output[0]);
    }

    public static OutputFactory<FileOutputStream> writeToFile(File file) {
        return original -> Output.fromCloseableStream(new FileOutputStream(file));
    }
}

