/*
 *    WMAcpiLoad - A dockapp to monitor ACPI status
 *    Copyright (C) 2002  Thomas Nemeth <tnemeth@free.fr>
 *
 *    Patch by Alan Carriou <cariou_alan@yahoo.fr> (C) 2004-2005
 *
 *    Based on work by Seiichi SATO <ssato@sh.rim.or.jp>
 *    Copyright (C) 2001,2002  Seiichi SATO <ssato@sh.rim.or.jp>
 *    and on work by Mark Staggs <me@markstaggs.net>
 *    Copyright (C) 2002  Mark Staggs <me@markstaggs.net>

 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.

 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.

 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef H_AC_ADAPTER
#  define H_AC_ADAPTER

/************************************************************************
 * Constants
 ************************************************************************/

/*
 * Name of the subdirectory of /proc/acpi which contains the AC adapter
 * information.
 * Must contain "/" as first and last characters.
 */
extern const char * const ac_adapter_dir;

/* 
 * Name of the file in the device directory which contains its status, i.e.
 * on-line or not.
 * Must contain "/" as first character.
 */
extern const char * const ac_adapter_state_file;

/************************************************************************
 * Function prototypes for ac_adapter.c
 ************************************************************************/

/*
 * Cleanly frees the AC_adapter from memory.
 *
 * Accepts a NULL AC_adapter*, but does nothing with it.
 */
void ac_adapter_free(AC_adapter *);

/*
 * Allocates memory for a AC_adapter structure, and initializes it
 * with the info found in the directory provided, which must be
 * one such as /proc/acpi/ac_adapter/ACAD/.
 *
 * The AC_acapter structure allocated with ac_adapter_init must be 
 * deallocated with ac_adapter_free().
 *
 * If the dirent* is NULL, or if any malloc() fails, then it returns NULL.
 */
void *ac_adapter_init(struct dirent *);

/*
 * Sets the status field of the AC_adapter. In case of error, the status is set 
 * to "Other".
 * If the parameter is NULL, it does nothing.
 */
void ac_adapter_update_status(AC_adapter *);

#endif                          /* H_AC_ADAPTER */
