/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.IconsDatabase;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.panels.NextMediaFileFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class NextMediaDialog
extends JDialog
implements ActionListener {
    private static final String NEXTMEDIA_MSG_ID = "nextmedia.msg";
    private static final String NEXTMEDIA_TITLE_ID = "nextmedia.title";
    private static final String BROWSEBTN_ID = "nextmedia.browsebtn";
    private static final String OKBTN_ID = "nextmedia.okbtn";
    private static final String CANCELBTN_ID = "nextmedia.cancelbtn";
    private static final long serialVersionUID = -2551719029962051020L;
    protected JLabel msg;
    protected JTextField path;
    protected JButton browsebtn;
    protected JButton okbtn;
    protected JButton cancelbtn;
    protected String nextmedianame;
    protected String nextmediapath;
    protected String nextmediainput;
    protected LocaleDatabase langpack;
    protected IconsDatabase icons;
    protected Frame owner;

    public NextMediaDialog(InstallerFrame installerFrame, String string) throws HeadlessException {
        this(null, installerFrame, string);
    }

    public NextMediaDialog(Frame frame, InstallerFrame installerFrame, String string) throws HeadlessException {
        this(frame, installerFrame.langpack, installerFrame.icons, string);
    }

    public NextMediaDialog(Frame frame, LocaleDatabase localeDatabase, IconsDatabase iconsDatabase, String string) throws HeadlessException {
        super(frame, localeDatabase.getString(NEXTMEDIA_TITLE_ID), true);
        this.owner = frame;
        this.langpack = localeDatabase;
        this.icons = iconsDatabase;
        this.nextmediapath = string;
        File file = new File(this.nextmediapath);
        this.nextmedianame = file.getName();
        this.initUI();
    }

    public NextMediaDialog(Frame frame, AutomatedInstallData automatedInstallData, String string) throws HeadlessException {
        this(frame, automatedInstallData.langpack, null, string);
    }

    protected void initUI() {
        if (this.icons != null) {
            this.msg = LabelFactory.create(this.langpack.getString(NEXTMEDIA_MSG_ID), this.icons.getImageIcon("warning"), 2);
            this.browsebtn = ButtonFactory.createButton(this.langpack.getString(BROWSEBTN_ID), this.icons.getImageIcon("open"), new Color(230, 230, 230));
            this.okbtn = ButtonFactory.createButton(this.langpack.getString(OKBTN_ID), this.icons.getImageIcon("ok"), new Color(230, 230, 230));
            this.cancelbtn = ButtonFactory.createButton(this.langpack.getString(CANCELBTN_ID), this.icons.getImageIcon("cancel"), new Color(230, 230, 230));
        } else {
            this.msg = new JLabel(this.langpack.getString(NEXTMEDIA_MSG_ID), 2);
            this.browsebtn = new JButton(this.langpack.getString(BROWSEBTN_ID));
            this.okbtn = new JButton(this.langpack.getString(OKBTN_ID));
            this.cancelbtn = new JButton(this.langpack.getString(CANCELBTN_ID));
        }
        this.path = new JTextField(this.nextmediapath);
        this.path.setColumns(40);
        this.browsebtn.addActionListener(this);
        this.okbtn.addActionListener(this);
        this.cancelbtn.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        jPanel.add(this.msg);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 2));
        jPanel2.add(this.path);
        jPanel2.add(this.browsebtn);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 2));
        jPanel3.add(Box.createHorizontalGlue());
        jPanel3.add(this.okbtn);
        jPanel3.add(this.cancelbtn);
        jPanel3.add(Box.createHorizontalGlue());
        jPanel.add(jPanel3);
        jPanel.add(Box.createVerticalGlue());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "Center");
        this.pack();
        if (this.owner != null) {
            Dimension dimension = this.getSize();
            Dimension dimension2 = this.owner.getSize();
            Point point = this.owner.getLocationOnScreen();
            Point point2 = new Point();
            point2.setLocation(point.getX() + 0.5 * dimension2.getWidth(), point.getY() + 0.5 * dimension2.getHeight());
            Point point3 = new Point();
            point3.setLocation(point2.getX() - 0.5 * dimension.getWidth(), point2.getY() - 0.5 * dimension.getHeight());
            this.setLocation(point3);
        }
    }

    public String getNextMedia() {
        return this.nextmediainput;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        if (actionEvent.getSource() == this.browsebtn) {
            JFileChooser jFileChooser = this.path.getText() != null ? new JFileChooser(this.path.getText()) : new JFileChooser();
            jFileChooser.setFileFilter(new NextMediaFileFilter(this.nextmedianame, this.langpack));
            jFileChooser.setDialogTitle(this.langpack.getString("nextmedia.choosertitle"));
            jFileChooser.setDialogType(0);
            jFileChooser.setFileSelectionMode(0);
            if (jFileChooser.showOpenDialog(this) == 0) {
                this.nextmediainput = jFileChooser.getSelectedFile().getAbsolutePath();
                this.path.setText(this.nextmediainput);
            }
        } else if (actionEvent.getSource() == this.okbtn) {
            this.nextmediainput = this.path.getText();
            this.setVisible(false);
        } else if (actionEvent.getSource() == this.cancelbtn && (n = JOptionPane.showConfirmDialog(this, this.langpack.getString("installer.quit.message"), this.langpack.getString("installer.quit.title"), 0)) == 0) {
            System.exit(-1);
        }
    }
}

