/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.fluent.tiles;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.bean.Bean;
import com.jgoodies.fluent.tiles.EmptyTile;
import com.jgoodies.fluent.tiles.ObjectTile;
import com.jgoodies.fluent.tiles.Tile;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public interface HubSection {
    public static final String PROPERTY_HEADER = "header";
    public static final String PROPERTY_TILES = "tiles";
    public static final String PROPERTY_SIZE = "size";
    public static final String PROPERTY_LAYOUT_KEEPS_TILE_ORDER = "layoutKeepsTileOrder";

    public int getWidth();

    public String getHeader();

    public void setHeader(String var1);

    public Consumer<MouseEvent> getOnHeaderContextMenu();

    public boolean getLayoutKeepsTileOrder();

    public List<Tile> getTiles();

    public Stream<Tile> tiles();

    public HubSection addTile(Tile var1);

    public void addTile(int var1, Tile var2);

    public void removeTile(Tile var1);

    public void clearTiles();

    public void moveTileUp(int var1);

    public void moveTileDown(int var1);

    public static abstract class AbstractBuilder<B extends AbstractBuilder<?>> {
        protected final DefaultHubSection target = new DefaultHubSection();

        public B width(int value) {
            Preconditions.checkArgument(value >= 1, "The hub section width must be positive.");
            this.target.setWidth(value);
            return (B)this;
        }

        public B header(String str, Object ... args) {
            this.target.setHeader(str, args);
            return (B)this;
        }

        public B headerContextMenu(Consumer<MouseEvent> value) {
            this.target.setOnHeaderContextMenu(value);
            return (B)this;
        }

        public B layoutKeepsTileOrder(boolean value) {
            this.target.setLayoutKeepsTileOrder(value);
            return (B)this;
        }

        public B layoutKeepsTileOrder() {
            return this.layoutKeepsTileOrder(true);
        }

        public B layoutPacksTiles() {
            return this.layoutKeepsTileOrder(false);
        }

        public B emptyTile(Tile.Size size) {
            return this.add(new EmptyTile(size));
        }

        public ObjectTile.Adder<B> beginTile() {
            return new ObjectTile.Adder<AbstractBuilder>(this::add);
        }

        public B add(Tile tile) {
            Preconditions.checkNotNull(tile, "The %s must not be null.", "tile");
            this.target.addTile(tile);
            return (B)this;
        }

        public B addAll(Tile ... tiles) {
            Preconditions.checkNotNull(tiles, "The %s must not be null.", HubSection.PROPERTY_TILES);
            return this.addAll(Arrays.asList(tiles));
        }

        public B addAll(List<Tile> tiles) {
            Preconditions.checkNotNull(tiles, "The %s must not be null.", HubSection.PROPERTY_TILES);
            tiles.forEach(this::add);
            return (B)this;
        }

        public <E> B addEach(Iterable<E> elements, Function<E, Tile> elementToTile) {
            elements.forEach(element -> this.add((Tile)elementToTile.apply(element)));
            return (B)this;
        }

        public <E> B addEach(Stream<E> stream, Function<E, Tile> elementToTile) {
            stream.forEach(element -> this.add((Tile)elementToTile.apply(element)));
            return (B)this;
        }

        public B doWith(Consumer<B> consumer) {
            consumer.accept(this);
            return (B)this;
        }

        public <E> B doWithEach(Stream<E> stream, BiConsumer<E, B> elementAndBuilderConsumer) {
            stream.forEach(element -> elementAndBuilderConsumer.accept(element, this));
            return (B)this;
        }

        protected DefaultHubSection buildHubSection() {
            return this.target;
        }
    }

    public static class Adder<B>
    extends AbstractBuilder<Adder<B>> {
        private final Function<HubSection, B> addFunction;

        Adder(Function<HubSection, B> addFunction) {
            this.addFunction = addFunction;
        }

        public B endSection() {
            return this.addFunction.apply(this.buildHubSection());
        }
    }

    public static class Builder
    extends AbstractBuilder<Builder> {
        public DefaultHubSection build() {
            return this.buildHubSection();
        }
    }

    public static class DefaultHubSection
    extends Bean
    implements HubSection {
        private final List<Tile> tiles = new ArrayList<Tile>();
        private String header;
        private int width = 4;
        private Consumer<MouseEvent> onHeaderContextMenu;
        private boolean layoutKeepsTileOrder;

        @Override
        public final int getWidth() {
            return this.width;
        }

        public final void setWidth(int newValue) {
            this.width = newValue;
            this.firePropertyChange(HubSection.PROPERTY_SIZE, this.width, this.width);
        }

        @Override
        public final String getHeader() {
            return this.header;
        }

        @Override
        public final void setHeader(String newValue) {
            this.header = newValue;
            this.firePropertyChange(HubSection.PROPERTY_HEADER, this.header, this.header);
        }

        public final void setHeader(String text, Object ... args) {
            this.setHeader(Strings.get(text, args));
        }

        @Override
        public final Consumer<MouseEvent> getOnHeaderContextMenu() {
            return this.onHeaderContextMenu;
        }

        public final void setOnHeaderContextMenu(Consumer<MouseEvent> handler) {
            this.onHeaderContextMenu = handler;
        }

        @Override
        public final boolean getLayoutKeepsTileOrder() {
            return this.layoutKeepsTileOrder;
        }

        public final void setLayoutKeepsTileOrder(boolean newValue) {
            this.layoutKeepsTileOrder = newValue;
            this.firePropertyChange(HubSection.PROPERTY_HEADER, this.layoutKeepsTileOrder, this.layoutKeepsTileOrder);
        }

        @Override
        public final List<Tile> getTiles() {
            return Collections.unmodifiableList(this.tiles);
        }

        @Override
        public final Stream<Tile> tiles() {
            return this.tiles.stream();
        }

        @Override
        public final HubSection addTile(Tile tile) {
            Preconditions.checkNotNull(tile, "The %s must not be null.", "tile");
            this.tiles.add(tile);
            this.firePropertyChange(HubSection.PROPERTY_TILES, null, this.getTiles());
            return this;
        }

        @Override
        public final void addTile(int index, Tile tile) {
            Preconditions.checkNotNull(tile, "The %s must not be null.", "tile");
            this.tiles.add(index, tile);
            this.firePropertyChange(HubSection.PROPERTY_TILES, null, this.getTiles());
        }

        @Override
        public final void removeTile(Tile tile) {
            Preconditions.checkNotNull(tile, "The %s must not be null.", "tile");
            this.tiles.remove(tile);
            this.firePropertyChange(HubSection.PROPERTY_TILES, null, this.getTiles());
        }

        @Override
        public final void clearTiles() {
            this.tiles.clear();
            this.firePropertyChange(HubSection.PROPERTY_TILES, null, this.getTiles());
        }

        @Override
        public final void moveTileUp(int oldIndex) {
            int newIndex = oldIndex - 1;
            Tile tile = this.tiles.remove(oldIndex);
            this.addTile(newIndex, tile);
        }

        @Override
        public final void moveTileDown(int oldIndex) {
            int newIndex = oldIndex + 1;
            Tile tile = this.tiles.remove(oldIndex);
            this.addTile(newIndex, tile);
        }
    }
}

