/*
 * wxCHTDecoder
 * Copyright (C) 2004,2008 emuWorks
 * http://games.technoplaza.net/
 *
 * This file is part of wxCHTDecoder.
 *
 * wxCHTDecoder is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * wxCHTDecoder is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with wxCHTDecoder; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

// $Id: chtfilereader.cc,v 1.3 2008/12/15 03:57:04 jdratlif Exp $
 
#ifdef HAVE_CONFIG_H
    #include <config.h>
#endif

#include <wx/wxprec.h>

#ifndef WX_PRECOMP
   #include <wx/wx.h>
#endif

#include <wx/regex.h>

#include <fstream>
#include <sys/stat.h>

#include "exceptions/invalidchtfileexception.hh"
#include "tools/chtfilereader.hh"

using namespace wxCHTDecoder;

CHTFileReader *CHTFileReader::INSTANCE = new CHTFileReader();

CHTFileReader::CHTFileReader() {
    list = new std::vector<CHTCode>;
}

CHTFileReader::~CHTFileReader() {
    delete list;
}

bool CHTFileReader::isValidCHTFile(wxString &filename) {
    static wxRegEx endsWithCHT(wxT("\\.cht$"), (wxRE_EXTENDED | wxRE_ICASE));
    struct stat filestats;
    
    // the cht filename must end in .CHT
    if (!endsWithCHT.Matches(filename)) {
        return false;
    }
    
    // make sure file exists and is stattable
    if (stat(filename.mb_str(), &filestats) != 0) {
        return false;
    }
    
    // a .CHT file should be a multiple of 28 bytes
    if ((filestats.st_size % 28) != 0) {
        return false;
    }
    
    return true;
}

std::vector<CHTCode> &CHTFileReader::readCHTFile(wxString &filename, 
                                                 bool openInvalid) {
    if (!openInvalid && !isValidCHTFile(filename)) {
        throw InvalidCHTFileException();
    }
    
    list->clear();
    
    struct stat filestats;
    
    if (stat(filename.mb_str(), &filestats) != 0) {
        throw InvalidCHTFileException();
    }
   
    int codes = filestats.st_size / 28;
    char data[28];
   
    std::ifstream in(filename.mb_str(), std::ios::in | std::ios::binary);
    
    if (!in) {
        throw InvalidCHTFileException();
    }
    
    for (int i = 0; i < codes; i++) {
        in.read(data, 28);
        
        CHTCode code = CHTCode::parseCHTData((const char *)data);
        list->push_back(code);
    }
    
    in.close();
    
    return *list;
}

