/*
 * Decompiled with CFR 0.152.
 */
package org.dbuml.base.controller;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import org.dbuml.base.controller.CreateActions;
import org.dbuml.base.controller.FigureActionsInterface;
import org.dbuml.base.controller.GenericActions;
import org.dbuml.base.controller.Util;
import org.dbuml.base.controller.ui.ConstraintDlg;
import org.dbuml.base.controller.ui.EntitiesChooserDlg;
import org.dbuml.base.i18n.Translator;
import org.dbuml.base.model.Column;
import org.dbuml.base.model.DBModelFacade;
import org.dbuml.base.model.Table;

public class GenericFigureActions
extends GenericActions
implements FigureActionsInterface {
    private static JFrame frame;

    public void importTablesFromCatalog(Object schemaModel) {
        this.importTablesFromCatalog(schemaModel, null, false);
    }

    public void updateCatalog(Object selectedItem) {
        this.updateCatalog(selectedItem, false);
    }

    public void generateSource(Object selectedItem) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(0);
        int result = fileChooser.showSaveDialog(frame);
        if (result != 1) {
            File fileName = fileChooser.getSelectedFile();
            this.generateSource(selectedItem, fileName);
        }
    }

    public void importSchemas(Object selectedItem) {
        this.importSchemas(selectedItem, null, false);
    }

    public void createConstraintNotNull(Object tableModel) {
        Table table = DBModelFacade.getInstance().getTable(tableModel);
        if (table != null) {
            ArrayList<String> collection = new ArrayList<String>();
            for (Column col : table.getColumnsVector()) {
                if (!col.allowsNulls() || col.isPrimaryKey() && col.isForeignKey()) continue;
                collection.add(col.getName());
            }
            String[] choices = EntitiesChooserDlg.selectData(Translator.getInstance().localize("CONSTRAINT_NOTNULL"), collection.toArray(new String[0]));
            CreateActions.createConstraintNotNull(tableModel, choices);
        }
    }

    public void createConstraintUnique(Object tableModel) {
        Table table = DBModelFacade.getInstance().getTable(tableModel);
        if (table != null) {
            ArrayList<String> collection = new ArrayList<String>();
            for (Column col : table.getColumnsVector()) {
                if (col.isPrimaryKey() || col.isForeignKey()) continue;
                collection.add(col.getName());
            }
            String[] choices = ConstraintDlg.selectData(collection.toArray(new String[0]));
            ConstraintDlg dlg = ConstraintDlg.getInstance();
            CreateActions.createConstraintUnique(table, choices, dlg.getIndexName());
        }
    }

    public void importViews(Object schemaModel) {
        this.importViews(schemaModel, null, false);
    }

    public void createColumnForView(Object viewModel) {
        Collection baseCollection = DBModelFacade.getInstance().getViewBaseModels(viewModel);
        if (baseCollection.size() == 0) {
            Util.showMessageDialog(null, Translator.getInstance().localize("NO_BASE_TABLE_FORVIEW"), Translator.getInstance().localize("NO_BASE_TABLE"), 0);
        } else {
            Hashtable<String, Column> allColsMap = new Hashtable<String, Column>();
            Iterator it = baseCollection.iterator();
            Table table = null;
            while (it.hasNext()) {
                Object baseModel = it.next();
                table = DBModelFacade.getInstance().getTable(baseModel);
                if (table == null) {
                    table = DBModelFacade.getInstance().getView(baseModel);
                }
                if (table == null) continue;
                String tableName = table.getName();
                Column[] cols = table.getColumns();
                for (int i = 0; i < cols.length; ++i) {
                    allColsMap.put(tableName + "." + cols[i].getName(), cols[i]);
                }
            }
            table = null;
            if (allColsMap.isEmpty()) {
                Util.showMessageDialog(null, Translator.getInstance().localize("NO_BASE_ATTRS_FORVIEW"), Translator.getInstance().localize("NO_ATTRS"), 0);
            } else {
                String[] choices = EntitiesChooserDlg.selectData(Translator.getInstance().localize("ADD_COLUMN_FORVIEW"), allColsMap.keySet().toArray(new String[0]));
                CreateActions.createColumnForView(viewModel, allColsMap, choices);
            }
        }
    }

    public void importDatabases(Object selectedItem) {
        Util.showMessageDialog(null, Translator.getInstance().localize("IMPORT_DATABASES"), Translator.getInstance().localize("NOT_IMPLEMENTED"), 0);
    }
}

