/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeOPAQUE;
import oracle.sql.OPAQUE;
import oracle.sql.SQLName;
import oracle.sql.TypeDescriptor;

public class OpaqueDescriptor
extends TypeDescriptor
implements Serializable {
    static final boolean DEBUG = false;
    static final long serialVersionUID = 1013921343538311063L;

    public static OpaqueDescriptor createDescriptor(String string, Connection connection) throws SQLException {
        SQLName sQLName;
        String string2;
        OpaqueDescriptor opaqueDescriptor;
        if (string == null || string.length() == 0 || connection == null) {
            DBError.check_error(60, "Invalid arguments");
        }
        if ((opaqueDescriptor = (OpaqueDescriptor)((oracle.jdbc.OracleConnection)connection).getDescriptor(string2 = (sQLName = new SQLName(string, (oracle.jdbc.OracleConnection)connection)).getName())) == null) {
            opaqueDescriptor = new OpaqueDescriptor(sQLName, connection);
            ((oracle.jdbc.OracleConnection)connection).putDescriptor(string2, opaqueDescriptor);
        }
        return opaqueDescriptor;
    }

    public OpaqueDescriptor(String string, Connection connection) throws SQLException {
        super(string, connection);
        this.initPickler();
    }

    public OpaqueDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        super(sQLName, connection);
        this.initPickler();
    }

    public OpaqueDescriptor(SQLName sQLName, OracleTypeOPAQUE oracleTypeOPAQUE, Connection connection) throws SQLException {
        super(sQLName, oracleTypeOPAQUE, connection);
    }

    private void initPickler() throws SQLException {
        try {
            this.m_pickler = new OracleTypeADT(this.getName(), (Connection)this.m_conn);
            ((OracleTypeADT)this.m_pickler).init((OracleConnection)this.m_conn);
            this.m_pickler = (OracleTypeOPAQUE)((OracleTypeADT)this.m_pickler).cleanup();
            this.m_pickler.setDescriptor(this);
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            DBError.throwSqlException(60, "Unable to resolve type \"" + this.getName() + "\"");
        }
    }

    public OpaqueDescriptor(OracleTypeADT oracleTypeADT, Connection connection) throws SQLException {
        super(oracleTypeADT, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    byte[] toBytes(OPAQUE oPAQUE, boolean bl) throws SQLException {
        byte[] byArray = null;
        if (oPAQUE.shareBytes() != null) {
            return oPAQUE.shareBytes();
        }
        try {
            byArray = this.m_pickler.linearize(oPAQUE);
            Object var5_4 = null;
            if (bl) return byArray;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (bl) throw throwable;
            oPAQUE.setShareBytes(null);
            throw throwable;
        }
        oPAQUE.setShareBytes(null);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] toValue(OPAQUE oPAQUE, boolean bl) throws SQLException {
        byte[] byArray = null;
        if (oPAQUE.m_value != null) {
            byArray = oPAQUE.m_value;
        } else {
            try {
                this.m_pickler.unlinearize(oPAQUE.shareBytes(), 0L, oPAQUE, 1, null);
                byArray = oPAQUE.m_value;
                Object var5_4 = null;
                if (!bl) {
                    oPAQUE.m_value = null;
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (!bl) {
                    oPAQUE.m_value = null;
                }
                throw throwable;
            }
        }
        return byArray;
    }

    public int getTypeCode() {
        return 2007;
    }

    public long getMaxLength() throws SQLException {
        long l = this.hasUnboundedSize() ? 0L : ((OracleTypeOPAQUE)this.m_pickler).getMaxLength();
        return l;
    }

    public boolean isTrustedLibrary() throws SQLException {
        return ((OracleTypeOPAQUE)this.m_pickler).isTrustedLibrary();
    }

    public boolean isModeledInC() throws SQLException {
        return ((OracleTypeOPAQUE)this.m_pickler).isModeledInC();
    }

    public boolean hasUnboundedSize() throws SQLException {
        return ((OracleTypeOPAQUE)this.m_pickler).isUnboundedSized();
    }

    public boolean hasFixedSize() throws SQLException {
        return ((OracleTypeOPAQUE)this.m_pickler).isFixedSized();
    }

    public String descType() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.descType(stringBuffer, 0);
        return string;
    }

    String descType(StringBuffer stringBuffer, int n) throws SQLException {
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            string = string + "  ";
            ++n2;
        }
        String string2 = string + "  ";
        stringBuffer.append(string);
        stringBuffer.append(this.getTypeName());
        stringBuffer.append(" maxLen=" + this.getMaxLength() + " isTrusted=" + this.isTrustedLibrary() + " hasUnboundedSize=" + this.hasUnboundedSize() + " hasFixedSize=" + this.hasFixedSize());
        stringBuffer.append("\n");
        String string3 = stringBuffer.toString();
        return string3;
    }

    public Class getClass(Map map) throws SQLException {
        Class clazz = null;
        String string = this.getName();
        Class clazz2 = (Class)map.get(string);
        String string2 = this.getSchemaName();
        String string3 = this.getTypeName();
        if (clazz2 == null && this.m_conn.getUserName().equals(string2)) {
            clazz2 = (Class)map.get(string3);
        }
        if (!SQLName.s_parseAllFormat) {
            clazz = clazz2;
        } else {
            if (clazz2 == null && this.m_conn.getUserName().equals(string2)) {
                clazz2 = (Class)map.get("\"" + string3 + "\"");
            }
            if (clazz2 == null) {
                clazz2 = (Class)map.get("\"" + string2 + "\"" + "." + "\"" + string3 + "\"");
            }
            if (clazz2 == null) {
                clazz2 = (Class)map.get("\"" + string2 + "\"" + "." + string3);
            }
            if (clazz2 == null) {
                clazz2 = (Class)map.get(string2 + "." + "\"" + string3 + "\"");
            }
            clazz = clazz2;
        }
        return clazz;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }
}

