/*
 * Decompiled with CFR 0.152.
 */
package oracle.gss.util.CharConvBuilder;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import oracle.gss.util.CharConvBuilder.MappingSetter;
import oracle.sql.CharacterSet;

abstract class LCMapSetter
extends MappingSetter {
    static final int ENTRYWIDTH = 18;
    static final int MAXCHARVALUE = 65535;
    static final int LCWIDTH = 16;
    static final int LCSHIFT = 16;
    static final int LCMASK = 65535;
    static final int INVALIDLC = 65535;
    int m_l1BlockSize = 256;
    int m_ucsReplacement;
    char[] m_leadingCode;
    int m_lcCount;
    Vector[] m_mapStores;

    LCMapSetter(int n, int n2) {
        super(n);
        this.m_ucsReplacement = n2;
        this.m_leadingCode = new char[]{'\uffff', '\uffff', '\uffff', '\uffff'};
        this.m_mapStores = new Vector[this.m_leadingCode.length];
        this.m_lcCount = 0;
    }

    void buildMapping() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int[] nArray;
        int n6;
        Vector vector;
        int n7;
        int n8 = 8;
        int n9 = 8;
        int n10 = (1 << n8) - 1;
        int n11 = (1 << n9) - 1;
        int n12 = this.m_l1BlockSize * this.m_lcCount;
        char[] cArray = new char[n12];
        char[][] cArray2 = new char[n12][2];
        int n13 = 0;
        while (n13 < n12) {
            cArray[n13] = 65535;
            cArray2[n13][0] = (char)n11;
            cArray2[n13][1] = '\u0000';
            ++n13;
        }
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
        Hashtable hashtable2 = new Hashtable();
        int n14 = 0;
        while (n14 < this.m_lcCount) {
            n7 = this.m_l1BlockSize * n14;
            vector = this.m_mapStores[n14];
            n6 = vector.size();
            n13 = 0;
            while (n13 < n6) {
                nArray = (int[])vector.elementAt(n13);
                n5 = nArray[1];
                if (n5 != -1) {
                    n4 = nArray[0];
                    if (hashtable.get(new Integer(n5)) == null) {
                        hashtable.put(new Integer(n5), new Integer(n4));
                    } else {
                        hashtable2.put(new Integer(n5), hashtable.get(new Integer(n5)));
                    }
                    n3 = (n4 >> n9 & n10) + n7;
                    cArray[n3] = '\u0001';
                    n2 = n4 & n11;
                    if (n2 < cArray2[n3][0]) {
                        cArray2[n3][0] = (char)n2;
                    }
                    if (n2 > cArray2[n3][1]) {
                        cArray2[n3][1] = (char)n2;
                    }
                }
                ++n13;
            }
            ++n14;
        }
        int n15 = n = n11 + 1;
        int n16 = 0;
        n13 = 0;
        while (n13 < n12) {
            if (cArray[n13] != '\uffff') {
                int n17 = cArray2[n13][0];
                cArray[n13] = (char)(n15 - (n16 < n17 ? n16 : n17));
                n15 = cArray[n13] + n;
                n16 = n - cArray2[n13][1] - 1;
            }
            ++n13;
        }
        int[] nArray2 = new int[n15];
        n13 = 0;
        while (n13 < n15) {
            nArray2[n13] = -1;
            ++n13;
        }
        n14 = 0;
        while (n14 < this.m_lcCount) {
            n7 = this.m_l1BlockSize * n14;
            vector = this.m_mapStores[n14];
            n6 = vector.size();
            n13 = 0;
            while (n13 < n6) {
                nArray = (int[])vector.elementAt(n13);
                n5 = nArray[1];
                if (n5 != -1) {
                    n4 = nArray[0];
                    n3 = (n4 >> n9 & n10) + n7;
                    n2 = n4 & n11;
                    int n18 = cArray[n3] + n2;
                    nArray2[n18] = n5;
                }
                ++n13;
            }
            ++n14;
        }
        this.setArray2(nArray2);
        this.setArray(cArray);
        this.setLCTable();
        this.setDuplicateMapping(hashtable2);
    }

    void finish() {
        this.buildMapping();
        super.finish();
    }

    boolean set(int n, int n2) throws IOException {
        Vector<int[]> vector;
        int n3 = n >> 16 & 0xFFFF;
        int n4 = -1;
        int n5 = 0;
        while (n5 < this.m_lcCount) {
            if (n3 == this.m_leadingCode[n5]) {
                n4 = n5;
                break;
            }
            ++n5;
        }
        if (n4 == -1) {
            if (n5 < this.m_leadingCode.length) {
                this.m_leadingCode[n5] = (char)n3;
                n4 = n5;
                this.m_lcCount = n5 + 1;
            } else {
                this.printErrorMsg("***** Error: too many leading codes: " + MappingSetter.intToHex8(n3));
                return false;
            }
        }
        if ((vector = this.m_mapStores[n5]) == null) {
            this.m_mapStores[n5] = vector = new Vector<int[]>();
        }
        n2 = (int)CharacterSet.convertUTF32toUTF16((long)n2 & 0xFFFFFFFFL);
        int[] nArray = new int[]{n, n2};
        vector.addElement(nArray);
        return true;
    }

    abstract void setArray(char[] var1);

    abstract void setArray2(int[] var1);

    abstract void setDuplicateMapping(Hashtable var1);

    abstract void setLCTable();
}

