/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u0015\u0010\u0000\u001a\u00020\u0004*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0005\"\u0017\u0010\u0006\u001a\u0004\u0018\u00010\u0004*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\"\u0015\u0010\u0000\u001a\u00020\b*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\t\u00a8\u0006\n"}, d2={"realOverrideTarget", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getRealOverrideTarget", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "realOverrideTargetOrNull", "getRealOverrideTargetOrNull", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "(Lorg/jetbrains/kotlin/ir/declarations/IrProperty;)Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nIrResolveUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrResolveUtils.kt\norg/jetbrains/kotlin/ir/backend/js/utils/IrResolveUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,35:1\n1#2:36\n*E\n"})
public final class IrResolveUtilsKt {
    @NotNull
    public static final IrFunction getRealOverrideTarget(@NotNull IrFunction $this$realOverrideTarget) {
        IrFunction irFunction;
        Intrinsics.checkNotNullParameter($this$realOverrideTarget, "<this>");
        IrFunction irFunction2 = $this$realOverrideTarget;
        if (irFunction2 instanceof IrSimpleFunction) {
            irFunction = IrResolveUtilsKt.getRealOverrideTarget((IrSimpleFunction)$this$realOverrideTarget);
        } else if (irFunction2 instanceof IrConstructor) {
            irFunction = $this$realOverrideTarget;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return irFunction;
    }

    @NotNull
    public static final IrSimpleFunction getRealOverrideTarget(@NotNull IrSimpleFunction $this$realOverrideTarget) {
        Intrinsics.checkNotNullParameter($this$realOverrideTarget, "<this>");
        IrSimpleFunction irSimpleFunction = IrResolveUtilsKt.getRealOverrideTargetOrNull($this$realOverrideTarget);
        if (irSimpleFunction == null) {
            CompilationExceptionKt.compilationException("No real override target found", $this$realOverrideTarget);
            throw new KotlinNothingValueException();
        }
        return irSimpleFunction;
    }

    @Nullable
    public static final IrSimpleFunction getRealOverrideTargetOrNull(@NotNull IrSimpleFunction $this$realOverrideTargetOrNull) {
        IrSimpleFunction irSimpleFunction;
        Object v0;
        Set realOverrides;
        block2: {
            Intrinsics.checkNotNullParameter($this$realOverrideTargetOrNull, "<this>");
            realOverrides = IrFakeOverrideUtilsKt.collectRealOverrides$default($this$realOverrideTargetOrNull, null, null, 3, null);
            Iterable iterable = realOverrides;
            for (Object t2 : iterable) {
                IrSimpleFunction it = (IrSimpleFunction)t2;
                boolean bl = false;
                if (!(it.getModality() != Modality.ABSTRACT)) continue;
                v0 = t2;
                break block2;
            }
            v0 = null;
        }
        if ((irSimpleFunction = (IrSimpleFunction)v0) == null) {
            irSimpleFunction = (IrSimpleFunction)CollectionsKt.firstOrNull(realOverrides);
        }
        return irSimpleFunction;
    }

    @NotNull
    public static final IrProperty getRealOverrideTarget(@NotNull IrProperty $this$realOverrideTarget) {
        IrProperty irProperty;
        Object v0;
        Set realOverrides;
        block2: {
            Intrinsics.checkNotNullParameter($this$realOverrideTarget, "<this>");
            realOverrides = IrFakeOverrideUtilsKt.collectRealOverrides$default($this$realOverrideTarget, null, null, 3, null);
            Iterable iterable = realOverrides;
            for (Object t2 : iterable) {
                IrProperty it = (IrProperty)t2;
                boolean bl = false;
                if (!(it.getModality() != Modality.ABSTRACT)) continue;
                v0 = t2;
                break block2;
            }
            v0 = null;
        }
        if ((irProperty = (IrProperty)v0) == null && (irProperty = (IrProperty)CollectionsKt.firstOrNull(realOverrides)) == null) {
            CompilationExceptionKt.compilationException("No real override target found", $this$realOverrideTarget);
            throw new KotlinNothingValueException();
        }
        return irProperty;
    }
}

