/*
 * Decompiled with CFR 0.152.
 */
package test.hash;

import gnu.crypto.hash.IMessageDigest;
import gnu.crypto.hash.RipeMD160;
import gnu.crypto.util.Util;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestOfRipeMD160
extends TestCase {
    static /* synthetic */ Class class$test$hash$TestOfRipeMD160;

    public TestOfRipeMD160(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestOfRipeMD160.suite());
    }

    public static Test suite() {
        return new TestSuite(class$test$hash$TestOfRipeMD160 == null ? (class$test$hash$TestOfRipeMD160 = TestOfRipeMD160.class$("test.hash.TestOfRipeMD160")) : class$test$hash$TestOfRipeMD160);
    }

    public void testSelfTest() {
        try {
            RipeMD160 algorithm = new RipeMD160();
            Assert.assertTrue((String)"selfTest()", (boolean)algorithm.selfTest());
        }
        catch (Exception x) {
            Assert.fail((String)("selfTest(): " + String.valueOf(x)));
        }
    }

    public void testA() {
        try {
            RipeMD160 algorithm = new RipeMD160();
            algorithm.update("a".getBytes(), 0, 1);
            byte[] md = algorithm.digest();
            String exp = "0BDC9D2D256B3EE9DAAE347BE6F4DC835A467FFE";
            Assert.assertTrue((String)"testA()", (boolean)exp.equals(Util.toString((byte[])md)));
        }
        catch (Exception x) {
            Assert.fail((String)("testA(): " + String.valueOf(x)));
        }
    }

    public void testABC() {
        try {
            RipeMD160 algorithm = new RipeMD160();
            algorithm.update("abc".getBytes(), 0, 3);
            byte[] md = algorithm.digest();
            String exp = "8EB208F7E05D987A9B044A8E98C6B087F15A0BFC";
            Assert.assertTrue((String)"testABC()", (boolean)exp.equals(Util.toString((byte[])md)));
        }
        catch (Exception x) {
            Assert.fail((String)("testABC(): " + String.valueOf(x)));
        }
    }

    public void testMessageDigest() {
        try {
            RipeMD160 algorithm = new RipeMD160();
            algorithm.update("message digest".getBytes(), 0, 14);
            byte[] md = algorithm.digest();
            String exp = "5D0689EF49D2FAE572B881B123A85FFA21595F36";
            Assert.assertTrue((String)"testMessageDigest()", (boolean)exp.equals(Util.toString((byte[])md)));
        }
        catch (Exception x) {
            Assert.fail((String)("testMessageDigest(): " + String.valueOf(x)));
        }
    }

    public void testAlphabet() {
        try {
            RipeMD160 algorithm = new RipeMD160();
            algorithm.update("abcdefghijklmnopqrstuvwxyz".getBytes(), 0, 26);
            byte[] md = algorithm.digest();
            String exp = "F71C27109C692C1B56BBDCEB5B9D2865B3708DBC";
            Assert.assertTrue((String)"testAlphabet()", (boolean)exp.equals(Util.toString((byte[])md)));
        }
        catch (Exception x) {
            Assert.fail((String)("testAlphabet(): " + String.valueOf(x)));
        }
    }

    public void testCloning() {
        try {
            RipeMD160 algorithm = new RipeMD160();
            algorithm.update("a".getBytes(), 0, 1);
            IMessageDigest clone = (IMessageDigest)algorithm.clone();
            byte[] md = algorithm.digest();
            String exp = "0BDC9D2D256B3EE9DAAE347BE6F4DC835A467FFE";
            Assert.assertTrue((String)"testCloning()", (boolean)exp.equals(Util.toString((byte[])md)));
            clone.update("bc".getBytes(), 0, 2);
            md = clone.digest();
            exp = "8EB208F7E05D987A9B044A8E98C6B087F15A0BFC";
            Assert.assertTrue((String)"testCloning()", (boolean)exp.equals(Util.toString((byte[])md)));
        }
        catch (Exception x) {
            Assert.fail((String)("testCloning(): " + String.valueOf(x)));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

