/*
 * Decompiled with CFR 0.152.
 */
package test.hash;

import gnu.crypto.hash.IMessageDigest;
import gnu.crypto.hash.MD4;
import gnu.crypto.util.Util;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestOfMD4
extends TestCase {
    private IMessageDigest algorithm;
    static /* synthetic */ Class class$test$hash$TestOfMD4;

    public TestOfMD4(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestOfMD4.suite());
    }

    public static Test suite() {
        return new TestSuite(class$test$hash$TestOfMD4 == null ? (class$test$hash$TestOfMD4 = TestOfMD4.class$("test.hash.TestOfMD4")) : class$test$hash$TestOfMD4);
    }

    public void testSelfTest() {
        try {
            Assert.assertTrue((String)"selfTest()", (boolean)this.algorithm.selfTest());
        }
        catch (Exception x) {
            Assert.fail((String)("selfTest(): " + String.valueOf(x)));
        }
    }

    public void testA() {
        try {
            this.algorithm.update("a".getBytes(), 0, 1);
            byte[] md = this.algorithm.digest();
            String exp = "BDE52CB31DE33E46245E05FBDBD6FB24";
            Assert.assertTrue((String)"testA()", (boolean)exp.equals(Util.toString((byte[])md)));
        }
        catch (Exception x) {
            Assert.fail((String)("testA(): " + String.valueOf(x)));
        }
    }

    public void testABC() {
        try {
            this.algorithm.update("abc".getBytes(), 0, 3);
            byte[] md = this.algorithm.digest();
            String exp = "A448017AAF21D8525FC10AE87AA6729D";
            Assert.assertTrue((String)"testABC()", (boolean)exp.equals(Util.toString((byte[])md)));
        }
        catch (Exception x) {
            Assert.fail((String)("testABC(): " + String.valueOf(x)));
        }
    }

    public void testMessageDigest() {
        try {
            this.algorithm.update("message digest".getBytes(), 0, 14);
            byte[] md = this.algorithm.digest();
            String exp = "D9130A8164549FE818874806E1C7014B";
            Assert.assertTrue((String)"testMessageDigest()", (boolean)exp.equals(Util.toString((byte[])md)));
        }
        catch (Exception x) {
            Assert.fail((String)("testMessageDigest(): " + String.valueOf(x)));
        }
    }

    public void testAlphabet() {
        try {
            this.algorithm.update("abcdefghijklmnopqrstuvwxyz".getBytes(), 0, 26);
            byte[] md = this.algorithm.digest();
            String exp = "D79E1C308AA5BBCDEEA8ED63DF412DA9";
            Assert.assertTrue((String)"testAlphabet()", (boolean)exp.equals(Util.toString((byte[])md)));
        }
        catch (Exception x) {
            Assert.fail((String)("testAlphabet(): " + String.valueOf(x)));
        }
    }

    public void testAsciiSubset() {
        try {
            this.algorithm.update("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".getBytes(), 0, 62);
            byte[] md = this.algorithm.digest();
            String exp = "043F8582F241DB351CE627E153E7F0E4";
            Assert.assertTrue((String)"testAsciiSubset()", (boolean)exp.equals(Util.toString((byte[])md)));
        }
        catch (Exception x) {
            Assert.fail((String)("testAsciiSubset(): " + String.valueOf(x)));
        }
    }

    public void testEightyNumerics() {
        try {
            this.algorithm.update("12345678901234567890123456789012345678901234567890123456789012345678901234567890".getBytes(), 0, 80);
            byte[] md = this.algorithm.digest();
            String exp = "E33B4DDC9C38F2199C3E7B164FCC0536";
            Assert.assertTrue((String)"testEightyNumerics()", (boolean)exp.equals(Util.toString((byte[])md)));
        }
        catch (Exception x) {
            Assert.fail((String)("testEightyNumerics(): " + String.valueOf(x)));
        }
    }

    public void testCloning() {
        try {
            this.algorithm.update("a".getBytes(), 0, 1);
            IMessageDigest clone = (IMessageDigest)this.algorithm.clone();
            byte[] md = this.algorithm.digest();
            String exp = "BDE52CB31DE33E46245E05FBDBD6FB24";
            Assert.assertTrue((String)"testCloning()", (boolean)exp.equals(Util.toString((byte[])md)));
            clone.update("bc".getBytes(), 0, 2);
            md = clone.digest();
            exp = "A448017AAF21D8525FC10AE87AA6729D";
            Assert.assertTrue((String)"testABC()", (boolean)exp.equals(Util.toString((byte[])md)));
        }
        catch (Exception x) {
            Assert.fail((String)("testCloning(): " + String.valueOf(x)));
        }
    }

    protected void setUp() throws Exception {
        this.algorithm = new MD4();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

