/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.jce;

import gnu.crypto.jce.KeyPairGeneratorAdapter;
import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.util.HashMap;

public class DSSKeyPairGeneratorSpi
extends KeyPairGeneratorAdapter {
    public DSSKeyPairGeneratorSpi() {
        super("dss");
    }

    public void initialize(int keysize, SecureRandom random) {
        HashMap<String, Serializable> attributes = new HashMap<String, Serializable>();
        attributes.put("gnu.crypto.dss.L", new Integer(keysize));
        if (random != null) {
            attributes.put("gnu.crypto.dss.prng", random);
        }
        this.adaptee.setup(attributes);
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (params != null) {
            if (!(params instanceof DSAParameterSpec)) {
                throw new InvalidAlgorithmParameterException("params");
            }
            attributes.put("gnu.crypto.dss.params", params);
        }
        if (random != null) {
            attributes.put("gnu.crypto.dss.prng", random);
        }
        this.adaptee.setup(attributes);
    }
}

