/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.hash;

import gnu.crypto.Registry;
import gnu.crypto.hash.BaseHash;
import gnu.crypto.hash.IMessageDigest;
import gnu.crypto.hash.MD4;
import gnu.crypto.hash.MD5;
import gnu.crypto.hash.RipeMD128;
import gnu.crypto.hash.RipeMD160;
import gnu.crypto.hash.Sha160;
import gnu.crypto.hash.Whirlpool;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class HashFactory
implements Registry {
    private HashFactory() {
    }

    public static IMessageDigest getInstance(String name) {
        if (name == null) {
            return null;
        }
        name = name.trim();
        BaseHash result = null;
        if (name.equalsIgnoreCase("whirlpool")) {
            result = new Whirlpool();
        } else if (name.equalsIgnoreCase("ripemd128") || name.equalsIgnoreCase("ripemd-128")) {
            result = new RipeMD128();
        } else if (name.equalsIgnoreCase("ripemd160") || name.equalsIgnoreCase("ripemd-160")) {
            result = new RipeMD160();
        } else if (name.equalsIgnoreCase("sha-160") || name.equalsIgnoreCase("sha-1") || name.equalsIgnoreCase("sha1") || name.equalsIgnoreCase("sha")) {
            result = new Sha160();
        } else if (name.equalsIgnoreCase("md5")) {
            result = new MD5();
        } else if (name.equalsIgnoreCase("md4")) {
            result = new MD4();
        }
        if (result != null && !result.selfTest()) {
            throw new InternalError(result.name());
        }
        return result;
    }

    public static final Set getNames() {
        HashSet<String> hs = new HashSet<String>();
        hs.add("whirlpool");
        hs.add("ripemd128");
        hs.add("ripemd160");
        hs.add("sha-160");
        hs.add("md5");
        hs.add("md4");
        return Collections.unmodifiableSet(hs);
    }
}

