/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.sig.rsa;

import gnu.crypto.sig.IKeyPairGenerator;
import gnu.crypto.sig.rsa.GnuRSAPrivateKey;
import gnu.crypto.sig.rsa.GnuRSAPublicKey;
import gnu.crypto.util.PRNG;
import gnu.crypto.util.Prime;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.Map;

public class RSAKeyPairGenerator
implements IKeyPairGenerator {
    private static final String NAME = "rsa";
    private static final boolean DEBUG = true;
    private static final int debuglevel = 5;
    private static final PrintWriter err = new PrintWriter(System.out, true);
    private static final BigInteger ONE = BigInteger.ONE;
    private static final BigInteger TWO = new BigInteger("2");
    public static final String MODULUS_LENGTH = "gnu.crypto.rsa.L";
    public static final String SOURCE_OF_RANDOMNESS = "gnu.crypto.rsa.prng";
    public static final String RSA_PARAMETERS = "gnu.crypto.rsa.params";
    private static final int DEFAULT_MODULUS_LENGTH = 1024;
    private int L;
    private BigInteger e = BigInteger.valueOf(65537L);
    private SecureRandom rnd = null;

    private static void debug(String s) {
        err.println(">>> rsa: " + s);
    }

    public String name() {
        return NAME;
    }

    public void setup(Map attributes) {
        this.rnd = (SecureRandom)attributes.get(SOURCE_OF_RANDOMNESS);
        RSAKeyGenParameterSpec params = (RSAKeyGenParameterSpec)attributes.get(RSA_PARAMETERS);
        if (params != null) {
            this.L = params.getKeysize();
            this.e = params.getPublicExponent();
        } else {
            Integer l = (Integer)attributes.get(MODULUS_LENGTH);
            int n = this.L = l == null ? 1024 : l;
        }
        if (this.L < 1024) {
            throw new IllegalArgumentException(MODULUS_LENGTH);
        }
    }

    public KeyPair generate() {
        BigInteger q;
        BigInteger n;
        BigInteger p;
        int M = (this.L + 1) / 2;
        BigInteger lower = TWO.pow(M - 1);
        BigInteger upper = TWO.pow(M).subtract(ONE);
        byte[] kb = new byte[(M + 7) / 8];
        do {
            this.nextRandomBytes(kb);
        } while ((p = new BigInteger(1, kb).setBit(0)).compareTo(lower) < 0 || p.compareTo(upper) > 0 || !Prime.isProbablePrime(p) || !p.gcd(this.e).equals(ONE));
        do {
            this.nextRandomBytes(kb);
        } while ((n = p.multiply(q = new BigInteger(1, kb).setBit(0))).bitLength() != this.L || !Prime.isProbablePrime(q) || !q.gcd(this.e).equals(ONE));
        BigInteger phi = p.subtract(ONE).multiply(q.subtract(ONE));
        BigInteger d = this.e.modInverse(phi);
        GnuRSAPublicKey pubK = new GnuRSAPublicKey(n, this.e);
        GnuRSAPrivateKey secK = new GnuRSAPrivateKey(p, q, this.e, d);
        return new KeyPair(pubK, secK);
    }

    private void nextRandomBytes(byte[] buffer) {
        if (this.rnd != null) {
            this.rnd.nextBytes(buffer);
        } else {
            PRNG.nextBytes(buffer);
        }
    }
}

