/* Any copyright is dedicated to the Public Domain.
   http://creativecommons.org/publicdomain/zero/1.0/ */

Cu.import("resource://gre/modules/TelemetryLog.jsm", this);
Cu.import("resource://gre/modules/TelemetrySession.jsm", this);

const TEST_PREFIX = "TEST-";
const TEST_REGEX = new RegExp("^" + TEST_PREFIX);

function check_event(event, id, data)
{
  do_print("Checking message " + id);
  do_check_eq(event[0], id);
  do_check_true(event[1] > 0);

  if (data === undefined) {
    do_check_true(event.length == 2);
  } else {
    do_check_eq(event.length, data.length + 2);
    for (var i = 0; i < data.length; ++i) {
      do_check_eq(typeof(event[i + 2]), "string");
      do_check_eq(event[i + 2], data[i]);
    }
  }
}

function* run_test()
{
  yield TelemetrySession.setup();

  TelemetryLog.log(TEST_PREFIX + "1", ["val", 123, undefined]);
  TelemetryLog.log(TEST_PREFIX + "2", []);
  TelemetryLog.log(TEST_PREFIX + "3");

  var log = TelemetrySession.getPayload().log.filter(function(e) {
    // Only want events that were generated by the test.
    return TEST_REGEX.test(e[0]);
  });

  do_check_eq(log.length, 3);
  check_event(log[0], TEST_PREFIX + "1", ["val", "123", "undefined"]);
  check_event(log[1], TEST_PREFIX + "2", []);
  check_event(log[2], TEST_PREFIX + "3", undefined);
  do_check_true(log[0][1] <= log[1][1]);
  do_check_true(log[1][1] <= log[2][1]);

  yield TelemetrySession.shutdown();
}
