
/* -*- Mode: C++; tab-width: 20; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/*
 * Derived from the Unicode Character Database by genUnicodePropertyData.pl
 *
 * For Unicode terms of use, see http://www.unicode.org/terms_of_use.html
 */

/*
 * Created on Wed Oct 26 09:12:45 2016 from UCD data files with version info:
 *

# Date: 2015-06-16, 20:24:00 GMT [KW]
#
# Unicode Character Database
# Copyright (c) 1991-2015 Unicode, Inc.
# For terms of use, see http://www.unicode.org/terms_of_use.html
#
# For documentation, see the following:
# NamesList.html
# UAX #38, "Unicode Han Database (Unihan)"
# UAX #44, "Unicode Character Database."
#
# The UAXes can be accessed at http://www.unicode.org/versions/Unicode8.0.0/

This directory contains the final data files
for the Unicode Character Database, for Version 8.0.0 of the Unicode
Standard.


# Scripts-8.0.0.txt
# Date: 2015-03-11, 22:29:42 GMT [MD]

# BidiMirroring-8.0.0.txt
# Date: 2015-01-20, 18:30:00 GMT [KW, LI]

# BidiBrackets-8.0.0.txt
# Date: 2015-01-20, 19:00:00 GMT [AG, LI, KW]

# HangulSyllableType-8.0.0.txt
# Date: 2014-12-16, 23:07:45 GMT [MD]

# LineBreak-8.0.0.txt
# Date: 2015-02-13, 09:15:00 GMT [KW, LI]

# EastAsianWidth-8.0.0.txt
# Date: 2015-02-10, 21:00:00 GMT [KW, LI]

# File: xidmodifications.txt
# Version: 8.0.0
# Generated: 2015-05-17, 03:09:04 GMT

#
# Unihan_Variants.txt
# Date: 2015-04-30 18:38:20 GMT [JHJ]

# VerticalOrientation-13.txt
# Date: 2014-09-03, 17:30:00 GMT [EM, KI, LI]

 *
 * * * * * This file contains MACHINE-GENERATED DATA, do not edit! * * * * *
 */

#include <stdint.h>
#include "harfbuzz/hb.h"

#if !ENABLE_INTL_API
static const uint32_t sScriptCodeToTag[] = {
  HB_TAG('Z','y','y','y'),
  HB_TAG('Z','i','n','h'),
  HB_TAG('A','r','a','b'),
  HB_TAG('A','r','m','n'),
  HB_TAG('B','e','n','g'),
  HB_TAG('B','o','p','o'),
  HB_TAG('C','h','e','r'),
  HB_TAG('C','o','p','t'),
  HB_TAG('C','y','r','l'),
  HB_TAG('D','s','r','t'),
  HB_TAG('D','e','v','a'),
  HB_TAG('E','t','h','i'),
  HB_TAG('G','e','o','r'),
  HB_TAG('G','o','t','h'),
  HB_TAG('G','r','e','k'),
  HB_TAG('G','u','j','r'),
  HB_TAG('G','u','r','u'),
  HB_TAG('H','a','n','i'),
  HB_TAG('H','a','n','g'),
  HB_TAG('H','e','b','r'),
  HB_TAG('H','i','r','a'),
  HB_TAG('K','n','d','a'),
  HB_TAG('K','a','n','a'),
  HB_TAG('K','h','m','r'),
  HB_TAG('L','a','o','o'),
  HB_TAG('L','a','t','n'),
  HB_TAG('M','l','y','m'),
  HB_TAG('M','o','n','g'),
  HB_TAG('M','y','m','r'),
  HB_TAG('O','g','a','m'),
  HB_TAG('I','t','a','l'),
  HB_TAG('O','r','y','a'),
  HB_TAG('R','u','n','r'),
  HB_TAG('S','i','n','h'),
  HB_TAG('S','y','r','c'),
  HB_TAG('T','a','m','l'),
  HB_TAG('T','e','l','u'),
  HB_TAG('T','h','a','a'),
  HB_TAG('T','h','a','i'),
  HB_TAG('T','i','b','t'),
  HB_TAG('C','a','n','s'),
  HB_TAG('Y','i','i','i'),
  HB_TAG('T','g','l','g'),
  HB_TAG('H','a','n','o'),
  HB_TAG('B','u','h','d'),
  HB_TAG('T','a','g','b'),
  HB_TAG('B','r','a','i'),
  HB_TAG('C','p','r','t'),
  HB_TAG('L','i','m','b'),
  HB_TAG('L','i','n','b'),
  HB_TAG('O','s','m','a'),
  HB_TAG('S','h','a','w'),
  HB_TAG('T','a','l','e'),
  HB_TAG('U','g','a','r'),
  HB_TAG('H','r','k','t'),
  HB_TAG('B','u','g','i'),
  HB_TAG('G','l','a','g'),
  HB_TAG('K','h','a','r'),
  HB_TAG('S','y','l','o'),
  HB_TAG('T','a','l','u'),
  HB_TAG('T','f','n','g'),
  HB_TAG('X','p','e','o'),
  HB_TAG('B','a','l','i'),
  HB_TAG('B','a','t','k'),
  HB_TAG('B','l','i','s'),
  HB_TAG('B','r','a','h'),
  HB_TAG('C','h','a','m'),
  HB_TAG('C','i','r','t'),
  HB_TAG('C','y','r','s'),
  HB_TAG('E','g','y','d'),
  HB_TAG('E','g','y','h'),
  HB_TAG('E','g','y','p'),
  HB_TAG('G','e','o','k'),
  HB_TAG('H','a','n','s'),
  HB_TAG('H','a','n','t'),
  HB_TAG('H','m','n','g'),
  HB_TAG('H','u','n','g'),
  HB_TAG('I','n','d','s'),
  HB_TAG('J','a','v','a'),
  HB_TAG('K','a','l','i'),
  HB_TAG('L','a','t','f'),
  HB_TAG('L','a','t','g'),
  HB_TAG('L','e','p','c'),
  HB_TAG('L','i','n','a'),
  HB_TAG('M','a','n','d'),
  HB_TAG('M','a','y','a'),
  HB_TAG('M','e','r','o'),
  HB_TAG('N','k','o','o'),
  HB_TAG('O','r','k','h'),
  HB_TAG('P','e','r','m'),
  HB_TAG('P','h','a','g'),
  HB_TAG('P','h','n','x'),
  HB_TAG('P','l','r','d'),
  HB_TAG('R','o','r','o'),
  HB_TAG('S','a','r','a'),
  HB_TAG('S','y','r','e'),
  HB_TAG('S','y','r','j'),
  HB_TAG('S','y','r','n'),
  HB_TAG('T','e','n','g'),
  HB_TAG('V','a','i','i'),
  HB_TAG('V','i','s','p'),
  HB_TAG('X','s','u','x'),
  HB_TAG('Z','x','x','x'),
  HB_TAG('Z','z','z','z'),
  HB_TAG('C','a','r','i'),
  HB_TAG('J','p','a','n'),
  HB_TAG('L','a','n','a'),
  HB_TAG('L','y','c','i'),
  HB_TAG('L','y','d','i'),
  HB_TAG('O','l','c','k'),
  HB_TAG('R','j','n','g'),
  HB_TAG('S','a','u','r'),
  HB_TAG('S','g','n','w'),
  HB_TAG('S','u','n','d'),
  HB_TAG('M','o','o','n'),
  HB_TAG('M','t','e','i'),
  HB_TAG('A','r','m','i'),
  HB_TAG('A','v','s','t'),
  HB_TAG('C','a','k','m'),
  HB_TAG('K','o','r','e'),
  HB_TAG('K','t','h','i'),
  HB_TAG('M','a','n','i'),
  HB_TAG('P','h','l','i'),
  HB_TAG('P','h','l','p'),
  HB_TAG('P','h','l','v'),
  HB_TAG('P','r','t','i'),
  HB_TAG('S','a','m','r'),
  HB_TAG('T','a','v','t'),
  HB_TAG('Z','m','t','h'),
  HB_TAG('Z','s','y','m'),
  HB_TAG('B','a','m','u'),
  HB_TAG('L','i','s','u'),
  HB_TAG('N','k','g','b'),
  HB_TAG('S','a','r','b'),
  HB_TAG('B','a','s','s'),
  HB_TAG('D','u','p','l'),
  HB_TAG('E','l','b','a'),
  HB_TAG('G','r','a','n'),
  HB_TAG('K','p','e','l'),
  HB_TAG('L','o','m','a'),
  HB_TAG('M','e','n','d'),
  HB_TAG('M','e','r','c'),
  HB_TAG('N','a','r','b'),
  HB_TAG('N','b','a','t'),
  HB_TAG('P','a','l','m'),
  HB_TAG('S','i','n','d'),
  HB_TAG('W','a','r','a'),
  HB_TAG('A','f','a','k'),
  HB_TAG('J','u','r','c'),
  HB_TAG('M','r','o','o'),
  HB_TAG('N','s','h','u'),
  HB_TAG('S','h','r','d'),
  HB_TAG('S','o','r','a'),
  HB_TAG('T','a','k','r'),
  HB_TAG('T','a','n','g'),
  HB_TAG('W','o','l','e'),
  HB_TAG('H','l','u','w'),
  HB_TAG('K','h','o','j'),
  HB_TAG('T','i','r','h'),
  HB_TAG('A','g','h','b'),
  HB_TAG('M','a','h','j'),
  HB_TAG('A','h','o','m'),
  HB_TAG('H','a','t','r'),
  HB_TAG('M','o','d','i'),
  HB_TAG('M','u','l','t'),
  HB_TAG('P','a','u','c'),
  HB_TAG('S','i','d','d')
};
#endif

#if !ENABLE_INTL_API
static const int16_t sMirrorOffsets[] = {
  0,
  1,
  -1,
  2,
  -2,
  16,
  -16,
  3,
  -3,
  2016,
  138,
  1824,
  2104,
  2108,
  2106,
  -138,
  8,
  7,
  -8,
  -7,
  -1824,
  -2016,
  -2104,
  -2106,
  -2108
};
#endif


#if !ENABLE_INTL_API
#define kCharProp1MaxPlane  1
#define kCharProp1IndexBits 11
#define kCharProp1CharBits  5
static const uint8_t sCharProp1Planes[1] = {1};

static const uint8_t sCharProp1Pages[2][2048] = {
  {0,1,2,2,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,5,6,7,0,0,0,0,0,0,0,0,8,0,0,0,0,0,0,0,9,10,11,0,12,0,13,14,0,0,15,16,17,18,19,0,0,0,0,20,21,22,23,0,0,0,0,24,0,25,26,0,0,25,27,0,0,25,27,0,0,25,27,0,0,25,27,0,0,0,27,0,0,0,28,0,0,25,27,0,0,0,27,0,0,0,29,0,0,30,31,0,0,32,33,0,34,35,0,36,37,0,38,0,0,39,0,0,40,0,0,0,41,41,41,42,42,43,44,44,0,0,0,0,0,0,0,0,0,0,45,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,0,0,0,47,47,0,0,0,0,48,0,0,0,0,0,0,49,0,0,0,50,0,0,0,0,0,0,51,0,0,52,0,53,0,0,0,54,55,56,0,57,0,58,0,59,0,0,0,0,60,61,0,0,0,0,0,0,62,63,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,65,66,67,0,68,69,0,0,0,0,0,0,0,0,70,71,72,73,74,75,76,77,78,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,0,0,81,82,0,0,0,0,0,0,0,0,0,0,0,0,83,84,85,86,0,87,0,88,89,90,91,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,93,0,0,0,94,0,0,0,95,96,97,0,0,0,0,0,0,0,0,0,0,0,0,0,0,98,99,0,0,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,101,102,0,0,103,0,0,0,0,0,0,0,0,104,0,0,0,0,0,55,105,0,106,107,108,0,109,110,0,0,0,0,0,0,111,112,113,0,0,0,0,0,0,0,27,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,120,114,115,116,117,118,119,121,122,123,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,126,127,0,0,0,0,1,2,128,129,0,0,0,0},
  {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,130,0,0,0,0,0,0,0,131,0,0,0,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,133,134,0,0,0,0,0,135,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,94,0,136,0,0,137,138,0,109,0,0,139,0,0,140,0,0,0,0,0,141,0,25,27,142,0,0,0,0,0,0,0,0,0,0,143,0,0,0,0,0,0,94,144,0,0,94,0,0,0,145,0,0,0,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,147,0,148,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,149,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,150,151,152,0,0,0,0,153,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,154,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
};

static const nsCharProps1 sCharProp1Values[155][32] = {
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {3,0,0}, {0,0,0}, {4,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {3,0,0}, {0,0,0}, {4,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {5,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {6,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,232}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,232}, {0,0,216}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220},},
  {{0,0,220}, {0,0,202}, {0,0,202}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,202}, {0,0,202}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,1}, {0,0,1}, {0,0,1}, {0,0,1}, {0,0,1}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,230},},
  {{0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,240}, {0,0,230}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,220}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,230}, {0,0,232}, {0,0,220}, {0,0,220}, {0,0,230}, {0,0,233}, {0,0,234}, {0,0,234}, {0,0,233},},
  {{0,0,234}, {0,0,234}, {0,0,233}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,222}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230},},
  {{0,0,230}, {0,0,230}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,222}, {0,0,228}, {0,0,230}, {0,0,10}, {0,0,11}, {0,0,12}, {0,0,13}, {0,0,14}, {0,0,15}, {0,0,16}, {0,0,17}, {0,0,18}, {0,0,19}, {0,0,19}, {0,0,20}, {0,0,21}, {0,0,22}, {0,0,0}, {0,0,23},},
  {{0,0,0}, {0,0,24}, {0,0,25}, {0,0,0}, {0,0,230}, {0,0,220}, {0,0,0}, {0,0,18}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,30}, {0,0,31}, {0,0,32}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,27}, {0,0,28}, {0,0,29}, {0,0,30}, {0,0,31}, {0,0,32}, {0,0,33}, {0,0,34}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,220},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,35}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,230},},
  {{0,0,230}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,36}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,230}, {0,0,220}, {0,0,220}, {0,0,230}, {0,0,220}, {0,0,230},},
  {{0,0,230}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230},},
  {{0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,27}, {0,0,28}, {0,0,29}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,7}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,84}, {0,0,91}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,103}, {0,0,103}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,107}, {0,0,107}, {0,0,107}, {0,0,107}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,118}, {0,0,118}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,122}, {0,0,122}, {0,0,122}, {0,0,122}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,220}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,220}, {0,0,0}, {0,0,220}, {0,0,0}, {0,0,216}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,129}, {0,0,130}, {0,0,0}, {0,0,132}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,130}, {0,0,130}, {0,0,130}, {0,0,130}, {0,0,0}, {0,0,0},},
  {{0,0,130}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,9}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,7}, {0,0,0}, {0,0,9}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0},},
  {{0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0},},
  {{0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0},},
  {{0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,228}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,222}, {0,0,230}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,220},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,7}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,7}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,7}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,1}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220},},
  {{0,0,230}, {0,0,0}, {0,0,1}, {0,0,1}, {0,0,1}, {0,0,1}, {0,0,1}, {0,0,1}, {0,0,1}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,230}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,234}, {0,0,214}, {0,0,220}, {0,0,202}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230},},
  {{0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,233}, {0,0,220}, {0,0,230}, {0,0,220},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,1}, {0,0,1}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,1}, {0,0,1}, {0,0,1}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,1}, {0,0,1}, {0,0,230}, {0,0,220}, {0,0,230}, {0,0,1}, {0,0,1}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {7,0,0}, {7,0,0}, {7,0,0}, {8,0,0}, {8,0,0}, {8,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {9,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {10,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0},},
  {{1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {11,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {12,0,0}, {0,0,0}, {13,0,0}, {14,0,0}, {0,0,0}, {14,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {15,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0},},
  {{1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {16,0,0}, {16,0,0}, {16,0,0}, {0,0,0}, {17,0,0}, {17,0,0}, {0,0,0}, {0,0,0}, {18,0,0}, {18,0,0}, {18,0,0}, {19,0,0}, {19,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {3,0,0}, {0,0,0}, {4,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {7,0,0}, {1,0,0}, {2,0,0}, {8,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {20,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {21,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0},},
  {{2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0},},
  {{2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {22,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {23,0,0}, {24,0,0}, {23,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9},},
  {{0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230},},
  {{0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0},},
  {{1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,218}, {0,0,228}, {0,0,232}, {0,0,222}, {0,0,224}, {0,0,224}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,8}, {0,0,8}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,1,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,7}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230},},
  {{0,0,0}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,3,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,3,0}, {0,7,0}, {0,7,0}, {0,7,0},},
  {{0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,3,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0},},
  {{0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,3,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0},},
  {{0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,3,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0},},
  {{0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,3,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0},},
  {{0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,3,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0},},
  {{0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,3,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,7,0},},
  {{0,7,0}, {0,7,0}, {0,7,0}, {0,7,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0},},
  {{0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,2,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0},},
  {{0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,4,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,26}, {0,0,0},},
  {{0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {1,0,0}, {2,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {3,0,0}, {0,0,0}, {4,0,0}, {0,0,0}, {1,0,0},},
  {{2,0,0}, {0,0,0}, {1,0,0}, {2,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,220}, {0,0,0}, {0,0,0},},
  {{0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,220}, {0,0,0}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,1}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,7}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,7}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,7}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,7}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,9}, {0,0,7}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,7}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,7}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,9}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,1}, {0,0,1}, {0,0,1}, {0,0,1}, {0,0,1}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,1}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,216}, {0,0,216}, {0,0,1}, {0,0,1}, {0,0,1}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,226}, {0,0,216}, {0,0,216}, {0,0,216}, {0,0,216}, {0,0,216}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220},},
  {{0,0,220}, {0,0,220}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,220}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,230}, {0,0,230}, {0,0,230}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},},
  {{0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,220}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0}, {0,0,0},}
};
#endif

#if ENABLE_INTL_API
#define kCharProp2MaxPlane  16
#define kCharProp2IndexBits 9
#define kCharProp2CharBits  7
static const uint8_t sCharProp2Planes[16] = {1,2,3,4,4,4,4,4,4,4,4,4,4,5,3,3};

static const uint8_t sCharProp2Pages[6][512] = {
  {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,41,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,67,72,73,74,75,76,67,67,67,67,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,87,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,97,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,98,41,41,41,41,41,41,41,41,41,99,100,100,101,102,103,104,105,106,107,108,109,110,111,112,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,113,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,87,87,116,117,118,119,120,120,121,122,123,124,125,126},
  {127,128,129,130,114,131,132,133,134,135,136,114,134,134,137,114,138,139,140,141,142,143,144,145,146,147,114,114,148,114,114,114,149,150,151,152,153,154,155,114,114,156,114,157,158,159,160,114,114,161,114,114,114,162,114,114,114,114,114,114,114,114,114,114,134,134,134,134,134,134,134,163,164,134,165,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,166,166,166,166,166,166,166,166,167,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,134,134,134,134,168,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,100,100,100,100,169,170,171,172,114,114,114,114,114,114,173,174,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,175,115,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,176,177,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,74,178,179,180,181,114,182,114,183,184,185,120,120,186,120,187,67,67,67,67,188,189,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,134,190,114,114,114,114,114,114,114,114,114,114,191,192,114,114,193,194,195,196,197,115,74,74,74,74,198,199,74,200,201,202,203,204,205,206,114,114,114,114,114,114,114,114,114,114,114,114},
  {96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,207,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,208,96,209,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,96,210,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,87,87,87,87,211,115,115,115,115,115,115,115,115,115,115,212},
  {115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,212},
  {114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114},
  {213,114,214,215,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114,114}
};

static const nsCharProps2 sCharProp2Values[216][128] = {
  {{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,1},{1,8},{1,8},{1,8},{1,8},{1,8},{1,1},{1,1},{1,8},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,8},{1,8},{1,8},{1,8},{1,0},{1,8},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,8},{1,8},{1,8},{1,8},{1,12}},
  {{1,12},{1,12},{1,12},{1,12},{1,12},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,9},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{0,8},{1,9},{0,8},{1,9},{1,8},{1,8},{1,10},{0,8},{1,9},{1,8},{0,8},{1,9},{1,9},{1,9},{1,9},{1,8},{1,1},{1,9},{1,9},{1,9},{1,8},{0,9},{0,9},{0,9},{1,8},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{0,8},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{0,8},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,9},{1,9},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,9},{1,9},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,11},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,9}},
  {{1,3},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,4},{1,2},{1,0},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,0},{1,0},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,4},{1,4},{1,2},{1,2},{1,2},{1,0},{1,0},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,4},{1,4},{1,4},{1,2},{1,2},{1,4},{1,4},{1,3},{1,3},{1,3},{1,3},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,2},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,2},{1,2},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,9},{1,9},{1,9},{1,0},{1,0},{1,4},{1,4},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,4},{1,4},{1,0},{1,0},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,3},{1,3},{1,3},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,3},{1,3},{1,3},{1,2},{1,2},{1,3},{1,2},{1,2},{1,3},{1,0},{1,3},{1,2},{1,3},{1,3},{1,3},{1,4},{1,2},{1,3},{1,3},{1,2},{1,3},{1,3},{1,3},{1,3},{1,2},{1,2},{1,3},{1,3},{1,3},{1,3},{1,3},{1,2},{1,3},{1,3},{1,2},{1,3},{1,3},{1,2},{1,3},{1,4},{1,3},{1,3},{1,3},{1,3},{1,4},{1,3},{1,3},{1,3}},
  {{1,2},{1,3},{1,3},{1,2},{1,3},{1,3},{1,3},{1,3},{1,2},{1,3},{1,2},{1,2},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,2},{1,3},{1,2},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,4},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,3},{1,3},{1,0},{1,0},{1,3},{1,3},{1,3},{1,3},{1,3},{1,8},{1,8},{1,8},{1,8},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,8},{1,8},{1,9},{1,9},{1,9},{1,9},{1,9},{1,8},{1,8},{1,8},{1,8},{1,8},{0,8},{0,8},{1,0},{1,8},{1,3},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,2},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,2},{1,3},{1,0},{1,0},{1,0},{1,3},{1,0},{1,0},{1,3},{1,2},{1,3},{1,3},{1,3},{1,3},{1,0},{1,3},{1,3},{1,3},{1,3},{1,3},{1,2},{1,2},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,3},{1,3},{1,3},{1,3},{1,0},{1,0},{1,3},{1,0},{1,0},{1,2},{1,3},{1,2},{1,0},{1,2},{1,3},{1,0},{1,0},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,9},{1,9},{1,0},{1,9},{1,9},{1,0},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,10},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,2},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,9},{1,1},{1,4},{1,4},{1,12},{1,12},{1,9},{1,0},{1,0},{1,0},{1,9},{1,4}},
  {{1,12},{1,12},{1,12},{1,12},{1,9},{1,9},{1,0},{1,9},{1,0},{1,0},{1,0},{1,12},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,3},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,3},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,9},{1,9},{1,9},{1,4},{1,9},{1,9},{1,8},{1,4},{1,4},{1,9},{1,4},{1,4},{1,0},{1,0},{1,0},{1,0}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4}},
  {{1,4},{1,4},{1,8},{1,4},{1,4},{1,4},{1,4},{1,4},{1,8},{1,8},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,4},{1,4},{1,4},{1,4},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,0},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,9},{1,12},{1,8},{1,1},{1,12},{1,12},{1,8},{1,8},{1,8},{1,12},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,4},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,0},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,8},{1,2},{1,8},{1,2},{1,2},{1,8},{1,2},{1,4},{1,8},{1,4},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,12},{1,12},{1,12},{1,0},{1,0},{1,0},{1,1},{1,1},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,8},{1,10},{1,12},{1,8},{1,8},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,7},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,8},{1,8},{1,8},{1,8},{1,4},{1,4},{1,0},{1,0},{1,0},{1,11},{1,0},{1,9},{1,9},{1,9},{1,9},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,4},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,8},{1,0},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,8},{1,8},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,0},{1,0},{1,2},{1,2},{1,8},{1,2},{1,2},{1,2},{1,2},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,1},{1,1},{1,0}},
  {{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,8},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,12},{1,12},{1,6},{1,6},{1,6},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,8},{1,8},{1,8},{1,8},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,12},{1,12},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,4},{1,4},{1,4},{1,4},{1,4},{1,0},{1,2},{1,2},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2}},
  {{1,2},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,4},{1,0},{1,0},{1,4},{1,4},{1,3},{1,3},{1,2},{1,0},{1,0},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,0},{1,0},{1,0},{1,0},{1,8},{1,8},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,8},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,4},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,4},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,0},{1,0},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,12},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,0},{1,0},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,0},{1,12},{1,12},{1,12},{1,12},{1,9},{1,9},{1,12},{1,9},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12}},
  {{1,12},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,12},{1,12},{1,0},{1,0},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,9},{1,12},{1,0},{1,9},{1,12},{1,0},{1,0},{1,12},{1,12},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,12},{1,12},{1,0},{1,0},{1,12},{1,12},{1,0},{1,0},{1,0},{1,12},{1,12},{1,12},{1,2},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,9},{1,9},{1,9},{1,0},{1,12},{1,9},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,2},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,12},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,12},{1,12},{1,0},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,2},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,12},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,0},{1,0},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,2},{1,12},{1,12},{1,0},{1,0},{1,12},{1,12},{1,0},{1,0},{1,0},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,0},{1,0},{1,12},{1,12},{1,12},{1,12},{1,9},{1,9},{1,12},{1,0},{1,0},{1,0},{1,2},{1,2},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,8},{1,0},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,12},{1,12},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,12},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,12},{1,0},{1,0},{1,12},{1,0},{1,12},{1,0},{1,0},{1,12},{1,12},{1,12},{1,0},{1,0},{1,12},{1,12},{1,12},{1,0},{1,0},{1,0},{1,12},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,12},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,0},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,0},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,4},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,4},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,0},{1,0},{1,12},{1,4},{1,4},{1,2},{1,12},{1,12},{1,12},{1,12},{1,12},{1,0},{1,0},{1,2},{1,2},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8}},
  {{1,12},{1,4},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,0},{1,0},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,4},{1,12},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,12},{1,4},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,2},{1,12},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,0},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,4},{1,0},{1,0},{1,2},{1,2},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,8},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,12},{1,12},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,3},{1,3},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,3},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,12},{1,0},{1,12},{1,12},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,3},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,12},{1,12},{1,0},{1,3},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,9},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,12},{1,12},{1,8},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,8},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,12},{1,0},{1,0},{1,12},{1,0},{1,12},{1,12},{1,0},{1,0},{1,12},{1,0},{1,12},{1,12},{1,0},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,12},{1,0},{1,12},{1,0},{1,12},{1,12},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,9},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,9},{1,9},{1,0},{1,0},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,0},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,1},{1,9},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,3},{1,3},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,0},{1,8},{1,0},{1,8},{1,2},{1,8},{1,8},{1,8},{1,8},{1,0},{1,0},{1,0},{1,0},{1,0},{1,9},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,9},{1,0},{1,0},{1,0},{1,0},{1,9},{1,0},{1,0},{1,0},{1,0},{1,9},{1,0},{1,0},{1,0},{1,0},{1,9},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,9},{1,0},{1,0},{1,0},{1,12},{1,12},{1,12},{1,12},{1,0},{1,0},{1,9},{1,0},{1,9},{1,9},{1,11},{1,9},{1,11},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,0},{1,9},{1,0},{1,0},{1,0},{1,8},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,9},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,9},{1,0},{1,0},{1,0},{1,0},{1,9},{1,0},{1,0},{1,0},{1,0},{1,9},{1,0},{1,0},{1,0},{1,0},{1,9},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,9},{1,0},{1,0},{1,0},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,0},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,8},{1,8},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,12},{1,0},{1,12},{1,12},{1,12},{1,12},{1,12},{1,0},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,0},{1,0},{1,0},{1,0},{1,8},{1,9},{1,0},{1,0},{1,0}},
  {{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,10},{0,10},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4}},
  {{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,0},{1,0},{1,0},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,12},{1,12},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,12},{1,12}},
  {{1,8},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5}},
  {{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5}},
  {{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,8},{0,8},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5}},
  {{1,8},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,8},{1,8},{1,12},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,8},{1,8},{1,8},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,7},{1,7},{1,7},{1,12},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,11},{1,11},{1,0},{1,0},{1,0},{1,4},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,10},{1,10},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,4},{1,0},{1,4},{1,8},{1,8},{1,8},{1,0},{1,8},{1,8},{1,8},{1,8},{1,0},{1,4},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,10},{1,10},{1,10},{1,10},{1,12},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,12},{1,12},{1,12},{1,12},{1,12},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12}},
  {{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,12},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,12},{1,12},{1,12},{1,12},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,12},{1,12},{1,12},{1,12},{1,8},{1,12},{1,12},{1,12},{1,8},{1,8},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,12},{1,12},{1,6},{1,6},{1,6},{1,6},{1,6},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,12},{1,12},{1,12},{1,12},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,12},{1,12},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,8},{1,8},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,12},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,12},{1,12},{1,6}},
  {{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,6},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,12},{1,12},{1,12},{1,12},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12}},
  {{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,8},{1,8},{1,8},{1,8}},
  {{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,12},{1,12},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,12},{1,12},{1,12},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,8},{1,8}},
  {{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,4},{1,4},{1,4},{1,8},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,12},{1,4},{1,4},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,9},{1,9},{1,9},{1,3},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,3},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,3},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,9},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3}},
  {{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,4},{1,4},{1,4},{1,4},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,4},{1,3},{1,3},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,3},{1,3},{1,3},{1,3}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,9},{1,9},{1,3},{1,3},{1,0},{1,3},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,12},{1,0},{1,12},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,9},{1,0},{1,9},{1,0},{1,9},{1,0},{1,9},{1,0},{1,9},{1,0},{1,9},{1,0},{1,9},{1,12},{1,12}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,9},{1,0},{1,9},{1,9},{1,9},{1,9},{1,9},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,9},{1,0},{1,9},{1,0},{1,9},{1,9},{1,9},{1,0},{1,0},{1,0},{1,9},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,9},{1,12},{1,9},{1,9},{1,9},{1,0},{1,0},{1,0},{1,9},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,9},{1,0},{1,9},{1,9},{1,9},{1,12},{1,12},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,9},{1,0},{1,9},{1,0},{1,9},{1,9},{1,12}},
  {{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,10},{1,1},{1,1},{1,10},{1,10},{1,1},{1,9},{1,8},{1,8},{1,8},{1,8},{0,8},{1,9},{1,8},{1,1},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{0,8},{0,8},{1,8},{1,8},{1,9},{1,9},{1,9},{1,1},{1,8},{1,8},{1,10},{1,10},{1,10},{1,10},{1,10},{1,9},{0,8},{0,8},{1,8},{1,9},{1,9},{1,8},{1,9},{1,9},{1,8},{1,8},{1,8},{0,8},{0,9},{1,8},{1,9},{1,3},{1,3},{1,8},{0,8},{1,8},{1,8},{1,8},{1,8},{0,9},{0,9},{0,9},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{0,8},{1,8},{1,8},{1,2},{1,8},{1,8},{1,9},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,9},{1,10},{1,10},{1,10},{1,10},{1,10},{0,12},{1,10},{1,10},{1,10},{1,10},{1,11},{1,11},{1,11},{1,11},{1,11},{1,11},{1,9},{1,9},{1,12},{1,12},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9}},
  {{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,12},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,12},{1,12},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,9},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{0,8},{0,8},{0,8},{0,8},{1,7},{0,8},{0,8},{0,8},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{0,9},{0,9},{1,9},{0,9},{0,8},{0,9},{0,9},{0,9},{0,8},{0,9},{1,9},{1,9},{1,9},{1,9},{1,9},{0,9},{1,9},{1,9},{1,9},{0,9},{0,8},{1,9},{0,9},{0,8},{1,3},{1,9},{1,9},{1,9},{1,9},{1,9},{0,8},{0,8},{0,9},{0,9},{0,9},{0,8},{1,9},{0,8},{1,9},{0,8},{1,9},{0,8},{1,9},{1,9},{1,9},{1,9},{0,3},{1,9},{1,9},{1,9},{1,4},{1,9},{1,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,8},{0,9},{0,9},{0,9},{0,9},{0,9},{1,9},{1,8},{1,8},{1,8},{1,8},{0,9},{0,9},{0,9},{0,9},{0,9},{0,8},{1,8},{0,8},{0,8},{1,4},{0,8},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9}},
  {{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,9},{0,8},{0,8},{0,12},{0,12},{0,12},{0,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8}},
  {{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{0,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,9},{1,9},{1,8},{1,9},{1,9},{1,8},{1,8},{1,8},{0,8},{0,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8}},
  {{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8}},
  {{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{1,8},{1,8},{1,8},{1,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{1,8},{1,8},{1,8},{1,8},{0,8},{0,8},{0,8},{0,8},{0,8},{3,11},{3,11},{0,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{0,8},{0,8},{0,8}},
  {{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{1,8},{0,8},{1,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,12},{0,12},{0,12},{0,12},{0,12}},
  {{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{1,8},{0,8},{0,8},{0,8},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9}},
  {{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8}},
  {{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8}},
  {{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8}},
  {{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8}},
  {{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8}},
  {{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8}},
  {{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,9},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,9},{1,9},{1,9},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8}},
  {{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,9},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8}},
  {{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8}},
  {{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{0,8},{0,8},{0,12},{0,12},{0,12},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,12},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,8},{0,8},{0,8},{0,8},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,3},{1,3},{1,3},{1,3},{1,3},{1,9},{1,9},{1,4},{1,4}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8}},
  {{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,12},{1,0},{1,12},{1,12},{1,12},{1,12},{1,12},{1,0},{1,12},{1,12},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,9},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,5}},
  {{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4}},
  {{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,12},{0,8},{0,8},{0,8},{0,8},{0,9},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,9},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12}},
  {{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9}},
  {{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,12},{0,12},{0,12},{0,12}},
  {{0,9},{2,8},{2,8},{0,8},{0,8},{0,0},{0,0},{0,0},{3,8},{3,8},{3,8},{3,8},{3,8},{3,8},{3,8},{3,8},{3,8},{3,8},{0,8},{0,8},{3,8},{3,8},{3,8},{3,8},{3,8},{3,8},{3,8},{3,8},{3,8},{3,8},{3,8},{3,8},{0,8},{0,3},{0,3},{0,3},{0,3},{0,3},{0,3},{0,3},{0,3},{0,3},{0,3},{0,3},{0,3},{0,3},{0,4},{0,4},{3,8},{0,3},{0,3},{0,3},{0,3},{0,3},{0,9},{0,8},{0,9},{0,9},{0,9},{0,3},{0,3},{0,8},{0,8},{0,8},{0,12},{2,0},{0,0},{2,0},{0,0},{2,0},{0,0},{2,0},{0,0},{2,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{2,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},
  {{0,0},{0,0},{0,0},{2,0},{0,0},{2,0},{0,0},{2,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{2,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{2,0},{2,0},{0,12},{0,12},{0,0},{0,0},{2,9},{2,9},{0,0},{0,0},{0,9},{3,1},{2,0},{0,0},{2,0},{0,0},{2,0},{0,0},{2,0},{0,0},{2,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{2,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{2,0},{0,0},{2,0},{0,0},{2,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{2,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{2,0},{2,0},{0,0},{0,0},{0,0},{0,0},{0,1},{3,0},{0,0},{0,0},{0,9}},
  {{0,12},{0,12},{0,12},{0,12},{0,12},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{2,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,12},{0,12},{0,12},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,10},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9}},
  {{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,12},{0,8},{0,8},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,12},{0,12},{0,12},{0,12},{0,12},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{2,3},{2,3},{2,3},{2,3},{2,3},{2,3},{2,3},{2,3},{2,3},{2,3},{2,3},{2,3},{2,3},{2,3},{2,3},{2,3}},
  {{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,12},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,8}},
  {{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,12}},
  {{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{2,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{2,9},{2,9},{2,9},{2,9},{2,9}},
  {{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},
  {{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8}},
  {{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12}},
  {{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,5},{0,12},{0,12},{0,12},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,8},{1,8}},
  {{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6}},
  {{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,8},{1,8},{1,8},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,0},{1,0},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,2},{1,8},{1,8},{1,8},{1,8},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,2},{1,2},{1,8},{1,0}},
  {{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,9},{1,9},{1,2},{1,0},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,8},{1,8},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,9},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4}},
  {{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,0},{1,8},{1,8},{1,2},{1,2},{1,0},{1,0},{1,2},{1,0},{1,0},{1,0},{1,0},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,4},{1,4},{1,4},{1,12},{1,12},{1,4},{1,4},{1,2},{1,2},{1,2},{1,2},{1,2},{1,2},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,4},{1,9},{1,9},{1,0},{1,4},{1,4},{1,4},{1,4},{1,4}},
  {{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,8},{1,8},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,8},{1,8},{1,8},{1,4},{1,8},{1,4},{1,12},{1,12}},
  {{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,8},{1,8},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,8},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,12},{0,12},{0,12}},
  {{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,7},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,12},{1,12},{1,12},{1,12},{1,8},{1,8},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12}},
  {{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,12},{1,12},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,12},{1,12},{1,8},{1,8},{1,8},{1,8},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,8},{1,8},{1,8},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0}},
  {{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,6},{1,6},{1,6},{1,8},{1,8},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,8},{1,8},{1,6},{1,6},{1,6},{1,6},{1,6},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,0},{1,12},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,8},{1,9},{1,9},{1,9},{1,9},{1,2},{1,2},{1,2},{1,2},{1,4},{1,4},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6}},
  {{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,8},{1,6},{1,6},{1,12},{1,12},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,12},{0,12},{0,12},{0,12},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,4},{0,12},{0,12},{0,12},{0,12}},
  {{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12}},
  {{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,0},{0,0},{0,9},{0,0},{0,9},{0,0},{0,0},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,0},{0,9},{0,0},{0,9},{0,0},{0,0},{0,9},{0,9},{0,0},{0,0},{0,0},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,12},{0,12},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9}},
  {{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12}},
  {{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,9},{1,9},{1,9},{1,9},{1,9},{1,12},{1,12},{1,12},{1,12},{1,12},{1,9},{1,3},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,12},{1,9},{1,9},{1,9},{1,9},{1,9},{1,12},{1,9},{1,12},{1,9},{1,9},{1,12},{1,9},{1,9},{1,12},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9}},
  {{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9}},
  {{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9}},
  {{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9}},
  {{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,12},{1,12},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,8},{1,12},{1,12}},
  {{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{1,3},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,8},{0,8},{0,9},{0,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{2,9},{2,9},{2,9},{0,12},{0,9},{0,9},{0,9},{0,9},{1,9},{3,9},{3,9},{3,9},{3,9},{3,9},{3,9},{0,9},{0,9},{0,9},{0,9},{1,9},{1,9},{1,9},{1,9},{0,12},{0,9},{0,9},{0,9},{0,9},{0,12},{0,12},{0,12},{0,12},{1,9},{1,9},{1,9},{1,3},{1,9},{1,12},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9}},
  {{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,12},{1,12},{1,10}},
  {{1,12},{2,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{3,9},{3,9},{0,9},{0,9},{2,9},{1,9},{2,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{3,9},{3,9},{1,9},{1,9},{1,9},{2,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{3,9},{0,9},{3,9},{0,9},{3,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{3,9},{3,9},{3,9},{3,9},{3,9},{3,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9}},
  {{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,10},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,12},{1,12},{1,12},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,12},{1,12},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,12},{1,12},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,12},{1,12},{1,9},{1,9},{1,9},{1,12},{1,12},{1,12},{0,9},{0,9},{0,9},{3,9},{0,9},{0,9},{0,9},{0,12},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{1,8},{1,8},{1,8},{0,8},{0,8},{1,12},{1,12}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,7},{1,7},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,4},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8}},
  {{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,7},{1,12},{1,12}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,4},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,8},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,8},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,7},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,7},{1,7},{1,12},{1,12},{1,12},{1,7},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,8},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,8},{1,8},{1,7},{1,7},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8}},
  {{1,7},{1,7},{1,7},{1,7},{1,12},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,7},{1,7},{1,7},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,7},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,8},{1,8},{1,8}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,8},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8}},
  {{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,7}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,12},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,8},{1,8},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,8},{1,8},{1,8},{1,8},{1,8},{1,7},{1,7},{1,7},{1,8},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,8},{1,7},{1,8},{1,8},{1,8},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,7},{1,12},{1,7},{1,7},{1,7},{1,7},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,7},{1,7},{1,7},{1,7},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,7},{1,7},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,7},{1,7},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,7},{1,7},{1,12},{1,12},{1,7},{1,7},{1,7},{1,12},{1,12},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,8},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,12},{0,12},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,8},{1,8},{1,8},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,7}},
  {{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7}},
  {{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,6},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,7},{1,7},{1,7},{1,7},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,7},{1,7},{1,7}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,12}},
  {{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,5},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{0,4},{0,4},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,8},{1,7},{1,7},{1,8},{1,10},{1,10},{1,10},{1,10},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12}},
  {{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,12},{0,12},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,7},{0,7},{0,7},{0,7},{0,7},{0,8},{0,8},{0,8},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,10},{0,10},{0,10},{0,10},{0,10},{0,10},{0,10},{0,10},{0,7},{0,7},{0,7},{0,7},{0,7}},
  {{0,7},{0,7},{0,7},{0,8},{0,8},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,7},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,7},{0,7},{0,7},{0,7},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12}},
  {{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,7},{1,7},{1,7},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12}},
  {{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,12},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9}},
  {{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,12},{1,9},{1,9},{1,12},{1,12},{1,9},{1,12},{1,12},{1,9},{1,9},{1,12},{1,12},{1,9},{1,9},{1,9},{1,9},{1,12},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,12},{1,9},{1,12},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,12},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9}},
  {{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,12},{1,9},{1,9},{1,9},{1,9},{1,12},{1,12},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,12},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,12},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,12},{1,9},{1,9},{1,9},{1,9},{1,12},{1,9},{1,9},{1,9},{1,9},{1,9},{1,12},{1,9},{1,12},{1,12},{1,12},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,12},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9}},
  {{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,12},{1,12},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9}},
  {{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,12},{1,12},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,8},{1,8},{1,8},{1,8},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,7},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8}},
  {{1,8},{1,8},{1,8},{1,8},{1,7},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,7},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,9},{1,9},{1,9},{1,9},{1,12},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,12},{1,9},{1,9},{1,12},{1,9},{1,12},{1,12},{1,9},{1,12},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,12},{1,9},{1,9},{1,9},{1,9},{1,12},{1,9},{1,12},{1,9},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,9},{1,12},{1,12},{1,12},{1,12},{1,9},{1,12},{1,9},{1,12},{1,9},{1,12},{1,9},{1,9},{1,9},{1,12},{1,9},{1,9},{1,12},{1,9},{1,12},{1,12},{1,9},{1,12},{1,9},{1,12},{1,9},{1,12},{1,9},{1,12},{1,9},{1,12},{1,9},{1,9},{1,12},{1,9},{1,12},{1,12},{1,9},{1,9},{1,9},{1,9},{1,12},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,12},{1,9},{1,9},{1,9},{1,9},{1,12},{1,9},{1,9},{1,9},{1,9},{1,12},{1,9},{1,12}},
  {{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,12},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,12},{1,12},{1,12},{1,12},{1,12},{1,9},{1,9},{1,9},{1,12},{1,9},{1,9},{1,9},{1,9},{1,9},{1,12},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,9},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,12},{0,12},{0,12},{0,12},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8}},
  {{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,12},{0,12},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,12},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,12},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12}},
  {{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,8},{0,8},{0,12},{0,12},{0,12},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,12},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,9},{0,9},{0,12},{0,12},{0,12},{0,12},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8}},
  {{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,9},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8}},
  {{2,9},{2,9},{0,9},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,12},{0,12},{0,12},{0,12},{0,12},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,9},{0,9},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12}},
  {{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,12},{0,8},{0,8},{0,8},{0,8},{0,8}},
  {{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,12},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8}},
  {{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,12},{0,12},{0,12},{0,8},{0,8},{0,8},{0,8},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12}},
  {{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12}},
  {{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,8},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12}},
  {{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8}},
  {{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{1,8},{1,8},{1,8},{1,8},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,8},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}},
  {{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12}},
  {{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},
  {{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,12},{0,12},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},
  {{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12}},
  {{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,9},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12}},
  {{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{0,12},{1,12},{1,12}},
  {{1,12},{1,11},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,11}},
  {{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10}},
  {{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,10},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12},{1,12}}
};
#endif

#if !ENABLE_INTL_API
#define kCharProp2MaxPlane  16
#define kCharProp2IndexBits 12
#define kCharProp2CharBits  4
static const uint8_t sCharProp2Planes[16] = {1,2,3,4,4,4,4,4,4,4,4,4,4,5,6,6};

static const uint16_t sCharProp2Pages[7][4096] = {
  {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,16,16,17,18,16,16,19,20,21,22,23,24,25,26,27,16,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,59,59,60,60,60,61,61,62,63,63,63,64,63,63,63,63,63,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,81,82,83,84,85,86,81,81,81,81,87,88,89,90,91,92,93,94,81,81,81,95,95,96,97,98,99,100,101,102,103,104,105,106,107,108,108,108,108,109,110,111,111,112,113,114,115,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,194,195,196,197,198,198,199,200,201,202,203,204,198,198,205,206,207,208,209,210,211,212,213,214,215,216,217,218,198,198,219,219,220,221,222,223,224,225,226,227,228,228,229,230,230,231,232,232,232,232,232,233,234,235,235,235,236,237,237,237,237,237,238,238,238,238,239,240,238,238,239,238,238,241,242,243,238,238,238,242,238,238,238,244,245,246,238,247,248,248,248,248,248,249,250,251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,251,252,251,253,254,255,255,255,255,256,257,258,259,260,261,262,263,264,265,266,266,267,268,269,270,271,272,273,274,275,275,276,275,275,277,275,275,278,251,251,251,251,279,280,281,282,283,284,285,286,287,288,288,289,288,290,291,292,292,293,294,295,295,295,296,297,298,299,299,300,301,198,198,198,198,302,303,303,304,305,306,307,308,309,310,311,312,313,313,314,315,316,316,317,318,319,320,321,322,198,198,198,198,323,324,325,326,37,37,327,328,329,330,331,332,37,333,334,335,336,337,338,339,16,16,16,16,16,16,16,16,16,340,16,16,16,16,16,341,342,343,342,342,343,344,342,345,346,346,346,347,348,349,350,351,352,353,354,355,356,357,358,359,360,361,362,363,364,365,366,367,368,369,370,371,372,373,374,375,376,377,378,379,380,381,379,382,383,384,385,386,387,388,389,390,391,392,393,394,390,390,395,390,396,397,398,399,400,400,400,401,402,403,390,404,405,406,407,408,402,402,409,410,411,410,412,413,414,415,416,416,416,416,417,418,419,419,419,419,420,419,419,421,419,422,423,424,425,426,427,428,429,430,402,431,432,402,433,434,402,435,436,437,438,439,440,441,442,402,402,402,402,443,444,445,446,447,379,379,448,390,449,390,450,450,450,450,450,450,450,450,450,450,450,450,450,450,450,450,390,390,390,390,390,390,390,390,451,452,390,390,390,453,390,454,455,390,390,390,390,390,390,456,390,390,390,390,390,455,390,390,379,457,402,390,458,459,379,460,379,461,379,462,463,464,465,410,466,466,467,468,468,469,470,471,472,472,472,472,472,472,473,474,475,475,476,477,477,477,478,479,238,480,481,481,481,481,482,482,483,484,485,486,487,198,198,198,488,489,488,488,488,488,488,490,491,491,491,491,491,491,491,491,491,491,491,491,491,492,410,493,494,495,496,497,498,499,500,499,501,502,503,504,505,504,506,507,508,509,510,511,512,512,513,512,514,515,509,516,517,517,518,519,520,521,522,523,524,525,520,526,522,523,523,527,528,529,529,530,531,531,531,531,531,532,523,533,523,523,523,523,523,534,523,535,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,537,402,402,402,402,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,537,538,538,539,540,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,539,541,542,542,542,543,544,544,545,546,546,546,546,546,546,546,546,546,546,546,546,546,546,546,546,547,546,548,198,61,61,549,550,61,551,552,552,552,552,553,554,42,555,556,557,558,558,558,559,560,561,562,563,198,198,198,564,565,566,567,568,569,569,569,570,571,572,572,573,574,575,576,577,578,579,580,581,582,583,232,584,585,586,586,587,588,589,590,591,592,592,593,594,595,596,219,597,598,598,598,599,600,601,602,603,604,605,481,606,606,607,608,609,609,609,609,609,610,610,611,612,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,617,615,613,614,615,616,615,618,235,619,237,237,620,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,621,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,623,623,623,623,623,623,623,623,623,623,623,623,623,623,623,623,624,625,626,623,623,623,627,623,623,623,623,623,623,628,538,538,629,630,631,632,633,634,634,634,634,634,634,635,636,637,634,634,634,634,634,634,634,634,634,634,634,634,634,634,634,634,634,634,634,634,634,638,111,634,634,634,634,639,634,634,640,198,198,641,642,643,644,645,646,647,648,649,634,634,634,634,634,634,634,650,651,652,653,654,655,656,657,658,659,660,661,662,663,664,665,666},
  {667,668,669,670,671,671,198,198,668,668,668,668,668,668,668,672,673,674,674,675,676,676,676,677,678,679,680,198,198,400,400,681,198,198,198,198,198,198,198,198,682,683,684,684,684,685,686,687,688,688,689,690,691,692,692,693,694,695,696,696,697,698,198,198,699,699,700,701,701,702,702,702,703,704,705,198,198,198,198,198,706,706,707,708,708,708,709,198,198,198,198,198,198,198,198,198,710,710,710,710,710,710,710,710,710,710,710,710,710,710,710,710,710,710,710,711,710,712,713,198,198,198,198,198,198,198,198,198,714,715,715,716,717,718,719,720,721,722,723,108,108,108,724,725,726,727,728,729,108,108,108,108,730,730,731,732,733,734,733,733,735,736,737,738,739,740,741,742,743,744,108,108,745,746,747,748,749,749,749,750,751,752,753,754,755,756,757,108,108,108,108,108,758,758,758,758,759,108,108,108,760,760,760,761,762,762,762,763,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,764,765,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,766,767,767,768,769,770,771,772,773,774,774,775,776,777,778,779,780,781,782,783,784,785,785,786,787,788,788,789,790,791,792,793,794,795,796,797,198,198,198,198,798,799,800,801,801,802,803,804,805,806,807,808,809,810,811,812,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,813,813,813,814,815,816,198,198,198,198,198,198,198,198,198,198,817,817,818,819,820,821,410,410,822,822,822,823,824,825,198,198,826,826,827,828,829,198,198,198,830,831,832,833,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,834,834,835,835,836,837,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,838,838,838,839,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,840,841,198,198,198,198,198,198,842,842,842,842,842,842,843,844,840,840,840,840,840,840,840,840,840,840,840,840,845,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,846,846,846,846,846,846,846,846,846,846,846,846,846,846,846,846,846,846,846,846,846,846,846,846,846,846,846,846,846,846,846,846,846,846,846,846,846,847,846,846,848,846,846,846,846,846,846,846,846,846,846,846,846,846,846,849,846,846,846,846,846,846,846,846,846,846,850,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,851,851,851,851,851,851,851,851,851,851,851,851,851,851,851,851,851,851,851,851,851,851,851,851,851,851,851,851,852,851,851,851,851,851,851,851,853,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,552,552,552,552,552,552,552,552,552,552,552,552,552,552,552,552,552,552,552,552,552,552,552,552,552,552,552,552,552,552,552,552,552,552,552,854,855,856,857,198,198,198,198,198,198,858,859,860,861,861,861,862,863,864,865,866,861,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,867,867,867,867,868,869,870,871,872,873,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,874,410,410,410,410,410,410,410,410,410,410,410,410,410,410,410,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,875,875,875,875,875,875,876,877,878,879,880,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,881,881,881,881,881,881,881,881,881,881,881,881,881,881,881,882,881,881,883,881,881,884,885,886,887,881,888,889,890,881,891,410,892,892,892,892,893,198,198,198,198,198,198,198,198,198,198,198,402,402,402,402,402,894,895,896,198,198,198,198,198,198,198,198,897,898,899,900,901,902,903,897,904,905,906,907,908,897,898,899,909,910,899,911,912,913,914,897,915,899,897,898,899,900,901,899,903,897,904,914,897,915,899,897,898,899,916,897,917,918,919,920,899,921,897,922,923,924,925,899,926,897,927,899,928,929,930,931,932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,932,933,933,933,934,933,933,935,936,937,938,939,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,940,940,940,940,940,940,940,940,940,940,940,940,941,942,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,943,634,944,945,946,947,948,949,950,951,952,951,111,111,111,953,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,108,954,954,955,954,954,954,954,954,954,956,957,958,958,958,954,959,960,416,961,416,416,962,963,962,962,964,410,410,410,410,965,966,967,523,523,968,969,970,410,410,410,410,410,410,410,410,410,410,954,954,954,954,954,954,954,954,954,971,954,972,954,954,954,973,954,954,954,954,954,954,954,954,954,954,974,975,954,954,954,954,976,977,978,979,980,954,954,981,954,954,982,954,954,983,954,984,954,954,954,954,954,402,402,985,954,954,954,954,954,986,987,956,402,402,402,402,402,402,402,988,402,402,402,402,402,989,410,410,679,379,379,379,990,991,379,379,990,379,992,198,198,198,198,198,198,993,198,198,198,198,198,198,994,198,198,198,995,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198},
  {536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,996,538,538,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,997,536,536,536,536,536,536,536,536,536,536,536,536,536,998,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,536,999,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,623,623,623,623,623,623,623,623,623,623,623,623,623,623,623,623,623,623,623,623,623,623,623,623,623,623,623,623,623,623,623,623,623,627,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,1000},
  {538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,538,1000},
  {198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198},
  {1001,198,1002,1002,1002,1002,1002,1003,198,198,198,198,198,198,198,198,642,642,642,642,642,642,642,642,642,642,642,642,642,642,642,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198,198},
  {622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,622,1004}
};

static const nsCharProps2 sCharProp2Values[1005][16] = {
  {{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,8,8,-1,1,4},{0,0,0,0,7,8,-1,1,17},{0,0,0,0,8,8,-1,1,6},{0,0,0,0,9,8,-1,1,6},{0,0,0,0,7,8,-1,1,10},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9}},
  {{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,7,12,-1,1,9},{0,0,0,0,7,12,-1,1,9},{0,0,0,0,7,12,-1,1,9},{0,0,0,0,8,12,-1,1,9}},
  {{0,0,0,29,9,8,-1,1,26},{0,0,0,21,10,8,-1,1,11},{0,0,0,21,10,8,-1,1,23},{0,0,0,21,4,8,-1,1,2},{0,0,0,23,4,8,-1,1,22},{0,0,0,21,4,8,-1,1,21},{0,0,0,21,10,8,-1,1,2},{0,0,0,21,10,1,-1,1,23},{0,1,0,22,10,8,-1,1,20},{0,2,0,18,10,8,-1,1,36},{0,0,0,21,10,8,-1,1,2},{0,0,0,25,3,8,-1,1,22},{0,0,0,21,6,8,-1,1,16},{0,0,0,17,3,1,-1,1,13},{0,0,0,21,6,1,-1,1,16},{0,0,0,21,6,8,-1,1,27}},
  {{0,0,0,13,2,0,0,1,19},{0,0,0,13,2,0,1,1,19},{0,0,0,13,2,0,2,1,19},{0,0,0,13,2,0,3,1,19},{0,0,0,13,2,0,4,1,19},{0,0,0,13,2,0,5,1,19},{0,0,0,13,2,0,6,1,19},{0,0,0,13,2,0,7,1,19},{0,0,0,13,2,0,8,1,19},{0,0,0,13,2,0,9,1,19},{0,0,0,21,6,1,-1,1,16},{0,0,0,21,10,8,-1,1,16},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,21,10,8,-1,1,11}},
  {{0,0,0,21,10,8,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2}},
  {{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{0,1,0,22,10,8,-1,1,20},{0,0,0,21,10,8,-1,1,22},{0,2,0,18,10,8,-1,1,36},{0,0,0,24,10,8,-1,1,2},{0,0,0,16,10,0,-1,1,2}},
  {{0,0,0,24,10,8,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2}},
  {{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{0,1,0,22,10,8,-1,1,20},{0,0,0,25,10,8,-1,1,4},{0,2,0,18,10,8,-1,1,8},{0,0,0,25,10,8,-1,1,2},{0,0,0,0,18,12,-1,1,9}},
  {{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,7,8,-1,1,29},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9}},
  {{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9},{0,0,0,0,18,12,-1,1,9}},
  {{0,0,0,29,6,9,-1,1,12},{0,0,0,21,10,8,-1,1,20},{0,0,0,23,4,8,-1,1,21},{0,0,0,23,4,8,-1,1,22},{0,0,0,23,4,8,-1,1,22},{0,0,0,23,4,8,-1,1,22},{0,0,0,26,10,8,-1,1,2},{0,0,0,21,10,8,-1,0,1},{0,0,0,24,10,9,-1,1,1},{0,0,0,26,10,8,-1,0,2},{25,0,0,7,0,9,-1,1,1},{0,0,0,20,10,8,-1,1,23},{0,0,0,25,10,8,-1,1,2},{0,0,0,1,18,10,-1,1,4},{0,0,0,26,10,8,-1,0,2},{0,0,0,24,10,9,-1,1,2}},
  {{0,0,0,26,4,8,-1,1,21},{0,0,0,25,4,8,-1,0,22},{0,0,0,15,2,9,2,1,1},{0,0,0,15,2,9,3,1,1},{0,0,0,24,10,9,-1,1,5},{0,0,0,5,0,9,-1,1,2},{0,0,0,21,10,8,-1,1,1},{0,0,0,21,10,1,-1,1,1},{0,0,0,24,10,9,-1,1,1},{0,0,0,15,2,9,1,1,1},{25,0,0,7,0,9,-1,1,1},{0,0,0,19,10,8,-1,1,23},{0,0,0,15,10,9,-1,0,1},{0,0,0,15,10,9,-1,0,1},{0,0,0,15,10,9,-1,0,1},{0,0,0,21,10,8,-1,1,20}},
  {{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2}},
  {{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{0,0,0,25,10,8,-1,0,1},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2}},
  {{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2}},
  {{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{0,0,0,25,10,8,-1,0,1},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2}},
  {{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2}},
  {{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,9,-1,1,2},{25,0,0,5,0,9,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,9,-1,1,2}},
  {{25,0,0,5,0,9,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,11,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2}},
  {{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,9,-1,1,2}},
  {{25,0,0,5,0,3,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,9,0,0,-1,1,2}},
  {{25,0,0,9,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2}},
  {{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,9,0,0,-1,1,2}},
  {{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,7,0,4,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2}},
  {{25,0,0,7,0,3,-1,1,2},{25,0,0,7,0,3,-1,1,2},{25,0,0,7,0,3,-1,1,2},{25,0,0,7,0,3,-1,1,2},{25,0,0,9,0,9,-1,1,2},{25,0,0,8,0,9,-1,1,2},{25,0,0,5,0,9,-1,1,2},{25,0,0,9,0,9,-1,1,2},{25,0,0,8,0,9,-1,1,2},{25,0,0,5,0,9,-1,1,2},{25,0,0,9,0,9,-1,1,2},{25,0,0,8,0,9,-1,1,2},{25,0,0,5,0,9,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2}},
  {{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2}},
  {{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2}},
  {{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,9,-1,1,2},{25,0,0,8,0,9,-1,1,2},{25,0,0,5,0,9,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2}},
  {{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2}},
  {{25,0,0,9,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2}},
  {{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2}},
  {{25,0,0,5,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2}},
  {{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,4,-1,1,2}},
  {{25,0,0,5,0,2,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,2,-1,1,2}},
  {{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2}},
  {{25,0,0,5,0,2,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2}},
  {{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,7,0,2,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,3,-1,1,2}},
  {{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2}},
  {{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{0,0,0,6,10,3,-1,1,2},{0,0,0,6,10,3,-1,1,2},{0,0,0,6,0,0,-1,1,2},{0,0,0,6,0,0,-1,1,2},{0,0,0,6,0,3,-1,1,2},{0,0,0,6,0,3,-1,1,2},{0,0,0,6,0,3,-1,1,2}},
  {{0,0,0,6,0,3,-1,1,2},{0,0,0,6,0,3,-1,1,2},{0,0,0,24,10,8,-1,1,2},{0,0,0,24,10,8,-1,1,2},{0,0,0,24,10,8,-1,1,2},{0,0,0,24,10,8,-1,1,2},{0,0,0,6,10,3,-1,1,2},{0,0,0,6,10,3,-1,1,1},{0,0,0,6,10,3,-1,1,5},{0,0,0,6,10,3,-1,1,1},{0,0,0,6,10,3,-1,1,1},{0,0,0,6,10,3,-1,1,1},{0,0,0,6,10,3,-1,1,5},{0,0,0,6,10,3,-1,1,1},{0,0,0,6,10,3,-1,1,2},{0,0,0,6,10,3,-1,1,2}},
  {{0,0,0,6,0,3,-1,1,1},{0,0,0,6,0,3,-1,1,2},{0,0,0,24,10,8,-1,1,2},{0,0,0,24,10,8,-1,1,2},{0,0,0,24,10,8,-1,1,2},{0,0,0,24,10,8,-1,1,2},{0,0,0,24,10,8,-1,1,2},{0,0,0,24,10,8,-1,1,2},{0,0,0,24,10,9,-1,1,1},{0,0,0,24,10,9,-1,1,1},{0,0,0,24,10,9,-1,1,1},{0,0,0,24,10,9,-1,1,1},{0,0,0,24,10,9,-1,1,2},{0,0,0,24,10,9,-1,1,1},{0,0,0,24,10,8,-1,1,2},{0,0,0,24,10,8,-1,1,5}},
  {{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{0,0,0,24,10,8,-1,1,2},{0,0,0,24,10,8,-1,1,2},{0,0,0,24,10,8,-1,1,2},{0,0,0,24,10,8,-1,1,2},{0,0,0,24,10,8,-1,1,2},{5,0,0,24,10,8,-1,0,2},{5,0,0,24,10,8,-1,0,2},{0,0,0,6,10,0,-1,1,2},{0,0,0,24,10,8,-1,1,2},{0,0,0,6,0,3,-1,1,2},{0,0,0,24,10,8,-1,1,2}},
  {{0,0,0,24,10,8,-1,1,2},{0,0,0,24,10,8,-1,1,2},{0,0,0,24,10,8,-1,1,2},{0,0,0,24,10,8,-1,1,2},{0,0,0,24,10,8,-1,1,2},{0,0,0,24,10,8,-1,1,2},{0,0,0,24,10,8,-1,1,2},{0,0,0,24,10,8,-1,1,2},{0,0,0,24,10,8,-1,1,2},{0,0,0,24,10,8,-1,1,2},{0,0,0,24,10,8,-1,1,2},{0,0,0,24,10,8,-1,1,2},{0,0,0,24,10,8,-1,1,2},{0,0,0,24,10,8,-1,1,2},{0,0,0,24,10,8,-1,1,2},{0,0,0,24,10,8,-1,1,2}},
  {{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,2,-1,1,9},{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,2,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,0,-1,1,9}},
  {{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,2,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9}},
  {{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,2,-1,1,9},{1,0,0,12,17,2,-1,1,9},{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,3,-1,1,9}},
  {{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,2,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,2,-1,1,9},{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,2,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9}},
  {{1,0,0,12,17,9,-1,1,9},{1,0,0,12,17,9,-1,1,9},{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,9,-1,1,9},{1,0,0,12,17,9,-1,1,9},{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,10,-1,1,12}},
  {{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,2,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,12},{1,0,0,12,17,3,-1,1,12},{1,0,0,12,17,3,-1,1,12},{1,0,0,12,17,3,-1,1,12}},
  {{1,0,0,12,17,3,-1,1,12},{1,0,0,12,17,3,-1,1,12},{1,0,0,12,17,3,-1,1,12},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9}},
  {{14,0,0,9,0,4,-1,1,2},{14,0,0,5,0,4,-1,1,2},{14,0,0,9,0,4,-1,1,2},{14,0,0,5,0,4,-1,1,2},{0,0,0,6,10,9,-1,1,2},{14,0,0,24,10,1,-1,1,2},{14,0,0,9,0,4,-1,1,2},{14,0,0,5,0,4,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{14,0,0,6,0,9,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{0,0,0,21,10,9,-1,1,16},{14,0,0,9,0,4,-1,1,2}},
  {{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{14,0,0,24,10,9,-1,1,2},{0,0,0,24,10,9,-1,1,2},{14,0,0,9,0,0,-1,1,2},{0,0,0,21,10,9,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{14,0,0,9,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2}},
  {{14,0,0,5,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2}},
  {{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2}},
  {{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2}},
  {{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,9,0,3,-1,1,2}},
  {{14,0,0,5,0,9,-1,1,2},{14,0,0,5,0,9,-1,1,2},{14,0,0,9,0,9,-1,1,2},{14,0,0,9,0,9,-1,1,2},{14,0,0,9,0,9,-1,1,2},{14,0,0,5,0,9,-1,1,2},{14,0,0,5,0,9,-1,1,2},{14,0,0,5,0,3,-1,1,2},{14,0,0,9,0,4,-1,1,2},{14,0,0,5,0,4,-1,1,2},{14,0,0,9,0,4,-1,1,2},{14,0,0,5,0,4,-1,1,2},{14,0,0,9,0,4,-1,1,2},{14,0,0,5,0,4,-1,1,2},{14,0,0,9,0,4,-1,1,2},{14,0,0,5,0,4,-1,1,2}},
  {{14,0,0,9,0,4,-1,1,2},{14,0,0,5,0,4,-1,1,2},{7,0,0,9,0,7,-1,1,2},{7,0,0,5,0,7,-1,1,2},{7,0,0,9,0,7,-1,1,2},{7,0,0,5,0,7,-1,1,2},{7,0,0,9,0,7,-1,1,2},{7,0,0,5,0,7,-1,1,2},{7,0,0,9,0,7,-1,1,2},{7,0,0,5,0,7,-1,1,2},{7,0,0,9,0,7,-1,1,2},{7,0,0,5,0,7,-1,1,2},{7,0,0,9,0,7,-1,1,2},{7,0,0,5,0,7,-1,1,2},{7,0,0,9,0,7,-1,1,2},{7,0,0,5,0,7,-1,1,2}},
  {{14,0,0,5,0,9,-1,1,2},{14,0,0,5,0,9,-1,1,2},{14,0,0,5,0,9,-1,1,2},{14,0,0,5,0,4,-1,1,2},{14,0,0,9,0,9,-1,1,2},{14,0,0,5,0,9,-1,1,2},{14,0,0,25,10,8,-1,1,2},{14,0,0,9,0,4,-1,1,2},{14,0,0,5,0,4,-1,1,2},{14,0,0,9,0,9,-1,1,2},{14,0,0,9,0,4,-1,1,2},{14,0,0,5,0,4,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2}},
  {{8,0,0,9,0,0,-1,1,2},{8,0,0,9,0,0,-1,1,2},{8,0,0,9,0,0,-1,1,2},{8,0,0,9,0,0,-1,1,2},{8,0,0,9,0,0,-1,1,2},{8,0,0,9,0,0,-1,1,2},{8,0,0,9,0,0,-1,1,2},{8,0,0,9,0,0,-1,1,2},{8,0,0,9,0,0,-1,1,2},{8,0,0,9,0,0,-1,1,2},{8,0,0,9,0,0,-1,1,2},{8,0,0,9,0,0,-1,1,2},{8,0,0,9,0,0,-1,1,2},{8,0,0,9,0,0,-1,1,2},{8,0,0,9,0,0,-1,1,2},{8,0,0,9,0,0,-1,1,2}},
  {{8,0,0,5,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2}},
  {{8,0,0,9,0,4,-1,1,2},{8,0,0,5,0,4,-1,1,2},{8,0,0,9,0,4,-1,1,2},{8,0,0,5,0,4,-1,1,2},{8,0,0,9,0,4,-1,1,2},{8,0,0,5,0,4,-1,1,2},{8,0,0,9,0,4,-1,1,2},{8,0,0,5,0,4,-1,1,2},{8,0,0,9,0,4,-1,1,2},{8,0,0,5,0,4,-1,1,2},{8,0,0,9,0,4,-1,1,2},{8,0,0,5,0,4,-1,1,2},{8,0,0,9,0,4,-1,1,2},{8,0,0,5,0,4,-1,1,2},{8,0,0,9,0,4,-1,1,2},{8,0,0,5,0,4,-1,1,2}},
  {{8,0,0,9,0,4,-1,1,2},{8,0,0,5,0,4,-1,1,2},{8,0,0,26,0,8,-1,1,2},{8,0,0,12,17,4,-1,1,9},{8,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{8,0,0,12,17,4,-1,1,9},{8,0,0,11,17,8,-1,1,9},{8,0,0,11,17,8,-1,1,9},{8,0,0,9,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2},{8,0,0,9,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2},{8,0,0,9,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2}},
  {{8,0,0,9,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2},{8,0,0,9,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2},{8,0,0,9,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2},{8,0,0,9,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2},{8,0,0,9,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2},{8,0,0,9,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2},{8,0,0,9,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2},{8,0,0,9,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2}},
  {{8,0,0,9,0,0,-1,1,2},{8,0,0,9,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2},{8,0,0,9,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2},{8,0,0,9,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2},{8,0,0,9,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2},{8,0,0,9,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2},{8,0,0,9,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2},{8,0,0,9,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2}},
  {{8,0,0,9,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2},{8,0,0,9,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2},{8,0,0,9,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2},{8,0,0,9,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2},{8,0,0,9,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2},{8,0,0,9,0,4,-1,1,2},{8,0,0,5,0,4,-1,1,2},{8,0,0,9,0,4,-1,1,2},{8,0,0,5,0,4,-1,1,2},{8,0,0,9,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2}},
  {{103,0,0,2,0,12,-1,1,0},{3,0,0,9,0,0,-1,1,2},{3,0,0,9,0,0,-1,1,2},{3,0,0,9,0,0,-1,1,2},{3,0,0,9,0,0,-1,1,2},{3,0,0,9,0,0,-1,1,2},{3,0,0,9,0,0,-1,1,2},{3,0,0,9,0,0,-1,1,2},{3,0,0,9,0,0,-1,1,2},{3,0,0,9,0,0,-1,1,2},{3,0,0,9,0,0,-1,1,2},{3,0,0,9,0,0,-1,1,2},{3,0,0,9,0,0,-1,1,2},{3,0,0,9,0,0,-1,1,2},{3,0,0,9,0,0,-1,1,2},{3,0,0,9,0,0,-1,1,2}},
  {{3,0,0,9,0,0,-1,1,2},{3,0,0,9,0,0,-1,1,2},{3,0,0,9,0,0,-1,1,2},{3,0,0,9,0,0,-1,1,2},{3,0,0,9,0,0,-1,1,2},{3,0,0,9,0,0,-1,1,2},{3,0,0,9,0,0,-1,1,2},{3,0,0,9,0,0,-1,1,2},{3,0,0,9,0,0,-1,1,2},{3,0,0,9,0,0,-1,1,2},{3,0,0,9,0,0,-1,1,2},{3,0,0,9,0,0,-1,1,2},{3,0,0,9,0,0,-1,1,2},{3,0,0,9,0,0,-1,1,2},{3,0,0,9,0,0,-1,1,2},{3,0,0,9,0,0,-1,1,2}},
  {{3,0,0,9,0,0,-1,1,2},{3,0,0,9,0,0,-1,1,2},{3,0,0,9,0,0,-1,1,2},{3,0,0,9,0,0,-1,1,2},{3,0,0,9,0,0,-1,1,2},{3,0,0,9,0,0,-1,1,2},{3,0,0,9,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{3,0,0,6,0,0,-1,1,2},{3,0,0,21,0,8,-1,1,2},{3,0,0,21,0,8,-1,1,2},{3,0,0,21,0,8,-1,1,2},{3,0,0,21,0,8,-1,1,2},{3,0,0,21,0,8,-1,1,2},{3,0,0,21,0,8,-1,1,2}},
  {{103,0,0,2,0,12,-1,1,0},{3,0,0,5,0,0,-1,1,2},{3,0,0,5,0,0,-1,1,2},{3,0,0,5,0,0,-1,1,2},{3,0,0,5,0,0,-1,1,2},{3,0,0,5,0,0,-1,1,2},{3,0,0,5,0,0,-1,1,2},{3,0,0,5,0,0,-1,1,2},{3,0,0,5,0,0,-1,1,2},{3,0,0,5,0,0,-1,1,2},{3,0,0,5,0,0,-1,1,2},{3,0,0,5,0,0,-1,1,2},{3,0,0,5,0,0,-1,1,2},{3,0,0,5,0,0,-1,1,2},{3,0,0,5,0,0,-1,1,2},{3,0,0,5,0,0,-1,1,2}},
  {{3,0,0,5,0,0,-1,1,2},{3,0,0,5,0,0,-1,1,2},{3,0,0,5,0,0,-1,1,2},{3,0,0,5,0,0,-1,1,2},{3,0,0,5,0,0,-1,1,2},{3,0,0,5,0,0,-1,1,2},{3,0,0,5,0,0,-1,1,2},{3,0,0,5,0,0,-1,1,2},{3,0,0,5,0,0,-1,1,2},{3,0,0,5,0,0,-1,1,2},{3,0,0,5,0,0,-1,1,2},{3,0,0,5,0,0,-1,1,2},{3,0,0,5,0,0,-1,1,2},{3,0,0,5,0,0,-1,1,2},{3,0,0,5,0,0,-1,1,2},{3,0,0,5,0,0,-1,1,2}},
  {{3,0,0,5,0,0,-1,1,2},{3,0,0,5,0,0,-1,1,2},{3,0,0,5,0,0,-1,1,2},{3,0,0,5,0,0,-1,1,2},{3,0,0,5,0,0,-1,1,2},{3,0,0,5,0,0,-1,1,2},{3,0,0,5,0,0,-1,1,2},{3,0,0,5,0,9,-1,1,2},{103,0,0,2,0,12,-1,1,0},{0,0,0,21,0,8,-1,1,16},{3,0,0,17,10,1,-1,1,4},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{3,0,0,26,10,8,-1,1,2},{3,0,0,26,10,8,-1,1,2},{3,0,0,23,4,8,-1,1,22}},
  {{103,0,0,2,1,12,-1,1,0},{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,2,-1,1,9}},
  {{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,4,-1,1,9},{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,2,-1,1,9}},
  {{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,0,-1,1,9},{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,2,-1,1,9},{19,0,0,17,1,8,-1,1,4},{19,0,0,12,17,2,-1,1,9}},
  {{19,0,0,21,1,8,-1,1,2},{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,2,-1,1,9},{19,0,0,21,1,8,-1,1,2},{19,0,0,12,17,2,-1,1,9},{19,0,0,12,17,4,-1,1,9},{19,0,0,21,1,8,-1,1,11},{19,0,0,12,17,4,-1,1,9},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0}},
  {{19,0,0,7,1,0,-1,1,38},{19,0,0,7,1,0,-1,1,38},{19,0,0,7,1,0,-1,1,38},{19,0,0,7,1,0,-1,1,38},{19,0,0,7,1,0,-1,1,38},{19,0,0,7,1,0,-1,1,38},{19,0,0,7,1,0,-1,1,38},{19,0,0,7,1,0,-1,1,38},{19,0,0,7,1,0,-1,1,38},{19,0,0,7,1,0,-1,1,38},{19,0,0,7,1,0,-1,1,38},{19,0,0,7,1,0,-1,1,38},{19,0,0,7,1,0,-1,1,38},{19,0,0,7,1,0,-1,1,38},{19,0,0,7,1,0,-1,1,38},{19,0,0,7,1,0,-1,1,38}},
  {{19,0,0,7,1,0,-1,1,38},{19,0,0,7,1,0,-1,1,38},{19,0,0,7,1,0,-1,1,38},{19,0,0,7,1,0,-1,1,38},{19,0,0,7,1,0,-1,1,38},{19,0,0,7,1,0,-1,1,38},{19,0,0,7,1,0,-1,1,38},{19,0,0,7,1,0,-1,1,38},{19,0,0,7,1,0,-1,1,38},{19,0,0,7,1,0,-1,1,38},{19,0,0,7,1,0,-1,1,38},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0}},
  {{19,0,0,7,1,0,-1,1,38},{19,0,0,7,1,0,-1,1,38},{19,0,0,7,1,0,-1,1,38},{19,0,0,21,1,1,-1,1,2},{19,0,0,21,1,1,-1,1,2},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0}},
  {{2,0,0,1,5,8,-1,1,2},{2,0,0,1,5,8,-1,1,2},{2,0,0,1,5,8,-1,1,2},{2,0,0,1,5,8,-1,1,2},{2,0,0,1,5,8,-1,1,2},{0,0,0,1,5,8,-1,1,2},{2,0,0,25,10,8,-1,1,2},{2,0,0,25,10,8,-1,1,2},{2,0,0,25,13,8,-1,1,2},{2,0,0,21,4,8,-1,1,21},{2,0,0,21,4,8,-1,1,21},{2,0,0,23,13,8,-1,1,21},{0,0,0,21,6,8,-1,1,16},{2,0,0,21,13,8,-1,1,16},{2,0,0,26,10,8,-1,1,2},{2,0,0,26,10,8,-1,1,2}},
  {{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{0,0,0,21,13,8,-1,1,11},{0,0,0,1,13,10,-1,1,9},{103,0,0,2,13,12,-1,1,0},{2,0,0,21,13,8,-1,1,11},{0,0,0,21,13,8,-1,1,11}},
  {{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2}},
  {{0,0,0,6,13,7,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,0,-1,1,9}},
  {{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,0,-1,1,9},{1,0,0,12,17,0,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9}},
  {{2,0,0,13,5,0,0,1,19},{2,0,0,13,5,0,1,1,19},{2,0,0,13,5,0,2,1,19},{2,0,0,13,5,0,3,1,19},{2,0,0,13,5,0,4,1,19},{2,0,0,13,5,0,5,1,19},{2,0,0,13,5,0,6,1,19},{2,0,0,13,5,0,7,1,19},{2,0,0,13,5,0,8,1,19},{2,0,0,13,5,0,9,1,19},{2,0,0,21,4,8,-1,1,21},{2,0,0,21,5,8,-1,1,19},{2,0,0,21,5,8,-1,1,19},{2,0,0,21,13,8,-1,1,2},{2,0,0,7,13,4,-1,1,2},{2,0,0,7,13,4,-1,1,2}},
  {{1,0,0,12,17,0,-1,1,9},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,11,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2}},
  {{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,4,-1,1,2},{2,0,0,7,13,0,-1,1,2}},
  {{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,21,13,8,-1,1,11},{2,0,0,7,13,0,-1,1,2},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{0,0,0,1,5,8,-1,1,2},{2,0,0,26,10,8,-1,1,2},{2,0,0,12,17,2,-1,1,9}},
  {{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,6,13,0,-1,1,2},{2,0,0,6,13,0,-1,1,2},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,26,10,8,-1,1,2},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2}},
  {{2,0,0,13,2,0,0,1,19},{2,0,0,13,2,0,1,1,19},{2,0,0,13,2,0,2,1,19},{2,0,0,13,2,0,3,1,19},{2,0,0,13,2,0,4,1,19},{2,0,0,13,2,0,5,1,19},{2,0,0,13,2,0,6,1,19},{2,0,0,13,2,0,7,1,19},{2,0,0,13,2,0,8,1,19},{2,0,0,13,2,0,9,1,19},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,26,13,1,-1,1,2},{2,0,0,26,13,1,-1,1,2},{2,0,0,7,13,0,-1,1,2}},
  {{34,0,0,21,13,8,-1,1,2},{34,0,0,21,13,8,-1,1,2},{34,0,0,21,13,8,-1,1,2},{34,0,0,21,13,8,-1,1,2},{34,0,0,21,13,8,-1,1,2},{34,0,0,21,13,8,-1,1,2},{34,0,0,21,13,8,-1,1,2},{34,0,0,21,13,8,-1,1,2},{34,0,0,21,13,8,-1,1,2},{34,0,0,21,13,8,-1,1,2},{34,0,0,21,13,8,-1,1,2},{34,0,0,21,13,8,-1,1,2},{34,0,0,21,13,8,-1,1,2},{34,0,0,21,13,8,-1,1,2},{103,0,0,2,13,12,-1,1,0},{34,0,0,1,13,8,-1,1,2}},
  {{34,0,0,7,13,6,-1,1,2},{34,0,0,12,17,6,-1,1,9},{34,0,0,7,13,6,-1,1,2},{34,0,0,7,13,6,-1,1,2},{34,0,0,7,13,6,-1,1,2},{34,0,0,7,13,6,-1,1,2},{34,0,0,7,13,6,-1,1,2},{34,0,0,7,13,6,-1,1,2},{34,0,0,7,13,6,-1,1,2},{34,0,0,7,13,6,-1,1,2},{34,0,0,7,13,6,-1,1,2},{34,0,0,7,13,6,-1,1,2},{34,0,0,7,13,6,-1,1,2},{34,0,0,7,13,6,-1,1,2},{34,0,0,7,13,6,-1,1,2},{34,0,0,7,13,6,-1,1,2}},
  {{34,0,0,7,13,6,-1,1,2},{34,0,0,7,13,6,-1,1,2},{34,0,0,7,13,6,-1,1,2},{34,0,0,7,13,6,-1,1,2},{34,0,0,7,13,6,-1,1,2},{34,0,0,7,13,6,-1,1,2},{34,0,0,7,13,6,-1,1,2},{34,0,0,7,13,6,-1,1,2},{34,0,0,7,13,6,-1,1,2},{34,0,0,7,13,6,-1,1,2},{34,0,0,7,13,6,-1,1,2},{34,0,0,7,13,6,-1,1,2},{34,0,0,7,13,6,-1,1,2},{34,0,0,7,13,6,-1,1,2},{34,0,0,7,13,6,-1,1,2},{34,0,0,7,13,6,-1,1,2}},
  {{34,0,0,12,17,6,-1,1,9},{34,0,0,12,17,6,-1,1,9},{34,0,0,12,17,6,-1,1,9},{34,0,0,12,17,6,-1,1,9},{34,0,0,12,17,6,-1,1,9},{34,0,0,12,17,6,-1,1,9},{34,0,0,12,17,6,-1,1,9},{34,0,0,12,17,6,-1,1,9},{34,0,0,12,17,6,-1,1,9},{34,0,0,12,17,6,-1,1,9},{34,0,0,12,17,6,-1,1,9},{34,0,0,12,17,6,-1,1,9},{34,0,0,12,17,6,-1,1,9},{34,0,0,12,17,6,-1,1,9},{34,0,0,12,17,6,-1,1,9},{34,0,0,12,17,6,-1,1,9}},
  {{34,0,0,12,17,6,-1,1,9},{34,0,0,12,17,6,-1,1,9},{34,0,0,12,17,6,-1,1,9},{34,0,0,12,17,6,-1,1,9},{34,0,0,12,17,6,-1,1,9},{34,0,0,12,17,6,-1,1,9},{34,0,0,12,17,6,-1,1,9},{34,0,0,12,17,6,-1,1,9},{34,0,0,12,17,6,-1,1,9},{34,0,0,12,17,6,-1,1,9},{34,0,0,12,17,6,-1,1,9},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{34,0,0,7,13,6,-1,1,2},{34,0,0,7,13,6,-1,1,2},{34,0,0,7,13,6,-1,1,2}},
  {{37,0,0,7,13,0,-1,1,2},{37,0,0,7,13,0,-1,1,2},{37,0,0,7,13,0,-1,1,2},{37,0,0,7,13,0,-1,1,2},{37,0,0,7,13,0,-1,1,2},{37,0,0,7,13,0,-1,1,2},{37,0,0,7,13,0,-1,1,2},{37,0,0,7,13,0,-1,1,2},{37,0,0,7,13,0,-1,1,2},{37,0,0,7,13,0,-1,1,2},{37,0,0,7,13,0,-1,1,2},{37,0,0,7,13,0,-1,1,2},{37,0,0,7,13,0,-1,1,2},{37,0,0,7,13,0,-1,1,2},{37,0,0,7,13,0,-1,1,2},{37,0,0,7,13,0,-1,1,2}},
  {{37,0,0,7,13,0,-1,1,2},{37,0,0,7,13,0,-1,1,2},{37,0,0,7,13,0,-1,1,2},{37,0,0,7,13,0,-1,1,2},{37,0,0,7,13,0,-1,1,2},{37,0,0,7,13,0,-1,1,2},{37,0,0,12,17,0,-1,1,9},{37,0,0,12,17,0,-1,1,9},{37,0,0,12,17,0,-1,1,9},{37,0,0,12,17,0,-1,1,9},{37,0,0,12,17,0,-1,1,9},{37,0,0,12,17,0,-1,1,9},{37,0,0,12,17,0,-1,1,9},{37,0,0,12,17,0,-1,1,9},{37,0,0,12,17,0,-1,1,9},{37,0,0,12,17,0,-1,1,9}},
  {{37,0,0,12,17,0,-1,1,9},{37,0,0,7,13,0,-1,1,2},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0}},
  {{87,0,0,13,1,6,0,1,19},{87,0,0,13,1,6,1,1,19},{87,0,0,13,1,6,2,1,19},{87,0,0,13,1,6,3,1,19},{87,0,0,13,1,6,4,1,19},{87,0,0,13,1,6,5,1,19},{87,0,0,13,1,6,6,1,19},{87,0,0,13,1,6,7,1,19},{87,0,0,13,1,6,8,1,19},{87,0,0,13,1,6,9,1,19},{87,0,0,7,1,6,-1,1,2},{87,0,0,7,1,6,-1,1,2},{87,0,0,7,1,6,-1,1,2},{87,0,0,7,1,6,-1,1,2},{87,0,0,7,1,6,-1,1,2},{87,0,0,7,1,6,-1,1,2}},
  {{87,0,0,7,1,6,-1,1,2},{87,0,0,7,1,6,-1,1,2},{87,0,0,7,1,6,-1,1,2},{87,0,0,7,1,6,-1,1,2},{87,0,0,7,1,6,-1,1,2},{87,0,0,7,1,6,-1,1,2},{87,0,0,7,1,6,-1,1,2},{87,0,0,7,1,6,-1,1,2},{87,0,0,7,1,6,-1,1,2},{87,0,0,7,1,6,-1,1,2},{87,0,0,7,1,6,-1,1,2},{87,0,0,7,1,6,-1,1,2},{87,0,0,7,1,6,-1,1,2},{87,0,0,7,1,6,-1,1,2},{87,0,0,7,1,6,-1,1,2},{87,0,0,7,1,6,-1,1,2}},
  {{87,0,0,7,1,6,-1,1,2},{87,0,0,7,1,6,-1,1,2},{87,0,0,7,1,6,-1,1,2},{87,0,0,7,1,6,-1,1,2},{87,0,0,7,1,6,-1,1,2},{87,0,0,7,1,6,-1,1,2},{87,0,0,7,1,6,-1,1,2},{87,0,0,7,1,6,-1,1,2},{87,0,0,7,1,6,-1,1,2},{87,0,0,7,1,6,-1,1,2},{87,0,0,7,1,6,-1,1,2},{87,0,0,12,17,6,-1,1,9},{87,0,0,12,17,6,-1,1,9},{87,0,0,12,17,6,-1,1,9},{87,0,0,12,17,6,-1,1,9},{87,0,0,12,17,6,-1,1,9}},
  {{87,0,0,12,17,6,-1,1,9},{87,0,0,12,17,6,-1,1,9},{87,0,0,12,17,6,-1,1,9},{87,0,0,12,17,6,-1,1,9},{87,0,0,6,1,6,-1,1,2},{87,0,0,6,1,6,-1,1,2},{87,0,0,26,10,8,-1,1,2},{87,0,0,21,10,8,-1,1,2},{87,0,0,21,10,8,-1,1,16},{87,0,0,21,10,8,-1,1,11},{87,0,0,6,1,7,-1,1,2},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0}},
  {{126,0,0,7,1,7,-1,1,2},{126,0,0,7,1,7,-1,1,2},{126,0,0,7,1,7,-1,1,2},{126,0,0,7,1,7,-1,1,2},{126,0,0,7,1,7,-1,1,2},{126,0,0,7,1,7,-1,1,2},{126,0,0,7,1,7,-1,1,2},{126,0,0,7,1,7,-1,1,2},{126,0,0,7,1,7,-1,1,2},{126,0,0,7,1,7,-1,1,2},{126,0,0,7,1,7,-1,1,2},{126,0,0,7,1,7,-1,1,2},{126,0,0,7,1,7,-1,1,2},{126,0,0,7,1,7,-1,1,2},{126,0,0,7,1,7,-1,1,2},{126,0,0,7,1,7,-1,1,2}},
  {{126,0,0,7,1,7,-1,1,2},{126,0,0,7,1,7,-1,1,2},{126,0,0,7,1,7,-1,1,2},{126,0,0,7,1,7,-1,1,2},{126,0,0,7,1,7,-1,1,2},{126,0,0,7,1,7,-1,1,2},{126,0,0,12,17,7,-1,1,9},{126,0,0,12,17,7,-1,1,9},{126,0,0,12,17,7,-1,1,9},{126,0,0,12,17,7,-1,1,9},{126,0,0,6,1,7,-1,1,2},{126,0,0,12,17,7,-1,1,9},{126,0,0,12,17,7,-1,1,9},{126,0,0,12,17,7,-1,1,9},{126,0,0,12,17,7,-1,1,9},{126,0,0,12,17,7,-1,1,9}},
  {{126,0,0,12,17,7,-1,1,9},{126,0,0,12,17,7,-1,1,9},{126,0,0,12,17,7,-1,1,9},{126,0,0,12,17,7,-1,1,9},{126,0,0,6,1,7,-1,1,2},{126,0,0,12,17,7,-1,1,9},{126,0,0,12,17,7,-1,1,9},{126,0,0,12,17,7,-1,1,9},{126,0,0,6,1,7,-1,1,2},{126,0,0,12,17,7,-1,1,9},{126,0,0,12,17,7,-1,1,9},{126,0,0,12,17,7,-1,1,9},{126,0,0,12,17,7,-1,1,9},{126,0,0,12,17,7,-1,1,9},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0}},
  {{126,0,0,21,1,8,-1,1,2},{126,0,0,21,1,8,-1,1,2},{126,0,0,21,1,8,-1,1,2},{126,0,0,21,1,8,-1,1,2},{126,0,0,21,1,8,-1,1,2},{126,0,0,21,1,8,-1,1,2},{126,0,0,21,1,8,-1,1,2},{126,0,0,21,1,8,-1,1,2},{126,0,0,21,1,8,-1,1,2},{126,0,0,21,1,8,-1,1,2},{126,0,0,21,1,8,-1,1,2},{126,0,0,21,1,8,-1,1,2},{126,0,0,21,1,8,-1,1,2},{126,0,0,21,1,8,-1,1,2},{126,0,0,21,1,8,-1,1,2},{103,0,0,2,1,12,-1,1,0}},
  {{84,0,0,7,1,6,-1,1,2},{84,0,0,7,1,6,-1,1,2},{84,0,0,7,1,6,-1,1,2},{84,0,0,7,1,6,-1,1,2},{84,0,0,7,1,6,-1,1,2},{84,0,0,7,1,6,-1,1,2},{84,0,0,7,1,6,-1,1,2},{84,0,0,7,1,6,-1,1,2},{84,0,0,7,1,6,-1,1,2},{84,0,0,7,1,6,-1,1,2},{84,0,0,7,1,6,-1,1,2},{84,0,0,7,1,6,-1,1,2},{84,0,0,7,1,6,-1,1,2},{84,0,0,7,1,6,-1,1,2},{84,0,0,7,1,6,-1,1,2},{84,0,0,7,1,6,-1,1,2}},
  {{84,0,0,7,1,6,-1,1,2},{84,0,0,7,1,6,-1,1,2},{84,0,0,7,1,6,-1,1,2},{84,0,0,7,1,6,-1,1,2},{84,0,0,7,1,6,-1,1,2},{84,0,0,7,1,6,-1,1,2},{84,0,0,7,1,6,-1,1,2},{84,0,0,7,1,6,-1,1,2},{84,0,0,7,1,6,-1,1,2},{84,0,0,12,17,6,-1,1,9},{84,0,0,12,17,6,-1,1,9},{84,0,0,12,17,6,-1,1,9},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{84,0,0,21,1,8,-1,1,2},{103,0,0,2,1,12,-1,1,0}},
  {{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0}},
  {{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,4,-1,1,2},{2,0,0,7,13,4,-1,1,2},{2,0,0,7,13,4,-1,1,2}},
  {{2,0,0,7,13,4,-1,1,2},{2,0,0,7,13,4,-1,1,2},{2,0,0,7,13,0,-1,1,2},{2,0,0,7,13,2,-1,1,2},{2,0,0,7,13,2,-1,1,2},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0}},
  {{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0}},
  {{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9}},
  {{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9},{2,0,0,12,17,2,-1,1,9}},
  {{10,0,0,12,17,2,-1,1,9},{10,0,0,12,17,0,-1,1,9},{10,0,0,12,17,0,-1,1,9},{10,0,0,10,0,0,-1,1,9},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2}},
  {{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2}},
  {{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,12,17,0,-1,1,9},{10,0,0,10,0,0,-1,1,9},{10,0,0,12,17,0,-1,1,9},{10,0,0,7,0,0,-1,1,2},{10,0,0,10,0,0,-1,1,9},{10,0,0,10,0,0,-1,1,9}},
  {{10,0,0,10,0,0,-1,1,9},{10,0,0,12,17,0,-1,1,9},{10,0,0,12,17,0,-1,1,9},{10,0,0,12,17,0,-1,1,9},{10,0,0,12,17,0,-1,1,9},{10,0,0,12,17,0,-1,1,9},{10,0,0,12,17,0,-1,1,9},{10,0,0,12,17,0,-1,1,9},{10,0,0,12,17,0,-1,1,9},{10,0,0,10,0,0,-1,1,9},{10,0,0,10,0,0,-1,1,9},{10,0,0,10,0,0,-1,1,9},{10,0,0,10,0,0,-1,1,9},{10,0,0,12,17,0,-1,1,9},{10,0,0,10,0,4,-1,1,9},{10,0,0,10,0,0,-1,1,9}},
  {{10,0,0,7,0,0,-1,1,2},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{10,0,0,12,17,3,-1,1,9},{10,0,0,12,17,3,-1,1,9},{10,0,0,12,17,2,-1,1,9},{10,0,0,12,17,0,-1,1,9},{10,0,0,12,17,0,-1,1,9},{10,0,0,7,0,9,-1,1,2},{10,0,0,7,0,9,-1,1,2},{10,0,0,7,0,9,-1,1,2},{10,0,0,7,0,9,-1,1,2},{10,0,0,7,0,9,-1,1,2},{10,0,0,7,0,9,-1,1,2},{10,0,0,7,0,9,-1,1,2},{10,0,0,7,0,9,-1,1,2}},
  {{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,12,17,0,-1,1,9},{10,0,0,12,17,0,-1,1,9},{0,0,0,21,0,8,-1,1,4},{0,0,0,21,0,8,-1,1,4},{10,0,0,13,0,0,0,1,19},{10,0,0,13,0,0,1,1,19},{10,0,0,13,0,0,2,1,19},{10,0,0,13,0,0,3,1,19},{10,0,0,13,0,0,4,1,19},{10,0,0,13,0,0,5,1,19},{10,0,0,13,0,0,6,1,19},{10,0,0,13,0,0,7,1,19},{10,0,0,13,0,0,8,1,19},{10,0,0,13,0,0,9,1,19}},
  {{10,0,0,21,0,8,-1,1,2},{10,0,0,6,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,4,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2},{10,0,0,7,0,0,-1,1,2}},
  {{4,0,0,7,0,4,-1,1,2},{4,0,0,12,17,0,-1,1,9},{4,0,0,10,0,0,-1,1,9},{4,0,0,10,0,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{4,0,0,7,0,0,-1,1,2},{4,0,0,7,0,0,-1,1,2},{4,0,0,7,0,0,-1,1,2},{4,0,0,7,0,0,-1,1,2},{4,0,0,7,0,0,-1,1,2},{4,0,0,7,0,0,-1,1,2},{4,0,0,7,0,0,-1,1,2},{4,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{4,0,0,7,0,0,-1,1,2}},
  {{4,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{4,0,0,7,0,0,-1,1,2},{4,0,0,7,0,0,-1,1,2},{4,0,0,7,0,0,-1,1,2},{4,0,0,7,0,0,-1,1,2},{4,0,0,7,0,0,-1,1,2},{4,0,0,7,0,0,-1,1,2},{4,0,0,7,0,0,-1,1,2},{4,0,0,7,0,0,-1,1,2},{4,0,0,7,0,0,-1,1,2},{4,0,0,7,0,0,-1,1,2},{4,0,0,7,0,0,-1,1,2},{4,0,0,7,0,0,-1,1,2},{4,0,0,7,0,0,-1,1,2}},
  {{4,0,0,7,0,0,-1,1,2},{4,0,0,7,0,0,-1,1,2},{4,0,0,7,0,0,-1,1,2},{4,0,0,7,0,0,-1,1,2},{4,0,0,7,0,0,-1,1,2},{4,0,0,7,0,0,-1,1,2},{4,0,0,7,0,0,-1,1,2},{4,0,0,7,0,0,-1,1,2},{4,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{4,0,0,7,0,0,-1,1,2},{4,0,0,7,0,0,-1,1,2},{4,0,0,7,0,0,-1,1,2},{4,0,0,7,0,0,-1,1,2},{4,0,0,7,0,0,-1,1,2},{4,0,0,7,0,0,-1,1,2}},
  {{4,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{4,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{4,0,0,7,0,0,-1,1,2},{4,0,0,7,0,0,-1,1,2},{4,0,0,7,0,0,-1,1,2},{4,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{4,0,0,12,17,0,-1,1,9},{4,0,0,7,0,0,-1,1,2},{4,0,0,10,0,0,-1,1,9},{4,0,0,10,0,0,-1,1,9}},
  {{4,0,0,10,0,0,-1,1,9},{4,0,0,12,17,0,-1,1,9},{4,0,0,12,17,0,-1,1,9},{4,0,0,12,17,0,-1,1,9},{4,0,0,12,17,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{4,0,0,10,0,0,-1,1,9},{4,0,0,10,0,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{4,0,0,10,0,0,-1,1,9},{4,0,0,10,0,0,-1,1,9},{4,0,0,12,17,0,-1,1,9},{4,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0}},
  {{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{4,0,0,10,0,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{4,0,0,7,0,9,-1,1,2},{4,0,0,7,0,9,-1,1,2},{103,0,0,2,0,12,-1,1,0},{4,0,0,7,0,9,-1,1,2}},
  {{4,0,0,7,0,0,-1,1,2},{4,0,0,7,0,0,-1,1,2},{4,0,0,12,17,0,-1,1,9},{4,0,0,12,17,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{4,0,0,13,0,0,0,1,19},{4,0,0,13,0,0,1,1,19},{4,0,0,13,0,0,2,1,19},{4,0,0,13,0,0,3,1,19},{4,0,0,13,0,0,4,1,19},{4,0,0,13,0,0,5,1,19},{4,0,0,13,0,0,6,1,19},{4,0,0,13,0,0,7,1,19},{4,0,0,13,0,0,8,1,19},{4,0,0,13,0,0,9,1,19}},
  {{4,0,0,7,0,0,-1,1,2},{4,0,0,7,0,0,-1,1,2},{4,0,0,23,4,8,-1,1,21},{4,0,0,23,4,8,-1,1,21},{4,0,0,15,0,8,-1,1,2},{4,0,0,15,0,8,-1,1,2},{4,0,0,15,0,8,-1,1,2},{4,0,0,15,0,8,-1,1,2},{4,0,0,15,0,8,-1,1,2},{4,0,0,15,0,8,-1,1,21},{4,0,0,26,0,8,-1,1,2},{4,0,0,23,4,8,-1,1,22},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{103,0,0,2,0,12,-1,1,0},{16,0,0,12,17,0,-1,1,9},{16,0,0,12,17,0,-1,1,9},{16,0,0,10,0,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{16,0,0,7,0,0,-1,1,2},{16,0,0,7,0,0,-1,1,2},{16,0,0,7,0,0,-1,1,2},{16,0,0,7,0,0,-1,1,2},{16,0,0,7,0,0,-1,1,2},{16,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{16,0,0,7,0,0,-1,1,2}},
  {{16,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{16,0,0,7,0,0,-1,1,2},{16,0,0,7,0,0,-1,1,2},{16,0,0,7,0,0,-1,1,2},{16,0,0,7,0,0,-1,1,2},{16,0,0,7,0,0,-1,1,2},{16,0,0,7,0,0,-1,1,2},{16,0,0,7,0,0,-1,1,2},{16,0,0,7,0,0,-1,1,2},{16,0,0,7,0,0,-1,1,2},{16,0,0,7,0,0,-1,1,2},{16,0,0,7,0,0,-1,1,2},{16,0,0,7,0,0,-1,1,2},{16,0,0,7,0,0,-1,1,2}},
  {{16,0,0,7,0,0,-1,1,2},{16,0,0,7,0,0,-1,1,2},{16,0,0,7,0,0,-1,1,2},{16,0,0,7,0,0,-1,1,2},{16,0,0,7,0,0,-1,1,2},{16,0,0,7,0,0,-1,1,2},{16,0,0,7,0,0,-1,1,2},{16,0,0,7,0,0,-1,1,2},{16,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{16,0,0,7,0,0,-1,1,2},{16,0,0,7,0,0,-1,1,2},{16,0,0,7,0,0,-1,1,2},{16,0,0,7,0,0,-1,1,2},{16,0,0,7,0,0,-1,1,2},{16,0,0,7,0,0,-1,1,2}},
  {{16,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{16,0,0,7,0,0,-1,1,2},{16,0,0,7,0,9,-1,1,2},{103,0,0,2,0,12,-1,1,0},{16,0,0,7,0,0,-1,1,2},{16,0,0,7,0,9,-1,1,2},{103,0,0,2,0,12,-1,1,0},{16,0,0,7,0,0,-1,1,2},{16,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{16,0,0,12,17,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{16,0,0,10,0,0,-1,1,9},{16,0,0,10,0,0,-1,1,9}},
  {{16,0,0,10,0,0,-1,1,9},{16,0,0,12,17,0,-1,1,9},{16,0,0,12,17,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{16,0,0,12,17,0,-1,1,9},{16,0,0,12,17,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{16,0,0,12,17,0,-1,1,9},{16,0,0,12,17,0,-1,1,9},{16,0,0,12,17,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{103,0,0,2,0,12,-1,1,0},{16,0,0,12,17,2,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{16,0,0,7,0,9,-1,1,2},{16,0,0,7,0,9,-1,1,2},{16,0,0,7,0,9,-1,1,2},{16,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{16,0,0,7,0,9,-1,1,2},{103,0,0,2,0,12,-1,1,0}},
  {{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{16,0,0,13,0,0,0,1,19},{16,0,0,13,0,0,1,1,19},{16,0,0,13,0,0,2,1,19},{16,0,0,13,0,0,3,1,19},{16,0,0,13,0,0,4,1,19},{16,0,0,13,0,0,5,1,19},{16,0,0,13,0,0,6,1,19},{16,0,0,13,0,0,7,1,19},{16,0,0,13,0,0,8,1,19},{16,0,0,13,0,0,9,1,19}},
  {{16,0,0,12,17,0,-1,1,9},{16,0,0,12,17,0,-1,1,9},{16,0,0,7,0,0,-1,1,2},{16,0,0,7,0,0,-1,1,2},{16,0,0,7,0,0,-1,1,2},{16,0,0,12,17,2,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{103,0,0,2,0,12,-1,1,0},{15,0,0,12,17,0,-1,1,9},{15,0,0,12,17,0,-1,1,9},{15,0,0,10,0,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{15,0,0,7,0,0,-1,1,2},{15,0,0,7,0,0,-1,1,2},{15,0,0,7,0,0,-1,1,2},{15,0,0,7,0,0,-1,1,2},{15,0,0,7,0,0,-1,1,2},{15,0,0,7,0,0,-1,1,2},{15,0,0,7,0,0,-1,1,2},{15,0,0,7,0,0,-1,1,2},{15,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{15,0,0,7,0,0,-1,1,2}},
  {{15,0,0,7,0,0,-1,1,2},{15,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{15,0,0,7,0,0,-1,1,2},{15,0,0,7,0,0,-1,1,2},{15,0,0,7,0,0,-1,1,2},{15,0,0,7,0,0,-1,1,2},{15,0,0,7,0,0,-1,1,2},{15,0,0,7,0,0,-1,1,2},{15,0,0,7,0,0,-1,1,2},{15,0,0,7,0,0,-1,1,2},{15,0,0,7,0,0,-1,1,2},{15,0,0,7,0,0,-1,1,2},{15,0,0,7,0,0,-1,1,2},{15,0,0,7,0,0,-1,1,2},{15,0,0,7,0,0,-1,1,2}},
  {{15,0,0,7,0,0,-1,1,2},{15,0,0,7,0,0,-1,1,2},{15,0,0,7,0,0,-1,1,2},{15,0,0,7,0,0,-1,1,2},{15,0,0,7,0,0,-1,1,2},{15,0,0,7,0,0,-1,1,2},{15,0,0,7,0,0,-1,1,2},{15,0,0,7,0,0,-1,1,2},{15,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{15,0,0,7,0,0,-1,1,2},{15,0,0,7,0,0,-1,1,2},{15,0,0,7,0,0,-1,1,2},{15,0,0,7,0,0,-1,1,2},{15,0,0,7,0,0,-1,1,2},{15,0,0,7,0,0,-1,1,2}},
  {{15,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{15,0,0,7,0,0,-1,1,2},{15,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{15,0,0,7,0,0,-1,1,2},{15,0,0,7,0,0,-1,1,2},{15,0,0,7,0,0,-1,1,2},{15,0,0,7,0,0,-1,1,2},{15,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{15,0,0,12,17,0,-1,1,9},{15,0,0,7,0,0,-1,1,2},{15,0,0,10,0,0,-1,1,9},{15,0,0,10,0,0,-1,1,9}},
  {{15,0,0,10,0,0,-1,1,9},{15,0,0,12,17,0,-1,1,9},{15,0,0,12,17,0,-1,1,9},{15,0,0,12,17,0,-1,1,9},{15,0,0,12,17,0,-1,1,9},{15,0,0,12,17,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{15,0,0,12,17,0,-1,1,9},{15,0,0,12,17,0,-1,1,9},{15,0,0,10,0,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{15,0,0,10,0,0,-1,1,9},{15,0,0,10,0,0,-1,1,9},{15,0,0,12,17,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{15,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{15,0,0,7,0,0,-1,1,2},{15,0,0,7,0,0,-1,1,2},{15,0,0,12,17,0,-1,1,9},{15,0,0,12,17,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{15,0,0,13,0,0,0,1,19},{15,0,0,13,0,0,1,1,19},{15,0,0,13,0,0,2,1,19},{15,0,0,13,0,0,3,1,19},{15,0,0,13,0,0,4,1,19},{15,0,0,13,0,0,5,1,19},{15,0,0,13,0,0,6,1,19},{15,0,0,13,0,0,7,1,19},{15,0,0,13,0,0,8,1,19},{15,0,0,13,0,0,9,1,19}},
  {{15,0,0,21,0,8,-1,1,2},{15,0,0,23,4,8,-1,1,22},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{15,0,0,7,0,2,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{103,0,0,2,0,12,-1,1,0},{31,0,0,12,17,0,-1,1,9},{31,0,0,10,0,0,-1,1,9},{31,0,0,10,0,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{31,0,0,7,0,0,-1,1,2},{31,0,0,7,0,0,-1,1,2},{31,0,0,7,0,0,-1,1,2},{31,0,0,7,0,0,-1,1,2},{31,0,0,7,0,0,-1,1,2},{31,0,0,7,0,0,-1,1,2},{31,0,0,7,0,0,-1,1,2},{31,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{31,0,0,7,0,0,-1,1,2}},
  {{31,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{31,0,0,7,0,0,-1,1,2},{31,0,0,7,0,0,-1,1,2},{31,0,0,7,0,0,-1,1,2},{31,0,0,7,0,0,-1,1,2},{31,0,0,7,0,0,-1,1,2},{31,0,0,7,0,0,-1,1,2},{31,0,0,7,0,0,-1,1,2},{31,0,0,7,0,0,-1,1,2},{31,0,0,7,0,0,-1,1,2},{31,0,0,7,0,0,-1,1,2},{31,0,0,7,0,0,-1,1,2},{31,0,0,7,0,0,-1,1,2},{31,0,0,7,0,0,-1,1,2}},
  {{31,0,0,7,0,0,-1,1,2},{31,0,0,7,0,0,-1,1,2},{31,0,0,7,0,0,-1,1,2},{31,0,0,7,0,0,-1,1,2},{31,0,0,7,0,0,-1,1,2},{31,0,0,7,0,0,-1,1,2},{31,0,0,7,0,0,-1,1,2},{31,0,0,7,0,0,-1,1,2},{31,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{31,0,0,7,0,0,-1,1,2},{31,0,0,7,0,0,-1,1,2},{31,0,0,7,0,0,-1,1,2},{31,0,0,7,0,0,-1,1,2},{31,0,0,7,0,0,-1,1,2},{31,0,0,7,0,0,-1,1,2}},
  {{31,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{31,0,0,7,0,0,-1,1,2},{31,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{31,0,0,7,0,0,-1,1,2},{31,0,0,7,0,0,-1,1,2},{31,0,0,7,0,0,-1,1,2},{31,0,0,7,0,0,-1,1,2},{31,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{31,0,0,12,17,0,-1,1,9},{31,0,0,7,0,0,-1,1,2},{31,0,0,10,0,0,-1,1,9},{31,0,0,12,17,0,-1,1,9}},
  {{31,0,0,10,0,0,-1,1,9},{31,0,0,12,17,0,-1,1,9},{31,0,0,12,17,0,-1,1,9},{31,0,0,12,17,0,-1,1,9},{31,0,0,12,17,2,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{31,0,0,10,0,0,-1,1,9},{31,0,0,10,0,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{31,0,0,10,0,0,-1,1,9},{31,0,0,10,0,0,-1,1,9},{31,0,0,12,17,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{31,0,0,12,17,0,-1,1,9},{31,0,0,10,0,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{31,0,0,7,0,9,-1,1,2},{31,0,0,7,0,9,-1,1,2},{103,0,0,2,0,12,-1,1,0},{31,0,0,7,0,0,-1,1,2}},
  {{31,0,0,7,0,0,-1,1,2},{31,0,0,7,0,0,-1,1,2},{31,0,0,12,17,2,-1,1,9},{31,0,0,12,17,2,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{31,0,0,13,0,0,0,1,19},{31,0,0,13,0,0,1,1,19},{31,0,0,13,0,0,2,1,19},{31,0,0,13,0,0,3,1,19},{31,0,0,13,0,0,4,1,19},{31,0,0,13,0,0,5,1,19},{31,0,0,13,0,0,6,1,19},{31,0,0,13,0,0,7,1,19},{31,0,0,13,0,0,8,1,19},{31,0,0,13,0,0,9,1,19}},
  {{31,0,0,26,0,8,-1,1,2},{31,0,0,7,0,0,-1,1,2},{31,0,0,15,0,8,-1,1,2},{31,0,0,15,0,8,-1,1,2},{31,0,0,15,0,8,-1,1,2},{31,0,0,15,0,8,-1,1,2},{31,0,0,15,0,8,-1,1,2},{31,0,0,15,0,8,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{35,0,0,12,17,0,-1,1,9},{35,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{35,0,0,7,0,0,-1,1,2},{35,0,0,7,0,0,-1,1,2},{35,0,0,7,0,0,-1,1,2},{35,0,0,7,0,0,-1,1,2},{35,0,0,7,0,0,-1,1,2},{35,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{35,0,0,7,0,0,-1,1,2},{35,0,0,7,0,0,-1,1,2}},
  {{35,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{35,0,0,7,0,0,-1,1,2},{35,0,0,7,0,0,-1,1,2},{35,0,0,7,0,0,-1,1,2},{35,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{35,0,0,7,0,0,-1,1,2},{35,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{35,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{35,0,0,7,0,0,-1,1,2},{35,0,0,7,0,0,-1,1,2}},
  {{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{35,0,0,7,0,0,-1,1,2},{35,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{35,0,0,7,0,0,-1,1,2},{35,0,0,7,0,0,-1,1,2},{35,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{35,0,0,7,0,0,-1,1,2},{35,0,0,7,0,0,-1,1,2}},
  {{35,0,0,7,0,0,-1,1,2},{35,0,0,7,0,0,-1,1,2},{35,0,0,7,0,0,-1,1,2},{35,0,0,7,0,0,-1,1,2},{35,0,0,7,0,0,-1,1,2},{35,0,0,7,0,0,-1,1,2},{35,0,0,7,0,0,-1,1,2},{35,0,0,7,0,0,-1,1,2},{35,0,0,7,0,0,-1,1,2},{35,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{35,0,0,10,0,0,-1,1,9},{35,0,0,10,0,0,-1,1,9}},
  {{35,0,0,12,17,0,-1,1,9},{35,0,0,10,0,0,-1,1,9},{35,0,0,10,0,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{35,0,0,10,0,0,-1,1,9},{35,0,0,10,0,0,-1,1,9},{35,0,0,10,0,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{35,0,0,10,0,0,-1,1,9},{35,0,0,10,0,0,-1,1,9},{35,0,0,10,0,0,-1,1,9},{35,0,0,12,17,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{35,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{35,0,0,10,0,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{35,0,0,13,0,0,0,1,19},{35,0,0,13,0,0,1,1,19},{35,0,0,13,0,0,2,1,19},{35,0,0,13,0,0,3,1,19},{35,0,0,13,0,0,4,1,19},{35,0,0,13,0,0,5,1,19},{35,0,0,13,0,0,6,1,19},{35,0,0,13,0,0,7,1,19},{35,0,0,13,0,0,8,1,19},{35,0,0,13,0,0,9,1,19}},
  {{35,0,0,15,0,8,-1,1,2},{35,0,0,15,0,8,-1,1,2},{35,0,0,15,0,8,-1,1,2},{35,0,0,26,10,8,-1,1,2},{35,0,0,26,10,8,-1,1,2},{35,0,0,26,10,8,-1,1,2},{35,0,0,26,10,8,-1,1,2},{35,0,0,26,10,8,-1,1,2},{35,0,0,26,10,8,-1,1,2},{35,0,0,23,4,8,-1,1,22},{35,0,0,26,10,8,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{36,0,0,12,17,4,-1,1,9},{36,0,0,10,0,0,-1,1,9},{36,0,0,10,0,0,-1,1,9},{36,0,0,10,0,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2}},
  {{36,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2}},
  {{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2}},
  {{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,4,-1,1,2},{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{36,0,0,7,0,0,-1,1,2},{36,0,0,12,17,0,-1,1,9},{36,0,0,12,17,0,-1,1,9}},
  {{36,0,0,12,17,0,-1,1,9},{36,0,0,10,0,0,-1,1,9},{36,0,0,10,0,0,-1,1,9},{36,0,0,10,0,0,-1,1,9},{36,0,0,10,0,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{36,0,0,12,17,0,-1,1,9},{36,0,0,12,17,0,-1,1,9},{36,0,0,12,17,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{36,0,0,12,17,0,-1,1,9},{36,0,0,12,17,0,-1,1,9},{36,0,0,12,17,0,-1,1,9},{36,0,0,12,17,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{36,0,0,12,17,0,-1,1,9},{36,0,0,12,17,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{36,0,0,7,0,4,-1,1,2},{36,0,0,7,0,4,-1,1,2},{36,0,0,7,0,2,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{36,0,0,7,0,0,-1,1,2},{36,0,0,7,0,0,-1,1,2},{36,0,0,12,17,2,-1,1,9},{36,0,0,12,17,2,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{36,0,0,13,0,0,0,1,19},{36,0,0,13,0,0,1,1,19},{36,0,0,13,0,0,2,1,19},{36,0,0,13,0,0,3,1,19},{36,0,0,13,0,0,4,1,19},{36,0,0,13,0,0,5,1,19},{36,0,0,13,0,0,6,1,19},{36,0,0,13,0,0,7,1,19},{36,0,0,13,0,0,8,1,19},{36,0,0,13,0,0,9,1,19}},
  {{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{36,0,0,15,10,8,-1,1,2},{36,0,0,15,10,8,-1,1,2},{36,0,0,15,10,8,-1,1,2},{36,0,0,15,10,8,-1,1,2},{36,0,0,15,10,8,-1,1,2},{36,0,0,15,10,8,-1,1,2},{36,0,0,15,10,8,-1,1,2},{36,0,0,26,0,8,-1,1,2}},
  {{103,0,0,2,0,12,-1,1,0},{21,0,0,12,17,4,-1,1,9},{21,0,0,10,0,0,-1,1,9},{21,0,0,10,0,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2}},
  {{21,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2}},
  {{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2}},
  {{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{21,0,0,12,17,0,-1,1,9},{21,0,0,7,0,0,-1,1,2},{21,0,0,10,0,0,-1,1,9},{21,0,0,12,0,0,-1,1,9}},
  {{21,0,0,10,0,0,-1,1,9},{21,0,0,10,0,0,-1,1,9},{21,0,0,10,0,0,-1,1,9},{21,0,0,10,0,0,-1,1,9},{21,0,0,10,0,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{21,0,0,12,0,0,-1,1,9},{21,0,0,10,0,0,-1,1,9},{21,0,0,10,0,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{21,0,0,10,0,0,-1,1,9},{21,0,0,10,0,0,-1,1,9},{21,0,0,12,17,0,-1,1,9},{21,0,0,12,17,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{21,0,0,10,0,0,-1,1,9},{21,0,0,10,0,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{21,0,0,7,0,4,-1,1,2},{103,0,0,2,0,12,-1,1,0}},
  {{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2},{21,0,0,12,17,0,-1,1,9},{21,0,0,12,17,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{21,0,0,13,0,0,0,1,19},{21,0,0,13,0,0,1,1,19},{21,0,0,13,0,0,2,1,19},{21,0,0,13,0,0,3,1,19},{21,0,0,13,0,0,4,1,19},{21,0,0,13,0,0,5,1,19},{21,0,0,13,0,0,6,1,19},{21,0,0,13,0,0,7,1,19},{21,0,0,13,0,0,8,1,19},{21,0,0,13,0,0,9,1,19}},
  {{103,0,0,2,0,12,-1,1,0},{21,0,0,7,0,0,-1,1,2},{21,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{103,0,0,2,0,12,-1,1,0},{26,0,0,12,17,4,-1,1,9},{26,0,0,10,0,0,-1,1,9},{26,0,0,10,0,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2}},
  {{26,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2}},
  {{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2}},
  {{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{26,0,0,7,0,0,-1,1,2},{26,0,0,10,0,0,-1,1,9},{26,0,0,10,0,0,-1,1,9}},
  {{26,0,0,10,0,0,-1,1,9},{26,0,0,12,17,0,-1,1,9},{26,0,0,12,17,0,-1,1,9},{26,0,0,12,17,0,-1,1,9},{26,0,0,12,17,2,-1,1,9},{103,0,0,2,0,12,-1,1,0},{26,0,0,10,0,0,-1,1,9},{26,0,0,10,0,0,-1,1,9},{26,0,0,10,0,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{26,0,0,10,0,0,-1,1,9},{26,0,0,10,0,0,-1,1,9},{26,0,0,10,0,0,-1,1,9},{26,0,0,12,17,0,-1,1,9},{26,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0}},
  {{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{26,0,0,10,0,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{26,0,0,7,0,4,-1,1,2}},
  {{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,12,17,2,-1,1,9},{26,0,0,12,17,2,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{26,0,0,13,0,0,0,1,19},{26,0,0,13,0,0,1,1,19},{26,0,0,13,0,0,2,1,19},{26,0,0,13,0,0,3,1,19},{26,0,0,13,0,0,4,1,19},{26,0,0,13,0,0,5,1,19},{26,0,0,13,0,0,6,1,19},{26,0,0,13,0,0,7,1,19},{26,0,0,13,0,0,8,1,19},{26,0,0,13,0,0,9,1,19}},
  {{26,0,0,15,0,8,-1,1,2},{26,0,0,15,0,8,-1,1,2},{26,0,0,15,0,8,-1,1,2},{26,0,0,15,0,8,-1,1,2},{26,0,0,15,0,8,-1,1,2},{26,0,0,15,0,8,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{26,0,0,26,0,8,-1,1,21},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2},{26,0,0,7,0,0,-1,1,2}},
  {{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{33,0,0,10,0,0,-1,1,9},{33,0,0,10,0,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,3,-1,1,2}},
  {{33,0,0,7,0,3,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2}},
  {{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,3,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2}},
  {{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{33,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{33,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{33,0,0,12,17,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{33,0,0,10,0,0,-1,1,9}},
  {{33,0,0,10,0,0,-1,1,9},{33,0,0,10,0,0,-1,1,9},{33,0,0,12,17,0,-1,1,9},{33,0,0,12,17,0,-1,1,9},{33,0,0,12,17,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{33,0,0,12,17,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{33,0,0,10,0,0,-1,1,9},{33,0,0,10,0,0,-1,1,9},{33,0,0,10,0,0,-1,1,9},{33,0,0,10,0,0,-1,1,9},{33,0,0,10,0,0,-1,1,9},{33,0,0,10,0,0,-1,1,9},{33,0,0,10,0,0,-1,1,9},{33,0,0,10,0,3,-1,1,9}},
  {{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{33,0,0,13,0,4,0,1,19},{33,0,0,13,0,4,1,1,19},{33,0,0,13,0,4,2,1,19},{33,0,0,13,0,4,3,1,19},{33,0,0,13,0,4,4,1,19},{33,0,0,13,0,4,5,1,19},{33,0,0,13,0,4,6,1,19},{33,0,0,13,0,4,7,1,19},{33,0,0,13,0,4,8,1,19},{33,0,0,13,0,4,9,1,19}},
  {{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{33,0,0,10,0,0,-1,1,9},{33,0,0,10,0,3,-1,1,9},{33,0,0,21,0,8,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{103,0,0,2,0,12,-1,1,0},{38,0,0,7,0,0,-1,1,24},{38,0,0,7,0,0,-1,1,24},{38,0,0,7,0,0,-1,1,24},{38,0,0,7,0,0,-1,1,24},{38,0,0,7,0,0,-1,1,24},{38,0,0,7,0,0,-1,1,24},{38,0,0,7,0,0,-1,1,24},{38,0,0,7,0,0,-1,1,24},{38,0,0,7,0,0,-1,1,24},{38,0,0,7,0,0,-1,1,24},{38,0,0,7,0,0,-1,1,24},{38,0,0,7,0,0,-1,1,24},{38,0,0,7,0,0,-1,1,24},{38,0,0,7,0,0,-1,1,24},{38,0,0,7,0,0,-1,1,24}},
  {{38,0,0,7,0,0,-1,1,24},{38,0,0,7,0,0,-1,1,24},{38,0,0,7,0,0,-1,1,24},{38,0,0,7,0,0,-1,1,24},{38,0,0,7,0,0,-1,1,24},{38,0,0,7,0,0,-1,1,24},{38,0,0,7,0,0,-1,1,24},{38,0,0,7,0,0,-1,1,24},{38,0,0,7,0,0,-1,1,24},{38,0,0,7,0,0,-1,1,24},{38,0,0,7,0,0,-1,1,24},{38,0,0,7,0,0,-1,1,24},{38,0,0,7,0,0,-1,1,24},{38,0,0,7,0,0,-1,1,24},{38,0,0,7,0,0,-1,1,24},{38,0,0,7,0,0,-1,1,24}},
  {{38,0,0,7,0,0,-1,1,24},{38,0,0,12,17,0,-1,1,24},{38,0,0,7,0,0,-1,1,24},{38,0,0,7,0,9,-1,1,24},{38,0,0,12,17,0,-1,1,24},{38,0,0,12,17,0,-1,1,24},{38,0,0,12,17,0,-1,1,24},{38,0,0,12,17,0,-1,1,24},{38,0,0,12,17,0,-1,1,24},{38,0,0,12,17,0,-1,1,24},{38,0,0,12,17,0,-1,1,24},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{0,0,0,23,4,8,-1,1,22}},
  {{38,0,0,7,0,0,-1,1,24},{38,0,0,7,0,0,-1,1,24},{38,0,0,7,0,0,-1,1,24},{38,0,0,7,0,0,-1,1,24},{38,0,0,7,0,0,-1,1,24},{38,0,0,7,0,0,-1,1,24},{38,0,0,6,0,0,-1,1,24},{38,0,0,12,17,0,-1,1,24},{38,0,0,12,17,0,-1,1,24},{38,0,0,12,17,0,-1,1,24},{38,0,0,12,17,0,-1,1,24},{38,0,0,12,17,0,-1,1,24},{38,0,0,12,17,0,-1,1,24},{38,0,0,12,17,0,-1,1,24},{38,0,0,12,17,0,-1,1,24},{38,0,0,21,0,8,-1,1,2}},
  {{38,0,0,13,0,0,0,1,19},{38,0,0,13,0,0,1,1,19},{38,0,0,13,0,0,2,1,19},{38,0,0,13,0,0,3,1,19},{38,0,0,13,0,0,4,1,19},{38,0,0,13,0,0,5,1,19},{38,0,0,13,0,0,6,1,19},{38,0,0,13,0,0,7,1,19},{38,0,0,13,0,0,8,1,19},{38,0,0,13,0,0,9,1,19},{38,0,0,21,0,8,-1,1,4},{38,0,0,21,0,8,-1,1,4},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{103,0,0,2,0,12,-1,1,0},{24,0,0,7,0,0,-1,1,24},{24,0,0,7,0,0,-1,1,24},{103,0,0,2,0,12,-1,1,0},{24,0,0,7,0,0,-1,1,24},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{24,0,0,7,0,0,-1,1,24},{24,0,0,7,0,0,-1,1,24},{103,0,0,2,0,12,-1,1,0},{24,0,0,7,0,0,-1,1,24},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{24,0,0,7,0,0,-1,1,24},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{24,0,0,7,0,0,-1,1,24},{24,0,0,7,0,0,-1,1,24},{24,0,0,7,0,0,-1,1,24},{24,0,0,7,0,0,-1,1,24},{103,0,0,2,0,12,-1,1,0},{24,0,0,7,0,0,-1,1,24},{24,0,0,7,0,0,-1,1,24},{24,0,0,7,0,0,-1,1,24},{24,0,0,7,0,0,-1,1,24},{24,0,0,7,0,0,-1,1,24},{24,0,0,7,0,0,-1,1,24},{24,0,0,7,0,0,-1,1,24}},
  {{103,0,0,2,0,12,-1,1,0},{24,0,0,7,0,0,-1,1,24},{24,0,0,7,0,0,-1,1,24},{24,0,0,7,0,0,-1,1,24},{103,0,0,2,0,12,-1,1,0},{24,0,0,7,0,0,-1,1,24},{103,0,0,2,0,12,-1,1,0},{24,0,0,7,0,0,-1,1,24},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{24,0,0,7,0,0,-1,1,24},{24,0,0,7,0,0,-1,1,24},{103,0,0,2,0,12,-1,1,0},{24,0,0,7,0,0,-1,1,24},{24,0,0,7,0,0,-1,1,24},{24,0,0,7,0,0,-1,1,24}},
  {{24,0,0,7,0,0,-1,1,24},{24,0,0,12,17,0,-1,1,24},{24,0,0,7,0,0,-1,1,24},{24,0,0,7,0,9,-1,1,24},{24,0,0,12,17,0,-1,1,24},{24,0,0,12,17,0,-1,1,24},{24,0,0,12,17,0,-1,1,24},{24,0,0,12,17,0,-1,1,24},{24,0,0,12,17,0,-1,1,24},{24,0,0,12,17,0,-1,1,24},{103,0,0,2,0,12,-1,1,0},{24,0,0,12,17,0,-1,1,24},{24,0,0,12,17,0,-1,1,24},{24,0,0,7,0,0,-1,1,24},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{24,0,0,7,0,0,-1,1,24},{24,0,0,7,0,0,-1,1,24},{24,0,0,7,0,0,-1,1,24},{24,0,0,7,0,0,-1,1,24},{24,0,0,7,0,0,-1,1,24},{103,0,0,2,0,12,-1,1,0},{24,0,0,6,0,0,-1,1,24},{103,0,0,2,0,12,-1,1,0},{24,0,0,12,17,0,-1,1,24},{24,0,0,12,17,0,-1,1,24},{24,0,0,12,17,0,-1,1,24},{24,0,0,12,17,0,-1,1,24},{24,0,0,12,17,0,-1,1,24},{24,0,0,12,17,0,-1,1,24},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{24,0,0,13,0,0,0,1,19},{24,0,0,13,0,0,1,1,19},{24,0,0,13,0,0,2,1,19},{24,0,0,13,0,0,3,1,19},{24,0,0,13,0,0,4,1,19},{24,0,0,13,0,0,5,1,19},{24,0,0,13,0,0,6,1,19},{24,0,0,13,0,0,7,1,19},{24,0,0,13,0,0,8,1,19},{24,0,0,13,0,0,9,1,19},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{24,0,0,7,0,9,-1,1,24},{24,0,0,7,0,9,-1,1,24},{24,0,0,7,0,0,-1,1,24},{24,0,0,7,0,0,-1,1,24}},
  {{39,0,0,7,0,0,-1,1,2},{39,0,0,26,0,8,-1,1,5},{39,0,0,26,0,8,-1,1,5},{39,0,0,26,0,8,-1,1,5},{39,0,0,21,0,8,-1,1,5},{39,0,0,21,0,8,-1,1,2},{39,0,0,21,0,8,-1,1,5},{39,0,0,21,0,8,-1,1,5},{39,0,0,21,0,8,-1,1,12},{39,0,0,21,0,8,-1,1,5},{39,0,0,21,0,8,-1,1,5},{39,0,0,21,0,1,-1,1,4},{39,0,0,21,0,9,-1,1,12},{39,0,0,21,0,8,-1,1,11},{39,0,0,21,0,8,-1,1,11},{39,0,0,21,0,8,-1,1,11}},
  {{39,0,0,21,0,8,-1,1,11},{39,0,0,21,0,8,-1,1,11},{39,0,0,21,0,8,-1,1,12},{39,0,0,26,0,8,-1,1,2},{39,0,0,21,0,8,-1,1,11},{39,0,0,26,0,8,-1,1,2},{39,0,0,26,0,8,-1,1,2},{39,0,0,26,0,8,-1,1,2},{39,0,0,12,17,3,-1,1,9},{39,0,0,12,17,3,-1,1,9},{39,0,0,26,0,8,-1,1,2},{39,0,0,26,0,8,-1,1,2},{39,0,0,26,0,8,-1,1,2},{39,0,0,26,0,8,-1,1,2},{39,0,0,26,0,8,-1,1,2},{39,0,0,26,0,8,-1,1,2}},
  {{39,0,0,13,0,0,0,1,19},{39,0,0,13,0,0,1,1,19},{39,0,0,13,0,0,2,1,19},{39,0,0,13,0,0,3,1,19},{39,0,0,13,0,0,4,1,19},{39,0,0,13,0,0,5,1,19},{39,0,0,13,0,0,6,1,19},{39,0,0,13,0,0,7,1,19},{39,0,0,13,0,0,8,1,19},{39,0,0,13,0,0,9,1,19},{39,0,0,15,0,8,-1,1,2},{39,0,0,15,0,8,-1,1,2},{39,0,0,15,0,8,-1,1,2},{39,0,0,15,0,8,-1,1,2},{39,0,0,15,0,8,-1,1,2},{39,0,0,15,0,8,-1,1,2}},
  {{39,0,0,15,0,8,-1,1,2},{39,0,0,15,0,8,-1,1,2},{39,0,0,15,0,8,-1,1,2},{39,0,0,15,0,8,-1,1,2},{39,0,0,26,0,8,-1,1,4},{39,0,0,12,17,0,-1,1,9},{39,0,0,26,0,8,-1,1,2},{39,0,0,12,17,0,-1,1,9},{39,0,0,26,0,8,-1,1,2},{39,0,0,12,17,2,-1,1,9},{39,1,0,22,10,8,-1,1,20},{39,2,0,18,10,8,-1,1,8},{39,1,0,22,10,8,-1,1,20},{39,2,0,18,10,8,-1,1,8},{39,0,0,10,0,0,-1,1,9},{39,0,0,10,0,0,-1,1,9}},
  {{39,0,0,7,0,0,-1,1,2},{39,0,0,7,0,0,-1,1,2},{39,0,0,7,0,0,-1,1,2},{39,0,0,7,0,9,-1,1,2},{39,0,0,7,0,0,-1,1,2},{39,0,0,7,0,0,-1,1,2},{39,0,0,7,0,0,-1,1,2},{39,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{39,0,0,7,0,0,-1,1,2},{39,0,0,7,0,0,-1,1,2},{39,0,0,7,0,0,-1,1,2},{39,0,0,7,0,0,-1,1,2},{39,0,0,7,0,9,-1,1,2},{39,0,0,7,0,0,-1,1,2},{39,0,0,7,0,0,-1,1,2}},
  {{39,0,0,7,0,0,-1,1,2},{39,0,0,7,0,0,-1,1,2},{39,0,0,7,0,9,-1,1,2},{39,0,0,7,0,0,-1,1,2},{39,0,0,7,0,0,-1,1,2},{39,0,0,7,0,0,-1,1,2},{39,0,0,7,0,0,-1,1,2},{39,0,0,7,0,9,-1,1,2},{39,0,0,7,0,0,-1,1,2},{39,0,0,7,0,0,-1,1,2},{39,0,0,7,0,0,-1,1,2},{39,0,0,7,0,0,-1,1,2},{39,0,0,7,0,9,-1,1,2},{39,0,0,7,0,0,-1,1,2},{39,0,0,7,0,0,-1,1,2},{39,0,0,7,0,0,-1,1,2}},
  {{39,0,0,7,0,0,-1,1,2},{39,0,0,7,0,0,-1,1,2},{39,0,0,7,0,0,-1,1,2},{39,0,0,7,0,0,-1,1,2},{39,0,0,7,0,0,-1,1,2},{39,0,0,7,0,0,-1,1,2},{39,0,0,7,0,0,-1,1,2},{39,0,0,7,0,0,-1,1,2},{39,0,0,7,0,0,-1,1,2},{39,0,0,7,0,9,-1,1,2},{39,0,0,7,0,0,-1,1,2},{39,0,0,7,0,0,-1,1,2},{39,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{103,0,0,2,0,12,-1,1,0},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,9,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,9,-1,1,9},{39,0,0,12,17,9,-1,1,9},{39,0,0,12,17,11,-1,1,9},{39,0,0,12,17,9,-1,1,9},{39,0,0,12,17,11,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,10,0,0,-1,1,4}},
  {{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,9,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,21,0,8,-1,1,4},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,7,0,0,-1,1,2},{39,0,0,7,0,0,-1,1,2},{39,0,0,7,0,0,-1,1,2},{39,0,0,7,0,0,-1,1,2},{39,0,0,7,0,0,-1,1,2},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,0,-1,1,9}},
  {{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,9,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,9,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,0,-1,1,9}},
  {{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,9,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,9,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,9,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,0,-1,1,9}},
  {{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,9,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,0,-1,1,9},{39,0,0,12,17,0,-1,1,9},{103,0,0,2,0,12,-1,1,0},{39,0,0,26,0,8,-1,1,4},{39,0,0,26,0,8,-1,1,4}},
  {{39,0,0,26,0,8,-1,1,2},{39,0,0,26,0,8,-1,1,2},{39,0,0,26,0,8,-1,1,2},{39,0,0,26,0,8,-1,1,2},{39,0,0,26,0,8,-1,1,2},{39,0,0,26,0,8,-1,1,2},{39,0,0,12,17,0,-1,1,9},{39,0,0,26,0,8,-1,1,2},{39,0,0,26,0,8,-1,1,2},{39,0,0,26,0,8,-1,1,2},{39,0,0,26,0,8,-1,1,2},{39,0,0,26,0,8,-1,1,2},{39,0,0,26,0,8,-1,1,2},{103,0,0,2,0,12,-1,1,0},{39,0,0,26,0,8,-1,1,2},{39,0,0,26,0,8,-1,1,2}},
  {{39,0,0,21,0,8,-1,1,5},{39,0,0,21,0,8,-1,1,5},{39,0,0,21,0,8,-1,1,4},{39,0,0,21,0,8,-1,1,5},{39,0,0,21,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{39,0,0,21,0,8,-1,1,12},{39,0,0,21,0,8,-1,1,12},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24}},
  {{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,10,0,0,-1,1,24},{28,0,0,10,0,0,-1,1,24},{28,0,0,12,17,0,-1,1,24},{28,0,0,12,17,0,-1,1,24},{28,0,0,12,17,0,-1,1,24}},
  {{28,0,0,12,17,0,-1,1,24},{28,0,0,10,0,0,-1,1,24},{28,0,0,12,17,0,-1,1,24},{28,0,0,12,17,0,-1,1,24},{28,0,0,12,17,0,-1,1,24},{28,0,0,12,17,0,-1,1,24},{28,0,0,12,17,0,-1,1,24},{28,0,0,12,17,0,-1,1,24},{28,0,0,10,0,0,-1,1,24},{28,0,0,12,17,0,-1,1,24},{28,0,0,12,17,0,-1,1,24},{28,0,0,10,0,0,-1,1,24},{28,0,0,10,0,0,-1,1,24},{28,0,0,12,17,0,-1,1,24},{28,0,0,12,17,0,-1,1,24},{28,0,0,7,0,0,-1,1,24}},
  {{28,0,0,13,0,0,0,1,19},{28,0,0,13,0,0,1,1,19},{28,0,0,13,0,0,2,1,19},{28,0,0,13,0,0,3,1,19},{28,0,0,13,0,0,4,1,19},{28,0,0,13,0,0,5,1,19},{28,0,0,13,0,0,6,1,19},{28,0,0,13,0,0,7,1,19},{28,0,0,13,0,0,8,1,19},{28,0,0,13,0,0,9,1,19},{28,0,0,21,0,8,-1,1,4},{28,0,0,21,0,8,-1,1,4},{28,0,0,21,0,8,-1,1,2},{28,0,0,21,0,8,-1,1,2},{28,0,0,21,0,8,-1,1,2},{28,0,0,21,0,8,-1,1,2}},
  {{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,10,0,0,-1,1,24},{28,0,0,10,0,0,-1,1,24},{28,0,0,12,17,0,-1,1,24},{28,0,0,12,17,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,12,17,0,-1,1,24},{28,0,0,12,17,0,-1,1,24}},
  {{28,0,0,12,17,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,10,0,0,-1,1,24},{28,0,0,10,0,0,-1,1,24},{28,0,0,10,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,10,0,0,-1,1,24},{28,0,0,10,0,0,-1,1,24},{28,0,0,10,0,0,-1,1,24},{28,0,0,10,0,0,-1,1,24},{28,0,0,10,0,0,-1,1,24},{28,0,0,10,0,0,-1,1,24},{28,0,0,10,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24}},
  {{28,0,0,7,0,0,-1,1,24},{28,0,0,12,17,0,-1,1,24},{28,0,0,12,17,0,-1,1,24},{28,0,0,12,17,0,-1,1,24},{28,0,0,12,17,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24}},
  {{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,12,17,0,-1,1,24},{28,0,0,10,0,0,-1,1,24},{28,0,0,10,0,0,-1,1,24},{28,0,0,12,17,0,-1,1,24},{28,0,0,12,17,0,-1,1,24},{28,0,0,10,0,0,-1,1,24},{28,0,0,10,0,0,-1,1,24},{28,0,0,10,0,0,-1,1,24},{28,0,0,10,0,0,-1,1,24},{28,0,0,10,0,0,-1,1,24},{28,0,0,10,0,0,-1,1,24},{28,0,0,12,17,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,10,0,0,-1,1,24}},
  {{28,0,0,13,0,0,0,1,19},{28,0,0,13,0,0,1,1,19},{28,0,0,13,0,0,2,1,19},{28,0,0,13,0,0,3,1,19},{28,0,0,13,0,0,4,1,19},{28,0,0,13,0,0,5,1,19},{28,0,0,13,0,0,6,1,19},{28,0,0,13,0,0,7,1,19},{28,0,0,13,0,0,8,1,19},{28,0,0,13,0,0,9,1,19},{28,0,0,10,0,0,-1,1,24},{28,0,0,10,0,0,-1,1,24},{28,0,0,10,0,0,-1,1,24},{28,0,0,12,17,0,-1,1,24},{28,0,0,26,0,8,-1,1,24},{28,0,0,26,0,8,-1,1,24}},
  {{12,0,0,9,0,4,-1,1,2},{12,0,0,9,0,4,-1,1,2},{12,0,0,9,0,4,-1,1,2},{12,0,0,9,0,4,-1,1,2},{12,0,0,9,0,4,-1,1,2},{12,0,0,9,0,4,-1,1,2},{12,0,0,9,0,4,-1,1,2},{12,0,0,9,0,4,-1,1,2},{12,0,0,9,0,4,-1,1,2},{12,0,0,9,0,4,-1,1,2},{12,0,0,9,0,4,-1,1,2},{12,0,0,9,0,4,-1,1,2},{12,0,0,9,0,4,-1,1,2},{12,0,0,9,0,4,-1,1,2},{12,0,0,9,0,4,-1,1,2},{12,0,0,9,0,4,-1,1,2}},
  {{12,0,0,9,0,4,-1,1,2},{12,0,0,9,0,4,-1,1,2},{12,0,0,9,0,4,-1,1,2},{12,0,0,9,0,4,-1,1,2},{12,0,0,9,0,4,-1,1,2},{12,0,0,9,0,4,-1,1,2},{103,0,0,2,0,12,-1,1,0},{12,0,0,9,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{12,0,0,9,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{12,0,0,7,0,0,-1,1,2},{12,0,0,7,0,0,-1,1,2},{12,0,0,7,0,0,-1,1,2},{12,0,0,7,0,0,-1,1,2},{12,0,0,7,0,0,-1,1,2},{12,0,0,7,0,0,-1,1,2},{12,0,0,7,0,0,-1,1,2},{12,0,0,7,0,0,-1,1,2},{12,0,0,7,0,0,-1,1,2},{12,0,0,7,0,0,-1,1,2},{12,0,0,7,0,0,-1,1,2},{12,0,0,7,0,0,-1,1,2},{12,0,0,7,0,0,-1,1,2},{12,0,0,7,0,0,-1,1,2},{12,0,0,7,0,0,-1,1,2},{12,0,0,7,0,0,-1,1,2}},
  {{12,0,0,7,0,0,-1,1,2},{12,0,0,7,0,4,-1,1,2},{12,0,0,7,0,4,-1,1,2},{12,0,0,7,0,4,-1,1,2},{12,0,0,7,0,4,-1,1,2},{12,0,0,7,0,4,-1,1,2},{12,0,0,7,0,4,-1,1,2},{12,0,0,7,0,0,-1,1,2},{12,0,0,7,0,0,-1,1,2},{12,0,0,7,0,0,-1,1,2},{12,0,0,7,0,0,-1,1,2},{0,0,0,21,0,8,-1,1,2},{12,0,0,6,0,9,-1,1,2},{12,0,0,7,0,0,-1,1,2},{12,0,0,7,0,0,-1,1,2},{12,0,0,7,0,0,-1,1,2}},
  {{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33}},
  {{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,10,-1,0,33}},
  {{18,0,0,7,0,10,-1,0,35},{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35}},
  {{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35}},
  {{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,34},{18,0,0,7,0,4,-1,0,34},{18,0,0,7,0,4,-1,0,34},{18,0,0,7,0,4,-1,0,34},{18,0,0,7,0,4,-1,0,34},{18,0,0,7,0,4,-1,0,34},{18,0,0,7,0,4,-1,0,34},{18,0,0,7,0,4,-1,0,34}},
  {{18,0,0,7,0,4,-1,0,34},{18,0,0,7,0,4,-1,0,34},{18,0,0,7,0,4,-1,0,34},{18,0,0,7,0,4,-1,0,34},{18,0,0,7,0,4,-1,0,34},{18,0,0,7,0,4,-1,0,34},{18,0,0,7,0,4,-1,0,34},{18,0,0,7,0,4,-1,0,34},{18,0,0,7,0,4,-1,0,34},{18,0,0,7,0,4,-1,0,34},{18,0,0,7,0,4,-1,0,34},{18,0,0,7,0,4,-1,0,34},{18,0,0,7,0,4,-1,0,34},{18,0,0,7,0,4,-1,0,34},{18,0,0,7,0,4,-1,0,34},{18,0,0,7,0,4,-1,0,34}},
  {{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2}},
  {{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{11,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{11,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0}},
  {{11,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2}},
  {{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2}},
  {{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{11,0,0,12,17,0,-1,1,9},{11,0,0,12,17,0,-1,1,9},{11,0,0,12,17,0,-1,1,9}},
  {{11,0,0,21,0,8,-1,1,2},{11,0,0,21,0,8,-1,1,4},{11,0,0,21,0,8,-1,1,2},{11,0,0,21,0,8,-1,1,2},{11,0,0,21,0,8,-1,1,2},{11,0,0,21,0,8,-1,1,2},{11,0,0,21,0,8,-1,1,2},{11,0,0,21,0,8,-1,1,2},{11,0,0,21,0,8,-1,1,2},{11,0,0,15,0,4,1,1,2},{11,0,0,15,0,4,2,1,2},{11,0,0,15,0,4,3,1,2},{11,0,0,15,0,4,4,1,2},{11,0,0,15,0,4,5,1,2},{11,0,0,15,0,4,6,1,2},{11,0,0,15,0,4,7,1,2}},
  {{11,0,0,15,0,4,8,1,2},{11,0,0,15,0,4,9,1,2},{11,0,0,15,0,8,-1,1,2},{11,0,0,15,0,8,-1,1,2},{11,0,0,15,0,8,-1,1,2},{11,0,0,15,0,8,-1,1,2},{11,0,0,15,0,8,-1,1,2},{11,0,0,15,0,8,-1,1,2},{11,0,0,15,0,8,-1,1,2},{11,0,0,15,0,8,-1,1,2},{11,0,0,15,0,8,-1,1,2},{11,0,0,15,0,8,-1,1,2},{11,0,0,15,0,8,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{11,0,0,26,10,8,-1,1,2},{11,0,0,26,10,8,-1,1,2},{11,0,0,26,10,8,-1,1,2},{11,0,0,26,10,8,-1,1,2},{11,0,0,26,10,8,-1,1,2},{11,0,0,26,10,8,-1,1,2},{11,0,0,26,10,8,-1,1,2},{11,0,0,26,10,8,-1,1,2},{11,0,0,26,10,8,-1,1,2},{11,0,0,26,10,8,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{6,0,0,9,0,6,-1,1,2},{6,0,0,9,0,6,-1,1,2},{6,0,0,9,0,6,-1,1,2},{6,0,0,9,0,6,-1,1,2},{6,0,0,9,0,6,-1,1,2},{6,0,0,9,0,6,-1,1,2},{6,0,0,9,0,6,-1,1,2},{6,0,0,9,0,6,-1,1,2},{6,0,0,9,0,6,-1,1,2},{6,0,0,9,0,6,-1,1,2},{6,0,0,9,0,6,-1,1,2},{6,0,0,9,0,6,-1,1,2},{6,0,0,9,0,6,-1,1,2},{6,0,0,9,0,6,-1,1,2},{6,0,0,9,0,6,-1,1,2},{6,0,0,9,0,6,-1,1,2}},
  {{6,0,0,9,0,6,-1,1,2},{6,0,0,9,0,6,-1,1,2},{6,0,0,9,0,6,-1,1,2},{6,0,0,9,0,6,-1,1,2},{6,0,0,9,0,6,-1,1,2},{6,0,0,9,0,6,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{6,0,0,5,0,6,-1,1,2},{6,0,0,5,0,6,-1,1,2},{6,0,0,5,0,6,-1,1,2},{6,0,0,5,0,6,-1,1,2},{6,0,0,5,0,6,-1,1,2},{6,0,0,5,0,6,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{40,0,0,17,10,8,-1,1,4},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2}},
  {{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2}},
  {{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,21,0,8,-1,0,2},{40,0,0,21,0,8,-1,0,2},{40,0,0,7,0,5,-1,0,2}},
  {{29,0,0,29,9,8,-1,1,4},{29,0,0,7,0,7,-1,1,2},{29,0,0,7,0,7,-1,1,2},{29,0,0,7,0,7,-1,1,2},{29,0,0,7,0,7,-1,1,2},{29,0,0,7,0,7,-1,1,2},{29,0,0,7,0,7,-1,1,2},{29,0,0,7,0,7,-1,1,2},{29,0,0,7,0,7,-1,1,2},{29,0,0,7,0,7,-1,1,2},{29,0,0,7,0,7,-1,1,2},{29,0,0,7,0,7,-1,1,2},{29,0,0,7,0,7,-1,1,2},{29,0,0,7,0,7,-1,1,2},{29,0,0,7,0,7,-1,1,2},{29,0,0,7,0,7,-1,1,2}},
  {{29,0,0,7,0,7,-1,1,2},{29,0,0,7,0,7,-1,1,2},{29,0,0,7,0,7,-1,1,2},{29,0,0,7,0,7,-1,1,2},{29,0,0,7,0,7,-1,1,2},{29,0,0,7,0,7,-1,1,2},{29,0,0,7,0,7,-1,1,2},{29,0,0,7,0,7,-1,1,2},{29,0,0,7,0,7,-1,1,2},{29,0,0,7,0,7,-1,1,2},{29,0,0,7,0,7,-1,1,2},{29,1,0,22,10,8,-1,1,20},{29,2,0,18,10,8,-1,1,8},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{32,0,0,7,0,7,-1,1,2},{32,0,0,7,0,7,-1,1,2},{32,0,0,7,0,7,-1,1,2},{32,0,0,7,0,7,-1,1,2},{32,0,0,7,0,7,-1,1,2},{32,0,0,7,0,7,-1,1,2},{32,0,0,7,0,7,-1,1,2},{32,0,0,7,0,7,-1,1,2},{32,0,0,7,0,7,-1,1,2},{32,0,0,7,0,7,-1,1,2},{32,0,0,7,0,7,-1,1,2},{32,0,0,7,0,7,-1,1,2},{32,0,0,7,0,7,-1,1,2},{32,0,0,7,0,7,-1,1,2},{32,0,0,7,0,7,-1,1,2},{32,0,0,7,0,7,-1,1,2}},
  {{32,0,0,7,0,7,-1,1,2},{32,0,0,7,0,7,-1,1,2},{32,0,0,7,0,7,-1,1,2},{32,0,0,7,0,7,-1,1,2},{32,0,0,7,0,7,-1,1,2},{32,0,0,7,0,7,-1,1,2},{32,0,0,7,0,7,-1,1,2},{32,0,0,7,0,7,-1,1,2},{32,0,0,7,0,7,-1,1,2},{32,0,0,7,0,7,-1,1,2},{32,0,0,7,0,7,-1,1,2},{0,0,0,21,0,8,-1,1,4},{0,0,0,21,0,8,-1,1,4},{0,0,0,21,0,8,-1,1,4},{32,0,0,14,0,7,-1,1,2},{32,0,0,14,0,7,-1,1,2}},
  {{32,0,0,14,0,7,-1,1,2},{32,0,0,7,0,7,-1,1,2},{32,0,0,7,0,7,-1,1,2},{32,0,0,7,0,7,-1,1,2},{32,0,0,7,0,7,-1,1,2},{32,0,0,7,0,7,-1,1,2},{32,0,0,7,0,7,-1,1,2},{32,0,0,7,0,7,-1,1,2},{32,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{42,0,0,7,0,7,-1,1,2},{42,0,0,7,0,7,-1,1,2},{42,0,0,7,0,7,-1,1,2},{42,0,0,7,0,7,-1,1,2},{42,0,0,7,0,7,-1,1,2},{42,0,0,7,0,7,-1,1,2},{42,0,0,7,0,7,-1,1,2},{42,0,0,7,0,7,-1,1,2},{42,0,0,7,0,7,-1,1,2},{42,0,0,7,0,7,-1,1,2},{42,0,0,7,0,7,-1,1,2},{42,0,0,7,0,7,-1,1,2},{42,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{42,0,0,7,0,7,-1,1,2},{42,0,0,7,0,7,-1,1,2}},
  {{42,0,0,7,0,7,-1,1,2},{42,0,0,7,0,7,-1,1,2},{42,0,0,12,17,7,-1,1,9},{42,0,0,12,17,7,-1,1,9},{42,0,0,12,17,7,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{43,0,0,7,0,7,-1,1,2},{43,0,0,7,0,7,-1,1,2},{43,0,0,7,0,7,-1,1,2},{43,0,0,7,0,7,-1,1,2},{43,0,0,7,0,7,-1,1,2},{43,0,0,7,0,7,-1,1,2},{43,0,0,7,0,7,-1,1,2},{43,0,0,7,0,7,-1,1,2},{43,0,0,7,0,7,-1,1,2},{43,0,0,7,0,7,-1,1,2},{43,0,0,7,0,7,-1,1,2},{43,0,0,7,0,7,-1,1,2},{43,0,0,7,0,7,-1,1,2},{43,0,0,7,0,7,-1,1,2},{43,0,0,7,0,7,-1,1,2},{43,0,0,7,0,7,-1,1,2}},
  {{43,0,0,7,0,7,-1,1,2},{43,0,0,7,0,7,-1,1,2},{43,0,0,12,17,7,-1,1,9},{43,0,0,12,17,7,-1,1,9},{43,0,0,12,17,7,-1,1,9},{0,0,0,21,0,8,-1,1,4},{0,0,0,21,0,8,-1,1,4},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{44,0,0,7,0,7,-1,1,2},{44,0,0,7,0,7,-1,1,2},{44,0,0,7,0,7,-1,1,2},{44,0,0,7,0,7,-1,1,2},{44,0,0,7,0,7,-1,1,2},{44,0,0,7,0,7,-1,1,2},{44,0,0,7,0,7,-1,1,2},{44,0,0,7,0,7,-1,1,2},{44,0,0,7,0,7,-1,1,2},{44,0,0,7,0,7,-1,1,2},{44,0,0,7,0,7,-1,1,2},{44,0,0,7,0,7,-1,1,2},{44,0,0,7,0,7,-1,1,2},{44,0,0,7,0,7,-1,1,2},{44,0,0,7,0,7,-1,1,2},{44,0,0,7,0,7,-1,1,2}},
  {{44,0,0,7,0,7,-1,1,2},{44,0,0,7,0,7,-1,1,2},{44,0,0,12,17,7,-1,1,9},{44,0,0,12,17,7,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{45,0,0,7,0,7,-1,1,2},{45,0,0,7,0,7,-1,1,2},{45,0,0,7,0,7,-1,1,2},{45,0,0,7,0,7,-1,1,2},{45,0,0,7,0,7,-1,1,2},{45,0,0,7,0,7,-1,1,2},{45,0,0,7,0,7,-1,1,2},{45,0,0,7,0,7,-1,1,2},{45,0,0,7,0,7,-1,1,2},{45,0,0,7,0,7,-1,1,2},{45,0,0,7,0,7,-1,1,2},{45,0,0,7,0,7,-1,1,2},{45,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{45,0,0,7,0,7,-1,1,2},{45,0,0,7,0,7,-1,1,2}},
  {{45,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{45,0,0,12,17,7,-1,1,9},{45,0,0,12,17,7,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{23,0,0,7,0,0,-1,1,24},{23,0,0,7,0,0,-1,1,24},{23,0,0,7,0,0,-1,1,24},{23,0,0,7,0,0,-1,1,24},{23,0,0,7,0,0,-1,1,24},{23,0,0,7,0,0,-1,1,24},{23,0,0,7,0,0,-1,1,24},{23,0,0,7,0,0,-1,1,24},{23,0,0,7,0,0,-1,1,24},{23,0,0,7,0,0,-1,1,24},{23,0,0,7,0,0,-1,1,24},{23,0,0,7,0,0,-1,1,24},{23,0,0,7,0,0,-1,1,24},{23,0,0,7,0,0,-1,1,24},{23,0,0,7,0,0,-1,1,24},{23,0,0,7,0,0,-1,1,24}},
  {{23,0,0,7,0,0,-1,1,24},{23,0,0,7,0,0,-1,1,24},{23,0,0,7,0,0,-1,1,24},{23,0,0,7,0,11,-1,1,24},{23,0,0,7,0,11,-1,1,24},{23,0,0,7,0,0,-1,1,24},{23,0,0,7,0,0,-1,1,24},{23,0,0,7,0,0,-1,1,24},{23,0,0,7,0,4,-1,1,24},{23,0,0,7,0,0,-1,1,24},{23,0,0,7,0,0,-1,1,24},{23,0,0,7,0,0,-1,1,24},{23,0,0,7,0,0,-1,1,24},{23,0,0,7,0,0,-1,1,24},{23,0,0,7,0,0,-1,1,24},{23,0,0,7,0,0,-1,1,24}},
  {{23,0,0,7,0,0,-1,1,24},{23,0,0,7,0,0,-1,1,24},{23,0,0,7,0,0,-1,1,24},{23,0,0,7,0,0,-1,1,24},{23,0,0,12,17,10,-1,1,24},{23,0,0,12,17,10,-1,1,24},{23,0,0,10,0,0,-1,1,24},{23,0,0,12,17,0,-1,1,24},{23,0,0,12,17,0,-1,1,24},{23,0,0,12,17,0,-1,1,24},{23,0,0,12,17,0,-1,1,24},{23,0,0,12,17,0,-1,1,24},{23,0,0,12,17,0,-1,1,24},{23,0,0,12,17,0,-1,1,24},{23,0,0,10,0,0,-1,1,24},{23,0,0,10,0,0,-1,1,24}},
  {{23,0,0,10,0,0,-1,1,24},{23,0,0,10,0,0,-1,1,24},{23,0,0,10,0,0,-1,1,24},{23,0,0,10,0,0,-1,1,24},{23,0,0,10,0,0,-1,1,24},{23,0,0,10,0,0,-1,1,24},{23,0,0,12,17,0,-1,1,24},{23,0,0,10,0,0,-1,1,24},{23,0,0,10,0,0,-1,1,24},{23,0,0,12,17,0,-1,1,24},{23,0,0,12,17,0,-1,1,24},{23,0,0,12,17,3,-1,1,24},{23,0,0,12,17,3,-1,1,24},{23,0,0,12,17,3,-1,1,24},{23,0,0,12,17,3,-1,1,24},{23,0,0,12,17,3,-1,1,24}},
  {{23,0,0,12,17,3,-1,1,24},{23,0,0,12,17,4,-1,1,24},{23,0,0,12,17,0,-1,1,24},{23,0,0,12,17,4,-1,1,24},{23,0,0,21,0,8,-1,1,4},{23,0,0,21,0,8,-1,1,4},{23,0,0,21,0,8,-1,1,18},{23,0,0,6,0,0,-1,1,24},{23,0,0,21,0,8,-1,1,4},{23,0,0,21,0,8,-1,1,2},{23,0,0,21,0,8,-1,1,4},{23,0,0,23,4,8,-1,1,22},{23,0,0,7,0,0,-1,1,24},{23,0,0,12,17,4,-1,1,24},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{23,0,0,13,0,0,0,1,19},{23,0,0,13,0,0,1,1,19},{23,0,0,13,0,0,2,1,19},{23,0,0,13,0,0,3,1,19},{23,0,0,13,0,0,4,1,19},{23,0,0,13,0,0,5,1,19},{23,0,0,13,0,0,6,1,19},{23,0,0,13,0,0,7,1,19},{23,0,0,13,0,0,8,1,19},{23,0,0,13,0,0,9,1,19},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{23,0,0,15,10,8,-1,1,2},{23,0,0,15,10,8,-1,1,2},{23,0,0,15,10,8,-1,1,2},{23,0,0,15,10,8,-1,1,2},{23,0,0,15,10,8,-1,1,2},{23,0,0,15,10,8,-1,1,2},{23,0,0,15,10,8,-1,1,2},{23,0,0,15,10,8,-1,1,2},{23,0,0,15,10,8,-1,1,2},{23,0,0,15,10,8,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{27,0,0,21,10,8,-1,1,2},{27,0,0,21,10,8,-1,1,2},{0,0,0,21,10,8,-1,1,11},{0,0,0,21,10,8,-1,1,11},{27,0,0,21,10,8,-1,1,4},{0,0,0,21,10,8,-1,1,4},{27,0,0,17,10,8,-1,1,5},{27,0,0,21,10,8,-1,1,2},{27,0,0,21,10,8,-1,1,11},{27,0,0,21,10,8,-1,1,11},{27,0,0,21,10,8,-1,1,2},{27,0,0,12,17,10,-1,1,9},{27,0,0,12,17,10,-1,1,9},{27,0,0,12,17,10,-1,1,9},{27,0,0,1,18,10,-1,1,12},{103,0,0,2,0,12,-1,1,0}},
  {{27,0,0,13,0,5,0,1,19},{27,0,0,13,0,5,1,1,19},{27,0,0,13,0,5,2,1,19},{27,0,0,13,0,5,3,1,19},{27,0,0,13,0,5,4,1,19},{27,0,0,13,0,5,5,1,19},{27,0,0,13,0,5,6,1,19},{27,0,0,13,0,5,7,1,19},{27,0,0,13,0,5,8,1,19},{27,0,0,13,0,5,9,1,19},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2}},
  {{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,6,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2}},
  {{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,7,0,5,-1,1,2},{27,0,0,12,17,5,-1,1,9},{27,0,0,7,0,5,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{40,0,0,7,0,5,-1,0,2},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0}},
  {{48,0,0,7,0,6,-1,1,2},{48,0,0,7,0,6,-1,1,2},{48,0,0,7,0,6,-1,1,2},{48,0,0,7,0,6,-1,1,2},{48,0,0,7,0,6,-1,1,2},{48,0,0,7,0,6,-1,1,2},{48,0,0,7,0,6,-1,1,2},{48,0,0,7,0,6,-1,1,2},{48,0,0,7,0,6,-1,1,2},{48,0,0,7,0,6,-1,1,2},{48,0,0,7,0,6,-1,1,2},{48,0,0,7,0,6,-1,1,2},{48,0,0,7,0,6,-1,1,2},{48,0,0,7,0,6,-1,1,2},{48,0,0,7,0,6,-1,1,2},{48,0,0,7,0,6,-1,1,2}},
  {{48,0,0,7,0,6,-1,1,2},{48,0,0,7,0,6,-1,1,2},{48,0,0,7,0,6,-1,1,2},{48,0,0,7,0,6,-1,1,2},{48,0,0,7,0,6,-1,1,2},{48,0,0,7,0,6,-1,1,2},{48,0,0,7,0,6,-1,1,2},{48,0,0,7,0,6,-1,1,2},{48,0,0,7,0,6,-1,1,2},{48,0,0,7,0,6,-1,1,2},{48,0,0,7,0,6,-1,1,2},{48,0,0,7,0,6,-1,1,2},{48,0,0,7,0,6,-1,1,2},{48,0,0,7,0,6,-1,1,2},{48,0,0,7,0,6,-1,1,2},{103,0,0,2,0,12,-1,1,0}},
  {{48,0,0,12,17,6,-1,1,9},{48,0,0,12,17,6,-1,1,9},{48,0,0,12,17,6,-1,1,9},{48,0,0,10,0,6,-1,1,9},{48,0,0,10,0,6,-1,1,9},{48,0,0,10,0,6,-1,1,9},{48,0,0,10,0,6,-1,1,9},{48,0,0,12,17,6,-1,1,9},{48,0,0,12,17,6,-1,1,9},{48,0,0,10,0,6,-1,1,9},{48,0,0,10,0,6,-1,1,9},{48,0,0,10,0,6,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{48,0,0,10,0,6,-1,1,9},{48,0,0,10,0,6,-1,1,9},{48,0,0,12,17,6,-1,1,9},{48,0,0,10,0,6,-1,1,9},{48,0,0,10,0,6,-1,1,9},{48,0,0,10,0,6,-1,1,9},{48,0,0,10,0,6,-1,1,9},{48,0,0,10,0,6,-1,1,9},{48,0,0,10,0,6,-1,1,9},{48,0,0,12,17,6,-1,1,9},{48,0,0,12,17,6,-1,1,9},{48,0,0,12,17,6,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{48,0,0,26,10,8,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{48,0,0,21,10,8,-1,1,11},{48,0,0,21,10,8,-1,1,11},{48,0,0,13,0,6,0,1,19},{48,0,0,13,0,6,1,1,19},{48,0,0,13,0,6,2,1,19},{48,0,0,13,0,6,3,1,19},{48,0,0,13,0,6,4,1,19},{48,0,0,13,0,6,5,1,19},{48,0,0,13,0,6,6,1,19},{48,0,0,13,0,6,7,1,19},{48,0,0,13,0,6,8,1,19},{48,0,0,13,0,6,9,1,19}},
  {{52,0,0,7,0,6,-1,1,24},{52,0,0,7,0,6,-1,1,24},{52,0,0,7,0,6,-1,1,24},{52,0,0,7,0,6,-1,1,24},{52,0,0,7,0,6,-1,1,24},{52,0,0,7,0,6,-1,1,24},{52,0,0,7,0,6,-1,1,24},{52,0,0,7,0,6,-1,1,24},{52,0,0,7,0,6,-1,1,24},{52,0,0,7,0,6,-1,1,24},{52,0,0,7,0,6,-1,1,24},{52,0,0,7,0,6,-1,1,24},{52,0,0,7,0,6,-1,1,24},{52,0,0,7,0,6,-1,1,24},{52,0,0,7,0,6,-1,1,24},{52,0,0,7,0,6,-1,1,24}},
  {{52,0,0,7,0,6,-1,1,24},{52,0,0,7,0,6,-1,1,24},{52,0,0,7,0,6,-1,1,24},{52,0,0,7,0,6,-1,1,24},{52,0,0,7,0,6,-1,1,24},{52,0,0,7,0,6,-1,1,24},{52,0,0,7,0,6,-1,1,24},{52,0,0,7,0,6,-1,1,24},{52,0,0,7,0,6,-1,1,24},{52,0,0,7,0,6,-1,1,24},{52,0,0,7,0,6,-1,1,24},{52,0,0,7,0,6,-1,1,24},{52,0,0,7,0,6,-1,1,24},{52,0,0,7,0,6,-1,1,24},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{52,0,0,7,0,6,-1,1,24},{52,0,0,7,0,6,-1,1,24},{52,0,0,7,0,6,-1,1,24},{52,0,0,7,0,6,-1,1,24},{52,0,0,7,0,6,-1,1,24},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{59,0,0,7,0,6,-1,1,24},{59,0,0,7,0,6,-1,1,24},{59,0,0,7,0,6,-1,1,24},{59,0,0,7,0,6,-1,1,24},{59,0,0,7,0,6,-1,1,24},{59,0,0,7,0,6,-1,1,24},{59,0,0,7,0,6,-1,1,24},{59,0,0,7,0,6,-1,1,24},{59,0,0,7,0,6,-1,1,24},{59,0,0,7,0,6,-1,1,24},{59,0,0,7,0,6,-1,1,24},{59,0,0,7,0,6,-1,1,24},{59,0,0,7,0,6,-1,1,24},{59,0,0,7,0,6,-1,1,24},{59,0,0,7,0,6,-1,1,24},{59,0,0,7,0,6,-1,1,24}},
  {{59,0,0,7,0,6,-1,1,24},{59,0,0,7,0,6,-1,1,24},{59,0,0,7,0,6,-1,1,24},{59,0,0,7,0,6,-1,1,24},{59,0,0,7,0,6,-1,1,24},{59,0,0,7,0,6,-1,1,24},{59,0,0,7,0,6,-1,1,24},{59,0,0,7,0,6,-1,1,24},{59,0,0,7,0,6,-1,1,24},{59,0,0,7,0,6,-1,1,24},{59,0,0,7,0,6,-1,1,24},{59,0,0,7,0,6,-1,1,24},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{59,0,0,7,0,6,-1,1,24},{59,0,0,7,0,6,-1,1,24},{59,0,0,7,0,6,-1,1,24},{59,0,0,7,0,6,-1,1,24},{59,0,0,7,0,6,-1,1,24},{59,0,0,7,0,6,-1,1,24},{59,0,0,7,0,6,-1,1,24},{59,0,0,7,0,6,-1,1,24},{59,0,0,7,0,6,-1,1,24},{59,0,0,7,0,6,-1,1,24},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{59,0,0,13,0,6,0,1,19},{59,0,0,13,0,6,1,1,19},{59,0,0,13,0,6,2,1,19},{59,0,0,13,0,6,3,1,19},{59,0,0,13,0,6,4,1,19},{59,0,0,13,0,6,5,1,19},{59,0,0,13,0,6,6,1,19},{59,0,0,13,0,6,7,1,19},{59,0,0,13,0,6,8,1,19},{59,0,0,13,0,6,9,1,19},{59,0,0,15,0,6,1,1,24},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{59,0,0,26,10,8,-1,1,24},{59,0,0,26,10,8,-1,1,24}},
  {{23,0,0,26,10,8,-1,1,2},{23,0,0,26,10,8,-1,1,2},{23,0,0,26,10,8,-1,1,2},{23,0,0,26,10,8,-1,1,2},{23,0,0,26,10,8,-1,1,2},{23,0,0,26,10,8,-1,1,2},{23,0,0,26,10,8,-1,1,2},{23,0,0,26,10,8,-1,1,2},{23,0,0,26,10,8,-1,1,2},{23,0,0,26,10,8,-1,1,2},{23,0,0,26,10,8,-1,1,2},{23,0,0,26,10,8,-1,1,2},{23,0,0,26,10,8,-1,1,2},{23,0,0,26,10,8,-1,1,2},{23,0,0,26,10,8,-1,1,2},{23,0,0,26,10,8,-1,1,2}},
  {{55,0,0,7,0,7,-1,1,2},{55,0,0,7,0,7,-1,1,2},{55,0,0,7,0,7,-1,1,2},{55,0,0,7,0,7,-1,1,2},{55,0,0,7,0,7,-1,1,2},{55,0,0,7,0,7,-1,1,2},{55,0,0,7,0,7,-1,1,2},{55,0,0,7,0,7,-1,1,2},{55,0,0,7,0,7,-1,1,2},{55,0,0,7,0,7,-1,1,2},{55,0,0,7,0,7,-1,1,2},{55,0,0,7,0,7,-1,1,2},{55,0,0,7,0,7,-1,1,2},{55,0,0,7,0,7,-1,1,2},{55,0,0,7,0,7,-1,1,2},{55,0,0,7,0,7,-1,1,2}},
  {{55,0,0,7,0,7,-1,1,2},{55,0,0,7,0,7,-1,1,2},{55,0,0,7,0,7,-1,1,2},{55,0,0,7,0,7,-1,1,2},{55,0,0,7,0,7,-1,1,2},{55,0,0,7,0,7,-1,1,2},{55,0,0,7,0,7,-1,1,2},{55,0,0,12,17,7,-1,1,9},{55,0,0,12,17,7,-1,1,9},{55,0,0,10,0,7,-1,1,9},{55,0,0,10,0,7,-1,1,9},{55,0,0,12,17,7,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{55,0,0,21,0,8,-1,1,2},{55,0,0,21,0,8,-1,1,2}},
  {{106,0,0,7,0,6,-1,1,24},{106,0,0,7,0,6,-1,1,24},{106,0,0,7,0,6,-1,1,24},{106,0,0,7,0,6,-1,1,24},{106,0,0,7,0,6,-1,1,24},{106,0,0,7,0,6,-1,1,24},{106,0,0,7,0,6,-1,1,24},{106,0,0,7,0,6,-1,1,24},{106,0,0,7,0,6,-1,1,24},{106,0,0,7,0,6,-1,1,24},{106,0,0,7,0,6,-1,1,24},{106,0,0,7,0,6,-1,1,24},{106,0,0,7,0,6,-1,1,24},{106,0,0,7,0,6,-1,1,24},{106,0,0,7,0,6,-1,1,24},{106,0,0,7,0,6,-1,1,24}},
  {{106,0,0,7,0,6,-1,1,24},{106,0,0,7,0,6,-1,1,24},{106,0,0,7,0,6,-1,1,24},{106,0,0,7,0,6,-1,1,24},{106,0,0,7,0,6,-1,1,24},{106,0,0,10,0,6,-1,1,24},{106,0,0,12,17,6,-1,1,24},{106,0,0,10,0,6,-1,1,24},{106,0,0,12,17,6,-1,1,24},{106,0,0,12,17,6,-1,1,24},{106,0,0,12,17,6,-1,1,24},{106,0,0,12,17,6,-1,1,24},{106,0,0,12,17,6,-1,1,24},{106,0,0,12,17,6,-1,1,24},{106,0,0,12,17,6,-1,1,24},{103,0,0,2,0,12,-1,1,0}},
  {{106,0,0,12,17,6,-1,1,24},{106,0,0,10,0,6,-1,1,24},{106,0,0,12,17,6,-1,1,24},{106,0,0,10,0,6,-1,1,24},{106,0,0,10,0,6,-1,1,24},{106,0,0,12,17,6,-1,1,24},{106,0,0,12,17,6,-1,1,24},{106,0,0,12,17,6,-1,1,24},{106,0,0,12,17,6,-1,1,24},{106,0,0,12,17,6,-1,1,24},{106,0,0,12,17,6,-1,1,24},{106,0,0,12,17,6,-1,1,24},{106,0,0,12,17,6,-1,1,24},{106,0,0,10,0,6,-1,1,24},{106,0,0,10,0,6,-1,1,24},{106,0,0,10,0,6,-1,1,24}},
  {{106,0,0,10,0,6,-1,1,24},{106,0,0,10,0,6,-1,1,24},{106,0,0,10,0,6,-1,1,24},{106,0,0,12,17,6,-1,1,24},{106,0,0,12,17,6,-1,1,24},{106,0,0,12,17,6,-1,1,24},{106,0,0,12,17,6,-1,1,24},{106,0,0,12,17,6,-1,1,24},{106,0,0,12,17,6,-1,1,24},{106,0,0,12,17,6,-1,1,24},{106,0,0,12,17,6,-1,1,24},{106,0,0,12,17,6,-1,1,24},{106,0,0,12,17,6,-1,1,24},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{106,0,0,12,17,6,-1,1,9}},
  {{106,0,0,13,0,6,0,1,19},{106,0,0,13,0,6,1,1,19},{106,0,0,13,0,6,2,1,19},{106,0,0,13,0,6,3,1,19},{106,0,0,13,0,6,4,1,19},{106,0,0,13,0,6,5,1,19},{106,0,0,13,0,6,6,1,19},{106,0,0,13,0,6,7,1,19},{106,0,0,13,0,6,8,1,19},{106,0,0,13,0,6,9,1,19},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{106,0,0,21,0,8,-1,1,24},{106,0,0,21,0,8,-1,1,24},{106,0,0,21,0,8,-1,1,24},{106,0,0,21,0,8,-1,1,24},{106,0,0,21,0,8,-1,1,24},{106,0,0,21,0,8,-1,1,24},{106,0,0,21,0,8,-1,1,24},{106,0,0,6,0,6,-1,1,24},{106,0,0,21,0,8,-1,1,24},{106,0,0,21,0,8,-1,1,24},{106,0,0,21,0,8,-1,1,24},{106,0,0,21,0,8,-1,1,24},{106,0,0,21,0,8,-1,1,24},{106,0,0,21,0,8,-1,1,24},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,11,17,8,-1,1,9},{103,0,0,2,0,12,-1,1,0}},
  {{62,0,0,12,17,6,-1,1,9},{62,0,0,12,17,6,-1,1,9},{62,0,0,12,17,6,-1,1,9},{62,0,0,12,17,6,-1,1,9},{62,0,0,10,0,6,-1,1,9},{62,0,0,7,0,6,-1,1,2},{62,0,0,7,0,6,-1,1,2},{62,0,0,7,0,6,-1,1,2},{62,0,0,7,0,6,-1,1,2},{62,0,0,7,0,6,-1,1,2},{62,0,0,7,0,6,-1,1,2},{62,0,0,7,0,6,-1,1,2},{62,0,0,7,0,6,-1,1,2},{62,0,0,7,0,6,-1,1,2},{62,0,0,7,0,6,-1,1,2},{62,0,0,7,0,6,-1,1,2}},
  {{62,0,0,7,0,6,-1,1,2},{62,0,0,7,0,6,-1,1,2},{62,0,0,7,0,6,-1,1,2},{62,0,0,7,0,6,-1,1,2},{62,0,0,7,0,6,-1,1,2},{62,0,0,7,0,6,-1,1,2},{62,0,0,7,0,6,-1,1,2},{62,0,0,7,0,6,-1,1,2},{62,0,0,7,0,6,-1,1,2},{62,0,0,7,0,6,-1,1,2},{62,0,0,7,0,6,-1,1,2},{62,0,0,7,0,6,-1,1,2},{62,0,0,7,0,6,-1,1,2},{62,0,0,7,0,6,-1,1,2},{62,0,0,7,0,6,-1,1,2},{62,0,0,7,0,6,-1,1,2}},
  {{62,0,0,7,0,6,-1,1,2},{62,0,0,7,0,6,-1,1,2},{62,0,0,7,0,6,-1,1,2},{62,0,0,7,0,6,-1,1,2},{62,0,0,12,17,6,-1,1,9},{62,0,0,10,0,6,-1,1,9},{62,0,0,12,17,6,-1,1,9},{62,0,0,12,17,6,-1,1,9},{62,0,0,12,17,6,-1,1,9},{62,0,0,12,17,6,-1,1,9},{62,0,0,12,17,6,-1,1,9},{62,0,0,10,0,6,-1,1,9},{62,0,0,12,17,6,-1,1,9},{62,0,0,10,0,6,-1,1,9},{62,0,0,10,0,6,-1,1,9},{62,0,0,10,0,6,-1,1,9}},
  {{62,0,0,10,0,6,-1,1,9},{62,0,0,10,0,6,-1,1,9},{62,0,0,12,17,6,-1,1,9},{62,0,0,10,0,6,-1,1,9},{62,0,0,10,0,6,-1,1,9},{62,0,0,7,0,6,-1,1,2},{62,0,0,7,0,6,-1,1,2},{62,0,0,7,0,6,-1,1,2},{62,0,0,7,0,6,-1,1,2},{62,0,0,7,0,6,-1,1,2},{62,0,0,7,0,6,-1,1,2},{62,0,0,7,0,6,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{62,0,0,13,0,6,0,1,19},{62,0,0,13,0,6,1,1,19},{62,0,0,13,0,6,2,1,19},{62,0,0,13,0,6,3,1,19},{62,0,0,13,0,6,4,1,19},{62,0,0,13,0,6,5,1,19},{62,0,0,13,0,6,6,1,19},{62,0,0,13,0,6,7,1,19},{62,0,0,13,0,6,8,1,19},{62,0,0,13,0,6,9,1,19},{62,0,0,21,0,8,-1,1,4},{62,0,0,21,0,8,-1,1,4},{62,0,0,21,0,8,-1,1,2},{62,0,0,21,0,8,-1,1,4},{62,0,0,21,0,8,-1,1,4},{62,0,0,21,0,8,-1,1,4}},
  {{62,0,0,21,0,8,-1,1,4},{62,0,0,26,0,8,-1,1,2},{62,0,0,26,0,8,-1,1,2},{62,0,0,26,0,8,-1,1,2},{62,0,0,26,0,8,-1,1,2},{62,0,0,26,0,8,-1,1,2},{62,0,0,26,0,8,-1,1,2},{62,0,0,26,0,8,-1,1,2},{62,0,0,26,0,8,-1,1,2},{62,0,0,26,0,8,-1,1,2},{62,0,0,26,0,8,-1,1,2},{62,0,0,12,17,6,-1,1,9},{62,0,0,12,17,6,-1,1,9},{62,0,0,12,17,6,-1,1,9},{62,0,0,12,17,6,-1,1,9},{62,0,0,12,17,6,-1,1,9}},
  {{62,0,0,12,17,6,-1,1,9},{62,0,0,12,17,6,-1,1,9},{62,0,0,12,17,6,-1,1,9},{62,0,0,12,17,6,-1,1,9},{62,0,0,26,0,8,-1,1,2},{62,0,0,26,0,8,-1,1,2},{62,0,0,26,0,8,-1,1,2},{62,0,0,26,0,8,-1,1,2},{62,0,0,26,0,8,-1,1,2},{62,0,0,26,0,8,-1,1,2},{62,0,0,26,0,8,-1,1,2},{62,0,0,26,0,8,-1,1,2},{62,0,0,26,0,8,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{113,0,0,12,17,6,-1,1,9},{113,0,0,12,17,6,-1,1,9},{113,0,0,10,0,6,-1,1,9},{113,0,0,7,0,6,-1,1,2},{113,0,0,7,0,6,-1,1,2},{113,0,0,7,0,6,-1,1,2},{113,0,0,7,0,6,-1,1,2},{113,0,0,7,0,6,-1,1,2},{113,0,0,7,0,6,-1,1,2},{113,0,0,7,0,6,-1,1,2},{113,0,0,7,0,6,-1,1,2},{113,0,0,7,0,6,-1,1,2},{113,0,0,7,0,6,-1,1,2},{113,0,0,7,0,6,-1,1,2},{113,0,0,7,0,6,-1,1,2},{113,0,0,7,0,6,-1,1,2}},
  {{113,0,0,7,0,6,-1,1,2},{113,0,0,7,0,6,-1,1,2},{113,0,0,7,0,6,-1,1,2},{113,0,0,7,0,6,-1,1,2},{113,0,0,7,0,6,-1,1,2},{113,0,0,7,0,6,-1,1,2},{113,0,0,7,0,6,-1,1,2},{113,0,0,7,0,6,-1,1,2},{113,0,0,7,0,6,-1,1,2},{113,0,0,7,0,6,-1,1,2},{113,0,0,7,0,6,-1,1,2},{113,0,0,7,0,6,-1,1,2},{113,0,0,7,0,6,-1,1,2},{113,0,0,7,0,6,-1,1,2},{113,0,0,7,0,6,-1,1,2},{113,0,0,7,0,6,-1,1,2}},
  {{113,0,0,7,0,6,-1,1,2},{113,0,0,10,0,6,-1,1,9},{113,0,0,12,17,6,-1,1,9},{113,0,0,12,17,6,-1,1,9},{113,0,0,12,17,6,-1,1,9},{113,0,0,12,17,6,-1,1,9},{113,0,0,10,0,6,-1,1,9},{113,0,0,10,0,6,-1,1,9},{113,0,0,12,17,6,-1,1,9},{113,0,0,12,17,6,-1,1,9},{113,0,0,10,0,6,-1,1,9},{113,0,0,12,17,6,-1,1,9},{113,0,0,12,17,6,-1,1,9},{113,0,0,12,17,6,-1,1,9},{113,0,0,7,0,6,-1,1,2},{113,0,0,7,0,6,-1,1,2}},
  {{113,0,0,13,0,6,0,1,19},{113,0,0,13,0,6,1,1,19},{113,0,0,13,0,6,2,1,19},{113,0,0,13,0,6,3,1,19},{113,0,0,13,0,6,4,1,19},{113,0,0,13,0,6,5,1,19},{113,0,0,13,0,6,6,1,19},{113,0,0,13,0,6,7,1,19},{113,0,0,13,0,6,8,1,19},{113,0,0,13,0,6,9,1,19},{113,0,0,7,0,6,-1,1,2},{113,0,0,7,0,6,-1,1,2},{113,0,0,7,0,6,-1,1,2},{113,0,0,7,0,6,-1,1,2},{113,0,0,7,0,6,-1,1,2},{113,0,0,7,0,6,-1,1,2}},
  {{63,0,0,7,0,6,-1,1,2},{63,0,0,7,0,6,-1,1,2},{63,0,0,7,0,6,-1,1,2},{63,0,0,7,0,6,-1,1,2},{63,0,0,7,0,6,-1,1,2},{63,0,0,7,0,6,-1,1,2},{63,0,0,7,0,6,-1,1,2},{63,0,0,7,0,6,-1,1,2},{63,0,0,7,0,6,-1,1,2},{63,0,0,7,0,6,-1,1,2},{63,0,0,7,0,6,-1,1,2},{63,0,0,7,0,6,-1,1,2},{63,0,0,7,0,6,-1,1,2},{63,0,0,7,0,6,-1,1,2},{63,0,0,7,0,6,-1,1,2},{63,0,0,7,0,6,-1,1,2}},
  {{63,0,0,7,0,6,-1,1,2},{63,0,0,7,0,6,-1,1,2},{63,0,0,7,0,6,-1,1,2},{63,0,0,7,0,6,-1,1,2},{63,0,0,7,0,6,-1,1,2},{63,0,0,7,0,6,-1,1,2},{63,0,0,12,17,6,-1,1,9},{63,0,0,10,0,6,-1,1,9},{63,0,0,12,17,6,-1,1,9},{63,0,0,12,17,6,-1,1,9},{63,0,0,10,0,6,-1,1,9},{63,0,0,10,0,6,-1,1,9},{63,0,0,10,0,6,-1,1,9},{63,0,0,12,17,6,-1,1,9},{63,0,0,10,0,6,-1,1,9},{63,0,0,12,17,6,-1,1,9}},
  {{63,0,0,12,17,6,-1,1,9},{63,0,0,12,17,6,-1,1,9},{63,0,0,10,0,6,-1,1,9},{63,0,0,10,0,6,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{63,0,0,21,0,8,-1,1,2},{63,0,0,21,0,8,-1,1,2},{63,0,0,21,0,8,-1,1,2},{63,0,0,21,0,8,-1,1,2}},
  {{82,0,0,7,0,6,-1,1,2},{82,0,0,7,0,6,-1,1,2},{82,0,0,7,0,6,-1,1,2},{82,0,0,7,0,6,-1,1,2},{82,0,0,7,0,6,-1,1,2},{82,0,0,7,0,6,-1,1,2},{82,0,0,7,0,6,-1,1,2},{82,0,0,7,0,6,-1,1,2},{82,0,0,7,0,6,-1,1,2},{82,0,0,7,0,6,-1,1,2},{82,0,0,7,0,6,-1,1,2},{82,0,0,7,0,6,-1,1,2},{82,0,0,7,0,6,-1,1,2},{82,0,0,7,0,6,-1,1,2},{82,0,0,7,0,6,-1,1,2},{82,0,0,7,0,6,-1,1,2}},
  {{82,0,0,7,0,6,-1,1,2},{82,0,0,7,0,6,-1,1,2},{82,0,0,7,0,6,-1,1,2},{82,0,0,7,0,6,-1,1,2},{82,0,0,10,0,6,-1,1,9},{82,0,0,10,0,6,-1,1,9},{82,0,0,10,0,6,-1,1,9},{82,0,0,10,0,6,-1,1,9},{82,0,0,10,0,6,-1,1,9},{82,0,0,10,0,6,-1,1,9},{82,0,0,10,0,6,-1,1,9},{82,0,0,10,0,6,-1,1,9},{82,0,0,12,17,6,-1,1,9},{82,0,0,12,17,6,-1,1,9},{82,0,0,12,17,6,-1,1,9},{82,0,0,12,17,6,-1,1,9}},
  {{82,0,0,12,17,6,-1,1,9},{82,0,0,12,17,6,-1,1,9},{82,0,0,12,17,6,-1,1,9},{82,0,0,12,17,6,-1,1,9},{82,0,0,10,0,6,-1,1,9},{82,0,0,10,0,6,-1,1,9},{82,0,0,12,17,6,-1,1,9},{82,0,0,12,17,6,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{82,0,0,21,0,8,-1,1,4},{82,0,0,21,0,8,-1,1,4},{82,0,0,21,0,8,-1,1,4},{82,0,0,21,0,8,-1,1,4},{82,0,0,21,0,8,-1,1,4}},
  {{82,0,0,13,0,6,0,1,19},{82,0,0,13,0,6,1,1,19},{82,0,0,13,0,6,2,1,19},{82,0,0,13,0,6,3,1,19},{82,0,0,13,0,6,4,1,19},{82,0,0,13,0,6,5,1,19},{82,0,0,13,0,6,6,1,19},{82,0,0,13,0,6,7,1,19},{82,0,0,13,0,6,8,1,19},{82,0,0,13,0,6,9,1,19},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{82,0,0,7,0,6,-1,1,2},{82,0,0,7,0,6,-1,1,2},{82,0,0,7,0,6,-1,1,2}},
  {{109,0,0,13,0,6,0,1,19},{109,0,0,13,0,6,1,1,19},{109,0,0,13,0,6,2,1,19},{109,0,0,13,0,6,3,1,19},{109,0,0,13,0,6,4,1,19},{109,0,0,13,0,6,5,1,19},{109,0,0,13,0,6,6,1,19},{109,0,0,13,0,6,7,1,19},{109,0,0,13,0,6,8,1,19},{109,0,0,13,0,6,9,1,19},{109,0,0,7,0,6,-1,1,2},{109,0,0,7,0,6,-1,1,2},{109,0,0,7,0,6,-1,1,2},{109,0,0,7,0,6,-1,1,2},{109,0,0,7,0,6,-1,1,2},{109,0,0,7,0,6,-1,1,2}},
  {{109,0,0,7,0,6,-1,1,2},{109,0,0,7,0,6,-1,1,2},{109,0,0,7,0,6,-1,1,2},{109,0,0,7,0,6,-1,1,2},{109,0,0,7,0,6,-1,1,2},{109,0,0,7,0,6,-1,1,2},{109,0,0,7,0,6,-1,1,2},{109,0,0,7,0,6,-1,1,2},{109,0,0,7,0,6,-1,1,2},{109,0,0,7,0,6,-1,1,2},{109,0,0,7,0,6,-1,1,2},{109,0,0,7,0,6,-1,1,2},{109,0,0,7,0,6,-1,1,2},{109,0,0,7,0,6,-1,1,2},{109,0,0,7,0,6,-1,1,2},{109,0,0,7,0,6,-1,1,2}},
  {{109,0,0,7,0,6,-1,1,2},{109,0,0,7,0,6,-1,1,2},{109,0,0,7,0,6,-1,1,2},{109,0,0,7,0,6,-1,1,2},{109,0,0,7,0,6,-1,1,2},{109,0,0,7,0,6,-1,1,2},{109,0,0,7,0,6,-1,1,2},{109,0,0,7,0,6,-1,1,2},{109,0,0,6,0,6,-1,1,2},{109,0,0,6,0,6,-1,1,2},{109,0,0,6,0,6,-1,1,2},{109,0,0,6,0,6,-1,1,2},{109,0,0,6,0,6,-1,1,2},{109,0,0,6,0,6,-1,1,2},{109,0,0,21,0,8,-1,1,4},{109,0,0,21,0,8,-1,1,4}},
  {{113,0,0,21,0,8,-1,1,2},{113,0,0,21,0,8,-1,1,2},{113,0,0,21,0,8,-1,1,2},{113,0,0,21,0,8,-1,1,2},{113,0,0,21,0,8,-1,1,2},{113,0,0,21,0,8,-1,1,2},{113,0,0,21,0,8,-1,1,2},{113,0,0,21,0,8,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{0,0,0,21,0,8,-1,1,2},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9}},
  {{1,0,0,12,17,4,-1,1,9},{0,0,0,10,0,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{0,0,0,7,0,4,-1,1,2},{0,0,0,7,0,4,-1,1,2},{0,0,0,7,0,4,-1,1,2},{0,0,0,7,0,4,-1,1,2},{1,0,0,12,17,4,-1,1,9},{0,0,0,7,0,4,-1,1,2},{0,0,0,7,0,4,-1,1,2}},
  {{0,0,0,7,0,4,-1,1,2},{0,0,0,7,0,4,-1,1,2},{0,0,0,10,0,4,-1,1,9},{0,0,0,10,0,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{0,0,0,7,0,4,-1,1,2},{0,0,0,7,0,4,-1,1,2},{103,0,0,2,0,12,-1,1,0},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{14,0,0,5,0,3,-1,1,2},{14,0,0,5,0,3,-1,1,2},{14,0,0,5,0,3,-1,1,2},{14,0,0,5,0,3,-1,1,2},{14,0,0,5,0,3,-1,1,2},{8,0,0,5,0,3,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,3,-1,1,2}},
  {{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,3,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2}},
  {{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,3,-1,1,2},{25,0,0,6,0,9,-1,1,2}},
  {{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{14,0,0,6,0,9,-1,1,2},{14,0,0,6,0,9,-1,1,2},{14,0,0,6,0,9,-1,1,2}},
  {{14,0,0,6,0,9,-1,1,2},{14,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{14,0,0,6,0,9,-1,1,2},{14,0,0,6,0,9,-1,1,2},{14,0,0,6,0,9,-1,1,2},{14,0,0,6,0,9,-1,1,2},{14,0,0,6,0,9,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2}},
  {{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{8,0,0,6,0,9,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2}},
  {{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2}},
  {{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2}},
  {{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{14,0,0,6,0,9,-1,1,2}},
  {{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,3,-1,1,9}},
  {{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9}},
  {{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,4,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9}},
  {{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9}},
  {{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,9,-1,1,2},{25,0,0,5,0,9,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,3,-1,1,2}},
  {{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,9,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,9,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2}},
  {{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2}},
  {{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{14,0,0,9,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{14,0,0,9,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{14,0,0,9,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{14,0,0,9,0,0,-1,1,2}},
  {{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,9,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,9,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,9,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,9,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,9,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,9,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,9,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,8,0,0,-1,1,2},{14,0,0,8,0,0,-1,1,2},{14,0,0,8,0,0,-1,1,2},{14,0,0,8,0,0,-1,1,2},{14,0,0,8,0,0,-1,1,2},{14,0,0,8,0,0,-1,1,2},{14,0,0,8,0,0,-1,1,2},{14,0,0,8,0,0,-1,1,2}},
  {{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,9,-1,1,2},{14,0,0,8,0,0,-1,1,2},{14,0,0,24,10,9,-1,1,2},{14,0,0,5,0,9,-1,1,2},{14,0,0,24,10,9,-1,1,2}},
  {{14,0,0,24,10,9,-1,1,2},{14,0,0,24,10,9,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,9,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,9,-1,1,2},{14,0,0,8,0,0,-1,1,2},{14,0,0,24,10,9,-1,1,2},{14,0,0,24,10,9,-1,1,2},{14,0,0,24,10,9,-1,1,2}},
  {{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,9,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,9,-1,1,2},{103,0,0,2,0,12,-1,1,0},{14,0,0,24,10,9,-1,1,2},{14,0,0,24,10,9,-1,1,2},{14,0,0,24,10,9,-1,1,2}},
  {{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,9,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,9,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,24,10,9,-1,1,2},{14,0,0,24,10,9,-1,1,2},{14,0,0,24,10,9,-1,1,2}},
  {{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{14,0,0,5,0,0,-1,1,2},{14,0,0,5,0,0,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,9,-1,1,2},{14,0,0,9,0,0,-1,1,2},{14,0,0,9,0,9,-1,1,2},{14,0,0,8,0,0,-1,1,2},{14,0,0,24,10,9,-1,1,5},{14,0,0,24,10,9,-1,1,2},{103,0,0,2,0,12,-1,1,0}},
  {{0,0,0,29,9,9,-1,1,4},{0,0,0,29,9,9,-1,1,4},{0,0,0,29,9,9,-1,1,4},{0,0,0,29,9,9,-1,1,4},{0,0,0,29,9,9,-1,1,4},{0,0,0,29,9,9,-1,1,4},{0,0,0,29,9,9,-1,1,4},{0,0,0,29,9,9,-1,1,12},{0,0,0,29,9,9,-1,1,4},{0,0,0,29,9,9,-1,1,4},{0,0,0,29,9,9,-1,1,4},{0,0,0,1,18,10,-1,1,28},{1,0,0,1,18,1,-1,1,9},{1,0,0,1,18,1,-1,1,9},{0,0,0,1,0,10,-1,1,9},{0,0,0,1,1,10,-1,1,9}},
  {{0,0,0,17,10,1,-1,1,4},{0,0,0,17,10,9,-1,1,12},{0,0,0,17,10,8,-1,1,4},{0,0,0,17,10,8,-1,1,4},{0,0,0,17,10,8,-1,1,3},{0,0,0,17,10,8,-1,1,1},{0,0,0,21,10,8,-1,0,1},{0,0,0,21,10,9,-1,1,2},{0,0,0,20,10,8,-1,1,23},{0,0,0,19,10,1,-1,1,23},{0,0,0,22,10,8,-1,1,20},{0,0,0,20,10,8,-1,1,23},{0,0,0,20,10,8,-1,1,23},{0,0,0,19,10,8,-1,1,23},{0,0,0,22,10,8,-1,1,20},{0,0,0,20,10,8,-1,1,23}},
  {{0,0,0,21,10,8,-1,0,1},{0,0,0,21,10,8,-1,0,1},{0,0,0,21,10,8,-1,1,2},{0,0,0,21,10,8,-1,1,2},{0,0,0,21,10,9,-1,1,15},{0,0,0,21,10,9,-1,1,15},{0,0,0,21,10,9,-1,1,15},{0,0,0,21,10,1,-1,1,4},{0,0,0,27,9,8,-1,1,6},{0,0,0,28,7,8,-1,1,6},{0,0,0,1,11,10,-1,1,9},{0,0,0,1,14,10,-1,1,9},{0,0,0,1,16,10,-1,1,9},{0,0,0,1,12,10,-1,1,9},{0,0,0,1,15,10,-1,1,9},{0,0,0,29,6,9,-1,1,12}},
  {{0,0,0,21,4,8,-1,0,21},{0,0,0,21,4,8,-1,0,21},{0,0,0,21,4,8,-1,1,21},{0,0,0,21,4,9,-1,1,21},{0,0,0,21,4,9,-1,1,21},{0,0,0,21,10,8,-1,1,21},{0,0,0,21,10,9,-1,1,21},{0,0,0,21,10,9,-1,1,21},{0,0,0,21,10,8,-1,1,2},{0,0,0,20,10,8,-1,1,23},{0,0,0,19,10,8,-1,1,23},{0,0,0,21,10,8,-1,0,1},{0,0,0,21,10,9,-1,0,18},{0,0,0,21,10,8,-1,1,18},{0,0,0,21,10,9,-1,1,2},{0,0,0,16,10,3,-1,1,2}},
  {{0,0,0,16,10,3,-1,1,2},{0,0,0,21,10,8,-1,1,2},{0,0,0,21,10,8,-1,0,2},{0,0,0,21,10,8,-1,1,2},{0,0,0,25,6,8,-1,1,16},{0,1,0,22,10,8,-1,1,20},{0,2,0,18,10,8,-1,1,8},{0,0,0,21,10,9,-1,0,18},{0,0,0,21,10,9,-1,0,18},{0,0,0,21,10,9,-1,0,18},{0,0,0,21,10,8,-1,1,2},{0,0,0,21,10,8,-1,1,2},{0,0,0,21,10,8,-1,1,2},{0,0,0,21,10,8,-1,1,2},{0,0,0,21,10,8,-1,1,2},{0,0,0,21,10,8,-1,1,2}},
  {{0,0,0,21,10,8,-1,1,2},{0,0,0,21,10,8,-1,0,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,21,10,8,-1,1,2},{0,0,0,16,10,2,-1,1,2},{0,0,0,21,10,8,-1,1,2},{0,0,0,21,10,8,-1,1,4},{0,0,0,21,10,9,-1,1,2},{0,0,0,21,10,8,-1,1,4},{0,0,0,21,10,8,-1,1,4},{0,0,0,21,10,8,-1,1,4},{0,0,0,21,10,8,-1,1,4},{0,0,0,21,10,8,-1,1,2},{0,0,0,21,10,8,-1,1,4},{0,0,0,21,10,8,-1,1,4},{0,0,0,29,9,9,-1,1,4}},
  {{0,0,0,1,18,10,-1,1,30},{0,0,0,1,18,10,-1,1,2},{0,0,0,1,18,10,-1,1,2},{0,0,0,1,18,10,-1,1,2},{0,0,0,1,18,10,-1,1,2},{103,0,0,2,0,12,-1,0,0},{0,0,0,1,20,10,-1,1,9},{0,0,0,1,21,10,-1,1,9},{0,0,0,1,19,10,-1,1,9},{0,0,0,1,22,10,-1,1,9},{0,0,0,1,18,11,-1,1,9},{0,0,0,1,18,11,-1,1,9},{0,0,0,1,18,11,-1,1,9},{0,0,0,1,18,11,-1,1,9},{0,0,0,1,18,11,-1,1,9},{0,0,0,1,18,11,-1,1,9}},
  {{0,0,0,15,2,9,0,1,2},{25,0,0,6,0,9,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{0,0,0,15,2,9,4,1,1},{0,0,0,15,2,9,5,1,2},{0,0,0,15,2,9,6,1,2},{0,0,0,15,2,9,7,1,2},{0,0,0,15,2,9,8,1,2},{0,0,0,15,2,9,9,1,2},{0,0,0,25,3,9,-1,1,2},{0,0,0,25,3,9,-1,1,2},{0,0,0,25,10,9,-1,1,2},{0,1,0,22,10,9,-1,1,20},{0,2,0,18,10,9,-1,1,8},{25,0,0,6,0,9,-1,1,1}},
  {{0,0,0,15,2,9,0,1,2},{0,0,0,15,2,9,1,1,1},{0,0,0,15,2,9,2,1,1},{0,0,0,15,2,9,3,1,1},{0,0,0,15,2,9,4,1,1},{0,0,0,15,2,9,5,1,2},{0,0,0,15,2,9,6,1,2},{0,0,0,15,2,9,7,1,2},{0,0,0,15,2,9,8,1,2},{0,0,0,15,2,9,9,1,2},{0,0,0,25,3,9,-1,1,2},{0,0,0,25,3,9,-1,1,2},{0,0,0,25,10,9,-1,1,2},{0,1,0,22,10,9,-1,1,20},{0,2,0,18,10,9,-1,1,8},{103,0,0,2,0,12,-1,1,0}},
  {{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{0,0,0,23,4,8,-1,1,22},{0,0,0,23,4,8,-1,1,22},{0,0,0,23,4,8,-1,1,22},{0,0,0,23,4,8,-1,1,22},{0,0,0,23,4,8,-1,1,22},{0,0,0,23,4,8,-1,1,22},{0,0,0,23,4,8,-1,1,22},{0,0,0,23,4,8,-1,1,21},{0,0,0,23,4,9,-1,1,22},{0,0,1,23,4,8,-1,1,22},{0,0,0,23,4,8,-1,1,22},{0,0,0,23,4,8,-1,1,22},{0,0,0,23,4,8,-1,1,22},{0,0,0,23,4,8,-1,1,22},{0,0,0,23,4,8,-1,1,22},{0,0,0,23,4,8,-1,1,22}},
  {{0,0,0,23,4,8,-1,1,22},{0,0,0,23,4,8,-1,1,22},{0,0,0,23,4,8,-1,1,22},{0,0,0,23,4,8,-1,1,22},{0,0,0,23,4,8,-1,1,22},{0,0,0,23,4,8,-1,1,22},{0,0,0,23,4,8,-1,1,21},{0,0,0,23,4,8,-1,1,22},{0,0,0,23,4,8,-1,1,22},{0,0,0,23,4,8,-1,1,22},{0,0,0,23,4,8,-1,1,22},{0,0,0,23,4,8,-1,1,21},{0,0,0,23,4,8,-1,1,22},{0,0,0,23,4,8,-1,1,22},{0,0,0,23,4,8,-1,1,21},{103,0,0,2,4,12,-1,1,22}},
  {{103,0,0,2,4,12,-1,1,22},{103,0,0,2,4,12,-1,1,22},{103,0,0,2,4,12,-1,1,22},{103,0,0,2,4,12,-1,1,22},{103,0,0,2,4,12,-1,1,22},{103,0,0,2,4,12,-1,1,22},{103,0,0,2,4,12,-1,1,22},{103,0,0,2,4,12,-1,1,22},{103,0,0,2,4,12,-1,1,22},{103,0,0,2,4,12,-1,1,22},{103,0,0,2,4,12,-1,1,22},{103,0,0,2,4,12,-1,1,22},{103,0,0,2,4,12,-1,1,22},{103,0,0,2,4,12,-1,1,22},{103,0,0,2,4,12,-1,1,22},{103,0,0,2,4,12,-1,1,22}},
  {{1,0,0,12,17,7,-1,1,9},{1,0,0,12,17,7,-1,1,9},{1,0,0,12,17,7,-1,1,9},{1,0,0,12,17,7,-1,1,9},{1,0,0,12,17,7,-1,1,9},{1,0,0,12,17,7,-1,1,9},{1,0,0,12,17,7,-1,1,9},{1,0,0,12,17,7,-1,1,9},{1,0,0,12,17,7,-1,1,9},{1,0,0,12,17,7,-1,1,9},{1,0,0,12,17,7,-1,1,9},{1,0,0,12,17,7,-1,1,9},{1,0,0,12,17,7,-1,1,9},{1,0,0,11,17,8,-1,0,9},{1,0,0,11,17,8,-1,0,9},{1,0,0,11,17,8,-1,0,9}},
  {{1,0,0,11,17,8,-1,0,9},{1,0,0,12,17,7,-1,1,9},{1,0,0,11,17,8,-1,0,9},{1,0,0,11,17,8,-1,0,9},{1,0,0,11,17,8,-1,0,9},{1,0,0,12,17,7,-1,1,9},{1,0,0,12,17,7,-1,1,9},{1,0,0,12,17,7,-1,1,9},{1,0,0,12,17,7,-1,1,9},{1,0,0,12,17,7,-1,1,9},{1,0,0,12,17,7,-1,1,9},{1,0,0,12,17,7,-1,1,9},{1,0,0,12,17,7,-1,1,9},{1,0,0,12,17,7,-1,1,9},{1,0,0,12,17,7,-1,1,9},{1,0,0,12,17,7,-1,1,9}},
  {{1,0,0,12,17,7,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{0,0,0,26,10,9,-1,0,2},{0,0,0,26,10,9,-1,0,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,26,10,9,-1,0,21},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,9,-1,0,1},{0,0,0,26,10,9,-1,0,2},{0,0,0,9,0,9,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,9,-1,0,21},{0,0,0,5,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,0,2}},
  {{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,5,0,9,-1,0,1},{0,0,0,26,10,8,-1,0,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,26,10,9,-1,0,22},{0,0,0,26,10,8,-1,0,2},{0,0,0,25,10,3,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2}},
  {{0,0,0,26,10,9,-1,0,2},{0,0,0,26,10,9,-1,0,1},{0,0,0,26,10,9,-1,0,1},{0,0,0,26,10,8,-1,0,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,26,10,8,-1,0,2},{14,0,0,9,0,9,-1,1,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,26,10,8,-1,0,2},{25,0,0,9,0,9,-1,1,2},{25,0,0,9,0,9,-1,1,1},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,26,4,3,-1,0,2},{0,0,0,5,0,9,-1,1,2}},
  {{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{25,0,0,9,0,4,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,7,0,9,-1,0,2},{0,0,0,7,0,9,-1,0,2},{0,0,0,7,0,9,-1,0,2},{0,0,0,7,0,9,-1,0,2},{0,0,0,5,0,9,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,9,-1,0,2},{0,0,0,5,0,9,-1,0,2},{0,0,0,5,0,9,-1,0,2},{0,0,0,9,0,9,-1,0,2},{0,0,0,9,0,9,-1,0,2}},
  {{0,0,0,25,10,9,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,9,0,9,-1,0,2},{0,0,0,5,0,9,-1,0,2},{0,0,0,5,0,9,-1,0,2},{0,0,0,5,0,9,-1,0,2},{0,0,0,5,0,9,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{25,0,0,5,0,4,-1,1,2},{0,0,0,26,0,8,-1,0,2}},
  {{0,0,0,15,10,9,-1,0,2},{0,0,0,15,10,9,-1,0,2},{0,0,0,15,10,9,-1,0,2},{0,0,0,15,10,9,-1,0,2},{0,0,0,15,10,9,-1,0,1},{0,0,0,15,10,9,-1,0,1},{0,0,0,15,10,9,-1,0,2},{0,0,0,15,10,9,-1,0,2},{0,0,0,15,10,9,-1,0,2},{0,0,0,15,10,9,-1,0,2},{0,0,0,15,10,9,-1,0,2},{0,0,0,15,10,9,-1,0,1},{0,0,0,15,10,9,-1,0,2},{0,0,0,15,10,9,-1,0,2},{0,0,0,15,10,9,-1,0,1},{0,0,0,15,10,9,-1,0,2}},
  {{25,0,0,14,0,9,-1,0,1},{25,0,0,14,0,9,-1,0,1},{25,0,0,14,0,9,-1,0,1},{25,0,0,14,0,9,-1,0,1},{25,0,0,14,0,9,-1,0,1},{25,0,0,14,0,9,-1,0,1},{25,0,0,14,0,9,-1,0,1},{25,0,0,14,0,9,-1,0,1},{25,0,0,14,0,9,-1,0,1},{25,0,0,14,0,9,-1,0,1},{25,0,0,14,0,9,-1,0,1},{25,0,0,14,0,9,-1,0,1},{25,0,0,14,0,9,-1,0,2},{25,0,0,14,0,9,-1,0,2},{25,0,0,14,0,9,-1,0,2},{25,0,0,14,0,9,-1,0,2}},
  {{25,0,0,14,0,9,-1,0,1},{25,0,0,14,0,9,-1,0,1},{25,0,0,14,0,9,-1,0,1},{25,0,0,14,0,9,-1,0,1},{25,0,0,14,0,9,-1,0,1},{25,0,0,14,0,9,-1,0,1},{25,0,0,14,0,9,-1,0,1},{25,0,0,14,0,9,-1,0,1},{25,0,0,14,0,9,-1,0,1},{25,0,0,14,0,9,-1,0,1},{25,0,0,14,0,9,-1,0,2},{25,0,0,14,0,9,-1,0,2},{25,0,0,14,0,9,-1,0,2},{25,0,0,14,0,9,-1,0,2},{25,0,0,14,0,9,-1,0,2},{25,0,0,14,0,9,-1,0,2}},
  {{25,0,0,14,0,4,-1,0,2},{25,0,0,14,0,4,-1,0,2},{25,0,0,14,0,4,-1,0,2},{25,0,0,9,0,4,-1,0,2},{25,0,0,5,0,4,-1,0,2},{25,0,0,14,0,4,-1,0,2},{25,0,0,14,0,4,-1,0,2},{25,0,0,14,0,4,-1,0,2},{25,0,0,14,0,4,-1,0,2},{0,0,0,15,10,9,-1,0,1},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0}},
  {{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2}},
  {{0,0,0,25,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2}},
  {{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2}},
  {{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2}},
  {{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2}},
  {{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2}},
  {{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,1}},
  {{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,3,8,-1,1,22},{0,0,0,25,4,8,-1,1,22},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,0,1},{0,0,0,25,10,8,-1,1,1}},
  {{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,9,-1,1,1},{0,0,0,25,10,9,-1,1,2},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,9,-1,1,2}},
  {{0,0,0,25,10,9,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,0,1},{0,0,0,25,10,8,-1,0,1},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2}},
  {{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2}},
  {{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2}},
  {{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,1}},
  {{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2}},
  {{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2}},
  {{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2}},
  {{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,1},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2}},
  {{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,1}},
  {{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,15}},
  {{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,1,0,22,10,8,-1,1,20},{0,2,0,18,10,8,-1,1,8},{0,1,0,22,10,8,-1,1,20},{0,2,0,18,10,8,-1,1,8},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2}},
  {{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2}},
  {{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,1,1,22,10,11,-1,3,20},{0,2,1,18,10,11,-1,3,8},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2}},
  {{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2}},
  {{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2}},
  {{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2}},
  {{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2}},
  {{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2}},
  {{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2}},
  {{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,0,2}},
  {{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2}},
  {{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2}},
  {{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0}},
  {{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0}},
  {{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0}},
  {{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0}},
  {{0,0,0,15,10,9,1,0,1},{0,0,0,15,10,9,2,0,1},{0,0,0,15,10,9,3,0,1},{0,0,0,15,10,9,4,0,1},{0,0,0,15,10,9,5,0,1},{0,0,0,15,10,9,6,0,1},{0,0,0,15,10,9,7,0,1},{0,0,0,15,10,9,8,0,1},{0,0,0,15,10,9,9,0,1},{0,0,0,15,10,9,-1,0,1},{0,0,0,15,10,9,-1,0,1},{0,0,0,15,10,9,-1,0,1},{0,0,0,15,10,9,-1,0,1},{0,0,0,15,10,9,-1,0,1},{0,0,0,15,10,9,-1,0,1},{0,0,0,15,10,9,-1,0,1}},
  {{0,0,0,15,10,9,-1,0,1},{0,0,0,15,10,9,-1,0,1},{0,0,0,15,10,9,-1,0,1},{0,0,0,15,10,9,-1,0,1},{0,0,0,15,10,9,1,0,1},{0,0,0,15,10,9,2,0,1},{0,0,0,15,10,9,3,0,1},{0,0,0,15,10,9,4,0,1},{0,0,0,15,10,9,5,0,1},{0,0,0,15,10,9,6,0,1},{0,0,0,15,10,9,7,0,1},{0,0,0,15,10,9,8,0,1},{0,0,0,15,10,9,9,0,1},{0,0,0,15,10,9,-1,0,1},{0,0,0,15,10,9,-1,0,1},{0,0,0,15,10,9,-1,0,1}},
  {{0,0,0,15,10,9,-1,0,1},{0,0,0,15,10,9,-1,0,1},{0,0,0,15,10,9,-1,0,1},{0,0,0,15,10,9,-1,0,1},{0,0,0,15,10,9,-1,0,1},{0,0,0,15,10,9,-1,0,1},{0,0,0,15,10,9,-1,0,1},{0,0,0,15,10,9,-1,0,1},{0,0,0,15,2,9,1,0,1},{0,0,0,15,2,9,2,0,1},{0,0,0,15,2,9,3,0,1},{0,0,0,15,2,9,4,0,1},{0,0,0,15,2,9,5,0,1},{0,0,0,15,2,9,6,0,1},{0,0,0,15,2,9,7,0,1},{0,0,0,15,2,9,8,0,1}},
  {{0,0,0,15,2,9,9,0,1},{0,0,0,15,2,9,-1,0,1},{0,0,0,15,2,9,-1,0,1},{0,0,0,15,2,9,-1,0,1},{0,0,0,15,2,9,-1,0,1},{0,0,0,15,2,9,-1,0,1},{0,0,0,15,2,9,-1,0,1},{0,0,0,15,2,9,-1,0,1},{0,0,0,15,2,9,-1,0,1},{0,0,0,15,2,9,-1,0,1},{0,0,0,15,2,9,-1,0,1},{0,0,0,15,2,9,-1,0,1},{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,1}},
  {{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,1}},
  {{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,1},{0,0,0,15,10,9,0,0,1},{0,0,0,15,10,8,-1,0,1},{0,0,0,15,10,8,-1,0,1},{0,0,0,15,10,8,-1,0,1},{0,0,0,15,10,8,-1,0,1},{0,0,0,15,10,8,-1,0,1}},
  {{0,0,0,15,10,8,-1,0,1},{0,0,0,15,10,8,-1,0,1},{0,0,0,15,10,8,-1,0,1},{0,0,0,15,10,8,-1,0,1},{0,0,0,15,10,8,-1,0,1},{0,0,0,15,10,8,1,0,1},{0,0,0,15,10,8,2,0,1},{0,0,0,15,10,8,3,0,1},{0,0,0,15,10,8,4,0,1},{0,0,0,15,10,8,5,0,1},{0,0,0,15,10,8,6,0,1},{0,0,0,15,10,8,7,0,1},{0,0,0,15,10,8,8,0,1},{0,0,0,15,10,8,9,0,1},{0,0,0,15,10,8,-1,0,1},{0,0,0,15,10,8,0,0,2}},
  {{0,0,0,26,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,1}},
  {{0,0,0,26,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2}},
  {{0,0,0,26,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2}},
  {{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,1},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2}},
  {{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2}},
  {{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,1},{0,0,0,25,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2}},
  {{0,0,0,26,10,8,-1,0,1},{0,0,0,25,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1}},
  {{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2}},
  {{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,1}},
  {{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,25,10,8,-1,0,2},{0,0,0,25,10,8,-1,0,2},{0,0,0,25,10,8,-1,0,2},{0,0,0,25,10,8,-1,0,2},{0,0,0,25,10,8,-1,0,2},{0,0,0,25,10,8,-1,0,2},{0,0,0,25,10,8,-1,0,2},{0,0,0,25,10,8,-1,0,2}},
  {{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1}},
  {{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,1,14},{0,0,0,26,10,8,-1,1,14},{0,0,0,26,10,8,-1,1,14},{0,0,0,26,10,8,-1,1,14},{0,0,0,26,10,8,-1,1,14},{0,0,0,26,10,8,-1,1,14}},
  {{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2}},
  {{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2}},
  {{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,2},{0,0,0,25,10,8,-1,0,1}},
  {{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,14}},
  {{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1}},
  {{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2}},
  {{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14}},
  {{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,14}},
  {{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,14}},
  {{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1}},
  {{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14}},
  {{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2}},
  {{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,23},{0,0,0,26,10,8,-1,0,23},{0,0,0,26,10,8,-1,0,23},{0,0,0,26,10,8,-1,0,23},{0,0,0,26,10,8,-1,0,23}},
  {{0,0,0,26,10,8,-1,0,23},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,11},{0,0,0,26,10,8,-1,0,11},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,1,0,22,10,8,-1,1,20},{0,2,0,18,10,8,-1,1,8},{0,1,0,22,10,8,-1,1,20},{0,2,0,18,10,8,-1,1,8},{0,1,0,22,10,8,-1,1,20},{0,2,0,18,10,8,-1,1,8},{0,1,0,22,10,8,-1,1,20},{0,2,0,18,10,8,-1,1,8}},
  {{0,1,0,22,10,8,-1,1,20},{0,2,0,18,10,8,-1,1,8},{0,1,0,22,10,8,-1,1,20},{0,2,0,18,10,8,-1,1,8},{0,1,0,22,10,8,-1,1,20},{0,2,0,18,10,8,-1,1,8},{0,0,0,15,10,8,1,0,1},{0,0,0,15,10,8,2,0,1},{0,0,0,15,10,8,3,0,1},{0,0,0,15,10,8,4,0,1},{0,0,0,15,10,8,5,0,1},{0,0,0,15,10,8,6,0,1},{0,0,0,15,10,8,7,0,1},{0,0,0,15,10,8,8,0,1},{0,0,0,15,10,8,9,0,1},{0,0,0,15,10,8,-1,0,1}},
  {{0,0,0,15,10,8,1,0,1},{0,0,0,15,10,8,2,0,1},{0,0,0,15,10,8,3,0,1},{0,0,0,15,10,8,4,0,1},{0,0,0,15,10,8,5,0,1},{0,0,0,15,10,8,6,0,1},{0,0,0,15,10,8,7,0,1},{0,0,0,15,10,8,8,0,1},{0,0,0,15,10,8,9,0,1},{0,0,0,15,10,8,-1,0,1},{0,0,0,15,10,8,1,0,1},{0,0,0,15,10,8,2,0,1},{0,0,0,15,10,8,3,0,1},{0,0,0,15,10,8,4,0,1},{0,0,0,15,10,8,5,0,1},{0,0,0,15,10,8,6,0,1}},
  {{0,0,0,15,10,8,7,0,1},{0,0,0,15,10,8,8,0,1},{0,0,0,15,10,8,9,0,1},{0,0,0,15,10,8,-1,0,1},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2}},
  {{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,1,0,22,10,8,-1,1,20},{0,2,0,18,10,8,-1,1,8},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2}},
  {{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,1,0,22,10,8,-1,1,20},{0,2,0,18,10,8,-1,1,8},{0,1,0,22,10,8,-1,1,20},{0,2,0,18,10,8,-1,1,8},{0,1,0,22,10,8,-1,1,20},{0,2,0,18,10,8,-1,1,8},{0,1,0,22,10,8,-1,1,20},{0,2,0,18,10,8,-1,1,8},{0,1,0,22,10,8,-1,1,20},{0,2,0,18,10,8,-1,1,8}},
  {{46,0,0,26,0,8,-1,1,2},{46,0,0,26,0,8,-1,1,2},{46,0,0,26,0,8,-1,1,2},{46,0,0,26,0,8,-1,1,2},{46,0,0,26,0,8,-1,1,2},{46,0,0,26,0,8,-1,1,2},{46,0,0,26,0,8,-1,1,2},{46,0,0,26,0,8,-1,1,2},{46,0,0,26,0,8,-1,1,2},{46,0,0,26,0,8,-1,1,2},{46,0,0,26,0,8,-1,1,2},{46,0,0,26,0,8,-1,1,2},{46,0,0,26,0,8,-1,1,2},{46,0,0,26,0,8,-1,1,2},{46,0,0,26,0,8,-1,1,2},{46,0,0,26,0,8,-1,1,2}},
  {{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,1,0,22,10,8,-1,1,20},{0,2,0,18,10,8,-1,1,8},{0,1,0,22,10,8,-1,1,20},{0,2,0,18,10,8,-1,1,8},{0,1,0,22,10,8,-1,1,20},{0,2,0,18,10,8,-1,1,8},{0,1,0,22,10,8,-1,1,20},{0,2,0,18,10,8,-1,1,8},{0,1,0,22,10,8,-1,1,20},{0,2,0,18,10,8,-1,1,8},{0,1,0,22,10,8,-1,1,20},{0,2,0,18,10,8,-1,1,8},{0,1,0,22,10,8,-1,1,20}},
  {{0,2,0,18,10,8,-1,1,8},{0,1,0,22,10,8,-1,1,20},{0,2,0,18,10,8,-1,1,8},{0,1,0,22,10,8,-1,1,20},{0,2,0,18,10,8,-1,1,8},{0,1,0,22,10,8,-1,1,20},{0,2,0,18,10,8,-1,1,8},{0,1,0,22,10,8,-1,1,20},{0,2,0,18,10,8,-1,1,8},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2}},
  {{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,1,0,22,10,8,-1,1,20},{0,2,0,18,10,8,-1,1,8},{0,1,0,22,10,8,-1,1,20},{0,2,0,18,10,8,-1,1,8},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2}},
  {{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,1,0,22,10,8,-1,1,20},{0,2,0,18,10,8,-1,1,8},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2}},
  {{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,9,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2}},
  {{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,9,-1,1,2},{0,0,0,25,10,9,-1,1,2},{0,0,0,25,10,9,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2}},
  {{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2}},
  {{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,25,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2}},
  {{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,0,1},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2}},
  {{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2}},
  {{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2}},
  {{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2}},
  {{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{103,0,0,2,0,12,-1,0,0},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2}},
  {{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0}},
  {{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2}},
  {{56,0,0,9,0,7,-1,1,2},{56,0,0,9,0,7,-1,1,2},{56,0,0,9,0,7,-1,1,2},{56,0,0,9,0,7,-1,1,2},{56,0,0,9,0,7,-1,1,2},{56,0,0,9,0,7,-1,1,2},{56,0,0,9,0,7,-1,1,2},{56,0,0,9,0,7,-1,1,2},{56,0,0,9,0,7,-1,1,2},{56,0,0,9,0,7,-1,1,2},{56,0,0,9,0,7,-1,1,2},{56,0,0,9,0,7,-1,1,2},{56,0,0,9,0,7,-1,1,2},{56,0,0,9,0,7,-1,1,2},{56,0,0,9,0,7,-1,1,2},{56,0,0,9,0,7,-1,1,2}},
  {{56,0,0,9,0,7,-1,1,2},{56,0,0,9,0,7,-1,1,2},{56,0,0,9,0,7,-1,1,2},{56,0,0,9,0,7,-1,1,2},{56,0,0,9,0,7,-1,1,2},{56,0,0,9,0,7,-1,1,2},{56,0,0,9,0,7,-1,1,2},{56,0,0,9,0,7,-1,1,2},{56,0,0,9,0,7,-1,1,2},{56,0,0,9,0,7,-1,1,2},{56,0,0,9,0,7,-1,1,2},{56,0,0,9,0,7,-1,1,2},{56,0,0,9,0,7,-1,1,2},{56,0,0,9,0,7,-1,1,2},{56,0,0,9,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0}},
  {{56,0,0,5,0,7,-1,1,2},{56,0,0,5,0,7,-1,1,2},{56,0,0,5,0,7,-1,1,2},{56,0,0,5,0,7,-1,1,2},{56,0,0,5,0,7,-1,1,2},{56,0,0,5,0,7,-1,1,2},{56,0,0,5,0,7,-1,1,2},{56,0,0,5,0,7,-1,1,2},{56,0,0,5,0,7,-1,1,2},{56,0,0,5,0,7,-1,1,2},{56,0,0,5,0,7,-1,1,2},{56,0,0,5,0,7,-1,1,2},{56,0,0,5,0,7,-1,1,2},{56,0,0,5,0,7,-1,1,2},{56,0,0,5,0,7,-1,1,2},{56,0,0,5,0,7,-1,1,2}},
  {{56,0,0,5,0,7,-1,1,2},{56,0,0,5,0,7,-1,1,2},{56,0,0,5,0,7,-1,1,2},{56,0,0,5,0,7,-1,1,2},{56,0,0,5,0,7,-1,1,2},{56,0,0,5,0,7,-1,1,2},{56,0,0,5,0,7,-1,1,2},{56,0,0,5,0,7,-1,1,2},{56,0,0,5,0,7,-1,1,2},{56,0,0,5,0,7,-1,1,2},{56,0,0,5,0,7,-1,1,2},{56,0,0,5,0,7,-1,1,2},{56,0,0,5,0,7,-1,1,2},{56,0,0,5,0,7,-1,1,2},{56,0,0,5,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0}},
  {{25,0,0,9,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,9,0,3,-1,1,2},{25,0,0,9,0,3,-1,1,2},{25,0,0,9,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2}},
  {{25,0,0,9,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,5,0,3,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2}},
  {{7,0,0,9,0,7,-1,1,2},{7,0,0,5,0,7,-1,1,2},{7,0,0,9,0,7,-1,1,2},{7,0,0,5,0,7,-1,1,2},{7,0,0,9,0,7,-1,1,2},{7,0,0,5,0,7,-1,1,2},{7,0,0,9,0,7,-1,1,2},{7,0,0,5,0,7,-1,1,2},{7,0,0,9,0,7,-1,1,2},{7,0,0,5,0,7,-1,1,2},{7,0,0,9,0,7,-1,1,2},{7,0,0,5,0,7,-1,1,2},{7,0,0,9,0,7,-1,1,2},{7,0,0,5,0,7,-1,1,2},{7,0,0,9,0,7,-1,1,2},{7,0,0,5,0,7,-1,1,2}},
  {{7,0,0,9,0,7,-1,1,2},{7,0,0,5,0,7,-1,1,2},{7,0,0,9,0,7,-1,1,2},{7,0,0,5,0,7,-1,1,2},{7,0,0,5,0,7,-1,1,2},{7,0,0,26,10,8,-1,1,2},{7,0,0,26,10,8,-1,1,2},{7,0,0,26,10,8,-1,1,2},{7,0,0,26,10,8,-1,1,2},{7,0,0,26,10,8,-1,1,2},{7,0,0,26,10,8,-1,1,2},{7,0,0,9,0,7,-1,1,2},{7,0,0,5,0,7,-1,1,2},{7,0,0,9,0,7,-1,1,2},{7,0,0,5,0,7,-1,1,2},{7,0,0,12,17,7,-1,1,9}},
  {{7,0,0,12,17,7,-1,1,9},{7,0,0,12,17,7,-1,1,9},{7,0,0,9,0,7,-1,1,2},{7,0,0,5,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{7,0,0,21,10,8,-1,1,11},{7,0,0,21,10,8,-1,1,4},{7,0,0,21,10,8,-1,1,4},{7,0,0,21,10,8,-1,1,4},{7,0,0,15,10,8,-1,1,2},{7,0,0,21,10,8,-1,1,11},{7,0,0,21,10,8,-1,1,4}},
  {{12,0,0,5,0,4,-1,1,2},{12,0,0,5,0,4,-1,1,2},{12,0,0,5,0,4,-1,1,2},{12,0,0,5,0,4,-1,1,2},{12,0,0,5,0,4,-1,1,2},{12,0,0,5,0,4,-1,1,2},{12,0,0,5,0,4,-1,1,2},{12,0,0,5,0,4,-1,1,2},{12,0,0,5,0,4,-1,1,2},{12,0,0,5,0,4,-1,1,2},{12,0,0,5,0,4,-1,1,2},{12,0,0,5,0,4,-1,1,2},{12,0,0,5,0,4,-1,1,2},{12,0,0,5,0,4,-1,1,2},{12,0,0,5,0,4,-1,1,2},{12,0,0,5,0,4,-1,1,2}},
  {{12,0,0,5,0,4,-1,1,2},{12,0,0,5,0,4,-1,1,2},{12,0,0,5,0,4,-1,1,2},{12,0,0,5,0,4,-1,1,2},{12,0,0,5,0,4,-1,1,2},{12,0,0,5,0,4,-1,1,2},{103,0,0,2,0,12,-1,1,0},{12,0,0,5,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{12,0,0,5,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{60,0,0,7,0,5,-1,1,2},{60,0,0,7,0,5,-1,1,2},{60,0,0,7,0,5,-1,1,2},{60,0,0,7,0,5,-1,1,2},{60,0,0,7,0,5,-1,1,2},{60,0,0,7,0,5,-1,1,2},{60,0,0,7,0,5,-1,1,2},{60,0,0,7,0,5,-1,1,2},{60,0,0,7,0,5,-1,1,2},{60,0,0,7,0,5,-1,1,2},{60,0,0,7,0,5,-1,1,2},{60,0,0,7,0,5,-1,1,2},{60,0,0,7,0,5,-1,1,2},{60,0,0,7,0,5,-1,1,2},{60,0,0,7,0,5,-1,1,2},{60,0,0,7,0,5,-1,1,2}},
  {{60,0,0,7,0,5,-1,1,2},{60,0,0,7,0,5,-1,1,2},{60,0,0,7,0,5,-1,1,2},{60,0,0,7,0,5,-1,1,2},{60,0,0,7,0,5,-1,1,2},{60,0,0,7,0,5,-1,1,2},{60,0,0,7,0,5,-1,1,2},{60,0,0,7,0,5,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{60,0,0,6,0,9,-1,1,2}},
  {{60,0,0,21,0,8,-1,1,4},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{60,0,0,12,17,5,-1,1,9}},
  {{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0}},
  {{8,0,0,12,17,4,-1,1,9},{8,0,0,12,17,4,-1,1,9},{8,0,0,12,17,4,-1,1,9},{8,0,0,12,17,4,-1,1,9},{8,0,0,12,17,4,-1,1,9},{8,0,0,12,17,4,-1,1,9},{8,0,0,12,17,4,-1,1,9},{8,0,0,12,17,4,-1,1,9},{8,0,0,12,17,4,-1,1,9},{8,0,0,12,17,4,-1,1,9},{8,0,0,12,17,4,-1,1,9},{8,0,0,12,17,4,-1,1,9},{8,0,0,12,17,4,-1,1,9},{8,0,0,12,17,4,-1,1,9},{8,0,0,12,17,4,-1,1,9},{8,0,0,12,17,4,-1,1,9}},
  {{0,0,0,21,10,8,-1,1,23},{0,0,0,21,10,8,-1,1,23},{0,0,0,20,10,8,-1,1,23},{0,0,0,19,10,8,-1,1,23},{0,0,0,20,10,8,-1,1,23},{0,0,0,19,10,8,-1,1,23},{0,0,0,21,10,8,-1,1,23},{0,0,0,21,10,8,-1,1,23},{0,0,0,21,10,8,-1,1,23},{0,0,0,20,10,8,-1,1,23},{0,0,0,19,10,8,-1,1,23},{0,0,0,21,10,8,-1,1,23},{0,0,0,20,10,8,-1,1,23},{0,0,0,19,10,8,-1,1,23},{0,0,0,21,10,8,-1,1,4},{0,0,0,21,10,8,-1,1,4}},
  {{0,0,0,21,10,8,-1,1,4},{0,0,0,21,10,8,-1,1,4},{0,0,0,21,10,8,-1,1,4},{0,0,0,21,10,8,-1,1,4},{0,0,0,21,10,8,-1,1,4},{0,0,0,21,10,8,-1,1,4},{0,0,0,21,10,8,-1,1,2},{0,0,0,17,10,8,-1,1,4},{0,0,0,21,10,8,-1,1,20},{0,0,0,21,10,8,-1,1,4},{0,0,0,17,10,8,-1,1,2},{0,0,0,21,10,8,-1,1,2},{0,0,0,20,10,8,-1,1,23},{0,0,0,19,10,8,-1,1,23},{0,0,0,21,10,8,-1,1,2},{0,0,0,21,10,8,-1,1,2}},
  {{0,0,0,20,10,8,-1,1,23},{0,0,0,19,10,8,-1,1,23},{0,1,0,22,10,8,-1,1,20},{0,2,0,18,10,8,-1,1,8},{0,1,0,22,10,8,-1,1,20},{0,2,0,18,10,8,-1,1,8},{0,1,0,22,10,8,-1,1,20},{0,2,0,18,10,8,-1,1,8},{0,1,0,22,10,8,-1,1,20},{0,2,0,18,10,8,-1,1,8},{0,0,0,21,10,8,-1,1,4},{0,0,0,21,10,8,-1,1,4},{0,0,0,21,10,8,-1,1,4},{0,0,0,21,10,8,-1,1,4},{0,0,0,21,10,8,-1,1,11},{0,0,0,6,10,8,-1,1,2}},
  {{0,0,0,21,10,8,-1,1,4},{0,0,0,21,10,8,-1,1,4},{0,0,0,21,10,8,-1,1,2},{0,0,0,21,10,8,-1,1,4},{0,0,0,21,10,8,-1,1,4},{0,0,0,21,10,8,-1,1,2},{0,0,0,21,10,8,-1,1,2},{0,0,0,21,10,8,-1,1,2},{0,0,0,21,10,8,-1,1,2},{0,0,0,21,10,8,-1,1,2},{0,0,0,17,10,8,-1,1,3},{0,0,0,17,10,8,-1,1,3},{0,0,0,21,10,8,-1,1,4},{0,0,0,21,10,8,-1,1,4},{0,0,0,21,10,8,-1,1,4},{0,0,0,21,10,8,-1,1,2}},
  {{0,0,0,17,10,8,-1,1,4},{0,0,0,21,10,8,-1,1,4},{0,0,0,22,10,8,-1,1,20},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{17,0,1,26,10,8,-1,0,14},{17,0,1,26,10,8,-1,0,14},{17,0,1,26,10,8,-1,0,14},{17,0,1,26,10,8,-1,0,14},{17,0,1,26,10,8,-1,0,14},{17,0,1,26,10,8,-1,0,14},{17,0,1,26,10,8,-1,0,14},{17,0,1,26,10,8,-1,0,14},{17,0,1,26,10,8,-1,0,14},{17,0,1,26,10,8,-1,0,14},{17,0,1,26,10,8,-1,0,14},{17,0,1,26,10,8,-1,0,14},{17,0,1,26,10,8,-1,0,14},{17,0,1,26,10,8,-1,0,14},{17,0,1,26,10,8,-1,0,14},{17,0,1,26,10,8,-1,0,14}},
  {{17,0,1,26,10,8,-1,0,14},{17,0,1,26,10,8,-1,0,14},{17,0,1,26,10,8,-1,0,14},{17,0,1,26,10,8,-1,0,14},{17,0,1,26,10,8,-1,0,14},{17,0,1,26,10,8,-1,0,14},{17,0,1,26,10,8,-1,0,14},{17,0,1,26,10,8,-1,0,14},{17,0,1,26,10,8,-1,0,14},{17,0,1,26,10,8,-1,0,14},{103,0,0,2,0,12,-1,0,0},{17,0,1,26,10,8,-1,0,14},{17,0,1,26,10,8,-1,0,14},{17,0,1,26,10,8,-1,0,14},{17,0,1,26,10,8,-1,0,14},{17,0,1,26,10,9,-1,0,14}},
  {{17,0,1,26,10,8,-1,0,14},{17,0,1,26,10,8,-1,0,14},{17,0,1,26,10,8,-1,0,14},{17,0,1,26,10,9,-1,0,14},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0}},
  {{17,0,1,26,10,9,-1,0,14},{17,0,1,26,10,9,-1,0,14},{17,0,1,26,10,9,-1,0,14},{17,0,1,26,10,9,-1,0,14},{17,0,1,26,10,9,-1,0,14},{17,0,1,26,10,9,-1,0,14},{17,0,1,26,10,9,-1,0,14},{17,0,1,26,10,9,-1,0,14},{17,0,1,26,10,9,-1,0,14},{17,0,1,26,10,9,-1,0,14},{17,0,1,26,10,9,-1,0,14},{17,0,1,26,10,9,-1,0,14},{17,0,1,26,10,9,-1,0,14},{17,0,1,26,10,9,-1,0,14},{17,0,1,26,10,9,-1,0,14},{17,0,1,26,10,9,-1,0,14}},
  {{17,0,1,26,10,9,-1,0,14},{17,0,1,26,10,9,-1,0,14},{17,0,1,26,10,9,-1,0,14},{17,0,1,26,10,9,-1,0,14},{17,0,1,26,10,9,-1,0,14},{17,0,1,26,10,9,-1,0,14},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0}},
  {{0,0,1,26,10,8,-1,0,14},{0,0,1,26,10,8,-1,0,14},{0,0,1,26,10,8,-1,0,14},{0,0,1,26,10,8,-1,0,14},{0,0,1,26,10,8,-1,0,14},{0,0,1,26,10,8,-1,0,14},{0,0,1,26,10,8,-1,0,14},{0,0,1,26,10,8,-1,0,14},{0,0,1,26,10,8,-1,0,14},{0,0,1,26,10,8,-1,0,14},{0,0,1,26,10,8,-1,0,14},{0,0,1,26,10,8,-1,0,14},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0}},
  {{0,0,1,29,9,9,-1,0,4},{0,0,1,21,10,8,-1,2,8},{0,0,1,21,10,8,-1,2,8},{0,0,1,21,10,8,-1,0,14},{0,0,1,26,10,8,-1,0,14},{17,0,1,6,0,0,-1,0,18},{0,0,1,7,0,0,-1,0,14},{17,0,1,14,0,0,-1,0,14},{0,1,1,22,10,8,-1,3,20},{0,2,1,18,10,8,-1,3,8},{0,1,1,22,10,8,-1,3,20},{0,2,1,18,10,8,-1,3,8},{0,1,1,22,10,8,-1,3,20},{0,2,1,18,10,8,-1,3,8},{0,1,1,22,10,8,-1,3,20},{0,2,1,18,10,8,-1,3,8}},
  {{0,1,1,22,10,8,-1,3,20},{0,2,1,18,10,8,-1,3,8},{0,0,1,26,10,8,-1,0,14},{0,0,1,26,10,8,-1,0,14},{0,1,1,22,10,8,-1,3,20},{0,2,1,18,10,8,-1,3,8},{0,1,1,22,10,8,-1,3,20},{0,2,1,18,10,8,-1,3,8},{0,1,1,22,10,8,-1,3,20},{0,2,1,18,10,8,-1,3,8},{0,1,1,22,10,8,-1,3,20},{0,2,1,18,10,8,-1,3,8},{0,0,1,17,10,8,-1,3,18},{0,0,1,22,10,8,-1,3,20},{0,0,1,18,10,8,-1,3,8},{0,0,1,18,10,8,-1,3,8}},
  {{0,0,1,26,10,8,-1,0,14},{17,0,1,14,0,3,-1,0,14},{17,0,1,14,0,3,-1,0,14},{17,0,1,14,0,3,-1,0,14},{17,0,1,14,0,3,-1,0,14},{17,0,1,14,0,3,-1,0,14},{17,0,1,14,0,3,-1,0,14},{17,0,1,14,0,3,-1,0,14},{17,0,1,14,0,3,-1,0,14},{17,0,1,14,0,3,-1,0,14},{1,0,1,12,17,3,-1,0,9},{1,0,1,12,17,3,-1,0,9},{1,0,1,12,17,3,-1,0,9},{1,0,1,12,17,3,-1,0,9},{18,0,1,10,0,4,-1,0,9},{18,0,1,10,0,4,-1,0,9}},
  {{0,0,1,17,10,8,-1,3,14},{0,0,1,6,0,3,-1,0,14},{0,0,1,6,0,3,-1,0,14},{0,0,1,6,0,3,-1,0,14},{0,0,1,6,0,3,-1,0,14},{0,0,1,6,0,3,-1,0,9},{0,0,1,26,10,9,-1,0,14},{0,0,1,26,10,8,-1,0,14},{17,0,1,14,0,9,-1,0,14},{17,0,1,14,0,9,-1,0,14},{17,0,1,14,0,9,-1,0,14},{17,0,1,6,0,3,-1,0,18},{0,0,1,7,0,3,-1,0,18},{0,0,1,21,10,8,-1,0,14},{0,0,1,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14}},
  {{103,0,0,2,0,12,-1,0,0},{20,0,1,7,0,0,-1,2,37},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,2,37},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,2,37},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,2,37},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,2,37},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14}},
  {{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14}},
  {{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,2,37},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14}},
  {{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,2,37},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,2,37},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,2,37},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,2,37},{20,0,1,7,0,0,-1,0,14}},
  {{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,0,14},{20,0,1,7,0,0,-1,2,37},{20,0,1,7,0,0,-1,2,37},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{1,0,1,12,17,0,-1,0,9},{1,0,1,12,17,0,-1,0,9},{0,0,1,24,10,9,-1,2,18},{0,0,1,24,10,9,-1,2,18},{20,0,1,6,0,0,-1,0,18},{20,0,1,6,0,0,-1,0,18},{20,0,1,7,0,9,-1,0,14}},
  {{0,0,1,17,10,1,-1,3,18},{22,0,1,7,0,0,-1,2,37},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,2,37},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,2,37},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,2,37},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,2,37},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14}},
  {{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14}},
  {{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,2,37},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14}},
  {{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,2,37},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,2,37},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,2,37},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,2,37},{22,0,1,7,0,0,-1,0,14}},
  {{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,2,37},{22,0,1,7,0,0,-1,2,37},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{22,0,1,7,0,0,-1,0,14},{0,0,1,21,10,1,-1,0,18},{0,0,1,6,0,0,-1,3,37},{22,0,1,6,0,0,-1,0,18},{22,0,1,6,0,0,-1,0,18},{22,0,1,7,0,9,-1,0,14}},
  {{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14}},
  {{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14}},
  {{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,2,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0}},
  {{103,0,0,2,0,12,-1,0,0},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14}},
  {{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14}},
  {{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,10,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14}},
  {{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{18,0,1,7,0,9,-1,0,14},{103,0,0,2,0,12,-1,0,0}},
  {{0,0,1,26,0,8,-1,0,14},{0,0,1,26,0,8,-1,0,14},{0,0,1,15,0,9,-1,0,14},{0,0,1,15,0,9,-1,0,14},{0,0,1,15,0,9,-1,0,14},{0,0,1,15,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14}},
  {{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{5,0,1,7,0,0,-1,0,14},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0}},
  {{0,0,1,26,10,8,-1,0,14},{0,0,1,26,10,8,-1,0,14},{0,0,1,26,10,8,-1,0,14},{0,0,1,26,10,8,-1,0,14},{0,0,1,26,10,8,-1,0,14},{0,0,1,26,10,8,-1,0,14},{0,0,1,26,10,8,-1,0,14},{0,0,1,26,10,8,-1,0,14},{0,0,1,26,10,8,-1,0,14},{0,0,1,26,10,8,-1,0,14},{0,0,1,26,10,8,-1,0,14},{0,0,1,26,10,8,-1,0,14},{0,0,1,26,10,8,-1,0,14},{0,0,1,26,10,8,-1,0,14},{0,0,1,26,10,8,-1,0,14},{0,0,1,26,10,8,-1,0,14}},
  {{0,0,1,26,10,8,-1,0,14},{0,0,1,26,10,8,-1,0,14},{0,0,1,26,10,8,-1,0,14},{0,0,1,26,10,8,-1,0,14},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0}},
  {{22,0,1,7,0,3,-1,2,37},{22,0,1,7,0,3,-1,2,37},{22,0,1,7,0,3,-1,2,37},{22,0,1,7,0,3,-1,2,37},{22,0,1,7,0,3,-1,2,37},{22,0,1,7,0,3,-1,2,37},{22,0,1,7,0,3,-1,2,37},{22,0,1,7,0,3,-1,2,37},{22,0,1,7,0,3,-1,2,37},{22,0,1,7,0,3,-1,2,37},{22,0,1,7,0,3,-1,2,37},{22,0,1,7,0,3,-1,2,37},{22,0,1,7,0,3,-1,2,37},{22,0,1,7,0,3,-1,2,37},{22,0,1,7,0,3,-1,2,37},{22,0,1,7,0,3,-1,2,37}},
  {{18,0,1,26,0,9,-1,0,14},{18,0,1,26,0,9,-1,0,14},{18,0,1,26,0,9,-1,0,14},{18,0,1,26,0,9,-1,0,14},{18,0,1,26,0,9,-1,0,14},{18,0,1,26,0,9,-1,0,14},{18,0,1,26,0,9,-1,0,14},{18,0,1,26,0,9,-1,0,14},{18,0,1,26,0,9,-1,0,14},{18,0,1,26,0,9,-1,0,14},{18,0,1,26,0,9,-1,0,14},{18,0,1,26,0,9,-1,0,14},{18,0,1,26,0,9,-1,0,14},{18,0,1,26,0,9,-1,0,14},{18,0,1,26,0,9,-1,0,14},{18,0,1,26,0,9,-1,0,14}},
  {{18,0,1,26,0,9,-1,0,14},{18,0,1,26,0,9,-1,0,14},{18,0,1,26,0,9,-1,0,14},{18,0,1,26,0,9,-1,0,14},{18,0,1,26,0,9,-1,0,14},{18,0,1,26,0,9,-1,0,14},{18,0,1,26,0,9,-1,0,14},{18,0,1,26,0,9,-1,0,14},{18,0,1,26,0,9,-1,0,14},{18,0,1,26,0,9,-1,0,14},{18,0,1,26,0,9,-1,0,14},{18,0,1,26,0,9,-1,0,14},{18,0,1,26,0,9,-1,0,14},{18,0,1,26,10,9,-1,0,14},{18,0,1,26,10,9,-1,0,14},{103,0,0,2,0,12,-1,0,0}},
  {{0,0,1,15,0,9,-1,0,14},{0,0,1,15,0,9,-1,0,14},{0,0,1,15,0,9,-1,0,14},{0,0,1,15,0,9,-1,0,14},{0,0,1,15,0,9,-1,0,14},{0,0,1,15,0,9,-1,0,14},{0,0,1,15,0,9,-1,0,14},{0,0,1,15,0,9,-1,0,14},{0,0,1,15,0,9,-1,0,14},{0,0,1,15,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14}},
  {{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14}},
  {{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,0,15,0,8,-1,0,1},{0,0,0,15,0,8,-1,0,1},{0,0,0,15,0,8,-1,0,1},{0,0,0,15,0,8,-1,0,1},{0,0,0,15,0,8,-1,0,1},{0,0,0,15,0,8,-1,0,1},{0,0,0,15,0,8,-1,0,1},{0,0,0,15,0,8,-1,0,1}},
  {{0,0,1,26,10,9,-1,0,14},{0,0,1,15,10,9,-1,0,14},{0,0,1,15,10,9,-1,0,14},{0,0,1,15,10,9,-1,0,14},{0,0,1,15,10,9,-1,0,14},{0,0,1,15,10,9,-1,0,14},{0,0,1,15,10,9,-1,0,14},{0,0,1,15,10,9,-1,0,14},{0,0,1,15,10,9,-1,0,14},{0,0,1,15,10,9,-1,0,14},{0,0,1,15,10,9,-1,0,14},{0,0,1,15,10,9,-1,0,14},{0,0,1,15,10,9,-1,0,14},{0,0,1,15,10,9,-1,0,14},{0,0,1,15,10,9,-1,0,14},{0,0,1,15,10,9,-1,0,14}},
  {{18,0,1,26,0,9,-1,0,14},{18,0,1,26,0,9,-1,0,14},{18,0,1,26,0,9,-1,0,14},{18,0,1,26,0,9,-1,0,14},{18,0,1,26,0,9,-1,0,14},{18,0,1,26,0,9,-1,0,14},{18,0,1,26,0,9,-1,0,14},{18,0,1,26,0,9,-1,0,14},{18,0,1,26,0,9,-1,0,14},{18,0,1,26,0,9,-1,0,14},{18,0,1,26,0,9,-1,0,14},{18,0,1,26,0,9,-1,0,14},{18,0,1,26,10,9,-1,0,14},{18,0,1,26,10,9,-1,0,14},{18,0,1,26,10,9,-1,0,14},{0,0,1,26,0,8,-1,0,14}},
  {{0,0,1,26,0,9,-1,0,14},{0,0,1,15,10,9,-1,0,14},{0,0,1,15,10,9,-1,0,14},{0,0,1,15,10,9,-1,0,14},{0,0,1,15,10,9,-1,0,14},{0,0,1,15,10,9,-1,0,14},{0,0,1,15,10,9,-1,0,14},{0,0,1,15,10,9,-1,0,14},{0,0,1,15,10,9,-1,0,14},{0,0,1,15,10,9,-1,0,14},{0,0,1,15,10,9,-1,0,14},{0,0,1,15,10,9,-1,0,14},{0,0,1,15,10,9,-1,0,14},{0,0,1,15,10,9,-1,0,14},{0,0,1,15,10,9,-1,0,14},{0,0,1,15,10,9,-1,0,14}},
  {{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,10,9,-1,0,14},{0,0,1,26,10,9,-1,0,14},{0,0,1,26,10,9,-1,0,14},{0,0,1,26,10,9,-1,0,14}},
  {{22,0,1,26,0,9,-1,0,14},{22,0,1,26,0,9,-1,0,14},{22,0,1,26,0,9,-1,0,14},{22,0,1,26,0,9,-1,0,14},{22,0,1,26,0,9,-1,0,14},{22,0,1,26,0,9,-1,0,14},{22,0,1,26,0,9,-1,0,14},{22,0,1,26,0,9,-1,0,14},{22,0,1,26,0,9,-1,0,14},{22,0,1,26,0,9,-1,0,14},{22,0,1,26,0,9,-1,0,14},{22,0,1,26,0,9,-1,0,14},{22,0,1,26,0,9,-1,0,14},{22,0,1,26,0,9,-1,0,14},{22,0,1,26,0,9,-1,0,14},{22,0,1,26,0,9,-1,0,14}},
  {{22,0,1,26,0,9,-1,0,14},{22,0,1,26,0,9,-1,0,14},{22,0,1,26,0,9,-1,0,14},{22,0,1,26,0,9,-1,0,14},{22,0,1,26,0,9,-1,0,14},{22,0,1,26,0,9,-1,0,14},{22,0,1,26,0,9,-1,0,14},{22,0,1,26,0,9,-1,0,14},{22,0,1,26,0,9,-1,0,14},{22,0,1,26,0,9,-1,0,14},{22,0,1,26,0,9,-1,0,14},{22,0,1,26,0,9,-1,0,14},{22,0,1,26,0,9,-1,0,14},{22,0,1,26,0,9,-1,0,14},{22,0,1,26,0,9,-1,0,14},{103,0,0,2,0,12,-1,0,0}},
  {{22,0,1,26,0,9,-1,2,14},{22,0,1,26,0,9,-1,2,14},{22,0,1,26,0,9,-1,2,14},{22,0,1,26,0,9,-1,2,14},{22,0,1,26,0,9,-1,2,14},{22,0,1,26,0,9,-1,2,14},{22,0,1,26,0,9,-1,2,14},{22,0,1,26,0,9,-1,2,14},{22,0,1,26,0,9,-1,2,14},{22,0,1,26,0,9,-1,2,14},{22,0,1,26,0,9,-1,2,14},{22,0,1,26,0,9,-1,2,14},{22,0,1,26,0,9,-1,2,14},{22,0,1,26,0,9,-1,2,14},{22,0,1,26,0,9,-1,2,14},{22,0,1,26,0,9,-1,2,14}},
  {{22,0,1,26,0,9,-1,2,14},{22,0,1,26,0,9,-1,2,14},{22,0,1,26,0,9,-1,2,14},{22,0,1,26,0,9,-1,2,14},{22,0,1,26,0,9,-1,2,14},{22,0,1,26,0,9,-1,2,14},{22,0,1,26,0,9,-1,2,14},{22,0,1,26,0,9,-1,2,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14}},
  {{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,10,9,-1,0,14},{0,0,1,26,10,9,-1,0,14},{0,0,1,26,10,9,-1,0,14},{0,0,1,26,10,9,-1,0,14},{0,0,1,26,0,9,-1,2,14},{0,0,1,26,0,9,-1,2,14},{0,0,1,26,0,9,-1,2,14},{0,0,1,26,0,9,-1,2,14},{0,0,1,26,0,9,-1,2,14}},
  {{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,10,9,-1,0,14},{0,0,1,26,10,9,-1,0,14}},
  {{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,10,9,-1,0,14}},
  {{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14}},
  {{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14}},
  {{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14}},
  {{41,0,1,7,0,5,-1,0,14},{41,0,1,7,0,5,-1,0,14},{41,0,1,7,0,5,-1,0,14},{41,0,1,7,0,5,-1,0,14},{41,0,1,7,0,5,-1,0,14},{41,0,1,7,0,5,-1,0,14},{41,0,1,7,0,5,-1,0,14},{41,0,1,7,0,5,-1,0,14},{41,0,1,7,0,5,-1,0,14},{41,0,1,7,0,5,-1,0,14},{41,0,1,7,0,5,-1,0,14},{41,0,1,7,0,5,-1,0,14},{41,0,1,7,0,5,-1,0,14},{41,0,1,7,0,5,-1,0,14},{41,0,1,7,0,5,-1,0,14},{41,0,1,7,0,5,-1,0,14}},
  {{41,0,1,7,0,5,-1,0,14},{41,0,1,7,0,5,-1,0,14},{41,0,1,7,0,5,-1,0,14},{41,0,1,7,0,5,-1,0,14},{41,0,1,7,0,5,-1,0,14},{41,0,1,6,0,5,-1,0,18},{41,0,1,7,0,5,-1,0,14},{41,0,1,7,0,5,-1,0,14},{41,0,1,7,0,5,-1,0,14},{41,0,1,7,0,5,-1,0,14},{41,0,1,7,0,5,-1,0,14},{41,0,1,7,0,5,-1,0,14},{41,0,1,7,0,5,-1,0,14},{41,0,1,7,0,5,-1,0,14},{41,0,1,7,0,5,-1,0,14},{41,0,1,7,0,5,-1,0,14}},
  {{41,0,1,7,0,5,-1,0,14},{41,0,1,7,0,5,-1,0,14},{41,0,1,7,0,5,-1,0,14},{41,0,1,7,0,5,-1,0,14},{41,0,1,7,0,5,-1,0,14},{41,0,1,7,0,5,-1,0,14},{41,0,1,7,0,5,-1,0,14},{41,0,1,7,0,5,-1,0,14},{41,0,1,7,0,5,-1,0,14},{41,0,1,7,0,5,-1,0,14},{41,0,1,7,0,5,-1,0,14},{41,0,1,7,0,5,-1,0,14},{41,0,1,7,0,5,-1,0,14},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0}},
  {{41,0,1,26,10,8,-1,0,14},{41,0,1,26,10,8,-1,0,14},{41,0,1,26,10,8,-1,0,14},{41,0,1,26,10,8,-1,0,14},{41,0,1,26,10,8,-1,0,14},{41,0,1,26,10,8,-1,0,14},{41,0,1,26,10,8,-1,0,14},{41,0,1,26,10,8,-1,0,14},{41,0,1,26,10,8,-1,0,14},{41,0,1,26,10,8,-1,0,14},{41,0,1,26,10,8,-1,0,14},{41,0,1,26,10,8,-1,0,14},{41,0,1,26,10,8,-1,0,14},{41,0,1,26,10,8,-1,0,14},{41,0,1,26,10,8,-1,0,14},{41,0,1,26,10,8,-1,0,14}},
  {{41,0,1,26,10,8,-1,0,14},{41,0,1,26,10,8,-1,0,14},{41,0,1,26,10,8,-1,0,14},{41,0,1,26,10,8,-1,0,14},{41,0,1,26,10,8,-1,0,14},{41,0,1,26,10,8,-1,0,14},{41,0,1,26,10,8,-1,0,14},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0}},
  {{131,0,0,7,0,6,-1,1,2},{131,0,0,7,0,6,-1,1,2},{131,0,0,7,0,6,-1,1,2},{131,0,0,7,0,6,-1,1,2},{131,0,0,7,0,6,-1,1,2},{131,0,0,7,0,6,-1,1,2},{131,0,0,7,0,6,-1,1,2},{131,0,0,7,0,6,-1,1,2},{131,0,0,7,0,6,-1,1,2},{131,0,0,7,0,6,-1,1,2},{131,0,0,7,0,6,-1,1,2},{131,0,0,7,0,6,-1,1,2},{131,0,0,7,0,6,-1,1,2},{131,0,0,7,0,6,-1,1,2},{131,0,0,7,0,6,-1,1,2},{131,0,0,7,0,6,-1,1,2}},
  {{131,0,0,7,0,6,-1,1,2},{131,0,0,7,0,6,-1,1,2},{131,0,0,7,0,6,-1,1,2},{131,0,0,7,0,6,-1,1,2},{131,0,0,7,0,6,-1,1,2},{131,0,0,7,0,6,-1,1,2},{131,0,0,7,0,6,-1,1,2},{131,0,0,7,0,6,-1,1,2},{131,0,0,6,0,6,-1,1,2},{131,0,0,6,0,6,-1,1,2},{131,0,0,6,0,6,-1,1,2},{131,0,0,6,0,6,-1,1,2},{131,0,0,6,0,6,-1,1,2},{131,0,0,6,0,6,-1,1,2},{131,0,0,21,0,8,-1,1,4},{131,0,0,21,0,8,-1,1,4}},
  {{99,0,0,7,0,6,-1,1,2},{99,0,0,7,0,6,-1,1,2},{99,0,0,7,0,6,-1,1,2},{99,0,0,7,0,6,-1,1,2},{99,0,0,7,0,6,-1,1,2},{99,0,0,7,0,6,-1,1,2},{99,0,0,7,0,6,-1,1,2},{99,0,0,7,0,6,-1,1,2},{99,0,0,7,0,6,-1,1,2},{99,0,0,7,0,6,-1,1,2},{99,0,0,7,0,6,-1,1,2},{99,0,0,7,0,6,-1,1,2},{99,0,0,7,0,6,-1,1,2},{99,0,0,7,0,6,-1,1,2},{99,0,0,7,0,6,-1,1,2},{99,0,0,7,0,6,-1,1,2}},
  {{99,0,0,7,0,6,-1,1,2},{99,0,0,7,0,6,-1,1,2},{99,0,0,7,0,6,-1,1,2},{99,0,0,7,0,6,-1,1,2},{99,0,0,7,0,6,-1,1,2},{99,0,0,7,0,6,-1,1,2},{99,0,0,7,0,6,-1,1,2},{99,0,0,7,0,6,-1,1,2},{99,0,0,7,0,6,-1,1,2},{99,0,0,7,0,6,-1,1,2},{99,0,0,7,0,6,-1,1,2},{99,0,0,7,0,6,-1,1,2},{99,0,0,6,0,6,-1,1,2},{99,0,0,21,10,8,-1,1,4},{99,0,0,21,10,8,-1,1,11},{99,0,0,21,10,8,-1,1,4}},
  {{99,0,0,13,0,6,0,1,19},{99,0,0,13,0,6,1,1,19},{99,0,0,13,0,6,2,1,19},{99,0,0,13,0,6,3,1,19},{99,0,0,13,0,6,4,1,19},{99,0,0,13,0,6,5,1,19},{99,0,0,13,0,6,6,1,19},{99,0,0,13,0,6,7,1,19},{99,0,0,13,0,6,8,1,19},{99,0,0,13,0,6,9,1,19},{99,0,0,7,0,6,-1,1,2},{99,0,0,7,0,6,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{8,0,0,9,0,0,-1,1,2},{8,0,0,5,0,0,-1,1,2},{8,0,0,9,0,4,-1,1,2},{8,0,0,5,0,4,-1,1,2},{8,0,0,9,0,4,-1,1,2},{8,0,0,5,0,4,-1,1,2},{8,0,0,9,0,4,-1,1,2},{8,0,0,5,0,4,-1,1,2},{8,0,0,9,0,4,-1,1,2},{8,0,0,5,0,4,-1,1,2},{8,0,0,9,0,4,-1,1,2},{8,0,0,5,0,4,-1,1,2},{8,0,0,9,0,4,-1,1,2},{8,0,0,5,0,4,-1,1,2},{8,0,0,7,0,4,-1,1,2},{8,0,0,12,17,2,-1,1,9}},
  {{8,0,0,11,17,8,-1,1,9},{8,0,0,11,17,8,-1,1,9},{8,0,0,11,17,8,-1,1,9},{8,0,0,21,10,8,-1,1,2},{8,0,0,12,17,0,-1,1,9},{8,0,0,12,17,0,-1,1,9},{8,0,0,12,17,0,-1,1,9},{8,0,0,12,17,0,-1,1,9},{8,0,0,12,17,0,-1,1,9},{8,0,0,12,17,0,-1,1,9},{8,0,0,12,17,0,-1,1,9},{8,0,0,12,17,0,-1,1,9},{8,0,0,12,17,2,-1,1,9},{8,0,0,12,17,2,-1,1,9},{8,0,0,21,10,8,-1,1,2},{8,0,0,6,10,0,-1,1,2}},
  {{8,0,0,9,0,4,-1,1,2},{8,0,0,5,0,4,-1,1,2},{8,0,0,9,0,4,-1,1,2},{8,0,0,5,0,4,-1,1,2},{8,0,0,9,0,4,-1,1,2},{8,0,0,5,0,4,-1,1,2},{8,0,0,9,0,4,-1,1,2},{8,0,0,5,0,4,-1,1,2},{8,0,0,9,0,4,-1,1,2},{8,0,0,5,0,4,-1,1,2},{8,0,0,9,0,4,-1,1,2},{8,0,0,5,0,4,-1,1,2},{8,0,0,6,0,9,-1,1,2},{8,0,0,6,0,9,-1,1,2},{8,0,0,12,17,2,-1,1,9},{8,0,0,12,17,0,-1,1,9}},
  {{130,0,0,7,0,6,-1,1,2},{130,0,0,7,0,6,-1,1,2},{130,0,0,7,0,6,-1,1,2},{130,0,0,7,0,6,-1,1,2},{130,0,0,7,0,6,-1,1,2},{130,0,0,7,0,6,-1,1,2},{130,0,0,7,0,6,-1,1,2},{130,0,0,7,0,6,-1,1,2},{130,0,0,7,0,6,-1,1,2},{130,0,0,7,0,6,-1,1,2},{130,0,0,7,0,6,-1,1,2},{130,0,0,7,0,6,-1,1,2},{130,0,0,7,0,6,-1,1,2},{130,0,0,7,0,6,-1,1,2},{130,0,0,7,0,6,-1,1,2},{130,0,0,7,0,6,-1,1,2}},
  {{130,0,0,7,0,6,-1,1,2},{130,0,0,7,0,6,-1,1,2},{130,0,0,7,0,6,-1,1,2},{130,0,0,7,0,6,-1,1,2},{130,0,0,7,0,6,-1,1,2},{130,0,0,7,0,6,-1,1,2},{130,0,0,14,0,6,-1,1,2},{130,0,0,14,0,6,-1,1,2},{130,0,0,14,0,6,-1,1,2},{130,0,0,14,0,6,-1,1,2},{130,0,0,14,0,6,-1,1,2},{130,0,0,14,0,6,-1,1,2},{130,0,0,14,0,6,-1,1,2},{130,0,0,14,0,6,-1,1,2},{130,0,0,14,0,6,-1,1,2},{130,0,0,14,0,6,-1,1,2}},
  {{130,0,0,12,17,6,-1,1,9},{130,0,0,12,17,6,-1,1,9},{130,0,0,21,0,8,-1,1,2},{130,0,0,21,0,8,-1,1,4},{130,0,0,21,0,8,-1,1,4},{130,0,0,21,0,8,-1,1,4},{130,0,0,21,0,8,-1,1,4},{130,0,0,21,0,8,-1,1,4},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{0,0,0,24,10,8,-1,1,2},{0,0,0,24,10,8,-1,1,2},{0,0,0,24,10,8,-1,1,2},{0,0,0,24,10,8,-1,1,2},{0,0,0,24,10,8,-1,1,2},{0,0,0,24,10,8,-1,1,2},{0,0,0,24,10,8,-1,1,2},{0,0,0,6,10,0,-1,1,2},{0,0,0,6,10,0,-1,1,2},{0,0,0,6,10,0,-1,1,2},{0,0,0,6,10,0,-1,1,2},{0,0,0,6,10,0,-1,1,2},{0,0,0,6,10,0,-1,1,2},{0,0,0,6,10,0,-1,1,2},{0,0,0,6,10,0,-1,1,2},{0,0,0,6,10,0,-1,1,2}},
  {{0,0,0,24,10,8,-1,1,2},{0,0,0,24,10,8,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2}},
  {{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2}},
  {{25,0,0,9,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2}},
  {{25,0,0,6,0,9,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2}},
  {{25,0,0,9,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{0,0,0,6,10,0,-1,1,2},{0,0,0,24,0,8,-1,1,2},{0,0,0,24,0,8,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,7,0,2,-1,1,2}},
  {{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2}},
  {{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,9,0,0,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{25,0,0,9,0,4,-1,1,2},{25,0,0,9,0,4,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,9,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{25,0,0,7,0,4,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,5,0,0,-1,1,2},{25,0,0,7,0,4,-1,1,2},{25,0,0,7,0,4,-1,1,2},{25,0,0,7,0,4,-1,1,2},{25,0,0,7,0,4,-1,1,2},{25,0,0,7,0,4,-1,1,2}},
  {{58,0,0,7,0,6,-1,1,2},{58,0,0,7,0,6,-1,1,2},{58,0,0,12,17,6,-1,1,9},{58,0,0,7,0,6,-1,1,2},{58,0,0,7,0,6,-1,1,2},{58,0,0,7,0,6,-1,1,2},{58,0,0,12,17,6,-1,1,9},{58,0,0,7,0,6,-1,1,2},{58,0,0,7,0,6,-1,1,2},{58,0,0,7,0,6,-1,1,2},{58,0,0,7,0,6,-1,1,2},{58,0,0,12,17,6,-1,1,9},{58,0,0,7,0,6,-1,1,2},{58,0,0,7,0,6,-1,1,2},{58,0,0,7,0,6,-1,1,2},{58,0,0,7,0,6,-1,1,2}},
  {{58,0,0,7,0,6,-1,1,2},{58,0,0,7,0,6,-1,1,2},{58,0,0,7,0,6,-1,1,2},{58,0,0,7,0,6,-1,1,2},{58,0,0,7,0,6,-1,1,2},{58,0,0,7,0,6,-1,1,2},{58,0,0,7,0,6,-1,1,2},{58,0,0,7,0,6,-1,1,2},{58,0,0,7,0,6,-1,1,2},{58,0,0,7,0,6,-1,1,2},{58,0,0,7,0,6,-1,1,2},{58,0,0,7,0,6,-1,1,2},{58,0,0,7,0,6,-1,1,2},{58,0,0,7,0,6,-1,1,2},{58,0,0,7,0,6,-1,1,2},{58,0,0,7,0,6,-1,1,2}},
  {{58,0,0,7,0,6,-1,1,2},{58,0,0,7,0,6,-1,1,2},{58,0,0,7,0,6,-1,1,2},{58,0,0,10,0,6,-1,1,9},{58,0,0,10,0,6,-1,1,9},{58,0,0,12,17,6,-1,1,9},{58,0,0,12,17,6,-1,1,9},{58,0,0,10,0,6,-1,1,9},{58,0,0,26,10,8,-1,1,2},{58,0,0,26,10,8,-1,1,2},{58,0,0,26,10,8,-1,1,2},{58,0,0,26,10,8,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{0,0,0,15,0,8,-1,1,2},{0,0,0,15,0,8,-1,1,2},{0,0,0,15,0,8,-1,1,2},{0,0,0,15,0,8,-1,1,2},{0,0,0,15,0,8,-1,1,2},{0,0,0,15,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,23,4,8,-1,1,21},{0,0,0,26,4,8,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{90,0,0,7,0,7,-1,1,2},{90,0,0,7,0,7,-1,1,2},{90,0,0,7,0,7,-1,1,2},{90,0,0,7,0,7,-1,1,2},{90,0,0,7,0,7,-1,1,2},{90,0,0,7,0,7,-1,1,2},{90,0,0,7,0,7,-1,1,2},{90,0,0,7,0,7,-1,1,2},{90,0,0,7,0,7,-1,1,2},{90,0,0,7,0,7,-1,1,2},{90,0,0,7,0,7,-1,1,2},{90,0,0,7,0,7,-1,1,2},{90,0,0,7,0,7,-1,1,2},{90,0,0,7,0,7,-1,1,2},{90,0,0,7,0,7,-1,1,2},{90,0,0,7,0,7,-1,1,2}},
  {{90,0,0,7,0,7,-1,1,2},{90,0,0,7,0,7,-1,1,2},{90,0,0,7,0,7,-1,1,2},{90,0,0,7,0,7,-1,1,2},{90,0,0,21,10,8,-1,1,5},{90,0,0,21,10,8,-1,1,5},{90,0,0,21,10,8,-1,1,11},{90,0,0,21,10,8,-1,1,11},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{111,0,0,10,0,6,-1,1,9},{111,0,0,10,0,6,-1,1,9},{111,0,0,7,0,6,-1,1,2},{111,0,0,7,0,6,-1,1,2},{111,0,0,7,0,6,-1,1,2},{111,0,0,7,0,6,-1,1,2},{111,0,0,7,0,6,-1,1,2},{111,0,0,7,0,6,-1,1,2},{111,0,0,7,0,6,-1,1,2},{111,0,0,7,0,6,-1,1,2},{111,0,0,7,0,6,-1,1,2},{111,0,0,7,0,6,-1,1,2},{111,0,0,7,0,6,-1,1,2},{111,0,0,7,0,6,-1,1,2},{111,0,0,7,0,6,-1,1,2},{111,0,0,7,0,6,-1,1,2}},
  {{111,0,0,7,0,6,-1,1,2},{111,0,0,7,0,6,-1,1,2},{111,0,0,7,0,6,-1,1,2},{111,0,0,7,0,6,-1,1,2},{111,0,0,7,0,6,-1,1,2},{111,0,0,7,0,6,-1,1,2},{111,0,0,7,0,6,-1,1,2},{111,0,0,7,0,6,-1,1,2},{111,0,0,7,0,6,-1,1,2},{111,0,0,7,0,6,-1,1,2},{111,0,0,7,0,6,-1,1,2},{111,0,0,7,0,6,-1,1,2},{111,0,0,7,0,6,-1,1,2},{111,0,0,7,0,6,-1,1,2},{111,0,0,7,0,6,-1,1,2},{111,0,0,7,0,6,-1,1,2}},
  {{111,0,0,7,0,6,-1,1,2},{111,0,0,7,0,6,-1,1,2},{111,0,0,7,0,6,-1,1,2},{111,0,0,7,0,6,-1,1,2},{111,0,0,10,0,6,-1,1,9},{111,0,0,10,0,6,-1,1,9},{111,0,0,10,0,6,-1,1,9},{111,0,0,10,0,6,-1,1,9},{111,0,0,10,0,6,-1,1,9},{111,0,0,10,0,6,-1,1,9},{111,0,0,10,0,6,-1,1,9},{111,0,0,10,0,6,-1,1,9},{111,0,0,10,0,6,-1,1,9},{111,0,0,10,0,6,-1,1,9},{111,0,0,10,0,6,-1,1,9},{111,0,0,10,0,6,-1,1,9}},
  {{111,0,0,10,0,6,-1,1,9},{111,0,0,10,0,6,-1,1,9},{111,0,0,10,0,6,-1,1,9},{111,0,0,10,0,6,-1,1,9},{111,0,0,12,17,6,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{111,0,0,21,0,8,-1,1,4},{111,0,0,21,0,8,-1,1,4}},
  {{111,0,0,13,0,6,0,1,19},{111,0,0,13,0,6,1,1,19},{111,0,0,13,0,6,2,1,19},{111,0,0,13,0,6,3,1,19},{111,0,0,13,0,6,4,1,19},{111,0,0,13,0,6,5,1,19},{111,0,0,13,0,6,6,1,19},{111,0,0,13,0,6,7,1,19},{111,0,0,13,0,6,8,1,19},{111,0,0,13,0,6,9,1,19},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{10,0,0,12,17,4,-1,1,9},{10,0,0,12,17,4,-1,1,9},{10,0,0,12,17,4,-1,1,9},{10,0,0,12,17,4,-1,1,9},{10,0,0,12,17,4,-1,1,9},{10,0,0,12,17,4,-1,1,9},{10,0,0,12,17,4,-1,1,9},{10,0,0,12,17,4,-1,1,9},{10,0,0,12,17,4,-1,1,9},{10,0,0,12,17,4,-1,1,9},{10,0,0,12,17,4,-1,1,9},{10,0,0,12,17,4,-1,1,9},{10,0,0,12,17,4,-1,1,9},{10,0,0,12,17,4,-1,1,9},{10,0,0,12,17,4,-1,1,9},{10,0,0,12,17,4,-1,1,9}},
  {{10,0,0,12,17,4,-1,1,9},{10,0,0,12,17,4,-1,1,9},{10,0,0,7,0,4,-1,1,2},{10,0,0,7,0,4,-1,1,2},{10,0,0,7,0,4,-1,1,2},{10,0,0,7,0,4,-1,1,2},{10,0,0,7,0,4,-1,1,2},{10,0,0,7,0,4,-1,1,2},{10,0,0,21,0,8,-1,1,2},{10,0,0,21,0,8,-1,1,2},{10,0,0,21,0,8,-1,1,2},{10,0,0,7,0,4,-1,1,2},{10,0,0,21,0,8,-1,1,5},{10,0,0,7,0,4,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{79,0,0,13,0,6,0,1,19},{79,0,0,13,0,6,1,1,19},{79,0,0,13,0,6,2,1,19},{79,0,0,13,0,6,3,1,19},{79,0,0,13,0,6,4,1,19},{79,0,0,13,0,6,5,1,19},{79,0,0,13,0,6,6,1,19},{79,0,0,13,0,6,7,1,19},{79,0,0,13,0,6,8,1,19},{79,0,0,13,0,6,9,1,19},{79,0,0,7,0,6,-1,1,2},{79,0,0,7,0,6,-1,1,2},{79,0,0,7,0,6,-1,1,2},{79,0,0,7,0,6,-1,1,2},{79,0,0,7,0,6,-1,1,2},{79,0,0,7,0,6,-1,1,2}},
  {{79,0,0,7,0,6,-1,1,2},{79,0,0,7,0,6,-1,1,2},{79,0,0,7,0,6,-1,1,2},{79,0,0,7,0,6,-1,1,2},{79,0,0,7,0,6,-1,1,2},{79,0,0,7,0,6,-1,1,2},{79,0,0,7,0,6,-1,1,2},{79,0,0,7,0,6,-1,1,2},{79,0,0,7,0,6,-1,1,2},{79,0,0,7,0,6,-1,1,2},{79,0,0,7,0,6,-1,1,2},{79,0,0,7,0,6,-1,1,2},{79,0,0,7,0,6,-1,1,2},{79,0,0,7,0,6,-1,1,2},{79,0,0,7,0,6,-1,1,2},{79,0,0,7,0,6,-1,1,2}},
  {{79,0,0,7,0,6,-1,1,2},{79,0,0,7,0,6,-1,1,2},{79,0,0,7,0,6,-1,1,2},{79,0,0,7,0,6,-1,1,2},{79,0,0,7,0,6,-1,1,2},{79,0,0,7,0,6,-1,1,2},{79,0,0,12,17,6,-1,1,9},{79,0,0,12,17,6,-1,1,9},{79,0,0,12,17,6,-1,1,9},{79,0,0,12,17,6,-1,1,9},{79,0,0,12,17,6,-1,1,9},{79,0,0,12,17,6,-1,1,9},{79,0,0,12,17,6,-1,1,9},{79,0,0,12,17,6,-1,1,9},{0,0,0,21,0,8,-1,1,4},{79,0,0,21,0,8,-1,1,4}},
  {{110,0,0,7,0,7,-1,1,2},{110,0,0,7,0,7,-1,1,2},{110,0,0,7,0,7,-1,1,2},{110,0,0,7,0,7,-1,1,2},{110,0,0,7,0,7,-1,1,2},{110,0,0,7,0,7,-1,1,2},{110,0,0,7,0,7,-1,1,2},{110,0,0,7,0,7,-1,1,2},{110,0,0,7,0,7,-1,1,2},{110,0,0,7,0,7,-1,1,2},{110,0,0,7,0,7,-1,1,2},{110,0,0,7,0,7,-1,1,2},{110,0,0,7,0,7,-1,1,2},{110,0,0,7,0,7,-1,1,2},{110,0,0,7,0,7,-1,1,2},{110,0,0,7,0,7,-1,1,2}},
  {{110,0,0,7,0,7,-1,1,2},{110,0,0,7,0,7,-1,1,2},{110,0,0,7,0,7,-1,1,2},{110,0,0,7,0,7,-1,1,2},{110,0,0,7,0,7,-1,1,2},{110,0,0,7,0,7,-1,1,2},{110,0,0,7,0,7,-1,1,2},{110,0,0,12,17,7,-1,1,9},{110,0,0,12,17,7,-1,1,9},{110,0,0,12,17,7,-1,1,9},{110,0,0,12,17,7,-1,1,9},{110,0,0,12,17,7,-1,1,9},{110,0,0,12,17,7,-1,1,9},{110,0,0,12,17,7,-1,1,9},{110,0,0,12,17,7,-1,1,9},{110,0,0,12,17,7,-1,1,9}},
  {{110,0,0,12,17,7,-1,1,9},{110,0,0,12,17,7,-1,1,9},{110,0,0,10,0,7,-1,1,9},{110,0,0,10,0,7,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{110,0,0,21,0,8,-1,1,2}},
  {{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33},{18,0,1,7,0,4,-1,0,33},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0}},
  {{78,0,0,12,17,6,-1,1,9},{78,0,0,12,17,6,-1,1,9},{78,0,0,12,17,6,-1,1,9},{78,0,0,10,0,6,-1,1,9},{78,0,0,7,0,6,-1,1,2},{78,0,0,7,0,6,-1,1,2},{78,0,0,7,0,6,-1,1,2},{78,0,0,7,0,6,-1,1,2},{78,0,0,7,0,6,-1,1,2},{78,0,0,7,0,6,-1,1,2},{78,0,0,7,0,6,-1,1,2},{78,0,0,7,0,6,-1,1,2},{78,0,0,7,0,6,-1,1,2},{78,0,0,7,0,6,-1,1,2},{78,0,0,7,0,6,-1,1,2},{78,0,0,7,0,6,-1,1,2}},
  {{78,0,0,7,0,6,-1,1,2},{78,0,0,7,0,6,-1,1,2},{78,0,0,7,0,6,-1,1,2},{78,0,0,7,0,6,-1,1,2},{78,0,0,7,0,6,-1,1,2},{78,0,0,7,0,6,-1,1,2},{78,0,0,7,0,6,-1,1,2},{78,0,0,7,0,6,-1,1,2},{78,0,0,7,0,6,-1,1,2},{78,0,0,7,0,6,-1,1,2},{78,0,0,7,0,6,-1,1,2},{78,0,0,7,0,6,-1,1,2},{78,0,0,7,0,6,-1,1,2},{78,0,0,7,0,6,-1,1,2},{78,0,0,7,0,6,-1,1,2},{78,0,0,7,0,6,-1,1,2}},
  {{78,0,0,7,0,6,-1,1,2},{78,0,0,7,0,6,-1,1,2},{78,0,0,7,0,6,-1,1,2},{78,0,0,12,17,6,-1,1,9},{78,0,0,10,0,6,-1,1,9},{78,0,0,10,0,6,-1,1,9},{78,0,0,12,17,6,-1,1,9},{78,0,0,12,17,6,-1,1,9},{78,0,0,12,17,6,-1,1,9},{78,0,0,12,17,6,-1,1,9},{78,0,0,10,0,6,-1,1,9},{78,0,0,10,0,6,-1,1,9},{78,0,0,12,17,6,-1,1,9},{78,0,0,10,0,6,-1,1,9},{78,0,0,10,0,6,-1,1,9},{78,0,0,10,0,6,-1,1,9}},
  {{78,0,0,10,0,6,-1,1,9},{78,0,0,21,0,8,-1,1,2},{78,0,0,21,0,8,-1,1,2},{78,0,0,21,0,8,-1,1,2},{78,0,0,21,0,8,-1,1,2},{78,0,0,21,0,8,-1,1,2},{78,0,0,21,0,8,-1,1,2},{78,0,0,21,0,8,-1,1,4},{78,0,0,21,0,8,-1,1,4},{78,0,0,21,0,8,-1,1,4},{78,0,0,21,0,8,-1,1,2},{78,0,0,21,0,8,-1,1,2},{78,0,0,21,0,8,-1,1,2},{78,0,0,21,0,8,-1,1,2},{103,0,0,2,0,12,-1,1,0},{0,0,0,6,0,7,-1,1,2}},
  {{78,0,0,13,0,6,0,1,19},{78,0,0,13,0,6,1,1,19},{78,0,0,13,0,6,2,1,19},{78,0,0,13,0,6,3,1,19},{78,0,0,13,0,6,4,1,19},{78,0,0,13,0,6,5,1,19},{78,0,0,13,0,6,6,1,19},{78,0,0,13,0,6,7,1,19},{78,0,0,13,0,6,8,1,19},{78,0,0,13,0,6,9,1,19},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{78,0,0,21,0,8,-1,1,2},{78,0,0,21,0,8,-1,1,2}},
  {{28,0,0,7,0,4,-1,1,24},{28,0,0,7,0,4,-1,1,24},{28,0,0,7,0,4,-1,1,24},{28,0,0,7,0,4,-1,1,24},{28,0,0,7,0,4,-1,1,24},{28,0,0,12,17,4,-1,1,24},{28,0,0,6,0,4,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24}},
  {{28,0,0,13,0,0,0,1,19},{28,0,0,13,0,0,1,1,19},{28,0,0,13,0,0,2,1,19},{28,0,0,13,0,0,3,1,19},{28,0,0,13,0,0,4,1,19},{28,0,0,13,0,0,5,1,19},{28,0,0,13,0,0,6,1,19},{28,0,0,13,0,0,7,1,19},{28,0,0,13,0,0,8,1,19},{28,0,0,13,0,0,9,1,19},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{103,0,0,2,0,12,-1,1,0}},
  {{66,0,0,7,0,6,-1,1,2},{66,0,0,7,0,6,-1,1,2},{66,0,0,7,0,6,-1,1,2},{66,0,0,7,0,6,-1,1,2},{66,0,0,7,0,6,-1,1,2},{66,0,0,7,0,6,-1,1,2},{66,0,0,7,0,6,-1,1,2},{66,0,0,7,0,6,-1,1,2},{66,0,0,7,0,6,-1,1,2},{66,0,0,7,0,6,-1,1,2},{66,0,0,7,0,6,-1,1,2},{66,0,0,7,0,6,-1,1,2},{66,0,0,7,0,6,-1,1,2},{66,0,0,7,0,6,-1,1,2},{66,0,0,7,0,6,-1,1,2},{66,0,0,7,0,6,-1,1,2}},
  {{66,0,0,7,0,6,-1,1,2},{66,0,0,7,0,6,-1,1,2},{66,0,0,7,0,6,-1,1,2},{66,0,0,7,0,6,-1,1,2},{66,0,0,7,0,6,-1,1,2},{66,0,0,7,0,6,-1,1,2},{66,0,0,7,0,6,-1,1,2},{66,0,0,7,0,6,-1,1,2},{66,0,0,7,0,6,-1,1,2},{66,0,0,12,17,6,-1,1,9},{66,0,0,12,17,6,-1,1,9},{66,0,0,12,17,6,-1,1,9},{66,0,0,12,17,6,-1,1,9},{66,0,0,12,17,6,-1,1,9},{66,0,0,12,17,6,-1,1,9},{66,0,0,10,0,6,-1,1,9}},
  {{66,0,0,10,0,6,-1,1,9},{66,0,0,12,17,6,-1,1,9},{66,0,0,12,17,6,-1,1,9},{66,0,0,10,0,6,-1,1,9},{66,0,0,10,0,6,-1,1,9},{66,0,0,12,17,6,-1,1,9},{66,0,0,12,17,6,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{66,0,0,7,0,6,-1,1,2},{66,0,0,7,0,6,-1,1,2},{66,0,0,7,0,6,-1,1,2},{66,0,0,12,17,6,-1,1,9},{66,0,0,7,0,6,-1,1,2},{66,0,0,7,0,6,-1,1,2},{66,0,0,7,0,6,-1,1,2},{66,0,0,7,0,6,-1,1,2},{66,0,0,7,0,6,-1,1,2},{66,0,0,7,0,6,-1,1,2},{66,0,0,7,0,6,-1,1,2},{66,0,0,7,0,6,-1,1,2},{66,0,0,12,17,6,-1,1,9},{66,0,0,10,0,6,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{66,0,0,13,0,6,0,1,19},{66,0,0,13,0,6,1,1,19},{66,0,0,13,0,6,2,1,19},{66,0,0,13,0,6,3,1,19},{66,0,0,13,0,6,4,1,19},{66,0,0,13,0,6,5,1,19},{66,0,0,13,0,6,6,1,19},{66,0,0,13,0,6,7,1,19},{66,0,0,13,0,6,8,1,19},{66,0,0,13,0,6,9,1,19},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{66,0,0,21,0,8,-1,1,2},{66,0,0,21,0,8,-1,1,4},{66,0,0,21,0,8,-1,1,4},{66,0,0,21,0,8,-1,1,4}},
  {{28,0,0,6,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,26,0,8,-1,1,24},{28,0,0,26,0,8,-1,1,24},{28,0,0,26,0,8,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,10,0,0,-1,1,24},{28,0,0,12,17,0,-1,1,24},{28,0,0,10,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24},{28,0,0,7,0,0,-1,1,24}},
  {{127,0,0,7,0,6,-1,1,24},{127,0,0,7,0,6,-1,1,24},{127,0,0,7,0,6,-1,1,24},{127,0,0,7,0,6,-1,1,24},{127,0,0,7,0,6,-1,1,24},{127,0,0,7,0,6,-1,1,24},{127,0,0,7,0,6,-1,1,24},{127,0,0,7,0,6,-1,1,24},{127,0,0,7,0,6,-1,1,24},{127,0,0,7,0,6,-1,1,24},{127,0,0,7,0,6,-1,1,24},{127,0,0,7,0,6,-1,1,24},{127,0,0,7,0,6,-1,1,24},{127,0,0,7,0,6,-1,1,24},{127,0,0,7,0,6,-1,1,24},{127,0,0,7,0,6,-1,1,24}},
  {{127,0,0,12,17,6,-1,1,24},{127,0,0,7,0,6,-1,1,24},{127,0,0,12,17,6,-1,1,24},{127,0,0,12,17,6,-1,1,24},{127,0,0,12,17,6,-1,1,24},{127,0,0,7,0,6,-1,1,24},{127,0,0,7,0,6,-1,1,24},{127,0,0,12,17,6,-1,1,24},{127,0,0,12,17,6,-1,1,24},{127,0,0,7,0,6,-1,1,24},{127,0,0,7,0,6,-1,1,24},{127,0,0,7,0,6,-1,1,24},{127,0,0,7,0,6,-1,1,24},{127,0,0,7,0,6,-1,1,24},{127,0,0,12,17,6,-1,1,24},{127,0,0,12,17,6,-1,1,24}},
  {{127,0,0,7,0,6,-1,1,24},{127,0,0,12,17,6,-1,1,24},{127,0,0,7,0,6,-1,1,24},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{127,0,0,7,0,6,-1,1,24},{127,0,0,7,0,6,-1,1,24},{127,0,0,6,0,6,-1,1,24},{127,0,0,21,0,8,-1,1,24},{127,0,0,21,0,8,-1,1,24}},
  {{115,0,0,7,0,6,-1,1,2},{115,0,0,7,0,6,-1,1,2},{115,0,0,7,0,6,-1,1,2},{115,0,0,7,0,6,-1,1,2},{115,0,0,7,0,6,-1,1,2},{115,0,0,7,0,6,-1,1,2},{115,0,0,7,0,6,-1,1,2},{115,0,0,7,0,6,-1,1,2},{115,0,0,7,0,6,-1,1,2},{115,0,0,7,0,6,-1,1,2},{115,0,0,7,0,6,-1,1,2},{115,0,0,10,0,6,-1,1,9},{115,0,0,12,17,6,-1,1,9},{115,0,0,12,17,6,-1,1,9},{115,0,0,10,0,6,-1,1,9},{115,0,0,10,0,6,-1,1,9}},
  {{115,0,0,21,0,8,-1,1,4},{115,0,0,21,0,8,-1,1,4},{115,0,0,7,0,6,-1,1,2},{115,0,0,6,0,6,-1,1,2},{115,0,0,6,0,6,-1,1,2},{115,0,0,10,0,6,-1,1,9},{115,0,0,12,17,6,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{103,0,0,2,0,12,-1,1,0},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0}},
  {{103,0,0,2,0,12,-1,1,0},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{11,0,0,7,0,0,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2}},
  {{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{25,0,0,5,0,4,-1,1,2},{0,0,0,24,0,8,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2},{25,0,0,6,0,9,-1,1,2}},
  {{25,0,0,5,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,5,0,2,-1,1,2},{25,0,0,5,0,4,-1,1,2},{14,0,0,5,0,4,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{6,0,0,5,0,6,-1,1,2},{6,0,0,5,0,6,-1,1,2},{6,0,0,5,0,6,-1,1,2},{6,0,0,5,0,6,-1,1,2},{6,0,0,5,0,6,-1,1,2},{6,0,0,5,0,6,-1,1,2},{6,0,0,5,0,6,-1,1,2},{6,0,0,5,0,6,-1,1,2},{6,0,0,5,0,6,-1,1,2},{6,0,0,5,0,6,-1,1,2},{6,0,0,5,0,6,-1,1,2},{6,0,0,5,0,6,-1,1,2},{6,0,0,5,0,6,-1,1,2},{6,0,0,5,0,6,-1,1,2},{6,0,0,5,0,6,-1,1,2},{6,0,0,5,0,6,-1,1,2}},
  {{115,0,0,7,0,6,-1,1,2},{115,0,0,7,0,6,-1,1,2},{115,0,0,7,0,6,-1,1,2},{115,0,0,7,0,6,-1,1,2},{115,0,0,7,0,6,-1,1,2},{115,0,0,7,0,6,-1,1,2},{115,0,0,7,0,6,-1,1,2},{115,0,0,7,0,6,-1,1,2},{115,0,0,7,0,6,-1,1,2},{115,0,0,7,0,6,-1,1,2},{115,0,0,7,0,6,-1,1,2},{115,0,0,7,0,6,-1,1,2},{115,0,0,7,0,6,-1,1,2},{115,0,0,7,0,6,-1,1,2},{115,0,0,7,0,6,-1,1,2},{115,0,0,7,0,6,-1,1,2}},
  {{115,0,0,7,0,6,-1,1,2},{115,0,0,7,0,6,-1,1,2},{115,0,0,7,0,6,-1,1,2},{115,0,0,10,0,6,-1,1,9},{115,0,0,10,0,6,-1,1,9},{115,0,0,12,17,6,-1,1,9},{115,0,0,10,0,6,-1,1,9},{115,0,0,10,0,6,-1,1,9},{115,0,0,12,17,6,-1,1,9},{115,0,0,10,0,6,-1,1,9},{115,0,0,10,0,6,-1,1,9},{115,0,0,21,0,8,-1,1,4},{115,0,0,10,0,6,-1,1,9},{115,0,0,12,17,6,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{115,0,0,13,0,6,0,1,19},{115,0,0,13,0,6,1,1,19},{115,0,0,13,0,6,2,1,19},{115,0,0,13,0,6,3,1,19},{115,0,0,13,0,6,4,1,19},{115,0,0,13,0,6,5,1,19},{115,0,0,13,0,6,6,1,19},{115,0,0,13,0,6,7,1,19},{115,0,0,13,0,6,8,1,19},{115,0,0,13,0,6,9,1,19},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{18,0,1,7,0,0,-1,0,31},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32}},
  {{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,31},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32}},
  {{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32}},
  {{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,31},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32}},
  {{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,31},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32}},
  {{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{18,0,1,7,0,0,-1,0,32},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0}},
  {{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35},{18,0,0,7,0,4,-1,0,35},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{18,0,0,7,0,4,-1,0,34},{18,0,0,7,0,4,-1,0,34},{18,0,0,7,0,4,-1,0,34},{18,0,0,7,0,4,-1,0,34},{18,0,0,7,0,4,-1,0,34}},
  {{18,0,0,7,0,4,-1,0,34},{18,0,0,7,0,4,-1,0,34},{18,0,0,7,0,4,-1,0,34},{18,0,0,7,0,4,-1,0,34},{18,0,0,7,0,4,-1,0,34},{18,0,0,7,0,4,-1,0,34},{18,0,0,7,0,4,-1,0,34},{18,0,0,7,0,4,-1,0,34},{18,0,0,7,0,4,-1,0,34},{18,0,0,7,0,4,-1,0,34},{18,0,0,7,0,4,-1,0,34},{18,0,0,7,0,4,-1,0,34},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0}},
  {{103,0,0,4,0,12,-1,1,25},{103,0,0,4,0,12,-1,1,25},{103,0,0,4,0,12,-1,1,25},{103,0,0,4,0,12,-1,1,25},{103,0,0,4,0,12,-1,1,25},{103,0,0,4,0,12,-1,1,25},{103,0,0,4,0,12,-1,1,25},{103,0,0,4,0,12,-1,1,25},{103,0,0,4,0,12,-1,1,25},{103,0,0,4,0,12,-1,1,25},{103,0,0,4,0,12,-1,1,25},{103,0,0,4,0,12,-1,1,25},{103,0,0,4,0,12,-1,1,25},{103,0,0,4,0,12,-1,1,25},{103,0,0,4,0,12,-1,1,25},{103,0,0,4,0,12,-1,1,25}},
  {{103,0,0,3,0,12,-1,0,0},{103,0,0,3,0,12,-1,0,0},{103,0,0,3,0,12,-1,0,0},{103,0,0,3,0,12,-1,0,0},{103,0,0,3,0,12,-1,0,0},{103,0,0,3,0,12,-1,0,0},{103,0,0,3,0,12,-1,0,0},{103,0,0,3,0,12,-1,0,0},{103,0,0,3,0,12,-1,0,0},{103,0,0,3,0,12,-1,0,0},{103,0,0,3,0,12,-1,0,0},{103,0,0,3,0,12,-1,0,0},{103,0,0,3,0,12,-1,0,0},{103,0,0,3,0,12,-1,0,0},{103,0,0,3,0,12,-1,0,0},{103,0,0,3,0,12,-1,0,0}},
  {{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14}},
  {{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14}},
  {{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,0,-1,0,14}},
  {{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14}},
  {{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14}},
  {{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{17,0,1,7,0,9,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14}},
  {{25,0,0,5,0,9,-1,1,2},{25,0,0,5,0,9,-1,1,2},{25,0,0,5,0,9,-1,1,2},{25,0,0,5,0,9,-1,1,2},{25,0,0,5,0,9,-1,1,2},{25,0,0,5,0,9,-1,1,2},{25,0,0,5,0,9,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{3,0,0,5,0,9,-1,1,2},{3,0,0,5,0,9,-1,1,2},{3,0,0,5,0,9,-1,1,2},{3,0,0,5,0,9,-1,1,2},{3,0,0,5,0,9,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{19,0,0,7,1,9,-1,1,38},{19,0,0,12,17,3,-1,1,9},{19,0,0,7,1,9,-1,1,38}},
  {{19,0,0,7,1,9,-1,1,38},{19,0,0,7,1,9,-1,1,38},{19,0,0,7,1,9,-1,1,38},{19,0,0,7,1,9,-1,1,38},{19,0,0,7,1,9,-1,1,38},{19,0,0,7,1,9,-1,1,38},{19,0,0,7,1,9,-1,1,38},{19,0,0,7,1,9,-1,1,38},{19,0,0,7,1,9,-1,1,38},{19,0,0,25,3,9,-1,1,2},{19,0,0,7,1,9,-1,1,38},{19,0,0,7,1,9,-1,1,38},{19,0,0,7,1,9,-1,1,38},{19,0,0,7,1,9,-1,1,38},{19,0,0,7,1,9,-1,1,38},{19,0,0,7,1,9,-1,1,38}},
  {{19,0,0,7,1,9,-1,1,38},{19,0,0,7,1,9,-1,1,38},{19,0,0,7,1,9,-1,1,38},{19,0,0,7,1,9,-1,1,38},{19,0,0,7,1,9,-1,1,38},{19,0,0,7,1,9,-1,1,38},{19,0,0,7,1,9,-1,1,38},{103,0,0,2,1,12,-1,1,0},{19,0,0,7,1,9,-1,1,38},{19,0,0,7,1,9,-1,1,38},{19,0,0,7,1,9,-1,1,38},{19,0,0,7,1,9,-1,1,38},{19,0,0,7,1,9,-1,1,38},{103,0,0,2,1,12,-1,1,0},{19,0,0,7,1,9,-1,1,38},{103,0,0,2,1,12,-1,1,0}},
  {{19,0,0,7,1,9,-1,1,38},{19,0,0,7,1,9,-1,1,38},{103,0,0,2,1,12,-1,1,0},{19,0,0,7,1,9,-1,1,38},{19,0,0,7,1,9,-1,1,38},{103,0,0,2,1,12,-1,1,0},{19,0,0,7,1,9,-1,1,38},{19,0,0,7,1,9,-1,1,38},{19,0,0,7,1,9,-1,1,38},{19,0,0,7,1,9,-1,1,38},{19,0,0,7,1,9,-1,1,38},{19,0,0,7,1,9,-1,1,38},{19,0,0,7,1,9,-1,1,38},{19,0,0,7,1,9,-1,1,38},{19,0,0,7,1,9,-1,1,38},{19,0,0,7,1,9,-1,1,38}},
  {{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2}},
  {{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,24,13,8,-1,1,2},{2,0,0,24,13,8,-1,1,2},{2,0,0,24,13,8,-1,1,2},{2,0,0,24,13,8,-1,1,2},{2,0,0,24,13,8,-1,1,2},{2,0,0,24,13,8,-1,1,2},{2,0,0,24,13,8,-1,1,2},{2,0,0,24,13,8,-1,1,2},{2,0,0,24,13,8,-1,1,2},{2,0,0,24,13,8,-1,1,2},{2,0,0,24,13,8,-1,1,2},{2,0,0,24,13,8,-1,1,2},{2,0,0,24,13,8,-1,1,2},{2,0,0,24,13,8,-1,1,2}},
  {{2,0,0,24,13,8,-1,1,2},{2,0,0,24,13,8,-1,1,2},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0}},
  {{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2}},
  {{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{0,0,0,18,10,8,-1,1,8},{0,0,0,22,10,8,-1,1,20}},
  {{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2}},
  {{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0}},
  {{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,23,13,9,-1,1,21},{2,0,0,26,10,8,-1,1,2},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0}},
  {{1,0,0,12,17,10,-1,1,9},{1,0,0,12,17,10,-1,1,9},{1,0,0,12,17,10,-1,1,9},{1,0,0,12,17,10,-1,1,9},{1,0,0,12,17,10,-1,1,9},{1,0,0,12,17,10,-1,1,9},{1,0,0,12,17,10,-1,1,9},{1,0,0,12,17,10,-1,1,9},{1,0,0,12,17,10,-1,1,9},{1,0,0,12,17,10,-1,1,9},{1,0,0,12,17,10,-1,1,9},{1,0,0,12,17,10,-1,1,9},{1,0,0,12,17,10,-1,1,9},{1,0,0,12,17,10,-1,1,9},{1,0,0,12,17,10,-1,1,9},{1,0,0,12,17,10,-1,1,9}},
  {{0,0,1,21,10,9,-1,0,16},{0,0,1,21,10,9,-1,0,8},{0,0,1,21,10,9,-1,0,8},{0,0,1,21,10,9,-1,0,16},{0,0,1,21,10,9,-1,0,16},{0,0,1,21,10,9,-1,0,11},{0,0,1,21,10,9,-1,0,11},{0,0,1,22,10,9,-1,0,20},{0,0,1,18,10,9,-1,0,8},{0,0,1,21,10,9,-1,0,15},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0}},
  {{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{1,0,0,12,17,3,-1,1,9},{8,0,0,12,17,3,-1,1,9},{8,0,0,12,17,3,-1,1,9}},
  {{0,0,1,21,10,9,-1,0,14},{0,0,1,17,10,9,-1,0,14},{0,0,1,17,10,9,-1,0,14},{0,0,1,16,10,9,-1,0,14},{0,0,1,16,10,9,-1,0,14},{0,0,1,22,10,9,-1,0,20},{0,0,1,18,10,9,-1,0,8},{0,0,1,22,10,9,-1,0,20},{0,0,1,18,10,9,-1,0,8},{0,0,1,22,10,9,-1,0,20},{0,0,1,18,10,9,-1,0,8},{0,0,1,22,10,9,-1,0,20},{0,0,1,18,10,9,-1,0,8},{0,0,1,22,10,9,-1,0,20},{0,0,1,18,10,9,-1,0,8},{0,0,1,22,10,9,-1,0,20}},
  {{0,0,1,18,10,9,-1,0,8},{0,0,1,22,10,9,-1,0,20},{0,0,1,18,10,9,-1,0,8},{0,0,1,22,10,9,-1,0,20},{0,0,1,18,10,9,-1,0,8},{0,0,1,21,10,8,-1,0,14},{0,0,1,21,10,8,-1,0,14},{0,0,1,22,10,9,-1,0,20},{0,0,1,18,10,9,-1,0,8},{0,0,1,21,10,9,-1,1,14},{0,0,1,21,10,9,-1,1,14},{0,0,1,21,10,9,-1,1,14},{0,0,1,21,10,9,-1,1,14},{0,0,1,16,10,9,-1,1,14},{0,0,1,16,10,9,-1,1,14},{0,0,1,16,10,9,-1,1,14}},
  {{0,0,1,21,6,9,-1,2,8},{0,0,1,21,10,9,-1,2,14},{0,0,1,21,6,9,-1,2,8},{103,0,0,2,0,12,-1,0,0},{0,0,1,21,10,9,-1,0,18},{0,0,1,21,6,9,-1,0,18},{0,0,1,21,10,9,-1,0,11},{0,0,1,21,10,9,-1,0,11},{0,0,1,17,10,9,-1,1,14},{0,1,1,22,10,9,-1,3,20},{0,2,1,18,10,9,-1,3,8},{0,1,1,22,10,9,-1,3,20},{0,2,1,18,10,9,-1,3,8},{0,1,1,22,10,9,-1,3,20},{0,2,1,18,10,9,-1,3,8},{0,0,1,21,4,9,-1,0,14}},
  {{0,0,1,21,10,9,-1,0,14},{0,0,1,21,10,9,-1,0,14},{0,0,1,25,3,9,-1,0,14},{0,0,1,17,3,9,-1,1,14},{0,0,1,25,10,9,-1,1,14},{0,0,1,25,10,9,-1,1,14},{0,0,1,25,10,9,-1,1,14},{103,0,0,2,0,12,-1,0,0},{0,0,1,21,10,9,-1,0,14},{0,0,1,23,4,9,-1,0,22},{0,0,1,21,4,9,-1,0,21},{0,0,1,21,10,9,-1,0,14},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0}},
  {{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,3,-1,1,2},{2,0,0,7,13,9,-1,1,2},{103,0,0,2,13,12,-1,1,0},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2}},
  {{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{0,0,0,1,18,10,-1,1,30}},
  {{103,0,0,2,0,12,-1,1,0},{0,0,1,21,10,9,-1,2,11},{0,0,1,21,10,9,-1,0,14},{0,0,1,21,4,9,-1,0,14},{0,0,1,23,4,9,-1,0,22},{0,0,1,21,4,9,-1,0,21},{0,0,1,21,10,9,-1,0,14},{0,0,1,21,10,9,-1,0,14},{0,1,1,22,10,9,-1,3,20},{0,2,1,18,10,9,-1,3,8},{0,0,1,21,10,9,-1,0,14},{0,0,1,25,3,9,-1,0,14},{0,0,1,21,6,9,-1,2,8},{0,0,1,17,3,9,-1,1,14},{0,0,1,21,6,9,-1,2,8},{0,0,1,21,6,9,-1,0,14}},
  {{0,0,1,13,2,9,0,0,14},{0,0,1,13,2,9,1,0,14},{0,0,1,13,2,9,2,0,14},{0,0,1,13,2,9,3,0,14},{0,0,1,13,2,9,4,0,14},{0,0,1,13,2,9,5,0,14},{0,0,1,13,2,9,6,0,14},{0,0,1,13,2,9,7,0,14},{0,0,1,13,2,9,8,0,14},{0,0,1,13,2,9,9,0,14},{0,0,1,21,6,9,-1,3,18},{0,0,1,21,10,9,-1,3,18},{0,0,1,25,10,9,-1,1,14},{0,0,1,25,10,9,-1,1,14},{0,0,1,25,10,9,-1,1,14},{0,0,1,21,10,9,-1,2,11}},
  {{0,0,1,21,10,9,-1,0,14},{25,0,1,9,0,9,-1,0,14},{25,0,1,9,0,9,-1,0,14},{25,0,1,9,0,9,-1,0,14},{25,0,1,9,0,9,-1,0,14},{25,0,1,9,0,9,-1,0,14},{25,0,1,9,0,9,-1,0,14},{25,0,1,9,0,9,-1,0,14},{25,0,1,9,0,9,-1,0,14},{25,0,1,9,0,9,-1,0,14},{25,0,1,9,0,9,-1,0,14},{25,0,1,9,0,9,-1,0,14},{25,0,1,9,0,9,-1,0,14},{25,0,1,9,0,9,-1,0,14},{25,0,1,9,0,9,-1,0,14},{25,0,1,9,0,9,-1,0,14}},
  {{25,0,1,9,0,9,-1,0,14},{25,0,1,9,0,9,-1,0,14},{25,0,1,9,0,9,-1,0,14},{25,0,1,9,0,9,-1,0,14},{25,0,1,9,0,9,-1,0,14},{25,0,1,9,0,9,-1,0,14},{25,0,1,9,0,9,-1,0,14},{25,0,1,9,0,9,-1,0,14},{25,0,1,9,0,9,-1,0,14},{25,0,1,9,0,9,-1,0,14},{25,0,1,9,0,9,-1,0,14},{0,1,1,22,10,9,-1,3,20},{0,0,1,21,10,9,-1,0,14},{0,2,1,18,10,9,-1,3,8},{0,0,1,24,10,9,-1,0,14},{0,0,1,16,10,9,-1,3,14}},
  {{0,0,1,24,10,9,-1,0,14},{25,0,1,5,0,9,-1,0,14},{25,0,1,5,0,9,-1,0,14},{25,0,1,5,0,9,-1,0,14},{25,0,1,5,0,9,-1,0,14},{25,0,1,5,0,9,-1,0,14},{25,0,1,5,0,9,-1,0,14},{25,0,1,5,0,9,-1,0,14},{25,0,1,5,0,9,-1,0,14},{25,0,1,5,0,9,-1,0,14},{25,0,1,5,0,9,-1,0,14},{25,0,1,5,0,9,-1,0,14},{25,0,1,5,0,9,-1,0,14},{25,0,1,5,0,9,-1,0,14},{25,0,1,5,0,9,-1,0,14},{25,0,1,5,0,9,-1,0,14}},
  {{25,0,1,5,0,9,-1,0,14},{25,0,1,5,0,9,-1,0,14},{25,0,1,5,0,9,-1,0,14},{25,0,1,5,0,9,-1,0,14},{25,0,1,5,0,9,-1,0,14},{25,0,1,5,0,9,-1,0,14},{25,0,1,5,0,9,-1,0,14},{25,0,1,5,0,9,-1,0,14},{25,0,1,5,0,9,-1,0,14},{25,0,1,5,0,9,-1,0,14},{25,0,1,5,0,9,-1,0,14},{0,1,1,22,10,9,-1,3,20},{0,0,1,25,10,9,-1,3,14},{0,2,1,18,10,9,-1,3,8},{0,0,1,25,10,9,-1,3,14},{0,1,1,22,10,9,-1,3,20}},
  {{0,2,1,18,10,9,-1,3,8},{0,0,1,21,10,9,-1,1,8},{0,1,1,22,10,9,-1,1,20},{0,2,1,18,10,9,-1,1,8},{0,0,1,21,10,9,-1,1,8},{0,0,1,21,10,9,-1,1,18},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,37},{22,0,1,7,0,9,-1,1,37},{22,0,1,7,0,9,-1,1,37},{22,0,1,7,0,9,-1,1,37},{22,0,1,7,0,9,-1,1,37},{22,0,1,7,0,9,-1,1,37},{22,0,1,7,0,9,-1,1,37},{22,0,1,7,0,9,-1,1,37},{22,0,1,7,0,9,-1,1,37}},
  {{0,0,1,6,0,9,-1,1,37},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2}},
  {{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2}},
  {{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2},{22,0,1,7,0,9,-1,1,2},{0,0,1,6,0,9,-1,1,18},{0,0,1,6,0,9,-1,1,18}},
  {{18,0,1,7,0,10,-1,1,2},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2}},
  {{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{103,0,0,2,0,12,-1,1,0}},
  {{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2}},
  {{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{18,0,1,7,0,9,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{0,0,1,23,4,9,-1,0,21},{0,0,1,23,4,9,-1,0,22},{0,0,1,25,10,9,-1,0,14},{0,0,1,24,10,9,-1,3,14},{0,0,1,26,10,9,-1,0,14},{0,0,1,23,4,9,-1,0,22},{0,0,1,23,4,9,-1,0,22},{103,0,0,2,0,12,-1,0,0},{0,0,1,26,10,9,-1,1,2},{0,0,1,25,10,9,-1,1,2},{0,0,1,25,10,9,-1,1,2},{0,0,1,25,10,9,-1,1,2},{0,0,1,25,10,9,-1,1,2},{0,0,1,26,10,9,-1,1,2},{0,0,1,26,10,9,-1,1,2},{103,0,0,2,0,12,-1,1,0}},
  {{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{0,0,0,1,10,8,-1,1,9},{0,0,0,1,10,8,-1,1,9},{0,0,0,1,10,8,-1,1,9},{0,0,0,26,10,8,-1,0,7},{0,0,0,26,10,8,-1,0,1},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2}},
  {{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2}},
  {{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2}},
  {{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{49,0,0,7,0,7,-1,1,2}},
  {{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{49,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{0,0,0,21,0,8,-1,1,4},{0,0,0,21,10,8,-1,1,4},{0,0,0,21,0,8,-1,1,4},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{0,0,0,15,0,8,-1,1,2},{0,0,0,15,0,8,-1,1,2},{0,0,0,15,0,8,-1,1,2},{0,0,0,15,0,8,-1,1,2},{0,0,0,15,0,8,-1,1,2},{0,0,0,15,0,8,-1,1,2},{0,0,0,15,0,8,-1,1,2},{0,0,0,15,0,8,-1,1,2},{0,0,0,15,0,8,-1,1,2}},
  {{0,0,0,15,0,8,-1,1,2},{0,0,0,15,0,8,-1,1,2},{0,0,0,15,0,8,-1,1,2},{0,0,0,15,0,8,-1,1,2},{0,0,0,15,0,8,-1,1,2},{0,0,0,15,0,8,-1,1,2},{0,0,0,15,0,8,-1,1,2},{0,0,0,15,0,8,-1,1,2},{0,0,0,15,0,8,-1,1,2},{0,0,0,15,0,8,-1,1,2},{0,0,0,15,0,8,-1,1,2},{0,0,0,15,0,8,-1,1,2},{0,0,0,15,0,8,-1,1,2},{0,0,0,15,0,8,-1,1,2},{0,0,0,15,0,8,-1,1,2},{0,0,0,15,0,8,-1,1,2}},
  {{0,0,0,15,0,8,-1,1,2},{0,0,0,15,0,8,-1,1,2},{0,0,0,15,0,8,-1,1,2},{0,0,0,15,0,8,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2}},
  {{14,0,0,14,10,4,-1,1,2},{14,0,0,14,10,4,-1,1,2},{14,0,0,14,10,4,-1,1,2},{14,0,0,14,10,4,-1,1,2},{14,0,0,14,10,4,-1,1,2},{14,0,0,14,10,4,-1,1,2},{14,0,0,14,10,4,-1,1,2},{14,0,0,14,10,4,-1,1,2},{14,0,0,14,10,4,-1,1,2},{14,0,0,14,10,4,-1,1,2},{14,0,0,14,10,4,-1,1,2},{14,0,0,14,10,4,-1,1,2},{14,0,0,14,10,4,-1,1,2},{14,0,0,14,10,4,-1,1,2},{14,0,0,14,10,4,-1,1,2},{14,0,0,14,10,4,-1,1,2}},
  {{14,0,0,14,10,4,-1,1,2},{14,0,0,14,10,4,-1,1,2},{14,0,0,14,10,4,-1,1,2},{14,0,0,14,10,4,-1,1,2},{14,0,0,14,10,4,-1,1,2},{14,0,0,15,10,8,-1,1,2},{14,0,0,15,10,8,-1,1,2},{14,0,0,15,10,8,-1,1,2},{14,0,0,15,10,8,-1,1,2},{14,0,0,26,10,8,-1,1,2},{14,0,0,26,10,8,-1,1,2},{14,0,0,26,10,8,-1,1,2},{14,0,0,26,10,8,-1,1,2},{14,0,0,26,10,8,-1,1,2},{14,0,0,26,10,8,-1,1,2},{14,0,0,26,10,8,-1,1,2}},
  {{14,0,0,26,10,8,-1,1,2},{14,0,0,26,10,8,-1,1,2},{14,0,0,26,10,8,-1,1,2},{14,0,0,26,10,8,-1,1,2},{14,0,0,26,10,8,-1,1,2},{14,0,0,26,10,8,-1,1,2},{14,0,0,26,10,8,-1,1,2},{14,0,0,26,10,8,-1,1,2},{14,0,0,26,10,8,-1,1,2},{14,0,0,26,10,8,-1,1,2},{14,0,0,15,10,8,-1,1,2},{14,0,0,15,10,8,-1,1,2},{14,0,0,26,10,8,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{14,0,0,26,10,8,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{0,0,0,26,0,8,-1,1,2},{1,0,0,12,17,7,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{107,0,0,7,0,7,-1,1,2},{107,0,0,7,0,7,-1,1,2},{107,0,0,7,0,7,-1,1,2},{107,0,0,7,0,7,-1,1,2},{107,0,0,7,0,7,-1,1,2},{107,0,0,7,0,7,-1,1,2},{107,0,0,7,0,7,-1,1,2},{107,0,0,7,0,7,-1,1,2},{107,0,0,7,0,7,-1,1,2},{107,0,0,7,0,7,-1,1,2},{107,0,0,7,0,7,-1,1,2},{107,0,0,7,0,7,-1,1,2},{107,0,0,7,0,7,-1,1,2},{107,0,0,7,0,7,-1,1,2},{107,0,0,7,0,7,-1,1,2},{107,0,0,7,0,7,-1,1,2}},
  {{107,0,0,7,0,7,-1,1,2},{107,0,0,7,0,7,-1,1,2},{107,0,0,7,0,7,-1,1,2},{107,0,0,7,0,7,-1,1,2},{107,0,0,7,0,7,-1,1,2},{107,0,0,7,0,7,-1,1,2},{107,0,0,7,0,7,-1,1,2},{107,0,0,7,0,7,-1,1,2},{107,0,0,7,0,7,-1,1,2},{107,0,0,7,0,7,-1,1,2},{107,0,0,7,0,7,-1,1,2},{107,0,0,7,0,7,-1,1,2},{107,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{104,0,0,7,0,7,-1,1,2},{104,0,0,7,0,7,-1,1,2},{104,0,0,7,0,7,-1,1,2},{104,0,0,7,0,7,-1,1,2},{104,0,0,7,0,7,-1,1,2},{104,0,0,7,0,7,-1,1,2},{104,0,0,7,0,7,-1,1,2},{104,0,0,7,0,7,-1,1,2},{104,0,0,7,0,7,-1,1,2},{104,0,0,7,0,7,-1,1,2},{104,0,0,7,0,7,-1,1,2},{104,0,0,7,0,7,-1,1,2},{104,0,0,7,0,7,-1,1,2},{104,0,0,7,0,7,-1,1,2},{104,0,0,7,0,7,-1,1,2},{104,0,0,7,0,7,-1,1,2}},
  {{104,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{1,0,0,12,17,4,-1,1,9},{0,0,0,15,2,8,-1,1,2},{0,0,0,15,2,8,-1,1,2},{0,0,0,15,2,8,-1,1,2},{0,0,0,15,2,8,-1,1,2},{0,0,0,15,2,8,-1,1,2},{0,0,0,15,2,8,-1,1,2},{0,0,0,15,2,8,-1,1,2},{0,0,0,15,2,8,-1,1,2},{0,0,0,15,2,8,-1,1,2},{0,0,0,15,2,8,-1,1,2},{0,0,0,15,2,8,-1,1,2},{0,0,0,15,2,8,-1,1,2},{0,0,0,15,2,8,-1,1,2},{0,0,0,15,2,8,-1,1,2},{0,0,0,15,2,8,-1,1,2}},
  {{0,0,0,15,2,8,-1,1,2},{0,0,0,15,2,8,-1,1,2},{0,0,0,15,2,8,-1,1,2},{0,0,0,15,2,8,-1,1,2},{0,0,0,15,2,8,-1,1,2},{0,0,0,15,2,8,-1,1,2},{0,0,0,15,2,8,-1,1,2},{0,0,0,15,2,8,-1,1,2},{0,0,0,15,2,8,-1,1,2},{0,0,0,15,2,8,-1,1,2},{0,0,0,15,2,8,-1,1,2},{0,0,0,15,2,8,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{30,0,0,7,0,7,-1,1,2},{30,0,0,7,0,7,-1,1,2},{30,0,0,7,0,7,-1,1,2},{30,0,0,7,0,7,-1,1,2},{30,0,0,7,0,7,-1,1,2},{30,0,0,7,0,7,-1,1,2},{30,0,0,7,0,7,-1,1,2},{30,0,0,7,0,7,-1,1,2},{30,0,0,7,0,7,-1,1,2},{30,0,0,7,0,7,-1,1,2},{30,0,0,7,0,7,-1,1,2},{30,0,0,7,0,7,-1,1,2},{30,0,0,7,0,7,-1,1,2},{30,0,0,7,0,7,-1,1,2},{30,0,0,7,0,7,-1,1,2},{30,0,0,7,0,7,-1,1,2}},
  {{30,0,0,15,0,8,-1,1,2},{30,0,0,15,0,8,-1,1,2},{30,0,0,15,0,8,-1,1,2},{30,0,0,15,0,8,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{13,0,0,7,0,7,-1,1,2},{13,0,0,7,0,7,-1,1,2},{13,0,0,7,0,7,-1,1,2},{13,0,0,7,0,7,-1,1,2},{13,0,0,7,0,7,-1,1,2},{13,0,0,7,0,7,-1,1,2},{13,0,0,7,0,7,-1,1,2},{13,0,0,7,0,7,-1,1,2},{13,0,0,7,0,7,-1,1,2},{13,0,0,7,0,7,-1,1,2},{13,0,0,7,0,7,-1,1,2},{13,0,0,7,0,7,-1,1,2},{13,0,0,7,0,7,-1,1,2},{13,0,0,7,0,7,-1,1,2},{13,0,0,7,0,7,-1,1,2},{13,0,0,7,0,7,-1,1,2}},
  {{13,0,0,7,0,7,-1,1,2},{13,0,0,14,0,7,-1,1,2},{13,0,0,7,0,7,-1,1,2},{13,0,0,7,0,7,-1,1,2},{13,0,0,7,0,7,-1,1,2},{13,0,0,7,0,7,-1,1,2},{13,0,0,7,0,7,-1,1,2},{13,0,0,7,0,7,-1,1,2},{13,0,0,7,0,7,-1,1,2},{13,0,0,7,0,7,-1,1,2},{13,0,0,14,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{89,0,0,7,0,7,-1,1,2},{89,0,0,7,0,7,-1,1,2},{89,0,0,7,0,7,-1,1,2},{89,0,0,7,0,7,-1,1,2},{89,0,0,7,0,7,-1,1,2},{89,0,0,7,0,7,-1,1,2},{89,0,0,7,0,7,-1,1,2},{89,0,0,7,0,7,-1,1,2},{89,0,0,7,0,7,-1,1,2},{89,0,0,7,0,7,-1,1,2},{89,0,0,7,0,7,-1,1,2},{89,0,0,7,0,7,-1,1,2},{89,0,0,7,0,7,-1,1,2},{89,0,0,7,0,7,-1,1,2},{89,0,0,7,0,7,-1,1,2},{89,0,0,7,0,7,-1,1,2}},
  {{89,0,0,7,0,7,-1,1,2},{89,0,0,7,0,7,-1,1,2},{89,0,0,7,0,7,-1,1,2},{89,0,0,7,0,7,-1,1,2},{89,0,0,7,0,7,-1,1,2},{89,0,0,7,0,7,-1,1,2},{89,0,0,12,17,7,-1,1,9},{89,0,0,12,17,7,-1,1,9},{89,0,0,12,17,7,-1,1,9},{89,0,0,12,17,7,-1,1,9},{89,0,0,12,17,7,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{53,0,0,7,0,7,-1,1,2},{53,0,0,7,0,7,-1,1,2},{53,0,0,7,0,7,-1,1,2},{53,0,0,7,0,7,-1,1,2},{53,0,0,7,0,7,-1,1,2},{53,0,0,7,0,7,-1,1,2},{53,0,0,7,0,7,-1,1,2},{53,0,0,7,0,7,-1,1,2},{53,0,0,7,0,7,-1,1,2},{53,0,0,7,0,7,-1,1,2},{53,0,0,7,0,7,-1,1,2},{53,0,0,7,0,7,-1,1,2},{53,0,0,7,0,7,-1,1,2},{53,0,0,7,0,7,-1,1,2},{53,0,0,7,0,7,-1,1,2},{53,0,0,7,0,7,-1,1,2}},
  {{53,0,0,7,0,7,-1,1,2},{53,0,0,7,0,7,-1,1,2},{53,0,0,7,0,7,-1,1,2},{53,0,0,7,0,7,-1,1,2},{53,0,0,7,0,7,-1,1,2},{53,0,0,7,0,7,-1,1,2},{53,0,0,7,0,7,-1,1,2},{53,0,0,7,0,7,-1,1,2},{53,0,0,7,0,7,-1,1,2},{53,0,0,7,0,7,-1,1,2},{53,0,0,7,0,7,-1,1,2},{53,0,0,7,0,7,-1,1,2},{53,0,0,7,0,7,-1,1,2},{53,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{53,0,0,21,0,8,-1,1,4}},
  {{61,0,0,7,0,7,-1,1,2},{61,0,0,7,0,7,-1,1,2},{61,0,0,7,0,7,-1,1,2},{61,0,0,7,0,7,-1,1,2},{61,0,0,7,0,7,-1,1,2},{61,0,0,7,0,7,-1,1,2},{61,0,0,7,0,7,-1,1,2},{61,0,0,7,0,7,-1,1,2},{61,0,0,7,0,7,-1,1,2},{61,0,0,7,0,7,-1,1,2},{61,0,0,7,0,7,-1,1,2},{61,0,0,7,0,7,-1,1,2},{61,0,0,7,0,7,-1,1,2},{61,0,0,7,0,7,-1,1,2},{61,0,0,7,0,7,-1,1,2},{61,0,0,7,0,7,-1,1,2}},
  {{61,0,0,7,0,7,-1,1,2},{61,0,0,7,0,7,-1,1,2},{61,0,0,7,0,7,-1,1,2},{61,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{61,0,0,7,0,7,-1,1,2},{61,0,0,7,0,7,-1,1,2},{61,0,0,7,0,7,-1,1,2},{61,0,0,7,0,7,-1,1,2},{61,0,0,7,0,7,-1,1,2},{61,0,0,7,0,7,-1,1,2},{61,0,0,7,0,7,-1,1,2},{61,0,0,7,0,7,-1,1,2}},
  {{61,0,0,21,0,8,-1,1,4},{61,0,0,14,0,7,-1,1,2},{61,0,0,14,0,7,-1,1,2},{61,0,0,14,0,7,-1,1,2},{61,0,0,14,0,7,-1,1,2},{61,0,0,14,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{9,0,0,9,0,7,-1,1,2},{9,0,0,9,0,7,-1,1,2},{9,0,0,9,0,7,-1,1,2},{9,0,0,9,0,7,-1,1,2},{9,0,0,9,0,7,-1,1,2},{9,0,0,9,0,7,-1,1,2},{9,0,0,9,0,7,-1,1,2},{9,0,0,9,0,7,-1,1,2},{9,0,0,9,0,7,-1,1,2},{9,0,0,9,0,7,-1,1,2},{9,0,0,9,0,7,-1,1,2},{9,0,0,9,0,7,-1,1,2},{9,0,0,9,0,7,-1,1,2},{9,0,0,9,0,7,-1,1,2},{9,0,0,9,0,7,-1,1,2},{9,0,0,9,0,7,-1,1,2}},
  {{9,0,0,9,0,7,-1,1,2},{9,0,0,9,0,7,-1,1,2},{9,0,0,9,0,7,-1,1,2},{9,0,0,9,0,7,-1,1,2},{9,0,0,9,0,7,-1,1,2},{9,0,0,9,0,7,-1,1,2},{9,0,0,9,0,7,-1,1,2},{9,0,0,9,0,7,-1,1,2},{9,0,0,5,0,7,-1,1,2},{9,0,0,5,0,7,-1,1,2},{9,0,0,5,0,7,-1,1,2},{9,0,0,5,0,7,-1,1,2},{9,0,0,5,0,7,-1,1,2},{9,0,0,5,0,7,-1,1,2},{9,0,0,5,0,7,-1,1,2},{9,0,0,5,0,7,-1,1,2}},
  {{9,0,0,5,0,7,-1,1,2},{9,0,0,5,0,7,-1,1,2},{9,0,0,5,0,7,-1,1,2},{9,0,0,5,0,7,-1,1,2},{9,0,0,5,0,7,-1,1,2},{9,0,0,5,0,7,-1,1,2},{9,0,0,5,0,7,-1,1,2},{9,0,0,5,0,7,-1,1,2},{9,0,0,5,0,7,-1,1,2},{9,0,0,5,0,7,-1,1,2},{9,0,0,5,0,7,-1,1,2},{9,0,0,5,0,7,-1,1,2},{9,0,0,5,0,7,-1,1,2},{9,0,0,5,0,7,-1,1,2},{9,0,0,5,0,7,-1,1,2},{9,0,0,5,0,7,-1,1,2}},
  {{51,0,0,7,0,7,-1,1,2},{51,0,0,7,0,7,-1,1,2},{51,0,0,7,0,7,-1,1,2},{51,0,0,7,0,7,-1,1,2},{51,0,0,7,0,7,-1,1,2},{51,0,0,7,0,7,-1,1,2},{51,0,0,7,0,7,-1,1,2},{51,0,0,7,0,7,-1,1,2},{51,0,0,7,0,7,-1,1,2},{51,0,0,7,0,7,-1,1,2},{51,0,0,7,0,7,-1,1,2},{51,0,0,7,0,7,-1,1,2},{51,0,0,7,0,7,-1,1,2},{51,0,0,7,0,7,-1,1,2},{51,0,0,7,0,7,-1,1,2},{51,0,0,7,0,7,-1,1,2}},
  {{50,0,0,7,0,7,-1,1,2},{50,0,0,7,0,7,-1,1,2},{50,0,0,7,0,7,-1,1,2},{50,0,0,7,0,7,-1,1,2},{50,0,0,7,0,7,-1,1,2},{50,0,0,7,0,7,-1,1,2},{50,0,0,7,0,7,-1,1,2},{50,0,0,7,0,7,-1,1,2},{50,0,0,7,0,7,-1,1,2},{50,0,0,7,0,7,-1,1,2},{50,0,0,7,0,7,-1,1,2},{50,0,0,7,0,7,-1,1,2},{50,0,0,7,0,7,-1,1,2},{50,0,0,7,0,7,-1,1,2},{50,0,0,7,0,7,-1,1,2},{50,0,0,7,0,7,-1,1,2}},
  {{50,0,0,7,0,7,-1,1,2},{50,0,0,7,0,7,-1,1,2},{50,0,0,7,0,7,-1,1,2},{50,0,0,7,0,7,-1,1,2},{50,0,0,7,0,7,-1,1,2},{50,0,0,7,0,7,-1,1,2},{50,0,0,7,0,7,-1,1,2},{50,0,0,7,0,7,-1,1,2},{50,0,0,7,0,7,-1,1,2},{50,0,0,7,0,7,-1,1,2},{50,0,0,7,0,7,-1,1,2},{50,0,0,7,0,7,-1,1,2},{50,0,0,7,0,7,-1,1,2},{50,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{50,0,0,13,0,7,0,1,19},{50,0,0,13,0,7,1,1,19},{50,0,0,13,0,7,2,1,19},{50,0,0,13,0,7,3,1,19},{50,0,0,13,0,7,4,1,19},{50,0,0,13,0,7,5,1,19},{50,0,0,13,0,7,6,1,19},{50,0,0,13,0,7,7,1,19},{50,0,0,13,0,7,8,1,19},{50,0,0,13,0,7,9,1,19},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{136,0,0,7,0,7,-1,1,2},{136,0,0,7,0,7,-1,1,2},{136,0,0,7,0,7,-1,1,2},{136,0,0,7,0,7,-1,1,2},{136,0,0,7,0,7,-1,1,2},{136,0,0,7,0,7,-1,1,2},{136,0,0,7,0,7,-1,1,2},{136,0,0,7,0,7,-1,1,2},{136,0,0,7,0,7,-1,1,2},{136,0,0,7,0,7,-1,1,2},{136,0,0,7,0,7,-1,1,2},{136,0,0,7,0,7,-1,1,2},{136,0,0,7,0,7,-1,1,2},{136,0,0,7,0,7,-1,1,2},{136,0,0,7,0,7,-1,1,2},{136,0,0,7,0,7,-1,1,2}},
  {{136,0,0,7,0,7,-1,1,2},{136,0,0,7,0,7,-1,1,2},{136,0,0,7,0,7,-1,1,2},{136,0,0,7,0,7,-1,1,2},{136,0,0,7,0,7,-1,1,2},{136,0,0,7,0,7,-1,1,2},{136,0,0,7,0,7,-1,1,2},{136,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{159,0,0,7,0,7,-1,1,2},{159,0,0,7,0,7,-1,1,2},{159,0,0,7,0,7,-1,1,2},{159,0,0,7,0,7,-1,1,2},{159,0,0,7,0,7,-1,1,2},{159,0,0,7,0,7,-1,1,2},{159,0,0,7,0,7,-1,1,2},{159,0,0,7,0,7,-1,1,2},{159,0,0,7,0,7,-1,1,2},{159,0,0,7,0,7,-1,1,2},{159,0,0,7,0,7,-1,1,2},{159,0,0,7,0,7,-1,1,2},{159,0,0,7,0,7,-1,1,2},{159,0,0,7,0,7,-1,1,2},{159,0,0,7,0,7,-1,1,2},{159,0,0,7,0,7,-1,1,2}},
  {{159,0,0,7,0,7,-1,1,2},{159,0,0,7,0,7,-1,1,2},{159,0,0,7,0,7,-1,1,2},{159,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{159,0,0,21,0,8,-1,1,2}},
  {{83,0,0,7,0,7,-1,1,2},{83,0,0,7,0,7,-1,1,2},{83,0,0,7,0,7,-1,1,2},{83,0,0,7,0,7,-1,1,2},{83,0,0,7,0,7,-1,1,2},{83,0,0,7,0,7,-1,1,2},{83,0,0,7,0,7,-1,1,2},{83,0,0,7,0,7,-1,1,2},{83,0,0,7,0,7,-1,1,2},{83,0,0,7,0,7,-1,1,2},{83,0,0,7,0,7,-1,1,2},{83,0,0,7,0,7,-1,1,2},{83,0,0,7,0,7,-1,1,2},{83,0,0,7,0,7,-1,1,2},{83,0,0,7,0,7,-1,1,2},{83,0,0,7,0,7,-1,1,2}},
  {{83,0,0,7,0,7,-1,1,2},{83,0,0,7,0,7,-1,1,2},{83,0,0,7,0,7,-1,1,2},{83,0,0,7,0,7,-1,1,2},{83,0,0,7,0,7,-1,1,2},{83,0,0,7,0,7,-1,1,2},{83,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{83,0,0,7,0,7,-1,1,2},{83,0,0,7,0,7,-1,1,2},{83,0,0,7,0,7,-1,1,2},{83,0,0,7,0,7,-1,1,2},{83,0,0,7,0,7,-1,1,2},{83,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{83,0,0,7,0,7,-1,1,2},{83,0,0,7,0,7,-1,1,2},{83,0,0,7,0,7,-1,1,2},{83,0,0,7,0,7,-1,1,2},{83,0,0,7,0,7,-1,1,2},{83,0,0,7,0,7,-1,1,2},{83,0,0,7,0,7,-1,1,2},{83,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{47,0,0,7,1,7,-1,1,2},{47,0,0,7,1,7,-1,1,2},{47,0,0,7,1,7,-1,1,2},{47,0,0,7,1,7,-1,1,2},{47,0,0,7,1,7,-1,1,2},{47,0,0,7,1,7,-1,1,2},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{47,0,0,7,1,7,-1,1,2},{103,0,0,2,1,12,-1,1,0},{47,0,0,7,1,7,-1,1,2},{47,0,0,7,1,7,-1,1,2},{47,0,0,7,1,7,-1,1,2},{47,0,0,7,1,7,-1,1,2},{47,0,0,7,1,7,-1,1,2},{47,0,0,7,1,7,-1,1,2}},
  {{47,0,0,7,1,7,-1,1,2},{47,0,0,7,1,7,-1,1,2},{47,0,0,7,1,7,-1,1,2},{47,0,0,7,1,7,-1,1,2},{47,0,0,7,1,7,-1,1,2},{47,0,0,7,1,7,-1,1,2},{47,0,0,7,1,7,-1,1,2},{47,0,0,7,1,7,-1,1,2},{47,0,0,7,1,7,-1,1,2},{47,0,0,7,1,7,-1,1,2},{47,0,0,7,1,7,-1,1,2},{47,0,0,7,1,7,-1,1,2},{47,0,0,7,1,7,-1,1,2},{47,0,0,7,1,7,-1,1,2},{47,0,0,7,1,7,-1,1,2},{47,0,0,7,1,7,-1,1,2}},
  {{47,0,0,7,1,7,-1,1,2},{47,0,0,7,1,7,-1,1,2},{47,0,0,7,1,7,-1,1,2},{47,0,0,7,1,7,-1,1,2},{47,0,0,7,1,7,-1,1,2},{47,0,0,7,1,7,-1,1,2},{103,0,0,2,1,12,-1,1,0},{47,0,0,7,1,7,-1,1,2},{47,0,0,7,1,7,-1,1,2},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{47,0,0,7,1,7,-1,1,2},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{47,0,0,7,1,7,-1,1,2}},
  {{116,0,0,7,1,7,-1,1,2},{116,0,0,7,1,7,-1,1,2},{116,0,0,7,1,7,-1,1,2},{116,0,0,7,1,7,-1,1,2},{116,0,0,7,1,7,-1,1,2},{116,0,0,7,1,7,-1,1,2},{116,0,0,7,1,7,-1,1,2},{116,0,0,7,1,7,-1,1,2},{116,0,0,7,1,7,-1,1,2},{116,0,0,7,1,7,-1,1,2},{116,0,0,7,1,7,-1,1,2},{116,0,0,7,1,7,-1,1,2},{116,0,0,7,1,7,-1,1,2},{116,0,0,7,1,7,-1,1,2},{116,0,0,7,1,7,-1,1,2},{116,0,0,7,1,7,-1,1,2}},
  {{116,0,0,7,1,7,-1,1,2},{116,0,0,7,1,7,-1,1,2},{116,0,0,7,1,7,-1,1,2},{116,0,0,7,1,7,-1,1,2},{116,0,0,7,1,7,-1,1,2},{116,0,0,7,1,7,-1,1,2},{103,0,0,2,1,12,-1,1,0},{116,0,0,21,1,8,-1,1,4},{116,0,0,15,1,8,-1,1,2},{116,0,0,15,1,8,-1,1,2},{116,0,0,15,1,8,-1,1,2},{116,0,0,15,1,8,-1,1,2},{116,0,0,15,1,8,-1,1,2},{116,0,0,15,1,8,-1,1,2},{116,0,0,15,1,8,-1,1,2},{116,0,0,15,1,8,-1,1,2}},
  {{144,0,0,7,1,7,-1,1,2},{144,0,0,7,1,7,-1,1,2},{144,0,0,7,1,7,-1,1,2},{144,0,0,7,1,7,-1,1,2},{144,0,0,7,1,7,-1,1,2},{144,0,0,7,1,7,-1,1,2},{144,0,0,7,1,7,-1,1,2},{144,0,0,7,1,7,-1,1,2},{144,0,0,7,1,7,-1,1,2},{144,0,0,7,1,7,-1,1,2},{144,0,0,7,1,7,-1,1,2},{144,0,0,7,1,7,-1,1,2},{144,0,0,7,1,7,-1,1,2},{144,0,0,7,1,7,-1,1,2},{144,0,0,7,1,7,-1,1,2},{144,0,0,7,1,7,-1,1,2}},
  {{144,0,0,7,1,7,-1,1,2},{144,0,0,7,1,7,-1,1,2},{144,0,0,7,1,7,-1,1,2},{144,0,0,7,1,7,-1,1,2},{144,0,0,7,1,7,-1,1,2},{144,0,0,7,1,7,-1,1,2},{144,0,0,7,1,7,-1,1,2},{144,0,0,26,1,8,-1,1,2},{144,0,0,26,1,8,-1,1,2},{144,0,0,15,1,8,-1,1,2},{144,0,0,15,1,8,-1,1,2},{144,0,0,15,1,8,-1,1,2},{144,0,0,15,1,8,-1,1,2},{144,0,0,15,1,8,-1,1,2},{144,0,0,15,1,8,-1,1,2},{144,0,0,15,1,8,-1,1,2}},
  {{143,0,0,7,1,7,-1,1,2},{143,0,0,7,1,7,-1,1,2},{143,0,0,7,1,7,-1,1,2},{143,0,0,7,1,7,-1,1,2},{143,0,0,7,1,7,-1,1,2},{143,0,0,7,1,7,-1,1,2},{143,0,0,7,1,7,-1,1,2},{143,0,0,7,1,7,-1,1,2},{143,0,0,7,1,7,-1,1,2},{143,0,0,7,1,7,-1,1,2},{143,0,0,7,1,7,-1,1,2},{143,0,0,7,1,7,-1,1,2},{143,0,0,7,1,7,-1,1,2},{143,0,0,7,1,7,-1,1,2},{143,0,0,7,1,7,-1,1,2},{143,0,0,7,1,7,-1,1,2}},
  {{143,0,0,7,1,7,-1,1,2},{143,0,0,7,1,7,-1,1,2},{143,0,0,7,1,7,-1,1,2},{143,0,0,7,1,7,-1,1,2},{143,0,0,7,1,7,-1,1,2},{143,0,0,7,1,7,-1,1,2},{143,0,0,7,1,7,-1,1,2},{143,0,0,7,1,7,-1,1,2},{143,0,0,7,1,7,-1,1,2},{143,0,0,7,1,7,-1,1,2},{143,0,0,7,1,7,-1,1,2},{143,0,0,7,1,7,-1,1,2},{143,0,0,7,1,7,-1,1,2},{143,0,0,7,1,7,-1,1,2},{143,0,0,7,1,7,-1,1,2},{103,0,0,2,1,12,-1,1,0}},
  {{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{143,0,0,15,1,8,-1,1,2},{143,0,0,15,1,8,-1,1,2},{143,0,0,15,1,8,-1,1,2},{143,0,0,15,1,8,-1,1,2},{143,0,0,15,1,8,-1,1,2},{143,0,0,15,1,8,-1,1,2},{143,0,0,15,1,8,-1,1,2},{143,0,0,15,1,8,-1,1,2},{143,0,0,15,1,8,-1,1,2}},
  {{162,0,0,7,1,7,-1,1,2},{162,0,0,7,1,7,-1,1,2},{162,0,0,7,1,7,-1,1,2},{162,0,0,7,1,7,-1,1,2},{162,0,0,7,1,7,-1,1,2},{162,0,0,7,1,7,-1,1,2},{162,0,0,7,1,7,-1,1,2},{162,0,0,7,1,7,-1,1,2},{162,0,0,7,1,7,-1,1,2},{162,0,0,7,1,7,-1,1,2},{162,0,0,7,1,7,-1,1,2},{162,0,0,7,1,7,-1,1,2},{162,0,0,7,1,7,-1,1,2},{162,0,0,7,1,7,-1,1,2},{162,0,0,7,1,7,-1,1,2},{162,0,0,7,1,7,-1,1,2}},
  {{162,0,0,7,1,7,-1,1,2},{162,0,0,7,1,7,-1,1,2},{162,0,0,7,1,7,-1,1,2},{103,0,0,2,1,12,-1,1,0},{162,0,0,7,1,7,-1,1,2},{162,0,0,7,1,7,-1,1,2},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{162,0,0,15,1,8,-1,1,2},{162,0,0,15,1,8,-1,1,2},{162,0,0,15,1,8,-1,1,2},{162,0,0,15,1,8,-1,1,2},{162,0,0,15,1,8,-1,1,2}},
  {{91,0,0,7,1,7,-1,1,2},{91,0,0,7,1,7,-1,1,2},{91,0,0,7,1,7,-1,1,2},{91,0,0,7,1,7,-1,1,2},{91,0,0,7,1,7,-1,1,2},{91,0,0,7,1,7,-1,1,2},{91,0,0,7,1,7,-1,1,2},{91,0,0,7,1,7,-1,1,2},{91,0,0,7,1,7,-1,1,2},{91,0,0,7,1,7,-1,1,2},{91,0,0,7,1,7,-1,1,2},{91,0,0,7,1,7,-1,1,2},{91,0,0,7,1,7,-1,1,2},{91,0,0,7,1,7,-1,1,2},{91,0,0,7,1,7,-1,1,2},{91,0,0,7,1,7,-1,1,2}},
  {{91,0,0,7,1,7,-1,1,2},{91,0,0,7,1,7,-1,1,2},{91,0,0,7,1,7,-1,1,2},{91,0,0,7,1,7,-1,1,2},{91,0,0,7,1,7,-1,1,2},{91,0,0,7,1,7,-1,1,2},{91,0,0,15,1,8,-1,1,2},{91,0,0,15,1,8,-1,1,2},{91,0,0,15,1,8,-1,1,2},{91,0,0,15,1,8,-1,1,2},{91,0,0,15,1,8,-1,1,2},{91,0,0,15,1,8,-1,1,2},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{91,0,0,21,10,8,-1,1,4}},
  {{108,0,0,7,1,7,-1,1,2},{108,0,0,7,1,7,-1,1,2},{108,0,0,7,1,7,-1,1,2},{108,0,0,7,1,7,-1,1,2},{108,0,0,7,1,7,-1,1,2},{108,0,0,7,1,7,-1,1,2},{108,0,0,7,1,7,-1,1,2},{108,0,0,7,1,7,-1,1,2},{108,0,0,7,1,7,-1,1,2},{108,0,0,7,1,7,-1,1,2},{108,0,0,7,1,7,-1,1,2},{108,0,0,7,1,7,-1,1,2},{108,0,0,7,1,7,-1,1,2},{108,0,0,7,1,7,-1,1,2},{108,0,0,7,1,7,-1,1,2},{108,0,0,7,1,7,-1,1,2}},
  {{108,0,0,7,1,7,-1,1,2},{108,0,0,7,1,7,-1,1,2},{108,0,0,7,1,7,-1,1,2},{108,0,0,7,1,7,-1,1,2},{108,0,0,7,1,7,-1,1,2},{108,0,0,7,1,7,-1,1,2},{108,0,0,7,1,7,-1,1,2},{108,0,0,7,1,7,-1,1,2},{108,0,0,7,1,7,-1,1,2},{108,0,0,7,1,7,-1,1,2},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{108,0,0,21,1,8,-1,1,2}},
  {{86,0,0,7,1,7,-1,0,2},{86,0,0,7,1,7,-1,0,2},{86,0,0,7,1,7,-1,0,2},{86,0,0,7,1,7,-1,0,2},{86,0,0,7,1,7,-1,0,2},{86,0,0,7,1,7,-1,0,2},{86,0,0,7,1,7,-1,0,2},{86,0,0,7,1,7,-1,0,2},{86,0,0,7,1,7,-1,0,2},{86,0,0,7,1,7,-1,0,2},{86,0,0,7,1,7,-1,0,2},{86,0,0,7,1,7,-1,0,2},{86,0,0,7,1,7,-1,0,2},{86,0,0,7,1,7,-1,0,2},{86,0,0,7,1,7,-1,0,2},{86,0,0,7,1,7,-1,0,2}},
  {{141,0,0,7,1,7,-1,1,2},{141,0,0,7,1,7,-1,1,2},{141,0,0,7,1,7,-1,1,2},{141,0,0,7,1,7,-1,1,2},{141,0,0,7,1,7,-1,1,2},{141,0,0,7,1,7,-1,1,2},{141,0,0,7,1,7,-1,1,2},{141,0,0,7,1,7,-1,1,2},{141,0,0,7,1,7,-1,1,2},{141,0,0,7,1,7,-1,1,2},{141,0,0,7,1,7,-1,1,2},{141,0,0,7,1,7,-1,1,2},{141,0,0,7,1,7,-1,1,2},{141,0,0,7,1,7,-1,1,2},{141,0,0,7,1,7,-1,1,2},{141,0,0,7,1,7,-1,1,2}},
  {{141,0,0,7,1,7,-1,1,2},{141,0,0,7,1,7,-1,1,2},{141,0,0,7,1,7,-1,1,2},{141,0,0,7,1,7,-1,1,2},{141,0,0,7,1,7,-1,1,2},{141,0,0,7,1,7,-1,1,2},{141,0,0,7,1,7,-1,1,2},{141,0,0,7,1,7,-1,1,2},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{141,0,0,15,1,8,-1,1,2},{141,0,0,15,1,8,-1,1,2},{141,0,0,7,1,7,-1,1,2},{141,0,0,7,1,7,-1,1,2}},
  {{141,0,0,15,1,8,-1,1,2},{141,0,0,15,1,8,-1,1,2},{141,0,0,15,1,8,-1,1,2},{141,0,0,15,1,8,-1,1,2},{141,0,0,15,1,8,-1,1,2},{141,0,0,15,1,8,-1,1,2},{141,0,0,15,1,8,-1,1,2},{141,0,0,15,1,8,-1,1,2},{141,0,0,15,1,8,-1,1,2},{141,0,0,15,1,8,-1,1,2},{141,0,0,15,1,8,-1,1,2},{141,0,0,15,1,8,-1,1,2},{141,0,0,15,1,8,-1,1,2},{141,0,0,15,1,8,-1,1,2},{141,0,0,15,1,8,-1,1,2},{141,0,0,15,1,8,-1,1,2}},
  {{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{141,0,0,15,1,8,-1,1,2},{141,0,0,15,1,8,-1,1,2},{141,0,0,15,1,8,-1,1,2},{141,0,0,15,1,8,-1,1,2},{141,0,0,15,1,8,-1,1,2},{141,0,0,15,1,8,-1,1,2},{141,0,0,15,1,8,-1,1,2},{141,0,0,15,1,8,-1,1,2},{141,0,0,15,1,8,-1,1,2},{141,0,0,15,1,8,-1,1,2},{141,0,0,15,1,8,-1,1,2},{141,0,0,15,1,8,-1,1,2},{141,0,0,15,1,8,-1,1,2},{141,0,0,15,1,8,-1,1,2}},
  {{57,0,0,7,1,7,-1,1,2},{57,0,0,12,17,7,-1,1,9},{57,0,0,12,17,7,-1,1,9},{57,0,0,12,17,7,-1,1,9},{103,0,0,2,1,12,-1,1,0},{57,0,0,12,17,7,-1,1,9},{57,0,0,12,17,7,-1,1,9},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{57,0,0,12,17,7,-1,1,9},{57,0,0,12,17,7,-1,1,9},{57,0,0,12,17,7,-1,1,9},{57,0,0,12,17,7,-1,1,9}},
  {{57,0,0,7,1,7,-1,1,2},{57,0,0,7,1,7,-1,1,2},{57,0,0,7,1,7,-1,1,2},{57,0,0,7,1,7,-1,1,2},{103,0,0,2,1,12,-1,1,0},{57,0,0,7,1,7,-1,1,2},{57,0,0,7,1,7,-1,1,2},{57,0,0,7,1,7,-1,1,2},{103,0,0,2,1,12,-1,1,0},{57,0,0,7,1,7,-1,1,2},{57,0,0,7,1,7,-1,1,2},{57,0,0,7,1,7,-1,1,2},{57,0,0,7,1,7,-1,1,2},{57,0,0,7,1,7,-1,1,2},{57,0,0,7,1,7,-1,1,2},{57,0,0,7,1,7,-1,1,2}},
  {{57,0,0,7,1,7,-1,1,2},{57,0,0,7,1,7,-1,1,2},{57,0,0,7,1,7,-1,1,2},{57,0,0,7,1,7,-1,1,2},{57,0,0,7,1,7,-1,1,2},{57,0,0,7,1,7,-1,1,2},{57,0,0,7,1,7,-1,1,2},{57,0,0,7,1,7,-1,1,2},{57,0,0,7,1,7,-1,1,2},{57,0,0,7,1,7,-1,1,2},{57,0,0,7,1,7,-1,1,2},{57,0,0,7,1,7,-1,1,2},{57,0,0,7,1,7,-1,1,2},{57,0,0,7,1,7,-1,1,2},{57,0,0,7,1,7,-1,1,2},{57,0,0,7,1,7,-1,1,2}},
  {{57,0,0,7,1,7,-1,1,2},{57,0,0,7,1,7,-1,1,2},{57,0,0,7,1,7,-1,1,2},{57,0,0,7,1,7,-1,1,2},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{57,0,0,12,17,7,-1,1,9},{57,0,0,12,17,7,-1,1,9},{57,0,0,12,17,7,-1,1,9},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{57,0,0,12,17,7,-1,1,9}},
  {{57,0,0,15,1,8,1,1,2},{57,0,0,15,1,8,2,1,2},{57,0,0,15,1,8,3,1,2},{57,0,0,15,1,8,4,1,2},{57,0,0,15,1,8,-1,1,2},{57,0,0,15,1,8,-1,1,2},{57,0,0,15,1,8,-1,1,2},{57,0,0,15,1,8,-1,1,2},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0}},
  {{57,0,0,21,1,8,-1,1,4},{57,0,0,21,1,8,-1,1,4},{57,0,0,21,1,8,-1,1,4},{57,0,0,21,1,8,-1,1,4},{57,0,0,21,1,8,-1,1,4},{57,0,0,21,1,8,-1,1,4},{57,0,0,21,1,8,-1,1,4},{57,0,0,21,1,8,-1,1,4},{57,0,0,21,1,8,-1,1,2},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0}},
  {{133,0,0,7,1,7,-1,1,2},{133,0,0,7,1,7,-1,1,2},{133,0,0,7,1,7,-1,1,2},{133,0,0,7,1,7,-1,1,2},{133,0,0,7,1,7,-1,1,2},{133,0,0,7,1,7,-1,1,2},{133,0,0,7,1,7,-1,1,2},{133,0,0,7,1,7,-1,1,2},{133,0,0,7,1,7,-1,1,2},{133,0,0,7,1,7,-1,1,2},{133,0,0,7,1,7,-1,1,2},{133,0,0,7,1,7,-1,1,2},{133,0,0,7,1,7,-1,1,2},{133,0,0,7,1,7,-1,1,2},{133,0,0,7,1,7,-1,1,2},{133,0,0,7,1,7,-1,1,2}},
  {{133,0,0,7,1,7,-1,1,2},{133,0,0,7,1,7,-1,1,2},{133,0,0,7,1,7,-1,1,2},{133,0,0,7,1,7,-1,1,2},{133,0,0,7,1,7,-1,1,2},{133,0,0,7,1,7,-1,1,2},{133,0,0,7,1,7,-1,1,2},{133,0,0,7,1,7,-1,1,2},{133,0,0,7,1,7,-1,1,2},{133,0,0,7,1,7,-1,1,2},{133,0,0,7,1,7,-1,1,2},{133,0,0,7,1,7,-1,1,2},{133,0,0,7,1,7,-1,1,2},{133,0,0,15,1,8,-1,1,2},{133,0,0,15,1,8,-1,1,2},{133,0,0,21,1,8,-1,1,2}},
  {{142,0,0,7,1,7,-1,1,2},{142,0,0,7,1,7,-1,1,2},{142,0,0,7,1,7,-1,1,2},{142,0,0,7,1,7,-1,1,2},{142,0,0,7,1,7,-1,1,2},{142,0,0,7,1,7,-1,1,2},{142,0,0,7,1,7,-1,1,2},{142,0,0,7,1,7,-1,1,2},{142,0,0,7,1,7,-1,1,2},{142,0,0,7,1,7,-1,1,2},{142,0,0,7,1,7,-1,1,2},{142,0,0,7,1,7,-1,1,2},{142,0,0,7,1,7,-1,1,2},{142,0,0,7,1,7,-1,1,2},{142,0,0,7,1,7,-1,1,2},{142,0,0,7,1,7,-1,1,2}},
  {{142,0,0,7,1,7,-1,1,2},{142,0,0,7,1,7,-1,1,2},{142,0,0,7,1,7,-1,1,2},{142,0,0,7,1,7,-1,1,2},{142,0,0,7,1,7,-1,1,2},{142,0,0,7,1,7,-1,1,2},{142,0,0,7,1,7,-1,1,2},{142,0,0,7,1,7,-1,1,2},{142,0,0,7,1,7,-1,1,2},{142,0,0,7,1,7,-1,1,2},{142,0,0,7,1,7,-1,1,2},{142,0,0,7,1,7,-1,1,2},{142,0,0,7,1,7,-1,1,2},{142,0,0,15,1,8,-1,1,2},{142,0,0,15,1,8,-1,1,2},{142,0,0,15,1,8,-1,1,2}},
  {{121,0,0,7,1,7,-1,1,2},{121,0,0,7,1,7,-1,1,2},{121,0,0,7,1,7,-1,1,2},{121,0,0,7,1,7,-1,1,2},{121,0,0,7,1,7,-1,1,2},{121,0,0,7,1,7,-1,1,2},{121,0,0,7,1,7,-1,1,2},{121,0,0,7,1,7,-1,1,2},{121,0,0,26,1,8,-1,1,2},{121,0,0,7,1,7,-1,1,2},{121,0,0,7,1,7,-1,1,2},{121,0,0,7,1,7,-1,1,2},{121,0,0,7,1,7,-1,1,2},{121,0,0,7,1,7,-1,1,2},{121,0,0,7,1,7,-1,1,2},{121,0,0,7,1,7,-1,1,2}},
  {{121,0,0,7,1,7,-1,1,2},{121,0,0,7,1,7,-1,1,2},{121,0,0,7,1,7,-1,1,2},{121,0,0,7,1,7,-1,1,2},{121,0,0,7,1,7,-1,1,2},{121,0,0,7,1,7,-1,1,2},{121,0,0,7,1,7,-1,1,2},{121,0,0,7,1,7,-1,1,2},{121,0,0,7,1,7,-1,1,2},{121,0,0,7,1,7,-1,1,2},{121,0,0,7,1,7,-1,1,2},{121,0,0,7,1,7,-1,1,2},{121,0,0,7,1,7,-1,1,2},{121,0,0,7,1,7,-1,1,2},{121,0,0,7,1,7,-1,1,2},{121,0,0,7,1,7,-1,1,2}},
  {{121,0,0,7,1,7,-1,1,2},{121,0,0,7,1,7,-1,1,2},{121,0,0,7,1,7,-1,1,2},{121,0,0,7,1,7,-1,1,2},{121,0,0,7,1,7,-1,1,2},{121,0,0,12,17,7,-1,1,9},{121,0,0,12,17,7,-1,1,9},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{121,0,0,15,1,8,-1,1,2},{121,0,0,15,1,8,-1,1,2},{121,0,0,15,1,8,-1,1,2},{121,0,0,15,1,8,-1,1,2},{121,0,0,15,1,8,-1,1,2}},
  {{121,0,0,21,1,8,-1,1,4},{121,0,0,21,1,8,-1,1,4},{121,0,0,21,1,8,-1,1,4},{121,0,0,21,1,8,-1,1,4},{121,0,0,21,1,8,-1,1,4},{121,0,0,21,1,8,-1,1,4},{121,0,0,21,1,8,-1,1,15},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0}},
  {{117,0,0,7,1,7,-1,1,2},{117,0,0,7,1,7,-1,1,2},{117,0,0,7,1,7,-1,1,2},{117,0,0,7,1,7,-1,1,2},{117,0,0,7,1,7,-1,1,2},{117,0,0,7,1,7,-1,1,2},{117,0,0,7,1,7,-1,1,2},{117,0,0,7,1,7,-1,1,2},{117,0,0,7,1,7,-1,1,2},{117,0,0,7,1,7,-1,1,2},{117,0,0,7,1,7,-1,1,2},{117,0,0,7,1,7,-1,1,2},{117,0,0,7,1,7,-1,1,2},{117,0,0,7,1,7,-1,1,2},{117,0,0,7,1,7,-1,1,2},{117,0,0,7,1,7,-1,1,2}},
  {{117,0,0,7,1,7,-1,1,2},{117,0,0,7,1,7,-1,1,2},{117,0,0,7,1,7,-1,1,2},{117,0,0,7,1,7,-1,1,2},{117,0,0,7,1,7,-1,1,2},{117,0,0,7,1,7,-1,1,2},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{117,0,0,21,10,8,-1,1,4},{117,0,0,21,10,8,-1,1,4},{117,0,0,21,10,8,-1,1,4},{117,0,0,21,10,8,-1,1,4},{117,0,0,21,10,8,-1,1,4},{117,0,0,21,10,8,-1,1,4},{117,0,0,21,10,8,-1,1,4}},
  {{125,0,0,7,1,7,-1,1,2},{125,0,0,7,1,7,-1,1,2},{125,0,0,7,1,7,-1,1,2},{125,0,0,7,1,7,-1,1,2},{125,0,0,7,1,7,-1,1,2},{125,0,0,7,1,7,-1,1,2},{125,0,0,7,1,7,-1,1,2},{125,0,0,7,1,7,-1,1,2},{125,0,0,7,1,7,-1,1,2},{125,0,0,7,1,7,-1,1,2},{125,0,0,7,1,7,-1,1,2},{125,0,0,7,1,7,-1,1,2},{125,0,0,7,1,7,-1,1,2},{125,0,0,7,1,7,-1,1,2},{125,0,0,7,1,7,-1,1,2},{125,0,0,7,1,7,-1,1,2}},
  {{125,0,0,7,1,7,-1,1,2},{125,0,0,7,1,7,-1,1,2},{125,0,0,7,1,7,-1,1,2},{125,0,0,7,1,7,-1,1,2},{125,0,0,7,1,7,-1,1,2},{125,0,0,7,1,7,-1,1,2},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{125,0,0,15,1,8,-1,1,2},{125,0,0,15,1,8,-1,1,2},{125,0,0,15,1,8,-1,1,2},{125,0,0,15,1,8,-1,1,2},{125,0,0,15,1,8,-1,1,2},{125,0,0,15,1,8,-1,1,2},{125,0,0,15,1,8,-1,1,2},{125,0,0,15,1,8,-1,1,2}},
  {{122,0,0,7,1,7,-1,1,2},{122,0,0,7,1,7,-1,1,2},{122,0,0,7,1,7,-1,1,2},{122,0,0,7,1,7,-1,1,2},{122,0,0,7,1,7,-1,1,2},{122,0,0,7,1,7,-1,1,2},{122,0,0,7,1,7,-1,1,2},{122,0,0,7,1,7,-1,1,2},{122,0,0,7,1,7,-1,1,2},{122,0,0,7,1,7,-1,1,2},{122,0,0,7,1,7,-1,1,2},{122,0,0,7,1,7,-1,1,2},{122,0,0,7,1,7,-1,1,2},{122,0,0,7,1,7,-1,1,2},{122,0,0,7,1,7,-1,1,2},{122,0,0,7,1,7,-1,1,2}},
  {{122,0,0,7,1,7,-1,1,2},{122,0,0,7,1,7,-1,1,2},{122,0,0,7,1,7,-1,1,2},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{122,0,0,15,1,8,-1,1,2},{122,0,0,15,1,8,-1,1,2},{122,0,0,15,1,8,-1,1,2},{122,0,0,15,1,8,-1,1,2},{122,0,0,15,1,8,-1,1,2},{122,0,0,15,1,8,-1,1,2},{122,0,0,15,1,8,-1,1,2},{122,0,0,15,1,8,-1,1,2}},
  {{123,0,0,7,1,7,-1,1,2},{123,0,0,7,1,7,-1,1,2},{123,0,0,7,1,7,-1,1,2},{123,0,0,7,1,7,-1,1,2},{123,0,0,7,1,7,-1,1,2},{123,0,0,7,1,7,-1,1,2},{123,0,0,7,1,7,-1,1,2},{123,0,0,7,1,7,-1,1,2},{123,0,0,7,1,7,-1,1,2},{123,0,0,7,1,7,-1,1,2},{123,0,0,7,1,7,-1,1,2},{123,0,0,7,1,7,-1,1,2},{123,0,0,7,1,7,-1,1,2},{123,0,0,7,1,7,-1,1,2},{123,0,0,7,1,7,-1,1,2},{123,0,0,7,1,7,-1,1,2}},
  {{123,0,0,7,1,7,-1,1,2},{123,0,0,7,1,7,-1,1,2},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{123,0,0,21,1,8,-1,1,2},{123,0,0,21,1,8,-1,1,2},{123,0,0,21,1,8,-1,1,2},{123,0,0,21,1,8,-1,1,2},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0}},
  {{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{123,0,0,15,1,8,-1,1,2},{123,0,0,15,1,8,-1,1,2},{123,0,0,15,1,8,-1,1,2},{123,0,0,15,1,8,-1,1,2},{123,0,0,15,1,8,-1,1,2},{123,0,0,15,1,8,-1,1,2},{123,0,0,15,1,8,-1,1,2}},
  {{88,0,0,7,1,7,-1,1,2},{88,0,0,7,1,7,-1,1,2},{88,0,0,7,1,7,-1,1,2},{88,0,0,7,1,7,-1,1,2},{88,0,0,7,1,7,-1,1,2},{88,0,0,7,1,7,-1,1,2},{88,0,0,7,1,7,-1,1,2},{88,0,0,7,1,7,-1,1,2},{88,0,0,7,1,7,-1,1,2},{88,0,0,7,1,7,-1,1,2},{88,0,0,7,1,7,-1,1,2},{88,0,0,7,1,7,-1,1,2},{88,0,0,7,1,7,-1,1,2},{88,0,0,7,1,7,-1,1,2},{88,0,0,7,1,7,-1,1,2},{88,0,0,7,1,7,-1,1,2}},
  {{88,0,0,7,1,7,-1,1,2},{88,0,0,7,1,7,-1,1,2},{88,0,0,7,1,7,-1,1,2},{88,0,0,7,1,7,-1,1,2},{88,0,0,7,1,7,-1,1,2},{88,0,0,7,1,7,-1,1,2},{88,0,0,7,1,7,-1,1,2},{88,0,0,7,1,7,-1,1,2},{88,0,0,7,1,7,-1,1,2},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0}},
  {{76,0,0,9,1,7,-1,1,2},{76,0,0,9,1,7,-1,1,2},{76,0,0,9,1,7,-1,1,2},{76,0,0,9,1,7,-1,1,2},{76,0,0,9,1,7,-1,1,2},{76,0,0,9,1,7,-1,1,2},{76,0,0,9,1,7,-1,1,2},{76,0,0,9,1,7,-1,1,2},{76,0,0,9,1,7,-1,1,2},{76,0,0,9,1,7,-1,1,2},{76,0,0,9,1,7,-1,1,2},{76,0,0,9,1,7,-1,1,2},{76,0,0,9,1,7,-1,1,2},{76,0,0,9,1,7,-1,1,2},{76,0,0,9,1,7,-1,1,2},{76,0,0,9,1,7,-1,1,2}},
  {{76,0,0,9,1,7,-1,1,2},{76,0,0,9,1,7,-1,1,2},{76,0,0,9,1,7,-1,1,2},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0}},
  {{76,0,0,5,1,7,-1,1,2},{76,0,0,5,1,7,-1,1,2},{76,0,0,5,1,7,-1,1,2},{76,0,0,5,1,7,-1,1,2},{76,0,0,5,1,7,-1,1,2},{76,0,0,5,1,7,-1,1,2},{76,0,0,5,1,7,-1,1,2},{76,0,0,5,1,7,-1,1,2},{76,0,0,5,1,7,-1,1,2},{76,0,0,5,1,7,-1,1,2},{76,0,0,5,1,7,-1,1,2},{76,0,0,5,1,7,-1,1,2},{76,0,0,5,1,7,-1,1,2},{76,0,0,5,1,7,-1,1,2},{76,0,0,5,1,7,-1,1,2},{76,0,0,5,1,7,-1,1,2}},
  {{76,0,0,5,1,7,-1,1,2},{76,0,0,5,1,7,-1,1,2},{76,0,0,5,1,7,-1,1,2},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{76,0,0,15,1,8,-1,1,2},{76,0,0,15,1,8,-1,1,2},{76,0,0,15,1,8,-1,1,2},{76,0,0,15,1,8,-1,1,2},{76,0,0,15,1,8,-1,1,2},{76,0,0,15,1,8,-1,1,2}},
  {{2,0,0,15,5,8,1,1,2},{2,0,0,15,5,8,2,1,2},{2,0,0,15,5,8,3,1,2},{2,0,0,15,5,8,4,1,2},{2,0,0,15,5,8,5,1,2},{2,0,0,15,5,8,6,1,2},{2,0,0,15,5,8,7,1,2},{2,0,0,15,5,8,8,1,2},{2,0,0,15,5,8,9,1,2},{2,0,0,15,5,8,-1,1,2},{2,0,0,15,5,8,-1,1,2},{2,0,0,15,5,8,-1,1,2},{2,0,0,15,5,8,-1,1,2},{2,0,0,15,5,8,-1,1,2},{2,0,0,15,5,8,-1,1,2},{2,0,0,15,5,8,-1,1,2}},
  {{2,0,0,15,5,8,-1,1,2},{2,0,0,15,5,8,-1,1,2},{2,0,0,15,5,8,-1,1,2},{2,0,0,15,5,8,-1,1,2},{2,0,0,15,5,8,-1,1,2},{2,0,0,15,5,8,-1,1,2},{2,0,0,15,5,8,-1,1,2},{2,0,0,15,5,8,-1,1,2},{2,0,0,15,5,8,-1,1,2},{2,0,0,15,5,8,-1,1,2},{2,0,0,15,5,8,-1,1,2},{2,0,0,15,5,8,-1,1,2},{2,0,0,15,5,8,-1,1,2},{2,0,0,15,5,8,-1,1,2},{2,0,0,15,5,8,-1,1,2},{103,0,0,2,1,12,-1,1,0}},
  {{65,0,0,10,0,7,-1,1,9},{65,0,0,12,17,7,-1,1,9},{65,0,0,10,0,7,-1,1,9},{65,0,0,7,0,7,-1,1,2},{65,0,0,7,0,7,-1,1,2},{65,0,0,7,0,7,-1,1,2},{65,0,0,7,0,7,-1,1,2},{65,0,0,7,0,7,-1,1,2},{65,0,0,7,0,7,-1,1,2},{65,0,0,7,0,7,-1,1,2},{65,0,0,7,0,7,-1,1,2},{65,0,0,7,0,7,-1,1,2},{65,0,0,7,0,7,-1,1,2},{65,0,0,7,0,7,-1,1,2},{65,0,0,7,0,7,-1,1,2},{65,0,0,7,0,7,-1,1,2}},
  {{65,0,0,7,0,7,-1,1,2},{65,0,0,7,0,7,-1,1,2},{65,0,0,7,0,7,-1,1,2},{65,0,0,7,0,7,-1,1,2},{65,0,0,7,0,7,-1,1,2},{65,0,0,7,0,7,-1,1,2},{65,0,0,7,0,7,-1,1,2},{65,0,0,7,0,7,-1,1,2},{65,0,0,7,0,7,-1,1,2},{65,0,0,7,0,7,-1,1,2},{65,0,0,7,0,7,-1,1,2},{65,0,0,7,0,7,-1,1,2},{65,0,0,7,0,7,-1,1,2},{65,0,0,7,0,7,-1,1,2},{65,0,0,7,0,7,-1,1,2},{65,0,0,7,0,7,-1,1,2}},
  {{65,0,0,7,0,7,-1,1,2},{65,0,0,7,0,7,-1,1,2},{65,0,0,7,0,7,-1,1,2},{65,0,0,7,0,7,-1,1,2},{65,0,0,7,0,7,-1,1,2},{65,0,0,7,0,7,-1,1,2},{65,0,0,7,0,7,-1,1,2},{65,0,0,7,0,7,-1,1,2},{65,0,0,12,17,7,-1,1,9},{65,0,0,12,17,7,-1,1,9},{65,0,0,12,17,7,-1,1,9},{65,0,0,12,17,7,-1,1,9},{65,0,0,12,17,7,-1,1,9},{65,0,0,12,17,7,-1,1,9},{65,0,0,12,17,7,-1,1,9},{65,0,0,12,17,7,-1,1,9}},
  {{65,0,0,12,17,7,-1,1,9},{65,0,0,12,17,7,-1,1,9},{65,0,0,12,17,7,-1,1,9},{65,0,0,12,17,7,-1,1,9},{65,0,0,12,17,7,-1,1,9},{65,0,0,12,17,7,-1,1,9},{65,0,0,12,17,7,-1,1,9},{65,0,0,21,0,8,-1,1,4},{65,0,0,21,0,8,-1,1,4},{65,0,0,21,0,8,-1,1,2},{65,0,0,21,0,8,-1,1,2},{65,0,0,21,0,8,-1,1,2},{65,0,0,21,0,8,-1,1,2},{65,0,0,21,0,8,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{65,0,0,15,10,8,1,1,2},{65,0,0,15,10,8,2,1,2},{65,0,0,15,10,8,3,1,2},{65,0,0,15,10,8,4,1,2},{65,0,0,15,10,8,5,1,2},{65,0,0,15,10,8,6,1,2},{65,0,0,15,10,8,7,1,2},{65,0,0,15,10,8,8,1,2},{65,0,0,15,10,8,9,1,2},{65,0,0,15,10,8,-1,1,2},{65,0,0,15,10,8,-1,1,2},{65,0,0,15,10,8,-1,1,2},{65,0,0,15,10,8,-1,1,2},{65,0,0,15,10,8,-1,1,2}},
  {{65,0,0,15,10,8,-1,1,2},{65,0,0,15,10,8,-1,1,2},{65,0,0,15,10,8,-1,1,2},{65,0,0,15,10,8,-1,1,2},{65,0,0,15,10,8,-1,1,2},{65,0,0,15,10,8,-1,1,2},{65,0,0,13,0,7,0,1,19},{65,0,0,13,0,7,1,1,19},{65,0,0,13,0,7,2,1,19},{65,0,0,13,0,7,3,1,19},{65,0,0,13,0,7,4,1,19},{65,0,0,13,0,7,5,1,19},{65,0,0,13,0,7,6,1,19},{65,0,0,13,0,7,7,1,19},{65,0,0,13,0,7,8,1,19},{65,0,0,13,0,7,9,1,19}},
  {{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{65,0,0,12,17,7,-1,1,9}},
  {{120,0,0,12,17,7,-1,1,9},{120,0,0,12,17,7,-1,1,9},{120,0,0,10,0,7,-1,1,9},{120,0,0,7,0,7,-1,1,2},{120,0,0,7,0,7,-1,1,2},{120,0,0,7,0,7,-1,1,2},{120,0,0,7,0,7,-1,1,2},{120,0,0,7,0,7,-1,1,2},{120,0,0,7,0,7,-1,1,2},{120,0,0,7,0,7,-1,1,2},{120,0,0,7,0,7,-1,1,2},{120,0,0,7,0,7,-1,1,2},{120,0,0,7,0,7,-1,1,2},{120,0,0,7,0,7,-1,1,2},{120,0,0,7,0,7,-1,1,2},{120,0,0,7,0,7,-1,1,2}},
  {{120,0,0,7,0,7,-1,1,2},{120,0,0,7,0,7,-1,1,2},{120,0,0,7,0,7,-1,1,2},{120,0,0,7,0,7,-1,1,2},{120,0,0,7,0,7,-1,1,2},{120,0,0,7,0,7,-1,1,2},{120,0,0,7,0,7,-1,1,2},{120,0,0,7,0,7,-1,1,2},{120,0,0,7,0,7,-1,1,2},{120,0,0,7,0,7,-1,1,2},{120,0,0,7,0,7,-1,1,2},{120,0,0,7,0,7,-1,1,2},{120,0,0,7,0,7,-1,1,2},{120,0,0,7,0,7,-1,1,2},{120,0,0,7,0,7,-1,1,2},{120,0,0,7,0,7,-1,1,2}},
  {{120,0,0,10,0,7,-1,1,9},{120,0,0,10,0,7,-1,1,9},{120,0,0,10,0,7,-1,1,9},{120,0,0,12,17,7,-1,1,9},{120,0,0,12,17,7,-1,1,9},{120,0,0,12,17,7,-1,1,9},{120,0,0,12,17,7,-1,1,9},{120,0,0,10,0,7,-1,1,9},{120,0,0,10,0,7,-1,1,9},{120,0,0,12,17,7,-1,1,9},{120,0,0,12,17,7,-1,1,9},{120,0,0,21,0,8,-1,1,2},{120,0,0,21,0,8,-1,1,2},{120,0,0,1,0,8,-1,1,2},{120,0,0,21,0,8,-1,1,4},{120,0,0,21,0,8,-1,1,4}},
  {{120,0,0,21,0,8,-1,1,4},{120,0,0,21,0,8,-1,1,4},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{152,0,0,7,0,7,-1,1,2},{152,0,0,7,0,7,-1,1,2},{152,0,0,7,0,7,-1,1,2},{152,0,0,7,0,7,-1,1,2},{152,0,0,7,0,7,-1,1,2},{152,0,0,7,0,7,-1,1,2},{152,0,0,7,0,7,-1,1,2},{152,0,0,7,0,7,-1,1,2},{152,0,0,7,0,7,-1,1,2},{152,0,0,7,0,7,-1,1,2},{152,0,0,7,0,7,-1,1,2},{152,0,0,7,0,7,-1,1,2},{152,0,0,7,0,7,-1,1,2},{152,0,0,7,0,7,-1,1,2},{152,0,0,7,0,7,-1,1,2},{152,0,0,7,0,7,-1,1,2}},
  {{152,0,0,7,0,7,-1,1,2},{152,0,0,7,0,7,-1,1,2},{152,0,0,7,0,7,-1,1,2},{152,0,0,7,0,7,-1,1,2},{152,0,0,7,0,7,-1,1,2},{152,0,0,7,0,7,-1,1,2},{152,0,0,7,0,7,-1,1,2},{152,0,0,7,0,7,-1,1,2},{152,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{152,0,0,13,0,7,0,1,19},{152,0,0,13,0,7,1,1,19},{152,0,0,13,0,7,2,1,19},{152,0,0,13,0,7,3,1,19},{152,0,0,13,0,7,4,1,19},{152,0,0,13,0,7,5,1,19},{152,0,0,13,0,7,6,1,19},{152,0,0,13,0,7,7,1,19},{152,0,0,13,0,7,8,1,19},{152,0,0,13,0,7,9,1,19},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{118,0,0,12,17,6,-1,1,9},{118,0,0,12,17,6,-1,1,9},{118,0,0,12,17,6,-1,1,9},{118,0,0,7,0,6,-1,1,2},{118,0,0,7,0,6,-1,1,2},{118,0,0,7,0,6,-1,1,2},{118,0,0,7,0,6,-1,1,2},{118,0,0,7,0,6,-1,1,2},{118,0,0,7,0,6,-1,1,2},{118,0,0,7,0,6,-1,1,2},{118,0,0,7,0,6,-1,1,2},{118,0,0,7,0,6,-1,1,2},{118,0,0,7,0,6,-1,1,2},{118,0,0,7,0,6,-1,1,2},{118,0,0,7,0,6,-1,1,2},{118,0,0,7,0,6,-1,1,2}},
  {{118,0,0,7,0,6,-1,1,2},{118,0,0,7,0,6,-1,1,2},{118,0,0,7,0,6,-1,1,2},{118,0,0,7,0,6,-1,1,2},{118,0,0,7,0,6,-1,1,2},{118,0,0,7,0,6,-1,1,2},{118,0,0,7,0,6,-1,1,2},{118,0,0,7,0,6,-1,1,2},{118,0,0,7,0,6,-1,1,2},{118,0,0,7,0,6,-1,1,2},{118,0,0,7,0,6,-1,1,2},{118,0,0,7,0,6,-1,1,2},{118,0,0,7,0,6,-1,1,2},{118,0,0,7,0,6,-1,1,2},{118,0,0,7,0,6,-1,1,2},{118,0,0,7,0,6,-1,1,2}},
  {{118,0,0,7,0,6,-1,1,2},{118,0,0,7,0,6,-1,1,2},{118,0,0,7,0,6,-1,1,2},{118,0,0,7,0,6,-1,1,2},{118,0,0,7,0,6,-1,1,2},{118,0,0,7,0,6,-1,1,2},{118,0,0,7,0,6,-1,1,2},{118,0,0,12,17,6,-1,1,9},{118,0,0,12,17,6,-1,1,9},{118,0,0,12,17,6,-1,1,9},{118,0,0,12,17,6,-1,1,9},{118,0,0,12,17,6,-1,1,9},{118,0,0,10,0,6,-1,1,9},{118,0,0,12,17,6,-1,1,9},{118,0,0,12,17,6,-1,1,9},{118,0,0,12,17,6,-1,1,9}},
  {{118,0,0,12,17,6,-1,1,9},{118,0,0,12,17,6,-1,1,9},{118,0,0,12,17,6,-1,1,9},{118,0,0,12,17,6,-1,1,9},{118,0,0,12,17,6,-1,1,9},{103,0,0,2,0,12,-1,1,0},{118,0,0,13,0,6,0,1,19},{118,0,0,13,0,6,1,1,19},{118,0,0,13,0,6,2,1,19},{118,0,0,13,0,6,3,1,19},{118,0,0,13,0,6,4,1,19},{118,0,0,13,0,6,5,1,19},{118,0,0,13,0,6,6,1,19},{118,0,0,13,0,6,7,1,19},{118,0,0,13,0,6,8,1,19},{118,0,0,13,0,6,9,1,19}},
  {{118,0,0,21,0,8,-1,1,4},{118,0,0,21,0,8,-1,1,4},{118,0,0,21,0,8,-1,1,4},{118,0,0,21,0,8,-1,1,4},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{160,0,0,7,0,7,-1,1,2},{160,0,0,7,0,7,-1,1,2},{160,0,0,7,0,7,-1,1,2},{160,0,0,7,0,7,-1,1,2},{160,0,0,7,0,7,-1,1,2},{160,0,0,7,0,7,-1,1,2},{160,0,0,7,0,7,-1,1,2},{160,0,0,7,0,7,-1,1,2},{160,0,0,7,0,7,-1,1,2},{160,0,0,7,0,7,-1,1,2},{160,0,0,7,0,7,-1,1,2},{160,0,0,7,0,7,-1,1,2},{160,0,0,7,0,7,-1,1,2},{160,0,0,7,0,7,-1,1,2},{160,0,0,7,0,7,-1,1,2},{160,0,0,7,0,7,-1,1,2}},
  {{160,0,0,7,0,7,-1,1,2},{160,0,0,7,0,7,-1,1,2},{160,0,0,7,0,7,-1,1,2},{160,0,0,12,17,7,-1,1,9},{160,0,0,21,0,8,-1,1,2},{160,0,0,21,0,8,-1,1,5},{160,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{151,0,0,12,17,7,-1,1,9},{151,0,0,12,17,7,-1,1,9},{151,0,0,10,0,7,-1,1,9},{151,0,0,7,0,7,-1,1,2},{151,0,0,7,0,7,-1,1,2},{151,0,0,7,0,7,-1,1,2},{151,0,0,7,0,7,-1,1,2},{151,0,0,7,0,7,-1,1,2},{151,0,0,7,0,7,-1,1,2},{151,0,0,7,0,7,-1,1,2},{151,0,0,7,0,7,-1,1,2},{151,0,0,7,0,7,-1,1,2},{151,0,0,7,0,7,-1,1,2},{151,0,0,7,0,7,-1,1,2},{151,0,0,7,0,7,-1,1,2},{151,0,0,7,0,7,-1,1,2}},
  {{151,0,0,7,0,7,-1,1,2},{151,0,0,7,0,7,-1,1,2},{151,0,0,7,0,7,-1,1,2},{151,0,0,7,0,7,-1,1,2},{151,0,0,7,0,7,-1,1,2},{151,0,0,7,0,7,-1,1,2},{151,0,0,7,0,7,-1,1,2},{151,0,0,7,0,7,-1,1,2},{151,0,0,7,0,7,-1,1,2},{151,0,0,7,0,7,-1,1,2},{151,0,0,7,0,7,-1,1,2},{151,0,0,7,0,7,-1,1,2},{151,0,0,7,0,7,-1,1,2},{151,0,0,7,0,7,-1,1,2},{151,0,0,7,0,7,-1,1,2},{151,0,0,7,0,7,-1,1,2}},
  {{151,0,0,7,0,7,-1,1,2},{151,0,0,7,0,7,-1,1,2},{151,0,0,7,0,7,-1,1,2},{151,0,0,10,0,7,-1,1,9},{151,0,0,10,0,7,-1,1,9},{151,0,0,10,0,7,-1,1,9},{151,0,0,12,17,7,-1,1,9},{151,0,0,12,17,7,-1,1,9},{151,0,0,12,17,7,-1,1,9},{151,0,0,12,17,7,-1,1,9},{151,0,0,12,17,7,-1,1,9},{151,0,0,12,17,7,-1,1,9},{151,0,0,12,17,7,-1,1,9},{151,0,0,12,17,7,-1,1,9},{151,0,0,12,17,7,-1,1,9},{151,0,0,10,0,7,-1,1,9}},
  {{151,0,0,10,0,7,-1,1,9},{151,0,0,7,0,7,-1,1,2},{151,0,0,7,0,7,-1,1,2},{151,0,0,7,0,7,-1,1,2},{151,0,0,7,0,7,-1,1,2},{151,0,0,21,0,8,-1,1,4},{151,0,0,21,0,8,-1,1,4},{151,0,0,21,0,8,-1,1,2},{151,0,0,21,0,8,-1,1,4},{151,0,0,21,0,8,-1,1,2},{151,0,0,12,17,7,-1,1,9},{151,0,0,12,17,7,-1,1,9},{151,0,0,12,17,7,-1,1,9},{151,0,0,21,0,8,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{151,0,0,13,0,7,0,1,19},{151,0,0,13,0,7,1,1,19},{151,0,0,13,0,7,2,1,19},{151,0,0,13,0,7,3,1,19},{151,0,0,13,0,7,4,1,19},{151,0,0,13,0,7,5,1,19},{151,0,0,13,0,7,6,1,19},{151,0,0,13,0,7,7,1,19},{151,0,0,13,0,7,8,1,19},{151,0,0,13,0,7,9,1,19},{151,0,0,7,0,7,-1,1,2},{151,0,0,21,0,8,-1,1,5},{151,0,0,7,0,7,-1,1,2},{151,0,0,21,0,8,-1,1,4},{151,0,0,21,0,8,-1,1,4},{151,0,0,21,0,8,-1,1,4}},
  {{103,0,0,2,0,12,-1,1,0},{33,0,0,15,0,8,-1,1,2},{33,0,0,15,0,8,-1,1,2},{33,0,0,15,0,8,-1,1,2},{33,0,0,15,0,8,-1,1,2},{33,0,0,15,0,8,-1,1,2},{33,0,0,15,0,8,-1,1,2},{33,0,0,15,0,8,-1,1,2},{33,0,0,15,0,8,-1,1,2},{33,0,0,15,0,8,-1,1,2},{33,0,0,15,0,8,-1,1,2},{33,0,0,15,0,8,-1,1,2},{33,0,0,15,0,8,-1,1,2},{33,0,0,15,0,8,-1,1,2},{33,0,0,15,0,8,-1,1,2},{33,0,0,15,0,8,-1,1,2}},
  {{33,0,0,15,0,8,-1,1,2},{33,0,0,15,0,8,-1,1,2},{33,0,0,15,0,8,-1,1,2},{33,0,0,15,0,8,-1,1,2},{33,0,0,15,0,8,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{157,0,0,7,0,7,-1,1,2},{157,0,0,7,0,7,-1,1,2},{157,0,0,7,0,7,-1,1,2},{157,0,0,7,0,7,-1,1,2},{157,0,0,7,0,7,-1,1,2},{157,0,0,7,0,7,-1,1,2},{157,0,0,7,0,7,-1,1,2},{157,0,0,7,0,7,-1,1,2},{157,0,0,7,0,7,-1,1,2},{157,0,0,7,0,7,-1,1,2},{157,0,0,7,0,7,-1,1,2},{157,0,0,7,0,7,-1,1,2},{157,0,0,7,0,7,-1,1,2},{157,0,0,7,0,7,-1,1,2},{157,0,0,7,0,7,-1,1,2},{157,0,0,7,0,7,-1,1,2}},
  {{157,0,0,7,0,7,-1,1,2},{157,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{157,0,0,7,0,7,-1,1,2},{157,0,0,7,0,7,-1,1,2},{157,0,0,7,0,7,-1,1,2},{157,0,0,7,0,7,-1,1,2},{157,0,0,7,0,7,-1,1,2},{157,0,0,7,0,7,-1,1,2},{157,0,0,7,0,7,-1,1,2},{157,0,0,7,0,7,-1,1,2},{157,0,0,7,0,7,-1,1,2},{157,0,0,7,0,7,-1,1,2},{157,0,0,7,0,7,-1,1,2},{157,0,0,7,0,7,-1,1,2},{157,0,0,7,0,7,-1,1,2}},
  {{157,0,0,7,0,7,-1,1,2},{157,0,0,7,0,7,-1,1,2},{157,0,0,7,0,7,-1,1,2},{157,0,0,7,0,7,-1,1,2},{157,0,0,7,0,7,-1,1,2},{157,0,0,7,0,7,-1,1,2},{157,0,0,7,0,7,-1,1,2},{157,0,0,7,0,7,-1,1,2},{157,0,0,7,0,7,-1,1,2},{157,0,0,7,0,7,-1,1,2},{157,0,0,7,0,7,-1,1,2},{157,0,0,7,0,7,-1,1,2},{157,0,0,10,0,7,-1,1,9},{157,0,0,10,0,7,-1,1,9},{157,0,0,10,0,7,-1,1,9},{157,0,0,12,17,7,-1,1,9}},
  {{157,0,0,12,17,7,-1,1,9},{157,0,0,12,17,7,-1,1,9},{157,0,0,10,0,7,-1,1,9},{157,0,0,10,0,7,-1,1,9},{157,0,0,12,17,7,-1,1,9},{157,0,0,10,0,7,-1,1,9},{157,0,0,12,17,7,-1,1,9},{157,0,0,12,17,7,-1,1,9},{157,0,0,21,0,8,-1,1,4},{157,0,0,21,0,8,-1,1,4},{157,0,0,21,0,8,-1,1,2},{157,0,0,21,0,8,-1,1,4},{157,0,0,21,0,8,-1,1,4},{157,0,0,21,0,8,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{164,0,0,7,0,7,-1,1,2},{164,0,0,7,0,7,-1,1,2},{164,0,0,7,0,7,-1,1,2},{164,0,0,7,0,7,-1,1,2},{164,0,0,7,0,7,-1,1,2},{164,0,0,7,0,7,-1,1,2},{164,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{164,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{164,0,0,7,0,7,-1,1,2},{164,0,0,7,0,7,-1,1,2},{164,0,0,7,0,7,-1,1,2},{164,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{164,0,0,7,0,7,-1,1,2}},
  {{164,0,0,7,0,7,-1,1,2},{164,0,0,7,0,7,-1,1,2},{164,0,0,7,0,7,-1,1,2},{164,0,0,7,0,7,-1,1,2},{164,0,0,7,0,7,-1,1,2},{164,0,0,7,0,7,-1,1,2},{164,0,0,7,0,7,-1,1,2},{164,0,0,7,0,7,-1,1,2},{164,0,0,7,0,7,-1,1,2},{164,0,0,7,0,7,-1,1,2},{164,0,0,7,0,7,-1,1,2},{164,0,0,7,0,7,-1,1,2},{164,0,0,7,0,7,-1,1,2},{164,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{164,0,0,7,0,7,-1,1,2}},
  {{164,0,0,7,0,7,-1,1,2},{164,0,0,7,0,7,-1,1,2},{164,0,0,7,0,7,-1,1,2},{164,0,0,7,0,7,-1,1,2},{164,0,0,7,0,7,-1,1,2},{164,0,0,7,0,7,-1,1,2},{164,0,0,7,0,7,-1,1,2},{164,0,0,7,0,7,-1,1,2},{164,0,0,7,0,7,-1,1,2},{164,0,0,21,0,8,-1,1,4},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{145,0,0,7,0,7,-1,1,2},{145,0,0,7,0,7,-1,1,2},{145,0,0,7,0,7,-1,1,2},{145,0,0,7,0,7,-1,1,2},{145,0,0,7,0,7,-1,1,2},{145,0,0,7,0,7,-1,1,2},{145,0,0,7,0,7,-1,1,2},{145,0,0,7,0,7,-1,1,2},{145,0,0,7,0,7,-1,1,2},{145,0,0,7,0,7,-1,1,2},{145,0,0,7,0,7,-1,1,2},{145,0,0,7,0,7,-1,1,2},{145,0,0,7,0,7,-1,1,2},{145,0,0,7,0,7,-1,1,2},{145,0,0,7,0,7,-1,1,2},{145,0,0,7,0,7,-1,1,2}},
  {{145,0,0,7,0,7,-1,1,2},{145,0,0,7,0,7,-1,1,2},{145,0,0,7,0,7,-1,1,2},{145,0,0,7,0,7,-1,1,2},{145,0,0,7,0,7,-1,1,2},{145,0,0,7,0,7,-1,1,2},{145,0,0,7,0,7,-1,1,2},{145,0,0,7,0,7,-1,1,2},{145,0,0,7,0,7,-1,1,2},{145,0,0,7,0,7,-1,1,2},{145,0,0,7,0,7,-1,1,2},{145,0,0,7,0,7,-1,1,2},{145,0,0,7,0,7,-1,1,2},{145,0,0,7,0,7,-1,1,2},{145,0,0,7,0,7,-1,1,2},{145,0,0,12,17,7,-1,1,9}},
  {{145,0,0,10,0,7,-1,1,9},{145,0,0,10,0,7,-1,1,9},{145,0,0,10,0,7,-1,1,9},{145,0,0,12,17,7,-1,1,9},{145,0,0,12,17,7,-1,1,9},{145,0,0,12,17,7,-1,1,9},{145,0,0,12,17,7,-1,1,9},{145,0,0,12,17,7,-1,1,9},{145,0,0,12,17,7,-1,1,9},{145,0,0,12,17,7,-1,1,9},{145,0,0,12,17,7,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{145,0,0,13,0,7,0,1,19},{145,0,0,13,0,7,1,1,19},{145,0,0,13,0,7,2,1,19},{145,0,0,13,0,7,3,1,19},{145,0,0,13,0,7,4,1,19},{145,0,0,13,0,7,5,1,19},{145,0,0,13,0,7,6,1,19},{145,0,0,13,0,7,7,1,19},{145,0,0,13,0,7,8,1,19},{145,0,0,13,0,7,9,1,19},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{137,0,0,12,17,7,-1,1,9},{137,0,0,12,17,7,-1,1,9},{137,0,0,10,0,7,-1,1,9},{137,0,0,10,0,7,-1,1,9},{103,0,0,2,0,12,-1,1,0},{137,0,0,7,0,7,-1,1,2},{137,0,0,7,0,7,-1,1,2},{137,0,0,7,0,7,-1,1,2},{137,0,0,7,0,7,-1,1,2},{137,0,0,7,0,7,-1,1,2},{137,0,0,7,0,7,-1,1,2},{137,0,0,7,0,7,-1,1,2},{137,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{137,0,0,7,0,7,-1,1,2}},
  {{137,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{137,0,0,7,0,7,-1,1,2},{137,0,0,7,0,7,-1,1,2},{137,0,0,7,0,7,-1,1,2},{137,0,0,7,0,7,-1,1,2},{137,0,0,7,0,7,-1,1,2},{137,0,0,7,0,7,-1,1,2},{137,0,0,7,0,7,-1,1,2},{137,0,0,7,0,7,-1,1,2},{137,0,0,7,0,7,-1,1,2},{137,0,0,7,0,7,-1,1,2},{137,0,0,7,0,7,-1,1,2},{137,0,0,7,0,7,-1,1,2},{137,0,0,7,0,7,-1,1,2}},
  {{137,0,0,7,0,7,-1,1,2},{137,0,0,7,0,7,-1,1,2},{137,0,0,7,0,7,-1,1,2},{137,0,0,7,0,7,-1,1,2},{137,0,0,7,0,7,-1,1,2},{137,0,0,7,0,7,-1,1,2},{137,0,0,7,0,7,-1,1,2},{137,0,0,7,0,7,-1,1,2},{137,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{137,0,0,7,0,7,-1,1,2},{137,0,0,7,0,7,-1,1,2},{137,0,0,7,0,7,-1,1,2},{137,0,0,7,0,7,-1,1,2},{137,0,0,7,0,7,-1,1,2},{137,0,0,7,0,7,-1,1,2}},
  {{137,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{137,0,0,7,0,7,-1,1,2},{137,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{137,0,0,7,0,7,-1,1,2},{137,0,0,7,0,7,-1,1,2},{137,0,0,7,0,7,-1,1,2},{137,0,0,7,0,7,-1,1,2},{137,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{137,0,0,12,17,7,-1,1,9},{137,0,0,7,0,7,-1,1,2},{137,0,0,10,0,7,-1,1,9},{137,0,0,10,0,7,-1,1,9}},
  {{137,0,0,12,17,7,-1,1,9},{137,0,0,10,0,7,-1,1,9},{137,0,0,10,0,7,-1,1,9},{137,0,0,10,0,7,-1,1,9},{137,0,0,10,0,7,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{137,0,0,10,0,7,-1,1,9},{137,0,0,10,0,7,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{137,0,0,10,0,7,-1,1,9},{137,0,0,10,0,7,-1,1,9},{137,0,0,10,0,7,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{137,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{137,0,0,10,0,7,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{137,0,0,7,0,7,-1,1,2},{137,0,0,7,0,7,-1,1,2},{137,0,0,7,0,7,-1,1,2}},
  {{137,0,0,7,0,7,-1,1,2},{137,0,0,7,0,7,-1,1,2},{137,0,0,10,0,7,-1,1,9},{137,0,0,10,0,7,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{137,0,0,12,17,7,-1,1,9},{137,0,0,12,17,7,-1,1,9},{137,0,0,12,17,7,-1,1,9},{137,0,0,12,17,7,-1,1,9},{137,0,0,12,17,7,-1,1,9},{137,0,0,12,17,7,-1,1,9},{137,0,0,12,17,7,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{137,0,0,12,17,7,-1,1,9},{137,0,0,12,17,7,-1,1,9},{137,0,0,12,17,7,-1,1,9},{137,0,0,12,17,7,-1,1,9},{137,0,0,12,17,7,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{158,0,0,7,0,7,-1,1,2},{158,0,0,7,0,7,-1,1,2},{158,0,0,7,0,7,-1,1,2},{158,0,0,7,0,7,-1,1,2},{158,0,0,7,0,7,-1,1,2},{158,0,0,7,0,7,-1,1,2},{158,0,0,7,0,7,-1,1,2},{158,0,0,7,0,7,-1,1,2},{158,0,0,7,0,7,-1,1,2},{158,0,0,7,0,7,-1,1,2},{158,0,0,7,0,7,-1,1,2},{158,0,0,7,0,7,-1,1,2},{158,0,0,7,0,7,-1,1,2},{158,0,0,7,0,7,-1,1,2},{158,0,0,7,0,7,-1,1,2},{158,0,0,7,0,7,-1,1,2}},
  {{158,0,0,10,0,7,-1,1,9},{158,0,0,10,0,7,-1,1,9},{158,0,0,10,0,7,-1,1,9},{158,0,0,12,17,7,-1,1,9},{158,0,0,12,17,7,-1,1,9},{158,0,0,12,17,7,-1,1,9},{158,0,0,12,17,7,-1,1,9},{158,0,0,12,17,7,-1,1,9},{158,0,0,12,17,7,-1,1,9},{158,0,0,10,0,7,-1,1,9},{158,0,0,12,17,7,-1,1,9},{158,0,0,10,0,7,-1,1,9},{158,0,0,10,0,7,-1,1,9},{158,0,0,10,0,7,-1,1,9},{158,0,0,10,0,7,-1,1,9},{158,0,0,12,17,7,-1,1,9}},
  {{158,0,0,12,17,7,-1,1,9},{158,0,0,10,0,7,-1,1,9},{158,0,0,12,17,7,-1,1,9},{158,0,0,12,17,7,-1,1,9},{158,0,0,7,0,7,-1,1,2},{158,0,0,7,0,7,-1,1,2},{158,0,0,21,0,8,-1,1,2},{158,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{158,0,0,13,0,7,0,1,19},{158,0,0,13,0,7,1,1,19},{158,0,0,13,0,7,2,1,19},{158,0,0,13,0,7,3,1,19},{158,0,0,13,0,7,4,1,19},{158,0,0,13,0,7,5,1,19},{158,0,0,13,0,7,6,1,19},{158,0,0,13,0,7,7,1,19},{158,0,0,13,0,7,8,1,19},{158,0,0,13,0,7,9,1,19},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{166,0,0,7,0,7,-1,0,2},{166,0,0,7,0,7,-1,0,2},{166,0,0,7,0,7,-1,0,2},{166,0,0,7,0,7,-1,0,2},{166,0,0,7,0,7,-1,0,2},{166,0,0,7,0,7,-1,0,2},{166,0,0,7,0,7,-1,0,2},{166,0,0,7,0,7,-1,0,2},{166,0,0,7,0,7,-1,0,2},{166,0,0,7,0,7,-1,0,2},{166,0,0,7,0,7,-1,0,2},{166,0,0,7,0,7,-1,0,2},{166,0,0,7,0,7,-1,0,2},{166,0,0,7,0,7,-1,0,2},{166,0,0,7,0,7,-1,0,2},{166,0,0,7,0,7,-1,0,2}},
  {{166,0,0,7,0,7,-1,0,2},{166,0,0,7,0,7,-1,0,2},{166,0,0,7,0,7,-1,0,2},{166,0,0,7,0,7,-1,0,2},{166,0,0,7,0,7,-1,0,2},{166,0,0,7,0,7,-1,0,2},{166,0,0,7,0,7,-1,0,2},{166,0,0,7,0,7,-1,0,2},{166,0,0,7,0,7,-1,0,2},{166,0,0,7,0,7,-1,0,2},{166,0,0,7,0,7,-1,0,2},{166,0,0,7,0,7,-1,0,2},{166,0,0,7,0,7,-1,0,2},{166,0,0,7,0,7,-1,0,2},{166,0,0,7,0,7,-1,0,2},{166,0,0,10,0,7,-1,0,9}},
  {{166,0,0,10,0,7,-1,0,9},{166,0,0,10,0,7,-1,0,9},{166,0,0,12,17,7,-1,0,9},{166,0,0,12,17,7,-1,0,9},{166,0,0,12,17,7,-1,0,9},{166,0,0,12,17,7,-1,0,9},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{166,0,0,10,0,7,-1,0,9},{166,0,0,10,0,7,-1,0,9},{166,0,0,10,0,7,-1,0,9},{166,0,0,10,0,7,-1,0,9},{166,0,0,12,17,7,-1,0,9},{166,0,0,12,17,7,-1,0,9},{166,0,0,10,0,7,-1,0,9},{166,0,0,12,17,7,-1,0,9}},
  {{166,0,0,12,17,7,-1,0,9},{166,0,0,21,0,8,-1,0,5},{166,0,0,21,0,8,-1,0,4},{166,0,0,21,0,8,-1,0,4},{166,0,0,21,0,8,-1,0,11},{166,0,0,21,0,8,-1,0,11},{166,0,0,21,0,8,-1,0,2},{166,0,0,21,0,8,-1,0,2},{166,0,0,21,0,8,-1,0,2},{166,0,0,21,0,8,-1,0,4},{166,0,0,21,0,8,-1,0,4},{166,0,0,21,0,8,-1,0,4},{166,0,0,21,0,8,-1,0,4},{166,0,0,21,0,8,-1,0,4},{166,0,0,21,0,8,-1,0,4},{166,0,0,21,0,8,-1,0,4}},
  {{166,0,0,21,0,8,-1,0,4},{166,0,0,21,0,8,-1,0,4},{166,0,0,21,0,8,-1,0,4},{166,0,0,21,0,8,-1,0,4},{166,0,0,21,0,8,-1,0,4},{166,0,0,21,0,8,-1,0,4},{166,0,0,21,0,8,-1,0,4},{166,0,0,21,0,8,-1,0,4},{166,0,0,7,0,7,-1,0,2},{166,0,0,7,0,7,-1,0,2},{166,0,0,7,0,7,-1,0,2},{166,0,0,7,0,7,-1,0,2},{166,0,0,12,17,7,-1,0,9},{166,0,0,12,17,7,-1,0,9},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0}},
  {{163,0,0,7,0,7,-1,1,2},{163,0,0,7,0,7,-1,1,2},{163,0,0,7,0,7,-1,1,2},{163,0,0,7,0,7,-1,1,2},{163,0,0,7,0,7,-1,1,2},{163,0,0,7,0,7,-1,1,2},{163,0,0,7,0,7,-1,1,2},{163,0,0,7,0,7,-1,1,2},{163,0,0,7,0,7,-1,1,2},{163,0,0,7,0,7,-1,1,2},{163,0,0,7,0,7,-1,1,2},{163,0,0,7,0,7,-1,1,2},{163,0,0,7,0,7,-1,1,2},{163,0,0,7,0,7,-1,1,2},{163,0,0,7,0,7,-1,1,2},{163,0,0,7,0,7,-1,1,2}},
  {{163,0,0,10,0,7,-1,1,9},{163,0,0,10,0,7,-1,1,9},{163,0,0,10,0,7,-1,1,9},{163,0,0,12,17,7,-1,1,9},{163,0,0,12,17,7,-1,1,9},{163,0,0,12,17,7,-1,1,9},{163,0,0,12,17,7,-1,1,9},{163,0,0,12,17,7,-1,1,9},{163,0,0,12,17,7,-1,1,9},{163,0,0,12,17,7,-1,1,9},{163,0,0,12,17,7,-1,1,9},{163,0,0,10,0,7,-1,1,9},{163,0,0,10,0,7,-1,1,9},{163,0,0,12,17,7,-1,1,9},{163,0,0,10,0,7,-1,1,9},{163,0,0,12,17,7,-1,1,9}},
  {{163,0,0,12,17,7,-1,1,9},{163,0,0,21,0,8,-1,1,4},{163,0,0,21,0,8,-1,1,4},{163,0,0,21,0,8,-1,1,2},{163,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{163,0,0,13,0,7,0,1,19},{163,0,0,13,0,7,1,1,19},{163,0,0,13,0,7,2,1,19},{163,0,0,13,0,7,3,1,19},{163,0,0,13,0,7,4,1,19},{163,0,0,13,0,7,5,1,19},{163,0,0,13,0,7,6,1,19},{163,0,0,13,0,7,7,1,19},{163,0,0,13,0,7,8,1,19},{163,0,0,13,0,7,9,1,19},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{153,0,0,7,0,7,-1,1,2},{153,0,0,7,0,7,-1,1,2},{153,0,0,7,0,7,-1,1,2},{153,0,0,7,0,7,-1,1,2},{153,0,0,7,0,7,-1,1,2},{153,0,0,7,0,7,-1,1,2},{153,0,0,7,0,7,-1,1,2},{153,0,0,7,0,7,-1,1,2},{153,0,0,7,0,7,-1,1,2},{153,0,0,7,0,7,-1,1,2},{153,0,0,7,0,7,-1,1,2},{153,0,0,7,0,7,-1,1,2},{153,0,0,7,0,7,-1,1,2},{153,0,0,7,0,7,-1,1,2},{153,0,0,7,0,7,-1,1,2},{153,0,0,7,0,7,-1,1,2}},
  {{153,0,0,7,0,7,-1,1,2},{153,0,0,7,0,7,-1,1,2},{153,0,0,7,0,7,-1,1,2},{153,0,0,7,0,7,-1,1,2},{153,0,0,7,0,7,-1,1,2},{153,0,0,7,0,7,-1,1,2},{153,0,0,7,0,7,-1,1,2},{153,0,0,7,0,7,-1,1,2},{153,0,0,7,0,7,-1,1,2},{153,0,0,7,0,7,-1,1,2},{153,0,0,7,0,7,-1,1,2},{153,0,0,12,17,7,-1,1,9},{153,0,0,10,0,7,-1,1,9},{153,0,0,12,17,7,-1,1,9},{153,0,0,10,0,7,-1,1,9},{153,0,0,10,0,7,-1,1,9}},
  {{153,0,0,12,17,7,-1,1,9},{153,0,0,12,17,7,-1,1,9},{153,0,0,12,17,7,-1,1,9},{153,0,0,12,17,7,-1,1,9},{153,0,0,12,17,7,-1,1,9},{153,0,0,12,17,7,-1,1,9},{153,0,0,10,0,7,-1,1,9},{153,0,0,12,17,7,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{153,0,0,13,0,7,0,1,19},{153,0,0,13,0,7,1,1,19},{153,0,0,13,0,7,2,1,19},{153,0,0,13,0,7,3,1,19},{153,0,0,13,0,7,4,1,19},{153,0,0,13,0,7,5,1,19},{153,0,0,13,0,7,6,1,19},{153,0,0,13,0,7,7,1,19},{153,0,0,13,0,7,8,1,19},{153,0,0,13,0,7,9,1,19},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{161,0,0,7,0,7,-1,1,24},{161,0,0,7,0,7,-1,1,24},{161,0,0,7,0,7,-1,1,24},{161,0,0,7,0,7,-1,1,24},{161,0,0,7,0,7,-1,1,24},{161,0,0,7,0,7,-1,1,24},{161,0,0,7,0,7,-1,1,24},{161,0,0,7,0,7,-1,1,24},{161,0,0,7,0,7,-1,1,24},{161,0,0,7,0,7,-1,1,24},{161,0,0,7,0,7,-1,1,24},{161,0,0,7,0,7,-1,1,24},{161,0,0,7,0,7,-1,1,24},{161,0,0,7,0,7,-1,1,24},{161,0,0,7,0,7,-1,1,24},{161,0,0,7,0,7,-1,1,24}},
  {{161,0,0,7,0,7,-1,1,24},{161,0,0,7,0,7,-1,1,24},{161,0,0,7,0,7,-1,1,24},{161,0,0,7,0,7,-1,1,24},{161,0,0,7,0,7,-1,1,24},{161,0,0,7,0,7,-1,1,24},{161,0,0,7,0,7,-1,1,24},{161,0,0,7,0,7,-1,1,24},{161,0,0,7,0,7,-1,1,24},{161,0,0,7,0,7,-1,1,24},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{161,0,0,12,17,7,-1,1,24},{161,0,0,12,17,7,-1,1,24},{161,0,0,12,17,7,-1,1,24}},
  {{161,0,0,10,0,7,-1,1,24},{161,0,0,10,0,7,-1,1,24},{161,0,0,12,17,7,-1,1,24},{161,0,0,12,17,7,-1,1,24},{161,0,0,12,17,7,-1,1,24},{161,0,0,12,17,7,-1,1,24},{161,0,0,10,0,7,-1,1,24},{161,0,0,12,17,7,-1,1,24},{161,0,0,12,17,7,-1,1,24},{161,0,0,12,17,7,-1,1,24},{161,0,0,12,17,7,-1,1,24},{161,0,0,12,17,7,-1,1,24},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{161,0,0,13,0,7,0,1,19},{161,0,0,13,0,7,1,1,19},{161,0,0,13,0,7,2,1,19},{161,0,0,13,0,7,3,1,19},{161,0,0,13,0,7,4,1,19},{161,0,0,13,0,7,5,1,19},{161,0,0,13,0,7,6,1,19},{161,0,0,13,0,7,7,1,19},{161,0,0,13,0,7,8,1,19},{161,0,0,13,0,7,9,1,19},{161,0,0,15,0,8,-1,1,24},{161,0,0,15,0,8,-1,1,24},{161,0,0,21,0,8,-1,1,4},{161,0,0,21,0,8,-1,1,4},{161,0,0,21,0,8,-1,1,4},{161,0,0,26,0,8,-1,1,24}},
  {{146,0,0,9,0,7,-1,1,2},{146,0,0,9,0,7,-1,1,2},{146,0,0,9,0,7,-1,1,2},{146,0,0,9,0,7,-1,1,2},{146,0,0,9,0,7,-1,1,2},{146,0,0,9,0,7,-1,1,2},{146,0,0,9,0,7,-1,1,2},{146,0,0,9,0,7,-1,1,2},{146,0,0,9,0,7,-1,1,2},{146,0,0,9,0,7,-1,1,2},{146,0,0,9,0,7,-1,1,2},{146,0,0,9,0,7,-1,1,2},{146,0,0,9,0,7,-1,1,2},{146,0,0,9,0,7,-1,1,2},{146,0,0,9,0,7,-1,1,2},{146,0,0,9,0,7,-1,1,2}},
  {{146,0,0,5,0,7,-1,1,2},{146,0,0,5,0,7,-1,1,2},{146,0,0,5,0,7,-1,1,2},{146,0,0,5,0,7,-1,1,2},{146,0,0,5,0,7,-1,1,2},{146,0,0,5,0,7,-1,1,2},{146,0,0,5,0,7,-1,1,2},{146,0,0,5,0,7,-1,1,2},{146,0,0,5,0,7,-1,1,2},{146,0,0,5,0,7,-1,1,2},{146,0,0,5,0,7,-1,1,2},{146,0,0,5,0,7,-1,1,2},{146,0,0,5,0,7,-1,1,2},{146,0,0,5,0,7,-1,1,2},{146,0,0,5,0,7,-1,1,2},{146,0,0,5,0,7,-1,1,2}},
  {{146,0,0,13,0,7,0,1,19},{146,0,0,13,0,7,1,1,19},{146,0,0,13,0,7,2,1,19},{146,0,0,13,0,7,3,1,19},{146,0,0,13,0,7,4,1,19},{146,0,0,13,0,7,5,1,19},{146,0,0,13,0,7,6,1,19},{146,0,0,13,0,7,7,1,19},{146,0,0,13,0,7,8,1,19},{146,0,0,13,0,7,9,1,19},{146,0,0,15,0,8,-1,1,2},{146,0,0,15,0,8,-1,1,2},{146,0,0,15,0,8,-1,1,2},{146,0,0,15,0,8,-1,1,2},{146,0,0,15,0,8,-1,1,2},{146,0,0,15,0,8,-1,1,2}},
  {{146,0,0,15,0,8,-1,1,2},{146,0,0,15,0,8,-1,1,2},{146,0,0,15,0,8,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{146,0,0,7,0,7,-1,1,2}},
  {{165,0,0,7,0,7,-1,1,2},{165,0,0,7,0,7,-1,1,2},{165,0,0,7,0,7,-1,1,2},{165,0,0,7,0,7,-1,1,2},{165,0,0,7,0,7,-1,1,2},{165,0,0,7,0,7,-1,1,2},{165,0,0,7,0,7,-1,1,2},{165,0,0,7,0,7,-1,1,2},{165,0,0,7,0,7,-1,1,2},{165,0,0,7,0,7,-1,1,2},{165,0,0,7,0,7,-1,1,2},{165,0,0,7,0,7,-1,1,2},{165,0,0,7,0,7,-1,1,2},{165,0,0,7,0,7,-1,1,2},{165,0,0,7,0,7,-1,1,2},{165,0,0,7,0,7,-1,1,2}},
  {{165,0,0,7,0,7,-1,1,2},{165,0,0,7,0,7,-1,1,2},{165,0,0,7,0,7,-1,1,2},{165,0,0,7,0,7,-1,1,2},{165,0,0,7,0,7,-1,1,2},{165,0,0,7,0,7,-1,1,2},{165,0,0,7,0,7,-1,1,2},{165,0,0,7,0,7,-1,1,2},{165,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{101,0,0,7,0,7,-1,1,2},{101,0,0,7,0,7,-1,1,2},{101,0,0,7,0,7,-1,1,2},{101,0,0,7,0,7,-1,1,2},{101,0,0,7,0,7,-1,1,2},{101,0,0,7,0,7,-1,1,2},{101,0,0,7,0,7,-1,1,2},{101,0,0,7,0,7,-1,1,2},{101,0,0,7,0,7,-1,1,2},{101,0,0,7,0,7,-1,1,2},{101,0,0,7,0,7,-1,1,2},{101,0,0,7,0,7,-1,1,2},{101,0,0,7,0,7,-1,1,2},{101,0,0,7,0,7,-1,1,2},{101,0,0,7,0,7,-1,1,2},{101,0,0,7,0,7,-1,1,2}},
  {{101,0,0,7,0,7,-1,1,2},{101,0,0,7,0,7,-1,1,2},{101,0,0,7,0,7,-1,1,2},{101,0,0,7,0,7,-1,1,2},{101,0,0,7,0,7,-1,1,2},{101,0,0,7,0,7,-1,1,2},{101,0,0,7,0,7,-1,1,2},{101,0,0,7,0,7,-1,1,2},{101,0,0,7,0,7,-1,1,2},{101,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{101,0,0,14,0,7,-1,1,2},{101,0,0,14,0,7,-1,1,2},{101,0,0,14,0,7,-1,1,2},{101,0,0,14,0,7,-1,1,2},{101,0,0,14,0,7,-1,1,2},{101,0,0,14,0,7,-1,1,2},{101,0,0,14,0,7,-1,1,2},{101,0,0,14,0,7,-1,1,2},{101,0,0,14,0,7,-1,1,2},{101,0,0,14,0,7,-1,1,2},{101,0,0,14,0,7,-1,1,2},{101,0,0,14,0,7,-1,1,2},{101,0,0,14,0,7,-1,1,2},{101,0,0,14,0,7,-1,1,2},{101,0,0,14,0,7,-1,1,2},{101,0,0,14,0,7,-1,1,2}},
  {{101,0,0,14,0,7,-1,1,2},{101,0,0,14,0,7,-1,1,2},{101,0,0,14,0,7,-1,1,2},{101,0,0,14,0,7,-1,1,2},{101,0,0,14,0,7,-1,1,2},{101,0,0,14,0,7,-1,1,2},{101,0,0,14,0,7,-1,1,2},{101,0,0,14,0,7,-1,1,2},{101,0,0,14,0,7,-1,1,2},{101,0,0,14,0,7,-1,1,2},{101,0,0,14,0,7,-1,1,2},{101,0,0,14,0,7,-1,1,2},{101,0,0,14,0,7,-1,1,2},{101,0,0,14,0,7,-1,1,2},{101,0,0,14,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0}},
  {{101,0,0,21,0,8,-1,1,4},{101,0,0,21,0,8,-1,1,4},{101,0,0,21,0,8,-1,1,4},{101,0,0,21,0,8,-1,1,4},{101,0,0,21,0,8,-1,1,4},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{101,0,0,7,0,7,-1,1,2},{101,0,0,7,0,7,-1,1,2},{101,0,0,7,0,7,-1,1,2},{101,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2}},
  {{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,20},{71,0,0,7,0,7,-1,0,20},{71,0,0,7,0,7,-1,0,20},{71,0,0,7,0,7,-1,0,8},{71,0,0,7,0,7,-1,0,8},{71,0,0,7,0,7,-1,0,8},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2}},
  {{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,8},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,20},{71,0,0,7,0,7,-1,0,8},{71,0,0,7,0,7,-1,0,20},{71,0,0,7,0,7,-1,0,8},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2}},
  {{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,20},{71,0,0,7,0,7,-1,0,8},{71,0,0,7,0,7,-1,0,8},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2}},
  {{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{71,0,0,7,0,7,-1,0,2},{103,0,0,2,0,12,-1,0,0}},
  {{156,0,0,7,0,7,-1,1,2},{156,0,0,7,0,7,-1,1,2},{156,0,0,7,0,7,-1,1,2},{156,0,0,7,0,7,-1,1,2},{156,0,0,7,0,7,-1,1,2},{156,0,0,7,0,7,-1,1,2},{156,0,0,7,0,7,-1,1,2},{156,0,0,7,0,7,-1,1,2},{156,0,0,7,0,7,-1,1,2},{156,0,0,7,0,7,-1,1,2},{156,0,0,7,0,7,-1,1,2},{156,0,0,7,0,7,-1,1,2},{156,0,0,7,0,7,-1,1,2},{156,0,0,7,0,7,-1,1,2},{156,0,0,7,0,7,-1,1,2},{156,0,0,7,0,7,-1,1,2}},
  {{156,0,0,7,0,7,-1,1,2},{156,0,0,7,0,7,-1,1,2},{156,0,0,7,0,7,-1,1,2},{156,0,0,7,0,7,-1,1,2},{156,0,0,7,0,7,-1,1,2},{156,0,0,7,0,7,-1,1,2},{156,0,0,7,0,7,-1,1,2},{156,0,0,7,0,7,-1,1,2},{156,0,0,7,0,7,-1,1,2},{156,0,0,7,0,7,-1,1,2},{156,0,0,7,0,7,-1,1,2},{156,0,0,7,0,7,-1,1,2},{156,0,0,7,0,7,-1,1,2},{156,0,0,7,0,7,-1,1,2},{156,0,0,7,0,7,-1,1,20},{156,0,0,7,0,7,-1,1,8}},
  {{156,0,0,7,0,7,-1,1,2},{156,0,0,7,0,7,-1,1,2},{156,0,0,7,0,7,-1,1,2},{156,0,0,7,0,7,-1,1,2},{156,0,0,7,0,7,-1,1,2},{156,0,0,7,0,7,-1,1,2},{156,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{130,0,0,7,0,6,-1,1,2},{130,0,0,7,0,6,-1,1,2},{130,0,0,7,0,6,-1,1,2},{130,0,0,7,0,6,-1,1,2},{130,0,0,7,0,6,-1,1,2},{130,0,0,7,0,6,-1,1,2},{130,0,0,7,0,6,-1,1,2},{130,0,0,7,0,6,-1,1,2},{130,0,0,7,0,6,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{149,0,0,7,0,7,-1,1,2},{149,0,0,7,0,7,-1,1,2},{149,0,0,7,0,7,-1,1,2},{149,0,0,7,0,7,-1,1,2},{149,0,0,7,0,7,-1,1,2},{149,0,0,7,0,7,-1,1,2},{149,0,0,7,0,7,-1,1,2},{149,0,0,7,0,7,-1,1,2},{149,0,0,7,0,7,-1,1,2},{149,0,0,7,0,7,-1,1,2},{149,0,0,7,0,7,-1,1,2},{149,0,0,7,0,7,-1,1,2},{149,0,0,7,0,7,-1,1,2},{149,0,0,7,0,7,-1,1,2},{149,0,0,7,0,7,-1,1,2},{149,0,0,7,0,7,-1,1,2}},
  {{149,0,0,7,0,7,-1,1,2},{149,0,0,7,0,7,-1,1,2},{149,0,0,7,0,7,-1,1,2},{149,0,0,7,0,7,-1,1,2},{149,0,0,7,0,7,-1,1,2},{149,0,0,7,0,7,-1,1,2},{149,0,0,7,0,7,-1,1,2},{149,0,0,7,0,7,-1,1,2},{149,0,0,7,0,7,-1,1,2},{149,0,0,7,0,7,-1,1,2},{149,0,0,7,0,7,-1,1,2},{149,0,0,7,0,7,-1,1,2},{149,0,0,7,0,7,-1,1,2},{149,0,0,7,0,7,-1,1,2},{149,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0}},
  {{149,0,0,13,0,7,0,1,19},{149,0,0,13,0,7,1,1,19},{149,0,0,13,0,7,2,1,19},{149,0,0,13,0,7,3,1,19},{149,0,0,13,0,7,4,1,19},{149,0,0,13,0,7,5,1,19},{149,0,0,13,0,7,6,1,19},{149,0,0,13,0,7,7,1,19},{149,0,0,13,0,7,8,1,19},{149,0,0,13,0,7,9,1,19},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{149,0,0,21,0,8,-1,1,4},{149,0,0,21,0,8,-1,1,4}},
  {{134,0,0,7,0,7,-1,1,2},{134,0,0,7,0,7,-1,1,2},{134,0,0,7,0,7,-1,1,2},{134,0,0,7,0,7,-1,1,2},{134,0,0,7,0,7,-1,1,2},{134,0,0,7,0,7,-1,1,2},{134,0,0,7,0,7,-1,1,2},{134,0,0,7,0,7,-1,1,2},{134,0,0,7,0,7,-1,1,2},{134,0,0,7,0,7,-1,1,2},{134,0,0,7,0,7,-1,1,2},{134,0,0,7,0,7,-1,1,2},{134,0,0,7,0,7,-1,1,2},{134,0,0,7,0,7,-1,1,2},{134,0,0,7,0,7,-1,1,2},{134,0,0,7,0,7,-1,1,2}},
  {{134,0,0,7,0,7,-1,1,2},{134,0,0,7,0,7,-1,1,2},{134,0,0,7,0,7,-1,1,2},{134,0,0,7,0,7,-1,1,2},{134,0,0,7,0,7,-1,1,2},{134,0,0,7,0,7,-1,1,2},{134,0,0,7,0,7,-1,1,2},{134,0,0,7,0,7,-1,1,2},{134,0,0,7,0,7,-1,1,2},{134,0,0,7,0,7,-1,1,2},{134,0,0,7,0,7,-1,1,2},{134,0,0,7,0,7,-1,1,2},{134,0,0,7,0,7,-1,1,2},{134,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{134,0,0,12,17,7,-1,1,9},{134,0,0,12,17,7,-1,1,9},{134,0,0,12,17,7,-1,1,9},{134,0,0,12,17,7,-1,1,9},{134,0,0,12,17,7,-1,1,9},{134,0,0,21,0,8,-1,1,4},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{75,0,0,7,0,7,-1,1,2},{75,0,0,7,0,7,-1,1,2},{75,0,0,7,0,7,-1,1,2},{75,0,0,7,0,7,-1,1,2},{75,0,0,7,0,7,-1,1,2},{75,0,0,7,0,7,-1,1,2},{75,0,0,7,0,7,-1,1,2},{75,0,0,7,0,7,-1,1,2},{75,0,0,7,0,7,-1,1,2},{75,0,0,7,0,7,-1,1,2},{75,0,0,7,0,7,-1,1,2},{75,0,0,7,0,7,-1,1,2},{75,0,0,7,0,7,-1,1,2},{75,0,0,7,0,7,-1,1,2},{75,0,0,7,0,7,-1,1,2},{75,0,0,7,0,7,-1,1,2}},
  {{75,0,0,12,17,7,-1,1,9},{75,0,0,12,17,7,-1,1,9},{75,0,0,12,17,7,-1,1,9},{75,0,0,12,17,7,-1,1,9},{75,0,0,12,17,7,-1,1,9},{75,0,0,12,17,7,-1,1,9},{75,0,0,12,17,7,-1,1,9},{75,0,0,21,0,8,-1,1,4},{75,0,0,21,0,8,-1,1,4},{75,0,0,21,0,8,-1,1,4},{75,0,0,21,0,8,-1,1,2},{75,0,0,21,0,8,-1,1,2},{75,0,0,26,0,8,-1,1,2},{75,0,0,26,0,8,-1,1,2},{75,0,0,26,0,8,-1,1,2},{75,0,0,26,0,8,-1,1,2}},
  {{75,0,0,6,0,7,-1,1,2},{75,0,0,6,0,7,-1,1,2},{75,0,0,6,0,7,-1,1,2},{75,0,0,6,0,7,-1,1,2},{75,0,0,21,0,8,-1,1,4},{75,0,0,26,0,8,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{75,0,0,13,0,7,0,1,19},{75,0,0,13,0,7,1,1,19},{75,0,0,13,0,7,2,1,19},{75,0,0,13,0,7,3,1,19},{75,0,0,13,0,7,4,1,19},{75,0,0,13,0,7,5,1,19},{75,0,0,13,0,7,6,1,19},{75,0,0,13,0,7,7,1,19},{75,0,0,13,0,7,8,1,19},{75,0,0,13,0,7,9,1,19},{103,0,0,2,0,12,-1,1,0},{75,0,0,15,0,8,-1,1,2},{75,0,0,15,0,8,-1,1,2},{75,0,0,15,0,8,-1,1,2},{75,0,0,15,0,8,-1,1,2},{75,0,0,15,0,8,-1,1,2}},
  {{75,0,0,15,0,8,-1,1,2},{75,0,0,15,0,8,-1,1,2},{103,0,0,2,0,12,-1,1,0},{75,0,0,7,0,7,-1,1,2},{75,0,0,7,0,7,-1,1,2},{75,0,0,7,0,7,-1,1,2},{75,0,0,7,0,7,-1,1,2},{75,0,0,7,0,7,-1,1,2},{75,0,0,7,0,7,-1,1,2},{75,0,0,7,0,7,-1,1,2},{75,0,0,7,0,7,-1,1,2},{75,0,0,7,0,7,-1,1,2},{75,0,0,7,0,7,-1,1,2},{75,0,0,7,0,7,-1,1,2},{75,0,0,7,0,7,-1,1,2},{75,0,0,7,0,7,-1,1,2}},
  {{75,0,0,7,0,7,-1,1,2},{75,0,0,7,0,7,-1,1,2},{75,0,0,7,0,7,-1,1,2},{75,0,0,7,0,7,-1,1,2},{75,0,0,7,0,7,-1,1,2},{75,0,0,7,0,7,-1,1,2},{75,0,0,7,0,7,-1,1,2},{75,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{75,0,0,7,0,7,-1,1,2},{75,0,0,7,0,7,-1,1,2},{75,0,0,7,0,7,-1,1,2}},
  {{92,0,0,7,0,5,-1,1,2},{92,0,0,7,0,5,-1,1,2},{92,0,0,7,0,5,-1,1,2},{92,0,0,7,0,5,-1,1,2},{92,0,0,7,0,5,-1,1,2},{92,0,0,7,0,5,-1,1,2},{92,0,0,7,0,5,-1,1,2},{92,0,0,7,0,5,-1,1,2},{92,0,0,7,0,5,-1,1,2},{92,0,0,7,0,5,-1,1,2},{92,0,0,7,0,5,-1,1,2},{92,0,0,7,0,5,-1,1,2},{92,0,0,7,0,5,-1,1,2},{92,0,0,7,0,5,-1,1,2},{92,0,0,7,0,5,-1,1,2},{92,0,0,7,0,5,-1,1,2}},
  {{92,0,0,7,0,5,-1,1,2},{92,0,0,7,0,5,-1,1,2},{92,0,0,7,0,5,-1,1,2},{92,0,0,7,0,5,-1,1,2},{92,0,0,7,0,5,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{92,0,0,7,0,5,-1,1,2},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9}},
  {{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9}},
  {{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{92,0,0,10,0,5,-1,1,9},{103,0,0,2,0,12,-1,1,0}},
  {{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{92,0,0,12,17,5,-1,1,9}},
  {{92,0,0,12,17,5,-1,1,9},{92,0,0,12,17,5,-1,1,9},{92,0,0,12,17,5,-1,1,9},{92,0,0,6,0,5,-1,1,2},{92,0,0,6,0,5,-1,1,2},{92,0,0,6,0,5,-1,1,2},{92,0,0,6,0,5,-1,1,2},{92,0,0,6,0,5,-1,1,2},{92,0,0,6,0,5,-1,1,2},{92,0,0,6,0,5,-1,1,2},{92,0,0,6,0,5,-1,1,2},{92,0,0,6,0,5,-1,1,2},{92,0,0,6,0,5,-1,1,2},{92,0,0,6,0,5,-1,1,2},{92,0,0,6,0,5,-1,1,2},{92,0,0,6,0,5,-1,1,2}},
  {{22,0,1,7,0,4,-1,0,14},{20,0,1,7,0,4,-1,0,14},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0}},
  {{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2}},
  {{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{135,0,0,7,0,7,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{135,0,0,26,0,8,-1,1,2},{135,0,0,12,17,7,-1,1,9},{135,0,0,12,17,7,-1,1,9},{135,0,0,21,0,8,-1,1,4}},
  {{0,0,0,1,18,10,-1,1,9},{0,0,0,1,18,10,-1,1,9},{0,0,0,1,18,10,-1,1,9},{0,0,0,1,18,10,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2}},
  {{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0}},
  {{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2}},
  {{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,9,-1,0,2},{0,0,0,26,0,9,-1,0,2}},
  {{0,0,0,26,0,9,-1,0,2},{0,0,0,26,0,9,-1,0,2},{0,0,0,26,0,9,-1,0,2},{0,0,0,26,0,9,-1,0,2},{0,0,0,26,0,9,-1,0,2},{0,0,0,10,0,7,-1,0,9},{0,0,0,10,0,7,-1,0,9},{1,0,0,12,17,7,-1,0,9},{1,0,0,12,17,7,-1,0,9},{1,0,0,12,17,7,-1,0,9},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,10,0,7,-1,0,9},{0,0,0,10,0,7,-1,0,9},{0,0,0,10,0,7,-1,0,9}},
  {{0,0,0,10,0,7,-1,0,9},{0,0,0,10,0,7,-1,0,9},{0,0,0,10,0,7,-1,0,9},{0,0,0,1,18,10,-1,0,9},{0,0,0,1,18,10,-1,0,9},{0,0,0,1,18,10,-1,0,9},{0,0,0,1,18,10,-1,0,9},{0,0,0,1,18,10,-1,0,9},{0,0,0,1,18,10,-1,0,9},{0,0,0,1,18,10,-1,0,9},{0,0,0,1,18,10,-1,0,9},{1,0,0,12,17,7,-1,0,9},{1,0,0,12,17,7,-1,0,9},{1,0,0,12,17,7,-1,0,9},{1,0,0,12,17,7,-1,0,9},{1,0,0,12,17,7,-1,0,9}},
  {{1,0,0,12,17,7,-1,0,9},{1,0,0,12,17,7,-1,0,9},{1,0,0,12,17,7,-1,0,9},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{1,0,0,12,17,7,-1,0,9},{1,0,0,12,17,7,-1,0,9},{1,0,0,12,17,7,-1,0,9},{1,0,0,12,17,7,-1,0,9},{1,0,0,12,17,7,-1,0,9},{1,0,0,12,17,7,-1,0,9},{1,0,0,12,17,7,-1,0,9},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2}},
  {{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{1,0,0,12,17,7,-1,0,9},{1,0,0,12,17,7,-1,0,9},{1,0,0,12,17,7,-1,0,9},{1,0,0,12,17,7,-1,0,9},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2}},
  {{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,9,-1,0,2},{0,0,0,26,0,9,-1,0,2},{0,0,0,26,0,9,-1,0,2},{0,0,0,26,0,9,-1,0,2},{0,0,0,26,0,9,-1,0,2}},
  {{0,0,0,26,0,9,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2}},
  {{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{0,0,0,26,0,8,-1,0,2},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0}},
  {{14,0,0,26,10,8,-1,1,2},{14,0,0,26,10,8,-1,1,2},{14,0,0,26,10,8,-1,1,2},{14,0,0,26,10,8,-1,1,2},{14,0,0,26,10,8,-1,1,2},{14,0,0,26,10,8,-1,1,2},{14,0,0,26,10,8,-1,1,2},{14,0,0,26,10,8,-1,1,2},{14,0,0,26,10,8,-1,1,2},{14,0,0,26,10,8,-1,1,2},{14,0,0,26,10,8,-1,1,2},{14,0,0,26,10,8,-1,1,2},{14,0,0,26,10,8,-1,1,2},{14,0,0,26,10,8,-1,1,2},{14,0,0,26,10,8,-1,1,2},{14,0,0,26,10,8,-1,1,2}},
  {{14,0,0,26,10,8,-1,1,2},{14,0,0,26,10,8,-1,1,2},{14,0,0,12,17,7,-1,1,9},{14,0,0,12,17,7,-1,1,9},{14,0,0,12,17,7,-1,1,9},{14,0,0,26,10,8,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0}},
  {{0,0,0,15,0,8,-1,0,2},{0,0,0,15,0,8,-1,0,2},{0,0,0,15,0,8,-1,0,2},{0,0,0,15,0,8,-1,0,2},{0,0,0,15,0,8,-1,0,2},{0,0,0,15,0,8,-1,0,2},{0,0,0,15,0,8,-1,0,2},{0,0,0,15,0,8,-1,0,2},{0,0,0,15,0,8,-1,0,2},{0,0,0,15,0,8,-1,0,2},{0,0,0,15,0,8,-1,0,2},{0,0,0,15,0,8,-1,0,2},{0,0,0,15,0,8,-1,0,2},{0,0,0,15,0,8,-1,0,2},{0,0,0,15,0,8,-1,0,2},{0,0,0,15,0,8,-1,0,2}},
  {{0,0,0,15,0,8,-1,0,2},{0,0,0,15,0,8,-1,0,2},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0}},
  {{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2}},
  {{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2}},
  {{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2}},
  {{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2}},
  {{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2}},
  {{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{103,0,0,2,0,12,-1,1,0},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2}},
  {{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2}},
  {{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2}},
  {{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{103,0,0,2,0,12,-1,1,0},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2}},
  {{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{0,0,0,9,0,9,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{103,0,0,2,0,12,-1,1,0},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2}},
  {{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{103,0,0,2,0,12,-1,1,0},{0,0,0,5,0,9,-1,1,2},{103,0,0,2,0,12,-1,1,0},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2}},
  {{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{103,0,0,2,0,12,-1,1,0},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2}},
  {{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{103,0,0,2,0,12,-1,1,0},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2}},
  {{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{103,0,0,2,0,12,-1,1,0},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{103,0,0,2,0,12,-1,1,0},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2}},
  {{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{103,0,0,2,0,12,-1,1,0},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{103,0,0,2,0,12,-1,1,0}},
  {{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{103,0,0,2,0,12,-1,1,0},{0,0,0,9,0,9,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2}},
  {{0,0,0,9,0,9,-1,1,2},{103,0,0,2,0,12,-1,1,0},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2}},
  {{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2}},
  {{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2}},
  {{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2}},
  {{0,0,0,9,0,9,-1,1,2},{0,0,0,25,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2}},
  {{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,25,10,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2}},
  {{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2}},
  {{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,25,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2}},
  {{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,25,10,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2}},
  {{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,25,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2}},
  {{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,25,10,9,-1,1,2}},
  {{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2}},
  {{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,25,0,9,-1,1,2}},
  {{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,25,10,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2}},
  {{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,25,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2}},
  {{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,25,10,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{0,0,0,9,0,9,-1,1,2},{0,0,0,5,0,9,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{0,0,0,13,2,9,0,1,19},{0,0,0,13,2,9,1,1,19}},
  {{0,0,0,13,2,9,2,1,19},{0,0,0,13,2,9,3,1,19},{0,0,0,13,2,9,4,1,19},{0,0,0,13,2,9,5,1,19},{0,0,0,13,2,9,6,1,19},{0,0,0,13,2,9,7,1,19},{0,0,0,13,2,9,8,1,19},{0,0,0,13,2,9,9,1,19},{0,0,0,13,2,9,0,1,19},{0,0,0,13,2,9,1,1,19},{0,0,0,13,2,9,2,1,19},{0,0,0,13,2,9,3,1,19},{0,0,0,13,2,9,4,1,19},{0,0,0,13,2,9,5,1,19},{0,0,0,13,2,9,6,1,19},{0,0,0,13,2,9,7,1,19}},
  {{0,0,0,13,2,9,8,1,19},{0,0,0,13,2,9,9,1,19},{0,0,0,13,2,9,0,1,19},{0,0,0,13,2,9,1,1,19},{0,0,0,13,2,9,2,1,19},{0,0,0,13,2,9,3,1,19},{0,0,0,13,2,9,4,1,19},{0,0,0,13,2,9,5,1,19},{0,0,0,13,2,9,6,1,19},{0,0,0,13,2,9,7,1,19},{0,0,0,13,2,9,8,1,19},{0,0,0,13,2,9,9,1,19},{0,0,0,13,2,9,0,1,19},{0,0,0,13,2,9,1,1,19},{0,0,0,13,2,9,2,1,19},{0,0,0,13,2,9,3,1,19}},
  {{0,0,0,13,2,9,4,1,19},{0,0,0,13,2,9,5,1,19},{0,0,0,13,2,9,6,1,19},{0,0,0,13,2,9,7,1,19},{0,0,0,13,2,9,8,1,19},{0,0,0,13,2,9,9,1,19},{0,0,0,13,2,9,0,1,19},{0,0,0,13,2,9,1,1,19},{0,0,0,13,2,9,2,1,19},{0,0,0,13,2,9,3,1,19},{0,0,0,13,2,9,4,1,19},{0,0,0,13,2,9,5,1,19},{0,0,0,13,2,9,6,1,19},{0,0,0,13,2,9,7,1,19},{0,0,0,13,2,9,8,1,19},{0,0,0,13,2,9,9,1,19}},
  {{112,0,0,26,0,8,-1,1,2},{112,0,0,26,0,8,-1,1,2},{112,0,0,26,0,8,-1,1,2},{112,0,0,26,0,8,-1,1,2},{112,0,0,26,0,8,-1,1,2},{112,0,0,26,0,8,-1,1,2},{112,0,0,26,0,8,-1,1,2},{112,0,0,26,0,8,-1,1,2},{112,0,0,26,0,8,-1,1,2},{112,0,0,26,0,8,-1,1,2},{112,0,0,26,0,8,-1,1,2},{112,0,0,26,0,8,-1,1,2},{112,0,0,26,0,8,-1,1,2},{112,0,0,26,0,8,-1,1,2},{112,0,0,26,0,8,-1,1,2},{112,0,0,26,0,8,-1,1,2}},
  {{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9}},
  {{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,26,0,8,-1,1,2},{112,0,0,26,0,8,-1,1,2},{112,0,0,26,0,8,-1,1,2},{112,0,0,26,0,8,-1,1,2},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9}},
  {{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,26,0,8,-1,1,2},{112,0,0,26,0,8,-1,1,2},{112,0,0,26,0,8,-1,1,2}},
  {{112,0,0,26,0,8,-1,1,2},{112,0,0,26,0,8,-1,1,2},{112,0,0,26,0,8,-1,1,2},{112,0,0,26,0,8,-1,1,2},{112,0,0,26,0,8,-1,1,2},{112,0,0,12,17,7,-1,1,9},{112,0,0,26,0,8,-1,1,2},{112,0,0,26,0,8,-1,1,2},{112,0,0,26,0,8,-1,1,2},{112,0,0,26,0,8,-1,1,2},{112,0,0,26,0,8,-1,1,2},{112,0,0,26,0,8,-1,1,2},{112,0,0,26,0,8,-1,1,2},{112,0,0,26,0,8,-1,1,2},{112,0,0,26,0,8,-1,1,2},{112,0,0,26,0,8,-1,1,2}},
  {{112,0,0,26,0,8,-1,1,2},{112,0,0,26,0,8,-1,1,2},{112,0,0,26,0,8,-1,1,2},{112,0,0,26,0,8,-1,1,2},{112,0,0,12,17,7,-1,1,9},{112,0,0,26,0,8,-1,1,2},{112,0,0,26,0,8,-1,1,2},{112,0,0,21,0,8,-1,1,4},{112,0,0,21,0,8,-1,1,4},{112,0,0,21,0,8,-1,1,4},{112,0,0,21,0,8,-1,1,4},{112,0,0,21,0,8,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9}},
  {{103,0,0,2,0,12,-1,1,0},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9},{112,0,0,12,17,7,-1,1,9}},
  {{140,0,0,7,1,7,-1,1,2},{140,0,0,7,1,7,-1,1,2},{140,0,0,7,1,7,-1,1,2},{140,0,0,7,1,7,-1,1,2},{140,0,0,7,1,7,-1,1,2},{140,0,0,7,1,7,-1,1,2},{140,0,0,7,1,7,-1,1,2},{140,0,0,7,1,7,-1,1,2},{140,0,0,7,1,7,-1,1,2},{140,0,0,7,1,7,-1,1,2},{140,0,0,7,1,7,-1,1,2},{140,0,0,7,1,7,-1,1,2},{140,0,0,7,1,7,-1,1,2},{140,0,0,7,1,7,-1,1,2},{140,0,0,7,1,7,-1,1,2},{140,0,0,7,1,7,-1,1,2}},
  {{140,0,0,7,1,7,-1,1,2},{140,0,0,7,1,7,-1,1,2},{140,0,0,7,1,7,-1,1,2},{140,0,0,7,1,7,-1,1,2},{140,0,0,7,1,7,-1,1,2},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{140,0,0,15,1,8,-1,1,2},{140,0,0,15,1,8,-1,1,2},{140,0,0,15,1,8,-1,1,2},{140,0,0,15,1,8,-1,1,2},{140,0,0,15,1,8,-1,1,2},{140,0,0,15,1,8,-1,1,2},{140,0,0,15,1,8,-1,1,2},{140,0,0,15,1,8,-1,1,2},{140,0,0,15,1,8,-1,1,2}},
  {{140,0,0,12,17,7,-1,1,9},{140,0,0,12,17,7,-1,1,9},{140,0,0,12,17,7,-1,1,9},{140,0,0,12,17,7,-1,1,9},{140,0,0,12,17,7,-1,1,9},{140,0,0,12,17,7,-1,1,9},{140,0,0,12,17,7,-1,1,9},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0},{103,0,0,2,1,12,-1,1,0}},
  {{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{103,0,0,2,13,12,-1,1,0},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2}},
  {{103,0,0,2,13,12,-1,1,0},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{103,0,0,2,13,12,-1,1,0},{2,0,0,7,13,9,-1,1,2},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{2,0,0,7,13,9,-1,1,2},{103,0,0,2,13,12,-1,1,0},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2}},
  {{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{103,0,0,2,13,12,-1,1,0},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{103,0,0,2,13,12,-1,1,0},{2,0,0,7,13,9,-1,1,2},{103,0,0,2,13,12,-1,1,0},{2,0,0,7,13,9,-1,1,2},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0}},
  {{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{2,0,0,7,13,9,-1,1,2},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{2,0,0,7,13,9,-1,1,2},{103,0,0,2,13,12,-1,1,0},{2,0,0,7,13,9,-1,1,2},{103,0,0,2,13,12,-1,1,0},{2,0,0,7,13,9,-1,1,2},{103,0,0,2,13,12,-1,1,0},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2}},
  {{103,0,0,2,13,12,-1,1,0},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{103,0,0,2,13,12,-1,1,0},{2,0,0,7,13,9,-1,1,2},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{2,0,0,7,13,9,-1,1,2},{103,0,0,2,13,12,-1,1,0},{2,0,0,7,13,9,-1,1,2},{103,0,0,2,13,12,-1,1,0},{2,0,0,7,13,9,-1,1,2},{103,0,0,2,13,12,-1,1,0},{2,0,0,7,13,9,-1,1,2},{103,0,0,2,13,12,-1,1,0},{2,0,0,7,13,9,-1,1,2}},
  {{103,0,0,2,13,12,-1,1,0},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{103,0,0,2,13,12,-1,1,0},{2,0,0,7,13,9,-1,1,2},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{103,0,0,2,13,12,-1,1,0},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2}},
  {{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{103,0,0,2,13,12,-1,1,0},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{103,0,0,2,13,12,-1,1,0},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{103,0,0,2,13,12,-1,1,0},{2,0,0,7,13,9,-1,1,2},{103,0,0,2,13,12,-1,1,0}},
  {{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{103,0,0,2,13,12,-1,1,0},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2}},
  {{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0}},
  {{103,0,0,2,13,12,-1,1,0},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{103,0,0,2,13,12,-1,1,0},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{103,0,0,2,13,12,-1,1,0},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2},{2,0,0,7,13,9,-1,1,2}},
  {{2,0,0,25,10,8,-1,1,2},{2,0,0,25,10,8,-1,1,2},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0},{103,0,0,2,13,12,-1,1,0}},
  {{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14}},
  {{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0}},
  {{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0}},
  {{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{103,0,0,2,0,12,-1,0,0}},
  {{103,0,0,2,0,12,-1,0,0},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14}},
  {{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0}},
  {{0,0,0,15,2,9,0,0,1},{0,0,0,15,2,9,0,0,1},{0,0,0,15,2,9,1,0,1},{0,0,0,15,2,9,2,0,1},{0,0,0,15,2,9,3,0,1},{0,0,0,15,2,9,4,0,1},{0,0,0,15,2,9,5,0,1},{0,0,0,15,2,9,6,0,1},{0,0,0,15,2,9,7,0,1},{0,0,0,15,2,9,8,0,1},{0,0,0,15,2,9,9,0,1},{0,0,0,15,10,8,-1,0,1},{0,0,0,15,10,8,-1,0,1},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0}},
  {{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,9,-1,0,2},{103,0,0,2,0,12,-1,0,0}},
  {{0,0,0,26,0,8,-1,0,1},{0,0,0,26,0,8,-1,0,1},{0,0,0,26,0,8,-1,0,1},{0,0,0,26,0,8,-1,0,1},{0,0,0,26,0,8,-1,0,1},{0,0,0,26,0,8,-1,0,1},{0,0,0,26,0,8,-1,0,1},{0,0,0,26,0,8,-1,0,1},{0,0,0,26,0,8,-1,0,1},{0,0,0,26,0,8,-1,0,1},{0,0,0,26,0,8,-1,0,1},{0,0,0,26,0,8,-1,0,1},{0,0,0,26,0,8,-1,0,1},{0,0,0,26,0,8,-1,0,1},{0,0,0,26,0,8,-1,0,1},{0,0,0,26,0,8,-1,0,1}},
  {{0,0,0,26,0,8,-1,0,1},{0,0,0,26,0,8,-1,0,1},{0,0,0,26,0,8,-1,0,1},{0,0,0,26,0,8,-1,0,1},{0,0,0,26,0,8,-1,0,1},{0,0,0,26,0,8,-1,0,1},{0,0,0,26,0,8,-1,0,1},{0,0,0,26,0,8,-1,0,1},{0,0,0,26,0,8,-1,0,1},{0,0,0,26,0,8,-1,0,1},{0,0,0,26,10,9,-1,0,2},{0,0,0,26,10,9,-1,0,2},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0}},
  {{0,0,0,26,0,9,-1,0,1},{0,0,0,26,0,8,-1,0,1},{0,0,0,26,0,8,-1,0,1},{0,0,0,26,0,8,-1,0,1},{0,0,0,26,0,8,-1,0,1},{0,0,0,26,0,8,-1,0,1},{0,0,0,26,0,8,-1,0,1},{0,0,0,26,0,8,-1,0,1},{0,0,0,26,0,8,-1,0,1},{0,0,0,26,0,8,-1,0,1},{0,0,0,26,0,8,-1,0,1},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0}},
  {{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{0,0,0,26,0,8,-1,0,39},{0,0,0,26,0,8,-1,0,39},{0,0,0,26,0,8,-1,0,39},{0,0,0,26,0,8,-1,0,39},{0,0,0,26,0,8,-1,0,39},{0,0,0,26,0,8,-1,0,39},{0,0,0,26,0,8,-1,0,39},{0,0,0,26,0,8,-1,0,39},{0,0,0,26,0,8,-1,0,39},{0,0,0,26,0,8,-1,0,39}},
  {{0,0,0,26,0,8,-1,0,39},{0,0,0,26,0,8,-1,0,39},{0,0,0,26,0,8,-1,0,39},{0,0,0,26,0,8,-1,0,39},{0,0,0,26,0,8,-1,0,39},{0,0,0,26,0,8,-1,0,39},{0,0,0,26,0,8,-1,0,39},{0,0,0,26,0,8,-1,0,39},{0,0,0,26,0,8,-1,0,39},{0,0,0,26,0,8,-1,0,39},{0,0,0,26,0,8,-1,0,39},{0,0,0,26,0,8,-1,0,39},{0,0,0,26,0,8,-1,0,39},{0,0,0,26,0,8,-1,0,39},{0,0,0,26,0,8,-1,0,39},{0,0,0,26,0,8,-1,0,39}},
  {{20,0,1,26,0,9,-1,2,14},{0,0,1,26,0,9,-1,2,14},{0,0,1,26,0,9,-1,0,14},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0}},
  {{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0}},
  {{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0}},
  {{0,0,1,26,0,9,-1,0,14},{0,0,1,26,0,9,-1,0,14},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0}},
  {{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14}},
  {{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14}},
  {{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,24,10,8,-1,0,2},{0,0,0,24,10,8,-1,0,2},{0,0,0,24,10,8,-1,0,2},{0,0,0,24,10,8,-1,0,2},{0,0,0,24,10,8,-1,0,2}},
  {{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,2}},
  {{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14}},
  {{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14}},
  {{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2}},
  {{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14}},
  {{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2}},
  {{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14}},
  {{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{103,0,0,2,0,12,-1,0,0},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14}},
  {{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{103,0,0,2,0,12,-1,0,0},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14}},
  {{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14}},
  {{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14}},
  {{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,23},{0,0,0,26,10,8,-1,0,23},{0,0,0,26,10,8,-1,0,23},{0,0,0,26,10,8,-1,0,18},{0,0,0,26,10,8,-1,0,18},{0,0,0,26,10,8,-1,0,18},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2}},
  {{0,0,0,26,10,8,-1,0,14},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0}},
  {{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{0,0,0,26,10,8,-1,0,14},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0}},
  {{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0}},
  {{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{0,0,0,26,10,8,-1,0,2},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0},{103,0,0,2,0,12,-1,0,0}},
  {{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{0,0,0,26,10,8,-1,1,2},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{0,0,0,26,10,8,-1,1,14},{0,0,0,26,10,8,-1,1,14},{0,0,0,26,10,8,-1,1,14},{0,0,0,26,10,8,-1,1,14},{0,0,0,26,10,8,-1,1,14},{0,0,0,26,10,8,-1,1,14},{0,0,0,26,10,8,-1,1,14},{0,0,0,26,10,8,-1,1,14},{0,0,0,26,10,8,-1,1,14},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{0,0,0,26,10,8,-1,1,14},{0,0,0,26,10,8,-1,1,14},{0,0,0,26,10,8,-1,1,14},{0,0,0,26,10,8,-1,1,14},{0,0,0,26,10,8,-1,1,14},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{0,0,0,26,10,8,-1,1,14},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14}},
  {{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14}},
  {{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14}},
  {{17,0,1,7,0,0,-1,0,14},{17,0,1,7,0,0,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14}},
  {{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,1,2,0,12,-1,0,14},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{103,0,0,2,0,12,-1,1,0},{0,0,0,1,18,11,-1,1,9},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}},
  {{0,0,0,1,18,10,-1,1,9},{0,0,0,1,18,10,-1,1,9},{0,0,0,1,18,10,-1,1,9},{0,0,0,1,18,10,-1,1,9},{0,0,0,1,18,10,-1,1,9},{0,0,0,1,18,10,-1,1,9},{0,0,0,1,18,10,-1,1,9},{0,0,0,1,18,10,-1,1,9},{0,0,0,1,18,10,-1,1,9},{0,0,0,1,18,10,-1,1,9},{0,0,0,1,18,10,-1,1,9},{0,0,0,1,18,10,-1,1,9},{0,0,0,1,18,10,-1,1,9},{0,0,0,1,18,10,-1,1,9},{0,0,0,1,18,10,-1,1,9},{0,0,0,1,18,10,-1,1,9}},
  {{0,0,0,1,18,10,-1,1,9},{0,0,0,1,18,10,-1,1,9},{0,0,0,1,18,10,-1,1,9},{0,0,0,1,18,10,-1,1,9},{0,0,0,1,18,10,-1,1,9},{0,0,0,1,18,10,-1,1,9},{0,0,0,1,18,10,-1,1,9},{0,0,0,1,18,10,-1,1,9},{0,0,0,1,18,10,-1,1,9},{0,0,0,1,18,10,-1,1,9},{0,0,0,1,18,10,-1,1,9},{0,0,0,1,18,10,-1,1,9},{0,0,0,1,18,10,-1,1,9},{0,0,0,1,18,10,-1,1,9},{0,0,0,1,18,10,-1,1,9},{0,0,0,1,18,11,-1,1,9}},
  {{103,0,0,3,0,12,-1,0,0},{103,0,0,3,0,12,-1,0,0},{103,0,0,3,0,12,-1,0,0},{103,0,0,3,0,12,-1,0,0},{103,0,0,3,0,12,-1,0,0},{103,0,0,3,0,12,-1,0,0},{103,0,0,3,0,12,-1,0,0},{103,0,0,3,0,12,-1,0,0},{103,0,0,3,0,12,-1,0,0},{103,0,0,3,0,12,-1,0,0},{103,0,0,3,0,12,-1,0,0},{103,0,0,3,0,12,-1,0,0},{103,0,0,3,0,12,-1,0,0},{103,0,0,3,0,12,-1,0,0},{103,0,0,2,0,12,-1,1,0},{103,0,0,2,0,12,-1,1,0}}
};
#endif


#define kFullWidthMaxPlane  0
#define kFullWidthIndexBits 10
#define kFullWidthCharBits  6
static const uint8_t sFullWidthPages[1024] = {
  0,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,5,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,6,7,8
};

static const uint16_t sFullWidthValues[9][64] = {
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3000,0xff01,0xff02,0xff03,0xff04,0xff05,0xff06,0xff07,0xff08,0xff09,0xff0a,0xff0b,0xff0c,0xff0d,0xff0e,0xff0f,0xff10,0xff11,0xff12,0xff13,0xff14,0xff15,0xff16,0xff17,0xff18,0xff19,0xff1a,0xff1b,0xff1c,0xff1d,0xff1e,0xff1f},
  {0xff20,0xff21,0xff22,0xff23,0xff24,0xff25,0xff26,0xff27,0xff28,0xff29,0xff2a,0xff2b,0xff2c,0xff2d,0xff2e,0xff2f,0xff30,0xff31,0xff32,0xff33,0xff34,0xff35,0xff36,0xff37,0xff38,0xff39,0xff3a,0xff3b,0xff3c,0xff3d,0xff3e,0xff3f,0xff40,0xff41,0xff42,0xff43,0xff44,0xff45,0xff46,0xff47,0xff48,0xff49,0xff4a,0xff4b,0xff4c,0xff4d,0xff4e,0xff4f,0xff50,0xff51,0xff52,0xff53,0xff54,0xff55,0xff56,0xff57,0xff58,0xff59,0xff5a,0xff5b,0xff5c,0xff5d,0xff5e,0x0000},
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffe0,0xffe1,0x0000,0xffe5,0xffe4,0x0000,0x0000,0x0000,0x0000,0x0000,0xffe2,0x0000,0x0000,0xffe3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffe6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
  {0x0000,0x0000,0x0000,0x0000,0x0000,0xff5f,0xff60,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3002,0x300c,0x300d,0x3001,0x30fb,0x30f2,0x30a1,0x30a3,0x30a5,0x30a7,0x30a9,0x30e3,0x30e5,0x30e7,0x30c3,0x30fc,0x30a2,0x30a4,0x30a6,0x30a8,0x30aa,0x30ab,0x30ad,0x30af,0x30b1,0x30b3,0x30b5,0x30b7,0x30b9,0x30bb,0x30bd},
  {0x30bf,0x30c1,0x30c4,0x30c6,0x30c8,0x30ca,0x30cb,0x30cc,0x30cd,0x30ce,0x30cf,0x30d2,0x30d5,0x30d8,0x30db,0x30de,0x30df,0x30e0,0x30e1,0x30e2,0x30e4,0x30e6,0x30e8,0x30e9,0x30ea,0x30eb,0x30ec,0x30ed,0x30ef,0x30f3,0x3099,0x309a,0x3164,0x3131,0x3132,0x3133,0x3134,0x3135,0x3136,0x3137,0x3138,0x3139,0x313a,0x313b,0x313c,0x313d,0x313e,0x313f,0x3140,0x3141,0x3142,0x3143,0x3144,0x3145,0x3146,0x3147,0x3148,0x3149,0x314a,0x314b,0x314c,0x314d,0x314e,0x0000},
  {0x0000,0x0000,0x314f,0x3150,0x3151,0x3152,0x3153,0x3154,0x0000,0x0000,0x3155,0x3156,0x3157,0x3158,0x3159,0x315a,0x0000,0x0000,0x315b,0x315c,0x315d,0x315e,0x315f,0x3160,0x0000,0x0000,0x3161,0x3162,0x3163,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2502,0x2190,0x2191,0x2192,0x2193,0x25a0,0x25cb,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000}
};



#define kFullWidthInverseMaxPlane  0
#define kFullWidthInverseIndexBits 10
#define kFullWidthInverseCharBits  6
static const uint8_t sFullWidthInversePages[1024] = {
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,3,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,6,7,8,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,11,0,12
};

static const uint16_t sFullWidthInverseValues[13][64] = {
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffe9,0xffea,0xffeb,0xffec,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
  {0x0000,0x0000,0xffe8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffed,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffee,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
  {0x0020,0xff64,0xff61,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff62,0xff63,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff9e,0xff9f,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff67,0xff71,0xff68,0xff72,0xff69,0xff73,0xff6a,0xff74,0xff6b,0xff75,0xff76,0x0000,0xff77,0x0000,0xff78,0x0000,0xff79,0x0000,0xff7a,0x0000,0xff7b,0x0000,0xff7c,0x0000,0xff7d,0x0000,0xff7e,0x0000,0xff7f,0x0000,0xff80},
  {0x0000,0xff81,0x0000,0xff6f,0xff82,0x0000,0xff83,0x0000,0xff84,0x0000,0xff85,0xff86,0xff87,0xff88,0xff89,0xff8a,0x0000,0x0000,0xff8b,0x0000,0x0000,0xff8c,0x0000,0x0000,0xff8d,0x0000,0x0000,0xff8e,0x0000,0x0000,0xff8f,0xff90,0xff91,0xff92,0xff93,0xff6c,0xff94,0xff6d,0xff95,0xff6e,0xff96,0xff97,0xff98,0xff99,0xff9a,0xff9b,0x0000,0xff9c,0x0000,0x0000,0xff66,0xff9d,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff65,0xff70,0x0000,0x0000,0x0000},
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffa1,0xffa2,0xffa3,0xffa4,0xffa5,0xffa6,0xffa7,0xffa8,0xffa9,0xffaa,0xffab,0xffac,0xffad,0xffae,0xffaf},
  {0xffb0,0xffb1,0xffb2,0xffb3,0xffb4,0xffb5,0xffb6,0xffb7,0xffb8,0xffb9,0xffba,0xffbb,0xffbc,0xffbd,0xffbe,0xffc2,0xffc3,0xffc4,0xffc5,0xffc6,0xffc7,0xffca,0xffcb,0xffcc,0xffcd,0xffce,0xffcf,0xffd2,0xffd3,0xffd4,0xffd5,0xffd6,0xffd7,0xffda,0xffdb,0xffdc,0xffa0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
  {0x0000,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027,0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,0x002f,0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,0x003f,0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f,0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,0x0058,0x0059,0x005a,0x005b,0x005c,0x005d,0x005e,0x005f},
  {0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,0x006f,0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,0x0078,0x0079,0x007a,0x007b,0x007c,0x007d,0x007e,0x2985,0x2986,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x00a2,0x00a3,0x00ac,0x00af,0x00a6,0x00a5,0x20a9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000}
};


#if !ENABLE_INTL_API
#define kCaseMapMaxPlane  1
#define kCaseMapIndexBits 11
#define kCaseMapCharBits  5
static const uint8_t sCaseMapPlanes[1] = {1};

static const uint8_t sCaseMapPages[2][2048] = {
  {0,0,1,2,0,3,4,5,6,7,8,9,10,11,12,13,6,14,15,16,17,0,0,0,0,0,18,19,20,21,22,23,24,25,26,6,27,6,28,6,6,29,30,31,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,33,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,36,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,0,0,0,0,6,6,6,6,39,6,6,6,40,41,42,43,41,44,45,46,0,0,0,0,0,0,0,0,0,47,48,49,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,52,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,55,56,57,6,6,6,58,59,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,61,62,0,0,0,0,63,6,64,65,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,68,69,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,72,0,0,0,0,0},
  {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,73,74,75,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76,77,78,79,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,81,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
};

static const uint32_t sCaseMapValues[82][32] = {
  {0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x00000000,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x00000000,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x10000329,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x00000000,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x00000000},
  {0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x00000000,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000187},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000159,0x10000178,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x40000003,0x10000003,0x40000007,0x10000007,0x40000003,0x10000003,0x4000007f},
  {0x1000007f,0x40000003,0x10000003,0x40000007,0x10000007,0x40000003,0x10000003,0x4000000f,0x1000000f,0x00000000,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000187,0x40000003,0x10000003,0x40000007,0x10000007,0x40000003,0x10000003,0x1000012c},
  {0x100003c3,0x400003d2,0x40000001,0x10000001,0x40000001,0x10000001,0x400003d2,0x4000000f,0x1000000f,0x400003df,0x400003dd,0x40000007,0x10000007,0x00000000,0x40000053,0x400003d6,0x400003cb,0x40000003,0x10000003,0x400003f3,0x400003f7,0x10000063,0x400003ff,0x400003ff,0x40000001,0x10000001,0x100003a7,0x00000000,0x400003f3,0x400003ef,0x100003be,0x400003ea},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000326,0x4000000f,0x1000000f,0x4000032a,0x00000000,0x00000000,0x40000001,0x10000001,0x40000326,0x4000001f,0x1000001f,0x4000033b,0x40000339,0x40000007,0x10000007,0x40000003,0x10000003,0x40000325,0x40000001,0x10000001,0x00000000,0x00000000,0x40000001,0x10000001,0x00000000,0x10000048},
  {0x00000000,0x00000000,0x00000000,0x00000000,0x40000002,0x80000001,0x20000003,0x4000000e,0x8000000f,0x20000001,0x40000006,0x80000001,0x20000007,0x40000003,0x10000003,0x4000001f,0x1000001f,0x40000003,0x10000003,0x40000007,0x10000007,0x40000003,0x10000003,0x4000000f,0x1000000f,0x40000003,0x10000003,0x40000007,0x10000007,0x10000053,0x40000001,0x10000001},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x40000002,0x80000003,0x20000001,0x40000001,0x10000001,0x40000063,0x40000048,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001},
  {0x400003be,0x00000000,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x40002e5f,0x40000007,0x10000007,0x400003a7,0x40002e58,0x10002e41},
  {0x10002e3f,0x40000003,0x10000003,0x400003c3,0x400000cd,0x400000c9,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x10002e3f,0x10002e3c,0x10002e22,0x100003d2,0x100003d2,0x00000000,0x100003df,0x100003dd,0x00000000,0x100003d6,0x00000000,0x100003cb,0x1000a5f7,0x00000000,0x00000000,0x00000000},
  {0x100003f3,0x1000a5cd,0x00000000,0x100003f7,0x00000000,0x1000a5e8,0x1000a5cc,0x00000000,0x100003ff,0x100003ff,0x00000000,0x10002e09,0x1000a5c1,0x00000000,0x00000000,0x100003f3,0x00000000,0x10002e1f,0x100003ef,0x00000000,0x00000000,0x100003ea,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x10002e19,0x00000000,0x00000000},
  {0x10000326,0x00000000,0x00000000,0x1000032a,0x00000000,0x00000000,0x00000000,0x1000a536,0x10000326,0x100000cd,0x1000033b,0x10000339,0x100000c9,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x10000325,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x1000a52f,0x1000a52e,0x00000000},
  {0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x100000dc,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x00000000,0x40000001,0x10000001,0x00000000,0x00000000,0x00000000,0x10000086,0x10000082,0x10000082,0x00000000,0x4000008c},
  {0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x4000002a,0x00000000,0x40000025,0x40000027,0x40000025,0x00000000,0x40000040,0x00000000,0x40000043,0x40000041,0x00000000,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020},
  {0x40000060,0x40000060,0x00000000,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x1000002a,0x10000025,0x10000027,0x10000025,0x00000000,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020},
  {0x10000060,0x10000060,0x10000061,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000040,0x10000043,0x10000041,0x40000018,0x10000042,0x10000049,0x00000000,0x00000000,0x00000000,0x10000073,0x10000076,0x10000018,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x1000006a,0x10000050,0x1000000b,0x1000008c,0x4000004c,0x10000060,0x00000000,0x4000000f,0x1000000f,0x4000000b,0x40000001,0x10000001,0x00000000,0x40000086,0x40000082,0x40000082},
  {0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020,0x40000020},
  {0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020,0x10000020},
  {0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050},
  {0x40000001,0x10000001,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001},
  {0x4000000f,0x40000003,0x10000003,0x40000007,0x10000007,0x40000003,0x10000003,0x4000000f,0x1000000f,0x40000003,0x10000003,0x40000007,0x10000007,0x40000003,0x10000003,0x1000000f,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050},
  {0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x400000d0,0x400000d0,0x400000d0,0x400000d0,0x400000d0,0x400000d0,0x400000d0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x00000000,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030},
  {0x100000d0,0x100000d0,0x100000d0,0x100000d0,0x100000d0,0x100000d0,0x100000d0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0,0x40003da0},
  {0x40003de0,0x40003de0,0x40003de0,0x40003de0,0x40003de0,0x40003de0,0x00000000,0x40003de0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x40003de0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b8d0,0x4000b830,0x4000b830,0x4000b830,0x4000b830,0x4000b830,0x4000b830,0x4000b830,0x4000b830,0x4000b830,0x4000b830,0x4000b830,0x4000b830,0x4000b830,0x4000b830,0x4000b830,0x4000b830},
  {0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b870,0x4000b870,0x4000b870,0x4000b870,0x4000b870,0x4000b870,0x4000b870,0x4000b870,0x4000b870,0x4000b870,0x4000b870,0x4000b870,0x4000b870,0x4000b870,0x4000b870,0x4000b870},
  {0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x4000b850,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x00000000,0x00000000,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x00000000,0x00000000},
  {0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x1000ba04,0x00000000,0x00000000,0x00000000,0x1000311e,0x00000000,0x00000000},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x100000fb,0x00000000,0x00000000,0x40001e41,0x00000000},
  {0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x00000000,0x00000000,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x00000000,0x00000000},
  {0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008},
  {0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x00000000,0x00000000,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x00000000,0x00000000,0x00000000,0x10000008,0x00000000,0x10000008,0x00000000,0x10000008,0x00000000,0x10000008,0x00000000,0x40000008,0x00000000,0x40000008,0x00000000,0x40000008,0x00000000,0x40000008},
  {0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x100000ca,0x100000ca,0x100000ba,0x100000ba,0x100000be,0x100000be,0x100000ac,0x100000ac,0x10000080,0x10000080,0x10000090,0x10000090,0x10000086,0x10000086,0x00000000,0x00000000},
  {0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x10000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x40000008,0x10000008,0x10000008,0x00000000,0x1000000f,0x00000000,0x00000000,0x00000000,0x00000000,0x40000008,0x40000008,0x400000ca,0x400000ca,0x4000000f,0x00000000,0x10001c27,0x00000000},
  {0x00000000,0x00000000,0x00000000,0x1000000f,0x00000000,0x00000000,0x00000000,0x00000000,0x400000ba,0x400000ba,0x400000be,0x400000be,0x4000000f,0x00000000,0x00000000,0x00000000,0x10000008,0x10000008,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x40000008,0x40000008,0x400000ac,0x400000ac,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x10000008,0x10000008,0x00000000,0x00000000,0x00000000,0x10000009,0x00000000,0x00000000,0x40000008,0x40000008,0x40000090,0x40000090,0x40000009,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x1000000f,0x00000000,0x00000000,0x00000000,0x00000000,0x40000080,0x40000080,0x40000086,0x40000086,0x4000000f,0x00000000,0x00000000,0x00000000},
  {0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x400022ef,0x00000000,0x00000000,0x00000000,0x40002141,0x400021ce,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x4000007c,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x1000007c,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x40000010,0x40000010,0x40000010,0x40000010,0x40000010,0x40000010,0x40000010,0x40000010,0x40000010,0x40000010,0x40000010,0x40000010,0x40000010,0x40000010,0x40000010,0x40000010,0x10000010,0x10000010,0x10000010,0x10000010,0x10000010,0x10000010,0x10000010,0x10000010,0x10000010,0x10000010,0x10000010,0x10000010,0x10000010,0x10000010,0x10000010,0x10000010},
  {0x00000000,0x00000000,0x00000000,0x40000007,0x10000007,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x40000066,0x40000066,0x4000006a,0x4000006a,0x4000006e,0x4000006e,0x4000006a,0x4000006a,0x40000066,0x40000066},
  {0x4000001a,0x4000001a,0x4000001e,0x4000001e,0x4000001a,0x4000001a,0x40000026,0x40000026,0x4000002a,0x4000002a,0x4000002e,0x4000002e,0x4000002a,0x4000002a,0x40000026,0x40000026,0x10000066,0x10000066,0x1000006a,0x1000006a,0x1000006e,0x1000006e,0x1000006a,0x1000006a,0x10000066,0x10000066,0x1000001a,0x1000001a,0x1000001e,0x1000001e,0x1000001a,0x1000001a},
  {0x10000026,0x10000026,0x1000002a,0x1000002a,0x1000002e,0x1000002e,0x1000002a,0x1000002a,0x10000026,0x10000026,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000030,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050,0x40000050},
  {0x40000070,0x40000070,0x40000070,0x40000070,0x40000070,0x40000070,0x40000070,0x40000070,0x40000070,0x40000070,0x40000070,0x40000070,0x40000070,0x40000070,0x40000070,0x00000000,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030,0x10000030},
  {0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000050,0x10000070,0x10000070,0x10000070,0x10000070,0x10000070,0x10000070,0x10000070,0x10000070,0x10000070,0x10000070,0x10000070,0x10000070,0x10000070,0x10000070,0x10000070,0x00000000},
  {0x40000001,0x10000001,0x40002e09,0x4000311e,0x40002e19,0x10002e5f,0x10002e58,0x4000000f,0x1000000f,0x40000003,0x10000003,0x40000007,0x10000007,0x40002e3c,0x40002e1f,0x40002e3f,0x40002e22,0x00000000,0x40000001,0x10000001,0x00000000,0x40000003,0x10000003,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x40002e41,0x40002e3f},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x40000007,0x10000007,0x40000003,0x10000003,0x00000000,0x00000000,0x00000000,0x40000001,0x10000001,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0,0x10003da0},
  {0x10003de0,0x10003de0,0x10003de0,0x10003de0,0x10003de0,0x10003de0,0x00000000,0x10003de0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x10003de0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x00000000,0x00000000,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x00000000,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x40000003,0x10000003,0x40000007,0x10000007,0x4000ba04,0x40000001,0x10000001},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x00000000,0x00000000,0x40000007,0x10000007,0x4000a5e8,0x00000000,0x00000000,0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x00000000,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001},
  {0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x40000001,0x10000001,0x4000a5cc,0x4000a5f7,0x4000a5cd,0x4000a5c1,0x00000000,0x00000000,0x4000a52e,0x4000a536,0x4000a52f,0x40000ce0,0x40000001,0x10000001,0x40000001,0x10000001,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x10000ce0,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x1000b8d0,0x1000b8d0,0x1000b8d0,0x1000b8d0,0x1000b8d0,0x1000b8d0,0x1000b8d0,0x1000b8d0,0x1000b8d0,0x1000b8d0,0x1000b8d0,0x1000b8d0,0x1000b8d0,0x1000b8d0,0x1000b8d0,0x1000b8d0},
  {0x1000b830,0x1000b830,0x1000b830,0x1000b830,0x1000b830,0x1000b830,0x1000b830,0x1000b830,0x1000b830,0x1000b830,0x1000b830,0x1000b830,0x1000b830,0x1000b830,0x1000b830,0x1000b830,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850},
  {0x1000b870,0x1000b870,0x1000b870,0x1000b870,0x1000b870,0x1000b870,0x1000b870,0x1000b870,0x1000b870,0x1000b870,0x1000b870,0x1000b870,0x1000b870,0x1000b870,0x1000b870,0x1000b870,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850,0x1000b850},
  {0x00000000,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x00000000,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x40000028,0x40000028,0x40000028,0x40000028,0x40000028,0x40000028,0x40000028,0x40000028,0x40000038,0x40000038,0x40000038,0x40000038,0x40000038,0x40000038,0x40000038,0x40000038,0x40000028,0x40000028,0x40000028,0x40000028,0x40000028,0x40000028,0x40000028,0x40000028,0x40000058,0x40000058,0x40000058,0x40000058,0x40000058,0x40000058,0x40000058,0x40000058},
  {0x40000068,0x40000068,0x40000068,0x40000068,0x40000068,0x40000068,0x40000068,0x40000068,0x10000028,0x10000028,0x10000028,0x10000028,0x10000028,0x10000028,0x10000028,0x10000028,0x10000038,0x10000038,0x10000038,0x10000038,0x10000038,0x10000038,0x10000038,0x10000038,0x10000028,0x10000028,0x10000028,0x10000028,0x10000028,0x10000028,0x10000028,0x10000028},
  {0x10000058,0x10000058,0x10000058,0x10000058,0x10000058,0x10000058,0x10000058,0x10000058,0x10000068,0x10000068,0x10000068,0x10000068,0x10000068,0x10000068,0x10000068,0x10000068,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040},
  {0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x40000040,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040},
  {0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x10000040,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000,0x00000000},
  {0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060,0x40000060},
  {0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060,0x10000060}
};
#endif
const uint32_t kTitleToUpper = 0x80000000;
const uint32_t kUpperToLower = 0x40000000;
const uint32_t kLowerToTitle = 0x20000000;
const uint32_t kLowerToUpper = 0x10000000;
const uint32_t kCaseMapCharMask = 0x001fffff;

/*
 * * * * * This file contains MACHINE-GENERATED DATA, do not edit! * * * * *
 */
