/*
 * Decompiled with CFR 0.152.
 */
package classycle.renderer;

import classycle.graph.GraphAttributes;
import classycle.graph.NameAttributes;
import classycle.graph.StrongComponent;
import classycle.graph.Vertex;
import classycle.renderer.AbstractStrongComponentRenderer;
import java.text.FieldPosition;
import java.text.MessageFormat;

public class XMLStrongComponentRenderer
extends AbstractStrongComponentRenderer {
    private final int _minimumSize;

    protected String getStrongComponentElementName() {
        return "cycle";
    }

    protected String getNodesElementName() {
        return "classes";
    }

    protected String getNodeElementName() {
        return "classRef";
    }

    protected String getCenterNodesElementName() {
        return "centerClasses";
    }

    protected String getBestFragmentersElementName() {
        return "bestFragmenters";
    }

    private MessageFormat getStrongComponentElementTemplate() {
        return new MessageFormat("    <" + this.getStrongComponentElementName() + " name=\"{0}\" size=\"{1}\" longestWalk=\"{2}\"" + " girth=\"{3}\" radius=\"{4}\" diameter=\"{5}\"" + " bestFragmentSize=\"{6}\">\n");
    }

    private MessageFormat getNodeElementTemplate() {
        return new MessageFormat("        <" + this.getNodeElementName() + " name=\"{0}\"/>\n");
    }

    private MessageFormat getNodeElementTemplateWithEccentricity() {
        return new MessageFormat("        <" + this.getNodeElementName() + " name=\"{0}\" eccentricity=\"{1}\"" + " maximumFragmentSize=\"{2}\"/>\n");
    }

    public XMLStrongComponentRenderer(int minimumSize) {
        this._minimumSize = minimumSize;
    }

    @Override
    public String render(StrongComponent component) {
        StringBuffer result = new StringBuffer();
        if (component.getNumberOfVertices() >= this._minimumSize) {
            Object[] values = new String[7];
            values[0] = XMLStrongComponentRenderer.createName(component);
            values[1] = Integer.toString(component.getNumberOfVertices());
            values[2] = Integer.toString(component.getLongestWalk());
            GraphAttributes attributes = (GraphAttributes)component.getAttributes();
            values[3] = Integer.toString(attributes.getGirth());
            values[4] = Integer.toString(attributes.getRadius());
            values[5] = Integer.toString(attributes.getDiameter());
            values[6] = Integer.toString(attributes.getBestFragmentSize());
            this.getStrongComponentElementTemplate().format(values, result, (FieldPosition)null);
            this.renderClasses(component, result);
            this.renderVertices(attributes.getCenterVertices(), result, this.getCenterNodesElementName());
            this.renderVertices(attributes.getBestFragmenters(), result, this.getBestFragmentersElementName());
            result.append("    </").append(this.getStrongComponentElementName()).append(">\n");
        }
        return new String(result);
    }

    private void renderClasses(StrongComponent component, StringBuffer result) {
        result.append("      <").append(this.getNodesElementName()).append(">\n");
        int[] eccentricities = ((GraphAttributes)component.getAttributes()).getEccentricities();
        int[] maximumFragmentSizes = ((GraphAttributes)component.getAttributes()).getMaximumFragmentSizes();
        Object[] values = new String[3];
        MessageFormat template = this.getNodeElementTemplateWithEccentricity();
        int n = component.getNumberOfVertices();
        for (int i = 0; i < n; ++i) {
            values[0] = ((NameAttributes)component.getVertex(i).getAttributes()).getName();
            values[1] = Integer.toString(eccentricities[i]);
            values[2] = Integer.toString(maximumFragmentSizes[i]);
            template.format(values, result, (FieldPosition)null);
        }
        result.append("      </").append(this.getNodesElementName()).append(">\n");
    }

    private void renderVertices(Vertex[] vertices, StringBuffer result, String tagName) {
        result.append("      <").append(tagName).append(">\n");
        Object[] values = new String[1];
        MessageFormat template = this.getNodeElementTemplate();
        for (int i = 0; i < vertices.length; ++i) {
            values[0] = ((NameAttributes)vertices[i].getAttributes()).getName();
            template.format(values, result, (FieldPosition)null);
        }
        result.append("      </").append(tagName).append(">\n");
    }
}

