#if 0

# *********************************************************
# THIS IS A GENERATED FILE! DO NOT EDIT THIS FILE DIRECTLY!
# *********************************************************
#
#endif

/*
 * Copyright (c) 2011, 2012, 2013 Ali Polatel <alip@exherbo.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef PINK_SYSTEM_H
#define PINK_SYSTEM_H

/**
 * @file pinktrace/system.h
 * @brief Pink's system specific definitions
 *
 * Do not include this file directly. Use pinktrace/pink.h directly.
 *
 * @defgroup pink_system Pink's system specific definitions
 * @ingroup pinktrace
 * @{
 **/

/** Define to 1 if the architecture is x86, 0 otherwise */
#define PINK_ARCH_I386			0
/** Define to 1 if the architecture is x86_64, 0 otherwise */
#define PINK_ARCH_X86_64		1
/** Define to 1 if the architecture is 32bit x86_64, 0 otherwise */
#define PINK_ARCH_X32			0
/** Define to 1 if the architecture is powerpc, 0 otherwise */
#define PINK_ARCH_POWERPC		0
/** Define to 1 if the architecture is powerpc64, 0 otherwise */
#define PINK_ARCH_POWERPC64		0
/** Define to 1 if the architecture is ia64, 0 otherwise */
#define PINK_ARCH_IA64			0
/** Define to 1 if the architecture is arm, 0 otherwise */
#define PINK_ARCH_ARM			0

/** Maximum number of arguments to a system call */
#define PINK_MAX_ARGS			6

/** A "valid" invalid system call number */
#define PINK_SYSCALL_INVALID		0xbadca11

/** Define to 1 if pinktrace supports IPV6, 0 otherwise */
#define PINK_HAVE_IPV6			1
/** Define to 1 if pinktrace supports Netlink, 0 otherwise */
#define PINK_HAVE_NETLINK		0

/**
 * Define to 1 if #PINK_TRACE_OPTION_SYSGOOD is supported, 0 otherwise
 *
 * @note This option is supported on Linux-2.4.6 and newer.
 * @see pink_trace_setup()
 **/
#define PINK_HAVE_OPTION_SYSGOOD	1
/**
 * Define to 1 if #PINK_TRACE_OPTION_FORK is supported, 0 otherwise
 *
 * @note This option is supported on Linux-2.5.46 and newer.
 * @see pink_trace_setup()
 **/
#define PINK_HAVE_OPTION_FORK		1
/**
 * Define to 1 if #PINK_TRACE_OPTION_VFORK is supported, 0 otherwise
 *
 * @note This option is supported on Linux-2.5.46 and newer.
 * @see pink_trace_setup()
 **/
#define PINK_HAVE_OPTION_VFORK		1
/**
 * Define to 1 if #PINK_TRACE_OPTION_CLONE is supported, 0 otherwise
 *
 * @note This option is supported on Linux-2.5.46 and newer.
 * @see pink_trace_setup()
 **/
#define PINK_HAVE_OPTION_CLONE		1
/**
 * Define to 1 if #PINK_TRACE_OPTION_EXEC is supported, 0 otherwise
 *
 * @note This option is supported on Linux-2.5.46 and newer.
 * @see pink_trace_setup()
 **/
#define PINK_HAVE_OPTION_EXEC		1
/**
 * Define to 1 if #PINK_TRACE_OPTION_VFORK_DONE is supported, 0 otherwise
 *
 * @note This option is supported on Linux-2.5.60 and newer.
 * @see pink_trace_setup()
 **/
#define PINK_HAVE_OPTION_VFORK_DONE	1
/**
 * Define to 1 if #PINK_TRACE_OPTION_EXIT is supported, 0 otherwise
 *
 * @note This option is supported on Linux-2.5.60 and newer.
 * @see pink_trace_setup()
 **/
#define PINK_HAVE_OPTION_EXIT		1
/**
 * Define to 1 if #PINK_TRACE_OPTION_SECCOMP is supported, 0 otherwise
 *
 * @note This option is supported on Linux-3.5 and newer.
 * @see pink_trace_setup()
 **/
#define PINK_HAVE_OPTION_SECCOMP	1
/**
 * Define to 1 if #PINK_TRACE_OPTION_EXITKILL is supported, 0 otherwise
 *
 * @note This option is supported on Linux-3.8 and newer.
 * @see pink_trace_setup()
 **/
#define PINK_HAVE_OPTION_EXITKILL	1

/**
 * Define to 1 if pink_trace_setup() is supported, 0 otherwise
 *
 * @note This function is supported on Linux-2.4.6 and newer.
 * @attention If this define is 0, pink_trace_setup() always returns @c -ENOSYS.
 * @see pink_trace_setup()
 **/
#define PINK_HAVE_SETUP			1

/**
 * Define to 1 if pink_trace_geteventmsg() is supported, 0 otherwise
 *
 * @attention If this define is 0, pink_trace_geteventmsg() always returns @c -ENOSYS.
 * @note This function is supported on Linux-2.5.46 and newer.
 * @see pink_trace_geteventmsg()
 **/
#define PINK_HAVE_GETEVENTMSG		1

/**
 * Define to 1 if pink_trace_get_siginfo() is supported, 0 otherwise
 *
 * @attention If this define is 0, pink_trace_get_siginfo always returns @c -ENOSYS.
 * @note This function is supported on Linux-2.3.99-pre6 and newer.
 * @see pink_trace_get_siginfo()
 **/
#define PINK_HAVE_GETSIGINFO		1

/**
 * Define to 1 if pink_trace_get_regset() is supported, 0 otherwise
 *
 * @attention If this define is 0, pink_trace_get_regset always returns @c -ENOSYS.
 * @note This function is supported on Linux-2.6.33 and newer.
 * @see pink_trace_get_regset()
 **/
#define PINK_HAVE_GETREGSET		1
/**
 * Define to 1 if pink_trace_set_regset() is supported, 0 otherwise
 *
 * @attention If this define is 0, pink_trace_set_regset always returns @c -ENOSYS.
 * @note This function is supported on Linux-2.6.33 and newer.
 * @see pink_trace_set_regset()
 **/
#define PINK_HAVE_SETREGSET		1

/**
 * Define to 1 if pink_trace_sysemu() is supported, 0 otherwise
 *
 * @attention If this define is 0, pink_trace_sysemu() always returns -ENOSYS.
 * @note This function is supported on Linux-2.6.14 and newer.
 * @see pink_trace_sysemu()
 **/
#define PINK_HAVE_SYSEMU		0
/**
 * Define to 1 if pink_trace_sysemu_singlestep() is supported, 0 otherwise
 *
 * @attention If this define is 0, pink_trace_sysemu_singlestep() always returns -ENOSYS.
 * @note This function is supported on Linux-2.6.14 and newer.
 * @see pink_trace_sysemu_singlestep()
 **/
#define PINK_HAVE_SYSEMU_SINGLESTEP	0

/**
 * Define to 1 if pink_trace_seize() is supported, 0 otherwise
 *
 * @attention If this define is 0, pink_trace_seize() always returns @c -ENOSYS.
 * @note This function is supported on Linux-3.4 and newer.
 **/
#define PINK_HAVE_SEIZE			1
/**
 * Define to 1 if pink_trace_interrupt() is supported, 0 otherwise
 *
 * @attention If this define is 0, pink_trace_interrupt() always returns @c -ENOSYS.
 * @note This function is supported on Linux-3.4 and newer.
 **/
#define PINK_HAVE_INTERRUPT		1
/**
 * Define to 1 if pink_trace_listen() is supported, 0 otherwise
 *
 * @attention If this define is 0, pink_trace_listen() always returns @c -ENOSYS.
 * @note This function is supported on Linux-3.4 and newer.
 **/
#define PINK_HAVE_LISTEN		1

/**
 * Define to 1 if #PINK_EVENT_FORK is supported, 0 otherwise
 *
 * @note This event is supported on Linux-2.5.46 and newer.
 **/
#define PINK_HAVE_EVENT_FORK		1
/**
 * Define to 1 if #PINK_EVENT_VFORK is supported, 0 otherwise
 *
 * @note This event is supported on Linux-2.5.46 and newer.
 **/
#define PINK_HAVE_EVENT_VFORK		1
/**
 * Define to 1 if #PINK_EVENT_CLONE is supported, 0 otherwise
 *
 * @note This event is supported on Linux-2.5.46 and newer.
 **/
#define PINK_HAVE_EVENT_CLONE		1
/**
 * Define to 1 if #PINK_EVENT_EXEC is supported, 0 otherwise
 *
 * @note This event is supported on Linux-2.5.46 and newer.
 **/
#define PINK_HAVE_EVENT_EXEC		1
/**
 * Define to 1 if #PINK_EVENT_VFORK_DONE is supported, 0 otherwise
 *
 * @note This event is supported on Linux-2.5.60 and newer.
 * @see pink_event_decide()
 **/
#define PINK_HAVE_EVENT_VFORK_DONE	1
/**
 * Define to 1 if #PINK_EVENT_EXIT is supported, 0 otherwise
 *
 * @note This event is supported on Linux-2.5.60 and newer.
 **/
#define PINK_HAVE_EVENT_EXIT		1
/**
 * Define to 1 if #PINK_EVENT_SECCOMP is supported, 0 otherwise
 *
 * @note This event is supported on Linux-3.5 and newer.
 **/
#define PINK_HAVE_EVENT_SECCOMP		1
/**
 * Define to 1 if #PINK_EVENT_STOP is supported, 0 otherwise
 *
 * @note This event is supported on Linux-3.4 and newer.
 **/
#define PINK_HAVE_EVENT_STOP		0

/**
 * Define to 1 if @e tkill(2) system call is available, 0 otherwise
 *
 * @note This system call is supported on Linux-2.5.4 and newer.
 * @see pink_trace_kill()
 **/
#define PINK_HAVE_TKILL			1
/**
 * Define to 1 if @e tgkill(2) system call is available, 0 otherwise
 *
 * @note This system call is supported on Linux-2.5.75 and newer.
 * @see pink_trace_kill()
 **/
#define PINK_HAVE_TGKILL		1

/**
 * Define to 1 if @e process_vm_readv(2) system call is available, 0 otherwise
 *
 * @note This system call is supported on Linux-3.2 and newer.
 * @note The kernel option @e CONFIG_CROSS_MEMORY_ATTACH must be enabled for
 *       this system call to work.
 * @see pink_read_vm_data()
 **/
#define PINK_HAVE_PROCESS_VM_READV	1
/**
 * Define to 1 if @e process_vm_writev(2) system call is available, 0 otherwise
 *
 * @note This system call is supported on Linux-3.2 and newer.
 * @note The kernel option @e CONFIG_CROSS_MEMORY_ATTACH must be enabled for
 *       this system call to work.
 * @see pink_write_vm_data()
 **/
#define PINK_HAVE_PROCESS_VM_WRITEV	1

/** @} */
#endif
