/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.logging;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.logging.ErrorManager;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import org.omegat.util.StaticUtils;

public class OmegaTFileHandler
extends StreamHandler {
    private File lockFile;
    private FileOutputStream lockStream;
    private final long maxSize;
    private final int count;

    public OmegaTFileHandler() throws IOException {
        String maxSizeStr;
        LogManager manager = LogManager.getLogManager();
        String cname = this.getClass().getName();
        String level = manager.getProperty(cname + ".level");
        if (level != null) {
            this.setLevel(Level.parse(level.trim()));
        }
        this.maxSize = (maxSizeStr = manager.getProperty(cname + ".size")) != null ? Long.parseLong(maxSizeStr) : 0x100000L;
        String countStr = manager.getProperty(cname + ".count");
        this.count = countStr != null ? Integer.parseInt(countStr) : 10;
        this.openFiles(new File(StaticUtils.getConfigDir(), "logs"));
    }

    private void openFiles(File dir) throws IOException {
        dir.mkdirs();
        for (int instanceIndex = 0; instanceIndex < 100; ++instanceIndex) {
            String fileName = "OmegaT" + (instanceIndex > 0 ? "-" + instanceIndex : "");
            this.lockFile = new File(dir, fileName + ".log.lck");
            this.lockStream = new FileOutputStream(this.lockFile);
            if (this.lockStream.getChannel().tryLock() == null) continue;
            this.rotate(dir, fileName);
            this.setEncoding("UTF-8");
            this.setOutputStream(new FileOutputStream(new File(dir, fileName + ".log"), true));
            break;
        }
        this.setErrorManager(new ErrorManager());
    }

    public synchronized void close() throws SecurityException {
        try {
            this.lockStream.close();
            this.lockFile.delete();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void rotate(File dir, final String fileName) {
        File logFile = new File(dir, fileName + ".log");
        if (!logFile.exists() || logFile.length() < this.maxSize) {
            return;
        }
        String suffix = new SimpleDateFormat("yyyyMMdd.HHmm").format(new Date());
        File destFile = new File(dir, fileName + '.' + suffix + ".log");
        logFile.renameTo(destFile);
        File[] oldLogs = dir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().startsWith(fileName + '.') && pathname.getName().endsWith(".log");
            }
        });
        if (oldLogs != null) {
            Arrays.sort(oldLogs, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    return o2.getName().compareToIgnoreCase(o1.getName());
                }
            });
            for (int i = this.count; i < oldLogs.length; ++i) {
                oldLogs[i].delete();
            }
        }
    }

    public synchronized void publish(LogRecord record) {
        if (this.isLoggable(record)) {
            super.publish(record);
            this.flush();
        }
    }
}

