/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.gui;

import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;

public class OmegaTFileChooser
extends JFileChooser {
    private static ImageIcon omegatIcon = null;

    public OmegaTFileChooser() {
        this(Preferences.getPreference("current_folder"));
    }

    public OmegaTFileChooser(String path) {
        super(path);
        try {
            if (omegatIcon == null) {
                omegatIcon = new ImageIcon(this.getClass().getResource("/org/omegat/gui/resources/OmegaT_small.gif"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Icon getIcon(File f) {
        if (OmegaTFileChooser.isProjectDir(f) && omegatIcon != null) {
            return omegatIcon;
        }
        return super.getIcon(f);
    }

    public String getTypeDescription(File f) {
        if (OmegaTFileChooser.isProjectDir(f)) {
            return OStrings.getString("PFC_OMEGAT_PROJECT");
        }
        return super.getTypeDescription(f);
    }

    public static boolean isProjectDir(File f) {
        if (f == null || f.getName().length() == 0) {
            return false;
        }
        File projFile = new File(f.getAbsolutePath() + File.separator + "omegat.project");
        File internal = new File(f.getAbsolutePath() + File.separator + "omegat");
        return projFile.exists() && internal.exists() && internal.isDirectory();
    }
}

