/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TMXReader2 {
    private final XMLInputFactory factory;
    private final SimpleDateFormat dateFormat1;
    private final SimpleDateFormat dateFormat2;
    private final SimpleDateFormat dateFormatOut;
    public static final String SEG_PARAGRAPH = "paragraph";
    public static final String SEG_SENTENCE = "sentence";
    public static final String CT_OMEGAT = "OmegaT";
    private XMLEventReader xml;
    private boolean isParagraphSegtype = true;
    private boolean isOmegaT = false;
    private boolean extTmxLevel2;
    private boolean useSlash;
    private boolean isSegmentingEnabled;
    private int errorsCount;
    private int warningsCount;
    ParsedTu currentTu = new ParsedTu();
    StringBuilder propContent = new StringBuilder();
    StringBuilder noteContent = new StringBuilder();
    StringBuilder segContent = new StringBuilder();
    StringBuilder segInlineTag = new StringBuilder();
    Map<String, Integer> pairTags = new TreeMap<String, Integer>();
    public static final EntityResolver TMX_DTD_RESOLVER = new EntityResolver(){

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (systemId.endsWith("tmx11.dtd")) {
                return new InputSource(TMXReader2.class.getResourceAsStream("/schemas/tmx11.dtd"));
            }
            if (systemId.endsWith("tmx14.dtd")) {
                return new InputSource(TMXReader2.class.getResourceAsStream("/schemas/tmx14.dtd"));
            }
            return null;
        }
    };

    public TMXReader2() {
        this.factory = XMLInputFactory.newInstance();
        this.factory.setProperty("javax.xml.stream.isNamespaceAware", false);
        this.factory.setXMLReporter(new XMLReporter(){

            public void report(String message, String error_type, Object info, Location location) throws XMLStreamException {
                Log.logWarningRB("TMXR_WARNING_WHILE_PARSING", String.valueOf(location.getLineNumber()), String.valueOf(location.getColumnNumber()));
                Log.log(message + ": " + info);
                TMXReader2.this.warningsCount++;
            }
        });
        this.dateFormat1 = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'", Locale.ENGLISH);
        this.dateFormat1.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.dateFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ENGLISH);
        this.dateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.dateFormatOut = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'", Locale.ENGLISH);
        this.dateFormatOut.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readTMX(File file, Language sourceLanguage, Language targetLanguage, boolean isSegmentingEnabled, boolean forceOmegaTMX, boolean extTmxLevel2, boolean useSlash, LoadCallback callback) throws Exception {
        this.extTmxLevel2 = extTmxLevel2;
        this.useSlash = useSlash;
        this.isSegmentingEnabled = isSegmentingEnabled;
        Log.logRB("TMXR_INFO_READING_FILE", file.getAbsolutePath());
        boolean allFound = true;
        BufferedInputStream in = file.getName().endsWith(".gz") ? new BufferedInputStream(new GZIPInputStream(new FileInputStream(file))) : new BufferedInputStream(new FileInputStream(file));
        this.xml = this.factory.createXMLEventReader(in);
        try {
            while (this.xml.hasNext()) {
                XMLEvent e = this.xml.nextEvent();
                switch (e.getEventType()) {
                    case 1: {
                        StartElement eStart = (StartElement)e;
                        if ("tu".equals(eStart.getName().getLocalPart())) {
                            this.parseTu(eStart);
                            ParsedTuv origTuv = this.getTuvByLang(sourceLanguage);
                            ParsedTuv targetTuv = this.getTuvByLang(targetLanguage);
                            allFound &= callback.onEntry(this.currentTu, origTuv, targetTuv, this.isParagraphSegtype);
                            break;
                        }
                        if (!"header".equals(eStart.getName().getLocalPart())) break;
                        this.parseHeader(eStart, sourceLanguage);
                    }
                }
            }
        }
        finally {
            this.xml.close();
            ((InputStream)in).close();
        }
        if (!allFound) {
            Log.logWarningRB("TMXR_WARNING_SOURCE_NOT_FOUND", new Object[0]);
            ++this.warningsCount;
        }
        Log.logRB("TMXR_INFO_READING_COMPLETE", new Object[0]);
        Log.log("");
    }

    protected void parseHeader(StartElement element, Language sourceLanguage) {
        this.isParagraphSegtype = SEG_PARAGRAPH.equals(TMXReader2.getAttributeValue(element, "segtype"));
        this.isOmegaT = CT_OMEGAT.equals(TMXReader2.getAttributeValue(element, "creationtool"));
        Log.logRB("TMXR_INFO_CREATION_TOOL", TMXReader2.getAttributeValue(element, "creationtool"));
        Log.logRB("TMXR_INFO_CREATION_TOOL_VERSION", TMXReader2.getAttributeValue(element, "creationtoolversion"));
        Log.logRB("TMXR_INFO_SEG_TYPE", TMXReader2.getAttributeValue(element, "segtype"));
        Log.logRB("TMXR_INFO_SOURCE_LANG", TMXReader2.getAttributeValue(element, "srclang"));
        String tmxSourceLanguage = TMXReader2.getAttributeValue(element, "srclang");
        if (!tmxSourceLanguage.equalsIgnoreCase(sourceLanguage.getLanguage())) {
            Log.logWarningRB("TMXR_WARNING_INCORRECT_SOURCE_LANG", tmxSourceLanguage, sourceLanguage);
        }
        if (this.isSegmentingEnabled && this.isParagraphSegtype) {
            Log.logWarningRB("TMXR_WARNING_UPGRADE_SENTSEG", new Object[0]);
        }
    }

    protected void parseTu(StartElement element) throws Exception {
        this.currentTu.clear();
        this.currentTu.changeid = TMXReader2.getAttributeValue(element, "changeid");
        this.currentTu.changedate = this.parseISO8601date(TMXReader2.getAttributeValue(element, "changedate"));
        this.currentTu.creationid = TMXReader2.getAttributeValue(element, "creationid");
        this.currentTu.creationdate = this.parseISO8601date(TMXReader2.getAttributeValue(element, "creationdate"));
        while (true) {
            XMLEvent e = this.xml.nextEvent();
            switch (e.getEventType()) {
                case 1: {
                    StartElement eStart = (StartElement)e;
                    if ("tuv".equals(eStart.getName().getLocalPart())) {
                        this.parseTuv(eStart);
                        break;
                    }
                    if ("prop".equals(eStart.getName().getLocalPart())) {
                        this.parseProp(eStart);
                        break;
                    }
                    if (!"note".equals(eStart.getName().getLocalPart())) break;
                    this.parseNote(eStart);
                    break;
                }
                case 2: {
                    EndElement eEnd = (EndElement)e;
                    if (!"tu".equals(eEnd.getName().getLocalPart())) break;
                    return;
                }
            }
        }
    }

    protected void parseTuv(StartElement element) throws Exception {
        ParsedTuv tuv = new ParsedTuv();
        this.currentTu.tuvs.add(tuv);
        tuv.changeid = TMXReader2.getAttributeValue(element, "changeid");
        tuv.changedate = this.parseISO8601date(TMXReader2.getAttributeValue(element, "changedate"));
        tuv.creationid = TMXReader2.getAttributeValue(element, "creationid");
        tuv.creationdate = this.parseISO8601date(TMXReader2.getAttributeValue(element, "creationdate"));
        Iterator<Attribute> it = element.getAttributes();
        while (it.hasNext()) {
            Attribute a = it.next();
            if (!"lang".equals(a.getName().getLocalPart())) continue;
            tuv.lang = a.getValue();
            break;
        }
        while (true) {
            XMLEvent e = this.xml.nextEvent();
            switch (e.getEventType()) {
                case 1: {
                    StartElement eStart = (StartElement)e;
                    if (!"seg".equals(eStart.getName().getLocalPart())) break;
                    if (this.isOmegaT) {
                        this.parseSegOmegaT();
                    } else if (this.extTmxLevel2) {
                        this.parseSegExtLevel2();
                    } else {
                        this.parseSegExtLevel1();
                    }
                    tuv.text = this.segContent.toString();
                    break;
                }
                case 2: {
                    EndElement eEnd = (EndElement)e;
                    if (!"tuv".equals(eEnd.getName().getLocalPart())) break;
                    return;
                }
            }
        }
    }

    protected void parseNote(StartElement element) throws Exception {
        this.noteContent.setLength(0);
        while (true) {
            XMLEvent e = this.xml.nextEvent();
            switch (e.getEventType()) {
                case 2: {
                    EndElement eEnd = (EndElement)e;
                    if (!"note".equals(eEnd.getName().getLocalPart())) break;
                    this.currentTu.note = this.noteContent.toString();
                    return;
                }
                case 4: {
                    Characters c = (Characters)e;
                    this.noteContent.append(c.getData());
                }
            }
        }
    }

    protected void parseProp(StartElement element) throws Exception {
        String propType = TMXReader2.getAttributeValue(element, "type");
        this.propContent.setLength(0);
        while (true) {
            XMLEvent e = this.xml.nextEvent();
            switch (e.getEventType()) {
                case 2: {
                    EndElement eEnd = (EndElement)e;
                    if (!"prop".equals(eEnd.getName().getLocalPart())) break;
                    this.currentTu.props.put(propType, this.propContent.toString());
                    return;
                }
                case 4: {
                    Characters c = (Characters)e;
                    this.propContent.append(c.getData());
                }
            }
        }
    }

    protected void parseSegOmegaT() throws Exception {
        this.segContent.setLength(0);
        while (true) {
            XMLEvent e = this.xml.nextEvent();
            switch (e.getEventType()) {
                case 2: {
                    EndElement eEnd = (EndElement)e;
                    if (!"seg".equals(eEnd.getName().getLocalPart())) break;
                    return;
                }
                case 4: {
                    Characters c = (Characters)e;
                    this.segContent.append(c.getData());
                }
            }
        }
    }

    protected void parseSegExtLevel1() throws Exception {
        this.segContent.setLength(0);
        int inlineLevel = 0;
        while (true) {
            XMLEvent e = this.xml.nextEvent();
            switch (e.getEventType()) {
                case 1: {
                    ++inlineLevel;
                    break;
                }
                case 2: {
                    --inlineLevel;
                    EndElement eEnd = (EndElement)e;
                    if (!"seg".equals(eEnd.getName().getLocalPart())) break;
                    return;
                }
                case 4: {
                    if (inlineLevel != 0) break;
                    Characters c = (Characters)e;
                    this.segContent.append(c.getData());
                }
            }
        }
    }

    protected void parseSegExtLevel2() throws Exception {
        this.segContent.setLength(0);
        this.segInlineTag.setLength(0);
        this.pairTags.clear();
        int tagNumber = 0;
        int inlineLevel = 0;
        String currentI = null;
        String currentPos = null;
        block8: while (true) {
            XMLEvent e = this.xml.nextEvent();
            switch (e.getEventType()) {
                case 1: {
                    StartElement eStart = e.asStartElement();
                    if ("hi".equals(eStart.getName().getLocalPart())) continue block8;
                    ++inlineLevel;
                    this.segInlineTag.setLength(0);
                    if ("bpt".equals(eStart.getName().getLocalPart())) {
                        currentI = TMXReader2.getAttributeValue(eStart, "i");
                        this.pairTags.put(currentI, tagNumber);
                        ++tagNumber;
                        break;
                    }
                    if ("ept".equals(eStart.getName().getLocalPart())) {
                        currentI = TMXReader2.getAttributeValue(eStart, "i");
                        break;
                    }
                    if ("it".equals(eStart.getName().getLocalPart())) {
                        currentPos = TMXReader2.getAttributeValue(eStart, "pos");
                        break;
                    }
                    currentI = null;
                    break;
                }
                case 2: {
                    Integer tagN;
                    EndElement eEnd = e.asEndElement();
                    if ("hi".equals(eEnd.getName().getLocalPart())) continue block8;
                    --inlineLevel;
                    if ("seg".equals(eEnd.getName().getLocalPart())) {
                        return;
                    }
                    boolean slashBefore = false;
                    boolean slashAfter = false;
                    char tagName = TMXReader2.getFirstLetter(this.segInlineTag);
                    if ("bpt".equals(eEnd.getName().getLocalPart())) {
                        tagN = this.pairTags.get(currentI);
                    } else if ("ept".equals(eEnd.getName().getLocalPart())) {
                        slashBefore = true;
                        tagN = this.pairTags.get(currentI);
                    } else if ("it".equals(eEnd.getName().getLocalPart())) {
                        tagN = tagNumber;
                        if ("end".equals(currentPos)) {
                            slashBefore = true;
                        } else if (this.useSlash) {
                            slashAfter = true;
                        }
                    } else {
                        tagN = tagNumber;
                        if (this.useSlash) {
                            slashAfter = true;
                        }
                    }
                    if (tagN == null) {
                        Log.logErrorRB("TMX_ERROR_READING_LEVEL2", e.getLocation().getLineNumber(), e.getLocation().getColumnNumber());
                        ++this.errorsCount;
                        this.segContent.setLength(0);
                        while (true) {
                            XMLEvent ev = this.xml.nextEvent();
                            switch (ev.getEventType()) {
                                case 2: {
                                    EndElement evEnd = (EndElement)ev;
                                    if (!"seg".equals(evEnd.getName().getLocalPart())) break;
                                    return;
                                }
                            }
                        }
                    }
                    this.segContent.append('<');
                    if (slashBefore) {
                        this.segContent.append('/');
                    }
                    this.segContent.append(tagName);
                    this.segContent.append(Integer.toString(tagN));
                    if (slashAfter) {
                        this.segContent.append('/');
                    }
                    this.segContent.append('>');
                    break;
                }
                case 4: {
                    Characters c = (Characters)e;
                    if (inlineLevel == 0) {
                        this.segContent.append(c.getData());
                        break;
                    }
                    this.segInlineTag.append(c.getData());
                }
            }
        }
    }

    protected static char getFirstLetter(StringBuilder s) {
        char f = '\u0000';
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isLetter(s.charAt(i))) continue;
            f = Character.toLowerCase(s.charAt(i));
            break;
        }
        return f != '\u0000' ? f : (char)'f';
    }

    protected ParsedTuv getTuvByLang(Language lang) {
        String langLanguage = lang.getLanguageCode();
        String langCountry = lang.getCountryCode();
        ParsedTuv tuvLC = null;
        ParsedTuv tuvL = null;
        ParsedTuv tuvLW = null;
        for (int i = 0; i < this.currentTu.tuvs.size(); ++i) {
            ParsedTuv tuv = this.currentTu.tuvs.get(i);
            String tuvLang = tuv.lang;
            if (!langLanguage.regionMatches(true, 0, tuvLang, 0, 2)) continue;
            if (tuvLang.length() < 3) {
                tuvL = tuv;
                continue;
            }
            if (langCountry.regionMatches(true, 0, tuvLang, 3, 2)) {
                tuvLC = tuv;
                continue;
            }
            tuvLW = tuv;
        }
        ParsedTuv bestTuv = tuvLC != null ? tuvLC : (tuvL != null ? tuvL : tuvLW);
        return bestTuv;
    }

    public long parseISO8601date(String str) {
        if (str == null) {
            return 0L;
        }
        try {
            return this.dateFormat1.parse(str).getTime();
        }
        catch (ParseException ex) {
            try {
                return this.dateFormat2.parse(str).getTime();
            }
            catch (ParseException parseException) {
                return 0L;
            }
        }
    }

    private static String getAttributeValue(StartElement e, String attrName) {
        Attribute a = e.getAttributeByName(new QName(attrName));
        return a != null ? a.getValue() : null;
    }

    public static class ParsedTuv {
        public String lang;
        public String changeid;
        public long changedate;
        public String creationid;
        public long creationdate;
        public String text;
    }

    public static class ParsedTu {
        public String changeid;
        public long changedate;
        public String creationid;
        public long creationdate;
        public String note;
        public Map<String, String> props = new TreeMap<String, String>();
        public List<ParsedTuv> tuvs = new ArrayList<ParsedTuv>();

        void clear() {
            this.changeid = null;
            this.changedate = 0L;
            this.creationid = null;
            this.creationdate = 0L;
            this.props = new TreeMap<String, String>();
            this.tuvs = new ArrayList<ParsedTuv>();
            this.note = null;
        }
    }

    public static interface LoadCallback {
        public boolean onEntry(ParsedTu var1, ParsedTuv var2, ParsedTuv var3, boolean var4);
    }
}

