/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import gen.core.project.Omegat;
import gen.core.project.Project;
import java.io.File;
import java.io.IOException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.segmentation.SRX;
import org.omegat.filters2.TranslationException;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;

public class ProjectFileStorage {
    private static final JAXBContext CONTEXT;

    public static ProjectProperties loadProjectProperties(File projectDir) throws Exception {
        ProjectProperties result = new ProjectProperties(projectDir);
        File inFile = new File(projectDir, "omegat.project");
        Omegat om = (Omegat)CONTEXT.createUnmarshaller().unmarshal(inFile);
        if (!"1.0".equals(om.getProject().getVersion())) {
            throw new TranslationException(StaticUtils.format(OStrings.getString("PFR_ERROR_UNSUPPORTED_PROJECT_VERSION"), om.getProject().getVersion()));
        }
        String m_root = inFile.getParentFile().getAbsolutePath() + File.separator;
        result.setTargetRoot(ProjectFileStorage.computeAbsolutePath(m_root, om.getProject().getTargetDir(), "target"));
        result.setSourceRoot(ProjectFileStorage.computeAbsolutePath(m_root, om.getProject().getSourceDir(), "source"));
        result.setTMRoot(ProjectFileStorage.computeAbsolutePath(m_root, om.getProject().getTmDir(), "tm"));
        result.setGlossaryRoot(ProjectFileStorage.computeAbsolutePath(m_root, om.getProject().getGlossaryDir(), "glossary"));
        String glossaryFile = om.getProject().getGlossaryFile();
        String glossaryDir = null;
        glossaryDir = glossaryFile != null ? new File(glossaryFile).getParent() : result.getGlossaryRoot();
        if (glossaryDir == null) {
            glossaryDir = ".";
        }
        glossaryDir = ProjectFileStorage.computeAbsolutePath(m_root, glossaryDir, "glossary");
        glossaryFile = om.getProject().getGlossaryFile();
        if (glossaryFile == null) {
            glossaryFile = "__DEFAULT__";
        }
        if (glossaryFile.equalsIgnoreCase("__DEFAULT__")) {
            glossaryDir = result.getGlossaryRoot();
            if (!glossaryDir.endsWith(File.separator)) {
                glossaryDir = glossaryDir + File.separator;
            }
            glossaryFile = glossaryDir + result.getProjectName() + "-glossary.txt";
        } else {
            glossaryFile = glossaryDir + new File(glossaryFile).getName();
        }
        result.setWriteableGlossary(glossaryFile);
        result.setDictRoot(ProjectFileStorage.computeAbsolutePath(m_root, om.getProject().getDictionaryDir(), "dictionary"));
        result.setSourceLanguage(om.getProject().getSourceLang());
        result.setTargetLanguage(om.getProject().getTargetLang());
        if (om.getProject().isSentenceSeg() != null) {
            result.setSentenceSegmentingEnabled(om.getProject().isSentenceSeg());
        }
        if (om.getProject().isSupportDefaultTranslations() != null) {
            result.setSupportDefaultTranslations(om.getProject().isSupportDefaultTranslations());
        }
        if (om.getProject().isRemoveTags() != null) {
            result.setRemoveTags(om.getProject().isRemoveTags());
        }
        if (om.getProject().getExternalCommand() != null) {
            result.setExternalCommand(om.getProject().getExternalCommand());
        }
        return result;
    }

    public static void writeProjectFile(ProjectProperties props) throws Exception {
        File outFile = new File(props.getProjectRoot(), "omegat.project");
        String m_root = outFile.getParentFile().getAbsolutePath() + File.separator;
        Omegat om = new Omegat();
        om.setProject(new Project());
        om.getProject().setVersion("1.0");
        om.getProject().setSourceDir(ProjectFileStorage.computeRelativePath(m_root, props.getSourceRoot(), "source"));
        om.getProject().setTargetDir(ProjectFileStorage.computeRelativePath(m_root, props.getTargetRoot(), "target"));
        om.getProject().setTmDir(ProjectFileStorage.computeRelativePath(m_root, props.getTMRoot(), "tm"));
        om.getProject().setGlossaryDir(ProjectFileStorage.computeRelativePath(m_root, props.getGlossaryRoot(), "glossary"));
        String glossaryFile = new File(props.getWriteableGlossary()).getName();
        String glossaryDir = ProjectFileStorage.computeRelativePath(m_root, props.getGlossaryRoot(), "glossary");
        if (glossaryDir.equalsIgnoreCase("__DEFAULT__")) {
            if (!props.getWriteableGlossary().equalsIgnoreCase(props.getGlossaryRoot() + props.getProjectName() + "-glossary.txt")) {
                glossaryDir = props.getWriteableGlossaryDir();
                if (!StringUtil.isEmpty(glossaryDir = ProjectFileStorage.computeRelativePath(m_root, glossaryDir, "glossary"))) {
                    glossaryDir = glossaryDir + "/";
                }
                glossaryFile = glossaryDir + glossaryFile;
            } else {
                glossaryFile = "__DEFAULT__";
            }
        } else {
            if (!glossaryDir.endsWith(File.separator)) {
                glossaryDir = glossaryDir + "/";
            }
            glossaryFile = glossaryDir + glossaryFile;
        }
        om.getProject().setGlossaryFile(glossaryFile);
        om.getProject().setDictionaryDir(ProjectFileStorage.computeRelativePath(m_root, props.getDictRoot(), "dictionary"));
        om.getProject().setSourceLang(props.getSourceLanguage().toString());
        om.getProject().setTargetLang(props.getTargetLanguage().toString());
        om.getProject().setSentenceSeg(props.isSentenceSegmentingEnabled());
        om.getProject().setSupportDefaultTranslations(props.isSupportDefaultTranslations());
        om.getProject().setRemoveTags(props.isRemoveTags());
        om.getProject().setExternalCommand(props.getExternalCommand());
        Marshaller m = CONTEXT.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)true);
        m.marshal((Object)om, outFile);
        SRX.saveTo(props.getProjectSRX(), new File(props.getProjectInternal(), "segmentation.conf"));
    }

    private static String computeAbsolutePath(String m_root, String relativePath, String defaultName) {
        if (relativePath == null) {
            return m_root + defaultName + File.separator;
        }
        if ("__DEFAULT__".equals(relativePath)) {
            return m_root + defaultName + File.separator;
        }
        try {
            boolean startsWithRoot = false;
            for (File root : File.listRoots()) {
                try {
                    String platformRelativePath = relativePath.replace('/', File.separatorChar);
                    startsWithRoot = platformRelativePath.startsWith(root.getCanonicalPath());
                }
                catch (IOException e) {
                    startsWithRoot = false;
                }
                if (!startsWithRoot) continue;
                return new File(relativePath).getCanonicalPath() + File.separator;
            }
            return new File(m_root, relativePath).getCanonicalPath() + File.separator;
        }
        catch (IOException e) {
            return relativePath;
        }
    }

    private static String computeRelativePath(String m_root, String absolutePath, String defaultName) {
        if (absolutePath.equals(m_root + defaultName + File.separator)) {
            return "__DEFAULT__";
        }
        try {
            String res = absolutePath;
            File abs = new File(absolutePath).getCanonicalFile();
            File root = new File(m_root).getCanonicalFile();
            String prefix = new String();
            for (int i = 0; i < 2; ++i) {
                if ((abs.getPath() + File.separator).startsWith(root.getPath() + File.separator)) {
                    res = prefix + abs.getPath().substring(root.getPath().length());
                    if (!res.startsWith(File.separator)) break;
                    res = res.substring(1);
                    break;
                }
                root = root.getParentFile();
                prefix = prefix + File.separator + "..";
            }
            return res.replace(File.separatorChar, '/');
        }
        catch (IOException e) {
            return absolutePath.replace(File.separatorChar, '/');
        }
    }

    static {
        try {
            CONTEXT = JAXBContext.newInstance((Class[])new Class[]{Omegat.class});
        }
        catch (Exception ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }
}

