/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.omegat.util.StaticUtils;

public class OStrings {
    private static String __VERSION_KEY = "version";
    private static String __UPDATE_KEY = "update";
    public static final String VERSION = ResourceBundle.getBundle("org/omegat/Version").getString(__VERSION_KEY);
    public static final String UPDATE = ResourceBundle.getBundle("org/omegat/Version").getString(__UPDATE_KEY);
    private static ResourceBundle bundle = ResourceBundle.getBundle("org/omegat/Bundle");

    public static ResourceBundle getResourceBundle() {
        return bundle;
    }

    public static void loadBundle(String filename) {
        boolean loaded = false;
        try {
            FileInputStream in = new FileInputStream(filename);
            bundle = new PropertyResourceBundle(in);
            loaded = true;
            in.close();
        }
        catch (FileNotFoundException exception) {
            System.err.println("Resource bundle file not found: " + filename);
        }
        catch (IOException exception) {
            System.err.println("Error while reading resource bundle file: " + filename);
        }
        if (!loaded) {
            System.err.println("Reverting to resource bundle for the default locale");
            bundle = ResourceBundle.getBundle("org/omegat/Bundle");
        }
    }

    public static String getString(String key) {
        return bundle.getString(key);
    }

    public static String getDisplayVersion() {
        return UPDATE != null && !UPDATE.equals("0") ? StaticUtils.format(OStrings.getString("version-update-template"), VERSION, UPDATE) : StaticUtils.format(OStrings.getString("version-template"), VERSION, UPDATE);
    }

    public static String getSegmentMarker() {
        return OStrings.getString("TF_CUR_SEGMENT_START");
    }
}

