/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;

public class LFileCopy {
    private static int BUFSIZE = 1024;

    public static void copy(String src, String dest) throws IOException {
        File ifp = new File(src);
        File ofp = new File(dest);
        LFileCopy.copy(ifp, ofp);
    }

    public static void copy(File src, File dest) throws IOException {
        int readBytes;
        if (!src.exists()) {
            throw new IOException(StaticUtils.format(OStrings.getString("LFC_ERROR_FILE_DOESNT_EXIST"), src.getAbsolutePath()));
        }
        FileInputStream fis = new FileInputStream(src);
        dest.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(dest);
        byte[] b = new byte[BUFSIZE];
        while ((readBytes = fis.read(b)) > 0) {
            fos.write(b, 0, readBytes);
        }
        fis.close();
        fos.close();
    }

    public static void copy(InputStream src, File dest) throws IOException {
        int readBytes;
        dest.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(dest);
        byte[] b = new byte[BUFSIZE];
        while ((readBytes = src.read(b)) > 0) {
            fos.write(b, 0, readBytes);
        }
        fos.close();
    }

    public static void copy(InputStream src, OutputStream dest) throws IOException {
        int readBytes;
        byte[] b = new byte[BUFSIZE];
        while ((readBytes = src.read(b)) > 0) {
            dest.write(b, 0, readBytes);
        }
    }

    public static void copy(Reader src, Writer dest) throws IOException {
        int readChars;
        char[] b = new char[BUFSIZE];
        while ((readChars = src.read(b)) > 0) {
            dest.write(b, 0, readChars);
        }
    }

    public static void copy(File src, OutputStream dest) throws IOException {
        int readBytes;
        if (!src.exists()) {
            throw new IOException(StaticUtils.format(OStrings.getString("LFC_ERROR_FILE_DOESNT_EXIST"), src.getAbsolutePath()));
        }
        FileInputStream fis = new FileInputStream(src);
        byte[] b = new byte[BUFSIZE];
        while ((readBytes = fis.read(b)) > 0) {
            dest.write(b, 0, readBytes);
        }
        fis.close();
    }
}

