/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.tagvalidation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.IProject;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.filters2.po.PoFilter;
import org.omegat.gui.main.MainWindow;
import org.omegat.gui.tagvalidation.ITagValidation;
import org.omegat.gui.tagvalidation.TagValidationFrame;
import org.omegat.util.OStrings;
import org.omegat.util.PatternConsts;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagValidationTool
implements ITagValidation,
IProjectEventListener {
    private TagValidationFrame m_tagWin;
    private MainWindow mainWindow;

    public TagValidationTool(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        CoreEvents.registerProjectChangeListener(this);
    }

    public TagValidationTool() {
        CoreEvents.registerProjectChangeListener(this);
    }

    @Override
    public boolean validateTags() {
        List<SourceTextEntry> suspects = this.listInvalidTags();
        if (this.mainWindow != null) {
            return this.showTagResultsInGui(suspects);
        }
        return this.showTagResultsInConsole(suspects);
    }

    private boolean showTagResultsInGui(List<SourceTextEntry> suspects) {
        if (suspects.size() > 0) {
            if (this.m_tagWin == null) {
                this.m_tagWin = new TagValidationFrame(this.mainWindow);
                this.m_tagWin.setFont(Core.getMainWindow().getApplicationFont());
            } else {
                this.m_tagWin.dispose();
            }
            this.m_tagWin.setVisible(true);
            this.m_tagWin.displayStringList(suspects);
            return false;
        }
        if (this.m_tagWin != null) {
            this.m_tagWin.dispose();
        }
        JOptionPane.showMessageDialog(Core.getMainWindow().getApplicationFrame(), OStrings.getString("TF_NOTICE_OK_TAGS"), OStrings.getString("TF_NOTICE_TITLE_TAGS"), 1);
        return true;
    }

    private boolean showTagResultsInConsole(List<SourceTextEntry> suspects) {
        if (suspects.size() > 0) {
            for (SourceTextEntry ste : suspects) {
                String src = ste.getSrcText();
                TMXEntry trans = Core.getProject().getTranslationInfo(ste);
                if (src.length() <= 0 || !trans.isTranslated()) continue;
                System.out.println(ste.entryNum());
                System.out.println(src);
                System.out.println(trans.translation);
            }
            return false;
        }
        return true;
    }

    @Override
    public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
        switch (eventType) {
            case CLOSE: {
                if (this.m_tagWin == null) break;
                this.m_tagWin.dispose();
            }
        }
    }

    private List<SourceTextEntry> listInvalidTags() {
        ArrayList<String> srcTags = new ArrayList<String>(32);
        ArrayList<String> locTags = new ArrayList<String>(32);
        ArrayList<SourceTextEntry> suspects = new ArrayList<SourceTextEntry>(16);
        Pattern printfPattern = null;
        if ("true".equalsIgnoreCase(Preferences.getPreference("tagValidation_elaborateCheck"))) {
            printfPattern = PatternConsts.PRINTF_VARS;
        } else if ("true".equalsIgnoreCase(Preferences.getPreference("tagValidation_simpleCheck"))) {
            printfPattern = PatternConsts.SIMPLE_PRINTF_VARS;
        }
        Pattern javaMessageFormatPattern = null;
        if ("true".equalsIgnoreCase(Preferences.getPreference("tagValidation_javaMessageFormatSimplePatternCheck"))) {
            javaMessageFormatPattern = PatternConsts.SIMPLE_JAVA_MESSAGEFORMAT_PATTERN_VARS;
        }
        Pattern customTagPattern = null;
        String customRegExp = Preferences.getPreferenceDefaultAllowEmptyString("tagValidation_customPattern");
        if (!"".equalsIgnoreCase(customRegExp)) {
            customTagPattern = Pattern.compile(customRegExp);
        }
        Pattern RemovePattern = PatternConsts.getRemovePattern();
        for (IProject.FileInfo fi : Core.getProject().getProjectFiles()) {
            for (SourceTextEntry ste : fi.entries) {
                Matcher removeMatcher;
                String s = ste.getSrcText();
                TMXEntry te = Core.getProject().getTranslationInfo(ste);
                if (!te.isTranslated()) continue;
                if (printfPattern != null) {
                    HashSet<String> printfSourceSet = new HashSet<String>();
                    Matcher printfMatcher = printfPattern.matcher(s);
                    int index = 1;
                    while (printfMatcher.find()) {
                        String printfVariable = printfMatcher.group(0);
                        String argumentswapspecifier = printfMatcher.group(1);
                        if (argumentswapspecifier != null && argumentswapspecifier.endsWith("$")) {
                            printfSourceSet.add("" + argumentswapspecifier.substring(0, argumentswapspecifier.length() - 1) + printfVariable.substring(printfVariable.length() - 1, printfVariable.length()));
                            continue;
                        }
                        printfSourceSet.add("" + index + printfVariable.substring(printfVariable.length() - 1, printfVariable.length()));
                        ++index;
                    }
                    HashSet<String> printfTargetSet = new HashSet<String>();
                    printfMatcher = printfPattern.matcher(te.translation);
                    index = 1;
                    while (printfMatcher.find()) {
                        String printfVariable = printfMatcher.group(0);
                        String argumentswapspecifier = printfMatcher.group(1);
                        if (argumentswapspecifier != null && argumentswapspecifier.endsWith("$")) {
                            printfTargetSet.add("" + argumentswapspecifier.substring(0, argumentswapspecifier.length() - 1) + printfVariable.substring(printfVariable.length() - 1, printfVariable.length()));
                            continue;
                        }
                        printfTargetSet.add("" + index + printfVariable.substring(printfVariable.length() - 1, printfVariable.length()));
                        ++index;
                    }
                    if (!printfSourceSet.equals(printfTargetSet)) {
                        suspects.add(ste);
                        continue;
                    }
                }
                if (fi.filterClass.equals(PoFilter.class)) {
                    if (s.startsWith("\n") != te.translation.startsWith("\n")) {
                        suspects.add(ste);
                        continue;
                    }
                    if (s.endsWith("\n") != te.translation.endsWith("\n")) {
                        suspects.add(ste);
                        continue;
                    }
                }
                srcTags.clear();
                locTags.clear();
                StaticUtils.buildTagList(s, srcTags);
                StaticUtils.buildTagList(te.translation, locTags);
                if (customTagPattern != null) {
                    Matcher customTagPatternMatcher = customTagPattern.matcher(s);
                    while (customTagPatternMatcher.find()) {
                        srcTags.add(customTagPatternMatcher.group(0));
                    }
                    customTagPatternMatcher = customTagPattern.matcher(te.translation);
                    while (customTagPatternMatcher.find()) {
                        locTags.add(customTagPatternMatcher.group(0));
                    }
                }
                if (srcTags.size() != locTags.size()) {
                    suspects.add(ste);
                    continue;
                }
                boolean tagsAreIdentical = true;
                for (int j = 0; j < srcTags.size(); ++j) {
                    String t;
                    s = (String)srcTags.get(j);
                    if (s.equals(t = (String)locTags.get(j))) continue;
                    tagsAreIdentical = false;
                    break;
                }
                if (!(tagsAreIdentical || Preferences.isPreference("loose_tag_ordering") && this.tagsAreWellFormed(srcTags, locTags))) {
                    suspects.add(ste);
                    continue;
                }
                if (javaMessageFormatPattern != null) {
                    srcTags.clear();
                    locTags.clear();
                    Matcher javaMessageFormatMatcher = javaMessageFormatPattern.matcher(s);
                    while (javaMessageFormatMatcher.find()) {
                        srcTags.add(javaMessageFormatMatcher.group(0));
                    }
                    javaMessageFormatMatcher = javaMessageFormatPattern.matcher(te.translation);
                    while (javaMessageFormatMatcher.find()) {
                        locTags.add(javaMessageFormatMatcher.group(0));
                    }
                    Collections.sort(srcTags);
                    Collections.sort(locTags);
                    if (!((Object)srcTags).equals(locTags)) {
                        suspects.add(ste);
                        continue;
                    }
                }
                if (RemovePattern == null || !(removeMatcher = RemovePattern.matcher(te.translation)).find()) continue;
                suspects.add(ste);
            }
        }
        return suspects;
    }

    private boolean tagsAreWellFormed(List<String> srcTags, List<String> locTags) {
        for (String tag : srcTags) {
            if (locTags.contains(tag)) continue;
            return false;
        }
        Stack<StaticUtils.TagInfo> tagStack = new Stack<StaticUtils.TagInfo>();
        HashSet<String> cache = new HashSet<String>();
        for (String tag : locTags) {
            if (!srcTags.contains(tag)) {
                return false;
            }
            if (cache.contains(tag)) {
                return false;
            }
            cache.add(tag);
            StaticUtils.TagInfo info = StaticUtils.getTagInfo(tag);
            switch (info.type) {
                case START: {
                    tagStack.push(info);
                    break;
                }
                case END: {
                    if (tagStack.isEmpty()) break;
                    if (((StaticUtils.TagInfo)tagStack.peek()).name.equals(info.name)) {
                        tagStack.pop();
                        break;
                    }
                    return false;
                }
            }
        }
        while (!tagStack.isEmpty()) {
            if (!srcTags.contains(StaticUtils.getPairedTag((StaticUtils.TagInfo)tagStack.pop()))) continue;
            return false;
        }
        return true;
    }
}

