/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.stat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.omegat.core.Core;
import org.omegat.core.statistics.CalcMatchStatistics;
import org.omegat.core.statistics.CalcStandardStatistics;
import org.omegat.core.threads.LongProcessThread;
import org.omegat.util.OStrings;
import org.omegat.util.gui.DockingUI;

public class StatisticsWindow
extends JDialog {
    private JProgressBar progressBar = new JProgressBar();
    private JTextArea output = new JTextArea();
    private LongProcessThread thread;

    public StatisticsWindow(STAT_TYPE statType) {
        super((Frame)Core.getMainWindow().getApplicationFrame(), true);
        switch (statType) {
            case STANDARD: {
                this.setTitle(OStrings.getString("CT_STATSSTANDARD_WindowHeader"));
                this.thread = new CalcStandardStatistics(this);
                break;
            }
            case MATCHES: {
                this.setTitle(OStrings.getString("CT_STATSMATCH_WindowHeader"));
                this.thread = new CalcMatchStatistics(this);
            }
        }
        this.thread.setPriority(1);
        this.thread.start();
        this.setLayout(new BorderLayout());
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add(p);
        this.progressBar.setStringPainted(true);
        p.add((Component)this.progressBar, "South");
        this.output.setEditable(false);
        this.output.setFont(new Font("Monospaced", 0, Core.getMainWindow().getApplicationFont().getSize()));
        p.add((Component)new JScrollPane(this.output), "Center");
        this.setDefaultCloseOperation(2);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                StatisticsWindow.this.thread.fin();
                StatisticsWindow.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                StatisticsWindow.this.thread.fin();
            }
        });
        this.setSize(800, 400);
        DockingUI.displayCentered(this);
    }

    public void showProgress(final int percent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StatisticsWindow.this.progressBar.setValue(percent);
                StatisticsWindow.this.progressBar.setString(percent + "%");
            }
        });
    }

    public void displayData(final String result, final boolean end) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (end) {
                    StatisticsWindow.this.progressBar.setValue(100);
                    StatisticsWindow.this.progressBar.setString("");
                    StatisticsWindow.this.progressBar.setVisible(false);
                }
                StatisticsWindow.this.output.setText(result);
                StatisticsWindow.this.output.setCaretPosition(0);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum STAT_TYPE {
        STANDARD,
        MATCHES;

    }
}

