/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.search;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.text.StringContent;
import javax.swing.undo.UndoManager;
import org.omegat.core.Core;
import org.omegat.core.search.SearchResultEntry;
import org.omegat.core.threads.SearchThread;
import org.omegat.gui.main.MainWindow;
import org.omegat.gui.search.EntryListPane;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.OmegaTFileChooser;
import org.omegat.util.gui.UIThreadsUtil;
import org.openide.awt.Mnemonics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchWindow
extends JFrame {
    private MainWindow m_parent;
    private SimpleDateFormat m_dateFormat;
    private JLabel m_searchLabel;
    private JTextField m_searchField;
    private JButton m_searchButton;
    private JRadioButton m_exactSearchRB;
    private JRadioButton m_keywordSearchRB;
    private JRadioButton m_regexpSearchRB;
    private JLabel m_resultsLabel;
    private JButton m_advancedButton;
    private JCheckBox m_searchSourceCB;
    private JCheckBox m_searchTargetCB;
    private JCheckBox m_searchNotesCB;
    private boolean m_advancedVisible;
    private Box bAB;
    private JCheckBox m_authorCB;
    private MFindField m_authorField;
    private Box bDB;
    private JCheckBox m_dateFromCB;
    private JButton m_dateFromButton;
    private JSpinner m_dateFromSpinner;
    private SpinnerDateModel m_dateFromModel;
    private JCheckBox m_dateToCB;
    private JButton m_dateToButton;
    private JSpinner m_dateToSpinner;
    private SpinnerDateModel m_dateToModel;
    private Box bNbr;
    private JLabel m_numberLabel;
    private JSpinner m_numberOfResults;
    private SpinnerModel m_numberModel;
    private JSpinner m_dummy;
    private JCheckBox m_caseCB;
    private JCheckBox m_tmSearchCB;
    private JCheckBox m_allResultsCB;
    private boolean m_tmSearch = true;
    private JLabel m_dirLabel;
    private JTextField m_dirField;
    private JButton m_dirButton;
    private JCheckBox m_dirCB;
    private JCheckBox m_recursiveCB;
    private JButton m_dismissButton;
    private JButton m_filterButton;
    private JButton m_removeFilterButton;
    private EntryListPane m_viewer;
    private SearchThread m_thread;
    private static final String SEARCH_TYPE_EXACT = "EXACT";
    private static final String SEARCH_TYPE_KEYWORD = "KEYWORD";
    private static final String SEARCH_TYPE_REGEXP = "REGEXP";
    private static final String SAVED_DATE_FORMAT = "yyyy/MM/dd HH:mm";
    private static final int H_MARGIN = 10;

    public SearchWindow(MainWindow par, String startText) {
        this.m_parent = par;
        this.m_dateFormat = new SimpleDateFormat(SAVED_DATE_FORMAT);
        this.m_searchLabel = new JLabel();
        this.m_searchField = new MFindField();
        if (startText != null) {
            this.m_searchField.setText(startText);
        }
        this.m_searchButton = new JButton();
        Box bSearch = Box.createHorizontalBox();
        bSearch.add(this.m_searchLabel);
        bSearch.add(this.m_searchField);
        bSearch.add(Box.createHorizontalStrut(10));
        bSearch.add(this.m_searchButton);
        this.m_exactSearchRB = new JRadioButton();
        this.m_keywordSearchRB = new JRadioButton();
        this.m_regexpSearchRB = new JRadioButton();
        this.m_resultsLabel = new JLabel();
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_exactSearchRB);
        bg.add(this.m_keywordSearchRB);
        bg.add(this.m_regexpSearchRB);
        Box bRB = Box.createHorizontalBox();
        bRB.add(this.m_exactSearchRB);
        bRB.add(Box.createHorizontalStrut(10));
        bRB.add(this.m_keywordSearchRB);
        bRB.add(Box.createHorizontalStrut(10));
        bRB.add(this.m_regexpSearchRB);
        bRB.add(Box.createHorizontalStrut(10));
        bRB.add(this.m_resultsLabel);
        bRB.add(Box.createHorizontalGlue());
        this.m_caseCB = new JCheckBox();
        this.m_searchSourceCB = new JCheckBox();
        this.m_searchTargetCB = new JCheckBox();
        this.m_searchNotesCB = new JCheckBox();
        this.m_tmSearchCB = new JCheckBox();
        this.m_allResultsCB = new JCheckBox();
        Box bOB = Box.createHorizontalBox();
        bOB.add(this.m_caseCB);
        bOB.add(Box.createHorizontalStrut(10));
        bOB.add(this.m_searchSourceCB);
        bOB.add(Box.createHorizontalStrut(10));
        bOB.add(this.m_searchTargetCB);
        bOB.add(Box.createHorizontalStrut(10));
        bOB.add(this.m_searchNotesCB);
        bOB.add(Box.createHorizontalStrut(10));
        bOB.add(this.m_tmSearchCB);
        bOB.add(Box.createHorizontalStrut(10));
        bOB.add(this.m_allResultsCB);
        this.m_advancedButton = new JButton();
        Box bAO = Box.createHorizontalBox();
        bAO.add(this.m_advancedButton);
        bAO.add(Box.createHorizontalGlue());
        this.m_authorCB = new JCheckBox();
        this.m_authorField = new MFindField();
        this.m_authorField.setEditable(false);
        this.m_authorField.setDefaultText(OStrings.getString("TF_CUR_SEGMENT_UNKNOWN_AUTHOR"));
        this.bAB = Box.createHorizontalBox();
        this.bAB.add(this.m_authorCB);
        this.bAB.add(this.m_authorField);
        Calendar calendar = Calendar.getInstance();
        Date initDate = calendar.getTime();
        calendar.add(1, -100);
        Date earliestDate = calendar.getTime();
        Date latestDate = initDate;
        this.m_dateFromModel = new SpinnerDateModel(initDate, earliestDate, latestDate, 1);
        this.m_dateFromCB = new JCheckBox();
        this.m_dateFromSpinner = new JSpinner(this.m_dateFromModel);
        this.m_dateFromButton = new JButton();
        this.bDB = Box.createHorizontalBox();
        this.bDB.add(this.m_dateFromCB);
        this.bDB.add(this.m_dateFromSpinner);
        this.bDB.add(this.m_dateFromButton);
        this.bDB.add(Box.createHorizontalStrut(10));
        this.bDB.add(Box.createHorizontalGlue());
        this.m_dateToModel = new SpinnerDateModel(initDate, earliestDate, latestDate, 1);
        this.m_dateToCB = new JCheckBox();
        this.m_dateToSpinner = new JSpinner(this.m_dateToModel);
        this.m_dateToButton = new JButton();
        this.bDB.add(this.m_dateToCB);
        this.bDB.add(this.m_dateToSpinner);
        this.bDB.add(this.m_dateToButton);
        this.m_numberModel = new SpinnerNumberModel(1000, 1, Integer.MAX_VALUE, 1);
        this.m_numberOfResults = new JSpinner(this.m_numberModel);
        this.m_numberLabel = new JLabel();
        this.bNbr = Box.createHorizontalBox();
        this.bNbr.add(this.m_numberLabel);
        this.bNbr.add(this.m_numberOfResults);
        this.bNbr.add(Box.createHorizontalStrut(10));
        this.bNbr.add(Box.createHorizontalGlue());
        this.m_dummy = new JSpinner();
        this.m_dummy.setVisible(false);
        this.bNbr.add(this.m_dummy);
        this.bNbr.add(Box.createHorizontalStrut(10));
        this.bNbr.add(Box.createHorizontalGlue());
        this.bNbr.add(this.m_dummy);
        this.m_viewer = new EntryListPane();
        JScrollPane viewerScroller = new JScrollPane(this.m_viewer);
        this.m_dirLabel = new JLabel();
        this.m_dirField = new JTextField();
        this.m_dirField.setEditable(false);
        this.m_dirButton = new JButton();
        Box bDir = Box.createHorizontalBox();
        bDir.add(this.m_dirLabel);
        bDir.add(this.m_dirField);
        bDir.add(Box.createHorizontalStrut(10));
        bDir.add(this.m_dirButton);
        this.m_dirCB = new JCheckBox();
        this.m_dirCB.setSelected(false);
        this.m_recursiveCB = new JCheckBox();
        this.m_recursiveCB.setSelected(true);
        this.m_recursiveCB.setEnabled(false);
        this.m_removeFilterButton = new JButton();
        this.m_removeFilterButton.setEnabled(false);
        this.m_filterButton = new JButton();
        this.m_filterButton.setEnabled(false);
        this.m_dismissButton = new JButton();
        Box bCB = Box.createHorizontalBox();
        bCB.add(this.m_dirCB);
        bCB.add(Box.createHorizontalStrut(10));
        bCB.add(this.m_recursiveCB);
        bCB.add(Box.createHorizontalGlue());
        bCB.add(this.m_removeFilterButton);
        bCB.add(this.m_filterButton);
        bCB.add(this.m_dismissButton);
        Container cp = this.getContentPane();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        cp.setLayout(gridbag);
        c.insets = new Insets(3, 3, 3, 3);
        c.anchor = 18;
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.fill = 2;
        c.gridwidth = 0;
        gridbag.setConstraints(bSearch, c);
        cp.add(bSearch);
        gridbag.setConstraints(bRB, c);
        cp.add(bRB);
        gridbag.setConstraints(bOB, c);
        cp.add(bOB);
        gridbag.setConstraints(this.bAB, c);
        cp.add(this.bAB);
        gridbag.setConstraints(this.bDB, c);
        cp.add(this.bDB);
        gridbag.setConstraints(this.bNbr, c);
        cp.add(this.bNbr);
        gridbag.setConstraints(bAO, c);
        cp.add(bAO);
        c.weighty = 3.0;
        c.fill = 1;
        gridbag.setConstraints(viewerScroller, c);
        cp.add(viewerScroller);
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 16;
        gridbag.setConstraints(bDir, c);
        cp.add(bDir);
        gridbag.setConstraints(bCB, c);
        cp.add(bCB);
        this.m_dismissButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchWindow.this.doCancel();
            }
        });
        this.m_filterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchWindow.this.doFilter();
            }
        });
        this.m_removeFilterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchWindow.this.doRemoveFilter();
            }
        });
        this.m_searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchWindow.this.doSearch();
            }
        });
        this.m_advancedButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchWindow.this.toggleAdvancedOptions();
            }
        });
        this.m_authorCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchWindow.this.enableDisableAuthor();
            }
        });
        this.m_dateToCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchWindow.this.enableDisableDateTo();
            }
        });
        this.m_dateToButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchWindow.this.doResetDateTo();
            }
        });
        this.m_dateFromButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchWindow.this.doResetDateFrom();
            }
        });
        this.m_dateFromCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchWindow.this.enableDisableDateFrom();
            }
        });
        this.m_dirButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchWindow.this.doBrowseDirectory();
            }
        });
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SearchWindow.this.doCancel();
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.m_exactSearchRB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchWindow.this.m_searchField.requestFocus();
            }
        });
        this.m_keywordSearchRB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchWindow.this.m_searchField.requestFocus();
            }
        });
        this.m_regexpSearchRB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchWindow.this.m_searchField.requestFocus();
            }
        });
        this.m_caseCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchWindow.this.m_searchField.requestFocus();
            }
        });
        this.m_searchSourceCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchWindow.this.m_searchField.requestFocus();
            }
        });
        this.m_searchTargetCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchWindow.this.m_searchField.requestFocus();
            }
        });
        this.m_searchNotesCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchWindow.this.m_searchField.requestFocus();
            }
        });
        this.m_tmSearchCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchWindow.this.m_tmSearch = SearchWindow.this.m_tmSearchCB.isSelected();
                SearchWindow.this.m_searchField.requestFocus();
            }
        });
        this.m_allResultsCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchWindow.this.m_searchField.requestFocus();
            }
        });
        this.m_dirCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SearchWindow.this.updateOptionStatus();
                if (SearchWindow.this.m_dirCB.isSelected()) {
                    SearchWindow.this.m_dirField.requestFocus();
                } else {
                    SearchWindow.this.m_searchField.requestFocus();
                }
            }
        });
        this.m_numberOfResults.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SearchWindow.this.m_searchField.requestFocus();
            }
        });
        this.updateUIText();
        this.loadPreferences();
        this.m_viewer.setFont();
        this.m_viewer.setText(OStrings.getString("SW_VIEWER_TEXT"));
        if (!Core.getProject().isProjectLoaded()) {
            this.m_dirCB.setSelected(true);
            this.m_dirCB.setEnabled(false);
            this.m_tmSearchCB.setSelected(false);
            this.m_tmSearchCB.setEnabled(false);
            this.m_dirField.setEditable(true);
            this.updateOptionStatus();
        }
        this.m_searchField.requestFocus();
    }

    private void loadPreferences() {
        try {
            String dx = Preferences.getPreference("search_window_x");
            String dy = Preferences.getPreference("search_window_y");
            int x = Integer.parseInt(dx);
            int y = Integer.parseInt(dy);
            this.setLocation(x, y);
            String dw = Preferences.getPreference("search_window_width");
            String dh = Preferences.getPreference("search_window_height");
            int w = Integer.parseInt(dw);
            int h = Integer.parseInt(dh);
            this.setSize(w, h);
        }
        catch (NumberFormatException nfe) {
            this.setSize(800, 700);
        }
        String searchFiles = Preferences.getPreference("search_window_search_files");
        if (StringUtil.isEmpty(searchFiles)) {
            searchFiles = "false";
        }
        this.m_dirCB.setSelected(Boolean.valueOf(searchFiles));
        String searchDir = Preferences.getPreference("search_window_dir");
        if (!StringUtil.isEmpty(searchDir)) {
            this.m_dirField.setText(searchDir);
        }
        this.m_dirField.setEditable(this.m_dirCB.isSelected());
        String recursive = Preferences.getPreference("search_window_search_recursive");
        if (StringUtil.isEmpty(recursive)) {
            recursive = "true";
        }
        this.m_recursiveCB.setSelected(Boolean.valueOf(recursive));
        this.m_recursiveCB.setEnabled(this.m_dirCB.isSelected());
        String searchType = Preferences.getPreference("search_window_search_type");
        if (StringUtil.isEmpty(searchType)) {
            searchType = SEARCH_TYPE_EXACT;
        }
        this.m_exactSearchRB.setSelected(searchType.equals(SEARCH_TYPE_EXACT));
        this.m_keywordSearchRB.setSelected(searchType.equals(SEARCH_TYPE_KEYWORD));
        this.m_regexpSearchRB.setSelected(searchType.equals(SEARCH_TYPE_REGEXP));
        String caseSens = Preferences.getPreference("search_window_case_sensitive");
        if (StringUtil.isEmpty(caseSens)) {
            caseSens = "false";
        }
        this.m_caseCB.setSelected(Boolean.valueOf(caseSens));
        String searchSource = Preferences.getPreference("search_window_search_source");
        if (StringUtil.isEmpty(searchSource)) {
            searchSource = "true";
        }
        this.m_searchSourceCB.setSelected(Boolean.valueOf(searchSource));
        String searchTarget = Preferences.getPreference("search_window_search_target");
        if (StringUtil.isEmpty(searchTarget)) {
            searchTarget = "true";
        }
        this.m_searchTargetCB.setSelected(Boolean.valueOf(searchTarget));
        String searchNotes = Preferences.getPreference("search_window_search_notes");
        if (StringUtil.isEmpty(searchNotes)) {
            searchNotes = "true";
        }
        this.m_searchNotesCB.setSelected(Boolean.valueOf(searchNotes));
        String tmSearch = Preferences.getPreference("search_window_tm_search");
        if (StringUtil.isEmpty(tmSearch)) {
            tmSearch = "true";
        }
        this.m_tmSearchCB.setSelected(Boolean.valueOf(tmSearch));
        this.m_tmSearch = Boolean.valueOf(tmSearch);
        String allResults = Preferences.getPreference("search_window_all_results");
        if (StringUtil.isEmpty(allResults)) {
            allResults = "false";
        }
        this.m_allResultsCB.setSelected(Boolean.valueOf(allResults));
        this.updateOptionStatus();
        this.loadAdvancedOptionPreferences();
        this.updateAdvancedOptionStatus();
    }

    private void savePreferences() {
        Preferences.setPreference("search_window_width", this.getWidth());
        Preferences.setPreference("search_window_height", this.getHeight());
        Preferences.setPreference("search_window_x", this.getX());
        Preferences.setPreference("search_window_y", this.getY());
        if (this.m_exactSearchRB.isSelected()) {
            Preferences.setPreference("search_window_search_type", SEARCH_TYPE_EXACT);
        } else if (this.m_keywordSearchRB.isSelected()) {
            Preferences.setPreference("search_window_search_type", SEARCH_TYPE_KEYWORD);
        } else if (this.m_regexpSearchRB.isSelected()) {
            Preferences.setPreference("search_window_search_type", SEARCH_TYPE_REGEXP);
        }
        Preferences.setPreference("search_window_case_sensitive", Boolean.toString(this.m_caseCB.isSelected()));
        Preferences.setPreference("search_window_search_source", Boolean.toString(this.m_searchSourceCB.isSelected()));
        Preferences.setPreference("search_window_search_target", Boolean.toString(this.m_searchTargetCB.isSelected()));
        Preferences.setPreference("search_window_search_notes", Boolean.toString(this.m_searchNotesCB.isSelected()));
        Preferences.setPreference("search_window_tm_search", Boolean.toString(this.m_tmSearch));
        Preferences.setPreference("search_window_all_results", Boolean.toString(this.m_allResultsCB.isSelected()));
        Preferences.setPreference("search_window_advanced_visible", Boolean.toString(this.m_advancedVisible));
        Preferences.setPreference("search_window_search_author", Boolean.toString(this.m_authorCB.isSelected()));
        Preferences.setPreference("search_window_author_name", this.m_authorField.getText());
        Preferences.setPreference("search_window_date_from", Boolean.toString(this.m_dateFromCB.isSelected()));
        Preferences.setPreference("search_window_date_from_value", this.m_dateFormat.format(this.m_dateFromModel.getDate()));
        Preferences.setPreference("search_window_date_to", Boolean.toString(this.m_dateToCB.isSelected()));
        Preferences.setPreference("search_window_date_to_value", this.m_dateFormat.format(this.m_dateToModel.getDate()));
        Preferences.setPreference("search_window_number_of_results", (Integer)this.m_numberOfResults.getValue());
        Preferences.setPreference("search_window_dir", this.m_dirField.getText());
        Preferences.setPreference("search_window_search_files", Boolean.toString(this.m_dirCB.isSelected()));
        Preferences.setPreference("search_window_search_recursive", Boolean.toString(this.m_recursiveCB.isSelected()));
        Preferences.save();
    }

    private void updateOptionStatus() {
        this.m_tmSearchCB.setEnabled(!this.m_dirCB.isSelected());
        this.m_tmSearchCB.setSelected(!this.m_dirCB.isSelected() && this.m_tmSearch);
        this.m_recursiveCB.setEnabled(this.m_dirCB.isSelected());
        this.m_dirField.setEditable(this.m_dirCB.isSelected());
    }

    public void displaySearchResult(final List<SearchResultEntry> entries) {
        UIThreadsUtil.executeInSwingThread(new Runnable(){

            public void run() {
                SearchWindow.this.m_viewer.displaySearchResult(entries, (Integer)SearchWindow.this.m_numberOfResults.getValue());
                SearchWindow.this.m_resultsLabel.setText(StaticUtils.format(OStrings.getString("SW_NR_OF_RESULTS"), new Integer(SearchWindow.this.m_viewer.getNrEntries())));
                SearchWindow.this.m_filterButton.setEnabled(true);
                SearchWindow.this.m_viewer.requestFocus();
            }
        });
    }

    @Override
    public void processWindowEvent(WindowEvent w) {
        int evt = w.getID();
        if (evt == 201 || evt == 202) {
            this.savePreferences();
            this.m_parent.removeSearchWindow(this);
            if (this.m_thread != null) {
                this.m_thread.fin();
            }
        }
        super.processWindowEvent(w);
    }

    private void doBrowseDirectory() {
        File dir;
        OmegaTFileChooser browser = new OmegaTFileChooser();
        browser.setDialogTitle(OStrings.getString("SW_TITLE"));
        browser.setFileSelectionMode(1);
        String curDir = this.m_dirField.getText();
        if (!curDir.equals("") && (dir = new File(curDir)).exists() && dir.isDirectory()) {
            browser.setCurrentDirectory(dir);
        }
        browser.showOpenDialog(this);
        dir = browser.getSelectedFile();
        if (dir == null) {
            return;
        }
        String str = dir.getAbsolutePath() + File.separator;
        this.m_dirField.setText(str);
    }

    private void doFilter() {
        Core.getEditor().addFilter(this.m_viewer.getEntryList());
        this.m_removeFilterButton.setEnabled(true);
    }

    private void doRemoveFilter() {
        this.m_removeFilterButton.setEnabled(false);
        Core.getEditor().removeFilter();
    }

    private void doSearch() {
        UIThreadsUtil.mustBeSwingThread();
        if (this.m_thread != null) {
            this.m_thread.fin();
        }
        this.m_searchField.requestFocus();
        this.m_viewer.reset();
        String root = null;
        if (this.m_dirCB.isSelected()) {
            File f;
            root = this.m_dirField.getText();
            if (!root.endsWith(File.separator)) {
                root = root + File.separator;
            }
            if (!(f = new File(root)).exists() || !f.isDirectory()) {
                String error = StaticUtils.format(OStrings.getString("SW_ERROR_BAD_DIR"), this.m_dirField.getText());
                this.m_viewer.setText(error);
                Log.log(error);
                return;
            }
        }
        this.savePreferences();
        if (StringUtil.isEmpty(this.m_searchField.getText())) {
            this.setTitle(OStrings.getString("SW_TITLE"));
        } else {
            this.setTitle(this.m_searchField.getText() + " - OmegaT");
        }
        this.m_thread = new SearchThread(this, this.m_searchField.getText(), root, this.m_recursiveCB.isSelected(), this.m_exactSearchRB.isSelected(), this.m_keywordSearchRB.isSelected(), this.m_regexpSearchRB.isSelected(), this.m_caseCB.isSelected(), this.m_tmSearchCB.isSelected(), this.m_allResultsCB.isSelected(), this.m_searchSourceCB.isSelected(), this.m_searchTargetCB.isSelected(), this.m_searchNotesCB.isSelected(), this.m_authorCB.isSelected(), this.m_authorField.getText(), this.m_dateFromCB.isSelected(), this.m_dateFromModel.getDate().getTime(), this.m_dateToCB.isSelected(), this.m_dateToModel.getDate().getTime(), (Integer)this.m_numberOfResults.getValue());
        this.m_thread.start();
    }

    private void doCancel() {
        UIThreadsUtil.mustBeSwingThread();
        if (this.m_thread != null) {
            this.m_thread.fin();
        }
        this.dispose();
    }

    private void toggleAdvancedOptions() {
        this.m_advancedVisible = !this.m_advancedVisible;
        this.updateAdvancedOptionStatus();
    }

    private void enableDisableAuthor() {
        boolean editable = this.m_authorCB.isSelected();
        this.m_authorField.setEditable(editable);
        if (editable) {
            this.m_authorField.requestFocus();
        } else {
            this.m_searchField.requestFocus();
        }
    }

    private void enableDisableDateFrom() {
        boolean enable = this.m_dateFromCB.isSelected();
        this.m_dateFromSpinner.setEnabled(enable);
        this.m_dateFromButton.setEnabled(enable);
        if (enable) {
            this.m_dateFromSpinner.requestFocus();
        } else {
            this.m_searchField.requestFocus();
        }
    }

    private void doResetDateFrom() {
        Calendar calendar = Calendar.getInstance();
        Date now = calendar.getTime();
        this.m_dateFromModel.setEnd(now);
        this.m_dateFromModel.setValue(now);
    }

    private void doResetDateTo() {
        Calendar calendar = Calendar.getInstance();
        Date now = calendar.getTime();
        this.m_dateToModel.setEnd(now);
        this.m_dateToModel.setValue(now);
    }

    private void enableDisableDateTo() {
        boolean enable = this.m_dateToCB.isSelected();
        this.m_dateToSpinner.setEnabled(enable);
        this.m_dateToButton.setEnabled(enable);
        if (enable) {
            this.m_dateToSpinner.requestFocus();
        } else {
            this.m_searchField.requestFocus();
        }
    }

    private void loadAdvancedOptionPreferences() {
        String advancedVisible = Preferences.getPreference("search_window_advanced_visible");
        if (StringUtil.isEmpty(advancedVisible)) {
            advancedVisible = "false";
        }
        this.m_advancedVisible = Boolean.valueOf(advancedVisible);
        String searchAuthor = Preferences.getPreference("search_window_search_author");
        if (StringUtil.isEmpty(searchAuthor)) {
            searchAuthor = "false";
        }
        this.m_authorCB.setSelected(Boolean.valueOf(searchAuthor));
        String authorName = Preferences.getPreference("search_window_author_name");
        if (!StringUtil.isEmpty(authorName)) {
            this.m_authorField.setText(authorName);
        }
        try {
            String dateTo;
            String dateFrom = Preferences.getPreference("search_window_date_from");
            if (StringUtil.isEmpty(dateFrom)) {
                dateFrom = "false";
            }
            this.m_dateFromCB.setSelected(Boolean.valueOf(dateFrom));
            String dateFromValue = Preferences.getPreference("search_window_date_from_value");
            if (!StringUtil.isEmpty(dateFromValue)) {
                this.m_dateFromModel.setValue(this.m_dateFormat.parse(dateFromValue));
            }
            if (StringUtil.isEmpty(dateTo = Preferences.getPreference("search_window_date_to"))) {
                dateTo = "false";
            }
            this.m_dateToCB.setSelected(Boolean.valueOf(dateTo));
            String dateToValue = Preferences.getPreference("search_window_date_to_value");
            if (!StringUtil.isEmpty(dateToValue)) {
                this.m_dateToModel.setValue(this.m_dateFormat.parse(dateToValue));
            }
        }
        catch (ParseException e) {
            this.m_dateFromCB.setSelected(false);
            this.m_dateToCB.setSelected(false);
        }
        this.m_numberOfResults.setValue(Preferences.getPreferenceDefault("search_window_number_of_results", 1000));
        if (this.m_authorCB.isSelected() || this.m_dateFromCB.isSelected() || this.m_dateToCB.isSelected()) {
            this.m_advancedVisible = true;
        }
    }

    private void updateAdvancedOptionStatus() {
        this.bAB.setVisible(this.m_advancedVisible);
        this.bDB.setVisible(this.m_advancedVisible);
        this.bNbr.setVisible(this.m_advancedVisible);
        this.m_authorField.setEditable(this.m_authorCB.isSelected());
        this.m_dateFromSpinner.setEnabled(this.m_dateFromCB.isSelected());
        this.m_dateFromButton.setEnabled(this.m_dateFromCB.isSelected());
        this.m_dateToSpinner.setEnabled(this.m_dateToCB.isSelected());
        this.m_dateToButton.setEnabled(this.m_dateToCB.isSelected());
    }

    private void updateUIText() {
        this.setTitle(OStrings.getString("SW_TITLE"));
        Mnemonics.setLocalizedText(this.m_searchLabel, OStrings.getString("SW_SEARCH_TEXT"));
        Mnemonics.setLocalizedText(this.m_searchButton, OStrings.getString("BUTTON_SEARCH"));
        Mnemonics.setLocalizedText(this.m_exactSearchRB, OStrings.getString("SW_EXACT_SEARCH"));
        Mnemonics.setLocalizedText(this.m_keywordSearchRB, OStrings.getString("SW_WORD_SEARCH"));
        Mnemonics.setLocalizedText(this.m_regexpSearchRB, OStrings.getString("SW_REGEXP_SEARCH"));
        Mnemonics.setLocalizedText(this.m_searchSourceCB, OStrings.getString("SW_SEARCH_SOURCE"));
        Mnemonics.setLocalizedText(this.m_searchTargetCB, OStrings.getString("SW_SEARCH_TARGET"));
        Mnemonics.setLocalizedText(this.m_searchNotesCB, OStrings.getString("SW_SEARCH_NOTES"));
        Mnemonics.setLocalizedText(this.m_advancedButton, OStrings.getString("SW_ADVANCED_OPTIONS"));
        Mnemonics.setLocalizedText(this.m_authorCB, OStrings.getString("SW_AUTHOR"));
        Mnemonics.setLocalizedText(this.m_dateFromButton, OStrings.getString("SW_NOW"));
        Mnemonics.setLocalizedText(this.m_dateFromCB, OStrings.getString("SW_CHANGED_AFTER"));
        Mnemonics.setLocalizedText(this.m_dateToCB, OStrings.getString("SW_CHANGED_BEFORE"));
        Mnemonics.setLocalizedText(this.m_dateToButton, OStrings.getString("SW_NOW"));
        Mnemonics.setLocalizedText(this.m_numberLabel, OStrings.getString("SW_NUMBER"));
        Mnemonics.setLocalizedText(this.m_caseCB, OStrings.getString("SW_CASE_SENSITIVE"));
        Mnemonics.setLocalizedText(this.m_tmSearchCB, OStrings.getString("SW_SEARCH_TM"));
        Mnemonics.setLocalizedText(this.m_allResultsCB, OStrings.getString("SW_ALL_RESULTS"));
        Mnemonics.setLocalizedText(this.m_dirLabel, OStrings.getString("SW_LOCATION"));
        Mnemonics.setLocalizedText(this.m_dirCB, OStrings.getString("SW_DIR_SEARCH"));
        Mnemonics.setLocalizedText(this.m_recursiveCB, OStrings.getString("SW_DIR_RECURSIVE"));
        Mnemonics.setLocalizedText(this.m_dirButton, OStrings.getString("SW_BROWSE"));
        Mnemonics.setLocalizedText(this.m_dismissButton, OStrings.getString("BUTTON_CLOSE"));
        Mnemonics.setLocalizedText(this.m_filterButton, OStrings.getString("BUTTON_FILTER"));
        Mnemonics.setLocalizedText(this.m_removeFilterButton, OStrings.getString("BUTTON_REMOVEFILTER"));
    }

    public void displayErrorRB(final Throwable ex, final String errorKey, final Object ... params) {
        UIThreadsUtil.executeInSwingThread(new Runnable(){

            public void run() {
                String msg = params != null ? StaticUtils.format(OStrings.getString(errorKey), params) : OStrings.getString(errorKey);
                String fulltext = msg;
                if (ex != null) {
                    fulltext = fulltext + "\n" + ex.getLocalizedMessage();
                }
                JOptionPane.showMessageDialog(SearchWindow.this, fulltext, OStrings.getString("TF_ERROR"), 0);
            }
        });
    }

    class MFindField
    extends JTextField
    implements FocusListener {
        private UndoManager undoManager;
        private Font normalFont;
        private Font defaultTextFont;
        private Color normalColor;
        private String defaultText;
        private boolean isDirty;

        public MFindField() {
            KeyStroke undo = StaticUtils.onMacOSX() ? KeyStroke.getKeyStroke(90, 4, false) : KeyStroke.getKeyStroke(90, 2, false);
            AbstractAction undoAction = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    MFindField.this.undo();
                }
            };
            this.getInputMap().put(undo, "UNDO");
            this.getActionMap().put("UNDO", undoAction);
            KeyStroke redo = StaticUtils.onMacOSX() ? KeyStroke.getKeyStroke(89, 4, false) : KeyStroke.getKeyStroke(89, 2, false);
            AbstractAction redoAction = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    MFindField.this.redo();
                }
            };
            this.getInputMap().put(redo, "REDO");
            this.getActionMap().put("REDO", redoAction);
            this.defaultText = null;
            this.normalFont = this.getFont();
            this.defaultTextFont = this.normalFont.deriveFont(2);
            this.normalColor = this.getForeground();
            this.isDirty = false;
            this.addFocusListener(this);
        }

        public void setDefaultText(String text) {
            this.defaultText = text;
            if (this.getText().length() == 0) {
                this.showDefaultText();
            }
        }

        private void showDefaultText() {
            this.setText(this.defaultText);
            this.setFont(this.defaultTextFont);
            this.setForeground(this.getDisabledTextColor());
            this.isDirty = false;
        }

        protected Document createDefaultModel() {
            PlainDocument doc = new PlainDocument(new StringContent());
            this.undoManager = new UndoManager();
            doc.addUndoableEditListener(this.undoManager);
            return doc;
        }

        protected void processKeyEvent(KeyEvent e) {
            if (e.getKeyCode() == 10 && e.getID() == 401) {
                if (!this.getText().equals("")) {
                    SearchWindow.this.doSearch();
                }
            } else {
                super.processKeyEvent(e);
            }
            if (e.getID() == 400) {
                this.isDirty = true;
            }
        }

        protected void undo() {
            if (this.undoManager.canUndo()) {
                this.undoManager.undo();
            }
        }

        protected void redo() {
            if (this.undoManager.canRedo()) {
                this.undoManager.redo();
            }
        }

        public void focusGained(FocusEvent e) {
            if (this.defaultText != null && this.isEditable() && this.getText().length() == 0) {
                this.setText("");
            }
        }

        public void focusLost(FocusEvent e) {
            if (this.defaultText != null && this.isEditable() && this.getText().length() == 0) {
                this.showDefaultText();
            }
        }

        public String getText() {
            String content = super.getText();
            if (!this.isDirty && this.defaultText != null && content.equals(this.defaultText)) {
                return "";
            }
            return content;
        }

        public void setText(String t) {
            this.setFont(this.normalFont);
            this.setForeground(this.normalColor);
            if (t.length() > 0) {
                this.isDirty = true;
            }
            super.setText(t);
        }
    }
}

