/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.search;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.DefaultStyledDocument;
import org.omegat.core.Core;
import org.omegat.core.search.SearchMatch;
import org.omegat.core.search.SearchResultEntry;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.gui.AlwaysVisibleCaret;
import org.omegat.util.gui.Styles;
import org.omegat.util.gui.UIThreadsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EntryListPane
extends JTextPane {
    protected static final AttributeSet FOUND_MARK = Styles.createAttributeSet(Color.BLUE, null, true, null);
    protected static final int MARKS_PER_REQUEST = 100;
    private final List<Integer> m_entryList = new ArrayList<Integer>();
    private final List<Integer> m_offsetList = new ArrayList<Integer>();
    private DisplayMatches currentlyDisplayedMatches;
    private int numberOfResults;

    public EntryListPane() {
        this.setDocument(new DefaultStyledDocument());
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (e.getClickCount() == 2) {
                    final Cursor oldCursor = EntryListPane.this.getCursor();
                    EntryListPane.this.setCursor(Cursor.getPredefinedCursor(3));
                    int pos = EntryListPane.this.getCaretPosition();
                    for (int i = 0; i < EntryListPane.this.m_offsetList.size(); ++i) {
                        int off = (Integer)EntryListPane.this.m_offsetList.get(i);
                        if (off < pos) continue;
                        final int entry = (Integer)EntryListPane.this.m_entryList.get(i);
                        if (entry >= 0) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    Core.getEditor().gotoEntry(entry);
                                    EntryListPane.this.setCursor(oldCursor);
                                }
                            });
                            break;
                        }
                        EntryListPane.this.setCursor(oldCursor);
                        break;
                    }
                }
            }
        });
        this.setEditable(false);
        AlwaysVisibleCaret.apply(this);
    }

    public void displaySearchResult(List<SearchResultEntry> entries, int numberOfResults) {
        UIThreadsUtil.mustBeSwingThread();
        this.numberOfResults = numberOfResults;
        this.currentlyDisplayedMatches = null;
        this.m_entryList.clear();
        this.m_offsetList.clear();
        if (entries == null) {
            this.setText("");
            return;
        }
        this.currentlyDisplayedMatches = new DisplayMatches(entries);
    }

    private void addMessage(StringBuilder m_stringBuf, String message) {
        if (m_stringBuf.length() > 0) {
            m_stringBuf.append("---------\n");
        }
        m_stringBuf.append(message);
    }

    public void setFont() {
        String srcFont = Preferences.getPreference("source_font");
        if (!srcFont.equals("")) {
            int fontsize;
            try {
                fontsize = Integer.valueOf(Preferences.getPreference("source_font_size"));
            }
            catch (NumberFormatException nfe) {
                fontsize = 12;
            }
            this.setFont(new Font(srcFont, 0, fontsize));
        }
    }

    public void reset() {
        this.displaySearchResult(null, 0);
    }

    public int getNrEntries() {
        return this.m_entryList.size();
    }

    public List<Integer> getEntryList() {
        return this.m_entryList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class DisplayMatches
    implements Runnable {
        protected final DefaultStyledDocument doc;
        private final List<SearchMatch> matches = new ArrayList<SearchMatch>();

        public DisplayMatches(List<SearchResultEntry> entries) {
            UIThreadsUtil.mustBeSwingThread();
            this.doc = new DefaultStyledDocument();
            StringBuilder m_stringBuf = new StringBuilder();
            if (entries.size() == 0) {
                EntryListPane.this.addMessage(m_stringBuf, OStrings.getString("ST_NOTHING_FOUND"));
            }
            if (entries.size() >= EntryListPane.this.numberOfResults) {
                EntryListPane.this.addMessage(m_stringBuf, StaticUtils.format(OStrings.getString("SW_MAX_FINDS_REACHED"), new Integer(EntryListPane.this.numberOfResults)));
            }
            for (SearchResultEntry e : entries) {
                this.addEntry(m_stringBuf, e.getEntryNum(), e.getPreamble(), e.getSrcPrefix(), e.getSrcText(), e.getTranslation(), e.getSrcMatch(), e.getTargetMatch());
            }
            try {
                this.doc.insertString(0, m_stringBuf.toString(), null);
            }
            catch (Exception ex) {
                // empty catch block
            }
            EntryListPane.this.setDocument(this.doc);
            EntryListPane.this.setCaretPosition(0);
            EntryListPane.this.setFont();
            if (this.matches.size() > 0) {
                SwingUtilities.invokeLater(this);
            }
        }

        public void addEntry(StringBuilder m_stringBuf, int num, String preamble, String srcPrefix, String src, String loc, SearchMatch[] srcMatches, SearchMatch[] targetMatches) {
            if (m_stringBuf.length() > 0) {
                m_stringBuf.append("---------\n");
            }
            if (preamble != null && !preamble.equals("")) {
                m_stringBuf.append(preamble + "\n");
            }
            if (src != null && !src.equals("")) {
                m_stringBuf.append("-- ");
                if (srcPrefix != null) {
                    m_stringBuf.append(srcPrefix);
                }
                if (srcMatches != null) {
                    for (SearchMatch m : srcMatches) {
                        m.start += m_stringBuf.length();
                        this.matches.add(m);
                    }
                }
                m_stringBuf.append(src);
                m_stringBuf.append('\n');
            }
            if (loc != null && !loc.equals("")) {
                m_stringBuf.append("-- ");
                if (targetMatches != null) {
                    for (SearchMatch m : targetMatches) {
                        m.start += m_stringBuf.length();
                        this.matches.add(m);
                    }
                }
                m_stringBuf.append(loc);
                m_stringBuf.append('\n');
            }
            EntryListPane.this.m_entryList.add(num);
            EntryListPane.this.m_offsetList.add(m_stringBuf.length());
        }

        @Override
        public void run() {
            UIThreadsUtil.mustBeSwingThread();
            if (EntryListPane.this.currentlyDisplayedMatches != this) {
                return;
            }
            List<SearchMatch> display = this.matches.subList(0, Math.min(100, this.matches.size()));
            for (SearchMatch m : display) {
                this.doc.setCharacterAttributes(m.start, m.length, FOUND_MARK, true);
            }
            display.clear();
            if (this.matches.size() > 0) {
                SwingUtilities.invokeLater(this);
            }
        }
    }
}

