/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.notes;

import java.awt.Dimension;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.gui.common.EntryInfoPane;
import org.omegat.gui.main.DockableScrollPane;
import org.omegat.gui.main.MainWindow;
import org.omegat.gui.notes.INotes;
import org.omegat.util.OStrings;
import org.omegat.util.gui.UIThreadsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotesTextArea
extends EntryInfoPane<String>
implements INotes {
    private static final String EXPLANATION = OStrings.getString("GUI_NOTESWINDOW_explanation");
    SourceTextEntry ste;

    public NotesTextArea(MainWindow mw) {
        super(true);
        String title = OStrings.getString("GUI_NOTESWINDOW_SUBWINDOWTITLE_Notes");
        mw.addDockable(new DockableScrollPane("NOTES", title, this, true));
        this.setEditable(false);
        this.setText(EXPLANATION);
        this.setMinimumSize(new Dimension(100, 50));
    }

    @Override
    protected void onProjectOpen() {
        this.clear();
    }

    @Override
    protected void onProjectClose() {
        this.clear();
        this.setText(EXPLANATION);
    }

    @Override
    public void clear() {
        UIThreadsUtil.mustBeSwingThread();
        this.setText("");
        this.setEditable(false);
        this.ste = null;
    }

    @Override
    public void setNoteText(String text) {
        UIThreadsUtil.mustBeSwingThread();
        this.setText(text != null ? text : "");
        this.setEditable(true);
    }

    @Override
    public String getNoteText() {
        UIThreadsUtil.mustBeSwingThread();
        return this.getText();
    }
}

