/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.multtrans;

import java.util.ArrayList;
import java.util.List;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.IProject;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.gui.common.EntryInfoSearchThread;
import org.omegat.gui.multtrans.MultipleTransFoundEntry;
import org.omegat.gui.multtrans.MultipleTransPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleTransFindThread
extends EntryInfoSearchThread<List<MultipleTransFoundEntry>> {
    private final IProject project;
    private final String sourceText;

    public MultipleTransFindThread(MultipleTransPane pane, IProject project, SourceTextEntry entry) {
        super(pane, entry);
        this.project = project;
        this.sourceText = entry.getSrcText();
    }

    @Override
    protected List<MultipleTransFoundEntry> search() throws Exception {
        final ArrayList<MultipleTransFoundEntry> result = new ArrayList<MultipleTransFoundEntry>();
        this.project.iterateByDefaultTranslations(new IProject.DefaultTranslationsIterator(){

            public void iterate(String source, TMXEntry trans) {
                if (MultipleTransFindThread.this.sourceText.equals(source)) {
                    result.add(new MultipleTransFoundEntry(source, trans));
                }
            }
        });
        this.project.iterateByMultipleTranslations(new IProject.MultipleTranslationsIterator(){

            public void iterate(EntryKey source, TMXEntry trans) {
                if (MultipleTransFindThread.this.sourceText.equals(source.sourceText)) {
                    result.add(new MultipleTransFoundEntry(source, trans));
                }
            }
        });
        return result;
    }
}

