/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.main;

import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.event.DockableStateWillChangeEvent;
import com.vlsolutions.swing.docking.event.DockableStateWillChangeListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.omegat.gui.filelist.ProjectFrame;
import org.omegat.gui.main.MainWindow;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.gui.DockingUI;
import org.openide.awt.Mnemonics;

public class MainWindowUI {
    public static String UI_LAYOUT_FILE = "uiLayout.xml";

    public static void createMainComponents(MainWindow mainWindow, Font font) {
        mainWindow.m_projWin = new ProjectFrame(mainWindow);
    }

    public static DockingDesktop initDocking(MainWindow mainWindow) {
        DockingUI.initialize();
        mainWindow.desktop = new DockingDesktop();
        mainWindow.desktop.addDockableStateWillChangeListener(new DockableStateWillChangeListener(){

            public void dockableStateWillChange(DockableStateWillChangeEvent event) {
                if (event.getFutureState().isClosed()) {
                    event.cancel();
                }
            }
        });
        return mainWindow.desktop;
    }

    public static JPanel createStatusBar(MainWindow mainWindow) {
        mainWindow.statusLabel = new JLabel();
        mainWindow.progressLabel = new JLabel();
        mainWindow.lengthLabel = new JLabel();
        mainWindow.statusLabel.setFont(new Font("MS Sans Serif", 0, 11));
        Mnemonics.setLocalizedText(mainWindow.progressLabel, OStrings.getString("MW_PROGRESS_DEFAULT"));
        mainWindow.progressLabel.setToolTipText(OStrings.getString("MW_PROGRESS_TOOLTIP"));
        mainWindow.progressLabel.setBorder(BorderFactory.createLineBorder(Color.black));
        mainWindow.progressLabel.setHorizontalTextPosition(0);
        Mnemonics.setLocalizedText(mainWindow.lengthLabel, OStrings.getString("MW_SEGMENT_LENGTH_DEFAULT"));
        mainWindow.lengthLabel.setToolTipText(OStrings.getString("MW_SEGMENT_LENGTH_TOOLTIP"));
        mainWindow.lengthLabel.setAlignmentX(1.0f);
        mainWindow.lengthLabel.setBorder(BorderFactory.createLineBorder(Color.black));
        mainWindow.lengthLabel.setFocusable(false);
        JPanel statusPanel2 = new JPanel(new FlowLayout(2));
        statusPanel2.add(mainWindow.progressLabel);
        statusPanel2.add(mainWindow.lengthLabel);
        JPanel statusPanel = new JPanel(new BorderLayout());
        statusPanel.add((Component)mainWindow.statusLabel, "Center");
        statusPanel.add((Component)statusPanel2, "East");
        return statusPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadScreenLayout(MainWindow mainWindow) {
        int h;
        int w;
        int y;
        int x;
        try {
            x = Integer.parseInt(Preferences.getPreference("screen_x"));
            y = Integer.parseInt(Preferences.getPreference("screen_y"));
            w = Integer.parseInt(Preferences.getPreference("screen_width"));
            h = Integer.parseInt(Preferences.getPreference("screen_height"));
        }
        catch (NumberFormatException nfe) {
            GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Rectangle scrSize = env.getMaximumWindowBounds();
            if (scrSize.width < 900) {
                x = 0;
                y = 0;
                w = 580;
                h = 536;
            }
            x = 0;
            y = 0;
            w = 690;
            h = 700;
        }
        mainWindow.setBounds(x, y, w, h);
        File uiLayoutFile = new File(StaticUtils.getConfigDir() + UI_LAYOUT_FILE);
        if (uiLayoutFile.exists()) {
            try {
                FileInputStream in = new FileInputStream(uiLayoutFile);
                try {
                    mainWindow.desktop.readXML((InputStream)in);
                }
                finally {
                    in.close();
                }
            }
            catch (Exception e) {
                Log.log(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveScreenLayout(MainWindow mainWindow) {
        Preferences.setPreference("screen_x", mainWindow.getX());
        Preferences.setPreference("screen_y", mainWindow.getY());
        Preferences.setPreference("screen_width", mainWindow.getWidth());
        Preferences.setPreference("screen_height", mainWindow.getHeight());
        File uiLayoutFile = new File(StaticUtils.getConfigDir() + UI_LAYOUT_FILE);
        try {
            FileOutputStream out = new FileOutputStream(uiLayoutFile);
            try {
                mainWindow.desktop.writeXML((OutputStream)out);
            }
            finally {
                out.close();
            }
        }
        catch (Exception ex) {
            Log.log(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetDesktopLayout(MainWindow mainWindow) {
        try {
            InputStream in = MainWindowUI.class.getResourceAsStream("DockingDefaults.xml");
            try {
                mainWindow.desktop.readXML(in);
            }
            finally {
                in.close();
            }
        }
        catch (Exception exception) {
            Log.log(exception);
        }
    }
}

