/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.main;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.omegat.util.StaticUtils;

public class MainWindowMenuShortcuts {
    public static void setShortcuts(JMenuBar menu) {
        Properties shortcuts = MainWindowMenuShortcuts.loadPredefinedShortcuts();
        MainWindowMenuShortcuts.setup(menu.getComponents(), shortcuts);
    }

    private static void setup(Component[] items, Properties shortcuts) {
        for (Component c : items) {
            if (c instanceof JMenu) {
                MainWindowMenuShortcuts.setup(((JMenu)c).getMenuComponents(), shortcuts);
            }
            if (!(c instanceof JMenuItem)) continue;
            String cmd = ((JMenuItem)c).getActionCommand();
            MainWindowMenuShortcuts.setAccelerator((JMenuItem)c, shortcuts.getProperty(cmd));
        }
    }

    private static void setAccelerator(JMenuItem item, String shortcut) {
        if (shortcut == null) {
            return;
        }
        item.setAccelerator(KeyStroke.getKeyStroke(shortcut));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Properties loadPredefinedShortcuts() {
        Properties shortcuts;
        block9: {
            shortcuts = new Properties();
            String name = MainWindowMenuShortcuts.class.getPackage().getName().replace('.', '/') + "/MainMenuShortcuts";
            name = name + (StaticUtils.onMacOSX() ? ".mac.properties" : ".properties");
            File userShortcuts = new File(StaticUtils.getConfigDir(), "MainMenuShortcuts.properties");
            try {
                InputStream in = MainWindowMenuShortcuts.class.getClassLoader().getResourceAsStream(name);
                try {
                    shortcuts.load(in);
                }
                finally {
                    in.close();
                }
                if (!userShortcuts.exists()) break block9;
                FileInputStream us = new FileInputStream(userShortcuts);
                try {
                    shortcuts.load(us);
                }
                finally {
                    ((InputStream)us).close();
                }
            }
            catch (IOException ex) {
                throw new ExceptionInInitializerError();
            }
        }
        return shortcuts;
    }
}

