/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.omegat.core.Core;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.StringEntry;
import org.omegat.gui.common.EntryInfoThreadPane;
import org.omegat.gui.dialogs.CreateGlossaryEntry;
import org.omegat.gui.editor.mark.Mark;
import org.omegat.gui.glossary.FindGlossaryThread;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.gui.glossary.GlossaryManager;
import org.omegat.gui.glossary.GlossaryReaderTSV;
import org.omegat.gui.glossary.TransTips;
import org.omegat.gui.glossary.TransTipsMarker;
import org.omegat.gui.glossary.TransTipsPopup;
import org.omegat.gui.main.DockableScrollPane;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.AlwaysVisibleCaret;
import org.omegat.util.gui.UIThreadsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlossaryTextArea
extends EntryInfoThreadPane<List<GlossaryEntry>> {
    private static final String EXPLANATION = OStrings.getString("GUI_GLOSSARYWINDOW_explanation");
    protected final GlossaryManager manager = new GlossaryManager(this);
    protected StringEntry processedEntry;
    protected static List<GlossaryEntry> nowEntries;
    protected JPopupMenu popup;
    private CreateGlossaryEntry createGlossaryEntryDialog;
    protected MouseListener mouseListener = new PopupListener(this);

    public GlossaryTextArea() {
        super(true);
        String title = OStrings.getString("GUI_MATCHWINDOW_SUBWINDOWTITLE_Glossary");
        Core.getMainWindow().addDockable(new DockableScrollPane("GLOSSARY", title, this, true));
        this.setEditable(false);
        AlwaysVisibleCaret.apply(this);
        this.setText(EXPLANATION);
        this.setMinimumSize(new Dimension(100, 50));
        this.popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(OStrings.getString("GUI_GLOSSARYWINDOW_addentry"));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Core.getGlossary().showCreateGlossaryEntryDialog();
            }
        });
        this.popup.add(menuItem);
        this.addMouseListener(this.mouseListener);
        Core.getEditor().registerPopupMenuConstructors(300, new TransTipsPopup());
    }

    @Override
    protected void onProjectOpen() {
        this.clear();
        this.manager.start();
    }

    @Override
    protected void onProjectClose() {
        this.clear();
        this.setText(EXPLANATION);
        this.manager.stop();
    }

    @Override
    protected void startSearchThread(SourceTextEntry newEntry) {
        new FindGlossaryThread(this, newEntry, this.manager).start();
    }

    public void refresh() {
        SourceTextEntry ste = Core.getEditor().getCurrentEntry();
        if (ste != null) {
            this.startSearchThread(ste);
        }
    }

    @Override
    protected void setFoundResult(SourceTextEntry en, List<GlossaryEntry> entries) {
        UIThreadsUtil.mustBeSwingThread();
        if (entries == null) {
            nowEntries = new ArrayList<GlossaryEntry>();
            this.setText("");
            return;
        }
        if (Preferences.isPreference("transtips")) {
            this.highlightTransTips(en, entries);
        }
        nowEntries = entries;
        StringBuffer buf = new StringBuffer();
        for (GlossaryEntry entry : entries) {
            buf.append(entry.getSrcText() + " = " + entry.getLocText());
            if (entry.getCommentText().length() > 0) {
                buf.append("\n" + entry.getCommentText());
            }
            buf.append("\n\n");
        }
        this.setText(buf.toString());
    }

    public void clear() {
        this.setText("");
    }

    public void highlightTransTips(SourceTextEntry en, List<GlossaryEntry> entries) {
        if (!entries.isEmpty()) {
            final ArrayList<Mark> marks = new ArrayList<Mark>();
            String sourceText = en.getSrcText();
            sourceText = sourceText.toLowerCase();
            TransTips.Search callback = new TransTips.Search(){

                public void found(GlossaryEntry ge, int start, int end) {
                    marks.add(new Mark(Mark.ENTRY_PART.SOURCE, start, end));
                }
            };
            for (GlossaryEntry ent : entries) {
                TransTips.search(en.getSrcText(), ent, callback);
            }
            Core.getEditor().markActiveEntrySource(en, marks, TransTipsMarker.class.getName());
        }
    }

    private void insertTerm(String selTxt) {
        Core.getEditor().insertText(selTxt);
    }

    public void showCreateGlossaryEntryDialog() {
        CreateGlossaryEntry d = this.createGlossaryEntryDialog;
        if (d != null) {
            d.requestFocus();
            return;
        }
        ProjectProperties props = Core.getProject().getProjectProperties();
        final File out = new File(props.getWriteableGlossary());
        final CreateGlossaryEntry dialog = new CreateGlossaryEntry(Core.getMainWindow().getApplicationFrame());
        String txt = dialog.getGlossaryFileText().getText();
        txt = MessageFormat.format(txt, out.getAbsolutePath());
        dialog.getGlossaryFileText().setText(txt);
        dialog.setVisible(true);
        dialog.addWindowFocusListener(new WindowFocusListener(){

            public void windowLostFocus(WindowEvent e) {
            }

            public void windowGainedFocus(WindowEvent e) {
                String sel = Core.getEditor().getSelectedText();
                if (!StringUtil.isEmpty(sel)) {
                    if (StringUtil.isEmpty(dialog.getSourceText().getText())) {
                        dialog.getSourceText().setText(sel);
                    } else if (StringUtil.isEmpty(dialog.getTargetText().getText())) {
                        dialog.getTargetText().setText(sel);
                    } else if (StringUtil.isEmpty(dialog.getCommentText().getText())) {
                        dialog.getCommentText().setText(sel);
                    }
                }
            }
        });
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                GlossaryTextArea.this.createGlossaryEntryDialog = null;
                if (dialog.getReturnStatus() == 1) {
                    String src = dialog.getSourceText().getText();
                    String loc = dialog.getTargetText().getText();
                    String com = dialog.getCommentText().getText();
                    if (!StringUtil.isEmpty(src) && !StringUtil.isEmpty(loc)) {
                        try {
                            GlossaryReaderTSV.append(out, new GlossaryEntry(src, loc, com));
                        }
                        catch (Exception ex) {
                            Log.log(ex);
                        }
                    }
                }
            }
        });
        this.createGlossaryEntryDialog = dialog;
    }

    class PopupListener
    extends MouseAdapter {
        private GlossaryTextArea glossaryTextArea;

        public PopupListener(GlossaryTextArea gte) {
            this.glossaryTextArea = gte;
        }

        public void mouseClicked(MouseEvent e) {
            if (e.isPopupTrigger() || e.getButton() == 3) {
                String selTxt = this.glossaryTextArea.getSelectedText();
                if (selTxt == null) {
                    if (Core.getProject().isProjectLoaded()) {
                        GlossaryTextArea.this.popup.show(this.glossaryTextArea, e.getX(), e.getY());
                    }
                } else {
                    GlossaryTextArea.this.insertTerm(selTxt);
                }
            }
        }
    }
}

