/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlossaryReaderTSV {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<GlossaryEntry> read(File file) throws IOException {
        InputStreamReader reader;
        String fname_lower = file.getName().toLowerCase();
        if (fname_lower.endsWith(".tab")) {
            reader = new InputStreamReader(new FileInputStream(file));
        } else if (fname_lower.endsWith(".utf8") || fname_lower.endsWith(".txt")) {
            FileInputStream fis = new FileInputStream(file);
            reader = new InputStreamReader((InputStream)fis, "UTF-8");
        } else {
            return null;
        }
        ArrayList<GlossaryEntry> result = new ArrayList<GlossaryEntry>();
        BufferedReader in = new BufferedReader(reader);
        try {
            in.mark(1);
            int ch = in.read();
            if (ch != 65279) {
                in.reset();
            }
            String s = in.readLine();
            while (s != null) {
                String[] tokens;
                if (!s.startsWith("#") && (tokens = s.split("\t")).length >= 2 && tokens[0].length() != 0) {
                    String comment = "";
                    if (tokens.length >= 3) {
                        comment = tokens[2];
                    }
                    result.add(new GlossaryEntry(tokens[0], tokens[1], comment));
                }
                s = in.readLine();
            }
        }
        finally {
            in.close();
        }
        return result;
    }

    public static void append(File file, GlossaryEntry newEntry) throws IOException {
        if (!file.exists()) {
            File parentFile = file.getParentFile();
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            file.createNewFile();
        }
        OutputStreamWriter wr = new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), "UTF-8");
        ((Writer)wr).append(newEntry.getSrcText()).append('\t').append(newEntry.getLocText());
        if (!StringUtil.isEmpty(newEntry.getCommentText())) {
            wr.append('\t').append(newEntry.getCommentText());
        }
        ((Writer)wr).append(System.getProperty("line.separator"));
        ((Writer)wr).close();
    }
}

