/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.omegat.gui.glossary.GlossaryEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlossaryReaderCSV {
    protected static final char SEPARATOR = ',';

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<GlossaryEntry> read(File file) throws IOException {
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
        ArrayList<GlossaryEntry> result = new ArrayList<GlossaryEntry>();
        BufferedReader in = new BufferedReader(reader);
        try {
            in.mark(1);
            int ch = in.read();
            if (ch != 65279) {
                in.reset();
            }
            String s = in.readLine();
            while (s != null) {
                String[] tokens;
                if (!s.startsWith("#") && (tokens = GlossaryReaderCSV.parseLine(s)).length >= 2 && tokens[0].length() != 0) {
                    String comment = "";
                    if (tokens.length >= 3) {
                        comment = tokens[2];
                    }
                    result.add(new GlossaryEntry(tokens[0], tokens[1], comment));
                }
                s = in.readLine();
            }
        }
        finally {
            in.close();
        }
        return result;
    }

    private static String[] parseLine(String line) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder w = new StringBuilder();
        boolean fopened = false;
        block6: for (int i = 0; i < line.length(); ++i) {
            char cn;
            char c = line.charAt(i);
            try {
                cn = line.charAt(i + 1);
            }
            catch (StringIndexOutOfBoundsException ex) {
                cn = '\u0000';
            }
            switch (c) {
                case '\"': {
                    if (w.length() == 0 && !fopened) {
                        fopened = true;
                        continue block6;
                    }
                    if (cn == '\"') {
                        w.append(c);
                        ++i;
                        continue block6;
                    }
                    fopened = false;
                    continue block6;
                }
                case ',': {
                    if (fopened) {
                        w.append(c);
                        continue block6;
                    }
                    result.add(w.toString());
                    w.setLength(0);
                    continue block6;
                }
                default: {
                    w.append(c);
                }
            }
        }
        result.add(w.toString());
        return result.toArray(new String[result.size()]);
    }
}

