/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.omegat.core.Core;
import org.omegat.core.glossaries.IGlossary;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.gui.glossary.GlossaryReaderCSV;
import org.omegat.gui.glossary.GlossaryReaderTBX;
import org.omegat.gui.glossary.GlossaryReaderTSV;
import org.omegat.gui.glossary.GlossaryTextArea;
import org.omegat.util.DirectoryMonitor;
import org.omegat.util.Language;
import org.omegat.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlossaryManager
implements DirectoryMonitor.Callback {
    protected DirectoryMonitor monitor;
    private final GlossaryTextArea pane;
    private final Map<String, List<GlossaryEntry>> glossaries = new TreeMap<String, List<GlossaryEntry>>();
    protected final IGlossary[] externalGlossaries;

    public GlossaryManager(GlossaryTextArea pane) {
        this.pane = pane;
        ArrayList<IGlossary> gl = new ArrayList<IGlossary>();
        for (Class<?> glc : PluginUtils.getGlossaryClasses()) {
            try {
                gl.add((IGlossary)glc.newInstance());
            }
            catch (Exception ex) {
                Log.log(ex);
            }
        }
        this.externalGlossaries = gl.toArray(new IGlossary[gl.size()]);
    }

    public void start() {
        File dir = new File(Core.getProject().getProjectProperties().getGlossaryRoot());
        this.monitor = new DirectoryMonitor(dir, this);
        this.monitor.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.monitor.fin();
        GlossaryManager glossaryManager = this;
        synchronized (glossaryManager) {
            this.glossaries.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileChanged(File file) {
        block9: {
            GlossaryManager glossaryManager = this;
            synchronized (glossaryManager) {
                this.glossaries.remove(file.getName());
            }
            if (file.exists()) {
                try {
                    List<GlossaryEntry> entries = this.loadGlossaryFile(file);
                    if (entries == null) break block9;
                    GlossaryManager glossaryManager2 = this;
                    synchronized (glossaryManager2) {
                        this.glossaries.put(file.getName(), entries);
                    }
                }
                catch (Exception ex) {
                    Log.logRB("CT_ERROR_ACCESS_GLOSSARY_DIR", new Object[0]);
                    Log.log(ex);
                }
            }
        }
        this.pane.refresh();
    }

    private List<GlossaryEntry> loadGlossaryFile(File file) throws Exception {
        String fname_lower = file.getName().toLowerCase();
        if (fname_lower.endsWith(".tab")) {
            Log.logRB("CT_LOADING_GLOSSARY", file.getName());
            return GlossaryReaderTSV.read(file);
        }
        if (fname_lower.endsWith(".utf8") || fname_lower.endsWith(".txt")) {
            Log.logRB("CT_LOADING_GLOSSARY", file.getName());
            return GlossaryReaderTSV.read(file);
        }
        if (fname_lower.endsWith(".csv")) {
            Log.logRB("CT_LOADING_GLOSSARY", file.getName());
            return GlossaryReaderCSV.read(file);
        }
        if (fname_lower.endsWith(".tbx")) {
            Log.logRB("CT_LOADING_GLOSSARY", file.getName());
            return GlossaryReaderTBX.read(file);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GlossaryEntry> getGlossaryEntries(String src) {
        ArrayList<GlossaryEntry> result = new ArrayList<GlossaryEntry>();
        GlossaryManager glossaryManager = this;
        synchronized (glossaryManager) {
            for (List<GlossaryEntry> en : this.glossaries.values()) {
                result.addAll(en);
            }
        }
        this.addExternalGlossaryEntries(result, src);
        return result;
    }

    private void addExternalGlossaryEntries(List<GlossaryEntry> result, String src) {
        Language source = Core.getProject().getProjectProperties().getSourceLanguage();
        Language target = Core.getProject().getProjectProperties().getTargetLanguage();
        for (IGlossary gl : this.externalGlossaries) {
            try {
                result.addAll(gl.search(source, target, src));
            }
            catch (Exception ex) {
                Log.log(ex);
            }
        }
    }
}

