/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.filters2;

import gen.core.filters.Filter;
import gen.core.filters.Filters;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.omegat.filters2.IFilter;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.filters2.master.FiltersTableModel;
import org.omegat.gui.filters2.FilterEditor;
import org.omegat.util.OStrings;
import org.openide.awt.Mnemonics;

public class FiltersCustomizer
extends JDialog
implements ListSelectionListener {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    public Filters result;
    private Filters defaultFilters;
    private Filters userFilters;
    private Filters projectFilters;
    private Filters editableFilters;
    private boolean isProjectSpecific;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JTextArea description;
    private JButton editButton;
    private JScrollPane filtersScrollPane;
    private JTable filtersTable;
    private JLabel jLabel1;
    private JButton okButton;
    private JButton optionsButton;
    private JCheckBox projectSpecificCB;
    private JButton toDefaultsButton;
    private int returnStatus = 0;

    public FiltersCustomizer(Frame parent, boolean projectSpecific, Filters defaultFilters, Filters userFilters, Filters projectFilters) {
        super(parent, true);
        this.isProjectSpecific = projectSpecific;
        this.defaultFilters = defaultFilters;
        this.userFilters = userFilters;
        this.projectFilters = projectFilters;
        if (userFilters == null) {
            userFilters = defaultFilters;
        }
        this.editableFilters = this.isProjectSpecific && projectFilters != null ? FilterMaster.cloneConfig(projectFilters) : FilterMaster.cloneConfig(userFilters);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                FiltersCustomizer.this.dispose();
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okButton);
        this.filtersTable.setModel(new FiltersTableModel(this.editableFilters));
        this.filtersTable.getSelectionModel().addListSelectionListener(this);
        if (projectSpecific) {
            this.setTitle(OStrings.getString("FILTERSCUSTOMIZER_TITLE_PROJECTSPECIFIC"));
        } else {
            this.projectSpecificCB.setVisible(false);
        }
        if (projectSpecific && projectFilters == null) {
            this.filtersTable.setEnabled(false);
            this.filtersTable.setFocusable(false);
            this.toDefaultsButton.setEnabled(false);
        } else {
            if (projectSpecific) {
                this.projectSpecificCB.setSelected(true);
            }
            this.filtersTable.setEnabled(true);
            this.filtersTable.setFocusable(true);
            this.toDefaultsButton.setEnabled(true);
        }
        Dimension tableSize = this.filtersTable.getPreferredSize();
        tableSize.height += 70;
        this.filtersScrollPane.setPreferredSize(tableSize);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (lsm.isSelectionEmpty()) {
            this.editButton.setEnabled(false);
            this.optionsButton.setEnabled(false);
        } else {
            this.editButton.setEnabled(true);
            int fIdx = this.filtersTable.getSelectedRow();
            Filter currFilter = this.editableFilters.getFilters().get(fIdx);
            IFilter f = FilterMaster.getFilterInstance(currFilter.getClassName());
            this.optionsButton.setEnabled(f.hasOptions());
        }
    }

    public Filters getResult() {
        return this.result;
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.toDefaultsButton = new JButton();
        this.jLabel1 = new JLabel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.filtersScrollPane = new JScrollPane();
        this.filtersTable = new JTable();
        this.description = new JTextArea();
        this.editButton = new JButton();
        this.optionsButton = new JButton();
        this.projectSpecificCB = new JCheckBox();
        this.setTitle(OStrings.getString("FILTERSCUSTOMIZER_TITLE"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                FiltersCustomizer.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.buttonPanel.setLayout(new FlowLayout(2));
        Mnemonics.setLocalizedText(this.toDefaultsButton, OStrings.getString("BUTTON_TO_DEFAULTS"));
        this.toDefaultsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FiltersCustomizer.this.toDefaultsButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.toDefaultsButton);
        this.jLabel1.setPreferredSize(new Dimension(20, 0));
        this.buttonPanel.add(this.jLabel1);
        Mnemonics.setLocalizedText(this.okButton, OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FiltersCustomizer.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        Mnemonics.setLocalizedText(this.cancelButton, OStrings.getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FiltersCustomizer.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.filtersScrollPane.setFocusable(false);
        this.filtersScrollPane.setViewportView(this.filtersTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.filtersScrollPane, gridBagConstraints);
        this.description.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.description.setEditable(false);
        this.description.setFont(new JLabel().getFont());
        this.description.setLineWrap(true);
        this.description.setText(OStrings.getString("FILTERSCUSTOMIZER_DESCRIPTION"));
        this.description.setWrapStyleWord(true);
        this.description.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.description, gridBagConstraints);
        Mnemonics.setLocalizedText(this.editButton, OStrings.getString("BUTTON_EDIT"));
        this.editButton.setToolTipText(OStrings.getString("FILTERSCUSTOMIZER_BUTTON_EDIT_HINT"));
        this.editButton.setEnabled(false);
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FiltersCustomizer.this.editButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.editButton, gridBagConstraints);
        Mnemonics.setLocalizedText(this.optionsButton, OStrings.getString("FILTERSCUSTOMIZER_BUTTON_OPTIONS"));
        this.optionsButton.setEnabled(false);
        this.optionsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FiltersCustomizer.this.optionsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.optionsButton, gridBagConstraints);
        Mnemonics.setLocalizedText(this.projectSpecificCB, OStrings.getString("FILTERSCUSTOMIZER_CHECKBOX_PROJECTSPECIFIC"));
        this.projectSpecificCB.setHorizontalAlignment(2);
        this.projectSpecificCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FiltersCustomizer.this.projectSpecificCBActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.projectSpecificCB, gridBagConstraints);
        this.pack();
    }

    private void projectSpecificCBActionPerformed(ActionEvent evt) {
        if (this.projectSpecificCB.isSelected()) {
            this.filtersTable.setEnabled(true);
            this.filtersTable.setFocusable(true);
        } else {
            this.filtersTable.setEnabled(false);
            this.filtersTable.setFocusable(false);
        }
    }

    private void optionsButtonActionPerformed(ActionEvent evt) {
        int fIdx = this.filtersTable.getSelectedRow();
        Filter currFilter = this.editableFilters.getFilters().get(fIdx);
        IFilter f = FilterMaster.getFilterInstance(currFilter.getClassName());
        Map<String, String> newConfig = f.changeOptions(this, FilterMaster.forFilter(currFilter.getOption()));
        if (newConfig != null) {
            FilterMaster.setOptions(currFilter, newConfig);
        }
    }

    private void toDefaultsButtonActionPerformed(ActionEvent evt) {
        this.editableFilters = FilterMaster.cloneConfig(this.defaultFilters);
        this.filtersTable.setModel(new FiltersTableModel(this.editableFilters));
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        int row = this.filtersTable.getSelectedRow();
        FilterEditor editor = new FilterEditor((Dialog)this, this.editableFilters.getFilters().get(row));
        editor.setVisible(true);
        if (editor.result != null) {
            this.editableFilters.getFilters().set(row, editor.result);
        }
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.result = this.isProjectSpecific && !this.projectSpecificCB.isSelected() ? null : this.editableFilters;
        this.setVisible(false);
        this.dispose();
    }
}

