/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.exttrans;

import java.awt.Dimension;
import java.util.ArrayList;
import org.omegat.core.Core;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.gui.common.EntryInfoSearchThread;
import org.omegat.gui.common.EntryInfoThreadPane;
import org.omegat.gui.exttrans.IMachineTranslation;
import org.omegat.gui.exttrans.MachineTranslationInfo;
import org.omegat.gui.main.DockableScrollPane;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.gui.AlwaysVisibleCaret;
import org.omegat.util.gui.UIThreadsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MachineTranslateTextArea
extends EntryInfoThreadPane<MachineTranslationInfo> {
    private static final String EXPLANATION = OStrings.getString("GUI_MACHINETRANSLATESWINDOW_explanation");
    protected final IMachineTranslation[] translators;
    protected String displayed;

    public MachineTranslateTextArea() {
        super(true);
        this.setEditable(false);
        AlwaysVisibleCaret.apply(this);
        this.setText(EXPLANATION);
        this.setMinimumSize(new Dimension(100, 50));
        String title = OStrings.getString("GUI_MATCHWINDOW_SUBWINDOWTITLE_MachineTranslate");
        Core.getMainWindow().addDockable(new DockableScrollPane("MACHINE_TRANSLATE", title, this, true));
        ArrayList<IMachineTranslation> tr = new ArrayList<IMachineTranslation>();
        for (Class<?> mtc : PluginUtils.getMachineTranslationClasses()) {
            try {
                tr.add((IMachineTranslation)mtc.newInstance());
            }
            catch (Exception ex) {
                Log.log(ex);
            }
        }
        this.translators = tr.toArray(new IMachineTranslation[tr.size()]);
    }

    public String getDisplayedTranslation() {
        return this.displayed;
    }

    @Override
    protected void onProjectClose() {
        UIThreadsUtil.mustBeSwingThread();
        this.setText(EXPLANATION);
    }

    @Override
    protected void startSearchThread(SourceTextEntry newEntry) {
        UIThreadsUtil.mustBeSwingThread();
        this.setText("");
        this.displayed = null;
        for (IMachineTranslation mt : this.translators) {
            new FindThread(mt, newEntry).start();
        }
    }

    @Override
    protected void setFoundResult(SourceTextEntry se, MachineTranslationInfo data) {
        UIThreadsUtil.mustBeSwingThread();
        if (data != null && data.result != null) {
            if (this.displayed == null) {
                this.displayed = data.result;
            }
            this.setText(this.getText() + data.result + "\n<" + data.translatorName + ">\n\n");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class FindThread
    extends EntryInfoSearchThread<MachineTranslationInfo> {
        private final IMachineTranslation translator;
        private final String src;

        public FindThread(IMachineTranslation translator, SourceTextEntry newEntry) {
            super(MachineTranslateTextArea.this, newEntry);
            this.translator = translator;
            this.src = newEntry.getSrcText();
        }

        @Override
        protected MachineTranslationInfo search() throws Exception {
            Language source = null;
            Language target = null;
            ProjectProperties pp = Core.getProject().getProjectProperties();
            if (pp != null) {
                source = pp.getSourceLanguage();
                target = pp.getTargetLanguage();
            }
            if (source == null || target == null) {
                return null;
            }
            MachineTranslationInfo result = new MachineTranslationInfo();
            result.translatorName = this.translator.getName();
            result.result = this.translator.getTranslation(source, target, this.src);
            return result.result != null ? result : null;
        }
    }
}

