/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor.mark;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import javax.swing.text.JTextComponent;
import org.omegat.gui.editor.mark.SymbolPainter;

public class BidiPainter
extends SymbolPainter {
    protected boolean rtl;
    protected boolean ltr;

    public BidiPainter(Color c, String s) {
        super(c, s);
        if (this.symbol.equals("\u200f") || this.symbol.equals("\u202e") || this.symbol.equals("\u202b")) {
            this.rtl = true;
            this.ltr = false;
        } else if (this.symbol.equals("\u200e") || this.symbol.equals("\u202a") || this.symbol.equals("\u202d")) {
            this.ltr = true;
            this.rtl = false;
        }
    }

    protected void paint(Graphics g, Rectangle rect, JTextComponent c) {
        g.setColor(this.color);
        Polygon p = new Polygon();
        p.addPoint(rect.x, rect.y + rect.height);
        p.addPoint(rect.x, rect.y);
        if (this.rtl) {
            p.addPoint(rect.x - 4, rect.y);
            p.addPoint(rect.x, rect.y + 4);
        } else if (this.ltr) {
            p.addPoint(rect.x + 4, rect.y);
            p.addPoint(rect.x, rect.y + 4);
        } else {
            p.addPoint(rect.x - 2, rect.y);
            p.addPoint(rect.x, rect.y - 4);
            p.addPoint(rect.x + 2, rect.y);
            p.addPoint(rect.x, rect.y);
        }
        g.fillPolygon(p);
    }
}

