/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor.mark;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.Highlighter;
import org.omegat.core.Core;
import org.omegat.gui.editor.mark.IMarker;
import org.omegat.gui.editor.mark.Mark;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMarker
implements IMarker {
    protected Highlighter.HighlightPainter PAINTER;
    protected String toolTip;
    protected Pattern pattern;

    @Override
    public Highlighter.HighlightPainter getPainter() {
        return this.PAINTER;
    }

    protected abstract boolean isEnabled();

    @Override
    public List<Mark> getMarksForEntry(String sourceText, String translationText, boolean isActive) throws Exception {
        Mark m;
        Matcher match;
        ArrayList<Mark> r = new ArrayList<Mark>();
        if (!this.isEnabled()) {
            return r;
        }
        if (isActive || Core.getEditor().getSettings().isDisplaySegmentSources() || translationText == null) {
            match = this.pattern.matcher(sourceText);
            while (match.find()) {
                m = new Mark(Mark.ENTRY_PART.SOURCE, match.start(), match.end());
                m.toolTipText = this.toolTip;
                r.add(m);
            }
        }
        if (translationText != null) {
            match = this.pattern.matcher(translationText);
            while (match.find()) {
                m = new Mark(Mark.ENTRY_PART.TRANSLATION, match.start(), match.end());
                m.toolTipText = this.toolTip;
                r.add(m);
            }
        }
        return r;
    }
}

