/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.io.File;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.gui.editor.EditorController;
import org.omegat.util.FileUtil;
import org.omegat.util.StaticUtils;
import org.omegat.util.gui.UIThreadsUtil;

public class SegmentExportImport {
    static final int WAIT_TIME = 100;
    private final EditorController controller;
    private volatile long exportLastModified = Long.MAX_VALUE;
    private final File importFile;

    public SegmentExportImport(EditorController controller) {
        this.controller = controller;
        this.importFile = new File(StaticUtils.getScriptDir(), "import.txt");
        new Thread(){

            public void run() {
                try {
                    while (true) {
                        if (SegmentExportImport.this.importFile.lastModified() >= SegmentExportImport.this.exportLastModified) {
                            SegmentExportImport.this.importText();
                            continue;
                        }
                        Thread.sleep(100L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }.start();
    }

    public synchronized void exportCurrentSegment(SourceTextEntry ste) {
        this.importFile.delete();
        if (ste == null) {
            this.exportLastModified = Long.MAX_VALUE;
            return;
        }
        String s1 = ste.getSrcText();
        TMXEntry te = Core.getProject().getTranslationInfo(ste);
        String s2 = te.isTranslated() ? te.translation : "";
        File sourceFile = FileUtil.writeScriptFile(s1, "source.txt");
        FileUtil.writeScriptFile(s2, "target.txt");
        this.exportLastModified = sourceFile.lastModified();
    }

    synchronized void importText() {
        if (this.importFile.lastModified() < this.exportLastModified) {
            return;
        }
        this.exportLastModified = this.importFile.lastModified() + 1L;
        final String text = FileUtil.readScriptFile(this.importFile);
        if (text != null) {
            UIThreadsUtil.executeInSwingThread(new Runnable(){

                public void run() {
                    SegmentExportImport.this.controller.replaceEditText(text);
                }
            });
        }
    }
}

