/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Position;
import org.omegat.core.Core;
import org.omegat.core.data.ProjectTMX;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.gui.editor.Document3;
import org.omegat.gui.editor.EditorController;
import org.omegat.gui.editor.EditorSettings;
import org.omegat.gui.editor.EditorUtils;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OConsts;
import org.omegat.util.OStrings;
import org.omegat.util.PatternConsts;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.UIThreadsUtil;

public class SegmentBuilder {
    public static final String SEGMENT_MARK_ATTRIBUTE = "SEGMENT_MARK_ATTRIBUTE";
    public static final String SEGMENT_SPELL_CHECK = "SEGMENT_SPELL_CHECK";
    private static final DecimalFormat NUMBER_FORMAT = new DecimalFormat("0000");
    private static final DateFormat dateFormat = DateFormat.getDateInstance();
    private static final DateFormat timeFormat = DateFormat.getTimeInstance();
    final SourceTextEntry ste;
    final int segmentNumberInProject;
    private long displayVersion;
    private String sourceText;
    private String translationText;
    private boolean active;
    private boolean transExist;
    private boolean noteExist;
    private boolean defaultTranslation;
    private final Document3 doc;
    private final EditorController controller;
    private final EditorSettings settings;
    protected int activeTranslationBeginOffset;
    protected int activeTranslationEndOffset;
    protected Position beginPosP1;
    protected Position endPosM1;
    protected Position posSourceBeg;
    protected Position posTranslationBeg;
    protected int offset;
    protected boolean hasRTL;

    public SegmentBuilder(EditorController controller, Document3 doc, EditorSettings settings, SourceTextEntry ste, int segmentNumberInProject) {
        this.controller = controller;
        this.doc = doc;
        this.settings = settings;
        this.ste = ste;
        this.segmentNumberInProject = segmentNumberInProject;
        this.hasRTL = controller.sourceLangIsRTL || controller.targetLangIsRTL || EditorUtils.localeIsRTL() || controller.currentOrientation != Document3.ORIENTATION.ALL_LTR;
        Map<Language, ProjectTMX> otherLanguageTMs = Core.getProject().getOtherTargetLanguageTMs();
        for (Map.Entry<Language, ProjectTMX> entry : otherLanguageTMs.entrySet()) {
            this.hasRTL = this.hasRTL || EditorUtils.isRTL(entry.getKey().getLanguageCode().toLowerCase());
        }
    }

    public boolean isDefaultTranslation() {
        return this.defaultTranslation;
    }

    public void setDefaultTranslation(boolean defaultTranslation) {
        this.defaultTranslation = defaultTranslation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSegmentElement(boolean isActive) {
        UIThreadsUtil.mustBeSwingThread();
        ++this.displayVersion;
        this.active = isActive;
        this.doc.trustedChangesInProgress = true;
        try {
            try {
                if (this.beginPosP1 != null && this.endPosM1 != null) {
                    int beginOffset = this.beginPosP1.getOffset() - 1;
                    int endOffset = this.endPosM1.getOffset() + 1;
                    this.doc.remove(beginOffset, endOffset - beginOffset);
                    this.offset = beginOffset;
                } else {
                    this.offset = this.doc.getLength();
                }
                TMXEntry trans = Core.getProject().getTranslationInfo(this.ste);
                this.defaultTranslation = trans.defaultTranslation;
                if (!Core.getProject().getProjectProperties().isSupportDefaultTranslations()) {
                    this.defaultTranslation = false;
                }
                this.transExist = trans.isTranslated();
                this.noteExist = trans.hasNote();
                int beginOffset = this.offset;
                if (isActive) {
                    this.createActiveSegmentElement(trans);
                } else {
                    this.createInactiveSegmentElement(trans);
                }
                int endOffset = this.offset;
                this.beginPosP1 = this.doc.createPosition(beginOffset + 1);
                this.endPosM1 = this.doc.createPosition(endOffset - 1);
            }
            catch (BadLocationException ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            this.doc.trustedChangesInProgress = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSegmentSeparator(Document3 doc) {
        doc.trustedChangesInProgress = true;
        try {
            try {
                doc.insertString(doc.getLength(), "\n", null);
            }
            catch (BadLocationException ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            doc.trustedChangesInProgress = false;
        }
    }

    private void createActiveSegmentElement(TMXEntry trans) throws BadLocationException {
        try {
            if (EditorSettings.DISPLAY_MODIFICATION_INFO_ALL.equals(this.settings.getDisplayModificationInfo()) || EditorSettings.DISPLAY_MODIFICATION_INFO_SELECTED.equals(this.settings.getDisplayModificationInfo())) {
                this.addModificationInfoPart(trans);
            }
            int prevOffset = this.offset;
            this.sourceText = this.ste.getSrcText();
            this.addInactiveSegPart(true, this.sourceText);
            Map<Language, ProjectTMX> otherLanguageTMs = Core.getProject().getOtherTargetLanguageTMs();
            for (Map.Entry<Language, ProjectTMX> entry : otherLanguageTMs.entrySet()) {
                TMXEntry altTrans = entry.getValue().getDefaultTranslation(this.sourceText);
                if (altTrans == null || !altTrans.isTranslated()) continue;
                Language language = entry.getKey();
                this.addOtherLanguagePart(altTrans.translation, language);
            }
            this.posSourceBeg = this.doc.createPosition(prevOffset + (this.hasRTL ? 1 : 0));
            this.translationText = trans.isTranslated() ? trans.translation : (!Preferences.isPreference("wf_noSourceText") ? this.ste.getSrcText() : "");
            this.addActiveSegPart(this.translationText);
            this.posTranslationBeg = null;
            this.doc.activeTranslationBeginM1 = this.doc.createPosition(this.activeTranslationBeginOffset - 1);
            this.doc.activeTranslationEndP1 = this.doc.createPosition(this.activeTranslationEndOffset + 1);
        }
        catch (OutOfMemoryError oome) {
            this.doc.remove(0, this.doc.getLength());
            System.gc();
            Object[] args = new Object[]{Runtime.getRuntime().maxMemory() / 1024L / 1024L};
            Log.logErrorRB("OUT_OF_MEMORY", args);
            Log.log(oome);
            Core.getMainWindow().showErrorDialogRB("OUT_OF_MEMORY", args, "TF_ERROR");
            System.exit(0);
        }
    }

    private void createInactiveSegmentElement(TMXEntry trans) throws BadLocationException {
        int prevOffset;
        if (EditorSettings.DISPLAY_MODIFICATION_INFO_ALL.equals(this.settings.getDisplayModificationInfo())) {
            this.addModificationInfoPart(trans);
        }
        this.sourceText = null;
        this.translationText = null;
        if (this.settings.isDisplaySegmentSources()) {
            this.sourceText = this.ste.getSrcText();
        }
        if (trans.isTranslated()) {
            this.translationText = trans.translation;
            if (StringUtil.isEmpty(this.translationText)) {
                this.translationText = OStrings.getString("EMPTY_TRANSLATION");
            }
        } else if (this.sourceText == null) {
            this.sourceText = this.ste.getSrcText();
        }
        if (this.sourceText != null) {
            prevOffset = this.offset;
            this.addInactiveSegPart(true, this.sourceText);
            this.posSourceBeg = this.doc.createPosition(prevOffset + (this.hasRTL ? 1 : 0));
        } else {
            this.posSourceBeg = null;
        }
        if (this.translationText != null) {
            prevOffset = this.offset;
            this.addInactiveSegPart(false, this.translationText);
            this.posTranslationBeg = this.doc.createPosition(prevOffset + (this.hasRTL ? 1 : 0));
        } else {
            this.posTranslationBeg = null;
        }
    }

    public SourceTextEntry getSourceTextEntry() {
        return this.ste;
    }

    public long getDisplayVersion() {
        return this.displayVersion;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getSourceText() {
        return this.sourceText;
    }

    public String getTranslationText() {
        return this.translationText;
    }

    public int getStartSourcePosition() {
        if (this.posSourceBeg != null) {
            return this.posSourceBeg.getOffset();
        }
        return -1;
    }

    public int getStartTranslationPosition() {
        if (this.posTranslationBeg != null) {
            return this.posTranslationBeg.getOffset();
        }
        return -1;
    }

    public int getStartPosition() {
        return this.beginPosP1.getOffset() - 1;
    }

    public int getEndPosition() {
        return this.endPosM1.getOffset() + 1;
    }

    private void setAlignment(int begin, int end, boolean isRTL) {
        boolean rtl = false;
        switch (this.controller.currentOrientation) {
            case ALL_LTR: {
                rtl = false;
                break;
            }
            case ALL_RTL: {
                rtl = true;
                break;
            }
            case DIFFER: {
                rtl = isRTL;
            }
        }
        this.doc.setAlignment(begin, end, rtl);
    }

    public boolean isInsideSegment(int location) {
        return this.beginPosP1.getOffset() - 1 <= location && location < this.endPosM1.getOffset() + 1;
    }

    private void addInactiveSegPart(boolean isSource, String text) throws BadLocationException {
        int prevOffset = this.offset;
        boolean rtl = isSource ? this.controller.sourceLangIsRTL : this.controller.targetLangIsRTL;
        this.insertDirectionEmbedding(rtl);
        this.insertTextWithTags(text, isSource);
        this.insertDirectionEndEmbedding();
        this.insert("\n", null);
        this.setAlignment(prevOffset, this.offset, rtl);
    }

    private void addOtherLanguagePart(String text, Language language) throws BadLocationException {
        int prevOffset = this.offset;
        boolean rtl = EditorUtils.isRTL(language.getLanguageCode());
        this.insertDirectionEmbedding(false);
        AttributeSet normal = this.attrs(true, false, false, false);
        this.insert(language.getLanguage() + ": ", normal);
        this.insertDirectionEndEmbedding();
        this.insertDirectionEmbedding(rtl);
        AttributeSet attrs = this.settings.getOtherLanguageTranslationAttributeSet();
        this.insert(text, attrs);
        this.insertDirectionEndEmbedding();
        this.insert("\n", null);
        this.setAlignment(prevOffset, this.offset, rtl);
    }

    private void addModificationInfoPart(TMXEntry trans) throws BadLocationException {
        String text;
        String author;
        if (!trans.isTranslated()) {
            return;
        }
        String string = author = trans.changer == null ? OStrings.getString("TF_CUR_SEGMENT_UNKNOWN_AUTHOR") : trans.changer;
        if (trans.changeDate != 0L) {
            String template = OStrings.getString("TF_CUR_SEGMENT_AUTHOR_DATE");
            Date changeDate = new Date(trans.changeDate);
            String changeDateString = dateFormat.format(changeDate);
            String changeTimeString = timeFormat.format(changeDate);
            Object[] args = new Object[]{author, changeDateString, changeTimeString};
            text = StaticUtils.format(template, args);
        } else {
            String template = OStrings.getString("TF_CUR_SEGMENT_AUTHOR");
            Object[] args = new Object[]{author};
            text = StaticUtils.format(template, args);
        }
        int prevOffset = this.offset;
        boolean rtl = EditorUtils.localeIsRTL();
        this.insertDirectionEmbedding(rtl);
        AttributeSet attrs = this.settings.getModificationInfoAttributeSet();
        this.insert(text, attrs);
        this.insertDirectionEndEmbedding();
        this.insert("\n", null);
        this.setAlignment(prevOffset, this.offset, rtl);
    }

    private void addActiveSegPart(String text) throws BadLocationException {
        int prevOffset = this.offset;
        boolean rtl = this.controller.targetLangIsRTL;
        this.insertDirectionEmbedding(rtl);
        this.activeTranslationBeginOffset = this.offset;
        this.insertTextWithTags(text, false);
        this.activeTranslationEndOffset = this.offset;
        this.insertDirectionEndEmbedding();
        this.insertDirectionMarker(rtl);
        this.insertDirectionEmbedding(EditorUtils.localeIsRTL());
        AttributeSet attrSegmentMark = this.settings.getSegmentMarkerAttributeSet();
        this.insert(this.createSegmentMarkText(), attrSegmentMark);
        this.insertDirectionEndEmbedding();
        this.insertDirectionMarker(rtl);
        this.insert("\n", null);
        this.setAlignment(prevOffset, this.offset, rtl);
    }

    void createInputAttributes(Element element, MutableAttributeSet set) {
        set.addAttributes(this.attrs(false, false, false, false));
    }

    private void insert(String text, AttributeSet attrs) throws BadLocationException {
        this.doc.insertString(this.offset, text, attrs);
        this.offset += text.length();
    }

    private String createSegmentMarkText() {
        String text = OConsts.segmentMarkerString;
        if ((text = text.trim().replace(' ', '\u00a0')).indexOf("0000") >= 0) {
            text = text.replace("0000", NUMBER_FORMAT.format(this.segmentNumberInProject));
        }
        return text;
    }

    void onActiveEntryChanged() {
        this.translationText = this.doc.extractTranslation();
        ++this.displayVersion;
    }

    public AttributeSet attrs(boolean isSource, boolean isPlaceholder, boolean isRemoveText, boolean isNBSP) {
        return this.settings.getAttributeSet(isSource, isPlaceholder, isRemoveText, this.ste.getDuplicate(), this.active, this.transExist, this.noteExist, isNBSP);
    }

    private void insertTextWithTags(String text, boolean isSource) throws BadLocationException {
        AttributeSet normal = this.attrs(isSource, false, false, false);
        int start = this.offset;
        int end = start + text.length();
        this.insert(text, normal);
        this.formatText(text, start, end, isSource);
    }

    public void formatText(String text, int start, int end, boolean isSource) {
        if (this.controller.currentOrientation != Document3.ORIENTATION.ALL_LTR) {
            return;
        }
        AttributeSet attrNormal = this.attrs(isSource, false, false, false);
        this.doc.setCharacterAttributes(start, end - start, attrNormal, true);
        AttributeSet attrPlaceholder = this.attrs(isSource, true, false, false);
        Pattern placeholderPattern = PatternConsts.getPlaceholderPattern();
        Matcher placeholderMatch = placeholderPattern.matcher(text);
        while (placeholderMatch.find()) {
            this.doc.setCharacterAttributes(start + placeholderMatch.start(), placeholderMatch.end() - placeholderMatch.start(), attrPlaceholder, true);
        }
        AttributeSet attrRemove = this.attrs(isSource, false, true, false);
        Pattern removePattern = PatternConsts.getRemovePattern();
        if (removePattern != null) {
            Matcher removeMatcher = removePattern.matcher(text);
            while (removeMatcher.find()) {
                this.doc.setCharacterAttributes(start + removeMatcher.start(), removeMatcher.end() - removeMatcher.start(), attrRemove, true);
            }
        }
    }

    private void insertDirectionEmbedding(boolean isRTL) throws BadLocationException {
        if (this.hasRTL) {
            this.insert(isRTL ? "\u202b" : "\u202a", null);
        }
    }

    private void insertDirectionEndEmbedding() throws BadLocationException {
        if (this.hasRTL) {
            this.insert("\u202c", null);
        }
    }

    private void insertDirectionMarker(boolean isRTL) throws BadLocationException {
        if (this.hasRTL) {
            this.insert(isRTL ? "\u200f" : "\u200e", null);
        }
    }
}

