/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import org.omegat.core.Core;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.gui.editor.EditorController;
import org.omegat.gui.editor.SegmentBuilder;
import org.omegat.gui.editor.mark.CalcMarkersThread;
import org.omegat.gui.editor.mark.EntryMarks;
import org.omegat.gui.editor.mark.IMarker;
import org.omegat.gui.editor.mark.Mark;
import org.omegat.util.Log;
import org.omegat.util.gui.UIThreadsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkerController {
    private final EditorController ec;
    private MarkInfo[][][] marks;
    private final String[] markerNames;
    private final Highlighter.HighlightPainter[] painters;
    protected final CalcMarkersThread[] markerThreads;
    private final Highlighter highlighter;

    MarkerController(EditorController ec) {
        this.ec = ec;
        this.highlighter = ec.editor.getHighlighter();
        ArrayList<IMarker> ms = new ArrayList<IMarker>();
        for (Class<?> mc : PluginUtils.getMarkerClasses()) {
            try {
                ms.add((IMarker)mc.newInstance());
            }
            catch (Exception ex) {
                Log.logErrorRB(ex, "PLUGIN_MARKER_INITIALIZE", mc.getName());
            }
        }
        for (IMarker marker : Core.getMarkers()) {
            ms.add(marker);
        }
        this.markerThreads = new CalcMarkersThread[ms.size()];
        this.markerNames = new String[ms.size()];
        this.painters = new Highlighter.HighlightPainter[ms.size()];
        for (int i = 0; i < ms.size(); ++i) {
            IMarker m = (IMarker)ms.get(i);
            this.markerNames[i] = m.getClass().getName();
            this.painters[i] = m.getPainter();
            this.markerThreads[i] = new CalcMarkersThread(this, m, i);
            this.markerThreads[i].start();
        }
    }

    int getMarkerIndex(String markerClassName) {
        for (int i = 0; i < this.markerNames.length; ++i) {
            if (!this.markerNames[i].equals(markerClassName)) continue;
            return i;
        }
        return -1;
    }

    void reset(int newEntriesCount) {
        UIThreadsUtil.mustBeSwingThread();
        for (CalcMarkersThread th : this.markerThreads) {
            th.reset();
        }
        this.highlighter.removeAllHighlights();
        this.marks = new MarkInfo[newEntriesCount][][];
        for (int i = 0; i < this.marks.length; ++i) {
            this.marks[i] = new MarkInfo[this.markerNames.length][];
        }
    }

    void resetEntryMarks(int entryIndex) {
        MarkInfo[][] m;
        try {
            m = this.marks[entryIndex];
        }
        catch (IndexOutOfBoundsException ex) {
            return;
        }
        for (int i = 0; i < m.length; ++i) {
            MarkInfo[] me = m[i];
            if (me != null) {
                for (int j = 0; j < me.length; ++j) {
                    this.highlighter.removeHighlight(me[j].underscore);
                }
            }
            this.marks[entryIndex][i] = null;
        }
    }

    public void process(SegmentBuilder[] entryBuilders) {
        for (CalcMarkersThread th : this.markerThreads) {
            th.add(entryBuilders);
        }
    }

    public void process(SegmentBuilder[] entryBuilders, int markerIndex) {
        for (int i = 0; i < this.marks.length; ++i) {
            MarkInfo[] me = this.marks[i][markerIndex];
            if (me != null) {
                for (int j = 0; j < me.length; ++j) {
                    this.highlighter.removeHighlight(me[j].underscore);
                }
            }
            this.marks[i][markerIndex] = null;
        }
        this.markerThreads[markerIndex].add(entryBuilders);
    }

    public void process(int entryIndex, SegmentBuilder entryBuilder) {
        for (CalcMarkersThread th : this.markerThreads) {
            th.add(entryIndex, entryBuilder);
        }
    }

    public String getToolTips(int entryIndex, int pos) {
        if (entryIndex < 0 || entryIndex >= this.marks.length) {
            return null;
        }
        if (this.marks[entryIndex] == null) {
            return null;
        }
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < this.marks[entryIndex].length; ++i) {
            if (this.marks[entryIndex][i] == null) continue;
            for (MarkInfo t : this.marks[entryIndex][i]) {
                if (t == null || t.tooltip == null || t.underscore.getStartOffset() > pos || t.underscore.getEndOffset() < pos) continue;
                if (res.length() > 0) {
                    res.append("<br>");
                }
                res.append(t.tooltip);
            }
        }
        if (res.length() == 0) {
            return null;
        }
        String r = res.toString();
        r = r.replace("<suggestion>", "<b>");
        r = r.replace("</suggestion>", "</b>");
        return "<html>" + r + "</html>";
    }

    public void setEntryMarks(int entryIndex, SegmentBuilder sb, List<Mark> newMarks, int markerIndex) {
        MarkInfo[][] markInfo = this.marks[entryIndex];
        MarkInfo[] me = markInfo[markerIndex];
        if (me != null) {
            for (int j = 0; j < me.length; ++j) {
                this.highlighter.removeHighlight(me[j].underscore);
            }
        }
        this.marks[entryIndex][markerIndex] = null;
        if (newMarks == null || newMarks.isEmpty()) {
            return;
        }
        MarkInfo[] nm = new MarkInfo[newMarks.size()];
        int sourceStartOffset = sb.getStartSourcePosition();
        int translationStartOffset = sb.isActive() ? this.ec.editor.getOmDocument().getTranslationStart() : sb.getStartTranslationPosition();
        for (int i = 0; i < newMarks.size(); ++i) {
            Mark m = newMarks.get(i);
            int startOffset = m.entryPart == Mark.ENTRY_PART.SOURCE ? sourceStartOffset : translationStartOffset;
            try {
                nm[i] = new MarkInfo();
                nm[i].underscore = (Highlighter.Highlight)this.highlighter.addHighlight(startOffset + m.startOffset, startOffset + m.endOffset, this.painters[markerIndex]);
                nm[i].tooltip = m.toolTipText;
                continue;
            }
            catch (BadLocationException ex) {
                Log.log(ex);
            }
        }
        this.marks[entryIndex][markerIndex] = nm;
    }

    public boolean isEntryChanged(EntryMarks ev) {
        SegmentBuilder ssb;
        try {
            ssb = this.ec.m_docSegList[ev.entryIndex];
        }
        catch (Exception e) {
            return true;
        }
        return ssb != ev.builder || ssb.getDisplayVersion() != ev.entryVersion;
    }

    protected static class MarkInfo {
        Highlighter.Highlight underscore;
        String tooltip;

        protected MarkInfo() {
        }
    }
}

