/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.spellchecker.SpellCheckerMarker;
import org.omegat.gui.editor.EditorController;
import org.omegat.gui.editor.EditorUtils;
import org.omegat.gui.editor.IPopupMenuConstructor;
import org.omegat.gui.editor.SegmentBuilder;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.gui.UIThreadsUtil;

public class EditorPopups {
    public static void init(EditorController ec) {
        ec.registerPopupMenuConstructors(100, new SpellCheckerPopup(ec));
        ec.registerPopupMenuConstructors(200, new GoToSegmentPopup(ec));
        ec.registerPopupMenuConstructors(400, new DefaultPopup());
        ec.registerPopupMenuConstructors(500, new EmptyNoneTranslationPopup(ec));
    }

    public static class EmptyNoneTranslationPopup
    implements IPopupMenuConstructor {
        protected final EditorController ec;

        public EmptyNoneTranslationPopup(EditorController ec) {
            this.ec = ec;
        }

        public void addItems(JPopupMenu menu, JTextComponent comp, int mousepos, boolean isInActiveEntry, boolean isInActiveTranslation, SegmentBuilder sb) {
            if (!isInActiveEntry) {
                return;
            }
            JMenuItem itemEmpty = menu.add(OStrings.getString("TRANS_POP_EMPTY_TRANSLATION"));
            itemEmpty.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Core.getEditor().setEmptyTranslation(true);
                    EmptyNoneTranslationPopup.this.setTranslation("");
                    Core.getEditor().replaceEditText("");
                }
            });
            JMenuItem itemRemove = menu.add(OStrings.getString("TRANS_POP_REMOVE_TRANSLATION"));
            itemRemove.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    EmptyNoneTranslationPopup.this.setTranslation(null);
                    Core.getEditor().replaceEditText("");
                }
            });
            menu.addSeparator();
        }

        protected void setTranslation(String v) {
            SourceTextEntry ste = Core.getEditor().getCurrentEntry();
            if (ste == null) {
                return;
            }
            TMXEntry prevTrans = Core.getProject().getTranslationInfo(ste);
            Core.getProject().setTranslation(ste, v, Core.getNotes().getNoteText(), prevTrans.defaultTranslation);
            Core.getEditor().replaceEditText("");
            Core.getEditor().commitAndLeave();
        }
    }

    public static class GoToSegmentPopup
    implements IPopupMenuConstructor {
        protected final EditorController ec;

        public GoToSegmentPopup(EditorController ec) {
            this.ec = ec;
        }

        public void addItems(JPopupMenu menu, final JTextComponent comp, final int mousepos, boolean isInActiveEntry, boolean isInActiveTranslation, SegmentBuilder sb) {
            if (isInActiveEntry) {
                return;
            }
            JMenuItem item = menu.add(OStrings.getString("MW_PROMPT_SEG_NR_TITLE"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    comp.setCaretPosition(mousepos);
                    GoToSegmentPopup.this.ec.goToSegmentAtLocation(comp.getCaretPosition());
                }
            });
            menu.addSeparator();
        }
    }

    public static class DefaultPopup
    implements IPopupMenuConstructor {
        public void addItems(JPopupMenu menu, final JTextComponent comp, int mousepos, boolean isInActiveEntry, boolean isInActiveTranslation, SegmentBuilder sb) {
            String selText = comp.getSelectedText();
            Clipboard omClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable contents = omClipboard.getContents(this);
            boolean cutEnabled = false;
            boolean copyEnabled = false;
            boolean pasteEnabled = false;
            if (selText != null && comp.getSelectionStart() <= mousepos && mousepos <= comp.getSelectionEnd()) {
                if (isInActiveTranslation) {
                    cutEnabled = true;
                }
                copyEnabled = true;
            }
            if (contents != null && isInActiveTranslation) {
                pasteEnabled = true;
            }
            JMenuItem cutContextItem = menu.add(OStrings.getString("CCP_CUT"));
            if (cutEnabled) {
                cutContextItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        comp.cut();
                    }
                });
            } else {
                cutContextItem.setEnabled(false);
            }
            JMenuItem copyContextItem = menu.add(OStrings.getString("CCP_COPY"));
            if (copyEnabled) {
                copyContextItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        comp.copy();
                    }
                });
            } else {
                copyContextItem.setEnabled(false);
            }
            JMenuItem pasteContextItem = menu.add(OStrings.getString("CCP_PASTE"));
            if (pasteEnabled) {
                pasteContextItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        comp.paste();
                    }
                });
            } else {
                pasteContextItem.setEnabled(false);
            }
            menu.addSeparator();
            JMenuItem item = menu.add(OStrings.getString("GUI_GLOSSARYWINDOW_addentry"));
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Core.getGlossary().showCreateGlossaryEntryDialog();
                }
            });
            menu.addSeparator();
        }
    }

    public static class SpellCheckerPopup
    implements IPopupMenuConstructor {
        protected final EditorController ec;

        public SpellCheckerPopup(EditorController ec) {
            this.ec = ec;
        }

        public void addItems(JPopupMenu menu, final JTextComponent comp, int mousepos, boolean isInActiveEntry, boolean isInActiveTranslation, SegmentBuilder sb) {
            if (!this.ec.getSettings().isAutoSpellChecking()) {
                // empty if block
            }
            if (!isInActiveTranslation) {
                return;
            }
            try {
                final int wordStart = EditorUtils.getWordStart(comp, mousepos);
                final int wordEnd = EditorUtils.getWordEnd(comp, mousepos);
                final String word = comp.getText(wordStart, wordEnd - wordStart);
                final AbstractDocument xlDoc = (AbstractDocument)comp.getDocument();
                if (!Core.getSpellChecker().isCorrect(word)) {
                    JMenuItem item;
                    List<String> suggestions = Core.getSpellChecker().suggest(word);
                    for (final String replacement : suggestions) {
                        JMenuItem item2 = menu.add(replacement);
                        item2.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                try {
                                    int pos = comp.getCaretPosition();
                                    xlDoc.replace(wordStart, wordEnd - wordStart, replacement, null);
                                    comp.setCaretPosition(pos);
                                }
                                catch (BadLocationException exc) {
                                    Log.log(exc);
                                }
                            }
                        });
                    }
                    if (suggestions.size() == 0) {
                        item = menu.add(OStrings.getString("SC_NO_SUGGESTIONS"));
                        item.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                            }
                        });
                    }
                    menu.addSeparator();
                    item = menu.add(OStrings.getString("SC_IGNORE_ALL"));
                    item.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            SpellCheckerPopup.this.addIgnoreWord(word, wordStart, false);
                        }
                    });
                    item = menu.add(OStrings.getString("SC_ADD_TO_DICTIONARY"));
                    item.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            SpellCheckerPopup.this.addIgnoreWord(word, wordStart, true);
                        }
                    });
                    menu.addSeparator();
                }
            }
            catch (BadLocationException ex) {
                Log.log(ex);
            }
        }

        protected void addIgnoreWord(String word, int offset, boolean add) {
            UIThreadsUtil.mustBeSwingThread();
            if (add) {
                Core.getSpellChecker().learnWord(word);
            } else {
                Core.getSpellChecker().ignoreWord(word);
            }
            this.ec.remarkOneMarker(SpellCheckerMarker.class.getName());
        }
    }
}

